!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

    program cef_to_rff_CLUPOS

    !--------------------------------------------------------------------0--
    ! Laboratoire de Physique des Plasmas
    ! Program to convert a pos cef file to a rff file.
    ! P. Robert, ScientiDev, Nov. 2020
    ! d'apres fgm_cef_to_rff de Rodrigue Piberne, LPP, 2012 March 26
    !--------------------------------------------------------------------0--

    use type_def_cef
    use rff_param_def
    use rff_data_def

    implicit none

    TYPE(CEF_PARAMETER), dimension(:), allocatable:: cef_param
    type(CEF_META),      dimension(:), allocatable:: cef_entry

    character(len=255)  :: cef_file_name,rff_file_name1,rff_file_name2, Fbasename, &
                           cef_file_basename, dummy_char,toto
    integer             :: cef_file_unit,rff_file_unit1,rff_file_unit2,err,n_variables,n_metadata, &
                           i, dummy_int, j,k,tmp_file_unit,nrec
    character(len=64), dimension(:), allocatable  :: variable_names,metadata_names,&
                                                     data_names
    character(len=1)    :: sat_num
    character(len=8)    :: date
    character(len=10)   :: date_sys,time_sys
    character(len=24)   :: date_temp

    integer             :: n_of_data_in_file
    real(kind=8)        :: px,py,pz, vx,vy,vz
    character(len=120)  :: extract

  print*, '-------------------------------------------------------------'
  print*, 'cef_to_rff_CLUPOS: convert a pos.cef file into a pos_VT.rff file'
  print*, '-------------------------------------------------------------'
  print*

  print*, 'CEF file to read ? (ex: .../data/toto.rff)'
  read(*,'(a)') cef_file_name 
  print*,  trim(cef_file_name)


  cef_file_unit=10

  rff_file_unit1=11
  rff_file_unit2=12

  tmp_file_unit=13

  cef_file_basename = Fbasename(cef_file_name)
  i=len_trim(cef_file_basename)
  cef_file_basename=cef_file_basename(1:i-4)

! rff file name
! ex: CLU3_AUX_VTL2_POS_20010110_000000_20010110_235959.rff

  i=index(cef_file_basename,'_1M_')
  dummy_char=cef_file_basename(2:2)
  rff_file_name1 = 'CLU'//trim(dummy_char)//cef_file_basename(6:10)//&
                   'VTL2_POS_'//trim(cef_file_basename(22:255))//'.rff'
  rff_file_name2 = 'CLU'//trim(dummy_char)//cef_file_basename(6:10)//&
                   'VTL2_VIT_'//trim(cef_file_basename(22:255))//'.rff'

  print*
  print*, 'RFF file name will be :'
  print*, trim(rff_file_name1)//"  for POS"
  print*, trim(rff_file_name2)//"  for VIT"

! parametres par defaut

  call rff_set_default_init

  manda_param%FILE_CLASS='VecTime'
  manda_param%FILE_FORMAT_VERSION = 'Roproc_Format_File V 2.2'
  manda_param%INDEX_LABEL = 'Time'
  manda_param%INDEX_TYPE = 'STR'
  manda_param%INDEX_UNITS = 'ISO_TIME'

  call rff_set_default_INDEX_EXTENSION_DESCRIP
  call rff_set_default_INDEX_DESCRIPTION
  call rff_set_default_DATA_DESCRIPTION
  call rff_set_default_BLOCK_DESCRIPTION

  sat_num=cef_file_basename(2:2)
  date=cef_file_basename(16:24)

    !read cef file
    ! -----------------------------------

    !1) open file
    !    ---------

    write(*,*)
    write(*,*) 'Opening file :',TRIM(cef_file_name)

    OPEN(cef_file_unit,file=trim(cef_file_name),status='old',action='read', iostat=err)

    if(err /= 0) then
        write(*,*) '*** unable to open file : ',TRIM(cef_file_name)
        write(*,*) '    in cef_to_rff, on unit ',cef_file_unit
        write(*,*) '    err= ',err
        write(*,*) '    program aborted !!!'
        stop 'cef_to_rff_CLUPOS.exe           : *** ERROR !! Program aborted !'
    endif

    ! 2) read metadata, variables and parameters
    !    -------------

    write(*,*)
    write(*,*) 'reading metadata...'

    !find the number of metadata
    n_metadata = 0
    call cef_find_n_metadata(cef_file_unit,n_metadata)

    !read metadata
    write(*,*)
    write(*,*) 'reading metadata...'
    allocate(metadata_names(n_metadata))
    metadata_names = 'xxx'
    call cef_R_metadata(cef_file_unit,n_metadata, metadata_names)
    write(*,'(a)') metadata_names

    !read entry
    allocate(cef_entry(n_metadata))
    call cef_R_entry(cef_file_unit,cef_entry,n_metadata, metadata_names)

    !find the number of variables
    write(*,*)
    write(*,*) 'reading variables...'
    n_variables = 0
    call cef_find_n_variables(cef_file_unit,n_variables)

    !read variables
    allocate(variable_names(n_variables))
    variable_names = 'xxx'
    call cef_R_variables(cef_file_unit,n_variables, variable_names)
    write(*,'(a)') variable_names

    !read parameters
    write(*,*)
    write(*,*) 'reading parameters...'
    allocate(cef_param(n_variables))
    call cef_R_parameter(cef_file_unit,cef_param,n_variables,variable_names)

    !find the number of non constant data
    n_of_data_in_file = 0
    do i=1, n_variables
        if (cef_param(i)%DATA == '') then
            n_of_data_in_file = n_of_data_in_file + 1
        endif
    enddo

    !associate corresponding name to these data
    allocate(data_names(n_of_data_in_file))
    j=1
    do i=1, n_variables
        if (cef_param(i)%DATA == '') then
            data_names(j) = variable_names(i)
            j = j+1
        endif
    enddo

  close(cef_file_unit)

! rff parameters
! ---------------

  call date_and_time(date_sys,time_sys)
  date_temp = date_sys(1:4)//"-"//date_sys(5:6)//"-"//date_sys(7:8)//&
  "T"//time_sys(1:2)//":"//time_sys(3:4)//":"//time_sys(5:9)//"Z"

  manda_param%FILE_CREATION_DATE = date_temp
  optio_param%DISCIPLINE_NAME='Space and Magnetospheric Physics'

! recup des parametres via le cef

  do i=1,n_metadata

    if (metadata_names(i) == 'MISSION') then
      call upper_case(cef_entry(i)%entry(1),len_trim(cef_entry(i)%entry(1)))
      manda_param%MISSION_NAME = extract(cef_entry(i)%entry(1))
      manda_param%MISSION_NAME = manda_param%MISSION_NAME(2:len_trim(manda_param%MISSION_NAME)-1)

    endif

    if (metadata_names(i) == 'OBSERVATORY_DESCRIPTION') then
      manda_param%OBSERVATORY_NAME =  extract(cef_entry(i)%entry(1))
      manda_param%OBSERVATORY_NAME = manda_param%OBSERVATORY_NAME(13:17)

      dummy_char =  cef_entry(i)%entry(1)
      dummy_char  = dummy_char(10:10)
      read(dummy_char, *) dummy_int
      manda_param%OBSERVATORY_NUMBER = dummy_int
    endif


    if (metadata_names(i) == 'FILE_TIME_SPAN') then
     dummy_char=cef_entry(i)%entry(1)
     optio_param%TIME_SPAN_FROM=dummy_char(1:24)
     optio_param%TIME_SPAN_TO  =dummy_char(26:50)
    endif

    if (metadata_names(i) == 'INVESTIGATOR_COORDINATES') then
     dummy_char=cef_entry(i)%entry(1)
     k=index(dummy_char,'>')
     optio_param%EXPERIMENT_PI_NAME=dummy_char(2:k-1)
     k=index(dummy_char,'>', back=.true.)
     optio_param%EXPERIMENT_PI_MAIL=trim(dummy_char(k+1:255))
     k=index(optio_param%EXPERIMENT_PI_MAIL,'"')
     optio_param%EXPERIMENT_PI_MAIL=optio_param%EXPERIMENT_PI_MAIL(1:k-1)
    endif

  end do

  manda_param%EXPERIMENT_NAME = 'AUX'
  manda_param%INSTRUMENT_TYPE = "Auxiliary"
  manda_param%INDEX_EXTENSION_LABEL='None'
  manda_param%INDEX_EXTENSION_TYPE='None'
  manda_param%INDEX_EXTENSION_UNITS='None'
  manda_param%INDEX_EXTENSION_FORMAT='None'
  manda_param%INDEX_EXTENSION_LENGTH= 0
  manda_param%INDEX_PROPERTIES= 'Regularly Spaced'
  manda_param%INDEX_DIMENSION= 1
  manda_param%INDEX_FORM= 'Scalar'
  manda_param%INDEX_UNITS= "ISO_TIME"
  manda_param%DATA_TYPE= 'FLT'
  manda_param%DATA_LABEL= "x (GSE) ; y (GSE) ; z (GSE)"
  manda_param%DATA_FORM="Vector"
  manda_param%DATA_COORDINATE_SYSTEM ="GSE"
  manda_param%DATA_REPRESENTATION="xyz Cartesian"
  manda_param%DATA_FILL_VALUE = "-1.e31"
  manda_param%INDEX_FORMAT='(a24)'

!OPTIONAL_PARAMETERS

  optio_param%TIME_RESOLUTION = 60.D0
  const_data%SAMPLE_RATE= 1.D0/optio_param%TIME_RESOLUTION

  write(sat_num,'(i1)') manda_param%OBSERVATORY_NUMBER

  optio_param%MI_DE=6
  optio_param%MISSION_DESCRIPTION(1)="The aim of the Cluster mission is to study small-scale structures "
  optio_param%MISSION_DESCRIPTION(2)="of the magnetosphere and its environment in three dimensions. " 
  optio_param%MISSION_DESCRIPTION(3)="To achieve this, Cluster is constituted of four identical spacecraft  " 
  optio_param%MISSION_DESCRIPTION(4)="that will flight in a tetrahedral configuration." 
  optio_param%MISSION_DESCRIPTION(5)="The separation distances between the spacecraft will be varied between"
  optio_param%MISSION_DESCRIPTION(6)="~40 km and the10000 km, according to key scientific regions."

  optio_param%EX_DE=5
  optio_param%EXPERIMENT_DESCRIPTION(1)= "Auxiliary Data"
  optio_param%EXPERIMENT_DESCRIPTION(2)= "This dataset contains the Cluster 3 geometric position and velocity specified"
  optio_param%EXPERIMENT_DESCRIPTION(3)= "in the GSE coordinate system and provided at 1 minute resolution." 
  optio_param%EXPERIMENT_DESCRIPTION(4)= "The data has been produced by the CAA team using the final reconstructed orbit"
  optio_param%EXPERIMENT_DESCRIPTION(5)= "supplied by ESOC Flight Dynamics in the form of Short Term Orbit Files (STOF)."

! reading data

!  ----------------
!  re-open cef file
!  ----------------

    write(*,*)
    write(*,*) 'Opening file :',TRIM(cef_file_name)

    OPEN(cef_file_unit,file=trim(cef_file_name),status='old',action='read', iostat=err)

    if(err /= 0) then
        write(*,*) '*** unable to open file : ',TRIM(cef_file_name)
        write(*,*) '    in cef_to_rff, on unit ',cef_file_unit
        write(*,*) '    err= ',err
        write(*,*) '    program aborted !!!'
        stop 'cef_to_rff_CLUPOS.exe           : *** ERROR !! Program aborted !'
    endif

   toto=' '
   do while ( toto(1:10) /= 'DATA_UNTIL' )           
      read(cef_file_unit,'(a)') toto
   enddo
  
   read(cef_file_unit,'(a)') toto  
   manda_param%block_first_index=  toto(1:index(toto,"Z"))
   manda_param%block_first_index=manda_param%block_first_index(1:19)//'.000Z'
    
   print*,'write data for RFF files  in a temporary file'

! ............................................
! creation du tmp pour position et vitesse
! ............................................

     OPEN(tmp_file_unit,file='data.tmp',status='new',action='write', iostat=err)  

     if(err /= 0) then
                  write(*,*) '*** unable to open file data.tmp'
                  write(*,*) '    in cef_to_rff_CLUPOS, on unit ',tmp_file_unit
                  write(*,*) '    err= ',err
                  write(*,*) '    program aborted !!!'
          stop 'cef_to_rff_CLUPOS.exe         : *** ERROR !! Program aborted !'
     endif
  
     nrec=0
      
     do while ( toto(1:9) /= '!RECORDS=' ) 
        dummy_char=toto   
        write(tmp_file_unit,'(a)') trim(toto)
        nrec=nrec+1
        read(cef_file_unit,'(a)') toto
     enddo

! .....................
   close(tmp_file_unit)
! .....................

!  ----------------   
   close(cef_file_unit)
!  ----------------


   read(toto(10:255),*) dummy_int
   manda_param%BLOCK_NUMBER=nrec
   
   if (nrec/= dummy_int) then
       print*, '*** nb of records read =',nrec
       print*, '    cef param !RECORDS =',dummy_int
   endif
   
   manda_param%block_last_index=  dummy_char(1:index(dummy_char,"Z"))
   manda_param%block_last_index=manda_param%block_last_index(1:19)//'.000Z'

! ---------------------------------
! create rff file for position only
! ---------------------------------

  open(rff_file_unit1,file = rff_file_name1,action='write')

  manda_param%EXPERIMENT_MODE = 'POS'
  manda_param%MEASUREMENT_TYPE = "Position"
  manda_param%DATA_DIMENSION(1)=3
  manda_param%DATA_UNITS= "km ; km ; km "
  manda_param%DATA_FORMAT='(3(",",F10.2))'


  optio_param%TITLE=trim(manda_param%MISSION_NAME)//'/'// &
                    trim(manda_param%EXPERIMENT_MODE)//'/'// &
                    trim(manda_param%OBSERVATORY_NAME)//' (#'//trim(sat_num)//')'
  optio_param%SUB_TITLE='Position (km) in GSE system' 

  print*, 'write header of ',trim(rff_file_name1)
  call rff_W_metadata(rff_file_unit1,rff_file_name1)
  call rff_W_const_data(rff_file_unit1)
  write(rff_file_unit1,'(80a)') '#',('-',i=1,79)
  write(rff_file_unit1,'(a)')   'START INDEXED_DATA'

  OPEN(tmp_file_unit,file='data.tmp',status='old',action='read', iostat=err)  

  if(err /= 0) then
               write(*,*) '*** unable to open file data.tmp'
               write(*,*) '    in cef_to_rff_CLUPOS, on unit ',tmp_file_unit
               write(*,*) '    err= ',err
               write(*,*) '    program aborted !!!'
       stop 'cef_to_rff_CLUPOS.exe            : *** ERROR !! Program aborted !'
  endif

   do i=1,nrec 
      read(tmp_file_unit,'(a)') toto
      read(toto,*) date_temp,px,py,pz, vx,vy,vz
      date_temp=date_temp(1:19)//'.000Z'
       write(rff_file_unit1,'(a24,3(",",F10.2))') date_temp,px,py,pz
   enddo

  close(tmp_file_unit)

  call rff_W_tail(rff_file_unit1)
  close(rff_file_unit1)
! ---------------------------------


! ---------------------------------
! create rff file for Velocity only
! ---------------------------------

  open(rff_file_unit2,file = rff_file_name2,action='write')

  manda_param%EXPERIMENT_MODE = 'VIT'
  manda_param%MEASUREMENT_TYPE = "Velocity"
  manda_param%DATA_DIMENSION(1)=3
  manda_param%DATA_UNITS= "km/s ; km/s ; km/s "
  manda_param%DATA_FORMAT='(3(",",F8.4))'
  
  
  optio_param%TITLE=trim(manda_param%MISSION_NAME)//'/'// &
                    trim(manda_param%EXPERIMENT_MODE)//'/'// &
                    trim(manda_param%OBSERVATORY_NAME)//' (#'//trim(sat_num)//')'
  optio_param%SUB_TITLE='Velocity (km) in GSE system' 

  print*, 'write header of ',trim(rff_file_name2)
  call rff_W_metadata(rff_file_unit2,rff_file_name2)
  call rff_W_const_data(rff_file_unit2)
  write(rff_file_unit2,'(80a)') '#',('-',i=1,79)
  write(rff_file_unit2,'(a)')   'START INDEXED_DATA'

  OPEN(tmp_file_unit,file='data.tmp',status='old',action='read', iostat=err)  

  if(err /= 0) then
               write(*,*) '*** unable to open file data.tmp'
               write(*,*) '    in cef_to_rff_CLUPOS, on unit ',tmp_file_unit
               write(*,*) '    err= ',err
               write(*,*) '    program aborted !!!'
       stop 'cef_to_rff_CLUPOS.exe            : *** ERROR !! Program aborted !'
  endif

   do i=1,nrec 
      read(tmp_file_unit,'(a)') toto
      read(toto,*) date_temp,px,py,pz, vx,vy,vz
      date_temp=date_temp(1:19)//'.000Z'
      write(rff_file_unit2,'(a24,3(",",F8.4))') date_temp, vx,vy,vz
   enddo


  close(tmp_file_unit)

  call rff_W_tail(rff_file_unit2)
  close(rff_file_unit2)
! ---------------------------------

  print*, 'cef_to_rff_CLUPOS.exe            : NORMAL TERMINATION'
     stop 'cef_to_rff_CLUPOS.exe            : NORMAL TERMINATION'

  end program cef_to_rff_CLUPOS

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
! function extraction de caracter pour eviter les warnings dans 
! l'utilisation de cef_entry(i)%entry(1)
! ex: manda_param%OBSERVATORY_NAME = cef_entry(i)%entry(1)(1:120) marche pas
! P. Robert, Juin 2020
!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  character*120 function extract(string)
  character*(*) string
  character*120 string2
  string2=string(1:120)
  extract=string2
  return
  end
!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
