!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program cef_to_rff_cwf_CLUSTA

!----------------------------------------------------------------------!
! Object: convert a CWF cef file to a VTL2 rff file.
! Author: P. Robert, Nov 2020, d'apres le DWF_cef_to_rff de R. Piberne, LPP, 2011 Nov
!----------------------------------------------------------------------!

  use type_def_cef
  use rff_param_def
  use rff_data_def

  implicit none

  TYPE(CEF_PARAMETER), dimension(:), allocatable:: cef_param
  type(CEF_META), dimension(:), allocatable:: cef_entry

  character(len=255)  :: cef_file_name,rff_file_name, Fbasename, &
                         cef_file_basename, dummy_char, dummy_char2, dummy_char3, &
                         dummy_char4, dummy_char5, dummy_char6, dummy_char7, &
                         dummy_char8, toto,toto2
  character(len=120)  :: block_first_index_NBR,block_first_index_HBR, &
                         block_last_index_NBR,block_last_index_HBR
  integer             :: cef_file_unit,rff_file_unit,err,n_variables,n_metadata, &
                         i, dummy_int, tmp_file_unit1,tmp_file_unit2,nrec_NBR,nrec_HBR,k
  character(len=64), dimension(:), allocatable  :: variable_names,metadata_names
  character(len=1)    :: sat_num
  character(len=4)    :: repere
  character(len=64)    :: date
  character(len=10)   :: date_sys,time_sys
  character(len=24)   :: date_temp
  real                :: dummy_float,x,y,z
  real(kind=8)        :: dummy_double
  integer             :: condition_good

  cef_file_unit=1
  rff_file_unit=2
  tmp_file_unit1=3
  tmp_file_unit2=4

  print*, 'path of cef file ? ex: ../C1_CP_STA_CWF_NBR__20010101_V04.cef'
  read *, cef_file_name
  print*, trim(cef_file_name)
  print*

  cef_file_basename = Fbasename(cef_file_name)

  sat_num=cef_file_basename(2:2)
  repere=cef_file_basename(15:18)
  if(repere(1:4) == 'GSE_') then 
                            repere='GSE '
                            date=cef_file_basename(20:50)
                            else
                            date=cef_file_basename(21:51)
  endif
  
  
  write(*,*) "sat_num=",sat_num
  write(*,*) "repere=",trim(repere)
  write(*,*) "date=",date
  

! -----------------------------------
! 1) open cef file
! -----------------------------------

  write(*,*)
  write(*,*) 'Opening file :',TRIM(cef_file_name)

  OPEN(cef_file_unit,file=trim(cef_file_name),status='old',action='read', iostat=err)

  if(err /= 0) then
               write(*,*) '*** unable to open file : ',TRIM(cef_file_name)
               write(*,*) '    in cef_to_rff, on unit ',cef_file_unit
               write(*,*) '    err= ',err
               write(*,*) '    program aborted !!!'
       stop 'cef_to_rff_cwf_CLUSTA.exe       : *** ERROR !! Program aborted !'
  endif

! -------------------------------------------  
! 2) read metadata, variables and parameters
! -------------------------------------------

  write(*,*)
  write(*,*) 'reading metadata, variables and parameters'

  !find the number of metadata
  n_metadata = 0
  call cef_find_n_metadata(cef_file_unit,n_metadata)
  write(*,*) 'n_metadata=',n_metadata

  !read metadata
  write(*,*)
  write(*,*) 'reading metadata...'
  allocate(metadata_names(n_metadata))
  metadata_names = 'xxx'
  call cef_R_metadata(cef_file_unit,n_metadata, metadata_names)
  do i=1,n_metadata
  write(*,*) metadata_names(i)
  enddo

  !read entry
  allocate(cef_entry(n_metadata))
  call cef_R_entry(cef_file_unit,cef_entry,n_metadata, metadata_names)

  !find the number of variables
  write(*,*)
  write(*,*) 'reading variables...'
  n_variables = 0
  call cef_find_n_variables(cef_file_unit,n_variables)
  write(*,*) 'n_variables=',n_variables

  !read variables
  allocate(variable_names(n_variables))
  variable_names = 'xxx'
  call cef_R_variables(cef_file_unit,n_variables, variable_names)
  do i=1,n_variables
  write(*,*) variable_names(i)
  enddo

  !read parameters
  write(*,*)
  write(*,*) 'reading parameters...'
  allocate(cef_param(n_variables))
  call cef_R_parameter(cef_file_unit,cef_param,n_variables,variable_names)
  do i=1,n_variables
  write(*,*) variable_names(i)
  enddo

  write(*,*) 
  write(*,*) 'create rff meta data'
  write(*,*)

! parametres par defaut

  call rff_set_default_init

  manda_param%FILE_CLASS='VecTime'
  manda_param%FILE_FORMAT_VERSION = 'Roproc_Format_File V 2.2'
  manda_param%INDEX_LABEL = 'Time'
  manda_param%INDEX_TYPE = 'STR'
  manda_param%INDEX_UNITS = 'ISO_TIME'

  call rff_set_default_INDEX_EXTENSION_DESCRIP
  call rff_set_default_INDEX_DESCRIPTION
  call rff_set_default_DATA_DESCRIPTION
  call rff_set_default_BLOCK_DESCRIPTION

  manda_param%FILE_FORMAT_VERSION = 'Roproc_Format_File V 2.2'
  manda_param%INDEX_FORM= 'Scalar'
  manda_param%INDEX_PROPERTIES= 'Regularly Spaced'

  write(*,*) manda_param%FILE_CLASS
  write(*,*) manda_param%FILE_FORMAT_VERSION
  write(*,*) manda_param%INDEX_LABEL
  write(*,*) manda_param%INDEX_TYPE
  write(*,*) manda_param%INDEX_UNITS
  write(*,*) manda_param%FILE_FORMAT_VERSION
  write(*,*) manda_param%INDEX_FORM
  write(*,*) manda_param%INDEX_PROPERTIES

  call date_and_time(date_sys,time_sys)

  date_temp = date_sys(1:4)//"-"//date_sys(5:6)//"-"//date_sys(7:8)//&
              "T"//time_sys(1:2)//":"//time_sys(3:4)//":"//time_sys(5:9)//"Z"

  manda_param%FILE_CREATION_DATE = date_temp
  write(*,*) manda_param%FILE_CREATION_DATE

  do i=1,n_metadata

    if (metadata_names(i) == 'MISSION') then
      call upper_case(cef_entry(i)%entry(1),len_trim(cef_entry(i)%entry(1)))
      toto=cef_entry(i)%entry(1)
      manda_param%MISSION_NAME = toto(1:64)
      manda_param%MISSION_NAME = manda_param%MISSION_NAME(2:len_trim(manda_param%MISSION_NAME)-1)
      write(*,*) manda_param%MISSION_NAME
    endif

    if (metadata_names(i) == 'OBSERVATORY_DESCRIPTION') then
      toto=cef_entry(i)%entry(1)
      manda_param%OBSERVATORY_NAME =  toto(1:64)
      manda_param%OBSERVATORY_NAME = manda_param%OBSERVATORY_NAME(13:17)
      write(*,*) manda_param%OBSERVATORY_NAME
      dummy_char =  cef_entry(i)%entry(1)
      dummy_char  = dummy_char(10:10)
      read(dummy_char, *) dummy_int
      manda_param%OBSERVATORY_NUMBER = dummy_int
      write(*,*) manda_param%OBSERVATORY_NUMBER
    endif

    if (metadata_names(i) == 'INSTRUMENT_NAME') then
      toto=cef_entry(i)%entry(1)
      manda_param%EXPERIMENT_NAME = toto(1:64)
      manda_param%EXPERIMENT_NAME = manda_param%EXPERIMENT_NAME(2:9)
      write(*,*) manda_param%EXPERIMENT_NAME
    endif

    if (metadata_names(i) == 'DATASET_ID') then
      toto=cef_entry(i)%entry(1)
      manda_param%EXPERIMENT_MODE = toto(1:64)
      manda_param%EXPERIMENT_MODE = manda_param%EXPERIMENT_mode(16:18)
      write(*,*) manda_param%EXPERIMENT_MODE
    endif

    if (metadata_names(i) == 'INSTRUMENT_TYPE') then
      toto=cef_entry(i)%entry(1)
      manda_param%INSTRUMENT_TYPE = toto(1:64)
      dummy_char  = manda_param%INSTRUMENT_TYPE
      dummy_char2 = manda_param%INSTRUMENT_TYPE
      dummy_char  = dummy_char(2:7)
      dummy_char2  = dummy_char2(9:12)
      manda_param%INSTRUMENT_TYPE = trim(dummy_char)//' '//trim(dummy_char2)//'s'
      write(*,*) manda_param%INSTRUMENT_TYPE
    endif

    if (metadata_names(i) == 'DATASET_TITLE') then
      toto=cef_entry(i)%entry(1)
      manda_param%MEASUREMENT_TYPE = toto(1:64)
      dummy_char  = manda_param%MEASUREMENT_TYPE
      dummy_char2 = manda_param%MEASUREMENT_TYPE
      dummy_char  = dummy_char(11:24)
      call lower_case(dummy_char, len_trim(dummy_char))
      dummy_char2  = dummy_char2(2:10)
      manda_param%MEASUREMENT_TYPE = 'B-AC '//trim(dummy_char2)//' '//trim(dummy_char)
      write(*,*) manda_param%MEASUREMENT_TYPE
    endif

  end do

  condition_good = 0
  do i=1, n_variables

        if (variable_names(i) == 'Time__C'//sat_num//'_CP_STA_CWF_'//trim(repere)) then

        manda_param%INDEX_FORMAT='(a'//trim(cef_param(i)%SIGNIFICANT_DIGITS)//')'
        write(*,*) manda_param%INDEX_FORMAT

        read(cef_param(i)%SIZES, *) dummy_int
        manda_param%INDEX_DIMENSION= dummy_int
        write(*,*) manda_param%INDEX_DIMENSION

      endif

      if (variable_names(i) == 'Status__C'//sat_num//'_CP_STA_CWF_'//trim(repere)) then

         dummy_char=cef_param(i)%LABLAXIS
         dummy_char=dummy_char(2:7)

         dummy_char3=cef_param(i)%VALUE_TYPE
         if (dummy_char3 == 'CHAR') then
            dummy_char3='STR'
         endif

         dummy_char5=cef_param(i)%UNITS
         if (dummy_char5 == '"unitless"') then
            dummy_char5='None'
         endif

         dummy_char7=cef_param(i)%SIGNIFICANT_DIGITS
         dummy_char7='(a'//trim(dummy_char7)

         condition_good=condition_good+1

      endif

      if (variable_names(i) == 'Phase_Angle__C'//sat_num//'_CP_STA_CWF_'//trim(repere)) then

         dummy_char2=cef_param(i)%LABLAXIS
         dummy_char2=dummy_char2(2:12)

         dummy_char4=cef_param(i)%VALUE_TYPE
         if (dummy_char4 == 'FLOAT') then
            dummy_char4 = 'FLT'
         endif

         dummy_char6=cef_param(i)%UNITS
         dummy_char6=dummy_char6(2:7)

         dummy_char8=cef_param(i)%SIGNIFICANT_DIGITS
         read(dummy_char8,*) dummy_int           ! P.R. March 2008
         dummy_int=dummy_int+1                   ! P.R. March 2008
!!         write(dummy_char8,'(i1)') dummy_int     ! P.R. March 2008
         dummy_char8='f'//trim(dummy_char8)//'.2)'

         condition_good=condition_good+1

      endif

      if (condition_good==2) then
        manda_param%INDEX_EXTENSION_LABEL=trim(dummy_char)//' ; '//trim(dummy_char2)
        manda_param%INDEX_EXTENSION_TYPE=trim(dummy_char3)//' ; '//trim(dummy_char4)
        manda_param%INDEX_EXTENSION_UNITS=trim(dummy_char5)//' ; '//trim(dummy_char6)
!       manda_param%INDEX_EXTENSION_FORMAT=trim(dummy_char7)//',",",'//trim(dummy_char8)
        manda_param%INDEX_EXTENSION_FORMAT='(a14,",",f7.2)'
        manda_param%INDEX_EXTENSION_LENGTH=22 !demander à Patrick comment est obtenu ce chiffre'P.R.: (a14,",",f7.2) 14 +1 +7

        write(*,*) manda_param%INDEX_EXTENSION_LABEL
        write(*,*) manda_param%INDEX_EXTENSION_TYPE
        write(*,*) manda_param%INDEX_EXTENSION_UNITS
        write(*,*) manda_param%INDEX_EXTENSION_FORMAT
        write(*,*) manda_param%INDEX_EXTENSION_LENGTH
        condition_good=0
      endif

      if (variable_names(i) == 'B_vec_xyz_Instrument__C'//sat_num//'_CP_STA_CWF_'//trim(repere)) then
         toto=cef_param(i)%LABEL_1
         manda_param%DATA_LABEL= toto(1:64)
         manda_param%DATA_LABEL=manda_param%DATA_LABEL(2:3)//' ; '//manda_param%DATA_LABEL(7:8)&
                                //' ; '//manda_param%DATA_LABEL(12:13)
        write(*,*) manda_param%DATA_LABEL

         toto=cef_param(i)%VALUE_TYPE
         if (toto == 'FLOAT') then
            toto = 'FLT'
         endif
         manda_param%DATA_TYPE=toto(1:64)
        write(*,*) manda_param%DATA_TYPE

         toto=cef_param(i)%UNITS
         manda_param%DATA_UNITS=toto(1:64)
         manda_param%DATA_UNITS=manda_param%DATA_UNITS(2:3)//' ; '//manda_param%DATA_UNITS(2:3)&
                                                           //' ; '//manda_param%DATA_UNITS(2:3)
        write(*,*) manda_param%DATA_UNITS

         toto=cef_param(i)%PROPERTY
         manda_param%DATA_FORM=toto(1:64)
         manda_param%DATA_FORM=manda_param%DATA_FORM(2:7)
        write(*,*) manda_param%DATA_FORM

         read(cef_param(i)%SIZES, *) dummy_int
         manda_param%DATA_DIMENSION(1)=dummy_int
        write(*,*) manda_param%DATA_DIMENSION

         dummy_char = cef_param(i)%REPRESENTATION_1
         dummy_char = dummy_char(2:2)//dummy_char(6:6)//dummy_char(10:10)//' Cartesian'
         toto=dummy_char
         manda_param%DATA_REPRESENTATION=toto(1:64)
         toto=cef_param(i)%FILLVAL
        write(*,*) manda_param%DATA_REPRESENTATION

         manda_param%DATA_FILL_VALUE = toto(1:64)
        write(*,*) manda_param%DATA_FILL_VALUE
      endif

  enddo


  dummy_char=cef_file_name(11:13)
  if(dummy_char == 'DWF')  manda_param%DATA_FORMAT='(3(I7,1X))'
  if(dummy_char == 'CWF')  manda_param%DATA_FORMAT='(3(E13.6,1X))'
  write(*,*) manda_param%DATA_FORMAT

! pour les despin en ISR2

  if(repere == 'ISR2') then
    do i=1, n_variables
      if (variable_names(i) == 'BDC_vec_xy_Instrument__C'//sat_num//'_CP_STA_CWF_'//trim(repere)) then
        read(cef_param(i)%SIZES, *) dummy_int
        manda_param%DATA_DIMENSION(1)=manda_param%DATA_DIMENSION(1)+dummy_int
        write(*,*) manda_param%DATA_DIMENSION(1)

        manda_param%DATA_LABEL=trim(manda_param%DATA_LABEL)//' ; Dx ; Dy'
        write(*,*) manda_param%DATA_LABEL

        manda_param%DATA_UNITS= trim(manda_param%DATA_UNITS)//' ; '//manda_param%DATA_UNITS(1:2)&
                                                            //' ; '//manda_param%DATA_UNITS(1:2)
        write(*,*) manda_param%DATA_UNITS

        manda_param%DATA_FORMAT='(5(E13.6,1X))'
        write(*,*) manda_param%DATA_FORMAT
      endif
    end do
  endif

  !OPTIONAL_PARAMETERS
  do i=1,n_metadata

! *** BUG dans les CWF CEF - mis en dur plus loin

      ! if (metadata_names(i) == 'TIME_RESOLUTION') then

         ! read(cef_entry(i)%entry(1), *) dummy_double
         ! optio_param%TIME_RESOLUTION=dummy_double
         ! const_data%SAMPLE_RATE=1.D0/dummy_double
        ! write(*,*) optio_param%TIME_RESOLUTION
        ! write(*,*) const_data%SAMPLE_RATE
      ! endif

      if (metadata_names(i) == 'FILE_TIME_SPAN') then

         dummy_char=cef_entry(i)%entry(1)
         optio_param%TIME_SPAN_FROM=dummy_char(1:24)
         optio_param%TIME_SPAN_TO  =dummy_char(26:50)
        write(*,*) optio_param%TIME_SPAN_FROM
        write(*,*) optio_param%TIME_SPAN_TO
      endif

      if (metadata_names(i) == 'EXPERIMENT_KEY_PERSONNEL') then

         dummy_char=cef_entry(i)%entry(1)
         optio_param%EXPERIMENT_PI_NAME=dummy_char(2:13)
        write(*,*) optio_param%EXPERIMENT_PI_NAME
         optio_param%EXPERIMENT_PI_MAIL=dummy_char(25:57)
        write(*,*) optio_param%EXPERIMENT_PI_MAIL
      endif

  enddo

  write(dummy_char, '(i1)') manda_param%OBSERVATORY_NUMBER
  optio_param%TITLE=trim(manda_param%MISSION_NAME)//' / ' //&
                    trim(manda_param%EXPERIMENT_NAME)//' / '//&
                    trim(manda_param%OBSERVATORY_NAME)// ' (#'//&
                    trim(dummy_char)//')'

  !Hard coding for some parameters

  optio_param%SUB_TITLE='Calibrated data (nT) in '//trim(repere)//' system'
  optio_param%DISCIPLINE_NAME='Space and Magnetospheric Physics'


  optio_param%MI_DE=8
  optio_param%MISSION_DESCRIPTION(1)='Cluster is a set of 4 spacecrafts, launched in summer 2000. Salsa & Samba'
  optio_param%MISSION_DESCRIPTION(2)='(C2-C3, FM6-FM7 on July 16, Rumba & Tango (C1-C4, FM5-FM8) on August 9.'
  optio_param%MISSION_DESCRIPTION(3)='The aim of the CLuster mission is to study small-scale structures of the'
  optio_param%MISSION_DESCRIPTION(4)='magnetosphere and its environment in three dimensions.'
  optio_param%MISSION_DESCRIPTION(5)='To achieve this, Cluster is constituted of four identical spacecrafts that'
  optio_param%MISSION_DESCRIPTION(6)='will fly in a tetrahedral configuration. The separation distances'
  optio_param%MISSION_DESCRIPTION(7)='between the spacecrafts will vary from ~40 km to 10,000 km,'
  optio_param%MISSION_DESCRIPTION(8)='according to the key scientific regions.'

  optio_param%EX_DE=13
  optio_param%EXPERIMENT_DESCRIPTION(1)='The Spatio Temporal Analysis Field Fluctuation experiment (STAFF) is a'
  optio_param%EXPERIMENT_DESCRIPTION(2)='Tri-axes search coils magnetometer measuring the 3 components of the'
  optio_param%EXPERIMENT_DESCRIPTION(3)='magnetic field up to 4kHz. The STAFF-SC waveform unit produces waveform'
  optio_param%EXPERIMENT_DESCRIPTION(4)='up to either 10 or 180 Hz, according to telemetry rate.'
  optio_param%EXPERIMENT_DESCRIPTION(5)='In Normal Bit Rate (NBR), the sample frequency is about 25.0 Hz, while it is'
  optio_param%EXPERIMENT_DESCRIPTION(6)='450 Hz in High Bit Rate (HBR). Owing to telemetry limitations, a reduction'
  optio_param%EXPERIMENT_DESCRIPTION(7)='of the dynamic data range from 16 to 12 bits is performed inside DWP.'
  optio_param%EXPERIMENT_DESCRIPTION(8)='The principle is to transmit the full 16-bit word at the beginning of'
  optio_param%EXPERIMENT_DESCRIPTION(9)='each telemetry packet, and later the difference between the successive'
  optio_param%EXPERIMENT_DESCRIPTION(10)='samples, coded on 12 bits. The 4th word of telemetry allows determination'
  optio_param%EXPERIMENT_DESCRIPTION(11)='of the maximum error on each component.'
  optio_param%EXPERIMENT_DESCRIPTION(12)='The data are given in the "SSW6RF" coordinates which means " STAFF Sensors'
  optio_param%EXPERIMENT_DESCRIPTION(13)='WEC 6 Reference Frame " where z is close to the spin axis.'

  optio_param%FI_AN=0

  optio_param%BL_HI=3
  optio_param%HISTORY(1)='N1_TO_RFF V.20120801'
  optio_param%HISTORY(2)='RPC_get_data_CLUSTA_WFL1 RPC_V1p4_Linux_x86_64'
  optio_param%HISTORY(3)='RPC_waveform_to_vectime'
  optio_param%FILE_ANOMALIES='None'

  !CONSTANT DATA

  do i=1,n_metadata

     if (metadata_names(i) == 'FILE_CAVEATS') then
         dummy_char = cef_entry(i)%entry(5)
         const_data%TED_VERSION = dummy_char(13:22)

         dummy_char = cef_entry(i)%entry(6)
         const_data%TCOR_OPTION = dummy_char(14:16)

         dummy_char = cef_entry(i)%entry(14)
         toto=dummy_char(index(dummy_char,":")+1:255)
         toto=toto(1:index(toto,'"')-1)
         read(toto,*) dummy_double
         const_data%SPIN_PERIOD = dummy_double
         
         dummy_char = cef_entry(i)%entry(13)
         toto=dummy_char(index(dummy_char,":")+1:255)
         toto=toto(1:index(toto,'"')-1)
         const_data%CONSTANT_TIME_MEASUREMENT = toto(1:32)
         
         dummy_char = cef_entry(i)%entry(15)
         toto=dummy_char(index(dummy_char,":")+1:255)
         toto=toto(1:index(toto,'"')-1)
         read(toto,*) x,y,z
         const_data%MASS_CENTER_X = x
         const_data%MASS_CENTER_Y = y
         const_data%MASS_CENTER_Z = z
         
         dummy_char = cef_entry(i)%entry(16)
         toto=dummy_char(index(dummy_char,":")+1:255)
         toto=toto(1:index(toto,'"')-1)
         read(toto,*) x,y
         const_data%EULER_ANGLE_FIRST  = x
         const_data%EULER_ANGLE_SECOND = y

         dummy_char = cef_entry(i)%entry(13)
         toto=dummy_char(index(dummy_char,":")+1:255)
         toto=toto(1:index(toto,'"')-1)
         read(toto,*) x,y,z
         const_data%SPIN_GEI_RIGHT_ASCENSION = z
         const_data%SPIN_GEI_DECLINATION = y

         dummy_char = cef_entry(i)%entry(11)
         toto=dummy_char(index(dummy_char,":")+1:255)
         toto=toto(1:index(toto,'"')-1)
         read(toto,*) x
         const_data%FREQUENCY_CUT_OFF = x

    endif


  enddo

  do i=1, n_variables

    if (variable_names(i) == 'Misalignment_Matrix__C'//sat_num//'_CP_STA_CWF_'//trim(repere)) then

      dummy_char = cef_param(i)%DATA
      dummy_int = index(dummy_char,',')
      dummy_char2 = dummy_char(1:dummy_int-1)
      dummy_char = dummy_char(dummy_int+1:255)
      read(dummy_char2, '(f6.4)') dummy_float
      const_data%MISALIGNMENT_MATRIX_L1_C1 = dummy_float
      dummy_int = index(dummy_char,',')
      dummy_char2 = dummy_char(1:dummy_int-1)
      dummy_char = dummy_char(dummy_int+1:255)
      read(dummy_char2, '(f6.4)') dummy_float
      const_data%MISALIGNMENT_MATRIX_L1_C2 = dummy_float
      dummy_int = index(dummy_char,',')
      dummy_char2 = dummy_char(1:dummy_int-1)
      dummy_char = dummy_char(dummy_int+1:255)
      read(dummy_char2, '(f6.4)') dummy_float
      const_data%MISALIGNMENT_MATRIX_L1_C3 = dummy_float
      dummy_int = index(dummy_char,',')
      dummy_char2 = dummy_char(1:dummy_int-1)
      dummy_char = dummy_char(dummy_int+1:255)
      read(dummy_char2, '(f6.4)') dummy_float
      const_data%MISALIGNMENT_MATRIX_L2_C1 = dummy_float
      dummy_int = index(dummy_char,',')
      dummy_char2 = dummy_char(1:dummy_int-1)
      dummy_char = dummy_char(dummy_int+1:255)
      read(dummy_char2, '(f6.4)') dummy_float
      const_data%MISALIGNMENT_MATRIX_L2_C2 = dummy_float
      dummy_int = index(dummy_char,',')
      dummy_char2 = dummy_char(1:dummy_int-1)
      dummy_char = dummy_char(dummy_int+1:255)
      read(dummy_char2, '(f6.4)') dummy_float
      const_data%MISALIGNMENT_MATRIX_L2_C3 = dummy_float
      dummy_int = index(dummy_char,',')
      dummy_char2 = dummy_char(1:dummy_int-1)
      dummy_char = dummy_char(dummy_int+1:255)
      read(dummy_char2, '(f6.4)') dummy_float
      const_data%MISALIGNMENT_MATRIX_L3_C1 = dummy_float
      dummy_int = index(dummy_char,',')
      dummy_char2 = dummy_char(1:dummy_int-1)
      dummy_char = dummy_char(dummy_int+1:255)
      read(dummy_char2, '(f6.4)') dummy_float
      const_data%MISALIGNMENT_MATRIX_L3_C2 = dummy_float
      dummy_char2 = dummy_char(1:255)
      read(dummy_char2, '(f6.4)') dummy_float
      const_data%MISALIGNMENT_MATRIX_L3_C3 = dummy_float

    endif

  enddo

  const_data%FREQUENCY_DETREND=0.
  const_data%CALIB_SHIFT_SIZE=2
  manda_param%DATA_COORDINATE_SYSTEM = trim(repere)

! --------------------------------
! create rff file with only header
! --------------------------------

! on cre 2 RFF, un pour le NBR, l'autre pour le HBR
! si l'un des deux est vide, la procédure RPC_cef_to_rff_cwf_CLUSTA le detruira

! lecture du cef pour first and last block index et number of blocks
! et separation NBR-HBR
! ----------------------

   OPEN(cef_file_unit,file=trim(cef_file_name),status='old',action='read', iostat=err)

  if(err /= 0) then
               write(*,*) '*** unable to open file ', trim(cef_file_name)
               write(*,*) '    in CWF_cef_to_rff, on unit ',cef_file_unit
               write(*,*) '    err= ',err
               write(*,*) '    program aborted !!!'
       stop 'cef_to_rff_cwf_CLUSTA.exe       : *** ERROR !! Program aborted !'
  endif


   toto=' '
   do while ( toto(1:10) /= 'DATA_UNTIL' )           
      read(cef_file_unit,'(a)') toto
   enddo

    
! creation de deux temporaire, NBR et HBR
    
   OPEN(tmp_file_unit1,file='data_NBR.tmp',status='new',action='write', iostat=err)  

  if(err /= 0) then
               write(*,*) '*** unable to open file data_NBR.tmp'
               write(*,*) '    in CWF_cef_to_rff, on unit ',tmp_file_unit1
               write(*,*) '    err= ',err
               write(*,*) '    program aborted !!!'
       stop 'cef_to_rff_cwf_CLUSTA.exe       : *** ERROR !! Program aborted !'
  endif

   OPEN(tmp_file_unit2,file='data_HBR.tmp',status='new',action='write', iostat=err)  

  if(err /= 0) then
               write(*,*) '*** unable to open file data_HBR.tmp'
               write(*,*) '    in CWF_cef_to_rff, on unit ',tmp_file_unit1
               write(*,*) '    err= ',err
               write(*,*) '    program aborted !!!'
       stop 'cef_to_rff_cwf_CLUSTA.exe       : *** ERROR !! Program aborted !'
  endif
   
! remplissage des donnees des 2 tmp

  nrec_NBR=0
  nrec_HBR=0

  do while ( toto2(1:9) /= '!RECORDS=' ) 
  read(cef_file_unit,'(a)') toto2
  toto=toto2(29:255)
  k=index(toto,',')
  if(k == 0) exit
  toto=toto(1:k-1)
  read(toto,*) x
  if(x.gt.0.03 .and. x.lt. 0.05) then
                                 ! le record est en NBR
                                 write(tmp_file_unit1,'(2a)') toto2(1:28),trim(toto2(29+k:255))
                                 nrec_NBR=nrec_NBR +1
                                 if(nrec_NBR == 1) block_first_index_NBR=  toto2(1:index(toto2,"Z"))
                                 block_last_index_NBR= toto2(1:index(toto2,"Z"))
                                 else
                                 ! HBR
                                 write(tmp_file_unit2,'(2a)') toto2(1:28),trim(toto2(29+k:255))
                                 nrec_HBR=nrec_HBR +1
                                 if(nrec_HBR == 1) block_first_index_HBR=  toto2(1:index(toto2,"Z"))
                                 block_last_index_HBR= toto2(1:index(toto2,"Z"))
  endif
  enddo

   close(tmp_file_unit1)
   close(tmp_file_unit2)
   close(cef_file_unit)

   
! creation des headers des 2 rff

! 1) NBR

  rff_file_name=trim("CLU"//sat_num//"_STASC_VTL2_NBR_"//trim(repere)//"_"//date)//".rff"
  write(*,*) 'rff_file_name_NBR=',rff_file_name
  
  const_data%CALIB_KERNEL_SIZE=1024
  manda_param%BLOCK_NUMBER=nrec_NBR
  manda_param%block_first_index=block_first_index_NBR
  manda_param%block_last_index =block_last_index_NBR
  manda_param%EXPERIMENT_MODE ='NBR'

! BUG dans les CEF CWF
  optio_param%TIME_RESOLUTION=3.99997333D-02
  const_data%SAMPLE_RATE=1.D0/3.99997333D-02  
  const_data%FREQUENCY_FILTER_MIN=const_data%FREQUENCY_CUT_OFF
  const_data%FREQUENCY_FILTER_MAX=real(const_data%SAMPLE_RATE)/2.


  open(rff_file_unit,file = rff_file_name,action='write')
  print*, 'write header of ',trim(rff_file_name)

  call rff_W_metadata(rff_file_unit,rff_file_name)
  call rff_W_const_data(rff_file_unit)
  write(rff_file_unit,'(80a)') '#',('-',i=1,79)
  write(rff_file_unit,'(a)')   'START INDEXED_DATA'
  close(rff_file_unit)

! 1) HBR

  rff_file_name=trim("CLU"//sat_num//"_STASC_VTL2_HBR_"//trim(repere)//"_"//date)//".rff"
  write(*,*) 'rff_file_name_HBR=',rff_file_name
  
  const_data%CALIB_KERNEL_SIZE=4096
  manda_param%BLOCK_NUMBER=nrec_HBR
  manda_param%block_first_index=block_first_index_HBR
  manda_param%block_last_index =block_last_index_HBR
  manda_param%EXPERIMENT_MODE ='HBR'

! BUG dans les CEF CWF
  optio_param%TIME_RESOLUTION=0.22222074D-02
  const_data%SAMPLE_RATE=1.D0/0.22222074D-02
  const_data%FREQUENCY_FILTER_MIN=const_data%FREQUENCY_CUT_OFF
  const_data%FREQUENCY_FILTER_MAX=real(const_data%SAMPLE_RATE)/2.

  open(rff_file_unit,file = rff_file_name,action='write')
  print*, 'write header of ',trim(rff_file_name)

  call rff_W_metadata(rff_file_unit,rff_file_name)
  call rff_W_const_data(rff_file_unit)
  write(rff_file_unit,'(80a)') '#',('-',i=1,79)
  write(rff_file_unit,'(a)')   'START INDEXED_DATA'
  close(rff_file_unit)

  print*, 'cef_to_rff_cwf_CLUSTA.exe        : NORMAL TERMINATION'
     stop 'cef_to_rff_cwf_CLUSTA.exe        : NORMAL TERMINATION'
  end program cef_to_rff_cwf_CLUSTA

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
! function extraction de caracter pour eviter les warnings dans 
! l'utilisation de cef_entry(i)%entry(1)
! ex: manda_param%OBSERVATORY_NAME = cef_entry(i)%entry(1)(1:120) marche pas
! P. Robert, Juin 2020
!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  character*120 function extract(string)
  character*(*) string
  character*120 string2
  string2=string(1:120)
  extract=string2
  return
  end

