!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program change_coordinate_system

!----------------------------------------------------------------------!
! Object: extract a time period into a WF or VT RFF file
! Author: P. Robert , LPP, 2011 May 27
!----------------------------------------------------------------------!

  use rff_param_def
  use rff_data_def
  use String_Functions

  implicit none

  character(len=255) :: file1, file2,label,units,buf
  character(len=27)  :: credate
  integer            :: iyear,imon,iday,ih,im,is,ims,imc
  integer            :: i,nbvec
  real               :: Ux,Uy,Uz, rr,rla,rlon,pp,pisd,rm
  character(len=6)   :: subname
  character(len=3)   :: allowed(7),rep1,rep2

  data allowed / 'geo','gei','gsq','gse','gsm','sma','mag'/

  print*, '------------------------------------------------------------'
  print*, 'change_coordinate_system : read a RFF vectime file'
  print*, 'and change_coordinate_system system'
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF file to read ? (ex: .../data/toto.rff)'
  read(*,'(a)') file1
  print*, trim(file1)

  print*, 'new coordinate system ? (ex: gse)'
  read(*,'(a)') rep2
  print*, rep2

  print*, 'RFF file to create ? (ex: ./toto_gse.rff)'
  read(*,'(a)') file2
  print*, trim(file2)


! read  RFF file
! --------------

! 1 file to read 
! 2 file to create with new system

  call rff_R_file(1,file1)

  IF(manda_param%FILE_CLASS /= 'VecTime') THEN
      write(*,*) '*** error, RFF file is not a VecTime Class'
      write(*,*) 'manda_param%FILE_CLASS=', manda_param%FILE_CLASS
      write(*,*) '    program aborted'
      stop 'change_coordinate_system.exe    : *** ERROR !! Program aborted !'
  ENDIF

  buf=manda_param%DATA_COORDINATE_SYSTEM
  rep1=buf(1:3)

  if (rep1 == rep2) then
                write(*,*) '*** error, input file is already in',rep1
                write(*,*) '    program aborted'
  stop 'change_coordinate_system.exe    : *** ERROR !! Program aborted !'
  endif

! *** conversion eventuelle en minuscule des noms des reperes

  rep1=Lower(rep1)
  rep2=Lower(rep2)


  print*, 'input  coordinate system :', rep1

  call test(rep1,allowed)
  call test(rep2,allowed)

! change data to new coordinate system
! ------------------------------------
 
  nbvec=manda_param%BLOCK_NUMBER
  label=manda_param%DATA_LABEL
  units=manda_param%DATA_UNITS

  print*
  print*, 'label=',trim(label)
  print*, 'units=',trim(units)

  IF(TRIM(label) == 'Latitude ; Longitude ; Distance' .OR. &
     TRIM(units) == 'degree ; degree ; km') THEN
      print*
      print*, 'conversion spherical position to cartesian one'
      pisd=acos(-1.)/180.

    manda_param%DATA_LABEL='Px ; Py ; Pz'
    manda_param%DATA_UNITS='km ; km ; km'
    manda_param%DATA_FORMAT='(3E13.5)'
    manda_param%MEASUREMENT_TYPE='Positions'
    optio_param%SUB_TITLE='Px,Py,Pz in '//rep2//' (Km)'


  ENDIF

  subname=rep1//rep2
  print*,'subname=',subname

  DO i=1,nbvec

      call decode_datiso(data_index(i),iyear,imon,iday,ih,im,is,ims,imc)
      if(i.lt.10) then
                  print*
                  print*,'iyear,imon,iday,ih,im,is=',iyear,imon,iday,ih,im,is
      endif

! **  initialisation des matrices

      call cp_time_param(iyear,imon,iday,ih,im,is)

! **  tranformation dans le repere souhaite

! *   transformations possibles: geo gei gsq gse gsm sma mag
!     toutes les combinaisons sont:

!     geogei geogsq geogse geogsm geosma geomag
!     geigeo gsqgeo gsegeo gsmgeo smageo maggeo

!     geigsq geigse geigsm geisma geimag
!     gsqgei gsegei gsmgei smagei maggei

!     gsqgse gsqgsm gsqsma gsqmag
!     gsegsq gsmgsq smagsq maggsq

!     gsegsm gsesma gsemag
!     gsmgse smagse maggse

!     gsmsma gsmmag
!     smagsm maggsm

!     smmag
!     magsma

! test vecteur nul ou trop grand

    rm=sqrt(R_data_vector(1,i)**2 +R_data_vector(2,i)**2 +R_data_vector(3,i)**2)
    if(rm < 1.e-30) then
       R_data_vector(1,i)=0.
       R_data_vector(2,i)=0.
       R_data_vector(3,i)=0.
       cycle
    endif

    if(rm > 1.e30) then
       R_data_vector(1,i)=1.e30
       R_data_vector(2,i)=1.e30
       R_data_vector(3,i)=1.e30
       cycle
    endif

    if(allocated(phase)) then
   !    if(phase(i) < 1.e-30) phase(i)=0.
   !    if(phase(i) > 360.  ) phase(i)=360.
 print*, 'phase=',phase(i)
    endif

! conversion en cartesien si donnée en lat,lon,dist

    IF(TRIM(label) == 'Latitude ; Longitude ; Distance' .OR. &
       TRIM(units) == 'degree ; degree ; km') THEN
        rla=R_data_vector(1,i)
        rlon=R_data_vector(2,i)
        rr=R_data_vector(3,i)

        pp=rr*cos(rla*pisd)
        Ux=pp*cos(rlon*pisd)
        Uy=pp*sin(rlon*pisd)
        Uz=rr*sin(rla*pisd)

        if(i.lt.10) then
           print*,'lat,long,r=',rla,rlon,rr
           print*,'Ux,Uy,Uz=',Ux,Uy,Uz
        endif

      ELSE
        Ux=R_data_vector(1,i)
        Uy=R_data_vector(2,i)
        Uz=R_data_vector(3,i)
    ENDIF

! * les if de la mort:...

      if(subname.eq.'geogei') then
         call t_geo_to_gei(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'geogsq') then
         call t_geo_to_gseq(Ux,Uy,Uz,R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'geogse') then
         call t_geo_to_gse(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'geogsm') then
         call t_geo_to_gsm(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'geosma') then
         call t_geo_to_sm(Ux,Uy,Uz,  R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'geomag') then
         call t_geo_to_mag(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'geigeo') then
         call t_gei_to_geo(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'gsqgeo') then
         call t_gseq_to_geo(Ux,Uy,Uz,R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'gsegeo') then
         call t_gse_to_geo(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'gsmgeo') then
         call t_gsm_to_geo(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'smageo') then
         call t_sm_to_geo(Ux,Uy,Uz,  R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'maggeo') then
         call t_mag_to_geo(Ux,Uy,Uz ,R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'geigsq') then
         call t_gei_to_gseq(Ux,Uy,Uz,R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'geigse') then
         call t_gei_to_gse(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'geigsm') then
         call t_gei_to_gsm(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'geisma') then
         call t_gei_to_sm(Ux,Uy,Uz,  R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'geimag') then
         call t_gei_to_mag(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'gsqgei') then
         call t_gseq_to_gei(Ux,Uy,Uz,R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'gsegei') then
         call t_gse_to_gei(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'gsmgei') then
         call t_gsm_to_gei(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'smagei') then
         call t_sm_to_gei(Ux,Uy,Uz,  R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'maggei') then
         call t_mag_to_gei(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'gsqgse') then
         call t_gseq_to_gse(Ux,Uy,Uz,R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'gsqgsm') then
         call t_gseq_to_gsm(Ux,Uy,Uz,R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'gsqsma') then
         call t_gsq_to_sm(Ux,Uy,Uz,  R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'gsqmag') then
         call t_gsq_to_mag(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'gsegsq') then
         call t_gse_to_gseq(Ux,Uy,Uz,R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'gsmgsq') then
         call t_gsm_to_gseq(Ux,Uy,Uz,R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'smagsq') then
         call t_sm_to_gsq(Ux,Uy,Uz,  R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'maggsq') then
         call t_mag_to_gsq(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'gsegsm') then
         call t_gse_to_gsm(Ux,Uy,Uz,R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'gsesma') then
         call t_gse_to_sm(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'gsemag') then
         call t_gse_to_mag(Ux,Uy,Uz,R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'gsmgse') then
         call t_gsm_to_gse(Ux,Uy,Uz,R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'smagse') then
         call t_sm_to_gse(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'maggse') then
         call t_mg_to_gse(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'gsmsma') then
         call t_gsm_to_sm(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'gsmmag') then
         call t_gsm_to_mag(Ux,Uy,Uz,R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'smagsm') then
         call t_sm_to_gsm(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'maggsm') then
         call t_mag_to_gsm(Ux,Uy,Uz,R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'smamag') then
         call t_sm_to_mag(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

      if(subname.eq.'magsma') then
         call t_mag_to_sm(Ux,Uy,Uz, R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i))
         cycle
      endif

  ENDDO

  do i=1,10
    print*, 'xyz ',rep2,' =',data_index(i),R_data_vector(1,i),R_data_vector(2,i),R_data_vector(3,i)
  enddo

! new mandatory parameters
! ------------------------

  manda_param%DATA_COORDINATE_SYSTEM=trim(Upper(rep2))

  write(*,*) 'new coordinate system=',manda_param%DATA_COORDINATE_SYSTEM

! create new vectime rff file
! ---------------------------

  call gdatiso(credate)
  call rff_update_history(credate,'change_coordinate_system')

 ! call rff_W_file(2,file2)

  call rff_W_metadata(2,file2)
  call rff_W_const_data(2)
  call rff_W_indexed_data(2)



  call rff_W_tail(2)

  print*, ('-',i=1,72)

  print*, "change_coordinate_system.exe     : NORMAL TERMINATION"
     stop "change_coordinate_system.exe     : NORMAL TERMINATION"

  end



!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX!
!
! EXTERNAL SUBROUTINES
!
!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX!
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine test(rep,allowed)

      character*3 rep,allowed(7)

      do i=1,7
      if(rep.eq.allowed(i)) return
      enddo

      print*, '*** ',rep,' is not allowed'
      print 100, 'allowed coordinates are ', allowed
      stop '   program aborted'

  100 format(a,/,7a5)

      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine t_sm_to_gse(x1,y1,z1,x2,y2,z2)

      call t_sm_to_gsm(x1,y1,z1,x3,y3,z3)
      call t_gsm_to_gse(x3,y3,z3,x2,y2,z2)

      return
      END
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine t_gse_to_sm(x1,y1,z1,x2,y2,z2)

      call t_gse_to_gsm(x1,y1,z1,x3,y3,z3)
      call t_gsm_to_sm(x3,y3,z3,x2,y2,z2)

      return
      END
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine t_mg_to_gse(x1,y1,z1,x2,y2,z2)

      call t_mag_to_sm(x1,y1,z1,x3,y3,z3)
      call t_sm_to_gse(x3,y3,z3,x2,y2,z2)

      return
      END
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine t_gse_to_mag(x1,y1,z1,x2,y2,z2)

      call t_gse_to_sm(x1,y1,z1,x3,y3,z3)
      call t_sm_to_mag(x3,y3,z3,x2,y2,z2)

      return
      END
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine t_sm_to_gsq(x1,y1,z1,x2,y2,z2)

      call t_sm_to_gsm(x1,y1,z1,x3,y3,z3)
      call t_gsm_to_gseq(x3,y3,z3,x2,y2,z2)

      return
      END
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine t_gsq_to_sm(x1,y1,z1,x2,y2,z2)

      call t_gseq_to_gsm(x1,y1,z1,x3,y3,z3)
      call t_gsm_to_sm(x3,y3,z3,x2,y2,z2)

      return
      END
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine t_mag_to_gsq(x1,y1,z1,x2,y2,z2)

      call t_mag_to_sm(x1,y1,z1,x3,y3,z3)
      call t_sm_to_gsq(x3,y3,z3,x2,y2,z2)

      return
      END
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine t_gsq_to_mag(x1,y1,z1,x2,y2,z2)

      call t_gsq_to_sm(x1,y1,z1,x3,y3,z3)
      call t_sm_to_mag(x3,y3,z3,x2,y2,z2)

      return
      END
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cchalen_(chast,nbcha)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_character_length without end blanks
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, PatCie, 1992
!     ---------------------------------------------------------------+--
!
      character*(*) chast
!
!     calcule la longueur utile d'une chaine de caracteres
!     les blancs de fin sont ignores
!
!
      nbc=len(chast)
      if(nbc.gt.255) then
                     print*, '***nbc=',nbc, ' > 255'
                     print*, '   program aborted'
                     stop '*** program aborted'
                     endif
!
!
      do 10 i=1,nbc
      ii=nbc-i+1
      if(chast(ii:ii).ne.' ') go to 12
   10 continue
      ii=0
   12 continue
!
      nbcha=ii
!
      return
      END
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
