!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program clean_rff

!----------------------------------------------------------------------!
! Object: Read & clean a RFF WaveForm or VecTime files
! Author: P. Robert , LPP, 2011 Mar 07
!----------------------------------------------------------------------!
  use rff_param_def
  use rff_data_def

  implicit none

  character(len=255) :: file, file_c,Fbasename
  character(len= 32) :: credate
  integer            :: nc,i

  print*, '------------------------------------------------------------'
  print*, 'clean_rff : read a RFF waveform or vectime file'
  print*, 'and create the same, "cleaned"'
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF waveform file to read ? (ex: .../data/toto.rff)'
  read(*,'(a)') file
  print*, trim(file)

! read  RFF file
! --------------

  call rff_R_file(1,file)

! Write RFF file
! --------------

  file_c=TRIM(Fbasename(file))

  nc=LEN_TRIM(file_c)
  file_c=file_c(1:nc-4)//'_clean.rff'

  write(*,*) ('-',i=1,72)
  write(*,*) 'Cleaned rff file will be : ',TRIM(file_c)

  call gdatiso(credate)
  call rff_update_history(credate,'RPC_clean_rff')
  call rff_W_file(2,file_c)

  write(*,*) ('-',i=1,72)

  print*, "clean_rff.exe                    : NORMAL TERMINATION"
     stop "clean_rff.exe                    : NORMAL TERMINATION"
  end

!XXXXXXXX0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
