      program co_IGRF_field

      double precision year,rr,tetd,phid,BBx,BBy,BBz,BB0
      character*1 c

! ----------------------------------------------------------------------
! *   Class  : basic compute modules of RPC Software
! *   Object : compute_IGRF magnetic field from the 13th generation IGRF
!              as agreed in December 2019 by IAGA Working Group V-MOD
! *   Author : P. Robert, ScientiDev, Nov 2021 (only this routine)
!            : Susan Macmillan, August 2003 (for IGRF 9th generation)
!            : William Brown, December 2019, February 2020.
! ----------------------------------------------------------------------


   10 continue

      call read_date(iyear,imon,iday,nday,ndayiny)
      call read_coordinate(x,y,z,r,tet,phi)
      
      rlat=90.-tet
      rlon=phi

      year=dble(iyear)+dble(nday)/dble(ndayiny)

      rr  =dble(r)
      tetd=dble(tet)
      phid=dble(phi)

      call co_igrf(year,rr,tetd,phid,BBx,BBy,BBz,BB0)

      Bx=real(BBx)
      By=real(BBy)
      Bz=real(BBz)
      B0=real(BB0)

      call t_car_to_sph(Bx,By,Bz,B02,Btet,Bphi)

      pisd=3.14159/180.
      Btet=Btet/pisd
      Bphi=Bphi/pisd


      print*,'-----------------------------------------------------------------------'
      print 100, 'year','mon','day','Year','R','rlat','rlon','B_North','B_Est','B_Vert.','B0','Btet','Bphi'
      print 200, iyear,imon,iday,year,rr,rlat,rlon,Bx,By,Bz,B0,Btet,Bphi
      print*,'-----------------------------------------------------------------------'
      
      print*,'another one? (y/n)'
      read(*,'(a)') c
      if(c=='y') go to 10

  100 format(a4,'-',a2  ,'-',a2  ,2x,a8  ,a9  ,a8  ,a7  ,2x,4a10  ,a8  ,a7  )
  200 format(i4,'-',i2.2,'-',i2.2,2x,f8.2,f9.3,f8.2,f7.2,2x,4f10.2,f8.2,f7.2)

      stop
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine read_date(iyear,imonth,iday,nday,ndayiny)
!
! ----------------------------------------------------------------------
! *   Class  : read modules of Rocotlib Software
! *   Object : read_date from input and check validity
! *   Author : P. Robert, CRPE, 1992, rev november 2021
!
! *   Comment: test if year is gt 1900
! *            test if imonth is not greater than 12
!              test if iday is not greather than lengh of the month,
!                        takink into account the leap years.
!               print error if date is not valid, and ask again
!
! *   Input  : iyear,imonth,iday given in standard input
! *   Output : iyear,imonth,iday
! ----------------------------------------------------------------------
!
!
      dimension month(12)
      data month/31,28,31,30,31,30,31,31,30,31,30,31/
      data ily /-1/
!
      print*
      print*, 'READ DATE (0 0 0 to finish)'
   10 continue
      print 100, ' iyear,imonth,iday ? (1900 < iyear < 2030)'
      read *,      iyear,imonth,iday
      if(iyear==0) stop

      print 110,   iyear,imonth,iday
!
  100 format(a)
  110 format(1x,i4,1x,i2,1x,i2)
!
      if(iyear.lt.1900) then
         print*, '*** Rocotlib/r_date: iyear must be greater than 1900'
         print*, '                     again ...'
                        go to 10
                        endif
!
      call cp_leap_year(iyear,ily)
!
!
      if(ily.eq.1) then
                   month(2)=29
                   ndayiny=366
                   else
                   month(2)=28
                   ndayiny=365
                   endif
!
      if(imonth.lt.1.or.imonth.gt.12) then
          print*, '*** Rocotlib/r_date: imonth must be between 1 or 12 '
          print*, '                     again...'
                     go to 10
                                      endif
!
      if(iday.gt.month(imonth)) then
                     print*, '*** Rocotlib/r_date: this month has only',&
     &                            month(imonth),'days'
                     print*, '                     again...'
                go to 10
                                endif

      nday=0

      do i=1,imonth-1
         nday=nday+month(i)
      enddo

      nday=nday+iday

      return
      END
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine read_coordinate(x,y,z,r,tet,phi)
!
! ----------------------------------------------------------------------
! *   Class  : read modules of Rocotlib Software
! *   Object : read coordinate values from input
! *   Author : P. Robert, CRPE, 2002
!
! *   Comment: read cs and x,y,z cartesian  or spherical coordinates
! *            print error if cs is not valid, and ask again
!
! *   Input  : cs (c or s) and x,y,z on standard input
! *   Output : cs and x,y,z always in cartesian coordinates
! ----------------------------------------------------------------------
!
      character*1 cs
!
!
      pisd=acos(-1.)/180.
!
      print*
      print*,'READ INPUT POINT COORDINATES'
   10 continue
!
      print 100, 'input coordinates: cartesian (c) or spherical (s)'
      read *, cs
      print 100, cs
!
      if(cs.ne.'s'.and.cs.ne.'c') then
                                  print*, 'only c or s'
                                  print*, 'again...'
                                  go to 10
                                  endif
      if(cs.eq.'s') then
                    print 100, 'R,tet, phi (RE,deg.) ?'
                    read *,  r,tet, phi
                    print 110,  r,tet, phi
!
                    tetr=tet*pisd
                    phir=phi*pisd
                    call t_sph_to_car(r,tetr,phir,x,y,z)
                    print 120, 'then x,y,z = ',x,y,z,' (RE)'
!
                    else
                    print*, 'x,y,z ? (RE) '
                    read *,  x,y,z
                    print*,  x,y,z
!
                    call t_car_to_sph(x,y,z,r,tet,phi)
                    tet=tet/pisd
                    phi=phi/pisd
                    print 200, 'then R,tet,phi= ',r,tet,phi,' (RE,deg.)'
                    endif
!
  100 format(a)
  110 format(e14.6,1x,f8.3,1x,f8.3)
  120 format(1x,a,3(e11.3),a)
  200 format(1x,a,e11.3,f8.3,f8.3,a)
!
      return
      END
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cp_leap_year(iyear,ileap)
!
! ----------------------------------------------------------------------
! *   Class  : calendar modules of Rocotlib Software
! *   Object : compute_leap_year with ileap=1 for leap year, 0 if not
! *   Author : P. Robert, CRPE, 1992
!
! *   Input  : iyear (ex: 1980)
! *   Output : ileap (1 or 0 if iyear is or not a leap year)
! ----------------------------------------------------------------------
!
      if(iyear.lt.1900) then
                print*,'*** Rocotlib/cp_leap_year: iyear= ',iyear
                print*,'*** Rocotlib/cp_leap_year: iyear must be > 1900'
                stop   '*** Rocotlib/cp_leap_year: iyear must be > 1900'
                        endif
!
      ir=iyear-(iyear/4)*4
      if(ir.eq.0) then
                  ileap=1
                  else
                  ileap=0
                  endif
!
      is=iyear-(iyear/100)*100
      if(is.eq.0) then
                  ir=iyear-(iyear/400)*400
                  if(ir.eq.0) then
                              ileap=1
                              else
                              ileap=0
                              endif
                  else
                  return
                  endif
!
      END
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine t_sph_to_car(r,teta,phi,x,y,z)
!
! ----------------------------------------------------------------------
!
! *   Class  : transform modules of Rocotlib Software
! *   Object : transforms_sph_to_car: SPH -> CAR  system
! *   Author : P. Robert, CRPE, 1992
! *   Comment: none
!
! *   Input  :   r,teta,phi  spherical coordinates (angles in radians)
! *   Output :   x,y,z       cartesian coordinates
! ----------------------------------------------------------------------
!
!
      sq=r*sin(teta)
      x=sq*cos(phi)
      y=sq*sin(phi)
      z=r*cos(teta)
!
      return
      END
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine t_car_to_sph(x,y,z,r,teta,phi)
!
! ----------------------------------------------------------------------
! *   Class  : transform modules of Rocotlib Software
! *   Object : transforms_car_to_sph: CAR -> SPH  system
! *   Author : P. Robert, CRPE, 1992
! *   Comment: none
!
! *   Input  :   x,y,z        cartesian coordinates
! *   Output :   r,teta,phi   spherical coordinates (angles in radians)
! ----------------------------------------------------------------------
!
!
      teta=0.
      phi=0.
      sq=x**2+y**2
      r=sqrt(sq+z**2)
      pi=acos(-1.)
      pisd=pi/180.
!
      if(r.lt.1.e-30) return
!
! *** en dessous de 1/10000 degres, on considere que teta =0 ou 180
!     et phi indefini, mis a zero
!
      if(sq/r.gt.1.7e-6) then
                   phi=atan2(y,x)
                 if(phi.lt.-179.999*pisd.and.phi.gt.-180.*pisd) phi=pi
                 if(phi.lt. 0.0001*pisd.and.phi.gt.-0.0001*pisd) phi=0.
                   teta=acos(z/r)
                   return
                   endif
!
      if (z.lt.0.) then
                   teta=acos(-1.)
                   else
                   teta=0.
                   endif
!
      return
      END
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!