!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program compute_sat_orbit_param

!----------------------------------------------------------------------!
! Object: compute sat. orbital parameters
! Author: P. Robert ,Scientidev, Jan 2021
!----------------------------------------------------------------------!

  use rff_param_def
  use rff_data_def

  implicit none

  real(kind=4) :: ux,uy,uz,vx,vy,vz,a1,a2,a3,b1,b2,b3,c1,c2,c3
  real(kind=4) :: aa1,aa2,aa3,ap1,ap2,ap3,am1,am2,am3,bm1,bm2,bm3,aar,apr,amr
  real(kind=4) :: rmin,rmax,apo,per,angle,ratio,teta,GR,ps

  real(kind=4), dimension(:), allocatable :: Wx,Wy,Wz
  real(kind=4) :: covar(3,3),lambda(3),eigvec(3,3) 

  character(len=255) :: file1,buf
  character(len=27)  :: datisoper
  integer            :: i,nbvec,indmin,indmax
 
  character(len=3)   :: rep1 
                                                                        

  write(*,*) '------------------------------------------------------------'
  write(*,*) 'compute_sat_orbit_param : read a RFF vectime file'
  write(*,*) 'and computeorbital parameters'
  write(*,*) '------------------------------------------------------------'
  write(*,*)

  write(*,*) 'RFF file to read ? (ex: .../data/toto.rff)'
  read(*,'(a)') file1
  write(*,*) trim(file1)

! read  RFF file
! --------------

  call rff_R_file(1,file1)

  IF(manda_param%FILE_CLASS /= 'VecTime') THEN
      write(*,*) '*** error, RFF file is not a VecTime Class'
      write(*,*) 'manda_param%FILE_CLASS=', manda_param%FILE_CLASS
      write(*,*) '    program aborted'
      stop 'compute_sat_orbit_param.exe     : *** ERROR !! Program aborted !'
  ENDIF
  
  buf=manda_param%DATA_COORDINATE_SYSTEM
  rep1=buf(1:3)

  if (rep1 /= 'GEI' .AND. rep1 /= 'gei') then
                write(*,*) '*** error, input file must be in GEI system'
                write(*,*) '    program aborted'
  stop 'compute_sat_orbit_param.exe     : *** ERROR !! Program aborted !'
  endif
   
  if(manda_param%DATA_UNITS /= 'km ; km ; km') then
           if((manda_param%DATA_UNITS == 'Re ; Re ; Re') .or. (manda_param%DATA_UNITS == 'RE ; RE ; RE'))  then
                write(*,*) '*   units=RE, conversion in km with RE=6378. km...'
                R_data_vector(:,:)=R_data_vector(:,:)*6378.
                                               else
           write(*,*) '*** error, data units in input file must be km or RE or Re'
           write(*,*) 'manda_param%DATA_UNITS=',manda_param%DATA_UNITS
           write(*,*) '    program aborted'
           stop 'compute_sat_orbit_param.exe      : *** ERROR !! Program aborted !'
           endif
  endif

  write(*,*) 'check if enough data to compute orbital parameters'

  teta=0.
  nbvec=manda_param%BLOCK_NUMBER

  DO i=2,nbvec
    
    ux=R_data_vector(1,i)
    uy=R_data_vector(2,i)
    uz=R_data_vector(3,i)

    vx=R_data_vector(1,i-1)
    vy=R_data_vector(2,i-1)
    vz=R_data_vector(3,i-1)

    GR=SQRT(R_data_vector(1,i)**2 +R_data_vector(2,i)**2 +R_data_vector(3,i)**2)
    if(GR < 6400.) CYCLE
    GR=SQRT(R_data_vector(1,i-1)**2 +R_data_vector(2,i-1)**2 +R_data_vector(3,i-1)**2)
    if(GR < 6400.) CYCLE


    call cp_angle_and_ratio(ux,uy,uz,vx,vy,vz,angle,ratio) 

    teta=teta+angle
  ENDDO
     
    teta=teta*180./acos(-1.)

    IF(teta < 90.) THEN
               write(*,*) 'teta=',teta
               write(*,*) '*** error, input file contains less than 1/2 orbit'
               write(*,*) '    program aborted'
  stop 'compute_sat_orbit_param.exe     : *** ERROR !! Program aborted !'
               ELSE
               write(*,*) 'OK, teta=',teta
  ENDIF

  write(*,*) 'Compute orbital parametres...'

  allocate(Wx(nbvec))
  allocate(Wy(nbvec))
  allocate(Wz(nbvec))

  Wx(:)=R_data_vector(1,:)
  Wy(:)=R_data_vector(2,:)
  Wz(:)=R_data_vector(3,:)

  call mat_cp_varmin(6,Wx,Wy,Wz,nbvec,0,covar,lambda,eigvec) 
                                                                      
  a1=eigvec(1,1)
  a2=eigvec(2,1)
  a3=eigvec(3,1)

  b1=eigvec(1,2)
  b2=eigvec(2,2)
  b3=eigvec(3,2)

  c1=eigvec(1,3)
  c2=eigvec(2,3)
  c3=eigvec(3,3)


  rmin= 1.e36
  rmax= 0.

  DO i=1,nbvec
      
    GR=SQRT(R_data_vector(1,i)**2 +R_data_vector(2,i)**2 +R_data_vector(3,i)**2)

    if(GR < 6400.) CYCLE
    if(GR > 1.e29) CYCLE

    IF(GR > rmax) THEN
                  rmax=GR
                  indmax=i
    ENDIF

    IF(GR < rmin) THEN
                  rmin=GR
                  indmin=i
    ENDIF
  ENDDO

    apo=rmax
    per=rmin


    datisoper=data_index(indmin)

! autres mesures de la direction du grand axe:

    aa1=R_data_vector(1,indmax)
    aa2=R_data_vector(2,indmax)
    aa3=R_data_vector(3,indmax)

    ap1=-R_data_vector(1,indmin)
    ap2=-R_data_vector(2,indmin)
    ap3=-R_data_vector(3,indmin)

    aar=sqrt(aa1**2 +aa2**2 +aa3**2)
    apr=sqrt(ap1**2 +ap2**2 +ap3**2)

    aa1=aa1/aar
    aa2=aa2/aar
    aa3=aa3/aar

    ap1=ap1/apr
    ap2=ap2/apr
    ap3=ap3/apr

! moyenne pondéree

    am1=(aa1*aar +ap1*apr)/(aar+apr)
    am2=(aa2*aar +ap2*apr)/(aar+apr)
    am3=(aa3*aar +ap3*apr)/(aar+apr)

    amr=sqrt(am1**2 +am2**2 +am3**2)

    am1=am1/amr
    am2=am2/amr
    am3=am3/amr
    

! calcul de b

    bm1= -am2*c3 + am3*c2 
    bm2= -am3*c1 + am1*c3 
    bm3= -am1*c2 + am2*c1 


  print*
  print*, 'check orthogonality of major and minor axis'

  ps=a1*b1 +a2*b2 + a3*b3
  angle=acos(ps)*180./3.1415927
  print*, '(a,b) angle=',angle

  if(angle < 89.9 .OR. angle > 90.1) then
            write(*,*) '*** error, grand axe et petit axe non orthogonaux'
            write(*,*) 'a=',a1,a2,a3
            write(*,*) 'b=',b1,b2,b3
            write(*,*) '    program aborted'
            stop 'compute_sat_orbit_param.exe     : *** ERROR !! Program aborted !'
  endif


    write(*,*) 'results, in this order:'
    write(*,*) '----------------------'
    write(*,*) 'Apogee '
    write(*,*) 'Perigee'
    write(*,*)
    write(*,*) 'date where S/ is at perigee'
    write(*,*)
    write(*,*) 'direction of semi-major axis, in GEI system, MVA method '
    write(*,*) '(from ellipse center to perigee, unit vector)'
    write(*,*)
    write(*,*) 'direction of semi-minor axis, in GEI system, MVA method '
    write(*,*) '(a,b vector in the sens of the motion, unit vector)'
    write(*,*)
    write(*,*) 'a,b from minmax method'

    write(*,*) apo
    write(*,*) per
    print 9,  datisoper
    write(*,*) a1,a2,a3
    write(*,*) b1,b2,b3
    write(*,*) am1,am2,am3
    write(*,*) bm1,bm2,bm3

    9  format(a) 

  write(*,*) "compute_sat_orbit_param.exe      : NORMAL TERMINATION"
        stop "compute_sat_orbit_param.exe      : NORMAL TERMINATION"

  end

!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
