      program compute_sat_trajectory

!     ***************************************************************0**
!     calcul de la trajectoire d'un satellite autour de la terre.
!     Utilise la keplerlib.
!     P. Robert, CRPE, ~1985, revu LPP novembre 2010
!     ***************************************************************0**


      use rff_param_def
      use rff_data_def

      real(kind=8)      :: a,b,c,e,r, per,apo,rper,rapo
      real(kind=4)      :: at,bt,ps
      character(len=27) :: datisocur,datisoper,datisoapo,peripre
      character(len=70) :: comment(20), rff_name

!     ---------------------------------------------------------------0--

!     masse de la Terre (kg)
!     GM=5.9737e24 !  (IMCCC)
      GM=5.9736e24 !  (marche mieux)

      print*, 'compute_sat_trajectory'
      print*, '------------------'

      print*
      print*, 'Apogee ?  (km, real*8, ex: 124252.735203443d0)'
      read *, apo
      print*, apo

      print*
      print*, 'Perigee ? (km, real*8, ex:  26321.1522350593d0)'
      read *, per
      print*, per

      print*
      print*, 'date where S/ is at perigee ? (ISO date, ex: 2001-09-25T18:56:06.000Z)'
      read(*,9) datisoper
      print 9,  datisoper
   9  format(a)

      print*
      print*, 'direction of semi-major axis, in GEI system ?'
      print*, '(from ellipse center to perigee, unit vector,'
      print*, ' ex: -0.9493840   0.3011743   0.0892410'
      read *, a1,a2,a3
      print*, a1,a2,a3

      print*
      print*, 'direction of semi-minor axis, in GEI system ?'
      print*, '(a,b vector in the sens of the motion, unit vector,'
      print*, ' ex: 0.0820478  -0.0364760   0.9959607'
      read *, b1,b2,b3
      print*, b1,b2,b3

      print*
      print*, 'time resolution for output positions ? (mn, ex: 5.0)'
      read *, deltaT
      print*, deltaT

      print*
      print*, 'name of output rff file ? (ex: toto.rff)'
      read(*,9) rff_name
      print 9,  rff_name

      print*
      print*, 'scale factor on x,y,z (ex: 1.)'
      read *, sfac
      print*, sfac

      print*
      print*, 'Input  parameters :'
      print*, '-----------------'
      print*
      print*, 'Earth m     : ',GM,' kg'
      print*, 'apogee      : ',apo
      print*, 'perigee     : ',per
      print*, 'perigee time: ',datisoper
      print*, 'semi-major axis direction in GEI: ',a1,a2,a3
      print*, 'semi-minor axis direction in GEI: ',b1,b2,b3
      print*, 'time resolution (mn): ',deltaT
      print*, 'name of outpu file  : ',rff_name

!     calcul des axes de l'ellipse

      call co_axes(apo,per,a,b,c,e)

      print*
      print*, 'Size and exentricity of the ellipse'
      print*, '-----------------------------------'
      print*
      print*, 'a=',a,' km'
      print*, 'b=',b,' km'
      print*, 'c=',c, 'km'
      print*, 'e=',e

      print*
      print*, 'check positions at the ellipse''apex:'
      print*, '------------------------------------'
      print*

! *   renormalisation des axes

      at=sqrt(a1**2 + a2**2 + a3**2)
      bt=sqrt(b1**2 + b2**2 + b3**2)

      a1=a1/at
      a2=a2/at
      a3=a3/at
     
      b1=b1/bt
      b2=b2/bt
      b3=b3/bt

      print*, 'after re-normalisation:'
      print*, 'semi-major axis direction in GEI: ',a1,a2,a3
      print*, 'semi-minor axis direction in GEI: ',b1,b2,b3

  print*
  print*, 'check orthogonality of major and minor axis'

  ps=a1*b1 +a2*b2 + a3*b3
  angle=acos(ps)*180./3.1415927
  print*, '(a,b) angle=',angle

  if(angle < 89.9 .OR. angle > 90.1) then
            write(*,*) '*** error, grand axe et petit axe non orthogonaux'
            write(*,*) 'a=',a1,a2,a3
            write(*,*) 'b=',b1,b2,b3
            write(*,*) '    program aborted'
            stop 'compute_sat_orbit_param.exe     : *** ERROR !! Program aborted !'
  endif

!     calcul de la periode de rotation (s)

      call co_period(a, GM, GT)

      GTh= GT/3600.

      print*,'revolution period in sec. : ',GT
      print*,'revolution period in hours: ',GTh

!     calcul des temps de passage  aux sommets de l'ellipse
!     (perigee=0, apogee= GT/2, et sommets secondaires a pour AE=0)

      call co_apex_time(GTh,e, Tapex)

      Tapex2=GTh-Tapex
      print*
      print*, 'time from perigee to get first  apex (hours) :',Tapex
      print*, '                         apogee      (hours) :',GTh/2.
      print*, '                         second apex (hours) :',Tapex2

!     nombre de points a calculer (2 periodes)

      nbp=2*int(GT/(deltaT*60.)) 

      allocate(R_data_vector(3,nbp))
      allocate(data_index(nbp))

!     position par rapport a la Terre, dans le repere de l'ellipse
!     au cours du temps; on a choisi les temps correspondants
!     aux apex (sommets secondaires de l'ellipse) pour retrouver
!     les perigee, apogee et grand axe de l'ellipse.

      print*
      print*, 'S/C position along one revolution:'
      print*, 'hour from perigee, Anomalie Exc., distance radiale, Anom. vraie'

      do it=0,4
         select case(it)
           case(0) ; hour=  0.
           case(1) ; hour= Tapex
           case(2) ; hour= GTh/2.
           case(3) ; hour= Tapex2
           case(4) ; hour= GTh
         end select

!        calcul de l'anomalie excentrique par resolution de l'equation
!        de Kepler

         call co_anom_excen(e,hour,GTh,AE)

!        calcul de l'anomalie vraie donnant la position angulaire
!        depuis le foyer (le Soleil)

         call co_anom_vraie(AE,e,a,AV,r)

         pisd=acos(-1.)/180.
         print*, hour, AE/pisd,r,AV/pisd
      enddo


      print*
      print*, 'remainder: perigee:',per
      print*, '           a      :',a
      print*, '           apogee :',apo
      print*, '           a again:',a
      print*, '           perigee:',per
      print*
      print*, 'Time has been chosed to correspond to the summit of the ellipse,'
      print*, 'to check that one find again perigee, a, apogee,a, and perigee'

! *   calcul de la position du perige et de l'apoge dans le GEI

      
      call co_anom_excen(e,0.,    GTh,AEper)
      call co_anom_excen(e,GTh/2.,GTh,AEapo)

      call co_anom_vraie(AEper,e,a,AVper,rper)
      call co_anom_vraie(AEapo,e,a,AVapo,rapo)

      call posgei(rper,AVper,a1,a2,a3,b1,b2,b3,sfac,px,py,pz)
      call posgei(rapo,AVapo,a1,a2,a3,b1,b2,b3,sfac,ax,ay,az)

      call tcarsph(px,py,pz,rp,tetp,phip)
      tetp=tetp/pisd
      phip=phip/pisd

      call tcarsph(ax,ay,az,ra,teta,phia)
      teta=teta/pisd
      phia=phia/pisd

      print*
      print*, 'Perigee position in GEI (xyz) : ', px,py,pz
      print*, 'Apogee  position in GEI (xyz) : ', ax,ay,az

      print*
      print*, 'Perigee position in GEI (rtp) : ', rp,tetp,phip
      print*, 'Apogee  position in GEI (rtp) : ', ra,teta,phia

!     calcul du temps de passage a l'apoge

      call addsec_datiso(datisoper, GT/2.,datisoapo)
      call addsec_datiso(datisoper,-GT/2.,datisocur)

      print*
      print*, 'perigee time: ',datisoper
      print*, 'apogee  time: ',datisoapo
      print*, 'apogee  time: ',datisocur

      print*
      print*, 'creation du fichier des positions en GEI'
      print*, '----------------------------------------'
      print*
      print*, 'calcul ...'


! perigee precedent

      call addsec_datiso(datisoper,-GT,peripre)
   
      print*, 'peri, peripre=',datisoper,peripre

! *   calcul des position

      do n= 1,nbp/2

         time=float(n-1)*deltaT*60.

         call addsec_datiso(peripre,time,data_index(n))
         call co_anom_excen(e,time,GT,AE)
         call co_anom_vraie(AE,e,a,AV,r)
         call posgei(r,AV,a1,a2,a3,b1,b2,b3,sfac,R_data_vector(1,n),R_data_vector(2,n),R_data_vector(3,n))

      enddo


      do n= nbp/2+1,nbp

         time=float(n-nbp/2)*deltaT*60.

         call addsec_datiso(datisoper,time,data_index(n))
         call co_anom_excen(e,time,GT,AE)
         call co_anom_vraie(AE,e,a,AV,r)
         call posgei(r,AV,a1,a2,a3,b1,b2,b3,sfac,R_data_vector(1,n),R_data_vector(2,n),R_data_vector(3,n))

      enddo

      write(comment(1),1) apo,per
      write(comment(2),2) datisoper
      write(comment(3),3) a1,a2,a3
      write(comment(4),4) b1,b2,b3
      write(comment(5),5) deltaT

   1  format('# Apogee:',f11.3,'  Perigee:',f11.3)
   2  format('# Perigee date : ',a)
   3  format('# semi-major axis direction in GEI :',3f11.7)
   4  format('# semi-minor axis direction in GEI :',3f11.7)
   5  format('# Time resolution : ',f11.5,' mn')

      nlc=5

      print*
      print*, 'creation du fichier RFF'

!     initialisation des meta-data

      call rff_set_default_init
      call init_metadata

!     header du fichier RFF

      manda_param%BLOCK_FIRST_INDEX         = data_index(1)
      manda_param%BLOCK_LAST_INDEX          = data_index(nbp)

      call rff_W_metadata(1,rff_name)
      call rff_W_const_data(1)
      call rff_W_indexed_data(1)
      call rff_W_tail(1)

! *** termine
!
      print *, ('-',i=1,72)
      print*, 'normal termination'

      print*, 'COMPUTE_SAT_TRAJECTORY.exe       : NORMAL TERMINATION'
         stop 'COMPUTE_SAT_TRAJECTORY.exe       : NORMAL TERMINATION'

!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      contains

      subroutine init_metadata


      use rff_param_def
      use rff_data_def

      manda_param%FILE_NAME                 = 'compute_sat_trajectory.rff'
      manda_param%FILE_CLASS                = 'VecTime'
      manda_param%FILE_FORMAT_VERSION       = 'Roproc_Format_File V 2.3'
      manda_param%FILE_CREATION_DATE        = data_index(1)

      manda_param%MISSION_NAME              = 'Simulation'
      manda_param%OBSERVATORY_NAME          = 'simulation'
      manda_param%OBSERVATORY_NUMBER        = 1
      manda_param%EXPERIMENT_NAME           = 'Kepler'
      manda_param%EXPERIMENT_MODE           = 'POSITIONS'
      manda_param%INSTRUMENT_TYPE           = 'Computer'
      manda_param%MEASUREMENT_TYPE          = 'x,y,z'

      manda_param%INDEX_LABEL               = 'Time'
      manda_param%INDEX_TYPE                = 'STR'
      manda_param%INDEX_UNITS               = 'ISO_TIME'
      manda_param%INDEX_FORMAT              = '(a27)'
      manda_param%INDEX_FORM                = 'Scala'
      manda_param%INDEX_DIMENSION           = 1
      manda_param%INDEX_PROPERTIES          = 'Regularly Spaced'

      manda_param%INDEX_EXTENSION_LABEL     = 'No'
      manda_param%INDEX_EXTENSION_TYPE      = 'STR'
      manda_param%INDEX_EXTENSION_UNITS     = 'None'
      manda_param%INDEX_EXTENSION_FORMAT    = 'None'
      manda_param%INDEX_EXTENSION_LENGTH    = 0

      manda_param%DATA_LABEL                = 'Px ; Py ; Pz'
      manda_param%DATA_TYPE                 = 'FLT'
      manda_param%DATA_UNITS                = 'km ; km ; km' 
      manda_param%DATA_FORMAT               = '(3e15.6)'
      manda_param%DATA_FORM                 = 'Vector'
      manda_param%DATA_DIMENSION            = 3
      manda_param%DATA_REPRESENTATION       = 'xyz Cartesian'
      manda_param%DATA_COORDINATE_SYSTEM    = 'GEI'
      manda_param%DATA_FILL_VALUE           = '1.e30'
      manda_param%BLOCK_NUMBER              = nbp



      optio_param%TIME_RESOLUTION           = deltaT

      optio_param%TITLE                     = 'Simulated Position'
      optio_param%SUB_TITLE                 = 'Px,Py,Pz in GEI system'
      optio_param%DISCIPLINE_NAME           = 'Space and  Magnetospheric Physics'
      optio_param%EXPERIMENT_PI_NAME        = 'No'
      optio_param%EXPERIMENT_PI_MAIL        = 'patrick.robert@lpp.polytechnique.fr'


      const_data%SAMPLE_RATE               =  1./deltaT

      end subroutine init_metadata
     
      end

!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX


