      program dir_size_pretty_tree
!


!----------------------------------------------------------------------!
! Object: Compute & print properly directory tree and size of each.
! Author: P. Robert , LPP, 1990
!----------------------------------------------------------------------!
!
!     Patrick ROBERT, CETP, 1990
!         revision decembre 1995
!          revision Octobre 2001 (pour version 5.8)
! ----------------------------------------------------------------!

      integer, dimension(:),allocatable :: niv
      integer :: lni(100)
      integer :: ipo(100)
      integer (kind=8) :: ib
!
      integer (kind=8), dimension(:), allocatable :: siz
!
      character(len=64) , dimension(:), allocatable :: dir
      character(len=512), dimension(:), allocatable :: lin
      character(len=255) :: forprop
      character(len=96)  :: wodi
      character(len=64)  ::  bb,tt,tra,titre
!
      data bb     /'| '/
      data tt     /'__________________________________________________'/
      data lni(1) /0/
      data ipd1,ipd2 / 1,1/
!
!     ******************************************************************
!
      print 200
      print 200, ('-',i=1,79)
!
! *** lecture du fichier resultant de pwd et du -k
!     chargement de lin(nd)
!
      close(1)
      open(1,file='dir_size_tree.tmp',form='formatted',status='unknown')
!
      print 200, 'Procedure dir_size_pretty_tree.exe - '// &
                 'P. Robert, CETP, 1990'// &
                 ' - Rev. Dec. 1995/ Feb 2014'
      print 200
!
      read(1,200) wodi
      print 200, 'Starting date        : ',trim(wodi)
      print 200
!
      read(1,200) wodi
      print 200, 'host name            : ',trim(wodi)
!
      read(1,200) wodi
      print 200, 'kernel name/release  : ',trim(wodi)
!
      read(1,200) wodi
      print 200, 'Starting directory   : ',trim(wodi)
!
      print 200, ' '
!
      read(1,200) wodi
      read(wodi,*) nbdir
      print 201, 'Total number of directories  : ',nbdir
!
      read(1,200) wodi
      read(wodi,*) nbfiles
      print 201, 'Total number of files        : ',nbfiles
      print 200, ('-',i=1,79)
!
! *** allocation des tableaux

      nbdir=nbdir+1

      allocate(niv(nbdir),stat=ierr1)
      allocate(siz(nbdir),stat=ierr2)
      allocate(dir(nbdir),stat=ierr3)
      allocate(lin(nbdir),stat=ierr4)

      if(ierr1 /= 0 .or. ierr2 /= 0 .or.ierr3 /= 0 .or.ierr4 /= 0 ) then
         print*,'*** dir_size_pretty_tree.exe: allocate error'
         print*,'    program aborted !!!'
         stop   'dir_size_pretty_tree.exe        : *** dir_size_pretty_tree.exe: allocate error'
      endif

! *** saut de l'entete

      read(1,200) bid
      read(1,200) bid
      read(1,200) bid
      read(1,200) titre
      read(1,200) bid
      read(1,200) bid
      
      nd=0
   10 continue
      nd=nd+1
!
      read(1,200,end=40) lin(nd)   
      go to 10
   40 continue
      close(1)
      
      nd=nd-1
      print 200, ' '
      print 201, 'nb. of directories considered: ',nd
      
            
!    si le point d'entree contiens des "/" il faudra les deduire

      nbs=0
      do il=1,255
      if(lin(1)(il:il).eq.'/' ) then
                                   nbs=nbs+1
      endif
      enddo
!
! *** identification des directories   
!     chargement de dir(nd), niv(nd), siz(nd)
!
      nbniv=0
      do 20 nudi=1,nd
!     idnu=nd-nudi+1
      idnu=nudi
      niv(nudi)=-nbs
!
      do 30 il=1,255
      if(lin(idnu)(il:il).eq.'/') then
                                  niv(nudi)=niv(nudi)+1
                                  ipd1=il+1
                                  ipd2=il+32
                  ipd1=min(ipd1,255)
                  ipd2=min(ipd2,255)
                                  endif
   30 continue
      nbniv=max(nbniv,niv(nudi))
      if(nbniv.gt.100) stop 'dir_size_pretty_tree.exe        : plus de 100 niveaux de directories'
      dir(nudi)=lin(idnu)(ipd1:ipd2)
      read(lin(idnu),*) ib
      siz(nudi)=ib
   20 continue
      print 201, 'Maximum number of levels     : ',nbniv
!
! *** calcul de la longueur de chaque niveau
!
      do 60 nuni=1,nbniv
      do 50 nudi=1,nd
      if(niv(nudi).ne.nuni) go to 50
      ll=len_trim(dir(nudi))
!     max 64-2
      lni(nuni)=max(lni(nuni),ll)
      if(lni(nuni) .gt.62) lni(nuni)=62
   50 continue
   60 continue

! calcul du format d'eciture des proprietees

      nl=len_trim(titre)
      
      if(titre(nl-1:nl) == 'Mo') then
                                 iformat=0
                                 else
                                 iformat=1
      endif

      n13=0

      do nudi=1,nd
!        nb de chiffres significatif necessaires
         nsiz=int(log10(  DBLE(siz(nudi))+0.1)) +1
         n13=max(n13,nsiz)
      enddo

      write(forprop,101) n13+1          
  101 format('(i',i2.2,',255a)')

  
! *** ecriture de l'arborescence avec calcul des raccords
!

      print 200, ' '  
      print 200, titre
      print 200, '--------------'
      
      print forprop,siz(1),'._' 

      do 70 nudi=2,nd
      nc=len_trim(dir(nudi))
      nn =niv(nudi)
      nnp=niv(nudi+1)
      ld=lni(nn)
      if(nnp.eq.nn+1) then
              tra=dir(nudi)(1:nc)//tt(nc+1:ld)
                      else
              tra=dir(nudi)(1:nc)
      endif

      write(lin(nudi),forprop) siz(nudi),'  ',(bb(1:lni(i)+2),i=1,nn-1),'|_',tra(1:ld)
      
   70 continue
!
! *** elimination des barres verticales intempestives
!
      do 80 il=2,nd
      nudi=nd-il+2
      nbar=0
!
      do 82 ic=1,255
      if(lin(nudi)(ic:ic).eq.'|') then
                  nbar=nbar+1
                  ipo(nbar)=ic
                  endif
   82 continue
!
      do 84 ib=1,nbar-1
      ipoba=ipo(nbar-ib)
      if(lin(nudi+1)(ipoba:ipoba).ne.'|') lin(nudi)(ipoba:ipoba)=' '
   84 continue
   80 continue
!
      do 90 nudi=2,nd
      print 200, trim(lin(nudi))
   90 continue
      print 200
      print 200, ('-',i=1,79)
!
! *** deallocation des tableaux

      deallocate(niv,stat=ierr1)
      deallocate(siz,stat=ierr2)
      deallocate(dir,stat=ierr3)
      deallocate(lin,stat=ierr4)
!
  200 format(79a)
  201 format(a,i6)
!
      print*, "dir_size_pretty_tree.exe         : NORMAL TERMINATION"
         stop "dir_size_pretty_tree.exe         : NORMAL TERMINATION"
      end
!
!     __________________________________________________________________
!
