!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
!                                                                       
!                                                                       
      subroutine r_copolar(idset,fultit,projet,experi,sid,isat,fnat,    &
     &                    titpan,jul00,ijoud,imoid,iand                 &
     &                   ,ih,im,is,ims,nbp,fc,f1,f2,                    &
     &                    nbseq,bitr,fe,fs,srasc,sdec,tspea,tspeb,      &
     &                    Nxulf,Nspe,dt,df,nt,nf,spebx,speby,spebz,     &
     &spebp,spebq,spebr)                                                
!                                                                       
!     ---------------------------------------------------------------+--
! *   Subject  : read  copolar.resu file                                
! *   Class    : processing of copolar.resu files type                  
! *   Author   : P. Robert, CETP                                        
! *   Comments :                                                        
!     ---------------------------------------------------------------+--
!                                                                       
!                                                                       
!     declarations                                                      
!                                                                       
!                                                                       
                                                                        
      character*64 fultit,projet,experi,fnat 
      character*3 bitr 
      character*5 sid 
      character*120 titpan 
      character*80 tspea(6),tspeb(6) 
!                                                                       
      integer nt(6),nf(6) 
      real dt(6), df(6) 
      real spebx(Nxulf,Nspe),speby(Nxulf,Nspe),spebz(Nxulf,Nspe) 
      real spebp(Nxulf,Nspe),spebq(Nxulf,Nspe),spebr(Nxulf,Nspe) 
!                                                                       
!                                                                       
!     lecture de l'entete du fichier                                    
!                                                                       
      call rheacopolar(idset,fultit,projet,experi,sid,isat,fnat,        &
     &              titpan,jul00,ijoud,imoid,iand,                      &
     &              ih,im,is,ims,nbp,fc,f1,f2,nbseq,bitr,               &
     &              fe,fs,srasc,sdec)                                   
!                                                                       
!     lecture ces 6 spectrogrammes                                      
                                                                        
      call rdatcopolar(tspea,tspeb,dt,df,nt,nf,Nxulf,Nspe,              &
     &spebx,speby,spebz,spebp,spebq,spebr)                              
!                                                                       
!                                                                       
!                                                                       
      return 
      END                                           
!                                                                       
!                                                                       
!                                                                       
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX   
!                                                                       
      subroutine rheacopolar(idset,fultit,projet,experi,sid,isat,fnat,  &
     &                    titpan,jul00,ijoud,imoid,iand                 &
     &                   ,ih,im,is,ims,nbp,fc,f1,f2,                    &
     &                    nbseq,bitr,fe,fs,srasc,sdec)                  
!                                                                       
!                                                                       
!     ---------------------------------------------------------------+--
! *   Subject  : read header of copolar.resu file                       
! *   Class    : processing of copolar.resu files type                  
! *   Author   : P. Robert, CETP                                        
! *   Comments :                                                        
!     ---------------------------------------------------------------+--
!                                                                       
!     declarations                                                      
!                                                                       
      character*(*) fultit,projet,experi,fnat 
!                                                                       
      character*78 cbid,tstart,tend,ttrait 
      character*(*) titpan 
      character*3 bitr 
      character*5 sid 
!                                                                       
!                                                                       
      data cbid,tstart,tend,ttrait /4*' '/ 
!                                                                       
      dfrom=' ' 
      ddcal=' ' 
!                                                                       
! *** test de la 1ere ligne du fichier                                  
!                                                                       
      read(1,1) tstart 
!                                                                       
      if(tstart.NE.'START OF FILE HEADER') then 
                          print*,'***/ FIRST LINE OF FILE:' 
                          print*,tstart 
                          print*, ' *** rheacowave' 
                          print*, ' File is not a cowave.resu file' 
      stop 'RHEACOWAVE     *** ABORTED ! FILE IS NOT A COWAVE.RESU  ***' 
                          endif 
!                                                                       
! *** saut des commentaires                                             
!                                                                       
      do while (cbid.ne.'END COMMENTS') 
      read(1,1) cbid 
      enddo 
!                                                                       
! *** lecture du reste de l'entete                                      
!                                                                       
      read(1,1) ttrait 
      read(1,1) cbid 
      read(1,*) idset 
      read(1,1) cbid 
      read(1,1) fultit 
      read(1,1) cbid 
      read(1,1) projet 
      read(1,1) cbid 
      read(1,1) experi 
      read(1,1) cbid 
      read(1,1) sid 
      read(1,1) cbid 
      read(1,*) isat 
      read(1,1) cbid 
      read(1,1) fnat 
      read(1,1) cbid 
      read(1,1) titpan 
      read(1,1) cbid 
      read(1,*) nbp 
      read(1,1) cbid 
      read(1,*) fc 
      read(1,1) cbid 
      read(1,*) f1,f2 
                                                                        
      read(1,1) cbid 
      read(1,*) nbseq 
      read(1,1) cbid 
      read(1,1) bitr 
      read(1,1) cbid 
      read(1,*) fe 
      read(1,1) cbid 
      read(1,*) fs 
      read(1,1) cbid 
      read(1,*) srasc,sdec 
      read(1,1) cbid 
      read(1,*) jul00,ijoud,imoid,iand 
      read(1,1) cbid 
      read(1,3) ih,im,is,ims 
      read(1,1) tend 
!                                                                       
! *** print des resultats                                               
!                                                                       
      call strlen(fultit,ncfu) 
      call strlen(projet,ncpr) 
      call strlen(experi,ncex) 
      call strlen(fnat,nfna) 
      call strlen(dfrom,ncfn1) 
      call strlen(ddcal,nccal) 
!                                                                       
      print *, ttrait 
      print *,  tstart 
      print *, 'Roproc data set Number : ',idset 
      print *, 'Full Title: ',fultit(1:ncfu) 
      print *, 'Project   : ',projet(1:ncpr) 
      print *, 'Experiment: ',experi(1:ncex) 
      print *, 'S/C ID: ',sid 
      print *, 'S/C # : ',isat 
      print *, 'Field Nat : ',fnat(1:nfna) 
      print *, 'Step of calibration of input data:',titpan 
      print *, 'nbp  :',nbp 
      print *, 'cut-off : ', fc 
      print *, 'filter  : ', f1,f2 
      print *, 'nbseq   : ',nbseq 
      print *, 'Bitrate : ',bitr 
      print *, 'Samp. f.: ',fe 
      print *, 'Spin  f.: ',fs 
      print *, 'sra,sdec: ',srasc,sdec 
      print *, 'asked date :          ',ijoud,imoid,iand,jul00 
      print *, 'asked time/duration : ',ih,im,is,ims 
      print *, tend 
      print *, ttrait 
!                                                                       
    1 format(a) 
    2 format(i3,i3,i2.2,i5) 
    3 format(3i3,i4) 
!                                                                       
!                                                                       
      return 
      END                                           
!                                                                       
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX   
!                                                                       
      subroutine wheacopolar(idset,fultit,projet,experi,sid,isat,fnat,  &
     &                    titpan,jul00,ijour,imois,                     &
     &                    iannee,iheur,imin,isec,imsec,nbp,fc,f1,f2,    &
     &                    nbseq,br,fe,fs,rasc,dec)                      
!                                                                       
!     ------------------------------------------------------------------
! *   Objet  : ecriture du header du fichier copolar.resu               
! *   Classe : traitement de fichier de type copolar.resu               
! *   Auteur : P. Robert, CETP, Janvier 2001                            
!     ------------------------------------------------------------------
!                                                                       
      character*(*) fultit,projet,experi,fnat 
      character*(*) titpan 
      character*3 br 
!                                                                       
      character*5 sid 
!                                                                       
      call strlen(fultit,ncfu) 
      call strlen(projet,ncpr) 
      call strlen(experi,ncex) 
      call strlen(sid,ncsid) 
      call strlen(pathfn1,ncfn1) 
      call strlen(pathcal,nccal) 
!                                                                       
      write(2,100) 'START OF FILE HEADER' 
      write(2,600) 
      write(2,100) ('-',i=1,72) 
      write(2,100) 'Roproc Data Set number:' 
      write(2,400)  idset 
      write(2,100) 'Full Title:' 
      write(2,100)  fultit(1:ncfu) 
      write(2,100) 'Project:' 
      write(2,100)  projet(1:ncpr) 
      write(2,100) 'Experiment:' 
      write(2,100)  experi(1:ncex) 
      write(2,100) 'Spacecraft ID:' 
      write(2,100)  sid(1:ncsid) 
      write(2,100) 'Spacecraft number:' 
      write(2,400)  isat 
      write(2,100) 'Step of calibration of imput data:' 
      write(2,100) titpan 
      write(2,100) 'Field Nature:' 
      write(2,100)  fnat 
!                                                                       
!                                                                       
      write(2,100) 'Date asked:' 
      write(2,*) ijour,imois,iannee,jul00 
!                                                                       
!                                                                       
      write(2,100) 'time  asked:' 
      write(2,*) iheur,imin,isec,imsec 
!                                                                       
!                                                                       
      write(2,100) 'Number of points for the windows:' 
      write(2,200)  nbp 
      write(2,100) 'Frequency cut-off for the calibration:' 
      write(2,500)  fc 
      write(2,100) 'Frequency bouds for the filtering in fixed system:' 
      write(2,500)  f1 ,f2 
      write(2,100) 'Number of windows:' 
      write(2,200)  nbseq 
      write(2,100) 'Bit Rate:' 
      write(2,100)  br 
      write(2,100) 'Sampled Frequency:' 
      write(2,500)  fe 
      write(2,100) 'Spin Frequency:' 
      write(2,500)  fs 
      if(isat.le.4) then 
                    write(2,100) 'R. Asc. and Dec. of Spin axis in GEI:' 
                    else 
                    write(2,100) 'Geographic Longitude and Latitude :' 
                    endif 
      write(2,500)  rasc,dec 
      write(2,100) 'END OF FILE HEADER' 
!                                                                       
  100 format(72a) 
  200 format(i8) 
  300 format(2i3.2,i5,3x,'(',i3.3,')') 
  310 format(3i2.2,3x,i3.3) 
  400 format(7i3) 
  500 format(3e14.6) 
  600 format('START COMMENTS',/,                                        &
     &'File type copolar.resu: Result of copolar.exe',/,                &
     &'The copolar.resu files are files containing level N1 or N2',     &
     &' waveform data.',/,                                              &
     &'The format of this file is common for the processing of ULF',    &
     &' Magnetic data',/,                                               &
     &'from experiments on spacecraft GEOS-1, GEOS-2, CLUSTER',         &
     &' and Moving Ground',/,                                           &
     &'Station. It allows to compare N1 data and N2 calibrated data',   &
     &' and can be',/,                                                  &
     &'the N2 input data level to produce calibrated waveform plots,',  &
     & ' spectra,',/,                                                   &
     &'spectrograms, integrated power, or any else N3 results.',/,      &
     &'File is structured as:',/,                                       &
     &'  . File Header, including comments and fixed data,',/,          &
     &'  . Several windows data, each window corresponds to a',         &
     &' waveform,',/,                                                   &
     &'    and could contains several data panels, corresponding',      &
     &' themselves to',/,                                               &
     &'    various levels of processing.',/,                            &
     &'Author: Patrick ROBERT, CETP, 1996-2000.      revision',         &
     &' October 2001.',/,                                               &
     &'              Revision for ground mobile station data,',         &
     &' January 2002.',/,                                               &
     &'              Revision for any kind of waves,',                  &
     &' August  2002.',/,                                               &
     &'              Revision for general titles management,',          &
     &' January 2003.'                                                  &
     &,/,'END COMMENTS')                                                
                                                                        
                                                                        
      return 
      END                                           
!                                                                       
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
!                                                                       
      subroutine rdatcopolar(tspea,tspeb,dt,df,nt,nf,                   &
     &Nxulf,Nspe,spebx,speby,spebz,spebp,spebq,spebr)                   
                                                                        
!                                                                       
                                                                        
!                                                                       
!     ---------------------------------------------------------------+--
! *   Subject  : read sequency of copolar.resu file                     
! *   Class    : processing of cowave.resu files type                   
! *   Author   : P. Robert, CETP, September 2000, revised January 2001  
! *   Comments : derived from read_caliulf_lib.f library of GEOS pack   
!     ---------------------------------------------------------------+--
!                                                                       
!      real bigtab(6,nxx,Nxulf)                                         
      real spebx(Nxulf,Nspe),speby(Nxulf,Nspe),spebz(Nxulf,Nspe) 
      real spebp(Nxulf,Nspe),spebq(Nxulf,Nspe),spebr(Nxulf,Nspe) 
      real dt(6),df(6) 
      integer nt(6),nf(6) 
!                                                                       
      character*64 tspea(6),tspeb(6) 
!                                                                       
      character*79 cbid,ttrait 
!                                                                       
! *** contenu des variables et tableaux:                                
!                                                                       
!     bigtab                                                            
!     Nxulf   : nombre maxi de points .                                 
!     tspea: titre principal de chaque spectrogramme.                   
!     tspeb: titre de chaque spectrogramme.                             
!                                                                       
!     dt: resolution en temps un dt par spectro                         
!     df  : resolution en frequence un dt par spectro                   
!                                                                       
! *** data/heure de debut; on teste le champ 'END OF FILE' ou le vrai eo
!                                                                       
!                                                                       
!     lecture de speb1                                                  
                                                                        
      read(1,100,end=30) ttrait 
      read(1,100,end=30) cbid 
      read(1,100,end=30) tspea(1) 
      read(1,100) cbid 
      read(1,100) tspeb(1) 
      read(1,100) cbid 
      read(1,*) dt(1),df(1) 
      read(1,100) cbid 
      read(1,*)   nt(1),nf(1) 
      read(1,100) cbid 
!                                                                       
!                                                                       
!     --------------------------                                        
!                                                                       
      read(1,*) ((spebx(j,k),k=1,nf(1)),j=1,nt(1)) 
                                                                        
!                                                                       
!     lecture de speb2                                                  
                                                                        
      read(1,100,end=30) ttrait 
      read(1,100,end=30) cbid 
      read(1,100,end=30) tspea(2) 
      read(1,100) cbid 
      read(1,100) tspeb(2) 
      read(1,100) cbid 
      read(1,*) dt(2),df(2) 
      read(1,100) cbid 
      read(1,*)   nt(2),nf(2) 
      read(1,100) cbid 
!                                                                       
!                                                                       
!     --------------------------                                        
!                                                                       
                                                                        
      read(1,*) ((speby(j,k),k=1,nf(2)),j=1,nt(2)) 
                                                                        
!                                                                       
!     lecture de speb3                                                  
                                                                        
      read(1,100,end=30) ttrait 
      read(1,100,end=30) cbid 
      read(1,100,end=30) tspea(3) 
      read(1,100) cbid 
      read(1,100) tspeb(3) 
      read(1,100) cbid 
      read(1,*) dt(3),df(3) 
      read(1,100) cbid 
      read(1,*)   nt(3),nf(3) 
      read(1,100) cbid 
!                                                                       
!                                                                       
!     --------------------------                                        
!                                                                       
      read(1,*) ((spebz(j,k),k=1,nf(3)),j=1,nt(3)) 
!                                                                       
!     lecture de speb4                                                  
                                                                        
      read(1,100,end=30) ttrait 
      read(1,100,end=30) cbid 
      read(1,100,end=30) tspea(4) 
      read(1,100) cbid 
      read(1,100) tspeb(4) 
      read(1,100) cbid 
      read(1,*) dt(4),df(4) 
      read(1,100) cbid 
      read(1,*)   nt(4),nf(4) 
      read(1,100) cbid 
!                                                                       
!                                                                       
!     --------------------------                                        
!                                                                       
      read(1,*) ((spebp(j,k),k=1,nf(4)),j=1,nt(4)) 
                                                                        
!                                                                       
!     lecture de speb5                                                  
                                                                        
      read(1,100,end=30) ttrait 
      read(1,100,end=30) cbid 
      read(1,100,end=30) tspea(5) 
      read(1,100) cbid 
      read(1,100) tspeb(5) 
      read(1,100) cbid 
      read(1,*) dt(5),df(5) 
      read(1,100) cbid 
      read(1,*)   nt(5),nf(5) 
      read(1,100) cbid 
!                                                                       
!                                                                       
!     --------------------------                                        
!                                                                       
      read(1,*) ((spebq(j,k),k=1,nf(5)),j=1,nt(5)) 
!                                                                       
!     lecture de speb6                                                  
                                                                        
      read(1,100,end=30) ttrait 
      read(1,100,end=30) cbid 
      read(1,100,end=30) tspea(6) 
      read(1,100) cbid 
      read(1,100) tspeb(6) 
      read(1,100) cbid 
      read(1,*) dt(6),df(6) 
      read(1,100) cbid 
      read(1,*)   nt(6),nf(6) 
      read(1,100) cbid 
!                                                                       
!                                                                       
!     --------------------------                                        
!                                                                       
      read(1,*) ((spebr(j,k),k=1,nf(6)),j=1,nt(6)) 
!                                                                       
!                                                                       
!                                                                       
   30 continue 
!                                                                       
                                                                        
  100 format(a) 
  500 format(4(e12.6,3x)) 
!                                                                       
!                                                                       
      return 
      END                                           
!                                                                       
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
!                                                                       
      subroutine w_copolar(fich2,idset,fultit,projet,experi,sid         &
     &            ,isat,fnat,titpan,jul00,ijoud,imoid,iand              &
     &                   ,ih,im,is,ims,nbp,fc,f1,f2,                    &
     &                    nbseq,bitr,fe,fs,srasc,sdec,tspea,tspeb,      &
     &                   Nxulf,Nspe,dt,df,nt,nf,spebx,speby,spebz,      &
     &spebp,spebq,spebr)                                                
!                                                                       
!                                                                       
!                                                                       
!                                                                       
!     ecriture d'un fichier copolar2.resu                               
!                                                                       
!     declarations                                                      
!                                                                       
      character*64 fultit,projet,experi,fnat 
      character*3 bitr 
      character*5 sid 
      character*120 titpan 
      character*64 fich2 
      character*80 tspea(6),tspeb(6) 
!                                                                       
      integer nt(6),nf(6) 
      real dt(6), df(6) 
      real spebx(Nxulf,Nspe),speby(Nxulf,Nspe),spebz(Nxulf,Nspe) 
      real spebp(Nxulf,Nspe),spebq(Nxulf,Nspe),spebr(Nxulf,Nspe) 
!                                                                       
!                                                                       
!                                                                       
      call wheacopolar(idset,fultit,projet,experi,sid,isat,fnat,        &
     &              titpan,jul00,ijoud,imoid,iand,                      &
     &              ih,im,is,ims,nbp,fc,f1,f2,nbseq,bitr,               &
     &              fe,fs,srasc,sdec)                                   
                                                                        
      call wrdatcopolar(tspea,tspeb,dt,df,nt,nf,spebx,speby,spebz,      &
     &spebp,spebq,spebr,Nxulf,Nspe)                                     
!                                                                       
!                                                                       
      return 
      END                                           
!                                                                       
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
!                                                                       
      subroutine wrdatcopolar(tspea,tspeb,dt,df,nt,nf,spebx,speby,      &
     &spebz,spebp,spebq,spebr,Nxulf,Nspe)                               
                                                                        
!                                                                       
!     ---------------------------------------------------------------+--
! *   Subject  : write sequency of copolar.resu file                    
! *   Class    : processing of copolar.resu files type                  
! *   Author   : P. Robert, CETP                                        
! *   Comments : derived from write_caliulf_lib.f library of GEOS pack  
!     ---------------------------------------------------------------+--
!                                                                       
!     declarations                                                      
!                                                                       
!      real bigtab(6,nxx,Nxulf)                                         
      real spebx(Nxulf,Nspe),speby(Nxulf,Nspe),spebz(Nxulf,Nspe) 
      real spebp(Nxulf,Nspe),spebq(Nxulf,Nspe),spebr(Nxulf,Nspe) 
                                                                        
      real dt(6),df(6) 
      integer nt(6),nf(6) 
!                                                                       
      character*64 tspea(6),tspeb(6) 
!                                                                       
!                                                                       
! *** contenu des variables et tableaux:                                
!                                                                       
!     bigtab                                                            
!     Nxulf   : nombre maxi de points .                                 
!     tspea: titre principal de chaque spectrogramme.                   
!     tspeb: titre de chaque spectrogramme.                             
!                                                                       
!     dt: resolution en temps un dt par spectro                         
!     df  : resolution en frequence un dt par spectro                   
!                                                                       
! *** data/heure de debut; on teste le champ 'END OF FILE' ou le vrai eo
!                                                                       
!                                                                       
!                                                                       
!      do 20 i=1,6                                                      
                                                                        
      call cchalen_(tspea(1),nwa) 
      call cchalen_(tspeb(1),nwb) 
      write(2,110) ('-',j=1,72) 
      write(2,100) 'DATA 1:' 
      write(2,100) tspea(1)(1:nwa) 
      write(2,100) 'Title' 
      write(2,100) tspeb(1)(1:nwb) 
      write(2,100) 'dt, df:' 
      write(2,*) dt(1),df(1) 
      write(2,100) 'nt, nf:' 
      write(2,*)   nt(1),nf(1) 
      write(2,100) 'Spectrogram data 1:' 
!                                                                       
!                                                                       
!     --------------------------                                        
!                                                                       
      write(2,500) ((spebx(j,k),k=1,nf(1)),j=1,nt(1)) 
!                                                                       
                                                                        
!     Spectrogramme 2                                                   
                                                                        
      call cchalen_(tspea(2),nwa) 
      call cchalen_(tspeb(2),nwb) 
      write(2,110) ('-',j=1,72) 
      write(2,100) 'DATA 2:' 
      write(2,100) tspea(2)(1:nwa) 
      write(2,100) 'Title' 
      write(2,100) tspeb(2)(1:nwb) 
      write(2,100) 'dt, df:' 
      write(2,*) dt(2),df(2) 
      write(2,100) 'nt, nf:' 
      write(2,*)   nt(2),nf(2) 
      write(2,100) 'Spectrogram data 2:' 
!                                                                       
!                                                                       
!     --------------------------                                        
!                                                                       
      write(2,500) ((speby(j,k),k=1,nf(2)),j=1,nt(2)) 
!                                                                       
!     Spectrogramme 3                                                   
                                                                        
      call cchalen_(tspea(3),nwa) 
      call cchalen_(tspeb(3),nwb) 
      write(2,110) ('-',j=1,72) 
      write(2,100) 'DATA 3:' 
      write(2,100) tspea(3)(1:nwa) 
      write(2,100) 'Title' 
      write(2,100) tspeb(3)(1:nwb) 
      write(2,100) 'dt, df:' 
      write(2,*) dt(3),df(3) 
      write(2,100) 'nt, nf:' 
      write(2,*)   nt(3),nf(3) 
      write(2,100) 'Spectrogram data 3:' 
!                                                                       
!                                                                       
!     --------------------------                                        
!                                                                       
      write(2,500) ((spebz(j,k),k=1,nf(3)),j=1,nt(3)) 
!                                                                       
!     Spectrogramme 4                                                   
                                                                        
      call cchalen_(tspea(4),nwa) 
      call cchalen_(tspeb(4),nwb) 
      write(2,110) ('-',j=1,72) 
      write(2,100) 'DATA 4:' 
      write(2,100) tspea(4)(1:nwa) 
      write(2,100) 'Title' 
      write(2,100) tspeb(4)(1:nwb) 
      write(2,100) 'dt, df:' 
      write(2,*) dt(4),df(4) 
      write(2,100) 'nt, nf:' 
      write(2,*)   nt(4),nf(4) 
      write(2,100) 'Spectrogram data 4:' 
!                                                                       
!                                                                       
!     --------------------------                                        
!                                                                       
      write(2,500) ((spebp(j,k),k=1,nf(4)),j=1,nt(4)) 
!                                                                       
!     Spectrogramme 5                                                   
                                                                        
      call cchalen_(tspea(5),nwa) 
      call cchalen_(tspeb(5),nwb) 
      write(2,110) ('-',j=1,72) 
      write(2,100) 'DATA 5:' 
      write(2,100) tspea(5)(1:nwa) 
      write(2,100) 'Title' 
      write(2,100) tspeb(5)(1:nwb) 
      write(2,100) 'dt, df:' 
      write(2,*) dt(5),df(5) 
      write(2,100) 'nt, nf:' 
      write(2,*)   nt(5),nf(5) 
      write(2,100) 'Spectrogram data:' 
!                                                                       
!                                                                       
!     --------------------------                                        
!                                                                       
      write(2,500) ((spebq(j,k),k=1,nf(5)),j=1,nt(5)) 
!                                                                       
!     Spectrogramme 6                                                   
                                                                        
      call cchalen_(tspea(6),nwa) 
      call cchalen_(tspeb(6),nwb) 
      write(2,110) ('-',j=1,72) 
      write(2,100) 'DATA 6:' 
      write(2,100) tspea(6)(1:nwa) 
      write(2,100) 'Title' 
      write(2,100) tspeb(6)(1:nwb) 
      write(2,100) 'dt,df:' 
      write(2,*) dt(6),df(6) 
      write(2,100) 'nt,nf:' 
      write(2,*)   nt(6),nf(6) 
      write(2,100) 'Spectrogram data 6:' 
!                                                                       
!                                                                       
!     --------------------------                                        
!                                                                       
      write(2,500) ((spebr(j,k),k=1,nf(6)),j=1,nt(6)) 
!                                                                       
!                                                                       
!   20 continue                                                         
!                                                                       
  110 format(72a) 
  100 format(x,72a) 
  500 format(4(e12.6,2x)) 
!                                                                       
      return 
      END                                           
