!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program reduce_time_rff

!----------------------------------------------------------------------!
! Object: extract a time period into a WF or VT RFF file 
! Author: P. Robert , LPP, 2011 May 27  
!----------------------------------------------------------------------!

  use rff_param_def
  use rff_data_def

  implicit none

  character(len=255) :: file1, file2, work
  character(len=27)  :: datiso1,datiso2, credate
  integer            :: i, i1=0, i2=0, n,id1,id2,ifc

  integer,dimension(2) :: data_dim


  print*, '------------------------------------------------------------'
  print*, 'reduce_time_rff : read a RFF waveform or vectime file'
  print*, 'and reduce time period'
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF file to read ? (ex: .../data/toto.rff)'
  read(*,'(a)') file1
  print*, trim(file1)

  print*, 'RFF file to create ? (ex: ./toto_red.rff)'
  read(*,'(a)') file2
  print*, trim(file2)

  print*, 'date ISO 1 of time period ? ex: 2001-09-23T09:00:39.504Z'
  read(*,'(a)') datiso1
  print*, trim(datiso1)

  print*, 'date ISO 2 of time period ? ex: 2001-09-23T09:00:43.004Z'
  read(*,'(a)') datiso2
  print*, trim(datiso2)


! convert datiso

  if (datiso2 .LT. datiso1) then
                write(*,*) '*** error, date2 < date1'
                write(*,*) '    program aborted'
  stop 'reduce_time_rff.exe             : *** ERROR !! Program aborted !'
  endif


! read  RFF file
! --------------
  
  ifc=1
  call rff_R_metadata(ifc,file1)
! call rff_W_manda_param(6)
! call rff_W_optio_param(6)

  call rff_R_const_data(ifc)
  call rff_R_indexed_data(ifc)
  call rff_R_tail(ifc)
  

! select time period
! ------------------

! first index

  do i=1, manda_param%block_number

     if(data_index(i) .GE. datiso1) then
                  i1=i
                  exit
     endif
  enddo

! last index

  do i=i1+1, manda_param%block_number

     if(data_index(i) .GE. datiso2) then
                  i2=i
                  exit
     endif
  enddo

! no time period found

  if (i1 == 0  .or. i2 == 0) then
                write(*,*) '*** error, time period not found'
                write(*,*) '    asked period: ', datiso1,' ',datiso2
                write(*,*) '    file content: ', data_index(1), &
                                                 data_index(manda_param%block_number)
                write(*,*) '    i1,i2=',i1,i2
                write(*,*) '    program aborted'
  stop 'reduce_time_rff.exe             : *** ERROR !! Program aborted !'
  endif

! reduce date
! -----------

  write(*,*) 
  write(*,*) 'old block number=',manda_param%block_number
  write(*,*) 'selected indicices: i1,i2=',i1,i2

  n=i2 -i1 +1
  manda_param%block_number= n
  write(*,*) 'new block number=',manda_param%block_number

  write(*,*)
  write(*,*) 'old block_first_index=',manda_param%block_first_index
  write(*,*) 'old block_last_index =',manda_param%block_last_index  

  manda_param%block_first_index=data_index(i1)
  manda_param%block_last_index  =data_index(i2)
  write(*,*) 'new block_first_index=',manda_param%block_first_index
  write(*,*) 'new block_last_index =',manda_param%block_last_index  

! index & extented index
! ----------------------

!  data_index2(1:n)=data_index(i1:i2) ne marche pas avec ifort (seg. fault)
! pour les gros trableaux ; il faut definir un tableau temporaire
! et comme parfois le tableau temporaire est trop gros, il faut se taper la boucle...

  do i=1,n
     data_index(i)=data_index(i+i1-1)
     status(i)    =    status(i+i1-1)
     phase(i)     =     phase(i+i1-1)
  enddo

! type of RFF

  print*, 'manda_param%FILE_CLASS =',TRIM(manda_param%FILE_CLASS)
  print*, 'manda_param%DATA_TYPE  =',TRIM(manda_param%DATA_TYPE)
  
! VecTime file
! ------------

  data_dim=manda_param%DATA_DIMENSION
  id1=data_dim(1)
  id2=data_dim(2)

  IF(manda_param%FILE_CLASS == 'VecTime') THEN
      IF(manda_param%DATA_TYPE == 'INT') THEN
         do i=1,n
            I_data_vector(:,i)=I_data_vector(:,i+i1-1)  
         enddo
         write(*,*) '    I_data_vector updated'
      ENDIF

      IF(manda_param%DATA_TYPE == 'FLT') THEN
         do i=1,n
            R_data_vector(:,i)=R_data_vector(:,i+i1-1)  
         enddo
         write(*,*) '    R_data_vector updated'
      ENDIF

  ENDIF

! WaveForm
! --------

  IF(manda_param%FILE_CLASS == 'WaveForm') THEN
      IF(manda_param%DATA_TYPE == 'INT') THEN
         do i=1,n
            I_data_matrix(:,:,i)=I_data_matrix(:,:,i+i1-1)  
         enddo
         write(*,*) '    I_data_matrix updated'
      ENDIF

      IF(manda_param%DATA_TYPE == 'FLT') THEN
         do i=1,n
            R_data_matrix(:,:,i)=R_data_matrix(:,:,i+i1-1)  
         enddo
         write(*,*) '    R_data_matrix updated'
      ENDIF

  ENDIF

! modification des formats d'ecriture (des "," au lieu de 1x pour IDL)

  IF(manda_param%FILE_CLASS /= 'WaveForm') THEN
      print*
      print*,'Current data formats:'
      print*,'manda_param%INDEX_FORMAT=',TRIM(manda_param%INDEX_FORMAT)
      print*,'manda_param%INDEX_EXTENSION_FORMAT=',TRIM(manda_param%INDEX_EXTENSION_FORMAT)
      print*,'manda_param%DATA_FORMAT=',TRIM(manda_param%DATA_FORMAT)
    
      work=manda_param%INDEX_FORMAT
      call rff_format_R_to_W(work,manda_param%INDEX_FORMAT)
    
      work=manda_param%INDEX_EXTENSION_FORMAT
      call rff_format_R_to_W(work,manda_param%INDEX_EXTENSION_FORMAT)
    
      work=manda_param%DATA_FORMAT
      call rff_format_R_to_W(work,manda_param%DATA_FORMAT)
    
      print*
      print*,'New formats for writing data:'
      print*,'manda_param%INDEX_FORMAT=',TRIM(manda_param%INDEX_FORMAT)
      print*,'manda_param%INDEX_EXTENSION_FORMAT=',TRIM(manda_param%INDEX_EXTENSION_FORMAT)
      print*,'manda_param%DATA_FORMAT=',TRIM(manda_param%DATA_FORMAT)

  ENDIF

! Update history field
! --------------------

  call gdatiso(credate)
  call rff_update_history(credate,'RPC_reduce_time_rff')


! write RFF file
! --------------

  call rff_W_file(2,file2)

  print*, ('-',i=1,72)

  print*, "reduce_time_rff.exe              : NORMAL TERMINATION"
     stop "reduce_time_rff.exe              : NORMAL TERMINATION"
  end

!XXXXXXXX0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

