!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program reduce_time_vectime

!----------------------------------------------------------------------!
! Object: extract a time period into a WF or VT RFF file 
! Author: P. Robert , LPP, 2011 May 27  
!----------------------------------------------------------------------!

  use rff_param_def
  use rff_data_def

  implicit none

  character(len=255) :: file1, file2,ligne,work
  character(len=27)  :: datiso1,datiso2, credate,newb1,newb2,debfic,finfic
  integer            :: i, ieof,ipos1,ifc1,ifc2,ifc3,nbb,ierr,get_pos,iwarn
  real (kind=8)      :: secdif,secdif3,secdif4
  real (kind=4)      :: red


  print*, '------------------------------------------------------------'
  print*, 'reduce_time_vectime : read a RFF vectime file'
  print*, 'and reduce time period'
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF file to read ? (ex: .../data/toto.rff)'
  read(*,'(a)') file1
  print*, trim(file1)

  print*, 'RFF file to create ? (ex: ./toto_red.rff)'
  read(*,'(a)') file2
  print*, trim(file2)

  print*, 'date ISO 1 of time period ? ex: 2001-09-23T09:00:39.504Z'
  read(*,'(a)') datiso1
  print*, trim(datiso1)

  print*, 'date ISO 2 of time period ? ex: 2001-09-23T09:00:43.004Z'
  read(*,'(a)') datiso2
  print*, trim(datiso2)


! convert datiso

  if (datiso2 .LT. datiso1) then
                write(*,*) '*** error, date2 < date1'
                write(*,*) '    program aborted'
  stop 'reduce_time_vectime.exe         : *** ERROR !! Program aborted !'
  endif


! read  RFF file
! --------------
  
  ifc1=1 ! file to read
  ifc2=2 ! part1 of new file
  ifc3=3 ! part2 of new file
  
  call rff_R_metadata(ifc1,file1)
  call rff_R_const_data(ifc1)

  if(manda_param%FILE_CLASS /= 'VecTime') then
      write(*,*) '*** error, RFF file is not a VecTime Class'
      write(*,*) 'manda_param%FILE_CLASS=', manda_param%FILE_CLASS
      write(*,*) '    program aborted'
      stop 'reduce_time_vectime.exe         : *** ERROR !! Program aborted !'
  endif

  debfic=TRIM(manda_param%BLOCK_FIRST_INDEX)
  finfic=TRIM(manda_param%BLOCK_LAST_INDEX)
  write(*,*)
  write(*,*) 'debfile,endfile  =',debfic, finfic
  write(*,*) 'date1,date2 asked=',datiso1,datiso2

  iwarn=0
  
  call diff_datiso(datiso1,debfic,secdif)
  
  if(secdif > 0.D0) then
                    write(*,*) 'date1 < debut fichier'
                    write(*,*) datiso1,debfic
                    write(*,*) 'secdif=',secdif
                    datiso1=debfic(1:27)
                    iwarn=1
  endif

  call diff_datiso(datiso2,finfic,secdif)
  
  if(secdif < 0.D0) then
                    write(*,*) 'date2 > fin fichier'
                    write(*,*) datiso2,finfic
                    write(*,*) 'secdif=',secdif
                    datiso2=finfic(1:27)
                    iwarn=2
  endif

  if(iwarn .ne. 0 ) then
                    write(*,*) 'asked date modified:'
                    write(*,*) 'date1,date2 mod. =',datiso1,datiso2
  endif

  if(datiso1 .eq. debfic .AND. datiso2 .eq. finfic) then
      write(*,*)
      write(*,*) '*** error, time period requested is the same that the entire file'
      write(*,*) '    datiso1,datiso2=',datiso1,' ',datiso2
      write(*,*) '    debfile,endfile=',debfic, ' ',finfic
      write(*,*) '    program aborted'
      stop 'reduce_time_vectime.exe         : *** ERROR !! Program aborted !'
  endif

    call diff_datiso(finfic ,debfic, secdif3) 
    call diff_datiso(datiso2,datiso1,secdif4)

    red=real( (secdif3-secdif4)/secdif3)*100.

   if(red .lt. 0. ) then
      write(*,*)
      write(*,*) '*** error, time period requested is greater that the entire file'
      write(*,*) '    datiso1,datiso2=',datiso1,' ',datiso2
      write(*,*) '    debfile,endfile=',debfic, ' ',finfic
      write(*,*) '    program aborted'
      stop 'reduce_time_vectime.exe          : *** ERROR !! Program aborted !'
   endif

    write(*,'(a,f7.1,a)')' file to be reduced of ',red,' %'

  open(ifc3,file='data.tmp')
  
  write(ifc3,'(a)') "#-------------------------------------------------------------------------------"
  write(ifc3,'(a)') "START INDEXED_DATA"
  
! select time period and create part2
! -----------------------------------

  nbb=0
  write(*,*) 'nb blocks=',manda_param%block_number

! Positionning on START INDEXED_DATA line of input RFF file

  ierr=get_pos('START INDEXED_DATA',ifc1)

  IF(ierr /= 0) THEN 
        write(*,*) '* WARNING ! keyword START INDEXED_DATA not found'
                ELSE
        write(*,*) 'Positionning at begin of data done'
  ENDIF

! possible blank line after the START INDEXED_DATA
  READ(ifc1,*) work 
  IF(len_trim(work) /= 0) THEN 
      BACKSPACE ifc1
  ENDIF

  write(*,*) 'Input file positionned on START INDEXED_DATA line'
  write(*,*)
  
  do i=1, manda_param%block_number
     
     READ(ifc1,'(a)', iostat=ieof) ligne
     IF(ieof /= 0) EXIT
     IF(i == 1) THEN
        write(*,*) i," ",ligne(1:70)
        !find where the ISO time ends
        ipos1=INDEX(ligne,'Z')
        write(*,*) ' data(index(1)  =',ligne(1:ipos1)
        write(*,*) ' position of "Z" separator in index :', ipos1
     ENDIF
     
     if(ligne(1:ipos1) .GE. datiso1) then
        write(ifc3,'(a)') trim(ligne)
        nbb=nbb+1
        IF(nbb == 1) newb1=ligne(1:ipos1)
     endif
     
          
     if(ligne(1:ipos1) .GE. datiso2) then
        newb2=ligne(1:ipos1)
        EXIT
     endif
  enddo

  write(ifc3,'(a)') "END INDEXED_DATA"
  write(ifc3,'(a)') "END DATA"
  write(ifc3,'(a)') "END ROPROC_FORMAT_FILE"
  close(ifc3)

! no time period found

  if (nbb == 0 ) then
                write(*,*) '*** error, time period not found'
                write(*,*) '    asked period: ', datiso1,' ',datiso2
                write(*,*) '    no blocks found'
                write(*,*) '    program aborted'
  stop 'reduce_time_vectime.exe         : *** ERROR !! Program aborted !'
  endif

! new mandatory parameters
! ------------------------

  write(*,*) 
  write(*,*) 'old block number=',manda_param%block_number
  manda_param%block_number= nbb
  write(*,*) 'new block number=',manda_param%block_number

  write(*,*)
  write(*,*) 'old block_first_index=',manda_param%block_first_index
  write(*,*) 'old block_last_index =',manda_param%block_last_index  

  manda_param%block_first_index=newb1
  manda_param%block_last_index =newb2
  write(*,*) 'new block_first_index=',manda_param%block_first_index
  write(*,*) 'new block_last_index =',manda_param%block_last_index  


! create new reduced vectime
! --------------------------
 
  call rff_W_metadata(ifc2,file2)
  call rff_W_const_data(ifc2)

! Update history field
! --------------------

  call gdatiso(credate)
  call rff_update_history(credate,'RPC_reduce_time_vectime')

  close(ifc2)

  print*, ('-',i=1,72)

  print*, "reduce_time_vectime.exe          : NORMAL TERMINATION"
     stop "reduce_time_vectime.exe          : NORMAL TERMINATION"
  end

!XXXXXXXX0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

