!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
! XX                                                                  XX
! XX  Patrick ROBERT, ScientiDev, 1986  --> a ce jour                 XX
! XX  Copyright 1986-2021  Patrick ROBERT, all rights reserved        XX
! XX                                                                  XX
! XX           -----------------                                      XX
! XX                                                                  XX
! XX V1.0 Version initiale  depuis archives :                Fev 1986 XX
! XX V2.0 Decoupage et structuration des call :              Fev 1986 XX
! XX V3.0 Creation du driver PostScript  :                   Mar 1990 XX
! XX V4.0 Refonte generale et nomage codifie des modules :   Mai 1993 XX
! XX V5.0 Usage des polices PS standards :                   Mar 1995 XX
! XX V6.0 Nouveaux modules de calcul et traces :             Dec 1995 XX
! XX V7.0 Redefinition des categories et des roles,                   XX
! XX      stucturation de l'arborescence en modules :        Dec 1996 XX
! XX V7.1 - V7.4 ameliorations et corrections diverses                XX
! XX V7.5 Extension a 8 bits des polices standards PS :      Dec 1997 XX
! XX V7.6 Nouveaux modules de trace :                        Mar 1998 XX
! XX V7.7 Optimisation pour ecriture de texte :              Nov 1998 XX
! XX V8.0 Gestion des polices proportionnelles PS :          Oct 1999 XX
! XX V8.1 Refonte generale des common et simplifications,             XX
! XX      Suppression de l'interface en pixels,                       XX
! XX      trace entierement vectoriel, gestion des images :  Nov 1999 XX
! XX V8.2 Introduction des formats A3,A2,A1 et A0 :          Avr 2000 XX
! XX V8.3 Corrections qq bugs :                              Dec 2001 XX
! XX V8.4 Resolution de quelques pb de polices Bold :        Dec 2003 XX
! XX V8.5 Corrections qq bugs :                              Avr 2005 XX
! XX V8.6 nouveaux ajustements pour le calcul des                     XX
! XX      graduations pour grandes valeurs proches :         Aou 2005 XX
! XX V8.7 Compatibilite pour divers Ghostview (Sun, Win) :   Nov 2005 XX
! XX V8.8 Verification FORESYS et introduction de plusieurs           XX
! XX      mires de couleur :                                 Jan 2006 XX
! XX V8.9 Compatibilite pour G77 PC windows :                Feb 2006 XX
! XX V9.0 25 mires de couleurs, possibilite mires a la carte Jun 2006 XX
! XX V9.1 Suppression drivers inacheves autre que PostScript,         XX
! XX      intro lines tiretees, formats en maj. ou minusc.,           XX
! XX      new routines de temps, refonte des categories :    Oct 2007 XX
! XX V9.2 Correction calcul Page Bounding Box :              Nov 2007 XX
! XX V9.3 fonction puissances pour portabilite (x**n) :      Nov 2007 XX
! XX V9.4 corr. bugs sur cfiggra_ et nb pages dans driver :  Mai 2008 XX
! XX V9.5 Intro fonctions calendrier, unicite du code SUN-PC,         XX
! XX      Activation dfigout_ et evite depass. format ds PS           XX
! XX      Optimisation distance graduations & labels a l'axe Jun 2008 XX
! XX V9.6 Full gfortran compatible                           Jun 2010 XX
! XX V9.7 Introduction graduations logarithmiques            Sep 2011 XX
! XX                                                                  XX
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
!
!
      subroutine capowex_(a,x,apowx)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_a_power_x i.e. a**x for code portability
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2007
!     ---------------------------------------------------------------+--
!
      if(a.lt.0.) call uperror_('capowex_ : a must be > 0')
!
      arg=x*log(a)
      argm=37.*log(10.)
      if(arg.gt.argm) call uperror_('capowex_ : a**x must be < 1.e37')
      apowx= exp(x*log(a))
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cbesfor_(x,format)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_best_format as '(f3.1)' for x=2.5
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      character*(*) format
      character*1 ia
!
      data epsi  /1.e-36/
      save epsi
!
!     calcule le format optimum d'un nombre donne x
!
!
      ll=len(format)
      if(ll.lt.8) call uperror_('cbesfor_: format < 8 caracteres')
!
      xx=abs(x)
!
      if(xx.lt.epsi) then
                     format='(f2.0)'
                     return
                     endif
!
!
      call cmanexp_(xx,rma,ie)
      call csigdig_(rma,nosd)
!
! *** format f: fn1.n2 avec chiffre np.n2
!
      if(xx.lt.1.) then
                   n1=nosd+2+abs(ie)
                   lim=9
                   else
                   n1=max(nosd+1,ie+1)
                   lim=8
                   endif
!
      if(n1.gt.lim) then
                  ia='e'
                  n2=nosd
                  n1=n2+6
!
                  else
                  ia='f'
                  if(xx.lt.1.) then
                               n2=nosd+abs(ie)
                               else
                               n2=n1-ie-1
                               endif
                  endif
!
      if(x.lt.0.) n1=n1+1
!
      if(n1.lt.10) then
                   write(format,101) ia,n1,n2
                   else
                   write(format,102) ia,n1,n2
                   endif
!
  101 format('(',a1,i1,'.',i1,')')
  102 format('(',a1,i2,'.',i1,')')
!
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cbesfori(ix,format)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_best_format_integer as '(i3)' for ix=124
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      character*(*) format
!
!     calcule le format optimum d'un nombre donne ix
!
!
      ll=len(format)
      if(ll.lt.8) call uperror_('cbesfori: format < 8 caracteres')
!
      iax=abs(ix)
!
      if(iax.eq.0) then
                   format='(i1)'
                   return
                   endif
!
      n1=int(alog10(float(iax))) +1
      if(ix.lt.0) n1=n1+1
!
      if(n1.lt.10) then
                   write(format,101) n1
                   else
                   write(format,102) n1
                   endif
!
  101 format('(i',i1,')')
  102 format('(i',i2,')')
!
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ccarpol_(x,y,r,teta)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_cartesian_to_polar degrees
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      data epsi  /1.e-35/
      save epsi
!
!
      dspi=180./acos(-1.)
!
      if(abs(x).lt.epsi.and.abs(y).lt.epsi) then
                                            teta=0.
                                            r=0.
                                            return
                                            endif
!
      tetar=atan2(y,x)
      teta=tetar*dspi
      if(teta.lt.0.) teta=teta+360.
      r=sqrt(x*x+y*y)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ccarsph_(x,y,z,r,teta,phi)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_cartesian_to_spherical degrees
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      data epsi  /1.e-35/
      save epsi
!
      dspi=180./acos(-1.)
!
!     conversion de coordonnees cartesiennes en spheriques
!
!
      r=sqrt(x*x+y*y+z*z)
      rp=amax1(r,epsi)
      teta=dspi*acos(z/rp)
      phi=0.
      if(abs(x).gt.epsi.and.abs(y).gt.epsi) phi=dspi*atan2(y,x)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cchalen_(chast,nbcha)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_character_length without end blanks
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) chast
!
!     calcule la longueur utile d'une chaine de caracteres
!     les blancs de fin sont ignores
!
!
      nbc=len(chast)
      if(nbc.gt.255) then
                     print*, '***probleme avec cchalen, nbc=',nbc
                     call uperror_('cchalen_:nbc GT 255 !!!')
                     endif
!
      do 10 i=1,nbc
      ii=nbc-i+1
      if(chast(ii:ii).ne.' ') go to 12
   10 continue
      ii=0
   12 continue
!
      nbcha=ii
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cchatim_(ctime,ih,im,is)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_time_character_to_time '13:03:05' to 13 03 05
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) ctime
!
      read(ctime,100) ih,im,is
!
  100 format(i2,1x,i2,1x,i2)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cclehsb_(level,hue,sat,bri)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_color_level_in_hsb values
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2013
!     ---------------------------------------------------------------+--
!
!
      common /colmap/ hueu,satu,briu,nbcolu
!
      real hueu(256),satu(256),briu(256)

      if(level.lt.1)   call uperror_('cclehsb_: level must be >0')
      if(level.gt.256) call uperror_('cclehsb_: level must be <= 256')
!
      hue=hueu(level)
      sat=satu(level)
      bri=briu(level)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cchawid_(chast,numfon,height,width)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_character_width from height in cm
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      real fonwid(255,13)
      save fonwid
!
      character*(*) chast
!
!
! *** calcul des largeurs des fonts disponibles
!
      call sdr_gfonwid(fonwid,nbfon)
!
! *** calcul du corps de la fonte utilisee selon sa hauteur
!
      call cfonbod_(numfon,height,fonbod)
!
! *** calcul du nb de caracteres de la chaine
!
      call cchalen_(chast,nc)
!
! *** calcul du rapport avec la fonte 10 de reference
!
      sca=fonbod/10.
      width=0.
!
! *** somme des tailles de chaque caracteres (blanc=32 par defaut)
!
      do 20 i=1,nc
      ich= ichar(chast(i:i))
      if(ich.eq.0) ich=32
      width= width + fonwid(ich,numfon)*sca
   20 continue
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ccirarc_(x1,y1,x2,y2,r,xc,yc,tet1,tet2)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_circular_arc from 2 points and radius
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      pi=acos(-1.)
      pisd=pi/180.
!
! *** calcul de alpha=(tet1+tet2)/2 et beta=(tet1-tet2)/2
!     2 solutions pour alpha et beta
!
      alpha1= -atan((x1-x2)/(y1-y2))
      alpha2= -atan((x1-x2)/(y1-y2)) +pi
!
      call cvecmod_(x1-x2, y1-y2, 0., rmod)
!
      beta1=  asin(rmod/(2.*r))
      beta2= -asin(rmod/(2.*r))
!
! *** donc 4 solutions pour tet1 et tet2
!
      tet1a= (alpha1-beta1)
      tet2a= (alpha1+beta1)
!
      tet1b= (alpha1-beta2)
      tet2b= (alpha1+beta2)
!
      tet1c= (alpha2-beta1)
      tet2c= (alpha2+beta1)
!
      tet1d= (alpha2-beta2)
      tet2d= (alpha2+beta2)
!
! *** condition tet2 > tet1 pour elimination de solutions (ita=0)
!
      if(tet1a.gt.tet2a) then
                         ita=0
                         else
                         ita=1
                         endif
!
      if(tet1b.gt.tet2b) then
                         itb=0
                         else
                         itb=1
                         endif
!
      if(tet1c.gt.tet2c) then
                         itc=0
                         else
                         itc=1
                         endif
!
      if(tet1d.gt.tet2d) then
                         itd=0
                         else
                         itd=1
                         endif
!
! *** calcul du centre: 2 solutions x 4 pour teta
!
      xc1a= x1-r*cos(tet1a)
      yc1a= y1-r*sin(tet1a)
!
      xc2a= x2-r*cos(tet2a)
      yc2a= y2-r*sin(tet2a)
      if(abs(xc1a-xc2a).gt.0.0001.or.abs(yc1a-yc2a).gt.0.0001) ita=0
!
!
      xc1b= x1-r*cos(tet1b)
      yc1b= y1-r*sin(tet1b)
!
      xc2b= x2-r*cos(tet2b)
      yc2b= y2-r*sin(tet2b)
      if(abs(xc1b-xc2b).gt.0.0001.or.abs(yc1b-yc2b).gt.0.0001) itb=0
!
!
      xc1c= x1-r*cos(tet1c)
      yc1c= y1-r*sin(tet1c)
!
      xc2c= x2-r*cos(tet2c)
      yc2c= y2-r*sin(tet2c)
      if(abs(xc1c-xc2c).gt.0.0001.or.abs(yc1c-yc2c).gt.0.0001) itc=0
!
!
      xc1d= x1-r*cos(tet1d)
      yc1d= y1-r*sin(tet1d)
!
      xc2d= x2-r*cos(tet2d)
      yc2d= y2-r*sin(tet2d)
      if(abs(xc1d-xc2d).gt.0.0001.or.abs(yc1d-yc2d).gt.0.0001) itd=0
!
! *** choix des solutions; il ne doit en rester qu'une
!
      isol=0
!
      if(ita.eq.1) then
                   isol=isol+1
                   xc=xc1a
                   yc=yc1a
                   tet1=tet1a
                   tet2=tet2a
                   endif
!
      if(itb.eq.1) then
                   isol=isol+1
                   xc=xc1b
                   yc=yc1b
                   tet1=tet1b
                   tet2=tet2b
                   endif
!
      if(itc.eq.1) then
                   isol=isol+1
                   xc=xc1c
                   yc=yc1c
                   tet1=tet1c
                   tet2=tet2c
                   endif
!
      if(itd.eq.1) then
                   isol=isol+1
                   xc=xc1d
                   yc=yc1d
                   tet1=tet1d
                   tet2=tet2d
                   endif
!
      if(isol.eq.0) call uperror_('ccirarc_:pas de solution !!!')
      if(isol.gt.1) call uperror_('ccirarc_:plusieurs solutions !!! ')
!
      tet1=tet1/pisd
      tet2=tet2/pisd
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ccollev_(level,hue,sat,bri)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_color_values for given level of current colormap
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2007
!     ---------------------------------------------------------------+--
!
      common /colmap/ hueu,satu,briu,nbcolu
      common /colmac/ comapu
!
      real hueu(256),satu(256),briu(256)
      character*10 comapu
      character*10 colmap
      save colmap
!
! *** mire utilisee et nombre de niveaux
!
      call gcolmap_(colmap,nlevel)
!
! *** test si le niveau demande est dans la mire courante
!
      if(level.lt.1)  call uperror_('dlincoln: level number < 1')
      if(level.gt.nlevel) then
                          print*, 'ROGRALIB/dlincoln: level number too large for colormap'
                          print*, 'level asked     : ',level
                          print*, 'current colormap: ',comapu
                          print*, 'Number of levels: ',nlevel
        call uperror_('dlincoln: level number too large for colormap')
                          endif
!
      hue=hueu(level)
      sat=satu(level)
      bri=briu(level)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cdatdoy_(idoy,iyear,imonth,iday)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_date_from_day_of_year and for a given year
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!                                 copy from Rocotlib, P. Robert, 1992
!
! *   input  : iyear,idoy (idoy=1 for january 1)
! *   output : imonth,iday
!     ---------------------------------------------------------------+--
!
      dimension month(12)
!
      data month/31,28,31,30,31,30,31,31,30,31,30,31/
      data ily /-1/
      save month,ily
!
!
      call cleayea_(iyear,ily)
!
      if(idoy.gt.365.and.ily.eq.0) then
            print*,'*** Rogralib/cdatdoy: idoy= ',idoy
            print*,'*** Rogralib/cdatdoy: iyear is not a leap year'
            print*,'                      no more than 365 day'
            call uperror_('cdatdoy: cdatdoy: iyear is not a leap year')
                                   endif
!
      if(idoy.lt.1) then
             print*,'*** Rogralib/cdatdoy: idoy= ',idoy
             print*,'*** Rogralib/cdatdoy: day of the year must be GT 0'
             call uperror_('cdatdoy: day of the year must be GT 0')
                    endif
!
      if(ily.eq.1) then
                   month(2)=29
                   else
                   month(2)=28
                   endif
!
      m=0
!
      do 10 im=1,12
      mp=m
      m=m+month(im)
      if(idoy.le.m) go to 20
   10 continue
   20 continue
!
      imonth=im
      iday=idoy-mp
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cdatj70_(jd70,iyear,imonth,iday)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_Julianday_1970_year_month_day integer values
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!                                 copy from Rocotlib, P. Robert, 1992
!
! *   input  : jd70  julian day 1970 (0= 1/1/1970)
! *   output : iyear,imonth,iday
!     ---------------------------------------------------------------+--
!
      data ily /-1/
      save ily
!
!
      jd1= -1
!
      do 10 iy=1970,3000
      call cleayea_(iy,ily)
      jdp=jd1
      if(ily.eq.1) then
                   jd1=jd1+366
                   else
                   jd1=jd1+365
                   endif
      if(jd1.ge.jd70) then
                      iyear=iy
                      go to 20
                      endif
!
   10 continue
      print*,'*** Rogralib/cdatj70: jd70= ',jd70
      print*,'*** Rogralib/cdatj70: jul. day correspond to year GT 3000'
      call uperror_('cdatj70: jul. day correspond to year GT 3000')
!
   20 continue
      jd=jd70-jdp
      call cdatdoy_(jd,iy,imonth,iday)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cdatsoy_(imonth,iday,iyear,ih,im,is,isoy)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_date_and_time to second of the year
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      dimension njn(12),njb(12)
      save njn,njb
!
      data njn/0,31,59,90,120,151,181,212,243,273,304,334/
      data njb/0,31,60,91,121,152,182,213,244,274,305,335/
!
      data epsi  /1.e-35/
      save epsi
!
!
      iyear_mod4=iyear/4
      rb=float(iyear)/4.-float(iyear_mod4)
!
      if(abs(rb).gt.epsi) then
                          nj=njn(imonth)
                          else
                          nj=njb(imonth)
                          endif
!
      isoy=is+im*60+ih*3600+iday*86400+nj*86400
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cdechex_(inu,hnu)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_decimal_to_hex
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*2 hnu
!
!
      inu1=inu/16
      if(inu1.le.9) then
                    hnu(1:1)=char(inu1+48)
                    else
                    hnu(1:1)=char(inu1+87)
                    endif
!
      inu2=inu-inu1*16
!
      if(inu2.le.9) then
                    hnu(2:2)=char(inu2+48)
                    else
                    hnu(2:2)=char(inu2+87)
                    endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cellarc_(x1,y1,x2,y2,a,b,xc,yc,tet1,tet2)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_elliptical_arc from 2 points and a,b
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      pi=acos(-1.)
      pisd=pi/180.
      bsa=b/a
!
! *** calcul de alpha=(tet1+tet2)/2 et beta=(tet1-tet2)/2
!     2 solutions pour alpha et beta
!
      alpha1= -atan(bsa*(x1-x2)/(y1-y2))
      alpha2= -atan(bsa*(x1-x2)/(y1-y2)) +pi
!
      r=sqrt( (b*cos(alpha1))**2 + (a*sin(alpha1))**2)
!
      call cvecmod_(x1-x2, y1-y2, 0., rmod)
!
      beta1=  asin(rmod/(2.*r))
      beta2= -asin(rmod/(2.*r))
!
! *** donc 4 solutions pour tet1 et tet2
!
      tet1a= (alpha1-beta1)
      tet2a= (alpha1+beta1)
!
      tet1b= (alpha1-beta2)
      tet2b= (alpha1+beta2)
!
      tet1c= (alpha2-beta1)
      tet2c= (alpha2+beta1)
!
      tet1d= (alpha2-beta2)
      tet2d= (alpha2+beta2)
!
! *** condition tet2 > tet1 pour elimination de solutions (ita=0)
!
      if(tet1a.gt.tet2a) then
                         ita=0
                         else
                         ita=1
                         endif
!
      if(tet1b.gt.tet2b) then
                         itb=0
                         else
                         itb=1
                         endif
!
      if(tet1c.gt.tet2c) then
                         itc=0
                         else
                         itc=1
                         endif
!
      if(tet1d.gt.tet2d) then
                         itd=0
                         else
                         itd=1
                         endif
!
! *** calcul du centre: 2 solutions x 4 pour teta
!
      xc1a= x1-a*cos(tet1a)
      yc1a= y1-b*sin(tet1a)
!
      xc2a= x2-a*cos(tet2a)
      yc2a= y2-b*sin(tet2a)
      if(abs(xc1a-xc2a).gt.0.0001.or.abs(yc1a-yc2a).gt.0.0001) ita=0
!
!
      xc1b= x1-a*cos(tet1b)
      yc1b= y1-b*sin(tet1b)
!
      xc2b= x2-a*cos(tet2b)
      yc2b= y2-b*sin(tet2b)
      if(abs(xc1b-xc2b).gt.0.0001.or.abs(yc1b-yc2b).gt.0.0001) itb=0
!
!
      xc1c= x1-a*cos(tet1c)
      yc1c= y1-b*sin(tet1c)
!
      xc2c= x2-a*cos(tet2c)
      yc2c= y2-b*sin(tet2c)
      if(abs(xc1c-xc2c).gt.0.0001.or.abs(yc1c-yc2c).gt.0.0001) itc=0
!
!
      xc1d= x1-a*cos(tet1d)
      yc1d= y1-b*sin(tet1d)
!
      xc2d= x2-a*cos(tet2d)
      yc2d= y2-b*sin(tet2d)
      if(abs(xc1d-xc2d).gt.0.0001.or.abs(yc1d-yc2d).gt.0.0001) itd=0
!
! *** choix des solutions; il ne doit en rester qu'une
!
      isol=0
!
      if(ita.eq.1) then
                   isol=isol+1
                   xc=xc1a
                   yc=yc1a
                   tet1=tet1a
                   tet2=tet2a
                   endif
!
      if(itb.eq.1) then
                   isol=isol+1
                   xc=xc1b
                   yc=yc1b
                   tet1=tet1b
                   tet2=tet2b
                   endif
!
      if(itc.eq.1) then
                   isol=isol+1
                   xc=xc1c
                   yc=yc1c
                   tet1=tet1c
                   tet2=tet2c
                   endif
!
      if(itd.eq.1) then
                   isol=isol+1
                   xc=xc1d
                   yc=yc1d
                   tet1=tet1d
                   tet2=tet2d
                   endif
!
      if(isol.eq.0) call uperror_('cellarc_:pas de solution !!!')
      if(isol.gt.1) call uperror_('cellarc_:plusieurs solutions !!! ')
!
      tet1=tet1/pisd
      tet2=tet2/pisd
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cfiggra_(xmin,xmax,x1,x2,bgx,sgx,fx)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_figure_graduations from xmin and xmax data
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) fx
!
      data rmax  /1.e+35/
      data epsi  /1.e-35/
      save rmax,epsi
!
!     calcule les parametres de graduation
!
      ll=len(fx)
      if(ll.lt.8) call uperror_('cfiggra_: format < 8 caracteres')
!
      xmi=xmin
      xma=xmax
!
      if(abs(xmi).lt.epsi) xmi=0.
      if(abs(xma).gt.rmax) xma=sign(rmax,xma)
!
      if(abs(xma-xmi).lt.epsi) then
           call upwarni_('cfiggra_: min and max of array are identical')
                               if(abs(xmi).lt.epsi) then
                                                    xmi=-1.e-31
                                                    xma= 1.e-31
                                                    else
                                                    xma=xmi*1.001
                                                    xmi=xmi*0.999
                                                    endif
                               endif
!
      call cgraste_(xmi,xma,bgx,sgx,x1,x2)
      call cgrafor_(x1,x2,bgx,fx)
      call uverfor_(fx,'cfiggra')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cfiggral(xmin,xmax, x1,x2)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_figure_graduations_log from xmin and xmax dat
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2011
!     ---------------------------------------------------------------+--
!
!
!     xmin, xmax : entree : extremas d'une fonction  representer en log
!                  sortie : extremas pour une figure logaritmique.
!                           x1= puissance de 10 <= xmin
!                           x2= puissance de 10 >= xmax
!
      if(xmin.le.0.)  call uperror_('cfiggral: xmin must be >0')
      if(xmax.le.0.)  call uperror_('cfiggral: xmax must be >0')

      call cmanexp_(xmin,rmi,iemin)
      call cmanexp_(xmax,rma,iemax)

! /// if(rmi.eq.0.1) iemin=iemin+1
!///  if(rma.eq.0.1) iemax=iemax-1
      if(abs(rma-0.1) .lt. 1.e-30) iemax=iemax-1
!
      call ctenpon_(iemin-1,x1)
      call ctenpon_(iemax,x2)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cfiggraa(x,n,x1,x2,bgx,sgx,fx)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_figure_graduations_array from 1 array x(n)
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      dimension x(n)
      character*(*) fx
!
!
! *** calcule les parametres de graduation de la courbe x(n)
!
!
      ll=len(fx)
      if(ll.lt.8) call uperror_('cfiggraa: format < 8 caracteres')
!
      call cminmax_(x,n,xmi,xma)
!
      call cfiggra_(xmi,xma,x1,x2,bgx,sgx,fx)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cfigpag_(fx,fy,px,py)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_figure_to_page_units
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      common /figlim/ x1,x2,y1,y2
      common /figsiz/ rx,ry
      common /figori/ xz,yz
      common /figsca/ ex,ey
      common /figout/ ifigout
      common /grasty/ logstx,logsty
!
!
      if(logstx.eq.0) then
                      px=xz+(fx-x1)/ex
                      else
                      px=xz+(log10(fx)-log10(x1))/ex
      endif

      if(logsty.eq.0) then
                      py=yz+(fy-y1)/ey
                      else
                      py=yz+(log10(fy)-log10(y1))/ey
      endif
!
! *** on empeche eventuellement de depasser les bords de la figure
!
      if(ifigout.eq.0) then
                       if(px.lt.xz) px=xz
                       if(py.lt.yz) py=yz
!
                       xf=xz+rx
                       yf=yz+ry
!
                       if(px.gt.xf) px=xf
                       if(py.gt.yf) py=yf
      endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cfonbod_(numfon,height,fonbod)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_font_body from fontyp number and height
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
! *** taile en cm pour la fonte 10 suivant le type
!
      if(numfon.ge.1.and.numfon.le. 4) hh= 98.2/500.
      if(numfon.ge.5.and.numfon.le. 8) hh=119.3/500.
      if(numfon.ge.9.and.numfon.le.12) hh=129.0/500.
      if(numfon.eq.13                ) hh=119.0/500.
!
! *** calcul du corps
!
      fonbod= 10.*height/hh
!
      if(abs(fonbod).gt.1000.) fonbod=1000.
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cfonnum_(fontyp,numfon)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_font_number from fontyp, as 7 for 'tital'
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) fontyp
      character*5 fonava(13)
      character*255 com
      save fonava,com
!
!
      call sdr_gfontyp(fonava,nbfon)
!
      lf= min(5,len(fontyp))
!
      do 10 i=1,nbfon
      if(fontyp(1:lf).eq.fonava(i)(1:lf)) go to 20
   10 continue
!
      write(com,100) (fonava(j),j=1,nbfon)
  100 format(20(a,', '))
      call cchalen_(com,ncom)
      call upwarni_('cfonnum_: Unknowed fontyp type, set to Courier')
      call upwarni_('cfonnum_: possible fontyps: '//com(1:ncom))
      numfon= 1
!
   20 continue
      numfon=i
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cfontyp_(numfon,fontyp)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_font_type from numfon as 'tital' for 7
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) fontyp
      character*5 fonava(13)
      save fonava
!
!
      call sdr_gfontyp(fonava,nbfon)
!
      fontyp=fonava(numfon)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cgrafor_(x1,x2,bgx,fx)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_graduations_format from axe's boundaries+big step
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) fx
      character*8 fx1,fx2,fx3
      character*1 if1,if2,if3,ifg
      save fx1,fx2,fx3, if1,if2,if3,ifg
!
      data epsi  /1.e-35/
      save epsi
!
! *** calcule le format des graduations d'apres x1,x2 et bgx
!
!
      ll=len(fx)
      if(ll.lt.8) call uperror_('cgrafor_: format <  8 caracteres')
      if(x1.gt.x2)         call uperror_('cgrafor_: x1 > x2')
      if((x2-x1) .lt.epsi) call uperror_('cgrafor_: x1 = x2')
      if(abs(bgx).lt.epsi) call uperror_('cgrafor_: bgx nul')
!
      nbsti=int((x2-x1)/bgx)
!
      a1=x1
      a2=x1+bgx
      a3=x1+float(nbsti)*bgx
!
      call cbesfor_(a1,fx1)
      call cbesfor_(a2,fx2)
      call cbesfor_(a3,fx3)
!
      call udecfor_(fx1,if1,n1,nd1)
      call udecfor_(fx2,if2,n2,nd2)
      call udecfor_(fx3,if3,n3,nd3)
!
      aama=amax1(abs(a1),abs(a2),abs(a3))
!
      if(abs(a1)/aama.lt.1.e-5) then
                                n1=0
                                nd1=0
                                if1='i'
                                endif
!
      if(abs(a2)/aama.lt.1.e-5) then
                                n2=0
                                nd2=0
                                if2='i'
                                endif
!
      if(abs(a3)/aama.lt.1.e-5) then
                                n3=0
                                nd3=0
                                if3='i'
                                endif
!
      n =max(n1,n2,n3)
      nd=max(nd1,nd2,nd3)
!
      ifg='i'
      if(if1.eq.'f'.or.if2.eq.'f'.or.if3.eq.'f') ifg='f'
      if(if1.eq.'e'.or.if2.eq.'e'.or.if3.eq.'e') ifg='e'

      imax=2147483647
      if(abs(x1).gt.float(imax) .or. abs(x2).gt.float(imax)) then
                    fx='(e10.3)'
                else
                    call uencfor_(fx,ifg,n,nd)
      endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cgraste_(x1,x2,bgx,sgx,x1a,x2a)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_graduations_steps from axe's boundaries
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /n_marques/ n_tick_min,n_tick_max
!
      data epsi  /1.e-35/
      data epsi2 /1.e-06/
      save epsi,epsi2
!
! *** calcule les graduations et arondi les bornes
!
!
      if(abs(x2-x1).lt.epsi) call uperror_('cgraste: x1=x2')
!
      if(x1*x2.ge.0.) go to 40
!
! ***  x1 negatif et x2 positif
!
      x1a=abs(x1)
      x2a=abs(x2)
      xsa=epsi
      if(x1a.gt.xsa) xsa=x1a
      if(x2a.gt.xsa) xsa=x2a
      if(xsa.lt.epsi) call uperror_('cgraste:1 for x1<0 and x2>0, then dx<epsilum')
      call cxtouim_(xsa)
      if(xsa.lt.epsi) call uperror_('cgraste:2 for x1<0 and x2>0, then dx<epsilum')
      call ucgraste(xsa,bgx,sgx)
!
      if(x1a.gt.x2a) then
                     x1a=sign(xsa,x1)
                     n=int(x2a/bgx)+1
                     x2a=float(n)*bgx
!
                     else
                     x2a=sign(xsa,x2)
                     n=int(x1a/bgx)+1
                     x1a=-float(n)*bgx
                     endif
      go to 80
!
   40 continue
!
! *** x1 et x2 meme signe
!
      if(abs(x2).gt.abs(x1)) go to 50
!
! *** x1 et x2 negatifs
!
      x1a=x1
      x2a=x2
      call cxtolim_(x1a)
!
!     salade sur la precision de la difference
!     on met x2a a la valeur donne par sa precision limitee a 4 chiffres
!
      dx=x2a-x1a
      call cxtouim_(dx)
      preci=dx/x1a
      call cmanexp_(preci,rman,ipreci)
      ipreci=iabs(ipreci)
      if(ipreci.gt.4) ipreci=4
      x2a=x1a+dx
      call cxtogpr_(x2a,ipreci)
!
!     recalcul de dx avec un x2a a 4 chiffres seulement
!
      dx=x2a-x1a
      call cxtouim_(dx)
      if(dx.lt.epsi) call uperror_('cgraste:3 for x1<0 and x2<0, then dx<epsilum')
      call ucgraste(dx,bgx,sgx)
      go to 80
!
   50 continue
!
! *** x1 et x2 positifs
!
      x1a=x1
      x2a=x2
      call cxtouim_(x2a)
!
!     salade sur la precision de la difference
!     on met x1a a la valeur donne par sa precision limitee a 4 chiffres
!
      dx=x2a-x1a
! /// dbug print*, 'cgraste 1 :x1,x2,x2a,dx=',x1,x2,x2a,dx
      call cxtouim_(dx)
! /// dbug print*, 'cgraste 2 :dx,preci,ipreci,x1a=',dx,preci,ipreci,x1a
      preci=dx/x2a
      call cmanexp_(preci,rman,ipreci)
      ipreci=iabs(ipreci)
      if(ipreci.gt.4) ipreci=4
      x1a=x2a-dx
      call cxtogpr_(x1a,ipreci)
!
!     recalcul de dx avec un x1a a 4 chiffres seulement
!
      dx=x2a-x1a
      call cxtouim_(dx)
      if(dx.lt.epsi) call uperror_('cgraste:4 for x1>0 and x2>0, then dx<epsilum')
      call ucgraste(dx,bgx,sgx)
!
   80 continue
!
! *** ajustement fin des bornes commun aux 3 possibilites
!
!
! *   on enleve les grandes marques inutiles
!
      n1=int((x1-x1a)/bgx+epsi2)
      n2=int((x2a-x2)/bgx+epsi2)
!
      x1a=x1a+float(n1)*bgx
      x2a=x2a-float(n2)*bgx
!
      ngm=int((x2a-x1a)/bgx+epsi2)
!
! *   si on n'a pas assez de grandes marques, on recalcule bgx et sgx
!     et re-ajustement fin
!
      if(ngm.lt.n_tick_min) then
                   bgx1=bgx*2.
                   call ucgraste(bgx1,bgx,sgx)
!
                   n1=int((x1-x1a)/bgx+epsi2)
                   n2=int((x2a-x2)/bgx+epsi2)
!
                   x1a=x1a+float(n1)*bgx
                   x2a=x2a-float(n2)*bgx
!
                   ngm=int((x2a-x1a)/bgx+epsi2)
                   endif
!
! *   si on a trop de grandes marques, on recalcule bgx et sgx
!     et re-ajustement fin
!
      if(ngm.gt.n_tick_max) then
                   bgx=bgx*2.
                   sgx=sgx*2.
!
                   n1=int((x1-x1a)/bgx+epsi2)
                   n2=int((x2a-x2)/bgx+epsi2)
!
                   x1a=x1a+float(n1)*bgx
                   x2a=x2a-float(n2)*bgx
!
                   ngm=int((x2a-x1a)/bgx+epsi2)
                   endif
!     Si on n'a qu'une grande marque, on recalcule bgx et sgx
!     et re-ajustement fin
      if(ngm.eq.1) then
                   bgx1=bgx
                   call ucgraste(bgx1,bgx,sgx)
                   bgx=bgx*2.
                   sgx=sgx*2.
!
                   n1=int((x1-x1a)/bgx+epsi2)
                   n2=int((x2a-x2)/bgx+epsi2)
!
                   x1a=x1a+float(n1)*bgx
                   x2a=x2a-float(n2)*bgx
!
                   ngm=int((x2a-x1a)/bgx+epsi2)
!
! *                re-belote si une seule grande marque, mais  on  ne
!                  fait pas de re-ajustement des bornes
!
                   if(ngm.eq.1) then
                                bgx2=bgx
                                call ucgraste(bgx2,bgx,sgx)
                                ngm=int((x2a-x1a)/bgx+epsi2)
                                endif
                   endif
!
! *   test si ngm est bien >0
!
      if(ngm.lt.1) then
                   x1a=x1a-bgx
                   x2a=x2a+bgx
                   call upwarni_('Number of big sticks < 1 in cgraste_')
                   return
                   endif
!
! *   on a bien ngm >1, on gratte les petites marques de la borne sup.
!
      nsginu=int((x2a-x2)/sgx +epsi2)
      x2a=x2a-float(nsginu)*sgx
!
!     on evite que le maximum touche le haut: ecart de 4% minimum
!
      dmin=0.04*(x2a-x1a)
      dact=x2a-x2
      if(dact.lt.dmin) then
                           nsg=int(dmin/sgx +0.5)
                           nsg=max(nsg,1)
                           nsg=min(nsg,9)
                           x2a=x2a+float(nsg)*sgx
                           endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cgrasts_(x1,x2,bgx,sgx,x1a,x2a)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_graduations_steps_simple with x2a=-x1a=bgx
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
! *** calcule les graduations et arondi les bornes x1a=-x2a
!
      data epsi  /1.e-35/
      save epsi
!
      if(abs(x2-x1).lt.epsi) call uperror_('cgrasts: x1=x2')
      call cgraste_(x1,x2,bgx,sgx,x1a,x2a)
!
      if(abs(x1a).gt.bgx) bgx=abs(x1a)
      if(abs(x2a).gt.bgx) bgx=abs(x2a)
      sgx=bgx/2.
      x1a=-bgx
      x2a= bgx
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine chsbrgb_(hue,sat,bri,r,g,b)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_hsb_to_rgb
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      rhue=hue
      rsat=sat
      rbri=bri
!
      call ubounds_(rhue,0.,1.)
      call ubounds_(rsat,0.,1.)
      call ubounds_(rbri,0.,1.)
!
      if(rsat.lt.1.e-20) then
                        r=rbri
                        g=rbri
                        b=rbri
                        return
                        endif
!
! *** modif PR par rapport a l'algo de base pour que on ait bien
!     chsbrvb * crvbhsb reciproque
!
      rbri2=rbri/2.
!
      if(rbri2.lt.0.5) then
                     rm2=rbri2*(1.+rsat)
                     else
                     rm2=rbri2 +rsat -rbri2*rsat
                     endif
!
      rm1=2.*rbri2 - rm2
!
      call uhuergb_(rm1,rm2,rhue+1./3.,r)
      call uhuergb_(rm1,rm2,rhue      ,g)
      call uhuergb_(rm1,rm2,rhue-1./3.,b)
!
! XX     call ubounds_(r,0.,1.)
! XX     call ubounds_(g,0.,1.)
! XX     call ubounds_(b,0.,1.)
!
!
! *** autre methode - marche que pour S=1 ou 0
!
! /// unti=1./3.
! /// pisd=3.1415927/180.
! /// hdeg=rhue*360.
!
! /// if(hdeg.le.120.) then
! ///               b=unti*(1-rsat)
! ///               r=unti*(1.+rsat*cos(hdeg*pisd)/cos((60.-hdeg)*pisd))
! ///               g= 1-(b+r)
!
! ///               r=r*bri
! ///               g=g*bri
! ///               b=b*bri
! ///               return
! ///               endif
!
! /// if(hdeg.le.240.) then
! ///               hdeg=hdeg-120.
! ///               r=unti*(1-rsat)
! ///               g=unti*(1.+rsat*cos(hdeg*pisd)/cos((60.-hdeg)*pisd))
! ///               b= 1-(r+g)
!
! ///               r=r*bri
! ///               g=g*bri
! ///               b=b*bri
! ///               return
! ///               endif
!
! /// if(hdeg.le.360.) then
! ///               hdeg=hdeg-240.
! ///               g=unti*(1-rsat)
! ///               b=unti*(1.+rsat*cos(hdeg*pisd)/cos((60.-hdeg)*pisd))
! ///               r= 1-(g+b)
!
! ///               r=r*bri
! ///               g=g*bri
! ///               b=b*bri
! ///               return
! ///               endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cicorgb_(ico,ir,ig,ib)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_ico_to_rgb ico [0-16777215] ir,ig,ib [0-255]
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!     ex: pour ico=8332313 -> (ir,ig,ib)=(127,36,25)
!
      ir= ico/65536
      ig=(ico - ir*65536)/256
      ib= ico - ir*65536 - ig*256
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cimahsy_(ima,nx,ny)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_image_to_horizontal_symetrie
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      integer ima(nx,ny)
!
!
      nx2=nx/2
!
      do 10 ix=1,nx2
      jx=nx+1-ix
!
      do 10 iy=1,ny
      isave=ima(ix,iy)
      ima(ix,iy)=ima(jx,iy)
      ima(jx,iy)=isave
   10 continue
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cimasizc(cima,nxmax,nx,ny)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_image_size_character cima(nxmax,ny) ->cima(nx,ny)
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!     permet d'utiliser un tableau dimensionne a (nx,ny) dans une
!     subrout. alors qu'il est dimensionne a (nxmax,nymax) dans le
!     programme principal. Il ne peut plus ensuite etre utilise
!     normalement dans le programme principal.
!     Utile en F77 seulment, quand pas de memoire dynamique.
!
      character*(*) cima(nxmax*ny)
!
!
      kt=0
      kr=0
!
      do j=1,ny
      do i=1,nxmax
      kt=kt+1
      if(i.le.nx) then
                  kr=kr+1
                  cima(kr)=cima(kt)
                  endif
      enddo
      enddo
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cimasizi(iima,nxmax,nx,ny)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_image_size_integer iima(nxmax,ny) to iima(nx,ny)
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!     permet d'utiliser un tableau dimensionne a (nx,ny) dans une
!     subrout. alors qu'il est dimensionne a (nxmax,nymax) dans le
!     programme principal. Il ne peut plus ensuite etre utilise
!     normalement dans le programme principal.
!     Utile en F77 seulment, quand pas de memoire dynamique.
!
      integer iima(nxmax*ny)
!
!
      kt=0
      kr=0
!
      do j=1,ny
      do i=1,nxmax
      kt=kt+1
      if(i.le.nx) then
                  kr=kr+1
                  iima(kr)=iima(kt)
                  endif
      enddo
      enddo
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cimasizr(rima,nxmax,nx,ny)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_image_size_real  rima(nxmax,ny) to rima(nx,ny)
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!     permet d'utiliser un tableau dimensionne a (nx,ny) dans une
!     subrout. alors qu'il est dimensionne a (nxmax,nymax) dans le
!     programme principal. Il ne peut plus ensuite etre utilise
!     normalement dans le programme principal.
!     Utile en F77 seulment, quand pas de memoire dynamique.
!
      real rima(nxmax*ny)
!
!
      kt=0
      kr=0
!
      do j=1,ny
      do i=1,nxmax
      kt=kt+1
      if(i.le.nx) then
                  kr=kr+1
                  rima(kr)=rima(kt)
                  endif
      enddo
      enddo
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cleayea_(iyear,ileap)
!
!
!     ---------------------------------------------------------------+--
! *   Object : compute_leap_year with ileap=1 for leap year, 0 if not
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!                                 copy from Rocotlib, P. Robert, 1992
!
! *   input  : iyear (ex: 1980)
! *   output : ileap (1 or 0 if iyear is or not a leap year)
!     ---------------------------------------------------------------+--
!
      if(iyear.lt.1900) then
                    print*,'*** Rogralib/cleayea_: iyear= ',iyear
                    print*,'*** Rogralib/cleayea_: iyear must be > 1900'
                    call uperror_('cleayea_: iyear must be > 1900')
                        endif
!
      ir=iyear-(iyear/4)*4
      if(ir.eq.0) then
                  ileap=1
                  else
                  ileap=0
                  endif
!
      is=iyear-(iyear/100)*100
      if(is.eq.0) then
                  ir=iyear-(iyear/400)*400
                  if(ir.eq.0) then
                              ileap=1
                              else
                              ileap=0
                              endif
                  else
                  return
                  endif
!
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cmanexp_(x,rma,ie)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_mantisse_and_exponent
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
! *   revision 2007 pour les valeurs negatives
!
      data epsi  /1.e-36/
      save epsi
!
!
      if(abs(x).lt.epsi) then
                         rma=0.
                         ie=0
                         return
                         endif
!
      xx=abs(x)
      if(xx.gt.1.) then
                   ie=int(alog10(xx))+1
                   else
                   ie=int(alog10(xx))
                   endif
! /// dbug    print*, 'cmanexp 1 : x,xx,ie=',x,xx,ie
!
      call ctenpon_(ie,die)
! /// dbug    print*, 'cmanexp 2 : ie,die=',ie,die
!
      rma=xx/die
!
      if(rma.lt.0.1) then
                     rma=rma*10.
                     ie=ie-1
                     endif
!
      if(rma.ge.1.) then
                    rma=rma/10.
                    ie=ie+1
                    endif
!
      rma=sign(rma,x)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cmatlim_(rma,nx,ny,rmamin,rmamax)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_matrice_limits of rma(nx,ny)
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      real rma(nx,ny)
!
      data rmax  /1.e+35/
      data epsi  /1.e-35/
      save rmax,epsi
!
      rmamin=  rmax
      rmamax= -rmax
!
      do 10 ix=1,nx
      do 10 iy=1,ny
      if(rma(ix,iy).lt.rmamin) rmamin=rma(ix,iy)
      if(rma(ix,iy).gt.rmamax) rmamax=rma(ix,iy)
   10 continue
!
      sdx=rmamax-rmamin
      adx=abs(sdx)
      if(adx.lt.epsi) then
                call upwarni_('cmatlim_: min & max of array identical')
                 print*, 'min=',rmamin,' max=',rmamax
                 if(abs(rmamin).lt.epsi) rmamin=0.
                 rmamax=rmamin*1.01
                 print*, 'tooked values min=',rmamin,' max=',rmamax
                 print*
                 endif
!
      if(sdx.lt.0.) then
                    call upwarni_('cmatlim_: min greater than max')
                    print*, 'min=',rmamin,' max=',rmamax
                    if(abs(rmamin).lt.epsi) rmamin=0.
                    rmamax=rmamin*1.01
                    print*, 'tooked values min=',rmamin,' max=',rmamax
                    print*
                    endif
!
      if(abs(rmamin-rmax).lt.epsi) call uperror_('cminma2: xmin unknowed')
      if(abs(rmamax+rmax).lt.epsi) call uperror_('cminma2: xmax unknowed')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cmatlimp(rma,nx,ny,rmamin,rmamax,ixmi,iymi,ixma,iyma)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_matrice_limits_positions of rma(nx,ny)
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      real rma(nx,ny)
!
      data rmax  /1.e+35/
      data epsi  /1.e-35/
      save rmax,epsi
!
      rmamin=  rmax
      rmamax= -rmax
!
      do 10 ix=1,nx
      do 10 iy=1,ny
      if(rma(ix,iy).lt.rmamin) then
                               rmamin=rma(ix,iy)
                               ixmi=ix
                               iymi=iy
                               endif
      if(rma(ix,iy).gt.rmamax) then
                               rmamax=rma(ix,iy)
                               ixma=ix
                               iyma=iy
                               endif
   10 continue
!
      sdx=rmamax-rmamin
      adx=abs(sdx)
      if(adx.lt.epsi) then
                call upwarni_('cmatlimp: min & max of array identical')
                 print*, 'min=',rmamin,' max=',rmamax
                 if(abs(rmamin).lt.epsi) rmamin=0.
                 rmamax=rmamin*1.01
                 print*, 'tooked values min=',rmamin,' max=',rmamax
                 print*
                 endif
!
      if(sdx.lt.0.) then
                    call upwarni_('cmatlimp: min greater than max')
                    print*, 'min=',rmamin,' max=',rmamax
                    if(abs(rmamin).lt.epsi) rmamin=0.
                    rmamax=rmamin*1.01
                    print*, 'tooked values min=',rmamin,' max=',rmamax
                    print*
                    endif
!
      if(abs(rmamin-rmax).lt.epsi) call uperror_('cminma2: xmin unknowed')
      if(abs(rmamax+rmax).lt.epsi) call uperror_('cminma2: xmax unknowed')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cminmax_(ax,n,axmin,axmax)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_mini_maxi of array ax(n)
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      real ax(n)
!
      data rmax  /1.e+35/
      data epsi  /1.e-35/
      save rmax,epsi
!
!
      axmin= rmax
      axmax=-rmax
!
      kmin=0
      kmax=0
!
      do 10 i=1,n
      if(ax(i).lt.axmin) then
                         axmin=ax(i)
                         kmin=1
                         endif
      if(ax(i).gt.axmax) then
                         axmax=ax(i)
                         kmax=2
                         endif
   10 continue
!
      if(kmin.eq.0.or.kmax.eq.0) then
                 call upwarni_('cminmax: min et max of array undefined')
                 print*, 'array content undefined, set to zero'
                 print*, 'min and max set to 0. and 1.e-30'
                 axmin=0.
                 axmax=1.e-30
                 do 20 i=1,n
                 ax(i)=0.
   20            continue
                 return
                                 endif
!
!
      sdx=axmax-axmin
      adx=abs(sdx)
      if(adx.lt.epsi) then
                 call upwarni_('cminmax: min et max of array identical')
                 print*, 'min=',axmin,' max=',axmax
                 if(abs(axmin).lt.epsi) axmin=0.
                 axmax=axmin+epsi*1.e6
                 print*, 'tooked values min=',axmin,' max=',axmax
                 print*
                 endif
!
      if(sdx.lt.0.) then
                    call upwarni_('cminmax: min greater than max')
                    print*, 'min=',axmin,' max=',axmax
                    if(abs(axmin).le.epsi) then
                                           axmin=0.
                                           axmax=epsi
                                           else
                                           axmax=axmin+abs(axmin)
                                           endif
                    print*, 'tooked values min=',axmin,' max=',axmax
                    print*
                    endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cmodpha_(cbx,rmx,rpx)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_module_phase of oa complex number
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      complex cbx
!
      pisd=acos(-1.)/180.
!
      rmx=cabs(cbx)
!
      rpx=atan2(aimag(cbx),real(cbx))/pisd
!
      if(rmx.lt.1.e-36) rpx=0.
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cmoncar_(imonth,cmonth)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_month_number_to_char 3-> 'March' (cmonth*9)
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) cmonth
      character*9   cmon12(12)
      save cmon12
!
      data cmon12/'January','February','March','April','May','June',&
                  'July','August','September','October','November','December'/
!
      im=imonth
      if(im.lt. 1) im= 1
      if(im.gt.12) im=12
!
      cmonth=cmon12(im)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cpagfig_(px,py,fx,fy)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_page_to_figure_units
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /figlim/ x1,x2,y1,y2
      common /figori/ xz,yz
      common /figsca/ ex,ey
      common /grasty/ logstx,logsty
!
!
      if(logstx.eq.0) then
                      fx=x1+(px-xz)*ex
                      else
                      fx=x1+(log10(px)-log10(xz))*ex
      endif

      if(logsty.eq.0) then
                      fy=y1+(py-yz)*ey
                      else
                      fy=y1+(log10(py)-log10(yz))*ey
      endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cplarot_(xc,yc,angle,x1,y1,x2,y2)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_plane_rotation from center and angle
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      data epsi  /1.e-35/
      save epsi
!
      pisd=acos(-1.)/180.
!
      if(abs(x1-xc).lt.epsi.and.abs(y1-yc).lt.epsi) then
                                                    x2=x1
                                                    y2=y1
                                                    return
                                                    endif
!
      st=sin(angle*pisd)
      ct=cos(angle*pisd)
!
      xp=x1-xc
      yp=y1-yc
!
      r=sqrt(xp*xp + yp*yp)
!
      sa=yp/r
      ca=xp/r
!
      sapt=sa*ct + st*ca
      capt=ca*ct - sa*st
!
      x2=r*capt + xc
      y2=r*sapt + yc
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cpolcar_(r,teta,x,y)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_polar_to_cartesian degrees
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      pisd=acos(-1.)/180.
!
!
      tetar=teta*pisd
      x=r*cos(tetar)
      y=r*sin(tetar)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cranval_(ranval)
!
!     ---------------------------------------------------------------0--
! *   Object : compute_random_value between 0. and 1.
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------0--
!
!     ------------------------------------------------------------------
!     BY P.W.DALY, patch the RANDOM function to portable RANDIM
!     modified P. Robert, september 1994
!     output: ranval between 0. and 1.
!     ------------------------------------------------------------------
!     Random Number Generators
!     From Numerical Recipes chapter 7.1
!
!     modified P. robert, september 1994
!
!     RANDIM(idum)  -  portable (i.e. machine independent)
!                      no sequential correlations
!                      virtually infinite period
!                      high and low order done separately
!                      BUT is relatively slow
!
!     Routines return a uniform random deviate between 0.0 and 1.0.
!     Set IDUM to any negative value to initialize or reinitialize the
!     sequence.
!     ------------------------------------------------------------------
!
      dimension r(97)
      parameter (m1=259200,ia1=7141,ic1=54773)
      parameter (m2=134456,ia2=8121,ic2=28411)
      parameter (m3=243000,ia3=4561,ic3=51349)
!
      save r, ix1,ix2,ix3
      save idum, iff
!
! *** modi intro PR pour eviter l'argument idum
!
      data idum /-2/, iff /0/
!
      idum=idum+1
!
      rm1=1./float(m1)
      rm2=1./float(m2)
!
! *** fin de modif
!
      if(idum.lt.0.or.iff.eq.0) then
        iff=1
        ix1=mod(ic1-idum,m1)
        ix1=mod(ia1*ix1+ic1,m1)
        ix2=mod(ix1,m2)
        ix1=mod(ia1*ix1+ic1,m1)
        ix3=mod(ix1,m3)
!
        do 10 j=1,97
          ix1=mod(ia1*ix1+ic1,m1)
          ix2=mod(ia2*ix2+ic2,m2)
          r(j)=(float(ix1)+float(ix2)*rm2)*rm1
   10  continue
!
        idum=1
      endif
!
      ix1=mod(ia1*ix1+ic1,m1)
      ix2=mod(ia2*ix2+ic2,m2)
      ix3=mod(ia3*ix3+ic3,m3)
      j=1+(97*ix3)/m3
      if(j.gt.97.or.j.lt.1) stop '*** pb cranval_, j.gt.97.or.j.lt.1'
      ranval=r(j)
      r(j)=(float(ix1)+float(ix2)*rm2)*rm1
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine crgbhsb_(r,g,b,hue,sat,bri)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_rgb_to_hsb all [0.-1.]
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      rr=r
      gg=g
      bb=b
      epsi2=1.e-6
      hue=99.99
      sat=99.99
      bri=99.99
!
      call ubounds_(rr,0.,1.)
      call ubounds_(gg,0.,1.)
      call ubounds_(bb,0.,1.)
!
      c1=min(rr,gg,bb)
      c2=max(rr,gg,bb)
!
      bri=(c1+c2)/2.
!
      if(abs(c2-c1).lt.epsi2) then
!                             *** couleur indefinie
                              sat=0.
                              hue=0.
                              return
                              endif
!
      if(bri.lt.0.5) then
                     sat=(c2-c1)/(c2+c1)
                     else
                     sat=(c2-c1)/(2.-c2-c1)
                     endif
!
      if(abs(rr-c2).lt.epsi2) then
                              hue=(gg-bb)/(c2-c1)
                              else
                        if(abs(gg-c2).lt.epsi2) then
                                                hue=2. + (bb-rr)/(c2-c1)
                                                else
                                                hue=4. + (rr-gg)/(c2-c1)
                                                endif
                               endif
!
      hue=hue/6.
      if(hue.lt.0.) hue=hue+1.
!
! *** modif PR
      bri=2.*bri
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine crgbico_(ir,ig,ib,ico)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_rgb_to_ico ir,ig,ib [0-255] ico [0-16777215]
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!     ex: pour (ir,ig,ib)=(127,36,25) -> ico=8332313
!
!     ico est le numero de la couleur parmis les 16 M (256**3)
!
      call uboundi_(ir,0,255)
      call uboundi_(ig,0,255)
      call uboundi_(ib,0,255)
!
      ico= 65536*ir + 256*ig + ib
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cscahis_(sca,nx,ny,scamin,scamax,isto,n)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_scalar_istogramme of sca(nx,ny) for n levels
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      real      sca(nx,ny)
      integer  isto(n)
!
!
      do 10 ih=1,n
      isto(ih)=0
   10 continue
!
! *** calcul de l'histogramme de l'image
!
      scalong=scamax-scamin
      if(scalong.lt.1.e-30) call uperror_('cscahis_: max .le. min')
!
      do 20 ix=1,nx
      do 20 iy=1,ny
!
      niv=int(((sca(ix,iy)-scamin)/scalong )*float(n-1)) +1
      if(niv.lt.1) niv=1
      if(niv.gt.n) niv=n
!
      do 30 ih=1,n
      if(niv.eq.ih) isto(ih)=isto(ih)+1
   30 continue
   20 continue
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cscaima_(sca,nx,ny,scamin,scamax,ima,sbla,swhi)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_scalar_to_image sca(nx,ny),ima(nx,ny) (ico unit)
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /colmap/ hueu,satu,briu,nbcolu
!
      real hueu(256),satu(256),briu(256)
!
      real    sca(nx,ny)
      integer ima(nx,ny), ico(256)
      save ico
!
!     On etale l'image entre les valeurs scamin et scamax de sca(nx,ny)
!     On met en noir  ce qui est inferieur a sbla (seuil du black)
!     On met en blanc ce qui est superieur a swhi (seuil du white)
!     pas de noir et blanc si sbla=swhi
!     swhi-sbla doit etre > nb. of colors
!
! *** conversion de la colormap courante en rgb
!
      do 10 i=1,nbcolu
!
      call chsbrgb_(hueu(i),satu(i),briu(i),r,g,b)
!
      ir=int(r*255.)
      ig=int(g*255.)
      ib=int(b*255.)
!
      call crgbico_(ir,ig,ib,ico(nbcolu+1-i)) ! voir le sens bleu->rouge
!
   10 continue
!
! *** valeurs du noir et du blanc
!
      call crgbico_(  0,  0,  0,inoir)
      call crgbico_(255,255,255,iblan)
!
! *** calcul de l'image sur scamin a scamax
!     valeurs hors sbla a swhi en noir ou blanc
!
      scalong=scamax-scamin
      if(scalong.lt.1.e-30) call uperror_('cscaima_: max .le. min')
!
      do 20 ix=1,nx
      do 20 iy=1,ny
!
      niv=int(((sca(ix,iy)-scamin)/scalong )*float(nbcolu-1)) +1
!
      if(niv.lt. 1) niv= 1
      if(niv.gt.nbcolu) niv=nbcolu
      ima(ix,iy)=ico(niv)
!
!      if(swhi.lt.scamax .or. sbla.gt.scamin) then
!             print*, '*** scawhi=',swhi,  ' scabla=',sbla
!             print*, '    scamax=',scamax,' scamin=',scamin
!             call uperror_('cscaima_: scawhi < scamax or scabla > scamin')
!      endif

      if(sca(ix,iy).lt.sbla) ima(ix,iy)=inoir
      if(sca(ix,iy).gt.swhi) ima(ix,iy)=iblan

!
   20 continue
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cscaima2(sca,nx,ny,scamin,scamax,ima,swhi,sbla)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_scalar_to_image sca(nx,ny),ima(nx,ny) (ico unit)
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2021
!     ---------------------------------------------------------------+--
!
      common /colmap/ hueu,satu,briu,nbcolu
!
      real hueu(256),satu(256),briu(256)
!
      real    sca(nx,ny)
      integer ima(nx,ny), ico(256)
      save ico
!
! ** inverse de cscaima pour le noir et le blanc
!
!     On etale l'image entre les valeurs scamin et scamax de sca(nx,ny)
!     On met en blanc  ce qui est inferieur a swhi (seuil du white)
!     On met en noir ce qui est superieur a sbla (seuil du black)
!     pas de noir et blanc si sbla=swhi
!     sbla-swhi
! *** conversion de la colormap courante en rgb
!
      do 10 i=1,nbcolu
!
      call chsbrgb_(hueu(i),satu(i),briu(i),r,g,b)
!
      ir=int(r*255.)
      ig=int(g*255.)
      ib=int(b*255.)
!
      call crgbico_(ir,ig,ib,ico(nbcolu+1-i)) ! voir le sens bleu->rouge
!
   10 continue
!
! *** valeurs du noir et du blanc
!
      call crgbico_(  0,  0,  0,inoir)
      call crgbico_(255,255,255,iblan)
!
! *** calcul de l'image sur scamin a scamax
!     valeurs hors sbla a swhi en noir ou blanc
!
      scalong=scamax-scamin
      if(scalong.lt.1.e-30) call uperror_('cscaima2: max .le. min')
!
      do 20 ix=1,nx
      do 20 iy=1,ny
!
      niv=int(((sca(ix,iy)-scamin)/scalong )*float(nbcolu-1)) +1
!
      if(niv.lt. 1) niv= 1
      if(niv.gt.nbcolu) niv=nbcolu
      ima(ix,iy)=ico(niv)
!
!      if(sbla.lt.scamax .or. swhi.gt.scamin) then
!             print*, 'sbla,scamax=',sbla,scamax
!             print*, 'swhi,scamin=',swhi,scamin
!             call uperror_('cscaima2: scawhi > scamin or scabla < scamax')
!      endif

      if(sca(ix,iy).lt.swhi) ima(ix,iy)=iblan
      if(sca(ix,iy).gt.sbla) ima(ix,iy)=inoir

!
   20 continue
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cscalog_(sca,nx,ny,valzer,valneg)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_scalar_image_to_log_values
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      real sca(nx,ny)
      real valzer,valneg
!
!
! *** le passage en log n'est possible que pour sca <1.e-20
!     on peut imposer des valeurs pour sca=0 et sca <0
!     sca(nx,ny)=alog10(sca(nx,ny))
!
      do 10 ix=1,nx
      do 10 iy=1,ny
      if(sca(ix,iy).gt.1.e-20) then
                               sca(ix,iy)=alog10(sca(ix,iy))
                               else
                               if(sca(ix,iy).lt.0.) then
                                                    sca(ix,iy)= valneg
                                                    else
                                                    sca(ix,iy)= valzer
                                                    endif
                               endif
   10 continue
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cscamul_(sca,nx,ny,rmul)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_scalar_image_to_sca*rmul
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      real sca(nx,ny)
!
!     sca(nx,ny)=sca(nx,ny)*rmul
!
      do 10 ix=1,nx
      do 10 iy=1,ny
      sca(ix,iy)=sca(ix,iy)*rmul
   10 continue
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cscasli_(sca,nx,ny,scamin,scamax,pcmin,pcmax)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_scalar_significant_min_max sca(nx,ny) %min, %max
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      real sca(nx,ny)
      integer isto(20)
!
      data nhis /20/
      save isto,nhis
!
! *** calcul des min et max significatif pour le calcul
!     d'une image et sa visualisation
!
! *** calcul des min et max vrais
!
      call cmatlim_(sca,nx,ny,scamin,scamax)

      if(abs(scamax-scamin).lt.1.e30) return

      call cscahis_(sca,nx,ny,scamin,scamax,isto,nhis)
!
! *** calcul du nb de points de l'histrogramme
!
      nbp=0
!
      do 10 i=1,nhis
      nbp=nbp+isto(i)
   10 continue
!
      nbmin= int(float(nbp)*pcmin/100.)
      nbmax= int(float(nbp)*pcmax/100.)
      dx= (scamax-scamin)/float(nhis)
!
! *** elimination des premieres colonnes de l'histogramme
!     si elles ne contiennent pas assez de points
!     (moins de percen % du total)
!
      do 20 i=1,nhis
      if(isto(i).lt.nbmin) then
                           scamin=scamin+dx
                           else
                           go to 30
                           endif
   20 continue
   30 continue
!
      do 40 i=1,nhis
      if(isto(nhis-i+1).lt.nbmax) then
                                  scamax=scamax-dx
                                  else
                                  go to 50
                                  endif
   40 continue
   50 continue
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine csigdig_(x,nosd)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_significant_digits for a real number
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*15 mot
      save mot
!
! *** calcule le nb. de chiffre significatif  de x (max 6)
!
!
      call cmanexp_(x,rma,ie)
!
      write(mot,1) rma
!
! ///      if(mot(10:10).eq.'9') then
! ///                            if(x.gt.0.) x=x +0.1e-6*(10.**ie)
! ///                            if(x.lt.0.) x=x -0.1e-6*(10.**ie)
! ///                            call cmanexp_(x,rma,ie)
! ///                            write(mot,1) rma
! ///                            endif
!
      do 10 i=1,6
      nosd=7-i
      ii=10-i
      if(mot(ii:ii).ne.'0') return
   10 continue
!
    1 format(f9.6)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine csor3ra_(ar0,ar1,ar2,n,n1,n2,isens)
!
!     ---------------------------------------------------------------0--
! *   Object : compute_sorting_of_3_real_array ar1,ar2 associated to ar0
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------0--
!
      real ar0(n), ar1(n), ar2(n)
      real olar0 , olar1 , olar2
!
      character*80 com
      save com
!
!
!     ar0 est le tableau a trier
!     ar1 est un 1er  tableaux associe a rearranger
!     ar2 est un 2eme tableaux associe a rearranger
!     n est la dimension des tableaux
!     n1 est l'indice de depart de ar0
!     n2 est l'indice de fin
!     isens= 1 tri ascendant
!     isens=-1 tri descendant
!
!
      if(n1.lt.1) n1=1
      if(isens.ne.1.and.isens.ne.-1) then
                                     write(com,100) isens
                                     call uperror_(com)
                                     endif
!
  100 format('csor3ra_: code de tri illegal',i3,' doit etre +/-1')
!
!
      n2m1=n2 - 1
!
      do 1 io=n1,n2m1
      iop1=io + 1
!
      do 2 ki=iop1,n2
      if(isens.eq.-1) then
                      if(ar0(io).le.ar0(ki)) then
                                             go to 5
                                             else
                                             go to 2
                                             endif
                      else
                      if(ar0(io).le.ar0(ki)) then
                                             go to 2
                                             else
                                             go to 5
                                             endif
                      endif
!
    5 olar0  =ar0(io)
      ar0(io)=ar0(ki)
      ar0(ki)=olar0
!
      olar1  =ar1(io)
      ar1(io)=ar1(ki)
      ar1(ki)=olar1
!
      olar2  =ar2(io)
      ar2(io)=ar2(ki)
      ar2(ki)=olar2
!
    2 continue
    1 continue
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine csoydat_(isoy,imonth,iday,nbyear,ih,im,is)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_second_of_the_year to date and time
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      dimension nj(12)
!
      data nj /0,31,59,90,120,151,181,212,243,273,304,334/
      save nj
!
!      on suppose l'annee non bissextile
!
      nbyear =isoy/(365*24*3600)
      tt=float(isoy-3600*24*365*nbyear)
!
      nbday =int(tt/(24.*3600.))
      tt=tt-24.*3600.*float(nbday)
!
      ih  =int(tt/3600.)
      tt=tt-3600.*float(ih)
!
      im  =int(tt/60.)
      tt=tt-60.*float(im)
!
      is  =int(tt)
!
      do 10 i=2,12
      if(nbday.le.nj(i)) then
                         imonth=i-1
                         iday=nbday-nj(imonth)
                         return
                         endif
   10 continue
!
      call uperror_('csoydat_: parametres d''entree incorrects')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine csphcar_(r,teta,phi,x,y,z)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_spherical_to_cartesian degrees
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      pisd=acos(-1.)/180.
!
!
! *** conversion de coordonnees spheriques en cartesiennes
!
!
      x=r*sin(teta*pisd)*cos(phi*pisd)
      y=r*sin(teta*pisd)*sin(phi*pisd)
      z=r*cos(teta*pisd)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ctenpon_(n,power)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_ten_power_n i.e. 10**n for code portability
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2007
!     ---------------------------------------------------------------+--
!
      real*8 dpower

      if(n.eq.0) then
                 power=1.
                 return
                 endif
!
      if(n.gt.36) then
                  power=1.e36
                  return
                  endif
!
      if(n.lt.-36) then
                   power=1.e-36
                   return
                   endif
!
      ie=abs(n)
      dpower=10.D0
!
! *   calcul en double pour eviter les 9.9999e5
!     et troncature avec 1.00000001 tj pour eviter les 9.9999997
!
      do i= 2,ie
      dpower=dpower*10.D0
      enddo
!
      if(n.gt.0) then
                 power=real(dpower)
                 else
                 power=real(1.00000001D0/dpower)
      endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ctimcha_(ih,im,is,ctime)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_time_number_to_char  '13:03:05'
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) ctime
!
      write(ctime,100) ih,im,is
!
      if(ctime(1:1).eq.' ') ctime(1:1)='0'
      if(ctime(4:4).eq.' ') ctime(4:4)='0'
      if(ctime(7:7).eq.' ') ctime(7:7)='0'
!
  100 format(i2.2,':',i2.2,':',i2.2)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ctimmil_(milday,ih,im,is,ims)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_milday_to_ih_im_is_ims integers values
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2001
!                                 copy from Rocotlib, P. Robert, 1992
!
! *   input  : milday millisecond of the day
! *   output : ih,im,is,ims
!     ---------------------------------------------------------------+--
!
!
      nj= milday/86400000
      mil2= milday-nj*86400000
!
      if(nj.ne.0) then
          print*, '*** ctimmil: milday=',milday,' > 86 400 000'
          print*, '            assumed:',mil2
          call upwarni_('ctimmil_: milday > 86 400 000, modified...')
          endif
!
      ih=  milday/3600000
      im= (milday-ih*3600000)/60000
      is= (milday-ih*3600000-im*60000)/1000
      ims= milday-ih*3600000 -im*60000 -is*1000
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ctwopon_(n,ipower)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_two_power_n i.e. 2**n for code portability
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2007
!     ---------------------------------------------------------------+--
!
      if(n.eq.0) then
                 ipower=1
                 return
                 endif
!
      if(n.lt.0) call uperror_('ctwopon_ : n must be > 0')
!
      nmax=2147483647
      if(n.gt.nmax) call uperror_('ctwopon_ : n must be < 2147483647')
!
!
      ipower=2
!
      do i= 2,n
      ipower=ipower*2
      enddo
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cvecmod_(x,y,z,rmod)
!
!     ---------------------------------------------------------------+--
! *   Object : compute_vector_modulus from 3 components
! *   Class  : compute modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2007
!     ---------------------------------------------------------------+--
!
      rmod=sqrt(x*x + y*y + z*z)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cxtogpr_(x,nosd)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_x_to_given_precision with numb. of signi. digits
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      call cmanexp_(x,rm,ie)
!
      nosd1=max(abs(nosd),1)
!
      call ctenpon_(nosd1,pow)
      rmn=abs(rm)*pow
      irm=int(rmn)
      rm2=float(irm)/pow
      call ctenpon_(ie,powie)
      x=sign(rm2,rm)*powie
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cxtolim_(x)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_x_to_low_integer_mantissa ex: 13.25 -> 10.
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      data epsi  /1.e-35/
      save epsi
!
! *** arondi x a sa mantisse entiere inferieure
!
!
      if(abs(x).lt.epsi) then
                         x=0.
                         return
                         endif
!
      call csigdig_(x,nosd)
!
      if(nosd.eq.1) then
                    return
!
                    else
                    call cmanexp_(x,rm,ie)
                    rm10=rm*10.
                    if(rm.gt.0.) then
                                 rm10a=float(int(rm10))
                                 else
                                 rm10a=float(int(rm10))-1.
                                 endif
                    call ctenpon_(ie,pow)
                    x=(rm10a/10.)*pow
                    return
                    endif
!
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cxtouim_(x)
!
!     ---------------------------------------------------------------+--
! *   Object : convert_x_to_upper_integer_mantissa ex: 13.25 -> 20.
! *   Class  : convert modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      data epsi  /1.e-35/
      save epsi
!
! *** arondi x a sa mantisse entiere superieure
!
!
      if(abs(x).lt.epsi) then
                         x=0.
                         return
                         endif
!
      call csigdig_(x,nosd)
! /// dbug              print*, 'cxtouim 1 : x,nosd=',x,nosd
!
      if(nosd.eq.1) then
                    return
!
                    else
                    call cmanexp_(x,rm,ie)
! /// dbug              print*, 'cxtouim 2 : x,rm,ie=',x,rm,ie
                    rm10=rm*10.
                    if(rm.gt.0.) then
                                 rm10a=float(int(rm10))+1.
                                 else
                                 rm10a=float(int(rm10))
                                 endif
                    call ctenpon_(ie,pow)
! /// dbug              print*, 'cxtouim 3 : rm10a,ie,pow=',rm10a,ie,pow
                    x=(rm10a/10.)*pow
! /// dbug              print*, 'cxtouim 4 : x,nosd=',x,nosd
                    return
                    endif
!
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dclogra_
!
!     ---------------------------------------------------------------+--
! *   Object : define_close_graphical_file and terminate the plot
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      common /pagnum/ npage
      common /numvec/ nbppo,nbpmo,nbtpo,nbtmo
      common /boupag/ xminb,xmaxb,yminb,ymaxb
      common /statim/ jj1,mm1,ian1,ih1,im1,is1,ims1,nc
      common /statim1/ datim1
      common /npsfil/ psfil
!
      character*29  datim1
      character*255 psfil
      character*8 time
      character*29  datim2
!
      save time,datim2
!
!
      call sdr_updbbox
      call sdr_dclogra
      call sys_gdattim(mm2,jj2,ian2,ih2,im2,is2)
!
      call gusdati_(datim2)
      call gditime_(time)
!
      nbv=nbppo+nbpmo
      print 110, time,' : End of page ',npage
      print 140,'nb vectors    :',nbv,nbppo,nbpmo
      print 150,'XY min-max    :',xminb,xmaxb,yminb,ymaxb
!
      call cchalen_(datim1,nc1)
      call cchalen_(datim2,nc2)

      print 100
      print 120, 'ROGRALIB / Starting plot : ',datim1(1:nc1),' U.T.'
      print 120, '         / Ending   plot : ',datim2(1:nc2),' U.T.'
!
      call cdatsoy_(mm1,jj1,ian1,ih1,im1,is1,iseca1)
      call cdatsoy_(mm2,jj2,ian2,ih2,im2,is2,iseca2)
!
      idif=iseca2-iseca1
!
      call csoydat_(idif,imois,jj,nban,ih,im,is)
!
      if(idif.le.86400) then
                        print 132, 'Duration      :',ih,im,is
                        else
                        print 134, 'Duration      :',jj,ian2,ih,im,is
                        endif
!
      nbtpo=nbtpo+nbppo
      nbtmo=nbtmo+nbpmo
      nbv=nbtpo+nbtmo
!
      call gditime_(time)
!
      print 140,'nb pages      :',npage
      print 140,'nb vectors    :',nbv,nbtpo,nbtmo
      print 120,'ROGRALIB / time ',time,' : Close PostScript file ', psfil(1:nc)
      print 120,'                           ---> Ready to print'
      print 200
!
!
  100 format(1x,79('-'))
  110 format(1x,'ROGRALIB / time ',2a,i5)
  120 format(1x,10a)
  132 format(10x,'/ ',a,                     i2,'h ',i2,' m ',i2,' s')
  134 format(10x,'/ ',a,i3,' j ',i1,' an',5x,i2,'h ',i2,' m ',i2,' s')
  140 format(10x,'/ ',a,2i8,' up,',i8,' down')
  150 format(10x,'/ ',a,3x,2f8.2,4x,2f8.2)
  200 format(1x,79('='))
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dcolmap_(colmap)
!
!     ---------------------------------------------------------------+--
! *   Object : define_color_map among existing color map
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /colmap/ hueu,satu,briu,nbcolu
      common /colmac/ comapu
      common /allmapn/ nbcmap
      common /allmapc/ comaps
!
      real hueu(256),satu(256),briu(256)
      character*10 comapu
      character*10 comaps(25)
!
      character*(*) colmap
      character*10  colmapc
!
!
      call cchalen_(colmap,nc)
      colmapc(1:nc)=colmap(1:nc)

      comapu='Undefined '
      nbcmap=25
!
! *** chargement des noms des palettes pre-definies:
!
      comaps(1)='classic022'
!
      do i=2,nbcmap
      if(i.le.7) then
                 im=i-1
                 else
                 im=mod(i-2,6)+1
                 endif
      call ctwopon_(im+2,np)
      write(comaps(i)(8:10),'(i3.3)') np
      enddo
!
      do i=2,7
      comaps(i)(1:7)='spectro'
      enddo
!
      do i=8,13
      comaps(i)(1:7)='rainbow'
      enddo
!
      do i=14,19
      comaps(i)(1:7)='fullhue'
      enddo
!
      do i=20,25
      comaps(i)(1:7)='greylev'
      enddo
!
! *** initialisations
!
      kpal=0
!
! *** calcul des hue, sat, bri pour la palette choisie
!
! ** palette classique (adaptee aux imprimantes)
!
      if(colmapc.eq.'classic022') then
          nbcolu=22
!
          hueu( 1) = 0.8710
          hueu( 2) = 0.0000
          hueu( 3) = 0.0323
          hueu( 4) = 0.0645
          hueu( 5) = 0.0968
          hueu( 6) = 0.1290
          hueu( 7) = 0.1613
          hueu( 8) = 0.1935
          hueu( 9) = 0.2258
          hueu(10) = 0.2581
          hueu(11) = 0.2903
          hueu(12) = 0.3097
          hueu(13) = 0.3333
          hueu(14) = 0.4065
          hueu(15) = 0.4452
          hueu(16) = 0.4839
          hueu(17) = 0.5161
          hueu(18) = 0.5613
          hueu(19) = 0.5935
          hueu(20) = 0.6666
          hueu(21) = 0.7097
          hueu(22) = 0.7419
!
          do i=1,nbcolu
          satu(i)=1.
          briu(i)=1.
          enddo
!
          comapu=colmapc
          print 100, ' ROGRALIB / Color map set : ',comapu
          return
          endif ! classic022
!
! /// toutes les mires sont maintenant du type "xxxxxxx016"
!     calcul du nombre de point de la mire
!
      if(colmapc(8:10).eq.'008') nbcolu=  08
      if(colmapc(8:10).eq.'016') nbcolu=  16
      if(colmapc(8:10).eq.'032') nbcolu=  32
      if(colmapc(8:10).eq.'064') nbcolu=  64
      if(colmapc(8:10).eq.'128') nbcolu= 128
      if(colmapc(8:10).eq.'256') nbcolu= 256
!
      if(nbcolu.eq.0) then
                 print 100, ' Color map asked: ',colmapc
                 print 100, ' must be one of :'
                 do i=1,nbcmap
                 print 100, '                  ',comaps(i)
                 enddo
                 call uperror_('ccolmap_: color map unknown')
                 endif
!
!
! ** palette spectro couleurs (adaptee aux spectrogrammes)
!
      if(colmap(1:7).eq.'spectro') then
!
! *      chargement des hue, sat, bri
!
         do i=1,nbcolu
!
!        Etalement des couleurs du rouge au violet:
!
         colstep=float(i)/float(nbcolu)-.15
         if (colstep.lt.0.) colstep=colstep+1.
         hueu(i)=colstep
         satu(i)=1.
!
!        Plus de jaune dans le vert clair:
!
         if(colstep.gt.0.15.and.colstep.lt.0.3) then
                 briu(i)=1.
                 a=0.15/(0.3*0.3 -0.15*0.15)
                 b=0.15-a*0.15*0.15
                 do j=1,5
                 hueu(i)=a*hueu(i)*hueu(i)+b
                 enddo
!
!            Plus de cyan dans le bleu clair:
!
               elseif (colstep.gt.0.5.and.colstep.lt.0.675) then
                       briu(i)=1.-0.09*(colstep-0.5)/.175
                       a=0.175/(0.675*0.675 -0.5*0.5)
                       b=0.5-a*0.5*0.5
                       do j=1,5
                       hueu(i)=a*hueu(i)*hueu(i) +b
                       enddo
!
!            Fin de la mire (violet) plus foncee:
!
               elseif (colstep.gt.0.6751.and.colstep.lt.0.851) then
                       briu(i)=0.85-((colstep-.7)/.175)/1.5
!
!            Debut de la mire tout en rouge, mais de plus en plus fonce:
!
               elseif (colstep.gt.0.85) then
                       hueu(i)=1.
                       call capowex_(colstep -0.55, 0.9, briu(i))
                       briu(i)=briu(i)/0.45
               else
                       briu(i)=1.
               endif
!
         if(briu(i).gt.1.0) briu(i)=1.0
         enddo
!
         comapu=colmap
         print 100, ' ROGRALIB / Color map set : ',comapu
         return
         endif ! spectro
!
!
! XXX palette de niveaux de gris: lineaire, du blanc vers le noir
!
      if(colmap(1:7).eq.'greylev') then
!
          do i=1,nbcolu
          hueu(i)=0.
          satu(i)=0.
          briu(i)=float(nbcolu-i)/float(nbcolu-1)
          enddo
!
          comapu=colmap
          print 100, ' ROGRALIB / Color map set : ',comapu
          return
          endif ! greylevel
!
!
! XXX palette de couleur full hue:
!                         toute la gamme du hue, lineaire et periodique
!                         du rouge vers le bleu, avec retour au rouge
!                         soit le hue de 0.(rouge) a 1. (re-rouge)
!
      if(colmap(1:7).eq.'fullhue') then
!
          do i=1,nbcolu
          hueu(i)= float(i-1)/float(nbcolu-1)
          satu(i)=1.
          briu(i)=1.
          enddo
!
          comapu=colmap
          print 100, ' ROGRALIB / Color map set : ',comapu
          return
          endif ! fullhue
!
!
! XXX palette de couleur rainbow:
!                       arc en ciel comme le full hue,  lineaire,
!                       mais limite du rouge pur au magenta pur,
!                       en passant par le bleu (huered=0.)
!
      huemag= 0.833333
!
      if(colmap(1:7).eq.'rainbow') then
!
          do i=1,nbcolu
          hueu(i)= float(i-1)*(huemag)/float(nbcolu-1)
          satu(i)=1.
          briu(i)=1.
          enddo
!
          comapu=colmap
          print 100, ' ROGRALIB / Color map set : ',comapu
          return
          endif ! rainbow
!
! *** aucune palette ne correspond au nom donne en argument
!
      if(kpal.eq.0) then
                 print 100, ' Color map asked: ',colmap
                 print 100, ' must be one of :'
                 do i=1,nbcmap
                 print 100, '                  ',comaps(i)
                 enddo
                 call uperror_('ccolmap_: color map unknown')
                 endif
!
  100 format(2a)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dcolmapu(colmapu,nlevel,hue,sat,bri)
!
!     ---------------------------------------------------------------+--
! *   Object : define_color_map_user , from hue(256),sat(256),bri(256)
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /colmap/ hueu,satu,briu,nbcolu
      common /colmac/ comapu
!
      real hueu(256),satu(256),briu(256)
      character*10 comapu
!
      real hue(nlevel),sat(nlevel),bri(nlevel)
!
      character*(*) colmapu
!
      do i=1,nlevel
      hueu(i)=hue(i)
      satu(i)=sat(i)
      briu(i)=bri(i)
      enddo
!
      nbcolu=nlevel
      comapu=colmapu
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dfigdef_
!
!     ---------------------------------------------------------------+--
! *   Object : define_figure_default for position of tit,lab,sti,grad
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      call dfigzat_(1.)
      call dtitpos_('top')
      call dlabpos_('center','center')
      call dlabseny('vertical')
      call dstipos_('oi','ii')
      call dgrapos_('bottom','left')
      call dfigout_('n')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dfiglim_(xmin,xmax,ymin,ymax)
!
!     ---------------------------------------------------------------+--
! *   Object : define_figure_limit
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      call dfiglimx(xmin,xmax)
      call dfiglimy(ymin,ymax)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dfiglimx(xmin,xmax)
!
!     ---------------------------------------------------------------+--
! *   Object : define_figure_limit_x
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /figlim/ x1,x2,y1,y2
      common /figsiz/ rx,ry
      common /figsca/ ex,ey
      common /grasty/ logstx,logsty
!
      data epsi  /1.e-35/
      save epsi
!
!
      x1=xmin
      x2=xmax
!
      if(abs(x2-x1).lt.epsi) call uperror_('dfiglimx: bornes x identiques')
!
      if(x1.gt.x2) call uperror_('dfiglimx: x1 plus grand que x2')
!
      if(rx.le.epsi) call uperror_('dfiglimx: dimension de la figure pas definie')
!
! *   definition de l'echelle x
!
      if(logstx.eq.0) then
                      ex=(x2-x1)/rx
                      else
                      ex=(log10(x2)-log10(x1))/rx
      endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dfiglimy(ymin,ymax)
!
!     ---------------------------------------------------------------+--
! *   Object : define_figure_limit_y
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      common /figlim/ x1,x2,y1,y2
      common /figsiz/ rx,ry
      common /figsca/ ex,ey
      common /grasty/ logstx,logsty
!
      data epsi  /1.e-35/
      save epsi
!
!
      y1=ymin
      y2=ymax
!
      if(abs(y2-y1).lt.epsi) call uperror_('dfiglimy: bornes y identiques')
!
      if(y1.gt.y2) call uperror_('dfiglimy: y1 plus grand que y2')
!
      if(ry.le.epsi) call uperror_('dfiglimy: dimension de la figure pas definie')
!
!
! *   definition de l'echelle y
!
      if(logsty.eq.0) then
                      ey=(y2-y1)/ry
                      else
                      ey=(log10(y2)-log10(y1))/ry
      endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dfigori_(figorx,figory)
!
!     ---------------------------------------------------------------+--
! *   Object : define_figure_origine in cm of the lower left corner
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      call dfigorix(figorx)
      call dfigoriy(figory)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dfigorix(figorx)
!
!     ---------------------------------------------------------------+--
! *   Object : define_figure_origine_x in cm of the lower left corner
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /figori/ xz,yz
      common /pagsiz/ tpx,tpy
!
!
      if(figorx.ge.tpx) call uperror_('dfigori_: ox > size of page x')
!
      xz=figorx
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dfigoriy(figory)
!
!     ---------------------------------------------------------------+--
! *   Object : define_figure_origine_y in cm of the lower left corner
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /figori/ xz,yz
      common /pagsiz/ tpx,tpy
!
!
      if(figory.ge.tpy) call uperror_('dfigori_: oy > size of page y')
!
      yz=figory
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dfigout_(yeno)
!
!     ---------------------------------------------------------------+--
! *   Object : define_figure_out 'no'= no trepassing fig. limits
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /figout/ ifigout
!
      character*(*) yeno
!
      if(yeno(1:1).eq.'y') then
                           ifigout=1
                           else
                           ifigout=0
                           endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dfigppo_(pox,poy)
!
!     ------------------------------------------------------------------
! *   Object : define_figure_pen_position in cm.
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      call cfigpag_(pox,poy,x1,y1)
      call dpagppo_(x1,y1)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dfigsiz_(figsix,figsiy)
!
!     ---------------------------------------------------------------+--
! *   Object : define_figure_size in cm.
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /figsiz/ rx,ry
      common /pagsiz/ tpx,tpy
!
! *** definit la taille de la figure
!
      if(figsix.lt.tpx/100.) then
            call upwarni_('!!!')
            print*, 'figsix=',figsix
            print*, 'tpx=   ',tpx
         call uperror_('dfigsiz_: taille x de la fig. inf. a tpagx/100')
                             endif
!
      if(figsiy.lt.tpy/100.) then
            call upwarni_('!!!')
            print*, 'figsiy=',figsiy
            print*, 'tpy=   ',tpy
         call uperror_('dfigsiz_: taille y de la fig. inf. a tpagy/100')
                             endif
!
      if(figsix.gt.tpx) then
            call upwarni_('!!!')
            print*, 'figsix=',figsix
            print*, 'tpx=   ',tpx
            call uperror_('dfigsiz_: taille x de la fig. sup. a tapagx')
                        endif
!
      if(figsiy.gt.tpy) then
            call upwarni_('!!!')
            print*, 'figsiy=',figsiy
            print*, 'tpy=   ',tpy
            call uperror_('dfigsiz_: taille y de la fig. sup. a tapagy')
                        endif
!
      rx=figsix
      ry=figsiy
!
! *** calcul des positions, taille des marques, titres etc.
!
      call dfigdef_
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dfigzat_(zoatt)
!
!     ---------------------------------------------------------------+--
! *   Object : define_figure_zoom_attribute for grad.,lab.,marks,title
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /biggra/ diafig,unifig,zofiat
      common /figsiz/ rx,ry
      common /grasty/ logstx,logsty
!
! *** definit un coef. sur tailles/defaut (mar,gra,lab,tit)
!
      zofiat=zoatt
      diafig=sqrt(rx*rx + ry*ry)
      unifig=diafig*zofiat
!
      bsti=unifig/60.
      ssti=unifig/120.
!
      if(logstx.eq.0) then
                     grax=unifig/60.
                     else
                     grax=unifig/36.
      endif
!
      if(logsty.eq.0) then
                     gray=unifig/60.
                     else
                     gray=unifig/36.
      endif
!
      rlax=unifig/40.
      rlay=unifig/40.
!
      tits=unifig/30.
!
      call dstisiz_(bsti,ssti)
      call dgrasiz_(grax,gray)
      call dlabsiz_(rlax,rlay)
      call dtitsiz_(tits)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dfilzon_
!
!     ---------------------------------------------------------------+--
! *   Object : define_fill_zone start of a path to fill
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      call sdr_dfilzon
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dfonnum_(numfon)
!
!     ---------------------------------------------------------------+--
! *   Object : define_font_number
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /fonnum/ nufon, bodfon
!
      character*16 com
!
!
      nufon=numfon
!
      write(com,100) 'dfonnum_: ',numfon
      call sdr_wfilcom(com)
!
  100 format(a,i3)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dfontyp_(fontyp)
!
!     ---------------------------------------------------------------+--
! *   Object : define_font_type as 'c','h','hbobl',...
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) fontyp
!
!     fontyp='*' --> police dessinnees par la bibliotheque (obsolete)
!
!     fontyp='c' --> police Courier disponible sur le driver
!            'h'            Helvetica
!            't'            Times
!            's'            Symbol
!             hbold, hobli, hbobl etc... voir sys_gfontyp
!
      call cfonnum_(fontyp,numfon)
      call dfonnum_(numfon)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dfoofon_(fontyp,fonsiz)
!
!     ---------------------------------------------------------------+--
! *   Object : define_foot_font as 'tital', 0.3 cm
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /foofon/ ifonf, hfonf
!
      character*(*) fontyp
!
!               ----------
!
      call cfonnum_(fontyp,ifonf)
!
      hfonf=fonsiz
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dgrapos_(grapox,grapoy)
!
!     ---------------------------------------------------------------+--
! *   Object : define_graduations_position on the figure (b,t and l,r)
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      common /grapos/ ipgrax,ipgray
!
      character*(*) grapox,grapoy
!
!
      ipgrax=2
      ipgray=2
!
      if(grapox(1:1).eq.'t') ipgrax= 1
      if(grapox(1:1).eq.'b') ipgrax= 0
      if(grapoy(1:1).eq.'r') ipgray= 1
      if(grapoy(1:1).eq.'l') ipgray= 0
!
      if(ipgrax.eq.2) call uperror_('dgrapos_: grapox=b or t only')
      if(ipgray.eq.2) call uperror_('dgrapos_: grapoy=l or r only')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dgrasiz_(grasix,grasiy)
!
!     ---------------------------------------------------------------+--
! *   Object : define_graduations_size in cm.
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      call dgrasizx(grasix)
      call dgrasizy(grasiy)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dgrasizx(grasix)
!
!     ---------------------------------------------------------------+--
! *   Object : define_graduations_size of x axis in cm.
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /grasiz/ tgrax,tgray,dgxax,dgyay,ncgrax,ncgray
!
!
      if(grasix.lt.0.) call uperror_('dgrasiz_: taille des graduations X negative')
!
      tgrax=grasix
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dgrasizy(grasiy)
!
!     ---------------------------------------------------------------+--
! *   Object : define_graduations_size of y axis in cm.
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /grasiz/ tgrax,tgray,dgxax,dgyay,ncgrax,ncgray
!
!
      if(grasiy.lt.0.) call uperror_('dgrasiz_: taille des graduations Y negative')
!
      tgray=grasiy
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dgrasty_(ilogx,ilogy)
!
!     ---------------------------------------------------------------+--
! *   Object : define_graduations_style of x & y axis, 0=linear,1=log
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2011
!     ---------------------------------------------------------------+--
!
      call dgrastyx(ilogx)
      call dgrastyy(ilogy)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dgrastyx(ilogx)
!
!     ---------------------------------------------------------------+--
! *   Object : define_graduations_style of x axis, 0=linear,1=log
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2011
!     ---------------------------------------------------------------+--
!
      common /grasty/ logstx,logsty
      common /biggra/ diafig,unifig,zofiat
!
!
      if(ilogx .LT. 0 .or. ilogx .GT. 1) call uperror_('dgrastyx: only 0 (lin) or 1 (log)')
!
      logstx=ilogx
!
! *   redefinit les tailles par defaut des graduations si axe log
!
      if(logstx.eq.0) then
                      grax=unifig/60.
                      else
                      grax=unifig/30.
      endif
!
      call dgrasizx(grax)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dgrastyy(ilogy)
!
!     ---------------------------------------------------------------+--
! *   Object : define_graduations_style of y axis, 0=linear,1=log
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2011
!     ---------------------------------------------------------------+--
!
      common /grasty/ logstx,logsty
      common /biggra/ diafig,unifig,zofiat
!
!
      if(ilogy .LT. 0 .or. ilogy .GT. 1) call uperror_('dgrastyy: only 0 (lin) or 1 (log)')
!
      logsty=ilogy
!
! *   redefinit les tailles par defaut des graduations si axe log
!
      if(logsty.eq.0) then
                      gray=unifig/60.
                      else
                      gray=unifig/30.
      endif
!
      call dgrasizy(gray)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dheafon_(fontyp,fonsiz)
!
!     ---------------------------------------------------------------+--
! *   Object : define_header_font as 'tital', 0.3 cm
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /heafon/ ifonh, hfonh
!
      character*(*) fontyp
!
!               ----------
!
      call cfonnum_(fontyp,ifonh)
!
      hfonh=fonsiz
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dheapos_(iposhe,disthe)
!
!     ---------------------------------------------------------------+--
! *   Object : define_header_position as ipos -1,0,1 and oy from bottom
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /heapos/ ipohea,dishea
!
!               ----------
!
      ipohea=iposhe
      dishea=disthe
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dimasha_
!
!     ---------------------------------------------------------------+--
! *   Object : define_image_shape must be followed by contour drawing
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      call sdr_dimasha
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dlabpos_(labpox,labpoy)
!
!     ---------------------------------------------------------------+--
! *   Object : define_labels_position on the figure (l,c,r and b,c,t)
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      common /labpos/ iplabx,iplaby
!
      character*(*) labpox,labpoy
!
!
      iplabx=2
      iplaby=2
!
      if(labpox(1:1).eq.'l') iplabx=-1
      if(labpox(1:1).eq.'c') iplabx= 0
      if(labpox(1:1).eq.'r') iplabx= 1
!
      if(labpoy(1:1).eq.'b') iplaby=-1
      if(labpoy(1:1).eq.'c') iplaby= 0
      if(labpoy(1:1).eq.'t') iplaby= 1
!
      if(iplabx.eq.2) call uperror_('dlabpos_: labpox=l,c or r only')
      if(iplaby.eq.2) call uperror_('dlabpos_: labpoy=b,c or t only')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dlabseny(labsey)
!
!     ---------------------------------------------------------------+--
! *   Object : define_labels_sens on the figure (h or v, only labely)
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /labsen/ islaby
!
      character*(*) labsey
!
!
      islaby=2
!
      if(labsey(1:1).eq.'v') islaby= 0
      if(labsey(1:1).eq.'h') islaby= 1
!
      if(islaby.eq.2) call uperror_('dlabseny: labsey= v or h only')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dlabsiz_(rlasix,rlasiy)
!
!     ---------------------------------------------------------------+--
! *   Object : define_labels_size in cm.
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      common /labsiz/ tlax,tlay,dlxax,dlyay
!
! *** definit la taille des labels
!
!
      if(rlasix.lt.0.) call uperror_('dlabsiz_: taille du label X negative')
      if(rlasiy.lt.0.) call uperror_('dlabsiz_: taille du label Y negative')
!
      tlax=rlasix
      tlay=rlasiy
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dlincol_(col)
!
!     ---------------------------------------------------------------+--
! *   Object : define_line_color as 'r' or nrgbcmypwi
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) col
!
      common /lincol/ rc,gc,bc,hue,sat,bri,icol
!
! *** valeurs possibles: black, red, green, blue, cyan,
!                        magenta, yellow, pink, white, ignore
!
      r=0.
      g=0.
      b=0.
      icol=0
!
      if(col(1:1).eq.'r') then
                          r=1.
                          g=0.
                          b=0.
                          icol=1
                          go to 10
                          endif
!
      if(col(1:1).eq.'g') then
                          r=0.
                          g=1.
                          b=0.
                          icol=2
                          go to 10
                          endif
!
      if(col(1:1).eq.'b') then
                          r=0.
                          g=0.
                          b=1.
                          icol=3
                          go to 10
                          endif
!
      if(col(1:1).eq.'c') then
                          r=0.
                          g=1.
                          b=1.
                          icol=4
                          go to 10
                          endif
!
      if(col(1:1).eq.'m') then
                          r=1.
                          g=0.
                          b=1.
                          icol=5
                          go to 10
                          endif
!
      if(col(1:1).eq.'y') then
                          r=1.
                          g=1.
                          b=0.
                          icol=6
                          go to 10
                          endif
!
      if(col(1:1).eq.'p') then
                          r=1.
                          g=0.8
                          b=0.8
                          icol=7
                          go to 10
                          endif
!
      if(col(1:1).eq.'w') then
                          r=1.
                          g=1.
                          b=1.
                          icol=8
                          go to 10
                          endif
!
      if(col(1:1).eq.'i') then
                          return
                          endif
   10 continue
!
      rc=r
      gc=g
      bc=b
!
      call crgbhsb_(rc,gc,bc,hue,sat,bri)
      call sdr_dlincol('rgb',r,g,b)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dlincoln(level)
!
!     ---------------------------------------------------------------+--
! *   Object : define_line_color from level of current color map
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2007
!     ---------------------------------------------------------------+--
!
!
      common /colmap/ hueu,satu,briu,nbcolu
      common /colmac/ comapu
!
      real hueu(256),satu(256),briu(256)
      character*10 comapu
      character*10 colmap
!
! *** mire utilisee et nombre de niveaux
!
      call gcolmap_(colmap,nlevel)
!
! *** test si le niveau demande est dans la mire courante
!
      if(level.lt.1)  call uperror_('dlincoln: level number < 1')
      if(level.gt.nlevel) then
                          print*, 'ROGRALIB/dlincoln: level number too large for colormap'
                          print*, 'level asked     : ',level
                          print*, 'current colormap: ',comapu
                          print*, 'Number of levels: ',nlevel
        call uperror_('dlincoln: level number too large for colormap')
                          endif
!
      h=hueu(level)
      s=satu(level)
      b=briu(level)
!
      call sdr_dlincol('hsb',h,s,b)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dlincon_
!
!     ---------------------------------------------------------------+--
! *   Object : define_line_continue, remove dash line option
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2007
!     ---------------------------------------------------------------+--
!
      call sdr_dlincon
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dlindas_(size1,blank1,size2,blank2)
!
!     ---------------------------------------------------------------+--
! *   Object : define_line_dash, from given parameters
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2007
!     ---------------------------------------------------------------+--
!
! *** le trait tirete est constitue d'un premier trait de taille size1,
!     puis d'un espace blanc de taille blank1, puis d'un deuxieme trait
!     suivi d'un deuxieme blanc.
!
      if(size1.lt.0.)  call upwarni_('dlindas_: size1  <0, abs() taken')
      if(size2.lt.0.)  call upwarni_('dlindas_: size2  <0, abs() taken')
      if(blank1.lt.0.) call upwarni_('dlindas_: blank1 <0, abs() taken')
      if(blank2.lt.0.) call upwarni_('dlindas_: blank2 <0, abs() taken')
!
      total= abs(size1) +abs(size2) +abs(blank1) +abs(blank2)
!
      epsi=1./1000.
      if(total.lt.epsi) then
                    print*, 'ROGRALIB/dlindas_: size or blank too small'
                    print*, 'size1 = ',size1
                    print*, 'size2 = ',size2
                    print*, 'blank1= ',blank1
                    print*, 'blank2= ',blank2
                    call uperror_('dlindas_: size or blank too small')
                        endif
!
      call sdr_dlindas(size1,blank1,size2,blank2)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dlinhsb_(h,s,b)
!
!     ---------------------------------------------------------------+--
! *   Object : define_line_hsb color components as h,s,b values
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /lincol/ rc,gc,bc,hue,sat,bri,icol
!
! *** valeurs possibles: h s b entre 0. et 1.
!
!
      hue=h
      sat=s
      bri=b
!
      if(hue.lt.0.) hue=0.
      if(sat.lt.0.) sat=0.
      if(bri.lt.0.) bri=0.
!
      if(hue.gt.1.) hue=1.
      if(sat.gt.1.) sat=1.
      if(bri.gt.1.) bri=1.
!
      call chsbrgb_(hue,sat,bri,rc,gc,bc)
      call sdr_dlincol('hsb',hue,sat,bri)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dlinrgb_(r,g,b)
!
!     ---------------------------------------------------------------+--
! *   Object : define_line_rgb color components as r,g,b values
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /lincol/ rc,gc,bc,hue,sat,bri,icol
!
! *** valeurs possibles: r g b entre 0. et 1.
!
!
      rc=r
      gc=g
      bc=b
!
      if(rc.lt.0.) rc=0.
      if(gc.lt.0.) gc=0.
      if(bc.lt.0.) bc=0.
!
      if(rc.gt.1.) rc=1.
      if(gc.gt.1.) gc=1.
      if(bc.gt.1.) bc=1.
!
      call crgbhsb_(rc,gc,bc,hue,sat,bri)
      call sdr_dlincol('rgb',rc,gc,bc)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dlinwid_(width)
!
!     ---------------------------------------------------------------+--
! *   Object : define_lines_width in pixel, for next drawn lines
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /linwid/ wid
!
      wid=width
!
      call sdr_dlinwid(width)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dopegra_(ifc,psfile)
!
!     ---------------------------------------------------------------+--
! *   Object : define_open_graphical_file and start the plot
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      common /numvec/ nbppo,nbpmo,nbtpo,nbtmo
      common /pagnum/ npage
      common /pagsiz/ tpx,tpy
      common /statim/ jj1,mm1,ian1,ih1,im1,is1,ims1,nc
      common /statim1/ datim1
      common /npsfil/ psfil
      common /boupag/ xminb,xmaxb,yminb,ymaxb
      common /grasty/ logstx,logsty
!
      character*(*) psfile
!
      character*29  datim1
      character*255 psfil
      character*18 usdate
      character*8 time
!
      save usdate,time
!
      data rmax  /1.e+36/
      save rmax
!
!
      call cchalen_(psfile,nc)
!
      psfil=psfile(1:nc)
!
      call sys_gdattim(mm1,jj1,ian1,ih1,im1,is1)
      call gusdate_(usdate)
      call gusdati_(datim1)
      call gditime_(time)
      call gvernum_(ver)
!
      print 100
      print 200,    'time '//time,' : Running ROGRALIB V ',ver,usdate
      print 400, '               ',' : Opening PostScript file ', psfile(1:nc),' (unit ',ifc,')'
      print 110
!
      npage=0
      nbtpo=0
      nbtmo=0
!
      xminb=  rmax
      yminb=  rmax
      xmaxb= -rmax
      ymaxb= -rmax
!
! *   axes lineaires par defaut
!
      logstx=0
      logsty=0
!
      call sdr_dopegra(ifc,psfile(1:nc))
!
      tpx=18.6
      tpy=27.3
!
      call dpagnew_
      call dpagdef_
!
! *** initialisation standard pour une figure quelconque
!     (dfigdef_ est appelle par dfigsiz_)
!
      call dfigori_(4.,8.)
      call dfigsiz_(15.,10.)
      call dstinum_(4,9)
!
      call sdr_wfilcom('end   dopegra')
!
  100 format(1x,79('='))
  110 format(1x,79('-'))
  200 format(1x,'ROGRALIB / ',2a,f3.1,1x,a)
  400 format(1x,'         ',4a,i2,a)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dpagdef_
!
!     ---------------------------------------------------------------+--
! *   Object : define_page_default set standard page default attributes
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      tchea=0.25
!
      call dfontyp_('h')
      call dlinwid_(3.)
      call dpagsca_(1.,1.)
      call dpagfor_('p')
      call dheafon_('tital',tchea)
      call dpagsiz_(18.6,27.3,1.2,1.2)
      call dheapos_(1,tchea +0.2)
      call dfoofon_('tital',tchea)
      call dcolmap_('classic022')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dpagfor_(pl)
!
      character*(*) pl
!
!     ---------------------------------------------------------------+--
! *   Object : define_page_format 'p' as portrait or 'l' as landscape
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /pagsiz/ tpx,tpy
      common /pagfor/ iorpag
!
! *** on reperes le sens courant
!
      tpmin=min(tpx,tpy)
      tpmax=max(tpx,tpy)
!
      if(pl(1:1).eq.'p') then
                         iorpag=0
                         tpx=tpmin
                         tpy=tpmax
                         return
                         endif
!
      if(pl(1:1).eq.'l') then
                         iorpag=1
                         tpx=tpmax
                         tpy=tpmin
                         return
                         endif
!
      call uperror_('dpagfor_: only "p" or "l"')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dpagnew_
!
!     ---------------------------------------------------------------+--
! *   Object : define_page_new with preceding page attribute
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /pagnum/ npage
      common /numvec/ nbppo,nbpmo,nbtpo,nbtmo
      common /fonnum/ nufon, bodfon
      common /boupag/ xminb,xmaxb,yminb,ymaxb
!
      character*8 time
      data rmax  /1.e+36/
      save rmax,time
!
!
      call sdr_wfilcom('begin dpagnew_')
      call sdr_dpagnew(nupa)
      call sdr_dfonnab(nufon,bodfon)
!
! *** on termine la page precedente eventuelle
!
      call gditime_(time)
      npage=npage+1
!
      if(npage.gt.1) then
                     call sdr_updbbox
!
                     nbv=nbppo+nbpmo
                     print 100, time,'    : End of page ',npage-1
                     print 140,'nb vectors    :',nbv,nbppo,nbpmo
                     print 150,'XY min-max    :',xminb,xmaxb,yminb,ymaxb
!
                     nbtpo=nbtpo+nbppo
                     nbtmo=nbtmo+nbpmo
!
                     nbppo=0
                     nbpmo=0
!
                     xminb=  rmax
                     yminb=  rmax
                     xmaxb= -rmax
                     ymaxb= -rmax
!
                     print 200
                     endif
!
!
      print 100, time,' : Begin  page  ',npage,' Please wait...'
!
      call sdr_wfilcom('end   dpagnew_')
!
  100 format(1x,'ROGRALIB / time ',2a,i4,a)
  140 format(10x,'/ ',a,2i8,' up,',i8,' down')
  150 format(10x,'/ ',a,3x,2f8.2,4x,2f8.2)
  200 format(1x,a)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dpagori_(pagorx,pagory)
!
!     ---------------------------------------------------------------+--
! *   Object : define_page_origine default=(0.,0.)
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /pagori/ popagx,popagy
!
      popagx=pagorx
      popagy=pagory
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dpagppo_(pox,poy)
!
!     ---------------------------------------------------------------+--
! *   Object : define_page_pen_position in cm, without plot
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /numvec/ nbppo,nbpmo,nbtpo,nbtmo
      common /penpos/ pepox,pepoy
      common /pagsiz/ tpx,tpy
      common /pagfor/ iorpag
      common /pagori/ popagx,popagy
      common /boupag/ xminb,xmaxb,yminb,ymaxb
!
! *** deplacement elementaire de plume  sans trace
!
      posx= pox-popagx
      posy= poy-popagy
!
      if(iorpag.eq.0) then
                      xx=posx
                      yy=posy
                      else
                      xx=tpy-posy
                      yy=posx
                      endif
!
      call sdr_dpagppo(xx,yy)
!
      nbppo=nbppo+1
      pepox=xx
      pepoy=yy
!
! *** update des extrema du trace (page/paysage cm unit)
!
      xminb= min(xminb, xx)
      yminb= min(yminb, yy)
      xmaxb= max(xmaxb, xx)
      ymaxb= max(ymaxb, yy)
!
      call sdr_updbbox
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dpagsca_(scax,scay)
!
!     ---------------------------------------------------------------+--
! *   Object : define_page_scale_factor default=(1.,1.)
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /pagsca/ zomx,zomy
!
!
      zomx=scax
      zomy=scay
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dpagsiz_(pagsix,pagsiy,rmargex,rmargey)
!
!     ---------------------------------------------------------------+--
! *   Object : define_page_size in cm. erase default size
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /pagsiz/ tpx,tpy
!
      tpx=pagsix
      tpy=pagsiy
!
! *** attention! les marges sont en plus
!
!     exemple: call dpagsiz_(19.,27.7,2.,2.) pour a4= 21 x29.7
!     sans marges a droite ni en haut
!
!     pour A4 avec marges de 1.2 cm tout autour, il faut
!     un call dpagsiz_(18.6,27.3,1.2,1.2)
!
      call sdr_dpagsiz(pagsix,pagsiy,rmargex,rmargey)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dstinum_(nmin,nmax)
!
!     ---------------------------------------------------------------+--
! *   Object : define_sticks_number , i.e. min and max big sticks number
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /n_marques/ n_tick_min,n_tick_max
!
      n_tick_min=nmin
      n_tick_max=nmax
!
      if (nmin.lt.2) then
           write(*,*) 'dstinum_ WARNING nmin<2 -> set to default nmin=2'
                     endif
!
      if (nmax.gt.9) then
           write(*,*) 'dstinum_ WARNING nmax>9 -> set to default nmax=9'
           n_tick_max=9
                     endif
!
      if (nmin.gt.nmax) then
           write(*,*) 'dstinum_ WARNING nmin>nmax -> set to default, nmin=2 and nmax=9'
           n_tick_min=2
           n_tick_max=9
                        endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dstipos_(stipox,stipoy)
!
!     ---------------------------------------------------------------+--
! *   Object : define_sticks_position as 'ii',io,oo,oi,' ' in,out,no
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /stipos/ ipmabx,ipmahx,ipmagy,ipmady
!
      character*(*) stipox,stipoy
!
!
      ipmabx=2
      ipmahx=2
      ipmagy=2
      ipmady=2
!
! *   tirets des graduations du bas
!
      if(stipox(1:1).eq.'i') ipmabx= 1
      if(stipox(1:1).eq.' ') ipmabx= 0
      if(stipox(1:1).eq.'o') ipmabx=-1
!
! *   tirets des graduations du haut
!
      if(stipox(2:2).eq.'i') ipmahx= 1
      if(stipox(2:2).eq.' ') ipmahx= 0
      if(stipox(2:2).eq.'o') ipmahx=-1
!
! *   tirets des graduations de gauche
!
      if(stipoy(1:1).eq.'i') ipmagy= 1
      if(stipoy(1:1).eq.' ') ipmagy= 0
      if(stipoy(1:1).eq.'o') ipmagy=-1
!
! *   tirets des graduations de droite
!
      if(stipoy(2:2).eq.'i') ipmady= 1
      if(stipoy(2:2).eq.' ') ipmady= 0
      if(stipoy(2:2).eq.'o') ipmady=-1
!
      if(ipmabx.eq.2) call uperror_('dstipos_: stipox(1:1)="i","o" or " " only')
      if(ipmahx.eq.2) call uperror_('dstipos_: stipox(2:2)="i","o" or " " only')
      if(ipmagy.eq.2) call uperror_('dstipos_: stipoy(1:1)="i","o" or " " only')
      if(ipmady.eq.2) call uperror_('dstipos_: stipoy(2:2)="i","o" or " " only')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dstisiz_(stisil,stisis)
!
!     ---------------------------------------------------------------+--
! *   Object : define_sticks_size long and short sticks in cm.
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /stisiz/ tgm,tpm
!
! *** definit la taille des grandes et petites marques
!
!
      if(stisil.lt.0.) call uperror_('dstisiz_: taille des grandes marques negative')
      if(stisis.lt.0.) call uperror_('dstisiz_: taille des petites marques negative')
!
      tgm=stisil
      tpm=stisis
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dtitpos_(titpo)
!
!     ---------------------------------------------------------------+--
! *   Object : define_title_position on the figure (top or bottom)
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /titpos/ ipotit
!
      character*(*) titpo
!
!
      if(titpo(1:1).ne.'t'.and.titpo(1:1).ne.'b') call uperror_('dtitpos_:  titpo t or b only')
!
      if(titpo(1:1).eq.'b') then
                            ipotit=0
                            else
                            ipotit=1
                            endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine dtitsiz_(titsi)
!
!     ---------------------------------------------------------------+--
! *   Object : define_title_size in cm.
! *   Class  : define modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /titsiz/ ttit,dtax
!
!
      if(titsi.lt.0.) call uperror_('dtitsiz_: taille du titre negative')
!
      ttit=titsi
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gboubox_(x1ups,x2ups,y1ups,y2ups,upstocm)
!
!     ---------------------------------------------------------------+--
! *   Object : give_bounding_box, in PostScript units, and conv ps to cm
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2007
!     ---------------------------------------------------------------+--
!
      common /sdrbbo/ xmip,xmap,ymip,ymap, xmimip,xmamap,ymimip,ymamap
!
      x1ups=xmip
      x2ups=xmap
      y1ups=ymip
      y2ups=ymap
!
      upstocm= 2.54/72.
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gclopar_(imonth,iday,iyear,ih,im,is)
!
!     ---------------------------------------------------------------+--
! *   Object : give_clock_parameters at the time call
! *   Class  : give date/time modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      call sys_gdattim(imonth,iday,iyear,ih,im,is)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gcolmap_(colmap,nlevel)
!
!     ---------------------------------------------------------------+--
! *   Object : give_color_map name and nb. of color levels
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2007
!     ---------------------------------------------------------------+--
!
      common /colmap/ hueu,satu,briu,nbcolu
      common /colmac/ comapu
!
      real hueu(256),satu(256),briu(256)
      character*10 comapu
!
      character*(*) colmap
!
      if(len(colmap).lt.10) call uperror_('gcolmap_: lenght of colmap must be GE 10')
      colmap=comapu
      nlevel=nbcolu
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gcolmapa(colmap,nbmap)
!
!     ---------------------------------------------------------------+--
! *   Object : give_color_map_array names and nb levels for all maps
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2007
!     ---------------------------------------------------------------+--
!
      common /allmapn/ nbcmap
      common /allmapc/ comaps
!
      character*10 comaps(25)
      character*(*) colmap(25)
!
      if(len(colmap(1)).lt.10) call uperror_('gcolmapa: lenght of colmap must be GE 10')
!
      if(nbcmap.gt.25) call uperror_('gcolmapa: number of colmap must be LE 25')
      nbmap=nbcmap
!
      do i=1,nbcmap
      colmap(i)=comaps(i)
      enddo
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gcolmapv(colmap,nlevel,hue,sat,bri)
!
!     ---------------------------------------------------------------+--
! *   Object : give_color_map_values of colormap, n,hue(n),sat(n),bri(n)
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2007
!     ---------------------------------------------------------------+--
!
      common /colmap/ hueu,satu,briu,nbcolu
      common /colmac/ comapu
!
      real hueu(256),satu(256),briu(256)
      character*10 comapu
!
      real hue(nlevel) ,sat(nlevel) ,bri(nlevel)
      character*(*) colmap
!
      if(len(colmap).lt.10) call uperror_('gcolmapv: lenght of colmap must be GE 10')
      colmap=comapu
      nlevel=nbcolu
!
      do i=1,nlevel
      hue(i)=hueu(i)
      sat(i)=satu(i)
      bri(i)=briu(i)
      enddo
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gdidate_(date10)
!
!     ---------------------------------------------------------------+--
! *   Object : give_digital_date as '2007-09-27'
! *   Class  : give date/time modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2007
!     ---------------------------------------------------------------+--
!
      character*(*) date10
!
      ll=len(date10)
      if(ll.lt.10) call uperror_('gditime_: character variable less than 10 carac.')
!
      call sys_gdattim(mm,jj,ian,ih,im,is)
!
      write(date10,100) ih,im,is
!
  100 format(i4.4,'-',i2.2,'-',i2.2)
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gditime_(time8)
!
!     ---------------------------------------------------------------+--
! *   Object : give_digital_time as '13:03:25'
! *   Class  : give date/time modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) time8
!
      ll=len(time8)
      if(ll.lt.8) call uperror_('gditime_: character variable less than 8 carac.')
!
      call sys_gdattim(mm,jj,ian,ih,im,is)
!
      write(time8,100) ih,im,is
!
  100 format(i2.2,':',i2.2,':',i2.2)
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gfiglimx(xmin,xmax)
!
!     ---------------------------------------------------------------+--
! *   Object : give_figure_limit_x for x axe
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      common /figlim/ x1,x2,y1,y2
!
      xmin=x1
      xmax=x2
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gfiglimy(ymin,ymax)
!
!     ---------------------------------------------------------------+--
! *   Object : give_figure_limit_y for y axe
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      common /figlim/ x1,x2,y1,y2
!
      ymin=y1
      ymax=y2
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gfigori_(figorx,figory)
!
!     ---------------------------------------------------------------+--
! *   Object : give_figure_origine in cm. from lower left corner
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /figori/ xz,yz
!
! *** valeur de la position des origines de la figure
!
      figorx=xz
      figory=yz
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gfigsca_(figscx,figscy)
!
!     ---------------------------------------------------------------+--
! *   Object : give_figure_scale in axe's uni/cm
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /figsca/ ex,ey
!
      if(abs(ex).lt.1.e-20) call uperror_('gfigsca_: scale x undefined')
      if(abs(ey).lt.1.e-20) call uperror_('gfigsca_: scale y undefined')
!
      figscx=ex
      figscy=ey
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gfigsiz_(figsix,figsiy)
!
!     ---------------------------------------------------------------+--
! *   Object : give_figure_size in cm.
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /figsiz/ rx,ry
!
! *** valeur de la taille de la figure en cm (=dim. axes)
!
      figsix=rx
      figsiy=ry
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gfigzat_(zoatt)
!
!     ---------------------------------------------------------------+--
! *   Object : give_figure_zoom_attribute for grad.,labels,marks,title
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /biggra/ diafig,unifig,zofiat
!
      data epsi  /1.e-35/
      save epsi
!
      if(diafig.lt.epsi) call uperror_('gfigzat_: taille de la figure non definie')
!
      zoatt=unifig/diafig
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gfonnum_(numfon)
!
!     ---------------------------------------------------------------+--
! *   Object : give_font_number
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /fonnum/ nufon, bodfon
!
!
      numfon=nufon
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gfontyp_(fontyp)
!
!     ---------------------------------------------------------------+--
! *   Object : give_font_type as  'c','h','hbold',...
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /fonnum/ nufon, bodfon
!
      character*(*) fontyp
!
      call cfontyp_(nufon,fontyp)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gfrdate_(date17)
!
!     ---------------------------------------------------------------+--
! *   Object : give_french_date as '21 Septembre 1988' (17c.)
! *   Class  : give date/time modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) date17
      character*9 mois(12)
      integer lm(12)
      save mois,lm
!
      data mois /'Janvier','Fevrier','Mars','Avril','Mai','Juin',&
                 'Juillet','Aout','Septembre','Octobre','Novembre','Decembre'/
!
      data lm /7,7,4,5,3,4,7,4,9,7,8,8/
!
!
      ll=len(date17)
      if(ll.lt.17) call uperror_('gfrdate_: date inferieur a 17 caracteres')
!
      call sys_gdattim(mm,jj,ian,ih,im,is)
      write(date17,100) jj,mois(mm)(1:lm(mm)),ian
!
  100 format(i2,1x,a,1x,i4)
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gfrdati_(dati28)
!
!     ---------------------------------------------------------------+--
! *   Object : give_french_date_and_time '23 Octobre 1992 - 23:50:10'
! *   Class  : give date/time modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) dati28
      character*17 date
      character*8 time
      save date,time
!
!
      ll=len(dati28)
      if(ll.lt.28) call uperror_('gfrdati_: variable dati less than 28 charac.')
!
      call gfrdate_(date)
      call cchalen_(date,nd)
      call gditime_(time)
!
      write(dati28,100) date(1:nd),time
!
  100 format(a,' - ',a8)
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ggrapos_(grapox,grapoy)
!
!     ---------------------------------------------------------------+--
! *   Object : give_graduations_position in character*1 variable
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /grapos/ ipgrax,ipgray
!
      character*(*) grapox,grapoy
!
!
      grapox='?'
      grapoy='?'
!
      if(ipgrax.eq.1) then
                      grapox(1:1)='t'
                      else
                      grapox(1:1)='b'
                      endif
!
      if(ipgray.eq.1) then
                      grapoy(1:1)='r'
                      else
                      grapoy(1:1)='l'
                      endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ggrasiz_(grasix,grasiy)
!
!     ---------------------------------------------------------------+--
! *   Object : give_graduations_size in cm.
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      common /grasiz/ tgrax,tgray,dgxax,dgyay,ncgrax,ncgray
!
! *** valeur de la taille des graduations en cm
!
      grasix=tgrax
      grasiy=tgray
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine glabpos_(labpox,labpoy)
!
!     ---------------------------------------------------------------+--
! *   Object : give_labels_position in character*1 variable
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      common /labpos/ iplabx,iplaby
!
      character*(*) labpox,labpoy
!
!
      labpox='?'
      labpoy='?'
!
      if(iplabx.eq.0) then
                      labpox(1:1)='c'
                      else
                      if(iplabx.eq. 1) labpox(1:1)='r'
                      if(iplabx.eq.-1) labpox(1:1)='l'
                      endif
!
      if(iplaby.eq.0) then
                      labpoy(1:1)='c'
                      else
                      if(iplaby.eq. 1) labpoy(1:1)='t'
                      if(iplaby.eq.-1) labpoy(1:1)='b'
                      endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine glabsiz_(rlasix,rlasiy)
!
!     ---------------------------------------------------------------+--
! *   Object : give_labels_size in cm.
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      common /labsiz/ tlax,tlay,dlxax,dlyay
!
!
      rlasix=tlax
      rlasiy=tlay
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gleadim_(x0,y0,sx,sy,ipos,sxe,sye,x1,x2,y1,y2,yt)
!
!     ---------------------------------------------------------------+--
! *   Object : give_leaf_dimensions of usefull square of the leaf
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!     utilitaire pour ppagleaf:
!     trace d'une feuille d'arbre, origine = pointe basse de la tige
!     ipos= -1, feuille vers la gauche, +1 vers la droite
!
!     donne:
!          sxe,sye: largeur et hauteur "efficace" du carre de la feuille
!          x1,x2  : position des bords verticaux
!          y1,y2  : position des bords horizontaux
!          yt     : hauteur de la tige
!
!
      x1= x0 +float(ipos)*sx*0.12
      x2= x0 +float(ipos)*sx*0.913
!
      y1= y0 +sy*0.045
      y2= y0 +sy*0.945
!
      yt= sy*0.07
!
      sxe= abs(x2-x1)
      sye= abs(y2-y1)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gvernum_(ver)
!
!     ------------------------------------------------------------------
! *   Object : give_version_number of the library, as 8.0
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      ver= 9.7
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine glincol_(col)
!
!     ---------------------------------------------------------------+--
! *   Object : give_line_color as 'n', or rgbcmypw
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) col
!
      common /lincol/ rc,gc,bc,hue,sat,bri,icol
!
! *** valeurs possibles: black, red, green, blue, cyan,
!                        magenta, yellow, pink, white
!
      col='n'
      if(icol.eq.1) col='r'
      if(icol.eq.2) col='g'
      if(icol.eq.3) col='b'
      if(icol.eq.4) col='c'
      if(icol.eq.5) col='m'
      if(icol.eq.6) col='y'
      if(icol.eq.7) col='p'
      if(icol.eq.8) col='w'
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine glinhsb_(h,s,b)
!
!     ---------------------------------------------------------------+--
! *   Object : give_line_hsb color components as h,s,b values
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /lincol/ rc,gc,bc,hue,sat,bri,icol
!
!
      h=hue
      s=sat
      b=bri
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine glinrgb_(r,g,b)
!
!     ---------------------------------------------------------------+--
! *   Object : give_line_rgb color components as r,g,b values
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /lincol/ rc,gc,bc,hue,sat,bri,icol
!
!
      r=rc
      g=gc
      b=bc
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine glinwid_(width)
!
!     ---------------------------------------------------------------+--
! *   Object : give_lines_width in pixel, for current drawn lines
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /linwid/ wid
!
      width=wid
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gpagfor_(pl)
!
      character*(*) pl
!
!     ---------------------------------------------------------------+--
! *   Object : give_page_format 'p' as portrait or 'l' as landscape
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /pagfor/ iorpag
!
      if(iorpag.eq.0) then
                      pl='p'
                      return
                      endif
!
      if(iorpag.eq.1) then
                      pl='l'
                      return
                      endif
!
      call uperror_('gpagfor_: error iorpag only 0 or 1')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gpagnum_(nupag)
!
!     ---------------------------------------------------------------+--
! *   Object : give_page_number of the current page
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      common /pagnum/ npage
!
      nupag=npage
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gpagori_(pagorx,pagory)
!
!     ---------------------------------------------------------------+--
! *   Object : give_page_origine in cm
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /pagori/ popagx,popagy
!
      pagorx=popagx
      pagory=popagy
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gpagppo_(pox,poy)
!
!     ---------------------------------------------------------------+--
! *   Object : give_page_pen_position in cm
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /penpos/ pepox,pepoy
!
      pox=pepox
      poy=pepoy
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gpagsca_(scax,scay)
!
!     ---------------------------------------------------------------+--
! *   Object : give_page_scale_factor from lower left corner
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /pagsca/ zomx,zomy
!
      scax=zomx
      scay=zomy
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gpagsiz_(pagsix,pagsiy)
!
!     ---------------------------------------------------------------+--
! *   Object : give_page_size in cm.
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /pagsiz/ tpx,tpy
!
      pagsix=tpx
      pagsiy=tpy
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gpripar_
!
!     ------------------------------------------------------------------
! *   Object : give_print_parameters
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      character*1 for,fontyp,col
      character*1 grapox,grapoy, labpox,labpoy, titpo
      character*2 stipox,stipoy
!
      save for,fontyp,col,grapox,grapoy, labpox,labpoy, titpo
      save stipox,stipoy
!
      call gpagfor_(for)
      call gpagori_(pagox,pagoy)
      call gpagsiz_(pagsx,pagsy)
      call gpagsca_(scalx,scaly)
      call gpagnum_(num)
!
      call gfontyp_(fontyp)
      call glincol_(col)
      call glinwid_(wi)
!
      call ggrapos_(grapox,grapoy)
      call glabpos_(labpox,labpoy)
      call gstipos_(stipox,stipoy)
      call gtitpos_(titpo)
!
      call ggrasiz_(grasix,grasiy)
      call glabsiz_(rlasix,rlasiy)
      call gstisiz_(stisix,stisiy)
      call gtitsiz_(titsi)
!
      print 100
      print 100, 'page  format       =',for
      print 300, 'page  origine x-y  =',pagox,pagoy
      print 300, 'page  size    x-y  =',pagsx,pagsy
      print 300, 'page  scale   x-y  =',scalx,scaly
      print 200, 'page  number       =',num
!
      print 100
      print 100, 'character font     =',fontyp
      print 100, 'lines color        =',col
      print 200, 'lines width        =',wi
      print 100
!
      print 500, 'graduation position=',grapox,grapoy
      print 500, 'label      position=',labpox,labpoy
      print 500, 'sticks     position=',stipox,stipoy
      print 500, 'titre      position=',titpo
!
      print 300, 'graduation size    =',grasix,grasiy
      print 300, 'label      size    =',rlasix,rlasiy
      print 300, 'sticks     size    =',stisix,stisiy
      print 300, 'titre      size    =',titsi
      print 100
!
  100 format(a,2x,a)
  200 format(a,i3)
  300 format(a,2f12.4)
  500 format(a,2(5x,a))
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gasdati_(dati26)
!
!     ---------------------------------------------------------------+--
! *   Object : give_atro_date_time as '1992, Oct. 23, 18:12 UT'
! *   Class  : give date/time modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2008
!     ---------------------------------------------------------------+--
!
      character*(*) dati26
      character*9 mois(12)
      integer lm(12)
      save mois,lm
!
      data mois /'January','February','March','April','May','June',&
                 'July','August','September','October','November','December'/
!
      data lm /7,8,5,5,3,4,4,6,9,7,8,8/
!
!
      ll=len(dati26)
      if(ll.lt.26) call uperror_('gasdati_: date inferieur a 26 caracteres')
!
      call sys_gdattim(mm,jj,ian,ih,im,is)
      write(dati26,100) ian,mois(mm)(1:lm(mm)),jj,ih,im
!
  100 format(i4.4,', ',a3,'. ',i2.2,' - ',i2.2,':',i2.2,' UT')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gstdati_(dati25)
!
!     ---------------------------------------------------------------+--
! *   Object : give_standart_date_time as 'October 23, 18:12, 1992'
! *   Class  : give date/time modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) dati25
      character*18 date
      character*8 time
      save date,time
!
      ll=len(dati25)
      if(ll.lt.25) call uperror_('gstdati_: variable dati less than 25 charac.')
!
      call gusdate_(date)
      call cchalen_(date,nd)
      call gditime_(time)
!
      write(dati25,100) date(1:nd-5),' ',time(1:5),date(nd-5:nd)
!
  100 format(4a)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gstipos_(stipox,stipoy)
!
!     ---------------------------------------------------------------+--
! *   Object : give_sticks_position in character*1 variable
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      common /stipos/ ipmabx,ipmahx,ipmagy,ipmady
!
      character*(*) stipox,stipoy
!
! *** valeur de la position des marques (int,ext)/figure
!
!
!
!     convention: 1=marques a l'interieur
!                 0=marques a l'exterieur de la figure
!
      stipox='??'
      stipoy='??'
!
      if(ipmabx.eq.1) then
                      stipox(1:1)='i'
                      else
                      stipox(1:1)='o'
                      endif
!
      if(ipmahx.eq.1) then
                      stipox(2:2)='i'
                      else
                      stipox(2:2)='o'
                      endif
!
      if(ipmagy.eq.1) then
                      stipoy(1:1)='i'
                      else
                      stipoy(1:1)='o'
                      endif
!
      if(ipmady.eq.1) then
                      stipoy(2:2)='i'
                      else
                      stipoy(2:2)='o'
                      endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gstisiz_(stisil,stisis)
!
!     ---------------------------------------------------------------+--
! *   Object : give_sticks_size in cm.
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      common /stisiz/ tgm,tpm
!
!     valeur de la taille des grandes et petites marques en cm
!
      stisil=tgm
      stisis=tpm
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gtitpos_(titpo)
!
!     ---------------------------------------------------------------+--
! *   Object : give_title_position in character*1 variable
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      common /titpos/ ipotit
!
      character*(*) titpo
!
      if(ipotit.eq.0) then
                      titpo='b'
                      else
                      titpo='t'
                      endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gtitsiz_(titsi)
!
!     ---------------------------------------------------------------+--
! *   Object : give_title_size in cm.
! *   Class  : give modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      common /titsiz/ ttit,dtax
!
! *** valeur de la taille du titre
!
      titsi=ttit
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gusdate_(date18)
!
!     ---------------------------------------------------------------+--
! *   Object : give_us_date as 'September 21, 1988' (18c.)
! *   Class  : give date/time modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) date18
      character*9 mois(12)
      integer lm(12)
      save mois,lm
!
      data mois/'January','February','March','April','May','June',&
                'July','August','September','October','November','December'/
!
      data lm/7,8,5,5,3,4,4,6,9,7,8,8/
!
!
      ll=len(date18)
      if(ll.lt.18) call uperror_('gusdate_: date inferieur a 18 caracteres')
!
      call sys_gdattim(mm,jj,ian,ih,im,is)
      write(date18,100) mois(mm)(1:lm(mm)),jj,ian
!
  100 format(a,1x,i2,',',1x,i4)
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine gusdati_(dati29)
!
!     ---------------------------------------------------------------+--
! *   Object : give_us_date_time as 'October 23, 1992 - 23:50:10'
! *   Class  : give date/time modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) dati29
      character*18 date
      character*8 time
      save date,time
!
!
      ll=len(dati29)
      if(ll.lt.29) call uperror_('gusdati_: variable dati less than 29 charac.')
!
      call gusdate_(date)
      call cchalen_(date,nd)
      call gditime_(time)
!
      write(dati29,100) date(1:nd),time
!
  100 format(a,' - ',a8)
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigarr_(orix,oriy,ipos,bodyl,bodyw,headl,headw,angle)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_arrow
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      call cfigpag_(orix,oriy,xx,yy)
      call gfigsca_(scax,scay)
!
      cbl=bodyl/scax
      cbw=bodyw/scay
!
      chl=headl/scax
      chw=headw/scay
!
      call ppagarr_(xx,yy,ipos,cbl,cbw,chl,chw,angle)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigcha_(orix,oriy,ipos,sizx,sizy,angle,chast)
!
      character*(*) chast
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_character_string size in cm
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      call cfigpag_(orix,oriy,xx,yy)
      call ppagcha_(xx,yy,ipos,sizx,sizy,angle,chast)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigcir_(xc,yc,r,teta1,teta2,dteta)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_circular_arc
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
! *** scale X is assumed to compute the radius
!
      call gfigsca_(scx,scy)
      call cfigpag_(xc,yc,xcp,ycp)
!
      rp=r/scx
!
      call ppagcir_(xcp,ycp,rp,teta1,teta2,dteta)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigcor_
      common /figsiz/ rx,ry
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_corners
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      call ppagrco_(0.,0.,rx,ry,ry/20.)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigculd(x1,dx,ay,n1,n2,nstep)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_curve_loop_dx
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      dimension ay(n2)
!
! *** trace du tableau ty(n) pour x=x1+(n-1)*dx
!
      call cfigpag_(x1,ay(n1),xx,yy)
      call dpagppo_(xx,yy)
!
      x=x1
!
      do 10 i=n1+1,n2,nstep
      x=x+dx
      call cfigpag_(x,ay(i),xx,yy)
      call ppagpmo_(xx,yy)
   10 continue
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigcur_(ax,ay,n)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_curve from ax(n),ay(n)
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      dimension ax(n),ay(n)
!
! *** trace d'un tableau ay(n)=f(ax(n))
!
      call cfigpag_(ax(1),ay(1),xx,yy)
      call dpagppo_(xx,yy)
!
      do 10 i=2,n
      call cfigpag_(ax(i),ay(i),xx,yy)
      call ppagpmo_(xx,yy)
   10 continue
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigcurd(x1,dx,ay,n)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_curve_dx from x1
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      dimension ay(n)
!
! *** trace du tableau ty(n) pour x=x1+(n-1)*dx
!
      call cfigpag_(x1,ay(1),xx,yy)
      call dpagppo_(xx,yy)
!
      x=x1
!
      do 10 i=2,n
      x=x+dx
      call cfigpag_(x,ay(i),xx,yy)
      call ppagpmo_(xx,yy)
   10 continue
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigcurl(ax,ay,n1,n2,nstep)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_curve_loop n=n1,n2,nstep
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      dimension ax(n2),ay(n2)
!
! *** trace d'un tableau ay(n)=f(tx(n))
!
      if(n1.ge.n2) call uperror_('pfigcurl_: n1.ge.n2')
!
      call cfigpag_(ax(n1),ay(n1),xx,yy)
      call dpagppo_(xx,yy)
!
      do 10 i=n1+1,n2,nstep
      call cfigpag_(ax(i),ay(i),xx,yy)
      call ppagpmo_(xx,yy)
   10 continue
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigcurs(ax,ay,n,ipos,sizx,sizy,symb,col)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_curve_symbol size in cm
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      dimension ax(n),ay(n)
      character*(*) symb,col
      character*1 pcol
      save pcol
!
! *** trace d'un tableau ay(n)=f(ax(n)) avec un symbol sur chaque point
!
!
! *** trace de la courbe avec la couleur courante
!
      call pfigcur_(ax,ay,n)
!
! *** changement de couleur pour les symboles
!
      call glincol_(pcol)
      call dlincol_(col)
!
! *** trace des symboles et remplissage,
!     contour des symbol avec la couleur de ligne
!
      do 10 i=1,n
      call dlincol_(col)
      call pfigsym_(ax(i),ay(i),ipos,sizx,sizy,symb)
      call pfilzon_
      call dlincol_(pcol)
      call pfigsym_(ax(i),ay(i),ipos,sizx,sizy,symb)
   10 continue
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigell_(xc,yc,a,b,rincli,teta1,teta2,dteta)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_elliptical_arc
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      call gfigsca_(scx,scy)
      call cfigpag_(xc,yc,xcp,ycp)
!
      ap=a/scx
      bp=b/scy
!
      call ppagell_(xcp,ycp,ap,bp,rincli,teta1,teta2,dteta)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigfra_
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_frame
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /figsiz/ rx,ry
      common /figori/ xz,yz
!
! *** trace du cadre autour de la figure
!
      call sdr_wfilcom('begin pfigfra_')
!
      call dpagppo_(xz,yz)
      call ppagpmo_(xz+rx,yz)
      call ppagpmo_(xz+rx,yz+ry)
      call ppagpmo_(xz,yz+ry)
      call ppagpmo_(xz,yz)
!
      call sdr_wfilcom('end   pfigfra_')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfiggrax(xref,bgx,sgx,forx)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_graduations_x as '(f3.0)',' ','*'
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /figsiz/ rx,ry
      common /figori/ xz,yz
      common /figlim/ x1,x2,y1,y2
      common /grasiz/ tgrax,tgray,dgxax,dgyay,ncgrax,ncgray
      common /grapos/ ipgrax,ipgray
      common /stisiz/ tgm,tpm
      common /stipos/ ipmabx,ipmahx,ipmagy,ipmady
      common /grasty/ logstx,logsty
!
      character*(*) forx
      character*8 form
      character*1 ifg
      save form,ifg
!
      data epsi  /1.e-35/
      save epsi
!
! *** trace les graduations de l'axe x
!     bgx,sgx= bigstep and small step des graduation x
!
      call sdr_wfilcom('begin pfiggrax')
!
! *** verif qu'on est bien en option axe lineaire
!
      if (logstx .ne. 0) call uperror_('pfiggrax: grad. style not defines as lin')
!
! *** verification du format
!
      if(forx.ne.' ') then
                      call uverfor_(forx,'pfiggrax')
                      call udecfor_(forx,ifg,ncgrax,ndec)
                      if((ifg.eq.'f' .or. ifg.eq.'F') .and.ndec.eq.0) then
                                      call uencfor_(form,'i',ncgrax-1,0)
                                      else
                                      form=forx
                                      endif
                      tgx=tgrax
                      else
                      form='*'
                      tgx=0.
                      endif
!
! *** verification des graduations
!
      if(bgx.lt.epsi) call uperror_('pfiggrax: big graduation <epsi')
      if(sgx.lt.epsi) call uperror_('pfiggrax: small graduation <epsi')
!
! *** valeur par defaut pour xref: si xref = 0 et qu'il n'est pas entre
!     x1 et x2, on prend xref= x1
!
      xref2=xref
      if(abs(xref).lt.epsi.and.(xref.lt.x1.or.xref.gt.x2)) xref2=x1
!
! *** trace des graduations
!
      yzp=yz+ry
      tgbx=tgm*float(ipmabx)
      tpbx=tpm*float(ipmabx)
      tghx=tgm*float(ipmahx)
      tphx=tpm*float(ipmahx)
!
!
      if (ipgrax.eq.1) then
!                      graduations en haut
                       if(ipmahx.eq.-1) then
                                        dg=tgm*1.5
                                        else
                                        dg=tgm*0.5
                                        endif
      call ppagaxex(xz,yz ,rx,x1,x2,xref2,bgx,sgx,-tgbx,-tpbx,0.,0.,'*')
      call ppagaxex(xz,yzp,rx,x1,x2,xref2,bgx,sgx, tghx, tphx, tgx,-dg,form)
!
                       else
!                      graduations en bas
                       if(ipmabx.eq.-1) then
                                        dg=tgm*1.5
                                        else
                                        dg=tgm*0.5
                                        endif
      call ppagaxex(xz,yzp,rx,x1,x2,xref2,bgx,sgx, tghx, tphx,0.,0.,'*')
      call ppagaxex(xz,yz ,rx,x1,x2,xref2,bgx,sgx,-tgbx,-tpbx, tgx,dg,form)
!
                       endif
!
      dgxax=dg
!
      call sdr_wfilcom('end   pfiggrax')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfiggray(yref,bgy,sgy,fory)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_graduations_y as '(f3.0)',' ','*'
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /figsiz/ rx,ry
      common /figori/ xz,yz
      common /figlim/ x1,x2,y1,y2
      common /grasiz/ tgrax,tgray,dgxax,dgyay,ncgrax,ncgray
      common /grapos/ ipgrax,ipgray
      common /stisiz/ tgm,tpm
      common /stipos/ ipmabx,ipmahx,ipmagy,ipmady
      common /grasty/ logstx,logsty
!
      character*(*) fory
      character*8 form
      character*1 ifg
      save form,ifg
!
      data epsi  /1.e-35/
      save epsi
!
!
! *** trace les graduations de l'axe y
!     bgy,sgy=bigstep and small step des graduation y
!
      call sdr_wfilcom('begin pfiggray')
!
! *** verif qu'on est bien en option axe lineaire
!
      if (logsty .ne. 0) call uperror_('pfiggray: grad. style not defines as lin')
!
! *** verification du format
!
      if(fory.ne.' ') then
                      call uverfor_(fory,'pfiggray')
                      call udecfor_(fory,ifg,ncgray,ndec)
                      if((ifg.eq.'f' .or. ifg.eq.'F') .and.ndec.eq.0) then
                                      ncgray= ncgray-1
                                      call uencfor_(form,'i',ncgray,0)
                                      else
                                      form=fory
                                      endif
                      tgy=tgray
                      else
                      form='*'
                      tgy=0.
                      endif
!
! *** verification des graduations
!
      if(bgy.lt.epsi) call uperror_('pfiggray: big graduation <epsi')
      if(sgy.lt.epsi) call uperror_('pfiggray: small graduations <epsi')
!
!
! *** valeur par defaut pour yref: si yref = 0 et qu'il n'est pas entre
!     y1 et y2, on prend yref= y1
!
      yref2=yref
      if(abs(yref).lt.epsi.and.(yref.lt.y1.or.yref.gt.y2)) yref2=y1
!
! *** trace des graduations
!
      xzp=xz+rx
      tggy=tgm*float(ipmagy)
      tpgy=tpm*float(ipmagy)
      tgdy=tgm*float(ipmady)
      tpdy=tpm*float(ipmady)
!
      if (ipgray.eq.1) then
!                    * graduations a droite
                       if(ipmady.eq.-1) then
                                        dg=tgm*1.5
                                        else
                                        dg= tgm*0.5
                                        endif
      call ppagaxey(xz ,yz,ry,y1,y2,yref2,bgy,sgy, tggy, tpgy,0.,0.,'*')
      call ppagaxey(xzp,yz,ry,y1,y2,yref2,bgy,sgy,-tgdy,-tpdy,tgy, -dg,form)
!
                       else
!                    * graduation a gauche
                       if(ipmagy.eq.-1) then
                                        dg=tgm*1.5
                                        else
                                        dg= tgm*0.5
                                        endif
      call ppagaxey(xzp,yz,ry,y1,y2,yref2,bgy,sgy,-tgdy,-tpdy,0.,0.,'*')
      call ppagaxey(xz ,yz,ry,y1,y2,yref2,bgy,sgy, tggy, tpgy,tgy, dg,form)
!
                       endif
!
      dgyay=dg
!
      call sdr_wfilcom('end   pfiggray')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfiggrlx(igra)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_graduations_log_x
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2011
!     ---------------------------------------------------------------+--
!
      common /figsiz/ rx,ry
      common /figori/ xz,yz
      common /figlim/ x1,x2,y1,y2
      common /grasiz/ tgrax,tgray,dgxax,dgyay,ncgrax,ncgray
      common /grapos/ ipgrax,ipgray
      common /stisiz/ tgm,tpm
      common /stipos/ ipmabx,ipmahx,ipmagy,ipmady
      common /grasty/ logstx,logsty
!
!
      data epsi  /1.e-35/
!
!     trace les graduations log de l'axe y
!     igra  : O permet de tracer les axes et les tirets des graduations
!             sans plotter les valeurs
!
      call sdr_wfilcom('begin pfiggrlx')
!
      if (x1.le.0.) call uperror_('pfiggrlx: lower bound x1<0. Not with log. plot.')
      if (logstx .ne. 1) call uperror_('pfiggrlx: grad. style not defines as log')
!
      if(igra.eq.0) then
                    tgraxx=0.
                    else
                    tgraxx=tgrax
      endif
!
! *** trace des graduations
!
      yzp=yz+ry
      tgbx=tgm*float(ipmabx)
      tpbx=tpm*float(ipmabx)
      tghx=tgm*float(ipmahx)
      tphx=tpm*float(ipmahx)
!
      if (ipgrax.eq.1) then
!                      graduations en haut
                       if(ipmahx.eq.-1) then
                                        dg=tgm*1.4
                                        else
                                        dg=tgm*0.5
                       endif
               call ppagaxlx(xz ,yz,rx,x1,x2,-tgbx,-tpbx,  0.,0.)
               call ppagaxlx(xz,yzp,rx,x1,x2, tghx, tphx,tgraxx,-dg)
!
                       else
!                      graduation en bas
                       if(ipmabx.eq.-1) then
                                        dg=tgm*1.4
                                        else
                                        dg=tgm*0.5
                       endif
               call ppagaxlx(xz,yzp,rx,x1,x2, tghx, tphx,  0.,0.)
               call ppagaxlx(xz ,yz,rx,x1,x2,-tgbx,-tpbx, tgraxx,dg)
!
      endif
!
      dgxax=dg
      ncgrax=2
!
      call sdr_wfilcom('end   pfiggrlx')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfiggrly(igra)
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_graduations_log_y
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2011
!     ---------------------------------------------------------------+--
!
      common /figsiz/ rx,ry
      common /figori/ xz,yz
      common /figlim/ x1,x2,y1,y2
      common /grasiz/ tgrax,tgray,dgxax,dgyay,ncgrax,ncgray
      common /grapos/ ipgrax,ipgray
      common /stisiz/ tgm,tpm
      common /stipos/ ipmabx,ipmahx,ipmagy,ipmady
      common /grasty/ logstx,logsty
!
!
      data epsi  /1.e-35/
!
!     trace les graduations de l'axe y
!     igra  : O permet de tracer les axes et les tirets des graduations
!             sans plotter les valeurs
!
!
      call sdr_wfilcom('begin pfiggrly')
!
      if (y1.le.0.) call uperror_('pfiggrly: lower bound y1<0. Not with log plot.')
      if (logsty .ne. 1) call uperror_('pfiggrly: grad. style not defines as log')
!
      if(igra.eq.0) then
                    tgrayy=0.
                    else
                    tgrayy=tgray
      endif
!
! *** trace des graduations
!
      xzp=xz+rx
      tggy=tgm*float(ipmagy)
      tpgy=tpm*float(ipmagy)
      tgdy=tgm*float(ipmady)
      tpdy=tpm*float(ipmady)
!
      if (ipgray.eq.1) then
!                      graduations a droite
                       if(ipmady.eq.-1) then
                                        dg=tgm*1.4
                                        else
                                        dg= tgm*0.5
                       endif
      call ppagaxly(xz ,yz,ry,y1,y2, tggy, tpgy, 0.,0.)
      call ppagaxly(xzp,yz,ry,y1,y2,-tgdy,-tpdy, tgrayy,-dg)
!
                       else
!                      graduation a gauche
                       if(ipmagy.eq.-1) then
                                        dg=tgm*1.4
                                        else
                                        dg= tgm*0.5
                       endif
      call ppagaxly(xzp,yz,ry,y1,y2,-tgdy,-tpdy, 0.,0.)
      call ppagaxly(xz ,yz,ry,y1,y2, tggy, tpgy,tgrayy,dg)
!
      endif
!
      dgyay=dg
!
! *   et pour le trace du label
      ncgray=3
!
      call sdr_wfilcom('end   pfiggrly')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfiggri_(dx,dy)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_grid on the entire figure
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      call gfiglimx(x1,x2)
      call gfiglimy(y1,y2)
!
! *** trace des lignes tous les dx,dy
!
      call pfiggrix(x1,x2,dx,y1,y2)
      call pfiggriy(y1,y2,dy,x1,x2)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfiggrix(x1,x2,dx,y1,y2)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_grid as vertical bars along x
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
! *** trace des lignes verticales tous les dx cm
!
      nbar=int((x2-x1)/dx)+1
!
      do i=1,nbar
      x=float(i-1)*dx +x1
      call pfiglin_(x,y1,x,y2)
      enddo
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfiggriy(y1,y2,dy,x1,x2)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_grid as horizontal bars along y
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
! *** trace des lignes horizontales tous les dy cm
!
      nbar=int((y2-y1)/dy)+1
!
      do i=1,nbar
      y=float(i-1)*dy +y1
      call pfiglin_(x1,y,x2,y)
      enddo
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfighis_(x1,dx,ay,n,col)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_histogram
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      dimension ay(n)
      character*(*) col
      character*1   col1
      save col1
!
! *** trace du tableau ay(n) pour x=x1+(n-1)*dx
!
      x1a=x1-dx/2.
      x1b=x1+dx/2.
!
      call glincol_(col1)
!
      do 20 k=1,2
!
      if(k.eq.1) then
                 if(col(1:1).eq.' ') go to 20
                 call dlincol_(col)
                 else
                 call dlincol_(col1)
                 endif
!
      call gfiglimy(ymin,ymax)
      call dfigppo_(x1a,ymin)
      call pfigpmo_(x1a,ay(1))
      call pfigpmo_(x1b,ay(1))
!
      do 10 i=2,n
      xia=x1a+float(i-1)*dx
      xib=x1b+float(i-1)*dx
      call pfigpmo_(xia,ay(i))
      call pfigpmo_(xib,ay(i))
   10 continue
      call pfigpmo_(xib,ymin)
      call pfigpmo_(x1a,ymin)
!
      if(k.eq.1) call pfilzon_
!
   20 continue
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfighli_(y)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_horizontal_line
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /figsiz/ rx,ry
      common /figori/ xz,yz
!
!
      call cfigpag_(0.,y,bid,yy)
      if(yy.lt.yz.or.yy.gt.yz+ry) return
!
      call dpagppo_(xz,yy)
      call ppagpmo_(xz+rx,yy)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigima_(orix,oriy,ipos,sizx,sizy,angle,image,nx,ny)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_image image in ico values
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      integer image(nx,ny)
!
!
      call gfigsca_(scx,scy)
      call cfigpag_(orix,oriy,opx,opy)
!
      spx=sizx/scx
      spy=sizy/scy
!
      call ppagima_(opx,opy,ipos,spx,spy,angle,image,nx,ny)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfiglab_(labelx,labely)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_label
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) labelx,labely
!
      call pfiglabx(labelx)
      call pfiglaby(labely)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfiglabx(labelx)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_label_x
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) labelx
!
      common /figsiz/ rx,ry
      common /figori/ xz,yz
      common /labsiz/ tlax,tlay,dlxax,dlyay
      common /labpos/ iplabx,iplaby
      common /grasiz/ tgrax,tgray,dgxax,dgyay,ncgrax,ncgray
      common /grapos/ ipgrax,ipgray
!
!
      call cchalen_(labelx,nx)
      if(nx.eq.0) return
!
      call sdr_wfilcom('begin pfiglabx')
!
! *** calcul de la largeur des caracteres du label
!
      call gfonnum_(numfon)
      call cchawid_(labelx,numfon,tlax,wid)
!
      if(wid.gt.rx) tlax=tlax*rx/wid
!
      if(iplabx.eq. 0) x=xz+rx/2.-wid/2.
      if(iplabx.eq.-1) x=xz
      if(iplabx.eq. 1) x=xz+rx -wid
!
! *** distance du label a l'axe
!
!cc   dlxax=dgxax+tgrax+tlax
      dlxax=dgxax+tgrax+tgrax/2.
!
      if(ipgrax.eq.0) then
                      y=yz-dlxax-tlax
                      else
                      y=yz+ry+dlxax
                      endif
!
! *** trace du label
!
      call ppagcha_(x,y,-1,tlax,tlax,0.,labelx)
!
      call sdr_wfilcom('end   pfiglabx')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfiglaby(labely)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_label_y
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      character*(*) labely
!
      common /figsiz/ rx,ry
      common /figori/ xz,yz
      common /labsiz/ tlax,tlay,dlxax,dlyay
      common /labpos/ iplabx,iplaby
      common /labsen/ islaby
      common /grasiz/ tgrax,tgray,dgxax,dgyay,ncgrax,ncgray
      common /grapos/ ipgrax,ipgray
!
!
      call cchalen_(labely,ny)
      if(ny.eq.0) return
!
      call sdr_wfilcom('begin pfiglaby')
!
! *** calcul de la largeur des caracteres du label
!
      call gfonnum_(numfon)
      call cchawid_(labely,numfon,tlay,wid)
!
      if(wid.gt.ry) tlay=tlay*ry/wid
!
! *** distance du label a l'axe
!
      call cchawid_('1',numfon,tgray,wid1)
      dlyay=dgyay +float(ncgray)*wid1 +wid1
!
! *** calcul du x,y pour le trace du label
!     x,y : point inf. gauche du label
!
      if(ipgray.eq.0) then
                      x=xz-dlyay
                      else
                      x=xz+rx+dlyay+tlay
                      endif
!
! *** correction selon orientation du label y
!
      if(islaby.eq.0) then
                      aa=90.
                      else
                      aa=0.
                      if(ipgray.eq.0) x= x -wid
                      endif
!
! dbg print*, 'ipgray,tlay,wid1,ncgray,dgyay,dlyay,x=',
! dbg&         ipgray,tlay,wid1,ncgray,dgyay,dlyay,x
!
      if(iplaby.eq.-1) y=yz
      if(iplaby.eq. 0) y=yz +ry/2. -wid/2.
      if(iplaby.eq. 1) y=yz+ry -wid
!
! *** trace du label
!
      call ppagcha_(x,y,-1,tlay,tlay,aa,labely)
!
      call sdr_wfilcom('end   pfiglaby')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfiglea_(x0,y0,sx,sy,ipos)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_leaf
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      call gfigsca_(scx,scy)
      call cfigpag_(x0,y0,x0p,y0p)
!
      sxp=sx/scx
      syp=sy/scy
!
      call ppaglea_(x0p,y0p,sxp,syp,ipos)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigleg_(orix,oriy,ipos,ssx,ssy,symb,col,slx,sly,leg)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_legende size in cm
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) symb, col, leg
      character*8 pcol
      save pcol
!
!
! *** trace du symbole colore
!
      call glincol_(pcol)
      call dlincol_(col)
      call pfigsym_(orix,oriy,ipos,ssx,ssy,symb)
      call pfilzon_
      call dlincol_(pcol)
      call pfigsym_(orix,oriy,ipos,ssx,ssy,symb)
!
! *** trace de la legende
!
      call cfigpag_(orix,oriy,cmx,cmy)
!
      if(ipos.eq.0) then
                    xl=cmx + ssx/2. + slx
                    yl=cmy - sly/2.
                    else
                    yl=cmy + ssy/2. -sly/2.
                    if(ipos.eq.-1) then
                                   xl=cmx + ssx + slx
                                   else
                                   xl=cmx + slx
                                   endif
                    endif
!
      call ppagcha_(xl,yl,-1,slx,sly,0.,leg)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfiglin_(orix,oriy,endx,endy)
!
!     ------------------------------------------------------------------
! *   Object : plot_figure_line
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      call cfigpag_(orix,oriy,x1,y1)
      call cfigpag_(endx,endy,x2,y2)
!
      call ppaglin_(x1,y1,x2,y2)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigpmo_(tox,toy)
!
!     ------------------------------------------------------------------
! *   Object : plot_figure_pen_motion
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      call cfigpag_(tox,toy,x1,y1)
      call ppagpmo_(x1,y1)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigros_(xc,yc,r,angle)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_rotation_symbol Earth's rotation symbol
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      a1=angle +  45.
      a2=a1    + 270.
!
      call pfigcir_(xc,yc,r,a1,a2,10.)
!
      pisd=acos(-1.)/180.
!
      xf=xc + r*cos(a2*pisd)
      yf=yc + r*sin(a2*pisd)
!
      tet=a2+70.
      tet2=(90.-tet)*pisd
!
      a=0.50*r
      b=0.30*r
!
      xa=xf-a*cos(tet*pisd)
      ya=yf-a*sin(tet*pisd)
!
      xa1= xa +b*cos(tet2)
      ya1= ya -b*sin(tet2)
!
      xa2= xa -b*cos(tet2)
      ya2= ya +b*sin(tet2)
!
      call pfiglin_(xf,yf,xa1,ya1)
      call pfiglin_(xf,yf,xa2,ya2)
!
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigsta_(y,x1,x2,width,col)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_status i.e. horizontal limited line
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) col
      character*1   col0
      save col0
!
      call cfigpag_(x1,y,xx1,yy)
      call cfigpag_(x2,y,xx2,yy)
!
      call glinwid_(wid0)
      call dlinwid_(width)
!
      call glincol_(col0)
      call dlincol_(col)
!
      call dpagppo_(xx1,yy)
      call ppagpmo_(xx2,yy)
!
      call dlinwid_(wid0)
      call dlincol_(col0)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigsym_(orix,oriy,ipos,sizx,sizy,symb)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_symbol size in cm
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) symb
!
!
      call cfigpag_(orix,oriy,xx,yy)
      call ppagsym_(xx,yy,ipos,sizx,sizy,symb)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigtav_(orix,oriy,ipos,sizx,sizy,angle,tex,val,format)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_text_and_value
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) tex,format
!
!
      call cfigpag_(orix,oriy,xx,yy)
      call gfigsca_(scax,scay)
!
      cmx=sizx/scax
      cmy=sizy/scay
!
      call ppagtav_(xx,yy,ipos,cmx,cmy,angle,tex,val,format)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigtit_(title)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_title
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) title
!
      common /figsiz/ rx,ry
      common /figori/ xz,yz
      common /titsiz/ ttit,dtax
      common /titpos/ ipotit
      common /grapos/ ipgrax,ipgray
      common /labsiz/ tlax,tlay,dlxax,dlyay
!
      data epsi  /1.e-35/
      save epsi
!
!
      if(ttit.lt.epsi) return
!
      call cchalen_(title,nct)
      if(nct.eq.0) return
!
      call sdr_wfilcom('begin pfigtit_')
!
! *** calcul de la largeur des caracteres du titre
!
      call gfonnum_(numfon)
      call cchawid_(title,numfon,ttit,wid)
!
      if(wid.gt.rx) then
                    tc=ttit*rx/wid
                    else
                    tc=ttit
                    endif
!
! *** distance du titre a l'axe
!
      if(ipgrax.eq.ipotit) then
                           dtax=dlxax+tlax+tc*1.5
                           else
                           dtax=tc*1.5
                           endif
!
      x=xz+rx/2.
      if(ipotit.eq.1) then
                      y=yz+ry+dtax
                      else
                      y=yz-dtax-tc
                      endif
!
! *** trace du titre
!
      call ppagcha_(x,y,0,tc,tc,0.,title)
!
      call sdr_wfilcom('end   pfigtit_')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigval_(orix,oriy,ipos,sizx,sizy,angle,value,format)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_value
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) format
!
!
      call cfigpag_(orix,oriy,xx,yy)
      call ppagval_(xx,yy,ipos,sizx,sizy,angle,value,format)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfigvli_(x)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_figure_vertical_line
! *   Class  : plot figure modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /figsiz/ rx,ry
      common /figori/ xz,yz
!
!
      call cfigpag_(x,0.,xx,yy)
      if(xx.lt.xz.or.xx.gt.xz+rx) return
!
      call dpagppo_(xx,yz)
      call ppagpmo_(xx,yz+ry)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine pfilzon_
!
!     ---------------------------------------------------------------+--
! *   Object : plot_fill_zone zone defined before
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      call sdr_pfilzon
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppag10pn(orix,oriy,ipos,sizx,sizy,angle,n)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_10**n symbol
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2011
!     ---------------------------------------------------------------+--
!
      character*8 format, exp
!
!
      decay=1.05*sizy
!
      tsx= 0.55*sizx
      tsy= 0.55*sizy
!
      tex= 0.40*sizx
      tey= 0.40*sizy
!
      if(n.lt.0) then
                 pex= 1.3*tsx
                 else
                 pex= 1.4*tsx
      endif
!
      pey= sizy -tey
!
! *   calcul des positions du 10 et de l'exposant
!
      if(ipos.eq.-1) then
                     xxs=orix
                     yys=oriy
                     xxe=orix + pex
                     yye=oriy + pey
                     else
                     if(ipos.eq.0) then
                                   xxs=orix -sizx/2.
                                   yys=oriy -sizy/2.
                                   xxe=orix -sizx/2. +pex
                                   yye=oriy -sizy/2. +pey
                                   else
                                   xxs=orix -sizx -tsx
                                   yys=oriy
                                   xxe=orix -sizx -tsx +pex
                                   yye=oriy +pey
                     endif
      endif
!
! *   plot du '10'
!
      call ppagcha_(xxs,yys,-1,tsx,tsy,angle,'10')
      call cbesfori(n,format)
!
! *  plot de l'exposant
!
      write(exp,format) n
!
      call ppagcha_(xxe,yye,-1,tex,tey,angle,exp)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagarr_(orix,oriy,ipos,bodyl,bodyw,headl,headw,angle)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_arrow
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      real x(9),y(9)
      save x,y
!
      data epsi  /1.e-35/
      save epsi
!
!
      pisd=acos(-1.)/180.
!
      if(abs(bodyl).lt.epsi.and.abs(bodyw).lt.epsi) return
!
      ax=bodyl-headl
      if(ax.lt.0.) ax=0.
      bx=headl
      cy=bodyw/2.
      dy=headw/2.
!
      if(ipos.eq.-1) then
                     xx=orix
                     yy=oriy
                     else
                     if(ipos.eq.1) then
                                   xx=orix-bodyl*cos(angle*pisd)
                                   yy=oriy-bodyl*sin(angle*pisd)
                                   else
                                   xx=orix-bodyl*cos(angle*pisd)/2.
                                   yy=oriy-bodyl*sin(angle*pisd)/2.
                                   endif
                     endif
!
      x(1)= 0.
      x(2)= 0.
      x(3)= ax
      x(4)= ax
      x(5)= ax+bx
      x(6)= ax
      x(7)= ax
      x(8)= 0.
      x(9)= 0.
!
      y(1)=  0.
      y(2)= -cy
      y(3)= -cy
      y(4)= -dy
      y(5)=  0.
      y(6)=  dy
      y(7)=  cy
      y(8)=  cy
      y(9)=  0.
!
      do 10 i=1,9
      call cplarot_(0.,0.,angle,x(i),y(i),x2,y2)
      x(i)=xx+x2
      y(i)=yy+y2
   10 continue
!
      call dpagppo_(x(1),y(1))
!
      do 20 i=2,9
      call ppagpmo_(x(i),y(i))
   20 continue
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagaxex(ox,oy,rx,x1,x2,xref,bgx,sgx,tgm,tpm,tg,dga,fg)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_axe_x, with no predefined options
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) fg
      character*8 fg_8
      character*16 for
      character*1 ifg
      save fg_8,for,ifg
!
      data epsi /1.e-10/
      save epsi
!
! *** trace les graduations d'un axe X entierement defini
!     modif P. Robert, Aout 2005, pour graduations quelconques
!
!      ox,oy=coordonnees en cm de l'origine de l'axe
!      rx=longueur en cm de l'axe x
!
!      x1,x2 : valeurs en unite d'axe des bornes, en ox et ox+rx
!      xref  : valeur de reference pour les graduations, multiple de bgx
!      bgx   : big   graduation x, intervalle entre 2 grandes marques
!      sgx   : small graduation x, intervalle entre 2 petites marques
!
!      tgm   : taille en cm des grandes marques
!      tpm   : taille en cm des petites marques
!      tg    : taille en cm des graduations
!      dga   : distance en cm des graduations a l'axe
!      fg    : format des graduations  ex'  >(f7.2)>
!
! *** on ne fait rien si la taille des marques est trop petite
!
      if(abs(tgm).lt.epsi) return
!
! *** nombre maximum de grandes marques gauches et droites
!
      ngmg= int((xref-x1)/bgx +0.1) +1
      ngmd= int((x2-xref)/bgx +0.1) +1
!
! *** modif des intervalle de graduation si pas assez de grandes marques
!
      if(ngmg +ngmd.le.1) then
                          bgx=bgx/2.
                          sgx=sgx/2.
                          ngmg= int((xref-x1)/bgx +0.1) +1
                          ngmd= int((x2-xref)/bgx +0.1) +1
                          endif
!
! *** nombre de petites marques entre 2 grandes marques
!
      npm= int(bgx/sgx +0.1) -1
!
! *** position en cm de la graduation de reference
!
      dx= x2-x1
      oxref= ox +(xref-x1)*rx/dx
!
      bgxcm= bgx*rx/dx
      sgxcm= sgx*rx/dx
!
! *** calcul du format si option '*'
!
      fg_8=fg
      if(fg_8(1:1).eq.'*'.or.fg_8(1:3).eq.'(*)') then
                                             call cbesfor_(xref+bgx,for)
                                             else
                                             for=fg
                                             endif
!
! *   verif
!
      call uverfor_(for,'ppagaxex')
      call udecfor_(for,ifg,ncfgra,ndec)
      if(ncfgra.le.0) call uperror_('ppagaxex: abnormal format')
!
! *** correction eventuelle de la taille des graduations
!
      if(bgxcm.lt.tg*float(ncfgra+2)) then
                                      tcx=bgxcm/float(ncfgra+2)
                                      else
                                      tcx=tg
                                      endif
!
      if(tcx.lt.tg/1.5) then
                        tcy=tcx*1.5
                        else
                        tcy=tg
                        endif
!
      if(dga.gt.0.) then
                    isig=1
                    else
                    isig=-1
                    endif
!
      dga2=dga +float(isig)*tcy/2.
!
! XXX on trace les graduations a partir de la valeur de reference xref,
!     a gauche et puis a droite
!
! *** graduation de l'axe a gauche de la grad. de reference
!
!
!c *   tolerence pour la precision de la position des graduations
!
      epsicm=1.e-3
!
      do 10 i= 1,ngmg+2
      xi = oxref -float(i-1)*bgxcm
      gra=  xref -float(i-1)*bgx
!
      if(xi.ge.ox-epsicm.and.xi.le.ox+rx+epsicm) then
! *                grandes marques
                   call dpagppo_(xi,oy)
                   call ppagpmo_(xi,oy-tgm)
! *                graduation correspondante
                   if(x1.lt.0.) then
                                xig=xi-tcx/4.
                                else
                                xig=xi
                                endif
                   call ppagval_(xig,oy-dga2,0,tcx,tcy,0.,gra,for)
                   endif
!
! *   petites marques
!
      do 20 j=1,npm
      xj= xi -float(j)*sgxcm
      if(xj.ge.ox-epsicm.and.xj.le.ox+rx+epsicm) then
                   call dpagppo_(xj,oy)
                   call ppagpmo_(xj,oy-tpm)
                   endif
   20 continue
!
   10 continue
!
!
! *** graduation de l'axe a droite de la grad. de reference
!
      do 30 i= 1,ngmd+2
      xi = oxref +float(i-1)*bgxcm
      gra=  xref +float(i-1)*bgx
!
      if(xi.le.ox+rx+epsicm.and.xi.ge.ox-epsicm.and.i.gt.1) then
! *                grandes marques
                   call dpagppo_(xi,oy)
                   call ppagpmo_(xi,oy-tgm)
! *                graduation correspondante
                   if(x1.lt.0.) then
                                xig=xi-tcx/4.
                                else
                                xig=xi
                                endif
                   call ppagval_(xig,oy-dga2,0,tcx,tcy,0.,gra,for)
                   endif
!
! *   petites marques
!
      do 40 j=1,npm
      xj= xi +float(j)*sgxcm
      if(xj.le.ox+rx+epsicm.and.xj.ge.ox-epsicm) then
                                   call dpagppo_(xj,oy)
                                   call ppagpmo_(xj,oy-tpm)
                                   endif
   40 continue
!
   30 continue
!
! *** trait plein sur l'axe
!
      call dpagppo_(ox,oy)
      call ppagpmo_(ox+rx,oy)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagaxey(ox,oy,ry,y1,y2,yref,bgy,sgy,tgm,tpm,tg,dga,fg)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_axe_y, with no predefined options
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) fg
      character*8  fg_8
      character*16  for
      character*1 ifg
      save fg_8,for,ifg
!
      data epsi /1.e-10/
      save epsi
!
! *** trace les graduations d'un aye Y entierement defini
!     modif P. Robert, Aout 2005, pour graduations quelconques
!
!      ox,oy=coordonnees en cm de l'origine de l'aye
!      ry=longueur en cm de l'aye y
!
!      y1,y2 : valeurs en unite d'aye des bornes, en oy et oy+ry
!      yref  : valeur de reference pour les graduations, multiple de bgy
!      bgy   : big   graduation y, intervalle entre 2 grandes marques
!      sgy   : small graduation y, intervalle entre 2 petites marques
!
!      tgm   : taille en cm des grandes marques
!      tpm   : taille en cm des petites marques
!      tg    : taille en cm des graduations
!      dga   : distance en cm des graduations a l'aye
!      fg    : format des graduations  ey'  >(f7.2)>
!
! *** on ne fait rien si la taille des marques est trop petite
!
      if(abs(tgm).lt.epsi) return
!
! *** nombre maximum de grandes marques gauches et droites
!
      ngmg= int((yref-y1)/bgy +0.1) +1
      ngmd= int((y2-yref)/bgy +0.1) +1
!
! *** modif des intervalle de graduation si pas assez de grandes marques
!
      if(ngmg +ngmd.le.1) then
                          bgy=bgy/2.
                          sgy=sgy/2.
                          ngmg= int((yref-y1)/bgy +0.1) +1
                          ngmd= int((y2-yref)/bgy +0.1) +1
                          endif
!
! *** nombre de petites marques entre 2 grandes marques
!
      npm= int(bgy/sgy +0.1) -1
!
! *** position en cm de la graduation de reference
!
      dy= y2-y1
      oyref= oy +(yref-y1)*ry/dy
!
      bgycm= bgy*ry/dy
      sgycm= sgy*ry/dy
!
! *** calcul du format si option '*'
!
      fg_8=fg
      if(fg_8(1:1).eq.'*'.or.fg_8(1:3).eq.'(*)') then
                                             call cbesfor_(yref+bgy,for)
                                             else
                                             for=fg
                                             endif
!
! *   verif
!
      call uverfor_(for,'ppagaxey')
      call udecfor_(for,ifg,ncfgra,ndec)
      if(ncfgra.le.0) call uperror_('ppagaxey: abnormal format')
!
! *** correction eventuelle de la taille des graduations
!
      if(tg/bgycm.ge.0.6) then
                          tcy=0.6*bgycm
                          else
                          tcy=tg
                          endif
      tcx=tcy
!
      if(dga.gt.0.) then
!                 * graduations a gauche
                    isig=1
                    else
!                 * graduations a droite
                    isig=-1
                    endif
!
!
! XXX on trace les graduations a partir de la valeur de reference yref,
!     a gauche et puis a droite (en dessous et au dessus)
!
! *** graduation de l'axe a gauche de la grad. de reference
!
! *   tolerence pour la precision de la position des graduations
!
      epsicm=1.e-3
      do 10 i= 1,ngmg+2
      yi = oyref -float(i-1)*bgycm
      gra=  yref -float(i-1)*bgy
!
      if(yi.ge.oy-epsicm.and.yi.le.oy+ry+epsicm) then
! *            grandes marques
               call dpagppo_(ox,yi)
               call ppagpmo_(ox+tgm,yi)
! *            graduation correspondante
               call ppagval_(ox-dga,yi-tcy*0.5,isig,tcx,tcy,0.,gra,for)
               endif
!
! *   petites marques
!
      do 20 j=1,npm
      yj= yi -float(j)*sgycm
      if(yj.ge.oy-epsicm.and.yj.le.oy+ry+epsicm) then
                                   call dpagppo_(ox,yj)
                                   call ppagpmo_(ox+tpm,yj)
                                   endif
   20 continue
!
   10 continue
!
!
! *** graduation de l'axe a droite  de la grad. de reference
!
      do 30 i= 1,ngmd+2
      yi = oyref +float(i-1)*bgycm
      gra=  yref +float(i-1)*bgy
!
      if(yi.le.oy+ry+epsicm.and.yi.ge.oy-epsicm.and.i.gt.1) then
! *            grandes marques
               call dpagppo_(ox,yi)
               call ppagpmo_(ox+tgm,yi)
! *            graduation correspondante
               call ppagval_(ox-dga,yi-tcy*0.5,isig,tcx,tcy,0.,gra,for)
               endif
!
! *   petites marques
!
      do 40 j=1,npm
      yj= yi +float(j)*sgycm
      if(yj.le.oy+ry+epsicm.and.yj.ge.oy-epsicm) then
                                   call dpagppo_(ox,yj)
                                   call ppagpmo_(ox+tpm,yj)
                                   endif
   40 continue
!
   30 continue
!
! *** trait plein sur l'axe
!
      call dpagppo_(ox,oy)
      call ppagpmo_(ox,oy+ry)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagaxlx(ox,oy,rx,x1,x2,tgm,tpm,tg,dga)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_axe_log_x, with no predefined options
! *   Class  : plot page modules of Rogralib Software
! *   Author : F. Mottez, P.Robert, 2011
!     ---------------------------------------------------------------+--
!
      real lx1,lx2
!
      data epsi /1.e-10/
!
!     trace les graduations logaritmiques d'un axe X
!                entierement defini
!     modif    P. Robert, Aout 2005, pour graduations quelconques,
!     creation F. Mottez, Mai 2006, en log a partir de ppagaxex
!     revision P. Robert, Septembre 2011
!
!      ox,oy=coordonnees en cm de l'origine de l'axe
!      rx=longueur en cm de l'axe x
!
!      x1,x2 : valeurs en unite d'axe des bornes, en ox et ox+rx
!      tgm   : taille en cm des grandes marques
!      tpm   : taille en cm des petites marques
!      tg    : taille en cm des graduations
!      dga   : distance en cm des graduations a l'aye
!
! *** on ne fait rien si la taille des marques est trop petite
!
      if(abs(tgm).lt.epsi) return
!
! *** on verifie que les bornes sont des puissances de 10
!
      call cmanexp_(x1,rman1,iex1)
      call cmanexp_(x2,rman2,iex2)
!
      tol=abs(rman1-0.1)
      if (tol.gt.1.e-6) then
          print*, 'ppagaxlx: x1 must be a power of 10'
          print*, 'mantisse=',rman1, ' mant-0.1=',tol,' > 1.e-6'
          call uperror_('ppagaxlx: x1 must be a power of 10')
      endif

      tol=abs(rman2-0.1)
            if (tol.gt.1.e-6) then
                print*, 'ppagaxlx: x2 must be a power of 10'
                print*, 'mantisse=',rman2, ' mant-0.1=',tol,' > 1.e-6'
                call uperror_('ppagaxlx: x2 must be a power of 10')
      endif
!
! *** Nombre de grandes marques
!     Les grandes marques sont espacees par decades en valeur,
!     et lineairement en longueur.
!
      lx1   = log10(x1)
      lx2   = log10(x2)
!
      nbgx = int(lx2-lx1 +epsi) +1
!
! *** nombre de petites marquesc  entre 2 grandes marques,
!     espacees lineairement en valeur, et logaritmiquement en longueur,
!
      npm= 10
!
! *** taille en cm de l'espace entre 2 grandes marques
!
      bgxcm= rx/float(nbgx-1)
!
! *** correction eventuelle de la taille des graduations
!
      ncfgra=2
!
      if(bgxcm.lt.tg*float(ncfgra+2)) then
                                      tcx=bgxcm/float(ncfgra+2)
                                      else
                                      tcx=tg
                                      endif
!
      if(tcx.lt.tg/1.5) then
                        tcy=tcx*1.5
                        else
                        tcy=tg
                        endif
!
      if(dga.gt.0.) then
                    isig=1
                    else
                    isig=-1
                    endif
!
      dga2=dga +float(isig)*tcy/2.
!
! *** graduation de l'axe
!
!c *  tolerence pour la precision de la position des graduations
!
      epsicm=1.e-3
!
      do 10 i= 1,nbgx
      xi = ox +float(i-1)*bgxcm
      lgra= int(log10(x1)+epsi) +i -1
!
      if(xi.ge.ox-epsicm.and.xi.le.ox+rx+epsicm) then
! *        grandes marques
           call dpagppo_(xi,oy)
           call ppagpmo_(xi,oy-tgm)
! *        graduation correspondante
           call ppag10pn(xi-tcx*0.5,oy-dga-0.7*tcy,0,tcx,tcy,0.,lgra)
      endif
!
! *   petites marques
!
      do 20 j=1,npm
      xj= xi +log10(float(j)*10./float(npm))*bgxcm
      if(xj.le.ox+rx+epsicm.and.xj.ge.ox-epsicm) then
            call dpagppo_(xj,oy)
            call ppagpmo_(xj,oy-tpm)
      endif
   20 continue
!
   10 continue
!
! *** trait plein sur l'axe
!
      call dpagppo_(ox,oy)
      call ppagpmo_(ox+rx,oy)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagaxly(ox,oy,ry,y1,y2,tgm,tpm,tg,dga)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_axe_log_y, with no predefined options
! *   Class  : plot page modules of Rogralib Software
! *   Author : F. Mottez, P.Robert, 2011
!     ---------------------------------------------------------------+--
!
      real ly1,ly2
!
      data epsi /1.e-10/
!
!     trace les graduations logaritmiques d'un axe Y
!                entierement defini
!     modif    P. Robert, Aout 2005, pour graduations quelconques,
!     creation F. Mottez, Mai 2006, en log a partir de ppagaxey
!     revision P. Robert, Septembre 2011
!
!      ox,oy=coordonnees en cm de l'origine de l'axe
!      ry=longueur en cm de l'axe y
!
!      y1,y2 : valeurs en unite d'axe des bornes, en oy et oy+rc
!      tgm   : taille en cm des grandes marques
!      tpm   : taille en cm des petites marques
!      tg    : taille en cm des graduations
!      dga   : distance en cm des graduations a l'aye
!
! *** on ne fait rien si la taille des marques est trop petite
!
      if(abs(tgm).lt.epsi) return
!
! *** on verifie que les bornes sont des puissances de 10
!
      call cmanexp_(y1,rman1,iex1)
      call cmanexp_(y2,rman2,iex2)
!
      tol=abs(rman1-0.1)
      if (tol.gt.1.e-6) then
          print*, 'ppagaxly: y1 must be a power of 10'
          print*, 'mantisse=',rman1, ' mant-0.1=',tol,' > 1.e-6'
          call uperror_('ppagaxly: y1 must be a power of 10')
      endif

      tol=abs(rman2-0.1)
            if (tol.gt.1.e-6) then
                print*, 'ppagaxly: y2 must be a power of 10'
                print*, 'mantisse=',rman2, ' mant-0.1=',tol,' > 1.e-6'
                call uperror_('ppagaxly: y2 must be a power of 10')
      endif
!
! *** Nombre de grandes marques
!     Les grandes marques sont espacees par decades en valeur,
!     et lineairement en longueur.
!
      ly1   = log10(y1)
      ly2   = log10(y2)

      nbgy = int(ly2-ly1 +epsi) +1
! dbx print*,'ly1,ly2,nbgy=',ly1,ly2,nbgy
!
! *** nombre de petites marquesc  entre 2 grandes marques,
!     espacees lineairement en valeur, et logaritmiquement en longueur,
!
      npm= 10
!
! *** taille en cm de l'espace entre 2 grandes marques
!
      bgycm= ry/float(nbgy-1)
!
! *** correction eventuelle de la taille des graduations
!
      if(bgycm.lt.tg) then
                      tcy=bgycm*0.8
                      else
                      tcy=tg
                      endif
!
      if(tcy.lt.tg/1.5) then
                        tcx=tcy*1.5
                        else
                        tcx=tg
                        endif
!
      if(dga.gt.0.) then
                    isig=1
                    else
                    isig=-1
                    endif
!
      dga2=dga +float(isig)*tcx/2.
!
! *** graduation de l'axe
!
!c *   tolerence pour la precision de la position des graduations
!
      epsicm=1.e-3
!
      do 10 i= 1,nbgy
      yi = oy +float(i-1)*bgycm
      lgra= int(log10(y1)+epsi) +i -1
! dbx print*,'i,lgra=',i,lgra
!
!
      if(yi.le.oy+ry+epsicm.and.yi.ge.oy-epsicm) then
! *        grandes marques
           call dpagppo_(ox,yi)
           call ppagpmo_(ox+tgm,yi)
! *        graduation correspondante
!
           call ppag10pn(ox-dga,yi-tcy*0.3,isig,tcx,tcy,0.,lgra)
      endif
!
! *   petites marques
!
      do 20 j=1,npm
      yj= yi +log10(float(j)*10./float(npm))*bgycm
      if(yj.le.oy+ry+epsicm.and.yj.ge.oy-epsicm) then
            call dpagppo_(ox,yj)
            call ppagpmo_(ox+tpm,yj)
      endif
   20 continue
!
   10 continue
!
! *** trait plein sur l'axe
!
      call dpagppo_(ox,oy)
      call ppagpmo_(ox,oy+ry)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagcha_(orix,oriy,ipos,sizx,height,angle,chast)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_character_string ipos=-1,0,+1 sizx not used
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) chast
!
      common /numvec/ nbppo,nbpmo,nbtpo,nbtmo
      common /penpos/ pepox,pepoy
      common /fonnum/ nufon, bodfon
      common /pagfor/ iorpag
      common /pagori/ popagx,popagy
      common /pagsiz/ tpx,tpy
      common /boupag/ xminb,xmaxb,yminb,ymaxb
!
      data epsi  /1.e-35/
      save epsi
!
      pisd=acos(-1.)/180.
!
! *** trace d un texte
!
!     ipos=-1 origine coin inf gauche
!     ipos= 0 origine au milieu
!     ipos= 1 origine coin inf droit
!
!
! *** on arrete si taille nulle ou chaine blanche
!
      if(sizx.lt.height/10.) call uperror_('ppagcha_: sizx <height/10.')
!
      if(height.lt.epsi) return
!
      call cchalen_(chast,n)
      if(n.eq.0) return
!
! *** test ipos
!
      if(ipos.eq.-1 .or.ipos.eq. 0 .or.ipos.eq. 1) then
!                    OK
                     else
                     call uperror_('ppagcha_: ipos # of -1,0,+1')
                     endif
!
! *** calcul de la longueur de la chaine en cm
!
      call cchawid_(chast,nufon,height,width)
!
! *** influence de l'angle pour le positionnement
!
      ar= angle*pisd
      ax= width*cos(ar)
      ay= width*sin(ar)
      bx=height*sin(ar)
      by=height*cos(ar)
!
! *** position standard coin inferieur gauche (ipos= -1)
!
      xx=orix-popagx
      yy=oriy-popagy
!
! *** on ramene les coordonnees au point inf. gauche
!     pour l'option centree ou cadree a droite
!
      if(ipos.eq.0) then
                    xx=orix-popagx-ax/2.+bx/2.
                    yy=oriy-popagy-ay/2.-by/2.
                    endif
!
      if(ipos.eq.1) then
                    xx=orix-popagx-ax+bx/2.
                    yy=oriy-popagy-ay
                    endif
!
! *** on ne trace rien si la coordonnee est en dehors de la page
!
! /// if(xx.lt.0.or.xx.gt.tpx) return
! /// if(yy.lt.0.or.yy.gt.tpy) return
!
! /// trace du texte par police interne  espacement fixe
!
! /// OBSOLETE
!
! /// correction de l'angle si format paysage
!
! ///     if(iorpag.eq.0) then
! ///                     apl=angle
! ///                     else
! ///                     apl=angle+90.
! ///                     endif
!
! /// if(ifon.eq.0) then
! ///               do 10 i=1,n
! ///               xxi=xx+(i-1)*ax
! ///               yyi=yy+(i-1)*ay
! ///               call upchael_(chast(i:i),xxi,yyi,sizx,height,apl)
! ///  10           continue
! ///               return
! ///               endif
!
! *** trace du texte par appel au generateur graphique du driver
!
! **  calcul et reinitialisation eventuelle du corps de la fonte
!
      call cfonbod_(nufon,height,fonbod)
      call sdr_dfonnab(nufon,fonbod)
!
! *** correction  si format paysage
!
      if(iorpag.eq.0) then
                      x1=xx
                      y1=yy
                      apl=angle
!
                      else
                      x1= tpy-yy
                      y1=xx
                      apl=angle+90.
                      endif
!
! **  trace
!
      call sdr_ppagcha(chast(1:n),x1,y1,apl)
!
      nbppo=nbppo+1
      pepox=xx
      pepoy=yy
!
! *** update des extrema du trace (page/paysage cm unit)
!
      ca= cos(apl*pisd)
      sa= sin(apl*pisd)
!
      x2= x1 + width*ca
      x3= x2 -height*sa
      x4= x1 -height*sa
!
      y2= y1 + width*sa
      y3= y2 +height*ca
      y4= y1 +height*ca
!
      xminb= min(xminb, x1,x2,x3,x4)
      yminb= min(yminb, y1,y2,y3,y4)
      xmaxb= max(xmaxb, x1,x2,x3,x4)
      ymaxb= max(ymaxb, y1,y2,y3,y4)
!
      call sdr_updbbox
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagchav(x,y,ipos,tax,tay,texte)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_character_string_v vertically, top to bottom
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) texte
!
      data epsi  /1.e-35/
      save epsi
!
!
! *** trace d'un texte vertical (enseigne)
!
!
      if(tax.lt.epsi) return
      if(tay.lt.epsi) return
!
      call cchalen_(texte,nbcara)
!
      do 10 i=1,nbcara
      yy=y+float(nbcara-1)*tay
      call ppagcha_(x,yy,ipos,tax,tay,0.,texte(i:i))
   10 continue
!
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagcir_(xc,yc,r,teta1,teta2,dteta)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_circular_arc
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      if(teta2.gt.teta1) then
                         n=int((teta2-teta1)/dteta+0.5)
                         else
                         n=int((teta2-teta1+360.)/dteta+0.5)
                         endif
!
      call cpolcar_(r,teta1,x,y)
      call dpagppo_(x+xc,y+yc)
!
      do 10 i=1,n
      tet=float(i)*dteta+teta1
      call cpolcar_(r,tet,x,y)
      call ppagpmo_(x+xc,y+yc)
   10 continue
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagcmah(orix,oriy,sizx,sizy,isens)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_palette horizontal, isens=+1 -> red on right
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /colmap/ hueu,satu,briu,nbcolu
!
      real hueu(256),satu(256),briu(256)
!
      integer imaico(256,1)
      save imaico
!
!
! *** conversion de la color map courante en code ico
!
      do 10 i=1,nbcolu
!
      if(isens.gt.0) then
                     ii= nbcolu-i+1
                     else
                     ii=i
                     endif
!
      call chsbrgb_(hueu(ii),satu(ii),briu(ii),r,g,b)
!
      ir=int(r*255.)
      ig=int(g*255.)
      ib=int(b*255.)
!
      call crgbico_(ir,ig,ib,imaico(i,1))
!
   10 continue
!
! *** trace
!
      call ppagima_(orix,oriy,-1,sizx,sizy,0.,imaico,nbcolu,1)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagcmav(orix,oriy,sizx,sizy,isens)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_palette vertical, isens=+1 -> red on top
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /colmap/ hueu,satu,briu,nbcolu
!
      real hueu(256),satu(256),briu(256)
!
      integer imaico(256,1)
      save imaico
!
!
! *** conversion de la color map courante en code ico
!
      do 10 i=1,nbcolu
!
      if(isens.gt.0) then
                     ii= nbcolu-i+1
                     else
                     ii=i
                     endif
!
      call chsbrgb_(hueu(ii),satu(ii),briu(ii),r,g,b)
!
      ir=int(r*255.)
      ig=int(g*255.)
      ib=int(b*255.)
!
      call crgbico_(ir,ig,ib,imaico(i,1))
!
   10 continue
!
! *** trace
!
      call ppagima_(orix-sizx,oriy,-1,sizx,sizy,90.,imaico,nbcolu,1)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagcor_
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_corners
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /pagsiz/ tpx,tpy
!
!
      call sdr_wfilcom('begin ppagcor_')
      call ppagrco_(0.,0.,tpx,tpy,tpy/20.)
      call sdr_wfilcom('end   ppagcor_')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagell_(xc,yc,a,b,rincli,teta1,teta2,dteta)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_elliptical_arc
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      pisd=acos(-1.)/180.
!
      n=int((teta2-teta1)/dteta+0.5)
!
      tetr=teta1*pisd
      x=a*cos(tetr) + xc
      y=b*sin(tetr) + yc
      call cplarot_(xc,yc,rincli,x,y,x2,y2)
      call dpagppo_(x2,y2)
!
      do 10 i=1,n
      tet=float(i)*dteta+teta1
      tetr=tet*pisd
      x=a*cos(tetr) + xc
      y=b*sin(tetr) + yc
      call cplarot_(xc,yc,rincli,x,y,x2,y2)
      call ppagpmo_(x2,y2)
   10 continue
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagfoo_(foot)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_foot add ps name
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /pagnum/ npage
      common /npsfil/ psfil
      common /foofon/ ifonf, hfonf
!
      character*(*) foot
      character*255 psfil
      character*255 com
      save com
!
!
      call sdr_wfilcom('begin ppagfoo_')
!
      call cchalen_(foot,ncf)
      call cchalen_(psfil,ncp)
!
      if(npage.eq.1) then
                     write(com,100) foot(1:ncf),psfil(1:ncp)
                     else
                     write(com,200) foot(1:ncf),psfil(1:ncp),npage
                     endif
!
      call gfonnum_(ifon)
      call dfonnum_(ifonf)
      call ppagcha_(0.2,hfonf/2.+0.07,-1,hfonf,hfonf,0.,com)
      call dfonnum_(ifon)
!
      call sdr_wfilcom('end   ppagfoo_')
!
  100 format(a,2x,a)
  200 format(a,2x,a,' - Page',i3)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagfra_
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_frame
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /pagsiz/ tpx,tpy
!
!
      call sdr_wfilcom('begin ppagfra_')
!
      call dpagppo_(0.,0.)
      call ppagpmo_(tpx,0.)
      call ppagpmo_(tpx,tpy)
      call ppagpmo_(0.,tpy)
      call ppagpmo_(0.,0.)
!
      call sdr_wfilcom('end   ppagfra_')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppaggri_
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_grid on the entire page
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
! *** trace du cadre de la page
!
      call gpagsiz_(sx,sy)
!
! *** trace des lignes tous les cm.
!
      do ix=1,int(sx),1
      call ppagvli_(float(ix))
      enddo
!
      do iy=1,int(sy),1
      call ppaghli_(float(iy))
      enddo
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppaggrix(x1,x2,dx,y1,y2)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_grid_x as vertical bars along x
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
! *** trace des lignes verticales tous les dx cm
!
      nbar=int((x2-x1)/dx)+1
!
      do i=1,nbar
      x=float(i-1)*dx +x1
      call ppaglin_(x,y1,x,y2)
      enddo
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppaggriy(y1,y2,dy,x1,x2)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_grid_y as horizontal bars along y
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
! *** trace des lignes horizontales tous les dy cm
!
      nbar=int((y2-y1)/dy)+1
!
      do i=1,nbar
      y=float(i-1)*dy +y1
      call ppaglin_(x1,y,x2,y)
      enddo
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppaghea_(header)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_header add st.datime
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /pagsiz/ tpx,tpy
      common /heafon/ ifonh, hfonh
      common /heapos/ ipohea,dishea
!
      character*(*) header
      character*26  asdati
      character*255 hhdat
!
      save asdati,hhdat
!
!
      call sdr_wfilcom('begin ppaghea_')
!
      call gasdati_(asdati)
      call cchalen_(header,nch)
!
      hhdat=header(1:nch)//'  '//asdati
!
! *   position
      if(ipohea.eq.0) then
                      ox=tpx/2.
                      else
                      if(ipohea.eq.1) then
                                      ox=tpx -0.2
                                      else
                                      ox= 0.2
                                      endif
                      endif
      oy=tpy-dishea
!
! *   plot
!
      call gfonnum_(ifon)
      call dfonnum_(ifonh)
      call ppagcha_(ox,oy,ipohea,hfonh,hfonh,0.,hhdat)
      call dfonnum_(ifon)
!
      call sdr_wfilcom('end   ppaghea_')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppaghli_(y)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_horizontal_line
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /pagsiz/ tpx,tpy
!
!
      call dpagppo_(0.,y)
      call ppagpmo_(tpx,y)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagima_(orix,oriy,ipos,sizx,sizy,angle,image,nx,ny)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_image image in ico values
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      integer image(nx,ny)
!
      common /numvec/ nbppo,nbpmo,nbtpo,nbtmo
      common /penpos/ pepox,pepoy
      common /pagfor/ iorpag
      common /pagori/ popagx,popagy
      common /pagsiz/ tpx,tpy
      common /boupag/ xminb,xmaxb,yminb,ymaxb
!
      pisd=acos(-1.)/180.
!
      if(nx.gt.300000) call uperror_('ppagima_:nb. points en x >300000')
!
      call sdr_wfilcom('begin ppagima_')
!
! *** test ipos
!
      if(ipos.eq.-1 .or.ipos.eq. 0 .or.ipos.eq. 1) then
!                    OK
                     else
                     call uperror_('ppagima_: ipos # of -1,0,+1')
                     endif
!
! *** influence de l'angle sur le positionnement
!
      ar=angle*pisd
      ax= sizx*cos(ar)
      ay= sizx*sin(ar)
      bx= sizy*sin(ar)
      by= sizy*cos(ar)
!
! *** position standard coin inferieur gauche (ipos= -1)
!
      xx=orix-popagx
      yy=oriy-popagy
!
! *** on ramene les coordonnees au point inf. gauche
!     pour l'option centree ou cadree a droite
!
      if(ipos.eq.0) then
                    xx=orix-popagx-ax/2.+bx/2.
                    yy=oriy-popagy-ay/2.-by/2.
                    endif
!
      if(ipos.eq.1) then
                    xx=orix-popagx-ax+bx/2.
                    yy=oriy-popagy-ay
                    endif
!
! *** on ne trace rien si la coordonnee est en dehors de la page
!
! /// if(xx.lt.0.or.xx.gt.tpx) return
! /// if(yy.lt.0.or.yy.gt.tpy) return
!
! *** correction de l'angle si format paysage
!
      if(iorpag.eq.0) then
                      x1=xx
                      y1=yy
                      apl=angle
!
                      else
                      x1=tpy-yy
                      y1=xx
                      apl=angle+90.
                      endif
!
! *** trace de l'image
!
      call sdr_ppagima(x1,y1,sizx,sizy,apl,image,nx,ny)
!
      nbppo=nbppo+1
      pepox=xx
      pepoy=yy
!
! *** update des extrema du trace (page/paysage cm unit)
!
      ca= cos(apl*pisd)
      sa= sin(apl*pisd)
!
      x2= x1 +sizx*ca
      x3= x2 -sizy*sa
      x4= x1 -sizy*sa
!
      y2= y1 +sizx*sa
      y3= y2 +sizy*ca
      y4= y1 +sizy*ca
!
      xminb= min(xminb, x1,x2,x3,x4)
      yminb= min(yminb, y1,y2,y3,y4)
      xmaxb= max(xmaxb, x1,x2,x3,x4)
      ymaxb= max(ymaxb, y1,y2,y3,y4)
!
      call sdr_updbbox
      call sdr_wfilcom('end   ppagima_')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppaglea_(x0,y0,sx,sy,ipos)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_pag_leaf
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!     trace d'une feuille d'arbre, origine = pointe basse de la tige
!     ipos=-1, feuille vers la gauche, +1 vers la droite
!
      real arci1x(7),arci1y(7),trai1x(4),trai1y(4)
      real arci2x(7),arci2y(7),trai2x(4),trai2y(4)
!
      real tra1x(4),tra1y(4)
      real tra2x(4),tra2y(4)
!
      real centx(7),centy(7)
      real teta1(7),teta2(7)
!
! *** save for gfotran
!
      save arci1x,arci1y,trai1x,trai1y
      save arci2x,arci2y,trai2x,trai2y
!
      save tra1x,tra1y
      save tra2x,tra2y
!
      save centx,centy
      save teta1,teta2
!
! *** ancienne version queue longue
!
! /// data arci1x /  0.0, -9.0, -9.0, -9.8, -1.8, -1.8,  0.0 /
! /// data arci1y /  0.0,  3.2,  7.9,  9.7,  7.2,  3.2,  1.2 /
! /// data arci2x / -1.9, -7.0, -9.8, -8.5, -3.8,  0.0,  0.0 /
! /// data arci2y /  1.2,  1.2,  9.7,  9.2,  9.2,  1.2,  0.0 /
!
! *** new version queue courte
!
      data arci1x /  0.0, -8.3, -8.3, -9.1, -1.1, -1.1, -0.3 /
      data arci1y /  0.0,  2.4,  7.1,  8.9,  6.4,  2.4,  0.7 /
      data arci2x / -1.2, -6.3, -9.1, -7.8, -3.1, -0.3,  0.0 /
      data arci2y /  0.4,  0.4,  8.9,  8.4,  8.4,  0.7,  0.0 /
!
!
! *** concordance des bords avec les cercles
!
      trai1x(1)=arci2x(1)
      trai1y(1)=arci2y(1)
!
      trai2x(1)=arci2x(2)
      trai2y(1)=arci2y(2)
!
!
      trai1x(2)=arci1x(2)
      trai1y(2)=arci1y(2)
!
      trai2x(2)=arci1x(3)
      trai2y(2)=arci1y(3)
!
!
      trai1x(3)=arci2x(4)
      trai1y(3)=arci2y(4)
!
      trai2x(3)=arci2x(5)
      trai2y(3)=arci2y(5)
!
!
      trai1x(4)=arci1x(5)
      trai1y(4)=arci1y(5)
!
      trai2x(4)=arci1x(6)
      trai2y(4)=arci1y(6)
!
!
! *** hauteur et largeur de la feuille, avec pointe et tige
!     (9.8 x 9.7)
!
      wfeuil=arci1x(1)-arci2x(3)
      hfeuil=arci2y(3)-arci1y(1)
!
! *** facteur de normalisation de hf et wf pour (1,1)
!
      fnorx=1./wfeuil
      fnory=1./hfeuil
!
! *** axes des ellipses correspondant aux cercles "scales"
!
      a=2.*fnorx*sx
      b=2.*fnory*sy
!
! *** correction par facteur d'echelle des arcs de cercles
!
      do 10 i=1,7
!
      x1= -float(ipos)*arci1x(i)*fnorx*sx +x0
      y1=              arci1y(i)*fnory*sy +y0
      x2= -float(ipos)*arci2x(i)*fnorx*sx +x0
      y2=              arci2y(i)*fnory*sy +y0
!
      if(ipos.eq.-1) then
      call cellarc_(x1,y1,x2,y2,a,b,centx(i),centy(i),teta1(i),teta2(i))
                     else
      call cellarc_(x2,y2,x1,y1,a,b,centx(i),centy(i),teta1(i),teta2(i))
                     endif
!
   10 continue
!
! *** correction par facteur d'echelle des lignes droites
!
      do 20 it=1,4
!
      tra1x(it)= -float(ipos)*trai1x(it)*fnorx*sx +x0
      tra1y(it)=              trai1y(it)*fnory*sy +y0
      tra2x(it)= -float(ipos)*trai2x(it)*fnorx*sx +x0
      tra2y(it)=              trai2y(it)*fnory*sy +y0
!
   20 continue
!
! *** trace de la feuille
!
      if(ipos.eq.-1) then
           call ppagell_(centx(1),centy(1),a,b,0.,teta1(1),teta2(1), 3.)
           call ppaglin_(tra1x(1),tra1y(1),       tra2x(1),tra2y(1))
           call ppagell_(centx(2),centy(2),a,b,0.,teta2(2),teta1(2),-3.)
           call ppaglin_(tra1x(2),tra1y(2),       tra2x(2),tra2y(2))
           call ppagell_(centx(3),centy(3),a,b,0.,teta1(3),teta2(3), 3.)
           call ppagell_(centx(4),centy(4),a,b,0.,teta1(4),teta2(4), 3.)
           call ppaglin_(tra1x(3),tra1y(3),       tra2x(3),tra2y(3))
           call ppagell_(centx(5),centy(5),a,b,0.,teta2(5),teta1(5),-3.)
           call ppaglin_(tra1x(4),tra1y(4),       tra2x(4),tra2y(4))
           call ppagell_(centx(6),centy(6),a,b,0.,teta1(6),teta2(6), 3.)
           call ppagell_(centx(7),centy(7),a,b,0.,teta1(7),teta2(7), 3.)
                     else
           call ppagell_(centx(1),centy(1),a,b,0.,teta2(1),teta1(1),-3.)
           call ppaglin_(tra2x(1),tra2y(1),       tra1x(1),tra1y(1))
           call ppagell_(centx(2),centy(2),a,b,0.,teta1(2),teta2(2), 3.)
           call ppaglin_(tra2x(2),tra2y(2),       tra1x(2),tra1y(2))
           call ppagell_(centx(3),centy(3),a,b,0.,teta2(3),teta1(3),-3.)
           call ppagell_(centx(4),centy(4),a,b,0.,teta2(4),teta1(4),-3.)
           call ppaglin_(tra2x(3),tra2y(3),       tra1x(3),tra1y(3))
           call ppagell_(centx(5),centy(5),a,b,0.,teta1(5),teta2(5), 3.)
           call ppaglin_(tra2x(4),tra2y(4),       tra1x(4),tra1y(4))
           call ppagell_(centx(6),centy(6),a,b,0.,teta2(6),teta1(6),-3.)
           call ppagell_(centx(7),centy(7),a,b,0.,teta2(7),teta1(7),-3.)
                     endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppaglin_(orix,oriy,endx,endy)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_line
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      call dpagppo_(orix,oriy)
      call ppagpmo_(endx,endy)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagpmo_(tox,toy)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_pen_motion from cur. pos.
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /numvec/ nbppo,nbpmo,nbtpo,nbtmo
      common /penpos/ pepox,pepoy
      common /pagsiz/ tpx,tpy
      common /pagfor/ iorpag
      common /pagori/ popagx,popagy
      common /boupag/ xminb,xmaxb,yminb,ymaxb
!
! *** deplacement elementaire de plume avec trace
!
      posx= tox-popagx
      posy= toy-popagy
!
      if(iorpag.eq.0) then
                      xx=posx
                      yy=posy
                      else
                      xx=tpy-posy
                      yy=posx
                      endif
!
      call sdr_ppagpmo(xx,yy)
!
      nbpmo=nbpmo+1
      pepox=xx
      pepoy=yy
!
! *** update des extrema du trace (page/paysage cm unit)
!
      xminb= min(xminb, xx)
      yminb= min(yminb, yy)
      xmaxb= max(xmaxb, xx)
      ymaxb= max(ymaxb, yy)
!
      call sdr_updbbox
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagrco_(orix,oriy,sizx,sizy,sizcor)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_rectangle_corner
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      call dpagppo_(orix,oriy+sizcor)
      call ppagpmo_(orix,oriy)
      call ppagpmo_(orix+sizcor,oriy)
      call dpagppo_(orix+sizx-sizcor,oriy)
      call ppagpmo_(orix+sizx,oriy)
      call ppagpmo_(orix+sizx,oriy+sizcor)
      call dpagppo_(orix+sizx,oriy+sizy-sizcor)
      call ppagpmo_(orix+sizx,oriy+sizy)
      call ppagpmo_(orix+sizx-sizcor,oriy+sizy)
      call dpagppo_(orix+sizcor,oriy+sizy)
      call ppagpmo_(orix,oriy+sizy)
      call ppagpmo_(orix,oriy+sizy-sizcor)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagrec_(orix,oriy,sizx,sizy)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_rectangle
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      call dpagppo_(orix,oriy)
      call ppagpmo_(orix+sizx,oriy)
      call ppagpmo_(orix+sizx,oriy+sizy)
      call ppagpmo_(orix,oriy+sizy)
      call ppagpmo_(orix,oriy)
!
      return
      end

!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      subroutine ppagsun_(ox,oy,rsun,rray,nray,hues,sats,huer,satr)

      dimension px(100), py(100)

!     ---------------------------------------------------------------+--
! *   Object : plot_page_sun symbol
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev, 2012
!     ---------------------------------------------------------------+--


      pi=acos(-1.)
      dtet=pi/float(nray)

      call glinrgb_(r,v,b)

! *   pas plus que 100 rayons

      if(nray .gt. 100) call uperror_('ppagsun_: nray must be < 100')

! *   calcul des pointes

      do i=1,2*nray+1,2
         tet=float(i-1)*dtet
         px(i)=ox +rray*sin(tet)
         py(i)=oy +rray*cos(tet)
      enddo

! *   calcul des creux

      do i=2,2*nray+1,2
         tet=float(i-1)*dtet
         px(i)=ox +rsun*sin(tet)
         py(i)=oy +rsun*cos(tet)
      enddo

! *** plot en couleur des rayons

      call dfilzon_
      call dlinhsb_(huer,satr,1.)
      call dpagppo_(px(1),py(1))

      do i=2,2*nray+1
         call ppagpmo_(px(i),py(i))
      enddo
      call pfilzon_

! *   retrace des bords en noir

      call dlincol_('n')
      call dpagppo_(px(1),py(1))

      do i=2,2*nray+1
         call ppagpmo_(px(i),py(i))
      enddo

! *** plot du soleil circulaire

      call dlinhsb_(hues,sats, 1.)
      call dfilzon_
      call ppagcir_(ox,oy,rsun,1.,360.,1.)
      call pfilzon_

! *   retrace du bord en noir

      call dlincol_('n')
      call ppagcir_(ox,oy,rsun,1.,360.,1.)

! *   restauration de la couleur d'origine

      call dlinrgb_(r,v,b)

      return
      end

!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagsym_(orix,oriy,ipos,sizx,sizy,symb)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_symbol
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
!
      common /biggra/ diafig,unifig,zofiat
!
      character*(*) symb
      character*4 perm(12)
      character*80 com
!
      real x(37),y(37)
!
      save perm,com,x,y
!
      data epsi  /1.e-35/
      save epsi
!
      data perm/'tria','carr','plus','croi','octo','dode','diam',&
                'star','pota','circ','hmar','vmar'/
!
!
!     trace d'un symbole centre si ipos=0, coin inf. gauche si non
!
!
      if(abs(sizx).lt.epsi.and.abs(sizy).lt.epsi) return
!
      l=len(symb)
      if(l.lt.4) call uperror_('ppagsymb_: length of symb must be ge 4')
!
      do 102 ns=1,12
      if(symb(1:4).eq.perm(ns)) go to 104
  102 continue
      write(com,100) symb(1:4),perm
  100 format('ppagsym_: ',a,'# de ',12(1x,a4))
      call uperror_(com)
!
  104 continue
!
      if(sizx.gt.0.) then
                     sx=sizx
                     else
                     sx=unifig*0.05
                     endif
!
      if(sizy.gt.0.) then
                     sy=sizy
                     else
                     sy=unifig*0.05
                     endif
!
      if(ipos.eq.0) then
                    xx=orix-sx/2.
                    yy=oriy-sy/2.
                    else
                    xx=orix
                    yy=oriy
                    endif
!
      xc=xx+sx/2.
      yc=yy+sy/2.
!
      go to (1,2,3,4,5,6,7,8,9,10,11,12), ns
!
    1 continue
!
! *** triangle
!
      call dpagppo_(xx,yy)
      call ppagpmo_(xx+sx,yy)
      call ppagpmo_(xx+sx/2.,yy+sy)
      call ppagpmo_(xx,yy)
      return
!
    2 continue
!
! *** carre
!
      call dpagppo_(xx,yy)
      call ppagpmo_(xx+sx,yy)
      call ppagpmo_(xx+sx,yy+sy)
      call ppagpmo_(xx,yy+sy)
      call ppagpmo_(xx,yy)
      return
!
    3 continue
!
! *** signe +
!
      call dpagppo_(xx   ,yc)
      call ppagpmo_(xx+sx,yc)
      call dpagppo_(xc   ,yy)
      call ppagpmo_(xc   ,yy+sy)
      return
!
    4 continue
!
! *** croix en X
!
      call dpagppo_(xx,yy)
      call ppagpmo_(xx+sx,yy+sy)
      call dpagppo_(xx,yy+sy)
      call ppagpmo_(xx+sx,yy)
      return
!
    5 continue
!
! *** octogone
!
      dx=sx/4.
      dy=sy/4.
!
      call dpagppo_(xx+dx,yy)
      call ppagpmo_(xx,yy+dy)
      call ppagpmo_(xx,yy+3.*dy)
      call ppagpmo_(xx+dx,yy+4.*dy)
      call ppagpmo_(xx+3.*dx,yy+4.*dy)
      call ppagpmo_(xx+4.*dx,yy+3.*dy)
      call ppagpmo_(xx+4.*dx,yy+dy)
      call ppagpmo_(xx+3.*dx,yy)
      call ppagpmo_(xx+dx,yy)
      return
!
    6 continue
!
! *** dodecagone
!
      dx=sx/8.
      dy=sy/8.
!
      call dpagppo_(xc-dx,yc+4.*dy)
      call ppagpmo_(xc-3.*dx,yc+3.*dy)
      call ppagpmo_(xc-4.*dx,yc+dy)
      call ppagpmo_(xc-4.*dx,yc-dy)
      call ppagpmo_(xc-3.*dx,yc-3.*dy)
      call ppagpmo_(xc-dx,yc-4.*dy)
      call ppagpmo_(xc+dx,yc-4.*dy)
      call ppagpmo_(xc+3.*dx,yc-3.*dy)
      call ppagpmo_(xc+4.*dx,yc-dy)
      call ppagpmo_(xc+4.*dx,yc+dy)
      call ppagpmo_(xc+3.*dx,yc+3.*dy)
      call ppagpmo_(xc+dx,yc+4.*dy)
      call ppagpmo_(xc-dx,yc+4.*dy)
      return
!
    7 continue
!
! *** diamant
!
      call dpagppo_(xx,yc)
      call ppagpmo_(xc,yy)
      call ppagpmo_(xx+sx,yc)
      call ppagpmo_(xc,yy+sy)
      call ppagpmo_(xx,yc)
      return
!
    8 continue
!
! *** star
!
      call dpagppo_(xx   ,yy)
      call ppagpmo_(xc   ,yy+sy)
      call ppagpmo_(xx+sx,yy)
      call ppagpmo_(xx   ,yc+sy/6.)
      call ppagpmo_(xx+sx,yc+sy/6.)
      call ppagpmo_(xx   ,yy)
      return
!
    9 continue
!
! *** potatoes
!
      dx=sx/8.
      dy=sy/8.
!
      call dpagppo_(xx       ,yy+2.*dy)
      call ppagpmo_(xx+0.2*dx,yy+3.0*dy)
      call ppagpmo_(xx+0.5*dx,yy+4.0*dy)
      call ppagpmo_(xx+1.0*dx,yy+5.0*dy)
      call ppagpmo_(xx+2.0*dx,yy+6.0*dy)
      call ppagpmo_(xx+3.0*dx,yy+7.0*dy)
      call ppagpmo_(xx+4.0*dx,yy+7.5*dy)
      call ppagpmo_(xx+5.0*dx,yy+7.8*dy)
      call ppagpmo_(xx+6.0*dx,yy+8.0*dy)
      call ppagpmo_(xx+7.0*dx,yy+7.8*dy)
      call ppagpmo_(xx+7.8*dx,yy+7.0*dy)
      call ppagpmo_(xx+8.0*dx,yy+6.0*dy)
      call ppagpmo_(xx+7.8*dx,yy+5.0*dy)
      call ppagpmo_(xx+7.5*dx,yy+4.0*dy)
      call ppagpmo_(xx+7.0*dx,yy+3.0*dy)
      call ppagpmo_(xx+6.0*dx,yy+2.0*dy)
      call ppagpmo_(xx+5.0*dx,yy+1.0*dy)
      call ppagpmo_(xx+4.0*dx,yy+0.5*dy)
      call ppagpmo_(xx+3.0*dx,yy+0.2*dy)
      call ppagpmo_(xx+2.0*dx,yy+0.0*dy)
      call ppagpmo_(xx+1.0*dx,yy+0.2*dy)
      call ppagpmo_(xx+0.2*dx,yy+1.0*dy)
      return
!
   10 continue
!
! *** circle (10 degrees step)
!
      dx=sx/2.
      dy=sy/2.
!
      xxc=xx+sx/2.
      yyc=yy+sy/2.
!
      x( 1) = xxc + ( 1.00000*dx)
      y( 1) = yyc + ( 0.00000*dy)
!
      x( 2) = xxc + ( 0.98481*dx)
      y( 2) = yyc + ( 0.17365*dy)
!
      x( 3) = xxc + ( 0.93969*dx)
      y( 3) = yyc + ( 0.34202*dy)
!
      x( 4) = xxc + ( 0.86603*dx)
      y( 4) = yyc + ( 0.50000*dy)
!
      x( 5) = xxc + ( 0.76604*dx)
      y( 5) = yyc + ( 0.64279*dy)
!
      x( 6) = xxc + ( 0.64279*dx)
      y( 6) = yyc + ( 0.76604*dy)
!
      x( 7) = xxc + ( 0.50000*dx)
      y( 7) = yyc + ( 0.86603*dy)
!
      x( 8) = xxc + ( 0.34202*dx)
      y( 8) = yyc + ( 0.93969*dy)
!
      x( 9) = xxc + ( 0.17365*dx)
      y( 9) = yyc + ( 0.98481*dy)
!
      x(10) = xxc + ( 0.00000*dx)
      y(10) = yyc + ( 1.00000*dy)
!
      x(11) = xxc + (-0.17365*dx)
      y(11) = yyc + ( 0.98481*dy)
!
      x(12) = xxc + (-0.34202*dx)
      y(12) = yyc + ( 0.93969*dy)
!
      x(13) = xxc + (-0.50000*dx)
      y(13) = yyc + ( 0.86603*dy)
!
      x(14) = xxc + (-0.64279*dx)
      y(14) = yyc + ( 0.76605*dy)
!
      x(15) = xxc + (-0.76604*dx)
      y(15) = yyc + ( 0.64279*dy)
!
      x(16) = xxc + (-0.86602*dx)
      y(16) = yyc + ( 0.50000*dy)
!
      x(17) = xxc + (-0.93969*dx)
      y(17) = yyc + ( 0.34202*dy)
!
      x(18) = xxc + (-0.98481*dx)
      y(18) = yyc + ( 0.17365*dy)
!
      x(19) = xxc + (-1.00000*dx)
      y(19) = yyc + ( 0.00000*dy)
!
      x(20) = xxc + (-0.98481*dx)
      y(20) = yyc + (-0.17365*dy)
!
      x(21) = xxc + (-0.93969*dx)
      y(21) = yyc + (-0.34202*dy)
!
      x(22) = xxc + (-0.86603*dx)
      y(22) = yyc + (-0.50000*dy)
!
      x(23) = xxc + (-0.76605*dx)
      y(23) = yyc + (-0.64279*dy)
!
      x(24) = xxc + (-0.64279*dx)
      y(24) = yyc + (-0.76604*dy)
!
      x(25) = xxc + (-0.50000*dx)
      y(25) = yyc + (-0.86602*dy)
!
      x(26) = xxc + (-0.34202*dx)
      y(26) = yyc + (-0.93969*dy)
!
      x(27) = xxc + (-0.17365*dx)
      y(27) = yyc + (-0.98481*dy)
!
      x(28) = xxc + ( 0.00000*dx)
      y(28) = yyc + (-1.00000*dy)
!
      x(29) = xxc + ( 0.17364*dx)
      y(29) = yyc + (-0.98481*dy)
!
      x(30) = xxc + ( 0.34202*dx)
      y(30) = yyc + (-0.93969*dy)
!
      x(31) = xxc + ( 0.50000*dx)
      y(31) = yyc + (-0.86603*dy)
!
      x(32) = xxc + ( 0.64278*dx)
      y(32) = yyc + (-0.76605*dy)
!
      x(33) = xxc + ( 0.76604*dx)
      y(33) = yyc + (-0.64279*dy)
!
      x(34) = xxc + ( 0.86602*dx)
      y(34) = yyc + (-0.50000*dy)
!
      x(35) = xxc + ( 0.93969*dx)
      y(35) = yyc + (-0.34202*dy)
!
      x(36) = xxc + ( 0.98481*dx)
      y(36) = yyc + (-0.17365*dy)
!
      x(37) = xxc + ( 1.00000*dx)
      y(37) = yyc + ( 0.00000*dy)
!
!
      call dpagppo_(x(1),y(1))
!
      do 101 i=2,37
      call ppagpmo_(x(i),y(i))
  101 continue
      return
!
   11 continue
!
! *** horizontal mark
!
      call dpagppo_(xx   ,yc)
      call ppagpmo_(xx+sx,yc)
      return
!
   12 continue
!
! *** vertical mark
!
      call dpagppo_(xc   ,yy)
      call ppagpmo_(xc   ,yy+sy)
      return
!
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagtav_(orix,oriy,ipos,sizx,sizy,angle,tex,val,format)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_text_and_value
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) tex
      character*(*) format
      character*1 ifg
      character*255 com
      save com
!
      data epsi  /1.e-35/
      save epsi
!
!
! *** trace un nombre avec un texte devant
!
!      orix,oriy=coordonnees en cm du texte a tracer
!      val=valeur flottante du nombre a tracer
!      format=format du nb a tracer ex: '(f9.3)'
!      sizx,sizy=taille en cm du nb a tracer
!      angle=angle en degres de l'inclinaison sur l'horizontale
!      (sens direct) du trace
!      ipos=-1 origine coin inf. gauche
!      ipos= 0 origine au milieu
!      ipos= 1 origine coin inf. droit
!
!
      if(sizx.lt.epsi) return
      if(sizy.lt.epsi) return
!
      call uverfor_(format,'ppagtav_')
      call udecfor_(format,ifg,n,nd)
!
      if(n.eq.0) return
      if(val.gt.0.) then
                    iv=int(val+0.5)
                    else
                    iv= -int(abs(val)+0.5)
                    endif
!
      if(ifg.eq.'i' .or.  ifg.eq.'I') write(com,format) iv
      if(ifg.ne.'i' .and. ifg.ne.'I') write(com,format) val
!
      call cchalen_(tex,nc)
      com=tex(1:nc)//com
!
      call ppagcha_(orix,oriy,ipos,sizx,sizy,angle,com)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagval_(orix,oriy,ipos,sizx,sizy,angle,value,format)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_value
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) format
      character*1 ifg
      character*64 texte
!
      data epsi  /1.e-35/
      save epsi
!
!
! *** trace un nombre selon un format donne
!
!      orix,oriy=coordonnees en cm du nb a tracer
!      value=valeur flottante du nombre a tracer
!      format=format du nb a tracer ex: '(f9.3)'
!      sizx,sizy=taille en cm du nb a tracer
!      angle=angle en degres de l'inclinaison sur l'horizontale
!      (sens direct) du trace
!      ipos=-1 origine coin inf. gauche
!      ipos= 0 origine au milieu
!      ipos= 1 origine coin inf. droit
!
!
      if(sizx.lt.epsi) return
      if(sizy.lt.epsi) return
!
      call uverfor_(format,'ppagval_')
      call udecfor_(format,ifg,n,nd)
!
      if(n.eq.0) return

      imax=2147483647
      if(abs(value).gt.float(imax) ) then
             write(texte,'(e10.3)') value
        else
          if(value.gt.0.) then
                      iv=int(value+0.5)
                      else
                      iv= -int(abs(value)+0.5)
          endif

          if(ifg.eq.'i' .or.  ifg.eq.'I') write(texte,format) iv
          if(ifg.ne.'i' .and. ifg.ne.'I') write(texte,format) value
      endif

      call ppagcha_(orix,oriy,ipos,sizx,sizy,angle,texte)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ppagvli_(x)
!
!     ---------------------------------------------------------------+--
! *   Object : plot_page_vertical_line
! *   Class  : plot page modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /pagsiz/ tpx,tpy
!
!
      call dpagppo_(x,0.)
      call ppagpmo_(x,tpy)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine rdimbmp_(ifc,fichbmp,nx,ny)
!
      common /ibmp_comp/ ibmp
!
!     ------------------------------------------------------------------
! *   Object : read_dimension_image_bmp for 24 bits file
! *   Class  : read modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      character*(*) fichbmp
      integer first_4octets(4)
!
! *** ouverture du fichier bmp
!
      close(ifc)
!bmp      open (ifc,file=fichbmp,status='old',form='binary')
      open(ifc,file=fichbmp,status='old',form='unformatted',access='direct',recl=1)
      ibmp=0
! PR  file_type='unknown'
! PR  n_oct_tot=26 ! on lit 26 octets au max dans rdimbmp_
!     Le fichier est-t-il un BMP ?
      do ibid=1,4
         call roctfil_(ifc,first_4octets(ibid))
      enddo
      if ((first_4octets(1).eq.66).and.(first_4octets(2).eq.77)) then
! PR     file_type='BMP_UNIX'
      else
         if ((first_4octets(4).eq.66).and.(first_4octets(3).eq.77)) then
! PR        file_type='BMP_PC'
         else
! PR        file_type='wrong_type'
         endif
      endif
!
! *** lecture de l'entete inutile
!
      do ibid=5,18
!bmp10      n_oct_tot=200
!bmp10      do ibid=5,200
         call roctfil_(ifc,ib0)
      enddo
!bmp10      stop
!
! *** lecture des dimensions de l'image
!
      call roctfil_(ifc,i1)
      call roctfil_(ifc,i2)
      call roctfil_(ifc,i3)
      call roctfil_(ifc,i4)
!
      nx=i1 + i2*256 + i3*256*256 + i4*256*256*256
!
      call roctfil_(ifc,j1)
      call roctfil_(ifc,j2)
      call roctfil_(ifc,j3)
      call roctfil_(ifc,j4)
!
      ny=j1 + j2*256 + j3*256*256 + j4*256*256*256
!
! *** fermeture du fichier
!
      close(ifc)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine rimabmp_(ifc,fichbmp,imaico,nx,ny)
!
      common /ibmp_comp/ ibmp
!
!     -------------------------------------------------------------------
! *   Object : read_image_bmp for 24 bits file, nx-ny defined, ico format
! *   Class  : read modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
!
      character*(*) fichbmp
! PR  character*128 file_type
      integer imaico(nx,ny)
      integer first_4octets(4)
!
!
! *** ouverture du fichier bmp
!
      close(ifc)
!bmp      open (ifc,file=fichbmp,status='old',form='binary')
      open(ifc,file=fichbmp,status='old',form='unformatted',access='direct',recl=1)
      ibmp=0
!
! PR  n_oct_tot=54+3*nx*ny ! nombre d'octets total dans l'image
!
! PR  file_type='unknown'
!     Le fichier est-t-il un BMP ?
      do ibid=1,4
         call roctfil_(ifc,first_4octets(ibid))
      enddo
      if ((first_4octets(1).eq.66).and.(first_4octets(2).eq.77)) then
! PR     file_type='BMP_UNIX'
      else
         if ((first_4octets(4).eq.66).and.(first_4octets(3).eq.77)) then
! PR        file_type='BMP_PC'
         else
! PR        file_type='wrong_type'
         endif
      endif
!
! *** lecture de l'entete inutile
!
      do 6 ibid=5,18
      call roctfil_(ifc,ib0)
    6 continue
!
! *** lecture des dimensions de l'image
!
      call roctfil_(ifc,i1)
      call roctfil_(ifc,i2)
      call roctfil_(ifc,i3)
      call roctfil_(ifc,i4)
!
      nx2=i1 + i2*256 + i3*256*256 + i4*256*256*256
!
      call roctfil_(ifc,j1)
      call roctfil_(ifc,j2)
      call roctfil_(ifc,j3)
      call roctfil_(ifc,j4)
!
! *** verif avec les dimensions declarees pour le tableau
!
      ny2=j1 + j2*256 + j3*256*256 + j4*256*256*256
!
      if(nx.ne.nx2.or. ny.ne.ny2) then
                    print*
                    print*, 'error in rimabmp_'
                    print*, 'no previous reading of dim. of bmp file'
                    print*, 'rimabmp_ must be preceded by rdimbmp_'
                    call uperror_('rimabmp_: no previous rdimbmp_ call')
                    endif
!
! *** fin de lecture de l'entete
!
      do 8 ibid=27,54
      call roctfil_(ifc,ib0)
    8 continue
!
! *** lecture de l'image .bmp / passage au format ico
!
      do 10 iy=1,ny
      do 10 ix=1,nx
!
      call roctfil_(ifc,ib)
      call roctfil_(ifc,ig)
      call roctfil_(ifc,ir)
      call crgbico_(ir,ig,ib,ico)
      imaico(ix,iy)=ico
   10 continue
!
      close(ifc)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine roctfil_(ifc,io)
!
!     ------------------------------------------------------------------
! *   Object : read_octet_on_file for opened direct file
! *   Class  : read modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
!
      character*1 cha
      integer fgetc
!
      data nberr/0/
      save nberr
!
! *** lecture octet par octet
!
      ier=fgetc(ifc,cha)
      io=ichar(cha)
!
      if(ier.eq.-1) then
                    nberr=nberr+1
                    print*, nberr, 'EOF encoutered, io set to 999'
                    io=999
                    return
                    endif
!
      if(ier.ne.0) then
                   nberr=nberr+1
                   print*, nberr, 'error fgetc, ier=',ier
                   if(nberr.gt.100) stop '> 100 errors in roctfil_'
                   endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_dclogra
!
!     ------------------------------------------------------------------
! *   Object : system_drv, close_graphical_file close PostScript file
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      common /sdrcom/ ifc,lc,numpag,is
      common /sdrbbo/ xmip,xmap,ymip,ymap, xmimip,xmamap,ymimip,ymamap
!
      if(lc.eq.1) write(ifc,100) 'stroke'
!
! *** conversion en entier des Bounding Box (obligatoire)
!
      ixmip=int(xmip)
      iymip=int(ymip)
      ixmap=int(xmap) +1
      iymap=int(ymap) +1
!
      ixmimip=int(xmimip)
      iymimip=int(ymimip)
      ixmamap=int(xmamap) +1
      iymamap=int(ymamap) +1
!
! *** cloture du PostScript
!
      write(ifc,100)
      write(ifc,100) '% ROGRALIB / sps_dclogra : system_postscript_close_graphical_file'
      write(ifc,100) 'restore'
      write(ifc,100) 'showpage'
      write(ifc,100) '%%PageTrailer'
      write(ifc,300) '%%PageBoundingBox: ', ixmip,iymip,ixmap,iymap
      write(ifc,100)
      write(ifc,100) '%%Trailer'
      write(ifc,300) '%%BoundingBox: ', ixmimip,iymimip,ixmamap,iymamap
! /// write(ifc,100) 'end'
! /// write(ifc,100) 'cleartomark countdictstack exch sub { end }  repeat restore'
      write(ifc,300) '%%Pages: ',numpag
      write(ifc,100) '%%EOF'
!
      close(ifc)
!
  100 format(a)
  300 format(a,4i8)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_dfilzon
!
      common /sdrcom/ ifc,lc,numpag,is
!
!     ------------------------------------------------------------------
! *   Object : system_drv, define_fill_zone
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
! *** empeche la demande de stroke dans sps_ppagpmo
!     permet d'enchainer des utilitaires de trace pour faire une ligne
!     continue jusqu'a la commande pfilzon
!
      is=1
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_dfonnab(numfon,bodfon)
!
!     ------------------------------------------------------------------
! *   Object : system_drv, define_font_number_and_body as 5, 10.25
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      common /sdrcom/ ifc,lc,numpag,is
!
      character*29  fonp(13)
!
      save fonp, numpre, bodpre
!
      data numpre /0/
      data bodpre /0./
!
      data fonp( 1)/'Patrick_Courier              '/
      data fonp( 2)/'Patrick_Courier-Bold         '/
      data fonp( 3)/'Patrick_Courier-Oblique      '/
      data fonp( 4)/'Patrick_Courier-BoldOblique  '/
      data fonp( 5)/'Patrick_Times-Roman          '/
      data fonp( 6)/'Patrick_Times-Bold           '/
      data fonp( 7)/'Patrick_Times-Italic         '/
      data fonp( 8)/'Patrick_Times-BoldItalic     '/
      data fonp( 9)/'Patrick_Helvetica            '/
      data fonp(10)/'Patrick_Helvetica-Bold       '/
      data fonp(11)/'Patrick_Helvetica-Oblique    '/
      data fonp(12)/'Patrick_Helvetica-BoldOblique'/
      data fonp(13)/'Symbol                       '/
!
! *** achtung Patrick_Symbol does not work...
!     use Symbol which is already exented to ascii-8
!
      if(lc.eq.1) then
                  write(ifc,100) 'stroke'
                  write(ifc,100)
                  endif
!
! *** Courier 10 par defaut; tailles limitees
!
      if(numfon.lt.1.or.numfon.gt.13) then
                                      nnf=1
                                      else
                                      nnf=numfon
                                      endif
!
      ffb=bodfon
      if(ffb.lt.0.001) ffb=   10.
      if(ffb.lt.   1.) ffb=    1.
      if(ffb.gt.1000.) ffb= 1000.
!
! *** longueur du texte fonp(nnf
!
      nbc=29
!
      do 10 i=1,nbc
      ii=nbc-i+1
      if(fonp(nnf)(ii:ii).ne.' ') go to 12
   10 continue
      ii=0
   12 continue
!
      nbcha=ii
!
      if((nnf.ne.numpre).or.(abs(ffb-bodpre).gt.1.E-6)) then
         write(ifc,200) fonp(nnf)(1:nbcha),ffb
      endif
      lc=0
      numpre=nnf
      bodpre=ffb
!
  100 format(a)
  200 format('/',a,' findfont ',f7.2,' scalefont setfont')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_dimasha
!
      common /sdrcom/ ifc,lc,numpag,is
!
!     ------------------------------------------------------------------
! *   Object : system_drv, define_image_shape
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      if(lc.eq.1) then
                  write(ifc,100) 'stroke'
                  write(ifc,100)
                  endif
!
      write(ifc,100)
      write(ifc,100) '% ROGRALIB / sps_dimasha: system_drv, define_image_shape'
      write(ifc,100) 'gsave'
      write(ifc,100) 'newpath'
!
      is=1
      lc=0
!
  100 format(a)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_dlincol(mode,c1,c2,c3)
!
!     ------------------------------------------------------------------
! *   Object : system_drv, define_line_color rgb or hsb components
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!
!     input : mode ('rgb' (default) or 'hsb'
!     input : c1,c2,c3 components, values between 0. and 1.
!     output: none
!     ------------------------------------------------------------------
!
      character*(*) mode
!
      common /sdrcom/ ifc,lc,numpag,is
!
      if(lc.eq.1) then
                  write(ifc,100) 'stroke'
                  write(ifc,100)
                  endif
!
      cc1=c1
      cc2=c2
      cc3=c3
!
      if(cc1.gt.1.) cc1=1.
      if(cc2.gt.1.) cc2=1.
      if(cc3.gt.1.) cc3=1.
!
      if(cc1.lt.0.) cc1=0.
      if(cc2.lt.0.) cc2=0.
      if(cc3.lt.0.) cc3=0.
!
!
      if(mode.eq.'hsb') then
                        write(ifc,200) cc1,cc2,cc3, 'sethsbcolor'
                        else
                        write(ifc,200) cc1,cc2,cc3, 'setrgbcolor'
                        endif
      lc=0
!
  100 format(a)
  200 format(3f5.2,1x,a)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_dlincon
!
!     ------------------------------------------------------------------
! *   Object : system_drv, define_line_continue, remove dash option
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2007
!     ------------------------------------------------------------------
!
      common /sdrcom/ ifc,lc,numpag,is
!
      write(ifc,200)
!
  200 format('[] 0 setdash')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_dlindas(size1,blank1,size2,blank2)
!
!     ------------------------------------------------------------------
! *   Object : system_drv, define_line_dash from given parameters
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2007
!     ------------------------------------------------------------------
!
      common /sdrcom/ ifc,lc,numpag,is
      common /pagsiz/ tpx,tpy
!
! *** le trait tirete est constitue d'un premier trait de taille size1,
!     puis d'un espace blanc de taille blank1, puis d'un deuxieme trait
!     suivi d'un deuxieme blanc.
!
! *** test si pas de valeurs delirantes
!
      s1=abs(size1)
      s2=abs(size2)
      b1=abs(blank1)
      b2=abs(blank2)
!
      diag= sqrt(tpx*tpx + tpy*tpy)
!
      if(s1.gt.diag) s1= diag/4.
      if(s2.gt.diag) s2= diag/4.
      if(b1.gt.diag) b1= diag/4.
      if(b2.gt.diag) b2= diag/4.
!
! *** conversion en ups
!
      ucm= 72./2.54
!
      s1ups=s1*ucm
      s2ups=s2*ucm
      b1ups=b1*ucm
      b2ups=b2*ucm
!
      write(ifc,200) s1ups,b1ups,s2ups,b2ups
!
  200 format('[',3(f4.1,' '),f4.1,'] 0 setdash')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_dlingle(gle)
!
!     ------------------------------------------------------------------
! *   Object : system_drv, define_grey_level between 0. and 1.
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      common /sdrcom/ ifc,lc,numpag,is
!
      if(lc.eq.1) then
                  write(ifc,100) 'stroke'
                  write(ifc,100)
                  endif
!
      cgl=gle
      if(cgl.gt.1.) cgl=1.
      if(cgl.lt.0.) cgl=0.
!
      write(ifc,200) cgl, 'setgray'
      lc=0
!
  100 format(a)
  200 format(f5.2,1x,a)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_dlinwid(width)
!
!     ------------------------------------------------------------------
! *   Object : system_drv, define_line_width in pixels
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      common /sdrcom/ ifc,lc,numpag,is
!
      if(lc.eq.1) then
                  write(ifc,100) 'stroke'
                  write(ifc,100)
                  endif
!
! *** taille du pixel en resolution 300 p/pouce
!
      dot= 72./300.
!
      write(ifc,200) width*dot, 'setlinewidth'
      lc=0
!
  100 format(a)
  200 format(f7.2,1x,a)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_dopegra(ifcps,psfile)
!
!     ------------------------------------------------------------------
! *   Object : system_drv, begin_plot open PostScript file
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!
!     input : ifcps, psfile
!     output: spax,spay
!     ------------------------------------------------------------------
!
      character*(*) psfile
      character*29  date
!
      common /sdrcom/ ifc,lc,numpag,is
      common /sdrpag/ supsx,supsy, smarx,smary,ifor
      common /sdrbbo/ xmip,xmap,ymip,ymap, xmimip,xmamap,ymimip,ymamap
!
      integer supsx(5), supsy(5)
      character*16 carspe(135)
      save carspe
!
! *** verif que le fichier se termine par '.ps'
!
      call cchalen_(psfile,nc)
!
      if(psfile(nc-2:nc).ne.'.ps') then
           call upwarni_('name of graphical file must be a .ps file, suffix .ps added')
                  psfile=psfile(nc:nc)//'.ps'
                    endif
!
! *** chargement de la table des caracteres speciaux
!
      data (carspe(i),i=1,99) /&
                               '/grave          ',&
                               '/acute          ',&
                               '/circumflex     ',&
                               '/tilde          ',&
                               '/macron         ',&
                               '/breve          ',&
                               '/dotaccent      ',&
                               '/dieresis       ',&
                               '/ring           ',&
                               '/cedilla        ',&
                               '/hungarumlaut   ',&
                               '/ogonek         ',&
                               '/caron          ',&
                               '/dotlessi       ',&
                               '/quotesingle    ',&
                               '/grave          ',&
                               '/bar            ',&
                               '/quotesinglbase ',&
                               '/florin         ',&
                               '/quotedblbase   ',&
                               '/ellipsis       ',&
                               '/dagger         ',&
                               '/daggerdbl      ',&
                               '/circumflex     ',&
                               '/perthousand    ',&
                               '/Scaron         ',&
                               '/guilsinglleft  ',&
                               '/OE             ',&
                               '/quoteleft      ',&
                               '/quoteright     ',&
                               '/quotedblleft   ',&
                               '/quotedblright  ',&
                               '/bullet         ',&
                               '/endash         ',&
                               '/emdash         ',&
                               '/tilde          ',&
                               '/trademark      ',&
                               '/scaron         ',&
                               '/guilsinglright ',&
                               '/oe             ',&
                               '/Ydieresis      ',&
                               '/space          ',&
                               '/exclamdown     ',&
                               '/currency       ',&
                               '/yen            ',&
                               '/brokenbar      ',&
                               '/section        ',&
                               '/dieresis       ',&
                               '/copyright      ',&
                               '/ordfeminine    ',&
                               '/guillemotleft  ',&
                               '/logicalnot     ',&
                               '/hyphen         ',&
                               '/registered     ',&
                               '/macron         ',&
                               '/degree         ',&
                               '/plusminus      ',&
                               '/twosuperior    ',&
                               '/threesuperior  ',&
                               '/acute          ',&
                               '/mu             ',&
                               '/paragraph      ',&
                               '/periodcentered ',&
                               '/cedilla        ',&
                               '/onesuperior    ',&
                               '/ordmasculine   ',&
                               '/guillemotright ',&
                               '/onequarter     ',&
                               '/onehalf        ',&
                               '/threequarters  ',&
                               '/questiondown   ',&
                               '/Agrave         ',&
                               '/Aacute         ',&
                               '/Acircumflex    ',&
                               '/Atilde         ',&
                               '/Adieresis      ',&
                               '/Aring          ',&
                               '/AE             ',&
                               '/Ccedilla       ',&
                               '/Egrave         ',&
                               '/Eacute         ',&
                               '/Ecircumflex    ',&
                               '/Edieresis      ',&
                               '/Igrave         ',&
                               '/Iacute         ',&
                               '/Icircumflex    ',&
                               '/Idieresis      ',&
                               '/Eth            ',&
                               '/Ntilde         ',&
                               '/Ograve         ',&
                               '/Oacute         ',&
                               '/Ocircumflex    ',&
                               '/Otilde         ',&
                               '/Odieresis      ',&
                               '/multiply       ',&
                               '/Oslash         ',&
                               '/Ugrave         ',&
                               '/Uacute         ',&
                               '/Ucircumflex    '/
!
      data (carspe(i),i=100,135) /&
                               '/Udieresis      ',&
                               '/Yacute         ',&
                               '/Thorn          ',&
                               '/germandbls     ',&
                               '/agrave         ',&
                               '/aacute         ',&
                               '/acircumflex    ',&
                               '/atilde         ',&
                               '/adieresis      ',&
                               '/aring          ',&
                               '/ae             ',&
                               '/ccedilla       ',&
                               '/egrave         ',&
                               '/eacute         ',&
                               '/ecircumflex    ',&
                               '/edieresis      ',&
                               '/igrave         ',&
                               '/iacute         ',&
                               '/icircumflex    ',&
                               '/idieresis      ',&
                               '/eth            ',&
                               '/ntilde         ',&
                               '/ograve         ',&
                               '/oacute         ',&
                               '/ocircumflex    ',&
                               '/otilde         ',&
                               '/odieresis      ',&
                               '/divide         ',&
                               '/oslash         ',&
                               '/ugrave         ',&
                               '/uacute         ',&
                               '/ucircumflex    ',&
                               '/udieresis      ',&
                               '/yacute         ',&
                               '/thorn          ',&
                               '/ydieresis      '/
!
!
! *** chargement des la tailles des pages possibles, en unites ps,
!      selon les formats supportes
!     (on suppose toujours l'orientation portrait)
!
!     A0,A1,A2,A3,A4
!
      supsx(1)= 2384
      supsx(2)= 1684
      supsx(3)= 1191
      supsx(4)=  842
      supsx(5)=  595
!
      supsy(1)= 3370
      supsy(2)= 2384
      supsy(3)= 1684
      supsy(4)= 1191
      supsy(5)=  842
!
!
! *** unites et conversions
!
!     1 pouce= 2.54    cm
!     1 pouce= 72      ups
!     1 ups  = 1/72    pouce
!     1 ups  = 2.54/72 cm      (=  0.0352777 cm)
!     1 cm   = 72/2.54 ups     (= 28.3465    ups)
!
! *** pour memoire:
!
!     format US letter
!     (8.5 x 11) pouces = (21.59 x 27.94) cm = (612 x 792) ups
!
!     format A4 utilise par defaut:
!     (595 x 842) ups = (8.263 x 11.694) pouces = (20.9903 x 29.704) cm
!
!     Les autres formats:
!
!   Paper Size                      Dimension (in points)
!   ------------------              ---------------------
!   Comm #10 Envelope               297 x 684
!   C5 Envelope                     461 x 648
!   DL Envelope                     312 x 624
!   Folio                           595 x 935
!   Executive                       522 x 756
!   Letter                          612 x 792
!   Legal                           612 x 1008
!   Ledger                          1224 x 792
!   Tabloid                         792 x 1224
!   A0                              2384 x 3370
!   A1                              1684 x 2384
!   A2                              1191 x 1684
!   A3                              842 x 1191
!   A4                              595 x 842
!   A5                              420 x 595
!   A6                              297 x 420
!   A7                              210 x 297
!   A8                              148 x 210
!   A9                              105 x 148
!   B0                              2920 x 4127
!   B1                              2064 x 2920
!   B2                              1460 x 2064
!   B3                              1032 x 1460
!   B4                              729 x 1032
!   B5                              516 x 729
!   B6                              363 x 516
!   B7                              258 x 363
!   B8                              181 x 258
!   B9                              127 x 181
!   B10                             91 x 127
!
! *** Bounding Box :  en attente, calcule a la fin du job
!     attention: pas plus de 2**31-1 soit 2.e9 pour conversion en entier
!
      xmip=   1.e9
      xmap=   0.
      ymip=   1.e9
      ymap=   0.
!
      xmimip= 1.e9
      xmamap= 0.
      ymimip= 1.e9
      ymamap= 0.
!
! *** ouverture du fichier et initialisations
!
      ifc=ifcps
      numpag=0
!
      close(ifc)
      open (ifc,file=psfile)
!
      call gusdati_(date)
      call cchalen_(psfile,nc)
      call gvernum_(ver)
!
! *** entete fichier
!
      write(ifc,100) '%!PS-Adobe-2.0'
      write(ifc,110) '%%Creator: Patrick ROBERT, ScientiDev, ROGRALIB Software V', ver
      write(ifc,100) '%%CreationDate: ',date
      write(ifc,100) '%%Title: Graphics produced by RograLib'
      write(ifc,100) '%%BoundingBox: (atend)'
! /// write(ifc,100) '%%DocumentData: Clean7bit'
      write(ifc,100) '%%Copyright: ScientiDev, ROGRALIB Software V', ver
      write(ifc,100) '%%Version: ROGRALIB V',ver
      write(ifc,100) '%%For: Patrick ROBERT'
      write(ifc,101) '%%DocumentMedia: A',4,supsx(5),supsy(5),' 0 () ()'
      write(ifc,101) '%%+              A',3,supsx(4),supsy(4),' 0 () ()'
      write(ifc,101) '%%+              A',2,supsx(3),supsy(3),' 0 () ()'
      write(ifc,101) '%%+              A',1,supsx(2),supsy(2),' 0 () ()'
      write(ifc,101) '%%+              A',0,supsx(1),supsy(1),' 0 () ()'
      write(ifc,100) '%%PageOrder: Ascend'
      write(ifc,100) '%%Pages: (atend)'
      write(ifc,100) '%%Copyright: (C) 1986-2021, Patrick ROBERT, ScientiDev, All Rights Reserved'
      write(ifc,100) '%%EndComments'
      write(ifc,100)
      write(ifc,100) '%%BeginDefaults'
      write(ifc,100) '%%PageOrientation: Portrait'
      write(ifc,100) '%%PageMedia: A4'
      write(ifc,100) '%%EndDefaults'
      write(ifc,100)
      write(ifc,100) '% ---------------------------------------------------------'
      write(ifc,110) '% PostScript file created by ROGRALIB V',ver,' software'
      write(ifc,100) '% Copyright (c) 1986-, Patrick ROBERT, ScientiDev'
      write(ifc,100) '% All Rights Reserved'
      write(ifc,100) '%'
      write(ifc,100) '%           -----------------                    '
      write(ifc,100) '%'
      write(ifc,100) '% V1.0 Version initiale  depuis archives :         Fev 1986'
      write(ifc,100) '% V2.0 Decoupage et structuration des call :       Fev 1986'
      write(ifc,100) '% V3.0 Creation du driver PostScript  :            Mar 1990'
      write(ifc,100) '% V4.0 Refonte et nomage codifie des modules :     Mai 1993'
      write(ifc,100) '% V5.0 Usage des polices PS standards :            Mar 1995'
      write(ifc,100) '% V6.0 Nouveaux modules de calcul et traces :      Dec 1995'
      write(ifc,100) '% V7.0 Redefinition des categories et des roles,           '
      write(ifc,100) '%      stucturation de l''arborescence en modules : Dec 1996'
      write(ifc,100) '% V7.1 a V7.4 : ameliorations et correct. diverses         '
      write(ifc,100) '% V7.5 Extension 8 bits des polices standards PS : Dec 1997'
      write(ifc,100) '% V7.6 Nouveaux modules de trace :                 Mar 1998'
      write(ifc,100) '% V7.7 Optimisation pour ecriture de texte :       Nov 1998'
      write(ifc,100) '% V8.0 Gestion des polices proportionnelles PS :   Oct 1999'
      write(ifc,100) '% V8.1 Refonte generale des common et simplifications,     '
      write(ifc,100) '%      Suppression de l''interface en pixels,              '
      write(ifc,100) '%      trace que vectoriel, gestion des images :   Nov 1999'
      write(ifc,100) '% V8.2 Introduction des formats A3,A2,A1 et A0 :   Avr 2000'
      write(ifc,100) '% V8.3 Corrections qq bugs :                       Dec 2001'
      write(ifc,100) '% V8.4 Resolution de quelques pb de polices Bold : Dec 2003'
      write(ifc,100) '% V8.5 Corrections qq bugs :                       Avr 2005'
      write(ifc,100) '% V8.6 nouveaux ajustements pour le calcul des             '
      write(ifc,100) '%      graduations pour grandes valeurs proches :  Aou 2005'
      write(ifc,100) '% V8.7 Compatibilite divers Ghostview (Sun, Win) : Nov 2005'
      write(ifc,100) '% V8.8 Verification FORESYS et introduction de '
      write(ifc,100) '%      plusieurs mires de couleur :                Jan 2006'
      write(ifc,100) '% V8.9 Compatibilite pour G77 PC windows :         Feb 2006'
      write(ifc,100) '% V9.0 25 possibilite mires de couleur a la carte: Jun 2006'
      write(ifc,100) '% V9.1 Suppression drivers inacheves autre que PostScript, '
      write(ifc,100) '%      intro lines tiretees, formats en maj. ou minusc.,   '
      write(ifc,100) '%      new routines de temps, refonte des categ. : Oct 2007'
      write(ifc,100) '% V9.2 Correction calcul Page Bounding Box :       Nov 2007'
      write(ifc,100) '% V9.3 fonction puissance pour portabilite (x**n): Nov 2007'
      write(ifc,100) '% V9.4 corr. bugs sur cfiggra_ et nb pages driver: Mai 2008'
      write(ifc,100) '% V9.5 Intro fonctions calendrier, unicite du code SUN-PC, '
      write(ifc,100) '%      Activation dfigout_ et evite depass. format ds PS   '
      write(ifc,100) '%      Optimis. distance grad.   labels a l''axe:   Jun 2008'
      write(ifc,100) '% V9.6 Full gfortran/ifort compatible              Jun 2010'
      write(ifc,100) '% V9.7 Introduction graduations logarithmiques     Sep 2011'
      write(ifc,100) '%'
      write(ifc,100) '% ---------------------------------------------------------'
!
! *** prologue
!
      write(ifc,100) ' '
      write(ifc,100) '%%BeginProlog'
      write(ifc,100) ' '
      write(ifc,100) '%%BeginResource: new fonts for extra ascii characters (128-255)'
      write(ifc,100) '%                serial Patrick_sdfont'
      write(ifc,100) '%                P.Robert - Dec 1995 '
      write(ifc,100) ' '
      write(ifc,100) '%NewCodes '
      write(ifc,100) '/NewCodes 256 array def '
      write(ifc,100) 'NewCodes 0 '
      write(ifc,100) 'StandardEncoding '
      write(ifc,100) '0 128 getinterval '
      write(ifc,100) 'putinterval '
      write(ifc,100) ' '
      write(ifc,100) (carspe(i),i=1,135)
      write(ifc,100) ' '
      write(ifc,100) 'NewCodes 128 128 getinterval astore pop '
      write(ifc,100) ' '
      write(ifc,100) '%CopyDictionary '
      write(ifc,100) '/CopyDictionary { '
      write(ifc,100) '   dup maxlength dict '
      write(ifc,100) '   /NF exch def '
      write(ifc,100) '   {1 index /FID ne '
      write(ifc,100) '       {NF 3 1 roll put} '
      write(ifc,100) '       {pop pop} '
      write(ifc,100) '    ifelse '
      write(ifc,100) '    } forall '
      write(ifc,100) '    NF '
      write(ifc,100) '} def '
      write(ifc,100) ' '
      write(ifc,100) '%recode a font with new encoding vector '
      write(ifc,100) '/Recode { '
      write(ifc,100) '    dup cvn /NewName exch def '
      write(ifc,100) '    (Patrick_) anchorsearch '
      write(ifc,100) '        {pop '
      write(ifc,100) '        findfont CopyDictionary '
      write(ifc,100) '        dup /Encoding NewCodes put '
      write(ifc,100) '        NewName exch definefont '
      write(ifc,100) '    } if '
      write(ifc,100) '    pop '
      write(ifc,100) '} def '
      write(ifc,100) ' '
      write(ifc,100) '%RecodeFont - create newly recoded font '
      write(ifc,100) '/RecodeFont { '
      write(ifc,100) '    dup FontDirectory exch known '
      write(ifc,100) '        {pop} '
      write(ifc,100) '        {Recode} '
      write(ifc,100) '    ifelse '
      write(ifc,100) '} def '
      write(ifc,100) ' '
      write(ifc,100) '%NewFont ready to use '
!
      write(ifc,100) '  (Patrick_Courier) RecodeFont'
      write(ifc,100) '  (Patrick_Courier-Bold) RecodeFont'
      write(ifc,100) '% (Patrick_Courier-Oblique) RecodeFont'
      write(ifc,100) '% (Patrick_Courier-BoldOblique) RecodeFont'
      write(ifc,100) '  (Patrick_Times-Roman) RecodeFont'
      write(ifc,100) '  (Patrick_Times-Bold) RecodeFont'
      write(ifc,100) '  (Patrick_Times-Italic) RecodeFont'
      write(ifc,100) '  (Patrick_Times-BoldItalic) RecodeFont'
      write(ifc,100) '  (Patrick_Helvetica) RecodeFont'
      write(ifc,100) '  (Patrick_Helvetica-Bold) RecodeFont'
      write(ifc,100) '  (Patrick_Helvetica-Oblique) RecodeFont'
      write(ifc,100) '  (Patrick_Helvetica-BoldOblique) RecodeFont'
      write(ifc,100) '  (Symbol) RecodeFont'
!
!
      write(ifc,100) ' '
      write(ifc,100) '%%EndResource - 11 new ascii extended font ready to use '
      write(ifc,100) ' '
      write(ifc,100) '%%EndProlog'
      write(ifc,100) '% -----------------------------------------------'
!
! *** setup
!
      write(ifc,100) ' '
      write(ifc,100) '%%BeginSetup'
      write(ifc,100) ' '
      write(ifc,100) '% PSCM: conv. cm. en unite PS '
      write(ifc,100) ' /PSCM {gsave 28.3465 28.3465 scale grestore} def'
      write(ifc,100) ' '
      write(ifc,100) '% MTS: moveto and show '
      write(ifc,100) '% optimisation pour ecriture de texte, nov. 1998'
      write(ifc,100) ' /MTS {moveto show} bind def'
      write(ifc,100) ' '
      write(ifc,100) '% MTRS: moveto rotate and show '
      write(ifc,100) '% ecriture de texte incline, nov. 1998'
      write(ifc,100) ' /MTRS {moveto rotate show rotate} bind def'
      write(ifc,100) ' '
      write(ifc,100) '% STP=SnapToPixel fit vers le pixel le + proche '
      write(ifc,100) ' /STP {'
      write(ifc,100) '       transform'
      write(ifc,100) '       round .25 add'
      write(ifc,100) '       exch'
      write(ifc,100) '       round .25 add'
      write(ifc,100) '       exch'
      write(ifc,100) '       itransform'
      write(ifc,100) '     } bind def'
      write(ifc,100) ' '
!
! *** on initialise par defaut la page au format A4, avec des marges
!     de 1.2 cm tour autour de la feuille 21. x 29.7
!
      call sdr_dpagsiz(18.6,27.3,1.2,1.2)
!
      write(ifc,100) '%%EndSetup'
      write(ifc,100) '% -----------------------------------------------'
!
!
  100 format(5a)
  101 format(a,i1,2i5,a)
  110 format(a,f4.1,a)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_dpagnew(nupa)
!
!     ------------------------------------------------------------------
! *   Object : system_drv, define_page_new and return page number
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      common /sdrcom/ ifc,lc,numpag,is
      common /sdrbbo/ xmip,xmap,ymip,ymap, xmimip,xmamap,ymimip,ymamap
!
      if(lc.eq.1) then
                  write(ifc,100) 'stroke'
                  write(ifc,100)
                  endif
!
      numpag=numpag+1
      nupa=numpag
!
! *** fin de la page precedente
!
! *   conversion en entier des Bounding Box (obligatoire)
!
!
      if(numpag.gt.1) then
                      ixmip=int(xmip)
                      iymip=int(ymip)
                      ixmap=int(xmap) +1
                      iymap=int(ymap) +1
!
                      write(ifc,300) '%%PageBoundingBox: ', ixmip,iymip,ixmap,iymap
                      write(ifc,100) 'restore'
                      write(ifc,100) 'showpage'
                      write(ifc,100) '%%PageTrailer'
                      write(ifc,100)
                      endif
!
! *** nouvelle page
!
      write(ifc,100)
      write(ifc,200) '%%Page: ',numpag,numpag
      write(ifc,100) '%%PageOrientation: Portrait'
      write(ifc,100) '%%PageBoundingBox: (atend)'
      write(ifc,100) 'save'
      write(ifc,100)
!
!     la mise a 1 des 2 parametres suivants degrade le trace avec GS 8.0
!
      write(ifc,100) '0 setlinejoin'
      write(ifc,100) '0 setlinecap'
!
! *** remise a zero du BoundingBox page
!     attention: pas plus de 2**31-1 soit 2.e9 pour conversion en entier
!
      xmip=1.e9
      xmap=0.
      ymip=1.e9
      ymap=0.
!
! *** pas de stroke ulterieur
!
      lc=0
      is=0
!
  100 format(a)
  200 format(a,i4,1x,i4)
  300 format(a,4i8)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_dpagppo(pox,poy)
!
!     ------------------------------------------------------------------
! *   Object : system_drv, define_page_pen_position in cm
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      common /sdrcom/ ifc,lc,numpag,is

      character*32 forps
      character*4 fx,fy
!
      save forps,fx,fy
!
      if(lc.eq.1) then
                  write(ifc,100) 'stroke'
                  write(ifc,100)
                  endif
!
! *** conversion en ups
!
      call sdr_tcmiups(pox,poy,opsx,opsy)
!
! *** on ne deplace la plume sans trace (plume haute)
!     que si le chemin est ferme (is=0)
!     sinon, on fait un deplacement avec trace depuis la position
!     courante, sauf au premier appel qui definit le debut
!     du chemin total
!
! *   calcul du format pour le fichier PostScript
!
      call ucomfor_(opsx,opsy,fx,fy)
!
      forps='(' // fx // ',1x,' // fy //',1x,a)'
!
      if(is.eq.0) then
!                 * chemin ferme
                  write(ifc,forps) opsx,opsy,'STP moveto'
                  else
!                 * chemin ouvert ou debut de nouveau chemin
                  if(is.eq.1) then
                              write(ifc,forps) opsx,opsy,'STP moveto'
                              else
                              write(ifc,forps) opsx,opsy,'STP lineto'
                              endif
                  is=is+1
                  endif
      lc=0
!
  100 format(a)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_dpagsiz(spax,spay,smax,smay)
!
!     ---------------------------------------------------------------+--
! *   Object : system_drv, define_page_size and margin size, in cm.
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /sdrpag/ supsx,supsy, smarx,smary,ifor
!
      integer supsx(5), supsy(5)
!
      if(spax.le.1.) call uperror_('sdr_dpagsiz: spax <1cm')
      if(spay.le.1.) call uperror_('sdr_dpagsiz: spay <1cm')
!
      call sdr_wfilcom('begin dpagsiz_')
!
!
! *** calcul du format (de A4 a A0, toujours en format portrait)
!
      spama= spax+smax
!
      ifor=4
      if(spama.gt. 21.0) ifor=3
      if(spama.gt. 29.7) ifor=2
      if(spama.gt. 42.0) ifor=1
      if(spama.gt. 59.4) ifor=0
      if(spama.gt. 84.0) ifor=0
!
! *** calcul des marges en ups
!
      smarx= smax*72./2.54
      smary= smay*72./2.54
!
! *** directives de taille de page dans le fichier PostScript
!
      call sdr_wfilcom('end   dpagsiz_')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_gfontyp(fontyp,nbfon)
!
!     ---------------------------------------------------------------+--
! *   Object : system_drv, give_font_types from fontyp(13) as 'tital'
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) fontyp(13)
!
!
      fontyp( 1)='couri'
      fontyp( 2)='cbold'
      fontyp( 3)='cobli'
      fontyp( 4)='cbobl'
!
      fontyp( 5)='times'
      fontyp( 6)='tbold'
      fontyp( 7)='tital'
      fontyp( 8)='tbita'
!
      fontyp( 9)='helve'
      fontyp(10)='hbold'
      fontyp(11)='hobli'
      fontyp(12)='hbobl'
!
      fontyp(13)='symbo'
!
      nbfon=13
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_gfonwid(fonwid,nbfon)
!
!     ---------------------------------------------------------------+--
! *   Object : system_drv, give_font_width from fonwid(255,13) in cm.
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
! **  Les largeurs sont donnees en data  en UPS pour le corps 10;
!     Ils sont convertis en cm dans le tableau de retour fonwid.
!     Les caracteres imprimables vont de 33 a 255
!
      real wcouri(255), wcbold(255), wcobli(255),wcbobl(255)
      real wtimes(255), wtbold(255), wtital(255),wtbita(255)
      real whelve(255), whbold(255), whobli(255),whbobl(255)
!
      save wcouri, wcbold, wcobli,wcbobl
      save wtimes, wtbold, wtital,wtbita
      save whelve, whbold, whobli,whbobl
!
      real fonwid(255,13)
!                 achtung, fonwid(255,*) met des depassements memoire
!     ------------------------
!
! *** Courier (espacement fixes)
!
      data   wcouri /255*6.00/
      data   wcbold /255*6.00/
      data   wcobli /255*6.00/
      data   wcbobl /255*6.00/
!
! *** Times-Roman (espacement proportionnels)
!
      data   wtimes / 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 2.50,&
                      3.33, 4.08, 5.00, 5.00, 8.33, 7.78, 3.33, 3.33,&
                      3.33, 5.00, 5.64, 2.50, 3.33, 2.50, 2.78, 5.00,&
                      5.00, 5.00, 5.00, 5.00, 5.00, 5.00, 5.00, 5.00,&
                      5.00, 2.78, 2.78, 5.64, 5.64, 5.64, 4.44, 9.21,&
                      7.22, 6.67, 6.67, 7.22, 6.11, 5.56, 7.22, 7.22,&
                      3.33, 3.89, 7.22, 6.11, 8.89, 7.22, 7.22, 5.56,&
                      7.22, 6.67, 5.56, 6.11, 7.22, 7.22, 9.44, 7.22,&
                      7.22, 6.11, 3.33, 2.78, 3.33, 4.69, 5.00, 3.33,&
                      4.44, 5.00, 4.44, 5.00, 4.44, 3.33, 5.00, 5.00,&
                      2.78, 2.78, 5.00, 2.78, 7.78, 5.00, 5.00, 5.00,&
                      5.00, 3.33, 3.89, 2.78, 5.00, 5.00, 7.22, 5.00,&
                      5.00, 4.44, 4.80, 2.00, 4.80, 5.41, 5.00, 3.33,&
                      3.33, 3.33, 3.33, 3.33, 3.33, 2.78, 1.80, 3.33,&
                      2.00, 3.33, 5.00, 4.44,10.00, 5.00, 5.00, 3.33,&
                     10.00, 5.56, 3.33, 8.89, 3.33, 3.33, 4.44, 4.44,&
                      3.50, 5.00,10.00, 3.33, 9.80, 3.89, 3.33, 7.22,&
                      7.22, 2.50, 3.33, 5.00, 5.00, 2.00, 5.00, 3.33,&
                      7.60, 2.76, 5.00, 5.64, 3.33, 7.60, 3.33, 4.00,&
                      5.64, 3.00, 3.00, 3.33, 5.00, 4.53, 2.50, 3.33,&
                      3.00, 3.10, 5.00, 7.50, 7.50, 7.50, 4.44, 7.22,&
                      7.22, 7.22, 7.22, 7.22, 7.22, 8.89, 6.67, 6.11,&
                      6.11, 6.11, 6.11, 3.33, 3.33, 3.33, 3.33, 7.22,&
                      7.22, 7.22, 7.22, 7.22, 7.22, 7.22, 5.64, 7.22,&
                      7.22, 7.22, 7.22, 7.22, 7.22, 5.56, 5.00, 4.44,&
                      4.44, 4.44, 4.44, 4.44, 4.44, 6.67, 4.44, 4.44,&
                      4.44, 4.44, 4.44, 2.78, 2.78, 2.78, 2.78, 5.00,&
                      5.00, 5.00, 5.00, 5.00, 5.00, 5.00, 5.64, 5.00,&
                      5.00, 5.00, 5.00, 5.00, 5.00, 5.00, 5.00/
!
! *** Times-Bold
!
      data   wtbold / 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 2.50,&
                      3.33, 5.55, 5.00, 5.00,10.00, 8.33, 3.33, 3.33,&
                      3.33, 5.00, 5.70, 2.50, 3.33, 2.50, 2.78, 5.00,&
                      5.00, 5.00, 5.00, 5.00, 5.00, 5.00, 5.00, 5.00,&
                      5.00, 3.33, 3.33, 5.70, 5.70, 5.70, 5.00, 9.30,&
                      7.22, 6.67, 7.22, 7.22, 6.67, 6.11, 7.78, 7.78,&
                      3.89, 5.00, 7.78, 6.67, 9.44, 7.22, 7.78, 6.11,&
                      7.78, 7.22, 5.56, 6.67, 7.22, 7.22,10.00, 7.22,&
                      7.22, 6.67, 3.33, 2.78, 3.33, 5.81, 5.00, 3.33,&
                      5.00, 5.56, 4.44, 5.56, 4.44, 3.33, 5.00, 5.56,&
                      2.78, 3.33, 5.56, 2.78, 8.33, 5.56, 5.00, 5.56,&
                      5.56, 4.44, 3.89, 3.33, 5.56, 5.00, 7.22, 5.00,&
                      5.00, 4.44, 3.94, 2.20, 3.94, 5.20, 5.00, 3.33,&
                      3.33, 3.33, 3.33, 3.33, 3.33, 2.78, 2.78, 3.33,&
                      2.20, 3.33, 5.00, 5.00,10.00, 5.00, 5.00, 3.33,&
                     10.00, 5.56, 3.33,10.00, 3.33, 3.33, 5.00, 5.00,&
                      3.50, 5.00,10.00, 3.33,10.00, 3.89, 3.33, 7.22,&
                      7.22, 2.50, 3.33, 5.00, 5.00, 2.20, 5.00, 3.33,&
                      7.47, 3.00, 5.00, 5.70, 3.33, 7.47, 3.33, 4.00,&
                      5.70, 3.00, 3.00, 3.33, 5.56, 5.40, 2.50, 3.33,&
                      3.00, 3.30, 5.00, 7.50, 7.50, 7.50, 5.00, 7.22,&
                      7.22, 7.22, 7.22, 7.22, 7.22,10.00, 7.22, 6.67,&
                      6.67, 6.67, 6.67, 3.89, 3.89, 3.89, 3.89, 7.22,&
                      7.22, 7.78, 7.78, 7.78, 7.78, 7.78, 5.70, 7.78,&
                      7.22, 7.22, 7.22, 7.22, 7.22, 6.11, 5.56, 5.00,&
                      5.00, 5.00, 5.00, 5.00, 5.00, 7.22, 4.44, 4.44,&
                      4.44, 4.44, 4.44, 2.78, 2.78, 2.78, 2.78, 5.00,&
                      5.56, 5.00, 5.00, 5.00, 5.00, 5.00, 5.70, 5.00,&
                      5.56, 5.56, 5.56, 5.56, 5.00, 5.56, 5.00/
!
! *** Times-Italic
!
      data   wtital / 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 2.50,&
                      3.33, 4.20, 5.00, 5.00, 8.33, 7.78, 3.33, 3.33,&
                      3.33, 5.00, 6.75, 2.50, 3.33, 2.50, 2.78, 5.00,&
                      5.00, 5.00, 5.00, 5.00, 5.00, 5.00, 5.00, 5.00,&
                      5.00, 3.33, 3.33, 6.75, 6.75, 6.75, 5.00, 9.20,&
                      6.11, 6.11, 6.67, 7.22, 6.11, 6.11, 7.22, 7.22,&
                      3.33, 4.44, 6.67, 5.56, 8.33, 6.67, 7.22, 6.11,&
                      7.22, 6.11, 5.00, 5.56, 7.22, 6.11, 8.33, 6.11,&
                      5.56, 5.56, 3.89, 2.78, 3.89, 4.22, 5.00, 3.33,&
                      5.00, 5.00, 4.44, 5.00, 4.44, 2.78, 5.00, 5.00,&
                      2.78, 2.78, 4.44, 2.78, 7.22, 5.00, 5.00, 5.00,&
                      5.00, 3.89, 3.89, 2.78, 5.00, 4.44, 6.67, 4.44,&
                      4.44, 3.89, 4.00, 2.75, 4.00, 5.41, 5.00, 3.33,&
                      3.33, 3.33, 3.33, 3.33, 3.33, 2.78, 2.14, 3.33,&
                      2.75, 3.33, 5.00, 5.56, 8.89, 5.00, 5.00, 3.33,&
                     10.00, 5.00, 3.33, 9.44, 3.33, 3.33, 5.56, 5.56,&
                      3.50, 5.00, 8.89, 3.33, 9.80, 3.89, 3.33, 6.67,&
                      5.56, 2.50, 3.89, 5.00, 5.00, 2.75, 5.00, 3.33,&
                      7.60, 2.76, 5.00, 6.75, 3.33, 7.60, 3.33, 4.00,&
                      6.75, 3.00, 3.00, 3.33, 5.00, 5.23, 2.50, 3.33,&
                      3.00, 3.10, 5.00, 7.50, 7.50, 7.50, 5.00, 6.11,&
                      6.11, 6.11, 6.11, 6.11, 6.11, 8.89, 6.67, 6.11,&
                      6.11, 6.11, 6.11, 3.33, 3.33, 3.33, 3.33, 7.22,&
                      6.67, 7.22, 7.22, 7.22, 7.22, 7.22, 6.75, 7.22,&
                      7.22, 7.22, 7.22, 7.22, 5.56, 6.11, 5.00, 5.00,&
                      5.00, 5.00, 5.00, 5.00, 5.00, 6.67, 4.44, 4.44,&
                      4.44, 4.44, 4.44, 2.78, 2.78, 2.78, 2.78, 5.00,&
                      5.00, 5.00, 5.00, 5.00, 5.00, 5.00, 6.75, 5.00,&
                      5.00, 5.00, 5.00, 5.00, 4.44, 5.00, 4.44/
!
! *** Times-BoldItalic
!
      data   wtbita / 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 2.50,&
                      3.89, 5.55, 5.00, 5.00, 8.33, 7.78, 3.33, 3.33,&
                      3.33, 5.00, 5.70, 2.50, 3.33, 2.50, 2.78, 5.00,&
                      5.00, 5.00, 5.00, 5.00, 5.00, 5.00, 5.00, 5.00,&
                      5.00, 3.33, 3.33, 5.70, 5.70, 5.70, 5.00, 8.32,&
                      6.67, 6.67, 6.67, 7.22, 6.67, 6.67, 7.22, 7.78,&
                      3.89, 5.00, 6.67, 6.11, 8.89, 7.22, 7.22, 6.11,&
                      7.22, 6.67, 5.56, 6.11, 7.22, 6.67, 8.89, 6.67,&
                      6.11, 6.11, 3.33, 2.78, 3.33, 5.70, 5.00, 3.33,&
                      5.00, 5.00, 4.44, 5.00, 4.44, 3.33, 5.00, 5.56,&
                      2.78, 2.78, 5.00, 2.78, 7.78, 5.56, 5.00, 5.00,&
                      5.00, 3.89, 3.89, 2.78, 5.56, 4.44, 6.67, 5.00,&
                      4.44, 3.89, 3.48, 2.20, 3.48, 5.70, 5.00, 3.33,&
                      3.33, 3.33, 3.33, 3.33, 3.33, 2.78, 2.78, 3.33,&
                      2.20, 3.33, 5.00, 5.00,10.00, 5.00, 5.00, 3.33,&
                     10.00, 5.56, 3.33, 9.44, 3.33, 3.33, 5.00, 5.00,&
                      3.50, 5.00,10.00, 3.33,10.00, 3.89, 3.33, 7.22,&
                      6.11, 2.50, 3.89, 5.00, 5.00, 2.20, 5.00, 3.33,&
                      7.47, 2.66, 5.00, 6.06, 3.33, 7.47, 3.33, 4.00,&
                      5.70, 3.00, 3.00, 3.33, 5.76, 5.00, 2.50, 3.33,&
                      3.00, 3.00, 5.00, 7.50, 7.50, 7.50, 5.00, 6.67,&
                      6.67, 6.67, 6.67, 6.67, 6.67, 9.44, 6.67, 6.67,&
                      6.67, 6.67, 6.67, 3.89, 3.89, 3.89, 3.89, 7.22,&
                      7.22, 7.22, 7.22, 7.22, 7.22, 7.22, 5.70, 7.22,&
                      7.22, 7.22, 7.22, 7.22, 6.11, 6.11, 5.00, 5.00,&
                      5.00, 5.00, 5.00, 5.00, 5.00, 7.22, 4.44, 4.44,&
                      4.44, 4.44, 4.44, 2.78, 2.78, 2.78, 2.78, 5.00,&
                      5.56, 5.00, 5.00, 5.00, 5.00, 5.00, 5.70, 5.00,&
                      5.56, 5.56, 5.56, 5.56, 4.44, 5.00, 4.44/
!
! *** Helvetica
!
      data   whelve / 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 2.78,&
                      2.78, 3.55, 5.56, 5.56, 8.89, 6.67, 2.22, 3.33,&
                      3.33, 3.89, 5.84, 2.78, 3.33, 2.78, 2.78, 5.56,&
                      5.56, 5.56, 5.56, 5.56, 5.56, 5.56, 5.56, 5.56,&
                      5.56, 2.78, 2.78, 5.84, 5.84, 5.84, 5.56,10.15,&
                      6.67, 6.67, 7.22, 7.22, 6.67, 6.11, 7.78, 7.22,&
                      2.78, 5.00, 6.67, 5.56, 8.33, 7.22, 7.78, 6.67,&
                      7.78, 7.22, 6.67, 6.11, 7.22, 6.67, 9.44, 6.67,&
                      6.67, 6.11, 2.78, 2.78, 2.78, 4.69, 5.56, 2.22,&
                      5.56, 5.56, 5.00, 5.56, 5.56, 2.78, 5.56, 5.56,&
                      2.22, 2.22, 5.00, 2.22, 8.33, 5.56, 5.56, 5.56,&
                      5.56, 3.33, 5.00, 2.78, 5.56, 5.00, 7.22, 5.00,&
                      5.00, 5.00, 3.34, 2.60, 3.34, 5.84, 5.00, 3.33,&
                      3.33, 3.33, 3.33, 3.33, 3.33, 2.78, 1.91, 3.33,&
                      2.60, 2.22, 5.56, 3.33,10.00, 5.56, 5.56, 3.33,&
                     10.00, 6.67, 3.33,10.00, 2.22, 2.22, 3.33, 3.33,&
                      3.50, 5.56,10.00, 3.33,10.00, 5.00, 3.33, 9.44,&
                      6.67, 2.78, 3.33, 5.56, 5.56, 2.60, 5.56, 3.33,&
                      7.37, 3.70, 5.56, 5.84, 3.33, 7.37, 3.33, 4.00,&
                      5.84, 3.33, 3.33, 3.33, 5.56, 5.37, 2.78, 3.33,&
                      3.33, 3.65, 5.56, 8.34, 8.34, 8.34, 6.11, 6.67,&
                      6.67, 6.67, 6.67, 6.67, 6.67,10.00, 7.22, 6.67,&
                      6.67, 6.67, 6.67, 2.78, 2.78, 2.78, 2.78, 7.22,&
                      7.22, 7.78, 7.78, 7.78, 7.78, 7.78, 5.84, 7.78,&
                      7.22, 7.22, 7.22, 7.22, 6.67, 6.67, 6.11, 5.56,&
                      5.56, 5.56, 5.56, 5.56, 5.56, 8.89, 5.00, 5.56,&
                      5.56, 5.56, 5.56, 2.78, 2.78, 2.78, 2.78, 5.56,&
                      5.56, 5.56, 5.56, 5.56, 5.56, 5.56, 5.84, 6.11,&
                      5.56, 5.56, 5.56, 5.56, 5.00, 5.56, 5.00/
!
! *** Helvetica-Bold
!
      data   whbold / 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 2.78,&
                      3.33, 4.74, 5.56, 5.56, 8.89, 7.22, 2.78, 3.33,&
                      3.33, 3.89, 5.84, 2.78, 3.33, 2.78, 2.78, 5.56,&
                      5.56, 5.56, 5.56, 5.56, 5.56, 5.56, 5.56, 5.56,&
                      5.56, 3.33, 3.33, 5.84, 5.84, 5.84, 6.11, 9.75,&
                      7.22, 7.22, 7.22, 7.22, 6.67, 6.11, 7.78, 7.22,&
                      2.78, 5.56, 7.22, 6.11, 8.33, 7.22, 7.78, 6.67,&
                      7.78, 7.22, 6.67, 6.11, 7.22, 6.67, 9.44, 6.67,&
                      6.67, 6.11, 3.33, 2.78, 3.33, 5.84, 5.56, 2.78,&
                      5.56, 6.11, 5.56, 6.11, 5.56, 3.33, 6.11, 6.11,&
                      2.78, 2.78, 5.56, 2.78, 8.89, 6.11, 6.11, 6.11,&
                      6.11, 3.89, 5.56, 3.33, 6.11, 5.56, 7.78, 5.56,&
                      5.56, 5.00, 3.89, 2.80, 3.89, 5.84, 5.00, 3.33,&
                      3.33, 3.33, 3.33, 3.33, 3.33, 2.78, 2.38, 3.33,&
                      2.80, 2.78, 5.56, 5.00,10.00, 5.56, 5.56, 3.33,&
                     10.00, 6.67, 3.33,10.00, 2.78, 2.78, 5.00, 5.00,&
                      3.50, 5.56,10.00, 3.33,10.00, 5.56, 3.33, 9.44,&
                      6.67, 2.78, 3.33, 5.56, 5.56, 2.80, 5.56, 3.33,&
                      7.37, 3.70, 5.56, 5.84, 3.33, 7.37, 3.33, 4.00,&
                      5.84, 3.33, 3.33, 3.33, 6.11, 5.56, 2.78, 3.33,&
                      3.33, 3.65, 5.56, 8.34, 8.34, 8.34, 6.11, 7.22,&
                      7.22, 7.22, 7.22, 7.22, 7.22,10.00, 7.22, 6.67,&
                      6.67, 6.67, 6.67, 2.78, 2.78, 2.78, 2.78, 7.22,&
                      7.22, 7.78, 7.78, 7.78, 7.78, 7.78, 5.84, 7.78,&
                      7.22, 7.22, 7.22, 7.22, 6.67, 6.67, 6.11, 5.56,&
                      5.56, 5.56, 5.56, 5.56, 5.56, 8.89, 5.56, 5.56,&
                      5.56, 5.56, 5.56, 2.78, 2.78, 2.78, 2.78, 6.11,&
                      6.11, 6.11, 6.11, 6.11, 6.11, 6.11, 5.84, 6.11,&
                      6.11, 6.11, 6.11, 6.11, 5.56, 6.11, 5.56/
!
! *** Helvetica-Oblique
!
      data   whobli / 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 2.78,&
                      2.78, 3.55, 5.56, 5.56, 8.89, 6.67, 2.22, 3.33,&
                      3.33, 3.89, 5.84, 2.78, 3.33, 2.78, 2.78, 5.56,&
                      5.56, 5.56, 5.56, 5.56, 5.56, 5.56, 5.56, 5.56,&
                      5.56, 2.78, 2.78, 5.84, 5.84, 5.84, 5.56,10.15,&
                      6.67, 6.67, 7.22, 7.22, 6.67, 6.11, 7.78, 7.22,&
                      2.78, 5.00, 6.67, 5.56, 8.33, 7.22, 7.78, 6.67,&
                      7.78, 7.22, 6.67, 6.11, 7.22, 6.67, 9.44, 6.67,&
                      6.67, 6.11, 2.78, 2.78, 2.78, 4.69, 5.56, 2.22,&
                      5.56, 5.56, 5.00, 5.56, 5.56, 2.78, 5.56, 5.56,&
                      2.22, 2.22, 5.00, 2.22, 8.33, 5.56, 5.56, 5.56,&
                      5.56, 3.33, 5.00, 2.78, 5.56, 5.00, 7.22, 5.00,&
                      5.00, 5.00, 3.34, 2.60, 3.34, 5.84, 5.00, 3.33,&
                      3.33, 3.33, 3.33, 3.33, 3.33, 2.78, 1.91, 3.33,&
                      2.60, 2.22, 5.56, 3.33,10.00, 5.56, 5.56, 3.33,&
                     10.00, 6.67, 3.33,10.00, 2.22, 2.22, 3.33, 3.33,&
                      3.50, 5.56,10.00, 3.33,10.00, 5.00, 3.33, 9.44,&
                      6.67, 2.78, 3.33, 5.56, 5.56, 2.60, 5.56, 3.33,&
                      7.37, 3.70, 5.56, 5.84, 3.33, 7.37, 3.33, 4.00,&
                      5.84, 3.33, 3.33, 3.33, 5.56, 5.37, 2.78, 3.33,&
                      3.33, 3.65, 5.56, 8.34, 8.34, 8.34, 6.11, 6.67,&
                      6.67, 6.67, 6.67, 6.67, 6.67,10.00, 7.22, 6.67,&
                      6.67, 6.67, 6.67, 2.78, 2.78, 2.78, 2.78, 7.22,&
                      7.22, 7.78, 7.78, 7.78, 7.78, 7.78, 5.84, 7.78,&
                      7.22, 7.22, 7.22, 7.22, 6.67, 6.67, 6.11, 5.56,&
                      5.56, 5.56, 5.56, 5.56, 5.56, 8.89, 5.00, 5.56,&
                      5.56, 5.56, 5.56, 2.78, 2.78, 2.78, 2.78, 5.56,&
                      5.56, 5.56, 5.56, 5.56, 5.56, 5.56, 5.84, 6.11,&
                      5.56, 5.56, 5.56, 5.56, 5.00, 5.56, 5.00/
!
! *** Helvetica-BoldOblique
!
      data   whbobl / 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00,&
                      0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 2.78,&
                      3.33, 4.74, 5.56, 5.56, 8.89, 7.22, 2.78, 3.33,&
                      3.33, 3.89, 5.84, 2.78, 3.33, 2.78, 2.78, 5.56,&
                      5.56, 5.56, 5.56, 5.56, 5.56, 5.56, 5.56, 5.56,&
                      5.56, 3.33, 3.33, 5.84, 5.84, 5.84, 6.11, 9.75,&
                      7.22, 7.22, 7.22, 7.22, 6.67, 6.11, 7.78, 7.22,&
                      2.78, 5.56, 7.22, 6.11, 8.33, 7.22, 7.78, 6.67,&
                      7.78, 7.22, 6.67, 6.11, 7.22, 6.67, 9.44, 6.67,&
                      6.67, 6.11, 3.33, 2.78, 3.33, 5.84, 5.56, 2.78,&
                      5.56, 6.11, 5.56, 6.11, 5.56, 3.33, 6.11, 6.11,&
                      2.78, 2.78, 5.56, 2.78, 8.89, 6.11, 6.11, 6.11,&
                      6.11, 3.89, 5.56, 3.33, 6.11, 5.56, 7.78, 5.56,&
                      5.56, 5.00, 3.89, 2.80, 3.89, 5.84, 5.00, 3.33,&
                      3.33, 3.33, 3.33, 3.33, 3.33, 2.78, 2.38, 3.33,&
                      2.80, 2.78, 5.56, 5.00,10.00, 5.56, 5.56, 3.33,&
                     10.00, 6.67, 3.33,10.00, 2.78, 2.78, 5.00, 5.00,&
                      3.50, 5.56,10.00, 3.33,10.00, 5.56, 3.33, 9.44,&
                      6.67, 2.78, 3.33, 5.56, 5.56, 2.80, 5.56, 3.33,&
                      7.37, 3.70, 5.56, 5.84, 3.33, 7.37, 3.33, 4.00,&
                      5.84, 3.33, 3.33, 3.33, 6.11, 5.56, 2.78, 3.33,&
                      3.33, 3.65, 5.56, 8.34, 8.34, 8.34, 6.11, 7.22,&
                      7.22, 7.22, 7.22, 7.22, 7.22,10.00, 7.22, 6.67,&
                      6.67, 6.67, 6.67, 2.78, 2.78, 2.78, 2.78, 7.22,&
                      7.22, 7.78, 7.78, 7.78, 7.78, 7.78, 5.84, 7.78,&
                      7.22, 7.22, 7.22, 7.22, 6.67, 6.67, 6.11, 5.56,&
                      5.56, 5.56, 5.56, 5.56, 5.56, 8.89, 5.56, 5.56,&
                      5.56, 5.56, 5.56, 2.78, 2.78, 2.78, 2.78, 6.11,&
                      6.11, 6.11, 6.11, 6.11, 6.11, 6.11, 5.84, 6.11,&
                      6.11, 6.11, 6.11, 6.11, 5.56, 6.11, 5.56/
!
! *** Symbol (a definir !)
!
!  ex:     data   wsymbo /255*6.00/
!
!
! *** mise en memoire des largeurs de caracteres
!     et conversion en cm
!
      do 10 i=1,255
!
      fonwid(i, 1)=wcouri(i)*2.54/72.
      fonwid(i, 2)=wcbold(i)*2.54/72.
      fonwid(i, 3)=wcobli(i)*2.54/72.
      fonwid(i, 4)=wcbobl(i)*2.54/72.
!
      fonwid(i, 5)=wtimes(i)*2.54/72.
      fonwid(i, 6)=wtbold(i)*2.54/72.
      fonwid(i, 7)=wtital(i)*2.54/72.
      fonwid(i, 8)=wtbita(i)*2.54/72.
!
      fonwid(i, 9)=whelve(i)*2.54/72.
      fonwid(i,10)=whbold(i)*2.54/72.
      fonwid(i,11)=whobli(i)*2.54/72.
      fonwid(i,12)=whbobl(i)*2.54/72.
!
! ***! on prends helvetica pour symbol en attendant mieux...
!
      fonwid(i,13)=whelve(i)*2.54/72.
!
   10 continue
!
      nbfon=13
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_pfilzon
!
!     ------------------------------------------------------------------
! *   Object : system_drv, plot_fill_zone of preceding plot
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      common /sdrcom/ ifc,lc,numpag,is
!
!
      write(ifc,100) 'closepath'
      write(ifc,100) 'fill'
      write(ifc,100)
!
      lc=0
!
! *** ferme aussi le chemin
      is=0
!
  100 format(a)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_ppagcha(chast,pox,poy,angle)
!
!     ------------------------------------------------------------------
! *   Object : system_drv, plot_character_string at bottom left corner
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      common /sdrcom/ ifc,lc,numpag,is
!
      character*(*) chast

      character*64 forps
      character*4 fx,fy
      character*255 ligne
      character*255 lignec
!
      save forps,fx,fy,ligne,lignec
!
!
      if(lc.eq.1) then
                  write(ifc,100) 'stroke'
                  write(ifc,100)
                  endif
!
! *** conversion en ups
!
      call sdr_tcmiups(pox,poy,opsx,opsy)
!
! *** traitement des parenthese et du backslash  en PostScript
!     (on ajoute \ devant les parenthese ou devant un \)
!
      ligne=chast
      lignec=ligne
      ic=0
!
      do 10 i=1,255
      ic=ic+1
      if(ic.gt.255) go to 20
!
      if(lignec(ic:ic).eq.'('.or.lignec(ic:ic).eq.')'.or.lignec(ic:ic).eq.char(92)) then
                                    lignec(1:ic-1)=ligne(1:ic-1)
                                    lignec(ic+1:255)=ligne(ic:254)
                                    lignec(ic:ic)=char(92)
                                    ic=ic+1
                                    ligne=lignec
                                    go to 10
                                    endif
   10 continue
   20 continue
!
      call cchalen_(lignec,ncu)
!
! *** trace de l'instruction dans le fichier PostScript
!
! *   calcul du format pour le fichier PostScript
!
      call ucomfor_(opsx,opsy,fx,fy)
!
      if(abs(angle).gt.0.1) then
            forps="(f8.2,1x,'(',a,') ',1x,f8.2,1x," // fx  // ',1x,' // fy // ',1x,a)'
            write(ifc,forps) -angle,lignec(1:ncu),angle,opsx,opsy,'MTRS'
                           else
            forps="('(',a,') '," // fx //',1x,' //fy // ',1x,a)'
            write(ifc,forps) lignec(1:ncu), opsx,opsy,'MTS'
                            endif
      lc=0
!
  100 format(a)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_ppagima(pox,poy,sizx,sizy,angle,imag,nx,ny)
!
      common /sdrcom/ ifc,lc,numpag,is
!
!     ------------------------------------------------------------------
! *   Object : system_drv, plot_page_image
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      integer imag(nx,ny)
!
      character*2 hra(300000), hga(300000), hba(300000)
      save hra,hga,hba
!
!
      if(lc.eq.1.and.is.ne.1) then
                              write(ifc,100) 'stroke'
                              write(ifc,100)
                              endif
!
      if(is.eq.2) then
                  write(ifc,100) 'clip'
                  else
                  write(ifc,100) 'gsave'
                  endif
!
! *** conversion en ups
!
      call sdr_tcmiups(pox,poy,opsx,opsy)
!
! *** tests
!
      if(nx.gt.300000)  call uperror_('sps_ppagima: nx > 300000')
!
      if(opsx.lt.   0.) call uperror_('sps_ppagima: origine x negative')
      if(opsy.lt.   0.) call uperror_('sps_ppagima: origine y negative')
      if(opsx.gt.9999.) call uperror_('sps_ppagima: origine x too big')
      if(opsy.gt.9999.) call uperror_('sps_ppagima: origine y too big')
!
      ucm= 72./2.54
      scax=sizx*ucm
      scay=sizy*ucm
!
      if(scax.lt.   0.) call uperror_('sps_ppagima: scale x negative')
      if(scay.lt.   0.) call uperror_('sps_ppagima: scale y negative')
      if(scax.gt.9999.) call uperror_('sps_ppagima: scale x too big')
      if(scay.gt.9999.) call uperror_('sps_ppagima: scale y too big')
!
! *** chargement de l'image
!
      write(ifc,100) ' '
      write(ifc,200) ' /w ',nx,' def'
      write(ifc,200) ' /h ',ny,' def'
      write(ifc,100) ' /bpp 8 def'
      write(ifc,100) ' /chaine w 3 mul string def'
      write(ifc,100) ' /dump'
      write(ifc,100) ' {'
      write(ifc,100) ' w h bpp [w 0 0 h neg 0 h]'
      write(ifc,100) ' { currentfile chaine readhexstring pop } false 3 colorimage'
      write(ifc,100) ' } def'
      write(ifc,100) '  '
!
      write(ifc,400) opsx,opsy, ' translate'
      if(abs(angle).gt.0.01) write(ifc,500) angle
      write(ifc,400) scax,scay, ' scale'
!
      write(ifc,100) '  dump'
!
      do 20 iy=1,ny
      ky=ny-iy+1
      do 30 ix=1,nx
      call cicorgb_(imag(ix,ky),ir,ig,ib)
      call cdechex_(ir,hra(ix))
      call cdechex_(ig,hga(ix))
      call cdechex_(ib,hba(ix))
   30 continue
      write(ifc,300) (hra(ix),hga(ix),hba(ix),ix=1,nx)
   20 continue
!
      write(ifc,100)
      if(abs(angle).gt.0.01) write(ifc,500) -angle
      write(ifc,100) 'grestore'
      write(ifc,100)
!
      lc=0
      is=0
!
!
  100 format(2a)
  200 format(a,i5,a)
  300 format(32(3a2))
  400 format(f8.2,1x,f8.2,a)
  500 format(f8.2,' rotate')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_ppagpmo(pox,poy)
!
!     ------------------------------------------------------------------
! *   Object : system_drv, plot_pen_motion in cm
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      common /sdrcom/ ifc,lc,numpag,is
!
      character*32 forps
      character*4 fx,fy
!
      save forps,fx,fy
!
!
! *** conversion en ups
!
      call sdr_tcmiups(pox,poy,opsx,opsy)
!
! *** trace de l'instruction dans le fichier PostScript
!
! *   calcul du format pour le fichier PostScript
!
      call ucomfor_(opsx,opsy,fx,fy)
!
      forps='(' // fx // ',1x,' // fy //',1x,a)'
!
      write(ifc,forps) opsx,opsy,'STP lineto'
!
! *** stroke ulterieur (seul subroutine autorisee a le faire)
!     seulement si on n'a pas ouvert de chemin par dfilzon_
!
      if(is.eq.0) then
                  lc=1
                  else
                  lc=0
                  endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_tcmiups(pox,poy,opsx,opsy)
!
!     ------------------------------------------------------------------
! *   Object : system_drv, transform_cm_in_ups
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      common /sdrpag/ supsx,supsy, smarx,smary,ifor
!
      integer supsx(5), supsy(5)
!
! *** conversion en ups
!
      ucm= 72./2.54
!
      opsx= smarx +pox*ucm
      opsy= smary +poy*ucm
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_updbbox
!
!     ------------------------------------------------------------------
! *   Object : system_drv, update bounding box values
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2007
!     ------------------------------------------------------------------
!
      common /boupag/ xminb,xmaxb,yminb,ymaxb
      common /sdrbbo/ xmip,xmap,ymip,ymap, xmimip,xmamap,ymimip,ymamap
!
! *** conversion en ups et chargement du common /sdrbbo/
!
      call sdr_tcmiups(xminb,yminb,xmip,ymip)
      call sdr_tcmiups(xmaxb,ymaxb,xmap,ymap)
!
      xmimip= min(xmimip,xmip)
      xmamap= max(xmamap,xmap)
      ymimip= min(ymimip,ymip)
      ymamap= max(ymamap,ymap)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sdr_wfilcom(com)
!
!     ------------------------------------------------------------------
! *   Object : system_drv, write_file_comment in .ps file
! *   Class  : system postscript driver modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      common /sdrcom/ ifc,lc,numpag,is
!
      character*(*) com
!
      if(com(1:5).eq.'begin') then
                              write(ifc,200) com
                              else
                              write(ifc,100) com
                              endif
!
  100 format(  '%ROGRALIB: ',a)
  200 format(/,'%ROGRALIB: ',a)
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine sys_gdattim(imon,id,iy,ih,im,is)
!
!     ------------------------------------------------------------------
!
! *   Object : system_low:give_date_time at the call
! *   Class  : system compiler dependant modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!
!     input : none
!     output: all arguments
!
!     ------------------------------------------------------------------
!
      integer time
!
      n=time()
!
      juld70= n/86400
      secotd= float(n -juld70*86400)
      milday= int(secotd*1000.)
! dbg print*, 'n,juld70,secotd,milday=',n,juld70,secotd,milday
!
      call cdatj70_(juld70,iy,imon,id)
      call ctimmil_(milday,ih,im,is,ims)
! dbg print*, 'iy,imon,id,ih,im,is,ims=',iy,imon,id,ih,im,is,ims
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine uboundi_(ix,ix1,ix2)
!
!     ---------------------------------------------------------------+--
! *   Object : u_bounds_integer ix as  ix1 <ix <ix2
! *   Class  : utility modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      if(ix.lt.ix1) ix=ix1
      if(ix.gt.ix2) ix=ix2
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ubounds_(x,x1,x2)
!
!     ---------------------------------------------------------------+--
! *   Object : u_bounds x as x1 <x <x2
! *   Class  : utility modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      if(x.lt.x1) x=x1
      if(x.gt.x2) x=x2
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ucgraste(dx,ggx,pgx)
!
!     ---------------------------------------------------------------+--
! *   Object : u_compute_graduations_steps from dx=x2-x1
! *   Class  : utility modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      data epsi  /1.e-35/
      save epsi
!
!
! *** calcule des intervalles de graduation pour dx donne
!                utilitaire de cgraste_
!
!
      if(dx.lt.0.)   call uperror_('ucgraste: dx negatif')
      if(dx.lt.epsi) call uperror_('ucgraste: dx trop petit')
!
      call cmanexp_(dx,rdx,ie)
      id=int(rdx*10.+0.5)
      if(id.lt.1) id=1
!
      go to (1,2,3,4,5,6,7,8,9,1),id
!
    1 ggx=dx/5.
      pgx=ggx/4.
      return
!
    2 ggx=dx/4.
      pgx=ggx/5.
      return
!
    3 ggx=dx/3.
! old pgx=ggx/10.
      pgx=ggx/5.
      return
!
    4 ggx=dx/4.
! old pgx=ggx/10.
      pgx=ggx/5.
      return
!
    5 ggx=dx/5.
! old pgx=ggx/10.
      pgx=ggx/4.
      return
!
    6 ggx=dx/3.
      pgx=ggx/4.
      return
!
    7 ggx=dx*2./7.
      pgx=ggx/4.
      return
!
    8 ggx=dx/4.
      pgx=ggx/4.
      return
!
    9 ggx=dx*2./9.
      pgx=ggx/4.
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ucomfor_(xups,yups,fx,fy)
!
!     ---------------------------------------------------------------+--
! *   Object : u_compute_format for lineto/moveto of PS file
! *   Class  : utility modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   2008
!     ---------------------------------------------------------------+--
!
      character*4 fx,fy
!
! *** avoid '****' string in PostScript file in case of overlap format
!     Note:
!     limits of x,y in ups units should be, in A0 format:
!         0 < x < 2380
!         0 < y < 3368
!
!     limits taken:     [-9999.90, +9999.90]
!
!
! *   compute X format
!
      if(xups.gt.0.) then
                     fx='F4.2'
                     if(xups.gt.   9.9) fx='F5.2'
                     if(xups.gt.  99.9) fx='F6.2'
                     if(xups.gt. 999.9) fx='F7.2'
                     if(xups.gt.9999.9) xups= 9999.90

                     else
                     fx='F5.2'
                     if(xups.lt.   -9.9) fx='F6.2'
                     if(xups.lt.  -99.9) fx='F7.2'
                     if(xups.lt. -999.9) fx='F8.2'
                     if(xups.lt. -9999.9) xups= -9999.90
                     endif
!
! *   compute Y format
!
      if(yups.gt.0.) then
                     fy='F4.2'
                     if(yups.gt.   9.9) fy='F5.2'
                     if(yups.gt.  99.9) fy='F6.2'
                     if(yups.gt. 999.9) fy='F7.2'
                     if(yups.gt.9999.9) yups= 9999.90

                     else
                     fy='F5.2'
                     if(yups.lt.   -9.9) fy='F6.2'
                     if(yups.lt.  -99.9) fy='F7.2'
                     if(yups.lt. -999.9) fy='F8.2'
                     if(yups.lt. -9999.9) yups= -9999.90
                     endif
!
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine udecfor_(format,ifg,n,nd)
!
!     ---------------------------------------------------------------+--
! *   Object : u_decode_format
! *   Class  : utility modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) format
      character*1 s(8),ifg
      character*8 for8
!
! *** decode un format en fournissant ses caracteristiques
!
!
      for8=format
!
      read(for8,1) (s(i),i=1,8)
      ifg=s(2)
      if(ifg.ne.'i' .and. ifg.ne.'I') go to 10
      nd=0
      if(s(4).eq.')' .or. s(4).eq.'.') read(for8,2) n
      if(s(5).eq.')' .or. s(5).eq.'.') read(for8,3) n
      return
!
   10 continue
      if(s(4).ne.'.') go to 20
      read(for8,4) n,nd
      return
!
   20 continue
      if(s(6).eq.')') read(for8,4) n,nd
      if(s(7).eq.')') read(for8,5) n,nd
      if(s(8).eq.')') read(for8,6) n,nd
!
    1 format(8a1)
    2 format(2x,i1,5x)
    3 format(2x,i2,4x)
    4 format(2x,i1,1x,i1,3x)
    5 format(2x,i2,1x,i1,2x)
    6 format(2x,i2,1x,i2,1x)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine uencfor_(format,ifg,n,nd)
!
!     ---------------------------------------------------------------+--
! *   Object : u_encode_format
! *   Class  : utility modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) format
      character*1 ifg
!
! *** encode un format a partir de ses caracteristiques
!
!
      ll=len(format)
      if(ll.lt.8) call uperror_('uencfor_: format inferieur a 8 caracteres')
!
      if(ifg.ne.'i') go to 10
      if(n.le.9) write(format,1) n
      if(n.ge.10) write(format,2) n
      return
!
   10 continue
      if(n.gt.9) go to 20
      write(format,3) ifg,n,nd
      return
!
   20 continue
      if(nd.gt.9) go to 30
      write(format,4) ifg,n,nd
      return
!
   30 continue
      write(format,5) ifg,n,nd
!
    1 format('(i',i1,')',4x)
    2 format('(i',i2,')',3x)
    3 format('(',a1,i1,'.',i1,')',2x)
    4 format('(',a1,i2,'.',i1,')',1x)
    5 format('(',a1,i2,'.',i2,')')
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine ufigbou_(xcm,ycm)
!
!     ---------------------------------------------------------------+--
! *   Object : u_figure_boundaries force xcm, ycm inside the figure
! *   Class  : utility modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      common /figsiz/ rx,ry
      common /figori/ xz,yz
!
! *** limite xcm et ycm aux bornes en cm de la figure
!
      if(xcm.lt.xz) xcm=xz
      if(xcm.gt.xz+rx) xcm=xz+rx
!
      if(ycm.lt.yz) ycm=yz
      if(ycm.gt.yz+ry) ycm=yz+ry
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine uhuergb_(rm1,rm2,hue,rgb)
!
!     ---------------------------------------------------------------+--
! *   Object : utility_for_chsbrgb_
! *   Class  : utility modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      hh=hue
      if(hh.lt.0.) hh=hh+1.
      if(hh.gt.1.) hh=hh-1.
!
      if(hh.lt.1./6.) then
                      rgb= rm1 + (rm2-rm1)*hh*6.
                      return
                      endif
!
      if(hh.lt.1./2.) then
                      rgb= rm2
                      return
                      endif
!
      if(hh.lt.2./3.) then
                      rgb= rm1 + (rm2-rm1)*(2./3. -hh)*6.
                      return
                      endif
      rgb=rm1
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine upchael_(cara,x,y,tax,tay,angle)
!
!     ---------------------------------------------------------------+--
! *   Object : u_plot_character_element used by upchast_
! *   Class  : utility modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) cara
      character*1 car
      save car
!
!
! *** trace du texte par deplacement de plume
!
!
      integer cxga(5),cyga(5)
      integer cxgb(12),cygb(12)
      integer cxgc(8),cygc(8)
      integer cxgd(7),cygd(7)
      integer cxge(7),cyge(7)
      integer cxgf(6),cygf(6)
      integer cxgg(10),cygg(10)
      integer cxgh(6),cygh(6)
      integer cxgi(6),cygi(6)
      integer cxgj(5),cygj(5)
      integer cxgk(7),cygk(7)
      integer cxgl(4),cygl(4)
      integer cxgm(7),cygm(7)
      integer cxgn(6),cygn(6)
      integer cxgo(9),cygo(9)
      integer cxgp(7),cygp(7)
      integer cxgq(10),cygq(10)
      integer cxgr(10),cygr(10)
      integer cxgs(12),cygs(12)
      integer cxgt(7),cygt(7)
      integer cxgu(6),cygu(6)
      integer cxgv(3),cygv(3)
      integer cxgw(5),cygw(5)
      integer cxgx(6),cygx(6)
      integer cxgy(5),cygy(5)
      integer cxgz(4),cygz(4)
      integer cx1(5),cy1(5)
      integer cx2(9),cy2(9)
      integer cx3(13),cy3(13)
      integer cx4(8),cy4(8)
      integer cx5(9),cy5(9)
      integer cx6(12),cy6(12)
      integer cx7(7),cy7(7)
      integer cx8(16),cy8(16)
      integer cx9(12),cy9(12)
      integer cx0(9),cy0(9)
      integer cxplus(5),cyplus(5)
      integer cxmoin(2),cymoin(2)
      integer cxpoin(5),cypoin(5)
      integer cxslas(2),cyslas(2)
      integer cx2pn1(5),cy2pn1(5)
      integer cx2pn2(5),cy2pn2(5)
      integer cxpaou(4),cypaou(4)
      integer cxpafe(4),cypafe(4)
      integer cxpce1(2),cypce1(2)
      integer cxpce2(5),cypce2(5)
      integer cxpce3(5),cypce3(5)
      integer cxega1(2),cyega1(2)
      integer cxega2(2),cyega2(2)
      integer cxvirg(4),cyvirg(4)
      integer cxpvi1(4),cypvi1(4)
      integer cxpvi2(5),cypvi2(5)
!
      integer cxa(10),cya(10)
      integer cxb(8),cyb(8)
      integer cxc(8),cyc(8)
      integer cxd(7),cyd(7)
      integer cxe(10),cye(10)
      integer cxf(7),cyf(7)
      integer cxg(12),cyg(12)
      integer cxh(7),cyh(7)
      integer cxi1(5),cyi1(5)
      integer cxi2(5),cyi2(5)
      integer cxj1(5),cyj1(5)
      integer cxj2(5),cyj2(5)
      integer cxk(8),cyk(8)
      integer cxl(2),cyl(2)
      integer cxm(10),cym(10)
      integer cxn(7),cyn(7)
      integer cxo(9),cyo(9)
      integer cxp(9),cyp(9)
      integer cxq(9),cyq(9)
      integer cxr(6),cyr(6)
      integer cxs(10),cys(10)
      integer cxt(8),cyt(8)
      integer cxu(6),cyu(6)
      integer cxv(3),cyv(3)
      integer cxw(5),cyw(5)
      integer cxx(13),cyx(13)
      integer cxy(10),cyy(10)
      integer cxz(4),cyz(4)
!
! *** save for gfortran
!
      save cxga,cyga
      save cxgb,cygb
      save cxgc,cygc
      save cxgd,cygd
      save cxge,cyge
      save cxgf,cygf
      save cxgg,cygg
      save cxgh,cygh
      save cxgi,cygi
      save cxgj,cygj
      save cxgk,cygk
      save cxgl,cygl
      save cxgm,cygm
      save cxgn,cygn
      save cxgo,cygo
      save cxgp,cygp
      save cxgq,cygq
      save cxgr,cygr
      save cxgs,cygs
      save cxgt,cygt
      save cxgu,cygu
      save cxgv,cygv
      save cxgw,cygw
      save cxgx,cygx
      save cxgy,cygy
      save cxgz,cygz
      save cx1,cy1
      save cx2,cy2
      save cx3,cy3
      save cx4,cy4
      save cx5,cy5
      save cx6,cy6
      save cx7,cy7
      save cx8,cy8
      save cx9,cy9
      save cx0,cy0
      save cxplus,cyplus
      save cxmoin,cymoin
      save cxpoin,cypoin
      save cxslas,cyslas
      save cx2pn1,cy2pn1
      save cx2pn2,cy2pn2
      save cxpaou,cypaou
      save cxpafe,cypafe
      save cxpce1,cypce1
      save cxpce2,cypce2
      save cxpce3,cypce3
      save cxega1,cyega1
      save cxega2,cyega2
      save cxvirg,cyvirg
      save cxpvi1,cypvi1
      save cxpvi2,cypvi2
!
      save cxa,cya
      save cxb,cyb
      save cxc,cyc
      save cxd,cyd
      save cxe,cye
      save cxf,cyf
      save cxg,cyg
      save cxh,cyh
      save cxi1,cyi1
      save cxi2,cyi2
      save cxj1,cyj1
      save cxj2,cyj2
      save cxk,cyk
      save cxl,cyl
      save cxm,cym
      save cxn,cyn
      save cxo,cyo
      save cxp,cyp
      save cxq,cyq
      save cxr,cyr
      save cxs,cys
      save cxt,cyt
      save cxu,cyu
      save cxv,cyv
      save cxw,cyw
      save cxx,cyx
      save cxy,cyy
      save cxz,cyz
!
      data nga/5/
      data ngb/12/
      data ngc/8/
      data ngd/7/
      data nge/7/
      data ngf/6/
      data ngg/10/
      data ngh/6/
      data ngi/6/
      data ngj/5/
      data ngk/7/
      data ngl/4/
      data ngm/7/
      data ngn/6/
      data ngo/9/
      data ngp/7/
      data ngq/10/
      data ngr/10/
      data ngs/12/
      data ngt/7/
      data ngu/6/
      data ngv/3/
      data ngw/5/
      data ngx/6/
      data ngy/5/
      data ngz/4/
      data n1/5/
      data n2/9/
      data n3/13/
      data n4/8/
      data n5/9/
      data n6/12/
      data n7/7/
      data n8/16/
      data n9/12/
      data n0/9/
      data nplus/5/
      data nmoin/2/
      data npoin/5/
      data nslas/2/
      data n2pn1/5/
      data n2pn2/5/
      data npaou/4/
      data npafe/4/
      data npce1/2/
      data npce2/5/
      data npce3/5/
      data nega1/2/
      data nega2/2/
      data nvirg/4/
      data npvi1/4/
      data npvi2/5/
!
      data na/10/
      data nb/8/
      data nc/8/
      data nd/7/
      data ne/10/
      data nf/7/
      data ng/12/
      data nh/7/
      data ni1/5/
      data ni2/5/
      data nj1/5/
      data nj2/5/
      data nk/8/
      data nl/2/
      data nm/10/
      data nn/7/
      data no/9/
      data np/9/
      data nq/9/
      data nr/6/
      data ns/10/
      data nt/8/
      data nu/6/
      data nv/3/
      data nw/5/
      data nx/13/
      data ny/10/
      data nz/4/
!
! *** les coordonnees pour le trace de chaque caractere
!     sont dans une grille entiere 6 X 6
!
      data cxga/1,3,5,4,2/
      data cyga/0,6,0,3,3/
      data cxgb/1,1,4,5,5,4,1,4,5,5,4,1/
      data cygb/0,6,6,5,4,3,3,3,2,1,0,0/
      data cxgc/5,4,2,1,1,2,4,5/
      data cygc/1,0,0,1,5,6,6,5/
      data cxgd/1,4,5,5,4,1,1/
      data cygd/0,0,1,5,6,6,0/
      data cxge/5,1,1,4,1,1,5/
      data cyge/0,0,3,3,3,6,6/
      data cxgf/1,1,4,1,1,5/
      data cygf/0,3,3,3,6,6/
      data cxgg/3,5,5,4,2,1,1,2,4,5/
      data cygg/2,2,1,0,0,1,5,6,6,5/
      data cxgh/1,1,1,5,5,5/
      data cygh/6,0,3,3,6,0/
      data cxgi/2,4,3,3,2,4/
      data cygi/6,6,6,0,0,0/
      data cxgj/5,5,4,2,1/
      data cygj/6,1,0,0,1/
      data cxgk/1,1,1,3,5,3,5/
      data cygk/6,0,3,3,6,3,0/
      data cxgl/1,1,5,5/
      data cygl/6,0,0,1/
      data cxgm/1,1,2,3,4,5,5/
      data cygm/0,6,6,4,6,6,0/
      data cxgn/1,1,2,4,5,5/
      data cygn/0,6,6,0,0,6/
      data cxgo/1,1,2,4,5,5,4,2,1/
      data cygo/1,5,6,6,5,1,0,0,1/
      data cxgp/1,1,4,5,5,4,1/
      data cygp/0,6,6,5,4,3,3/
      data cxgq/4,2,1,1,2,4,5,5,4,3/
      data cygq/0,0,1,5,6,6,5,1,0,2/
      data cxgr/1,1,4,5,5,4,1,4,5,5/
      data cygr/0,6,6,5,4,3,3,3,2,0/
      data cxgs/1,2,4,5,5,4,2,1,1,2,4,5/
      data cygs/1,0,0,1,2,3,3,4,5,6,6,5/
      data cxgt/1,1,3,3,3,5,5/
      data cygt/5,6,6,0,6,6,5/
      data cxgu/1,1,2,4,5,5/
      data cygu/6,1,0,0,1,6/
      data cxgv/1,3,5/
      data cygv/6,0,6/
      data cxgw/1,2,3,4,5/
      data cygw/6,0,3,0,6/
      data cxgx/1,3,1,5,3,5/
      data cygx/0,3,6,0,3,6/
      data cxgy/1,3,5,3,3/
      data cygy/6,3,6,3,0/
      data cxgz/1,5,1,5/
      data cygz/6,6,0,0/
      data cx1/1,3,3,2,4/
      data cy1/5,6,0,0,0/
      data cx2/1,1,2,4,5,5,1,1,5/
      data cy2/4,5,6,6,5,4,1,0,0/
      data cx3/1,2,4,5,5,4,3,4,5,5,4,2,1/
      data cy3/5,6,6,5,4,3,3,3,2,1,0,0,1/
      data cx4/4,1,1,4,4,4,4,5/
      data cy4/6,3,2,2,3,0,2,2/
      data cx5/5,1,1,4,5,5,4,2,1/
      data cy5/6,6,3,3,2,1,0,0,1/
      data cx6/5,4,2,1,1,2,4,5,5,4,2,1/
      data cy6/5,6,6,5,1,0,0,1,2,3,3,2/
      data cx7/1,1,5,4,2,4,3/
      data cy7/5,6,6,3,3,3,0/
      data cx8/2,1,1,2,4,5,5,4,2,1,1,2,4,5,5,4/
      data cy8/3,4,5,6,6,5,4,3,3,2,1,0,0,1,2,3/
      data cx9/5,4,2,1,1,2,4,5,5,4,2,1/
      data cy9/4,3,3,4,5,6,6,5,1,0,0,1/
      data cx0/2,1,1,2,4,5,5,4,2/
      data cy0/6,4,2,0,0,2,4,6,6/
      data cxplus/3,3,3,1,5/
      data cyplus/5,1,3,3,3/
      data cxmoin/1,5/
      data cymoin/3,3/
      data cxpoin/2,2,3,3,2/
      data cypoin/0,1,1,0,0/
      data cxslas/1,5/
      data cyslas/0,6/
      data cx2pn1/2,2,3,3,2/
      data cy2pn1/1,2,2,1,1/
      data cx2pn2/2,2,3,3,2/
      data cy2pn2/4,5,5,4,4/
      data cxpaou/4,3,3,4/
      data cypaou/0,2,4,6/
      data cxpafe/2,3,3,2/
      data cypafe/0,2,4,6/
      data cxpce1/1,5/
      data cypce1/0,6/
      data cxpce2/4,4,5,5,4/
      data cypce2/1,2,2,1,1/
      data cxpce3/1,1,2,2,1/
      data cypce3/4,5,5,4,4/
      data cxega1/2,4/
      data cyega1/2,2/
      data cxega2/2,4/
      data cyega2/4,4/
      data cxvirg/2,3,4,2/
      data cyvirg/0,2,2,0/
      data cxpvi1/2,3,4,2/
      data cypvi1/0,2,2,0/
      data cxpvi2/3,3,4,4,3/
      data cypvi2/3,4,4,3,3/
!
! *** pour l'alphabet minuscule, le pave 6 X 6 est transforme
!     par un depassement de -3 en y pour la queue des lettres
!     (donc 6 X 9 en fait)
!
      data cxa/1,2,4,5,5,6,2,1,2,5/
      data cya/3,4,4,3,0,0,0,1,2,2/
      data cxb/1,1,4,5,5,4,2,1/
      data cyb/6,0,0,1,3,4,4,3/
      data cxc/5,4,2,1,1,2,4,5/
      data cyc/3,4,4,3,1,0,0,1/
      data cxd/5,5,2,1,1,2,5/
      data cyd/6,0,0,1,3,4,4/
      data cxe/1,5,5,4,2,1,1,2,4,5/
      data cye/2,2,3,4,4,3,1,0,0,1/
      data cxf/5,4,2,1,1,1,3/
      data cyf/5,6,6,5,0,3,3/
      data cxg/ 1, 2, 4, 5,5,4,2,1,1,2,4,5/
      data cyg/-2,-3,-3,-2,3,4,4,3,1,0,0,1/
      data cxh/1,1,1,2,4,5,5/
      data cyh/0,6,3,4,4,3,0/
      data cxi1/1,1,2,4,5/
      data cyi1/4,1,0,0,1/
      data cxi2/1,1,2,2,1/
      data cyi2/5,6,6,5,5/
      data cxj1/5, 5, 4, 2, 1/
      data cyj1/4,-2,-3,-3,-2/
      data cxj2/4,4,5,5,4/
      data cyj2/5,6,6,5,5/
      data cxk/1,1,1,3,5,3,2,4/
      data cyk/0,6,2,4,4,4,3,0/
      data cxl/3,3/
      data cyl/6,0/
      data cxm/5,5,4,3,3,3,2,1,1,1/
      data cym/0,4,4,3,0,4,4,3,0,4/
      data cxn/5,5,4,2,1,1,1/
      data cyn/0,3,4,4,3,0,4/
      data cxo/1,1,2,4,5,5,4,2,1/
      data cyo/3,1,0,0,1,3,4,4,3/
      data cxp/ 1,1,2,4,5,5,4,2,1/
      data cyp/-3,3,4,4,3,1,0,0,1/
      data cxq/ 5,5,4,2,1,1,2,4,5/
      data cyq/-3,3,4,4,3,1,0,0,1/
      data cxr/1,1,1,2,3,4/
      data cyr/4,0,3,4,4,3/
      data cxs/5,4,2,1,2,4,5,4,2,1/
      data cys/3,4,4,3,2,2,1,0,0,1/
      data cxt/1,1,3,1,1,2,4,5/
      data cyt/5,4,4,4,1,0,0,1/
      data cxu/1,1,2,4,5,5/
      data cyu/4,1,0,0,1,4/
      data cxv/1,3,5/
      data cyv/4,0,4/
      data cxw/1,2,3,4,5/
      data cyw/4,0,4,0,4/
      data cxx/1,2,3,4,5,4,3,4,5,4,3,2,1/
      data cyx/4,4,2,4,4,4,2,0,0,0,2,0,0/
      data cxy/1,1,2,4,5,5, 5, 4, 2, 1/
      data cyy/4,1,0,0,1,4,-2,-3,-3,-2/
      data cxz/1,4,1,4/
      data cyz/4,4,0,0/
!
!
      tx=tax/6.
      ty=tay/6.
      a=angle
      car=cara(1:1)
!
!
      if(car.eq.'A') call upcincm_(x,y,cxga  ,cyga  ,nga  ,tx,ty,a,*100)
      if(car.eq.'B') call upcincm_(x,y,cxgb  ,cygb  ,ngb  ,tx,ty,a,*100)
      if(car.eq.'C') call upcincm_(x,y,cxgc  ,cygc  ,ngc  ,tx,ty,a,*100)
      if(car.eq.'D') call upcincm_(x,y,cxgd  ,cygd  ,ngd  ,tx,ty,a,*100)
      if(car.eq.'E') call upcincm_(x,y,cxge  ,cyge  ,nge  ,tx,ty,a,*100)
      if(car.eq.'F') call upcincm_(x,y,cxgf  ,cygf  ,ngf  ,tx,ty,a,*100)
      if(car.eq.'G') call upcincm_(x,y,cxgg  ,cygg  ,ngg  ,tx,ty,a,*100)
      if(car.eq.'H') call upcincm_(x,y,cxgh  ,cygh  ,ngh  ,tx,ty,a,*100)
      if(car.eq.'I') call upcincm_(x,y,cxgi  ,cygi  ,ngi  ,tx,ty,a,*100)
      if(car.eq.'J') call upcincm_(x,y,cxgj  ,cygj  ,ngj  ,tx,ty,a,*100)
      if(car.eq.'K') call upcincm_(x,y,cxgk  ,cygk  ,ngk  ,tx,ty,a,*100)
      if(car.eq.'L') call upcincm_(x,y,cxgl  ,cygl  ,ngl  ,tx,ty,a,*100)
      if(car.eq.'M') call upcincm_(x,y,cxgm  ,cygm  ,ngm  ,tx,ty,a,*100)
      if(car.eq.'N') call upcincm_(x,y,cxgn  ,cygn  ,ngn  ,tx,ty,a,*100)
      if(car.eq.'O') call upcincm_(x,y,cxgo  ,cygo  ,ngo  ,tx,ty,a,*100)
      if(car.eq.'P') call upcincm_(x,y,cxgp  ,cygp  ,ngp  ,tx,ty,a,*100)
      if(car.eq.'Q') call upcincm_(x,y,cxgq  ,cygq  ,ngq  ,tx,ty,a,*100)
      if(car.eq.'R') call upcincm_(x,y,cxgr  ,cygr  ,ngr  ,tx,ty,a,*100)
      if(car.eq.'S') call upcincm_(x,y,cxgs  ,cygs  ,ngs  ,tx,ty,a,*100)
      if(car.eq.'T') call upcincm_(x,y,cxgt  ,cygt  ,ngt  ,tx,ty,a,*100)
      if(car.eq.'U') call upcincm_(x,y,cxgu  ,cygu  ,ngu  ,tx,ty,a,*100)
      if(car.eq.'V') call upcincm_(x,y,cxgv  ,cygv  ,ngv  ,tx,ty,a,*100)
      if(car.eq.'W') call upcincm_(x,y,cxgw  ,cygw  ,ngw  ,tx,ty,a,*100)
      if(car.eq.'X') call upcincm_(x,y,cxgx  ,cygx  ,ngx  ,tx,ty,a,*100)
      if(car.eq.'Y') call upcincm_(x,y,cxgy  ,cygy  ,ngy  ,tx,ty,a,*100)
      if(car.eq.'Z') call upcincm_(x,y,cxgz  ,cygz  ,ngz  ,tx,ty,a,*100)
      if(car.eq.'1') call upcincm_(x,y,cx1   ,cy1   ,n1   ,tx,ty,a,*100)
      if(car.eq.'2') call upcincm_(x,y,cx2   ,cy2   ,n2   ,tx,ty,a,*100)
      if(car.eq.'3') call upcincm_(x,y,cx3   ,cy3   ,n3   ,tx,ty,a,*100)
      if(car.eq.'4') call upcincm_(x,y,cx4   ,cy4   ,n4   ,tx,ty,a,*100)
      if(car.eq.'5') call upcincm_(x,y,cx5   ,cy5   ,n5   ,tx,ty,a,*100)
      if(car.eq.'6') call upcincm_(x,y,cx6   ,cy6   ,n6   ,tx,ty,a,*100)
      if(car.eq.'7') call upcincm_(x,y,cx7   ,cy7   ,n7   ,tx,ty,a,*100)
      if(car.eq.'8') call upcincm_(x,y,cx8   ,cy8   ,n8   ,tx,ty,a,*100)
      if(car.eq.'9') call upcincm_(x,y,cx9   ,cy9   ,n9   ,tx,ty,a,*100)
      if(car.eq.'0') call upcincm_(x,y,cx0   ,cy0   ,n0   ,tx,ty,a,*100)
      if(car.eq.'+') call upcincm_(x,y,cxplus,cyplus,nplus,tx,ty,a,*100)
      if(car.eq.'-') call upcincm_(x,y,cxmoin,cymoin,nmoin,tx,ty,a,*100)
      if(car.eq.'.') call upcincm_(x,y,cxpoin,cypoin,npoin,tx,ty,a,*100)
      if(car.eq.'/') call upcincm_(x,y,cxslas,cyslas,nslas,tx,ty,a,*100)
      if(car.eq.':') call upcincm_(x,y,cx2pn1,cy2pn1,n2pn1,tx,ty,a,*110)
  110 if(car.eq.':') call upcincm_(x,y,cx2pn2,cy2pn2,n2pn2,tx,ty,a,*100)
      if(car.eq.'(') call upcincm_(x,y,cxpaou,cypaou,npaou,tx,ty,a,*100)
      if(car.eq.')') call upcincm_(x,y,cxpafe,cypafe,npafe,tx,ty,a,*100)
      if(car.eq.'%') call upcincm_(x,y,cxpce1,cypce1,npce1,tx,ty,a,*120)
  120 if(car.eq.'%') call upcincm_(x,y,cxpce2,cypce2,npce2,tx,ty,a,*121)
  121 if(car.eq.'%') call upcincm_(x,y,cxpce3,cypce3,npce3,tx,ty,a,*100)
      if(car.eq.'=') call upcincm_(x,y,cxega1,cyega1,nega1,tx,ty,a,*130)
  130 if(car.eq.'=') call upcincm_(x,y,cxega2,cyega2,nega2,tx,ty,a,*100)
      if(car.eq.',') call upcincm_(x,y,cxvirg,cyvirg,nvirg,tx,ty,a,*100)
      if(car.eq.';') call upcincm_(x,y,cxpvi1,cypvi1,npvi1,tx,ty,a,*140)
  140 if(car.eq.';') call upcincm_(x,y,cxpvi2,cypvi2,npvi2,tx,ty,a,*100)
!
!
      if(car.eq.'a') call upcincm_(x,y,cxa ,cya ,na ,tx,ty,a,*100)
      if(car.eq.'b') call upcincm_(x,y,cxb ,cyb ,nb ,tx,ty,a,*100)
      if(car.eq.'c') call upcincm_(x,y,cxc ,cyc ,nc ,tx,ty,a,*100)
      if(car.eq.'d') call upcincm_(x,y,cxd ,cyd ,nd ,tx,ty,a,*100)
      if(car.eq.'e') call upcincm_(x,y,cxe ,cye ,ne ,tx,ty,a,*100)
      if(car.eq.'f') call upcincm_(x,y,cxf ,cyf ,nf ,tx,ty,a,*100)
      if(car.eq.'g') call upcincm_(x,y,cxg ,cyg ,ng ,tx,ty,a,*100)
      if(car.eq.'h') call upcincm_(x,y,cxh ,cyh ,nh ,tx,ty,a,*100)
      if(car.eq.'i') call upcincm_(x,y,cxi1,cyi1,ni1,tx,ty,a,*150)
  150 if(car.eq.'i') call upcincm_(x,y,cxi2,cyi2,ni2,tx,ty,a,*100)
      if(car.eq.'j') call upcincm_(x,y,cxj1,cyj1,nj1,tx,ty,a,*160)
  160 if(car.eq.'j') call upcincm_(x,y,cxj2,cyj2,nj2,tx,ty,a,*100)
      if(car.eq.'k') call upcincm_(x,y,cxk ,cyk ,nk, tx,ty,a,*100)
      if(car.eq.'l') call upcincm_(x,y,cxl ,cyl ,nl, tx,ty,a,*100)
      if(car.eq.'m') call upcincm_(x,y,cxm ,cym ,nm, tx,ty,a,*100)
      if(car.eq.'n') call upcincm_(x,y,cxn ,cyn ,nn, tx,ty,a,*100)
      if(car.eq.'o') call upcincm_(x,y,cxo ,cyo ,no, tx,ty,a,*100)
      if(car.eq.'p') call upcincm_(x,y,cxp ,cyp ,np, tx,ty,a,*100)
      if(car.eq.'q') call upcincm_(x,y,cxq ,cyq ,nq, tx,ty,a,*100)
      if(car.eq.'r') call upcincm_(x,y,cxr ,cyr ,nr, tx,ty,a,*100)
      if(car.eq.'s') call upcincm_(x,y,cxs ,cys ,ns, tx,ty,a,*100)
      if(car.eq.'t') call upcincm_(x,y,cxt ,cyt ,nt, tx,ty,a,*100)
      if(car.eq.'u') call upcincm_(x,y,cxu ,cyu ,nu, tx,ty,a,*100)
      if(car.eq.'v') call upcincm_(x,y,cxv ,cyv ,nv, tx,ty,a,*100)
      if(car.eq.'w') call upcincm_(x,y,cxw ,cyw ,nw, tx,ty,a,*100)
      if(car.eq.'x') call upcincm_(x,y,cxx ,cyx ,nx, tx,ty,a,*100)
      if(car.eq.'y') call upcincm_(x,y,cxy ,cyy ,ny, tx,ty,a,*100)
      if(car.eq.'z') call upcincm_(x,y,cxz ,cyz ,nz, tx,ty,a,*100)
!
!
  100 return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine upcincm_(x,y,ix,iy,in,rmx,rmy,a,*)
!
!     ---------------------------------------------------------------+--
! *   Object : u_plot_curve_in_cm. from x-y origin, used by upchael_
! *   Class  : utility modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      dimension ix(in),iy(in)
!
! *** trace une courbe en cm, origine x,y facteur ech rmx,rmy
!     avec rotation d'angle a et return sur une etiquette
!
!
      cx=x+float(ix(1))*rmx
      cy=y+float(iy(1))*rmy
!
      call cplarot_(x,y,a,cx,cy,gx,gy)
      call dpagppo_(gx,gy)
!
      do 20 i=2,in
      cx=x+float(ix(i))*rmx
      cy=y+float(iy(i))*rmy
      call cplarot_(x,y,a,cx,cy,gx,gy)
      call ppagpmo_(gx,gy)
   20 continue
!
      return 1
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine uperror_(com)
!
!     ---------------------------------------------------------------+--
! *   Object : u_print_error stop the run and print diagnostics
! *   Class  : utility modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) com
!
!
      print 100
      print 200
      print 100, 'ROGRALIB: ERROR !!!'
      print 100
      print 100, com
      print 100
      print 100, 'premature close of grafical file'
      print 100, 'premature end of main program'
      print 200
      print 100
!
      call sdr_dclogra
!
  100 format(1x,a)
  200 format(1x,78('*'))
!
      stop 'error ROGRALIB - see outpout'
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine upwarni_(com)
!
!     ---------------------------------------------------------------+--
! *   Object : u_print_warni  may be preceding uperror
! *   Class  : utility modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) com
!
!
      print 100
      print 100, 'ROGRALIB: *** WARNING ',com
!
  100 format(1x,2a)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine urinbel_
!
      character*1 bell
!
!     ------------------------------------------------------------------
! *   Object : u_ring_bell by printing 'OO7' character
! *   Class  : utility modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ------------------------------------------------------------------
!
      data bell/''/
      save bell
!
!     bell='007' en octal
!
      print *,bell
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine uverfor_(format,com)
!
!     ---------------------------------------------------------------+--
! *   Object : u_verify_format and stop run and print com if not valid
! *   Class  : utility modules of Rogralib Software
! *   Author : P. Robert, ScientiDev,   1992
!     ---------------------------------------------------------------+--
!
      character*(*) format,com
      character*80 com2
      save com2
!
! *** verifi la validite d'un format
!
!
      call cchalen_(format,l)
      call cchalen_(com,ncom)
!
      if(l.lt.4) then
                 com2='uverfor_'//com(1:ncom)//': format inferieur a 4 caracteres'
                 call uperror_(com2)
                 endif
!
      if(format(1:1).ne.'(') then
                 com2='uverfor_'//com(1:ncom)//': le format ne commence pas par ('
                 call uperror_(com2)
                 endif
!
      if(format(l:l).ne.')') then
                 com2='uverfor_'//com(1:ncom)//': le format ne se termine pas par )'
                 call uperror_(com2)
                 endif
!
      if(format(2:2).ne.'i'.and.format(2:2).ne.'I'.and.format(2:2).ne.'f'.and.&
         format(2:2).ne.'F'.and.format(2:2).ne.'e'.and.format(2:2).ne.'E') then
                 com2='uverfor_'//com(1:ncom)//': format type i,f,e ou I,F,E seulement'
                 call uperror_(com2)
                 endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
