
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
  subroutine plotframe(titl,tcl,titr,tcr,signat)
!
! --------------------------------------------------------------------+--
! Trace le cadre "CETP" avec titre gauche   et droit dans le bandeau,
! signature et date de production
! --------------------------------------------------------------------+--
!
  character*(*) titl,titr,signat
  character*64  bandeau,prodat
  character*25  datim,fontyp
!
  Bandeau='LABORATOIRE  DE PHYSIQUE DES PLASMAS  -  SCIENTIDEV'
  tc1 =0.28
  tcsi=0.25
  tmar=0.3
  pvt=9.5
!
  call  gpagsiz_(psx,psy)
!
  call  glinwid_(wid)
  call  dlinwid_(4.)
  call  dfontyp_('h')
!
! *** bandeau jaune
!
  call  dlinrgb_(1.,1.,0.7)
  call  dfilzon_
  call  ppagrec_(0.,psy-0.7,psx,0.7)
  call  pfilzon_
!
! *** cadre et titre
!
  call  dlincol_('n')
  call  ppagfra_
  call  ppagcha_(psx/2.,psy-0.35,0,tc1,tc1,0.,bandeau)

  call  ppaghli_(psy-0.7)
!
  call gfonnum_(numfon)
  call cchawid_(titl,numfon,tcl,width)
  if(width.gt.pvt-2.*tmar) tcl=tcl*(pvt-2.*tmar)/width

  call  ppagcha_(tmar,psy-1.45,-1,tcl,tcl,0.,titl)
  call  ppagcha_(tmar*2.+pvt,psy-1.4,-1,tcr,tcr,0.,titr)
  call  ppaghli_(psy-1.8)
  call  ppaglin_(pvt,psy-1.8,9.5,psy-0.7)

  call  dlinwid_(wid)
!
! *** signature et date
!
  call  gfontyp_(fontyp)
  call  dfontyp_('tital')
  call  gstdati_(datim)
!
  prodat='Production date:  '//datim
!
  call  gfonnum_(numfon)
  call  cchawid_(signat,numfon,tcsi,wid)
  tcsix=tcsi
  if(wid.gt.11.2) tcsix=tcsix*11.2/wid
  call  ppagcha_(tmar,0.2,-1,tcsix,tcsix,0.,trim(signat))
  call  ppagcha_(psx-tmar,0.2,+1,tcsi,tcsi,0.,prodat)

  call  dfontyp_(fontyp)
!
  return
  END
!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
  subroutine cdattit_(iyear,imon,iday,dattit)
!
  character*(*) dattit
  character*9 cmon
  character*8 forj
  character*80  format
!
! --------------------------------------------------------------------+--
! #   compute_date_titre pour le titre droit de la page
! --------------------------------------------------------------------+--
!
  if(iyear.ge.2000) then
   call  cojd00(iyear,imon,iday,jd00)
                   else
   call  cojd50(iyear,imon,iday,jd00)
  endif

  idec=int(alog10(abs(float(jd00)))+0.5)+2
  print*, 'jd00,idec=',jd00,idec
  
  call  cmoncar_(imon,cmon)
  call  cchalen_(cmon,nbchar)

  write(forj,'(a,I1,a)') ',I',idec,','
  format='(i4.4,1x,a,1x,i2.2,"   (Julian day "'//trim(forj)//'")")'
  print*, 'format=',format
  write(dattit,format)  iyear,cmon(1:nbchar),iday,jd00
  print*, 'dattit=',trim(dattit)
!
  return
  END
!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
  subroutine pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
!
  common /figsiz/ rx,ry
  common /figori/ xz,yz
  common /figlim/ x1,x2,y1,y2
  common /grasiz/ tgrax,tgray,dgxax,dgyay,ncgrax,ncgray
  common /grapos/ ipgrax,ipgray
  common /stisiz/ tgm,tpm
  common /stipos/ ipmabx,ipmahx,ipmagy,ipmady

  real  valgra(nbgma)
  character*(*) titgra(nbgma)

! --------------------------------------------------------------------+--
! #   plot_figure_graduation_hourly
!
! plot les graduation   d'un axe horaire calcule par cfiggrah
! P. Robert, CETP, Avril  2005
! --------------------------------------------------------------------+--
!
  call  sdr_wfilcom('begin pfiggrah')

! *** trace des grandes et petites marques, du haut et du bas,
!     suivant   option vers interieur ou exterieur

  tgb=tgm*ipmabx
  tpb=tpm*ipmabx
  tgh=tgm*ipmahx
  tph=tpm*ipmahx!
  ex=rx/(x2-x1)
  valpdt=valdt/float(nbpma)
  xxp=xz

  do i=1,nbgma
    xxp=xz +(valgra(i)-x1)*ex
    if((xxp.ge.xz).and.(xxp.le.xz+rx))    then
       call  dpagppo_(xxp,yz)
       call  ppagpmo_(xxp,yz+tgb)
       call  dpagppo_(xxp,yz+ry)
       call  ppagpmo_(xxp,yz+ry-tgh)
    endif

    do j=1,nbpma
      xxpp=xxp +float(j)*valpdt*ex
      if((xxpp.ge.xz).and.(xxpp.le.xz+rx))  then
         call  dpagppo_(xxpp,yz)
         call  ppagpmo_(xxpp,yz+tpb)
         call  dpagppo_(xxpp,yz+ry)
         call  ppagpmo_(xxpp,yz+ry-tph)
      endif
    enddo
  enddo

! *   si on demarre a une grande marque > t1, on rajoute des petites marques au debut

  xx=xz +(valgra(1)-x1)*ex

  do j=1,nbpma
     xxp=xx -float(j)*valpdt*ex
     if(xxp.lt.xz) cycle
     call  dpagppo_(xxp,yz)
     call  ppagpmo_(xxp,yz+tpb)
     call  dpagppo_(xxp,yz+ry)
     call  ppagpmo_(xxp,yz+ry-tph)
  enddo
!
! *** trace de la valeur horaire des graduations
!
  if(tgrax.lt.0.001) go to  50

  dgxax= tgm +0.5*tgrax

  do  i=1,nbgma
     xx=xz +(valgra(i)-x1)*ex
     if(ipgrax.eq.1) then
!   graduations   en haut
         yy=yz+ry+dgxax+tgrax/2.
                     else
!   graduations   en bas
         yy=yz-dgxax-tgrax/2.
     endif
     if((xx.ge.xz).and.(xx.le.xz+rx)) then
        call ppagcha_(xx,yy,0,tgrax,tgrax,0.,titgra(i))
     endif
  enddo

   50 continue

  call  sdr_wfilcom('end   pfiggrah')

  return
  end
!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
  subroutine cfiggrah(t1,t2,valgra,titgra,valdt,nbgma,nbpma)
!
  real  valgra(nbgma)
  character*(*) titgra(nbgma)
!
! --------------------------------------------------------------------+--
! #   compute_figure_graduation_hourly
!
! Pour un   axe horaire, avec t1 et t2 en heure decimale, calcul du
! nombre de grandes marques, du nombre de   petite marques,
! du tableau de la valeur   en heure decimale de chaque grande marque,
! et du tableau character   du titre de chaque grande marque,
! sous la   forme  HH:MM:SS.
!
! Calcul valable pour   des periode de 2 mn a 4 jours.
!
! P. Robert, CETP, Octobre  2000
!     revision Decembre 2000 pour extension a + de 24h
!     revision Octobre  2002    pour arondi des bornes.
!     revision Avril    2005 passage IDL -> F77
! --------------------------------------------------------------------+--
!
! *** arondi eventuel des bornes a une minute ronde
!
! on commence   par arondir les bornes t1 et t2 a une minute ronde
! (inferieure   et superieure) si la difference est inferieure a
! la tolerence (0.1cm/15cm)*(t2-t1)
!
  tol=  (t2-t1)*0.1/15.
!
  print*, 'roundt1t2: t1,t2 initial=',  t1,t2
  print*, '    tol= ',tol, ' soit   ',tol*3600.,' sec'
!
  ith=  int(t1)
  itm=  int((t1-ith)*60.)
  t1r=  float(ith) +itm/60.
!
  if(abs(t1r-t1).lt.tol) t1=t1r
!
  ith=  int(t2)
  itm=  int((t2-ith)*60.)
  t2r=  float(ith) +(itm+1)/60.
!
  if(abs(t2r-t2).lt.tol) t2=t2r
!
  print*, 'roundt1t2: t1,t2 rounded=',  t1,t2
!
! *** on definit 9 echelles caracteristiques; t1,t2 en heures
!
  nbh   = int(t2-t1 +0.01)
  nb10m = int((t2-t1)*6.   +0.01)
  nb5m  = int((t2-t1)*12.  +0.01)
  nb2m  = int((t2-t1)*30.  +0.01)
  nb1m  = int((t2-t1)*60.  +0.01)
  nb30s = int((t2-t1)*120. +0.01)
  nb10s = int((t2-t1)*360. +0.01)
  nb5s  = int((t2-t1)*720. +0.01)
  nb1s  = int((t2-t1)*3600.+0.01)
!
! *** test de duree minimum
!
  if( (t2-t1)*3600.lt.2) then
      print*, '***  cfiggrah: duration.lt.2 s.'
      print*, '   t1,t2 (hours)=',t1,t2
      print*, '   duration (mn)=',(t2-t1)*60.
      print*, '***   arret brutal, pas de .ps'
      STOP 'COGRATIM        *** ABORTED ! T2-T1 < 2S      ***'
  endif
!
! *** calcul du nombre de marques et des valeurs associees
!
! nbgma= nombre de grandes marques, portant une valeur
! nbpma= nombre de petites marques entre 2 grandes marques
! valg1= heure de   la premiere marque
! valdt= intervalle entre   2 marques
!
  if(nb1s.gt.1) then
    nbgma=  nb1s +1
    valdt=  1./3600.
    valg1=int(t1*3600.+0.01)/3600.
    nbpma=5
  endif
!
  if(nb5s.gt.1) then
    nbgma=  nb5s +1
    valdt=  1./720.
    valg1=int(t1*720.+0.01)/720.
    nbpma=5
  endif
!
  if(nb10s.gt.1) then
    nbgma=  nb10s +1
    valdt=  1./360.
    valg1=int(t1*360.+0.01)/360.
    nbpma=5
  endif
!
  if(nb30s.gt.1) then
    nbgma=  nb30s +1
    valdt=  1./120.
    valg1=int(t1*120.+0.01)/120.
    nbpma=3
  endif
!
  if(nb1m.gt.1) then
    nbgma=  nb1m +1
    valdt=  1./60.
    valg1=int(t1*60.+0.01)/60.
    nbpma=6
    endif
!
  if(nb2m.gt.1) then
    nbgma=  nb2m +1
    valdt=  1./30.
    valg1=int(t1*30.+0.01)/30.
    nbpma=4
  endif
!
  if(nb5m.gt.1) then
    nbgma=  nb5m +1
    valdt=  1./12.
    valg1=int(t1*12.+0.01)/12.
    nbpma=5
  endif
!
  if(nb10m.gt.1) then
     nbgma= nb10m +1
     valdt= 1./6.
     valg1=int(t1*6.+0.01)/6.
     nbpma=5
   endif
!
  if(nbh.gt.1)  then
       nbgma= nbh +1
       valdt= 1.
       valg1= int(t1 +0.01)
       nbpma=6
   endif
!
! *** cas des grandes periodes superieures a 8 heures
!
  if(nbh.gt.8)  then
       nbgma= nbh/2 +1
       valdt= 2.
       valg1= int(t1/2. +0.01)*2.
       nbpma=4
   endif
!
  if(nbh.gt.16) then
    nbgma=  nbh/3 +1
    valdt=  3.
    valg1=  int(t1/3. +0.01)*3
    nbpma=6
    endif
!
  if(nbh.gt.24) then
    nbgma=  nbh/6 +1
    valdt=  6.
    valg1=  int(t1/6. +0.01)*6.
    nbpma=6
    endif
!
  if(nbh.gt.48) then
    nbgma=  nbh/12 +1
    valdt=  12.
    valg1=  int(t1/12. +0.01)*12.
    nbpma=6
  endif
!
  if(nbh.gt.96) then
    nbgma=  nbh/24 +1
    valdt=  24.
    valg1=  int(t1/24. +0.01)*24.
    nbpma=6
  endif
!
! *** calcul des valeurs des graduations en heure decimale
!     on rajoute une marque si la premiere est hors cadre

  nbgma=nbgma+1

  do i=1,nbgma
  valgra(i)= valg1  +(i-1)*valdt
  enddo
!
! *** chargement du tableau des graduations en mode character
!
  do i= 1,  nbgma
!
  ih =  int(  valgra(i))
  im =  int( (valgra(i) -float(ih))*60. +0.001)
  is =  int( (valgra(i) -float(ih))*3600. -float(im)*60. +0.001)
!
  write(titgra(i),"(i2.2,':',i2.2,':',i2.2)")     ih,im,is
  if(is.eq.0) write(titgra(i),"(i2.2,':',i2.2)")  ih,im
  if(is.eq.0.and.im .eq. 0  ) write(titgra(i),"(i3.2)") ih
  enddo
!
  return
  END
!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
  subroutine dlabdisy(disy)
!
! --------------------------------------------------------------------+--
! #   define_label_distance_y in cm.
! --------------------------------------------------------------------+--
!
! ***   TBD ***
!
  common /labsiz/ tlax,tlay,dlxax,dlyay
!
! objet  : definit la   distance du label y a l'axe y
!
  dlyay=disy
!
  return
  END
!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
  subroutine plotpalhsbx(ox,oy,sx,sy,xmin,xmax,tgra)
!
! --------------------------------------------------------------------+--
! plot d'une palette HSB
! --------------------------------------------------------------------+--
!
  character*8 forx
!
! *** palette hsb avec cadre
!
  call  ppagcmah(ox,oy,sx,sy,1)
  call  ppagrec_(ox,oy,sx,sy)
!
! *** graduation de l'axe avec les bornes exactes
!
! *   calcul des intervalles des graduations
!
  call  cfiggra_(xmin,xmax,x1a,x2a,bgx,sgx,forx)
!
! *   definition de la figure incluse correspondant aux grad. rondes
!
  call  dfigori_(ox,oy)
  call  dfigsiz_(sx,sy)
  call  dfiglimx(xmin,xmax)
!
! *   trace des graduations
!
  call  dstipos_('o ','ii')
  call  dstisiz_(sy/5.,sy/10.)
  call  dgrasiz_(tgra,tgra)
  call  pfiggrax(x1a+bgx,bgx,sgx,forx)
!
  return
  END
!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
  subroutine calseuil(projet,experi,br,semin,semax,ired)
!
! --------------------------------------------------------------------+--
! calcul des seuils min et max adaptes a chaque projet
! --------------------------------------------------------------------+--
!
  character*(*) projet,experi,br
!
  semin= -10.
  semax=    3.
  ired  =  15
!
  if(projet(1:7).eq.'CLUSTER') then
      if(experi(1:5).eq.'STAFF') then
                if(br(1:3).eq.'HBR') then
                                         semin= -9.7
                                         ired   = 30
                                     else
                                         semin= -6.45
                endif
      endif
!
      if(experi(1:3).eq.'EFW') then
                               semin= -3.1
                               endif
!
      if(experi(1:3).eq.'FGM') then
                               semin= -5.0
                               endif
  endif
!
  if(projet(1:4).eq.'GEOS')   then
                              semin= -7.2
                              endif
!
  if(projet(1:6).eq.'STAMOB') then
                              semin= -7.2
                              endif
!
  call  cchalen_(projet,np)
  call  cchalen_(experi,ne)
!
  print *
  print 100, '  Seuils recommandes suivant la manip:'
  print 100, '  pour la manip ', projet(1:np),'/',experi(1:ne),'/',  &
                br(1:3),': seuils min et    max = ',semin,semax
  print 110, '  et il faudrait forcer la mire sur le rouge de ',ired,' %'
!
  100 format(7a,2f7.2)
  110 format(a,i3,a)
!
  return
  END
!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
  subroutine corrseuils(semin,semax,ired,smi,sma)
!
! --------------------------------------------------------------------+--
! correction des seuils pour meilleurs rendu de l'image
! --------------------------------------------------------------------+--
!
! *** limitation dans les normes admissibles
!
  if(smi.lt.semin)  smi=semin
  if(sma.gt.semax)  sma=semax
!
! *** decalage vers le rouge (car valeurs generalement peu nombreuses)
!
  dynam= sma-smi
  decal= dynam*float(ired)/100.
  sma=  sma-decal
!
! *** re-limitation dans les normes admissibles de sma
!
  if(sma.gt.semax)  sma=semax
!
  print*
  print*, 'Seuils min,  max cal. et corriges =',smi,sma
!
  return
  END
!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
  subroutine pfigrond(pox,poy,siz)

  call dfilzon_
  call pfigsym_(pox,poy,0,siz,siz,'dode')
  call pfilzon_

  return
  END
!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
  subroutine ppagarrf(xx,yy,ipos,bodyl,bodyw,headl,headw,angle)

  call dfilzon_
  call ppagarr_(xx,yy,ipos,bodyl,bodyw,headl,headw,angle)
  call pfilzon_

  return
  END
!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
  subroutine pfigarrf(xx,yy,ipos,bodyl,bodyw,headl,headw,angle)

  call dfilzon_
  call pfigarr_(xx,yy,ipos,bodyl,bodyw,headl,headw,angle)
  call pfilzon_

  return
  END
!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX