!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program spectro_to_polar

!----------------------------------------------------------------------!
! Object: Read a SP.rff file and compute polar.resu containg all polarisation parameters
! Author: P. Robert , LPP, 2011 Mar 07
!----------------------------------------------------------------------!

  use rff_param_def
  use rff_data_def

  implicit none

  character(len=255) :: SPL2_file,POL_file,t1,t2,fultit,projet,experi,sid,fnat,bitr,titpan
  integer            :: ifc1,ifc2,ierr1,ierr2,ierr3,idset,isat,nbp,i,j,nbspe
  integer            :: jd00,iyear,imon,iday,ih,im,is,ims,imc,nbfreq
  integer            :: nf1,nf2
  real (kind=4)      :: fc,f1,f2,fe,Ts,srasc,sdec,dtspe,dfspe,pisd
  real (kind=4)      :: ra,tetar,phiar
  real (kind=4)      :: a,b,rkx,rky,rkz,ax,ay,az,pha,rk,tetkr,phikr,ptota
  real (kind=8)      :: spin_period, sample_rate
  
  complex (kind=4), dimension(:),  allocatable :: sx,sy,sz
  real    (kind=4), dimension(:,:),allocatable :: ptot,exen,tetk,phik,teta,phia
  character(len=27),dimension(:)  ,allocatable :: datiso

  print*, '------------------------------------------------------------'
  print*, 'spectro_to_polar : read a RFF spectrogram and compute'
  print*, 'polarisation parameters'
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF spectrogram SPL2_file to read ? (ex: .../data/toto.rff)'
  read(*,'(a)') SPL2_file
  print*, trim(SPL2_file)

  ifc1=1

  print*, 'file name of polar results ? (ex: CLU2_POLAR_NBR_20010923.resu)'
  read(*,'(a)') POL_file
  print*, trim(POL_file)

  ifc2=2

! 1) Reading Metadata
!    ================

  write(*,*)
  write(*,*) 'READING METADATA...'
  write(*,*) '----------------'

! reading manda_param & optio_param only

  call rff_R_metadata(ifc1,SPL2_file)

  write(*,*) 'Done...'

! Retrieve usefull parameter

  nbspe=manda_param%BLOCK_NUMBER
  t1=manda_param%BLOCK_FIRST_INDEX
  t2=manda_param%BLOCK_LAST_INDEX

  if (manda_param%data_form /= 'Matrix' ) then
     write(*,*)
     write(*,'(a)') ' -> ERROR spectro_to_polar: DATA_FORM of INPUT FILE IS NOT Matrix***'
     write(*,'(a)') ' -> PROGRAM ABORTED !!!'
     print*, 'spectro_to_polar.exe            : *** ERROR !! Program aborted !'
     stop    'spectro_to_polar.exe            : *** ERROR !! Program aborted !'
     endif

  if (manda_param%file_class /= 'Spectrogram' ) then
     write(*,*)
     write(*,'(a)') ' -> ERROR spectro_to_polar: CLASS OF INPUT FILE IS NOT Spectrogram ***'
     write(*,'(a)') ' -> PROGRAM ABORTED !!!'
     print*, 'spectro_to_polar.exe            : *** ERROR !! Program aborted !'
     stop    'spectro_to_polar.exe            : *** ERROR !! Program aborted !'
     endif

  if (manda_param%data_dimension(1) /= 6 ) then
     write(*,*)
     write(*,'(a)') ' -> ERROR spectro_to_polar: data dimension OF INPUT FILE IS NOT 6 (3Re & 3Img)***'
     write(*,'(a)') ' -> PROGRAM ABORTED !!!'
     print*, 'spectro_to_polar.exe            : *** ERROR !! Program aborted !'
     stop    'spectro_to_polar.exe            : *** ERROR !! Program aborted !'
     endif

  nbfreq= manda_param%data_dimension(2)


  write(*,*)
  write(*,*) 'READING CONSTANT DATA...'
  write(*,*) '------------------------'

  call rff_R_const_data(ifc1)
  call rff_W_const_data(6)

  write(*,*) 'Done...'

! Retrieve usefull constant data

  sample_rate  =const_data%sample_rate
  spin_period  =const_data%spin_period

  if (manda_param%file_class /= 'Spectrogram' ) then
     write(*,*)
     write(*,'(a)') ' -> ERROR spectro_to_polar: CLASS OF INPUT FILE IS NOT Spectrogram ***'
     write(*,'(a)') ' -> PROGRAM ABORTED !!!'
     print*, 'spectro_to_polar.exe            : *** ERROR !! Program aborted !'
     stop    'spectro_to_polar.exe            : *** ERROR !! Program aborted !'
     endif

  write(*,*)
  write(*,*) 'READING INDEXED DATA...'
  write(*,*) '-----------------------'

  call rff_R_indexed_data(ifc1)
  call rff_R_tail(ifc1)

  close(ifc1)

  write(*,*) 'Done...'

  write(*,*)
  write(*,*) 'R_DATA_MATRIX(1,10,1)    =',R_DATA_MATRIX(1,10,1)
  write(*,*) 'R_DATA_MATRIX(1,10,nbspe)=',R_DATA_MATRIX(1,10,nbspe)


  write(*,*)
  write(*,*) 'COMPUTING POLARIZATION...'
  write(*,*) '-------------------------'

  allocate(sx(nbfreq),stat=ierr1)
  allocate(sy(nbfreq),stat=ierr1)
  allocate(sz(nbfreq),stat=ierr1)

  allocate(ptot(nbspe,nbfreq),stat=ierr2)
  allocate(exen(nbspe,nbfreq),stat=ierr2)
  allocate(tetk(nbspe,nbfreq),stat=ierr2)
  allocate(phik(nbspe,nbfreq),stat=ierr2)
  allocate(teta(nbspe,nbfreq),stat=ierr2)
  allocate(phia(nbspe,nbfreq),stat=ierr2)
  allocate(datiso(nbspe), stat=ierr3)

  pisd=acos(-1.)/180.

  do i=1,nbspe
      datiso(i)=data_index(i)
      do j=1,nbfreq
      
      sx(j)=cmplx(R_DATA_MATRIX(1,j,i), R_DATA_MATRIX(2,j,i))
      sy(j)=cmplx(R_DATA_MATRIX(3,j,i), R_DATA_MATRIX(4,j,i))
      sz(j)=cmplx(R_DATA_MATRIX(5,j,i), R_DATA_MATRIX(6,j,i))

      call cpolar(sx(j),sy(j),sz(j),ptota,a,b,rkx,rky,rkz,ax,ay,az,pha)

      ptot(i,j)=ptota
      if(a.lt.1.e-30) then
         exen(i,j)=0.
                      else
         exen(i,j)=1. -b/a
      endif

      call tcarsph2(rkx,rky,rkz,rk,tetkr,phikr)
      call tcarsph2( ax, ay, az,ra,tetar,phiar)

      tetk(i,j)=tetkr/pisd
      phik(i,j)=phikr/pisd
      teta(i,j)=tetar/pisd
      phia(i,j)=phiar/pisd

      if(phik(i,j).lt.0.) phik(i,j)=phik(i,j)+360.
      if(phia(i,j).lt.0.) phia(i,j)=phia(i,j)+360.
      enddo
  enddo

  write(*,*) 'Done...'
  print*, 'ptot(1,10)=',ptot(1,10)
  print*, 'ptot(nbspe,10)=',ptot(nbspe,10)

  write(*,*)
  write(*,*) 'CREATING COPOLAR.resu...'
  write(*,*) '------------------------'


!
! *** on recupere ici la partie du copolar des Roprocs V4
!     ===================================================

      open(ifc2,file=POL_file)
!
! *** ecriture de l'entete
!
      idset =0
      fultit=optio_param%TITLE
      projet=manda_param%MISSION_NAME
      experi=manda_param%EXPERIMENT_NAME
      sid   =manda_param%OBSERVATORY_NAME
      isat  =manda_param%OBSERVATORY_NUMBER
      fnat  =manda_param%DATA_LABEL
      titpan=optio_param%SUB_TITLE
      nbp   =nbfreq*2
      fc    =0.
      f1    =0.
      f2    =nbfreq*real(optio_param%FREQUENCY_RESOLUTION)
      bitr  =manda_param%EXPERIMENT_MODE
      fe    =real(const_data%SAMPLE_RATE)
      Ts    =real(spin_period)
      srasc =0.
      sdec  =0.

      call decode_datiso(data_index(1),iyear,imon,iday,ih,im,is,ims,imc)
      call cjd2000(iyear,imon,iday,jd00)

      call wricosfilhead(ifc2,idset,fultit,projet,experi,sid,isat,fnat, &
                       titpan,nbp, &
                       fc,f1,f2,nbspe,bitr,fe,Ts,srasc,sdec, &
                       jd00,iday,imon,iyear,ih,im,is,ims)
!
!
! *** ecriture des spectrogrammes
!
! *   on se limite a la partie non filtree des spectres
!     et on arondi au dessu de f2 pour la visu
!
      dtspe=real(optio_param%TIME_RESOLUTION)
      dfspe=real(optio_param%FREQUENCY_RESOLUTION)

      nf1= 2
      nf2=int(f2/dfspe +0.001) +3
      if(nf2.le.nf1) nf2=nf1+1
      if(nf2.gt.nbfreq) nf2= nbfreq
!
      print*
      print*, 'f1,f2=',f1,f2
      print*, 'nf1,nf2=',nf1,nf2
      print*, 'f1p,f2p=',float(nf1-1)*dfspe,float(nf2-1)*dfspe

      print*, 'nbspe,nbp,nbfreq=',nbspe,nbp,nbfreq
!
      call wri6spectro(ifc2,dtspe,dfspe,1,nbspe,nf1,nf2, datiso, &
                       ptot,exen,tetk,phik,teta,phia,nbspe,nbfreq)
!
! *** ecriture de l'eof
!
      write(ifc2,*) 'END OF FILE'
!
      close(ifc2)

      ! Deallocation

      deallocate(sx,stat=ierr1)
      deallocate(sy,stat=ierr1)
      deallocate(sz,stat=ierr1)

      deallocate(ptot,stat=ierr2)
      deallocate(exen,stat=ierr2)
      deallocate(tetk,stat=ierr2)
      deallocate(phik,stat=ierr2)
      deallocate(teta,stat=ierr2)
      deallocate(phia,stat=ierr2)
!
! *** termine
!
      print*
      print*, ('-',i=1,72)
      print*, 'Termine'
      print*, ('-',i=1,72)

      print*, "spectro_to_polar.exe             : NORMAL TERMINATION"
         stop "spectro_to_polar.exe             : NORMAL TERMINATION"
  end

!XXXXXXXX0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
! EXTERNAL SUBROUTINES
!
!XXXXXXXX0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
! BEGIN polarlib.f
!
!   ----------------------------------------------------------------
!   |                                                              |
!   |                      polarlib                                |
!   |                                                              |
!   | Bibliotheque de calcul de la polarisation d'une onde plane.  |
!   | Extrait des bibliotheques developpees pour le satellite GEOS |
!   | au CRPE en 1977-1980. Conversion succinte des .f en .f90     |
!   |                                                              |
!   |           P. Robert, CNRS/CETP, Novembre 2001                |
!   |                                                              |
!   ----------------------------------------------------------------
!
!XXXXXXXX0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine cpolar(sx,sy,sz,ptot,a,b,rkx,rky,rkz,ax,ay,az,phase)
!
!     ---------------------------------------------------------------+--
!     calcul de l'ellipse de polarisation d'une onde plane, a partir
!     de ses coefficients de Fourrier sur 3 axes orthogonaux.
!     input : complex sx,sy,sz
!     output: a,b        = axes de l'ellipse
!             rkx,rky,rkz= normale au plan de l'ellipse
!             ax ,ay ,az = direction du grand axe
!             phase      = phase absolue du champ le long de l'ellipse
!
!     P. Robert, CETP, Novembre 2001
!     ---------------------------------------------------------------+--
!
      complex sx,sy,sz
!
      real aii(3),fii(3),GXI(3),GZI(3)
!
!
! *** calcul des amplitudes et phase sur chaque composante
!
      call CALAIFI(sx,sy,sz,aii,fii)
!
! *** puissance totale
!
      ptot= 0.5*(aii(1)**2 +aii(2)**2 + aii(3)**2)
!
! *** calcul des parametres de l'ellipse
!
      call ELLIPSE(aii,fii,phase,a,b,EXC,GXI,GZI)
!
      rkx=GZI(1)
      rky=GZI(2)
      rkz=GZI(3)
!
      ax=GXI(1)
      ay=GXI(2)
      az=GXI(3)
!
      return
      end

!XXXXXXXX0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      SUBROUTINE CALAIFI(SX,SY,SZ,AII,FII)
!
      DIMENSION AII(3),FII(3)
      COMPLEX SX,SY,SZ
!
!     ******************************************************************
!
!     AUTEUR   : P. ROBERT CRPE-CNET, 1980  (revu Novembre 2001)
!     CATEGORIE: DEPOUILLEMENT SPECIFIQUE UBF/GEOS
!     OBJET    : CALCUL DES COEFFICIENTS AI ET FII DU PROGRAMME POLAR
!
!     ******************************************************************
!
!
      AII(1)= 2.*CABS(SX)
      AII(2)= 2.*CABS(SY)
      AII(3)= 2.*CABS(SZ)
!
      RR= REAL(SX)
      RI=AIMAG(SX)
      FII(1)=0.
      IF(ABS(RR).GT.1.E-30.OR.ABS(RI).GT.1.E-30) FII(1)=ATAN2(RI,RR)
!
      RR= REAL(SY)
      RI=AIMAG(SY)
      FII(2)=0.
      IF(ABS(RR).GT.1.E-30.OR.ABS(RI).GT.1.E-30) FII(2)=ATAN2(RI,RR)
!
      RR= REAL(SZ)
      RI=AIMAG(SZ)
      FII(3)=0.
      IF(ABS(RR).GT.1.E-30.OR.ABS(RI).GT.1.E-30) FII(3)=ATAN2(RI,RR)
!
      RETURN
      END

!XXXXXXXX0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      SUBROUTINE ELLIPSE(AII,FII,PHA,AA,BB,EXC,GXI,GZI)
!
      DIMENSION AII(3),FII(3),GXI(3),GZI(3)
      double precision SN, CN, dblePHA, dbleAA, dbleBB
!
!     ******************************************************************
!
!     AUTEUR   : P. ROBERT CRPE-CNET, 1980
!     CATEGORIE: TRAITEMENT DU SIGNAL
!     OBJET    : CALCUL D UNE ELLIPSE A PARTIR DE SES 3 PROJECTIONS
!
!     ******************************************************************
!
!      CALCUL DE L"ELLIPSE DE POLARISATION A PARTIR DE SES 3 PROJECTIONS
!      DONNEES PAR LE MODULE AII ET LA PHASE FII DE CHAQUE COMPOSANTE
!
!
!      CALCUL DE LA PHASE ABSOLUE
!
      SN=0.d0
      CN=0.d0
      dblePHA=0.d0
!
      DO 76 J=1,3
         SN=SN+(dble(AII(J))**2)*SIN(2.d0*dble(FII(J)))
         CN=CN+(dble(AII(J))**2)*COS(2.d0*dble(FII(J)))
   76 CONTINUE
      IF(DABS(SN).GT.1.D-30.AND.DABS(CN).GT.1.D-30) &
           dblePHA=DATAN2(SN,CN)/2.D0
!
!      CALCUL DU MODULE DU GRAND AXE, DU PETIT AXE ET EXENTRICITE
!
      dbleAA=1.D-30
      dbleBB=1.D-30
!
      DO 78 J=1,3
         dbleAA=dbleAA+(dble(AII(J))*DCOS(dblePHA-dble(FII(J))))**2
         dbleBB=dbleBB+(dble(AII(J))*DSIN(dblePHA-dble(FII(J))))**2
   78 CONTINUE
!
!      dbleAA=DSQRT(dbleAA)
!      dbleBB=DSQRT(dbleBB)
      EXC=sngl(dbleBB/dbleAA)
!
!      CALCUL DE LA DIRECTION DES AXES DE L"ELLIPSE
!
      DO 82 J=1,3
         GXI(J)=sngl(dble(AII(J))*DCOS(dblePHA-dble(FII(J)))/dbleAA)
   82 CONTINUE
!
      GZI(1)=sngl(dble(AII(2))*dble(AII(3))* &
           DSIN(dble(FII(2))-dble(FII(3)))/(dbleAA*dbleBB))
      GZI(2)=sngl(dble(AII(3))*dble(AII(1))* &
           DSIN(dble(FII(3))-dble(FII(1)))/(dbleAA*dbleBB))
      GZI(3)=sngl(dble(AII(1))*dble(AII(2))* &
           DSIN(dble(FII(1))-dble(FII(2)))/(dbleAA*dbleBB))
!
      PHA=sngl(dblePHA)
      AA=sngl(dbleAA)
      BB=sngl(dbleBB)

      RETURN
      END

!XXXXXXXX0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      SUBROUTINE POLAIR(V,VMOD,TET,PHI,ID)
!
      DIMENSION V(3)
!
!     ******************************************************************
!
!     AUTEUR   : P. ROBERT CRPE-CNET, 1980
!     CATEGORIE: ASTRONOMIE ET CHANGEMENT DE BASE
!     OBJET    : MODULE ET ANGLES POLAIRES D"UN VECTEUR CARTESIEN
!                SORTIE EN DEGRE SI ID=1
!
!     ******************************************************************
!
!
      EP=1.E-35
      VMOD=0.
      TET=0.
      PHI=0.
      IF(ABS(V(1)).LT.EP.AND.ABS(V(2)).LT.EP.AND.ABS(V(3)).LT.EP)RETURN
!
      VMOD=SQRT(V(1)**2+V(2)**2+V(3)**2)
      VPERP=SQRT(V(1)**2+V(2)**2)
      TET=ATAN2(VPERP,V(3))
      PHI=ATAN2(V(2),V(1))
      IF(ID.NE.1) RETURN
!
      TET=TET*180./3.1415927
      PHI=PHI*180./3.1415927
!
      RETURN
      END

!XXXXXXXX0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      subroutine tcarsph2(x,y,z,r,teta,phi)
!
! ----------------------------------------------------------------------
!
! *   Class  : transform modules of Rocotlib Software
! *   Object : transforms_car_to_sph: CAR -> SPH  system
! *   Author : P. Robert, CRPE, 1992
! *   Comment: none
!
! *   input  :   x,y,z      cartesian coordinates
! *   output :   r,teta,phi spherical coordinates (angles in radians)
!
! ----------------------------------------------------------------------
!
!
      if(abs(x) > 1.e16) x=sign(1.e16,x)
      if(abs(y) > 1.e16) y=sign(1.e16,y)
      if(abs(z) > 1.e16) z=sign(1.e16,z)

      sq=x**2 +y**2
      r=sqrt(sq+z**2)
!
      if(sq.gt.1.e-30) then
                   sq=sqrt(sq)
                   phi=atan2(y,x)
                   teta=atan2(sq,z)
                   return
                   endif

      phi=0.
      if (z.lt.0.) then
                   teta=3.141592654
                   else
                   teta=0.
                   endif
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
! END polarlib.f

! ---------------------

! BEGIN rwcospectrolib.f
!
!  ---------------------------------------------------------------------
!  |                                                                   |
!  |                      rwcospectrolib                               |
!  |                                                                   |
!  |  bibliotheque de gestions de i/o pour la creation et la relecture |
!  |  des fichiers de types cospectro.resu                             |
!  |                                                                   |
!  |  P. Robert, CETP, Janvier 2001                                    |
!  |                                                                   |
!  ---------------------------------------------------------------------
!
      subroutine wricosfilhead(ifc, &
                               idset,fultit,projet,experi,sid,isat,fnat, &
                               titpan,nbp,fc,f1,f2, &
                               nbcol,br,fe,Ts,srasc,sdec, &
                               jul0,jj0,mm0,ian0,ih0,im0,is0,ims0)
!
!     ------------------------------------------------------------------
! *   Objet  : ecriture sur fichier cospectro.resu du header du fichier
! *   Classe : depouillement specifique Roproc_Wave
! *   Auteur : P. Robert, CETP, Janvier 2001
!     ------------------------------------------------------------------
!
      character*(*) fultit,projet,experi,sid,titpan,br,fnat
!
      print*, 'write cospectro file header...'
!
      call strlen(fultit,nful)
      call strlen(projet,npro)
      call strlen(experi,nexpe)
      call strlen(sid,nsid)
      call strlen(fnat,nfnat)
      call strlen(titpan,ntitp)
      call strlen(br,nbr)
!
      write(ifc,100) 'START OF FILE HEADER'
      write(ifc,600)
      write(ifc,100) ('-',i=1,72)
      write(ifc,100) 'Roproc Data Set Number:'
      write(ifc,400)  idset
      write(ifc,100) 'Full Title:'
      write(ifc,100)  fultit(1:nful)
      write(ifc,100) 'Project:'
      write(ifc,100)  projet(1:npro)
      write(ifc,100) 'Experiment:'
      write(ifc,100)  experi(1:nexpe)
      write(ifc,100) 'Spacecraft ID:'
      write(ifc,100)  sid(1:nsid)
      write(ifc,100) 'Spacecraft number:'
      write(ifc,400)  isat
      write(ifc,100) 'Field Nature:'
      write(ifc,100)  fnat(1:nfnat)
!
      write(ifc,100) 'Coordinate system of input data:'
      write(ifc,100)  titpan(1:ntitp)
!
      write(ifc,100) 'Number of points of windows:'
      write(ifc,200)  nbp
      write(ifc,100) 'Frequency cut-off for the calibration:'
      write(ifc,500)  fc
      write(ifc,100) 'Frequency bouds for the filtering in fixed system:'
      write(ifc,500)  f1 ,f2
      write(ifc,100) 'Number of windows:'
      write(ifc,200)  nbcol
      write(ifc,100) 'Bit Rate:'
      write(ifc,100)  br(1:nbr)
      write(ifc,100) 'Sampled Frequency:'
      write(ifc,500)  fe
      write(ifc,100) 'Spin Period:'
      write(ifc,500)  Ts
      write(ifc,100) 'R. Asc. and Dec. of Spin axis in GEI:'
      write(ifc,500)  srasc,sdec
!

      write(ifc,100) 'Starting date (njul50,iday,imonth,iyear):'
      write(ifc,200) jul0,jj0,mm0,ian0
      write(ifc,100) 'Starting Time (ih, im, is, ims):'
      write(ifc,300) ih0,im0,is0,ims0
      write(ifc,100) 'END OF FILE HEADER'
!
  100 format(72a)
  200 format(i6,2i3,i5)
  300 format(3i3,i4)
  400 format(5i3)
  500 format(3e14.5)
  600 format('START COMMENTS',/, &
      'File type cospectro.resu: Result of cospectro or copolar.exe',/, &
      'The cospectro.resu files is a file containing images of' &
      ,' spectrograms, ',/, &
      'and possibly other data such as DC magnetic field', &
      ' deduced from STAFF ',/, &
      'calibration. The input data has been taken from a caliXXX.resu', &
       ' file, ',/, &
      'issued itself from  the caliXXX.exe calibration program.',/, &
      'File is structured as:',/, &
      '  . File Header, including comments and fixed data,',/, &
      '  . spectrograms and possibly curves data.',/, &
      'Author: Patrick ROBERT, CETP, 1996-2000.      revision', &
      ' January   2001.',/, &
      '                                              revision', &
      ' August    2002.',/, &
      '                                              revision', &
      ' February  2002.',/, &
      '                                         Last revision', &
      ' February  2003.' &
      ,/,'END COMMENTS')

      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      subroutine wri6spectro(ifc,dtspe,dfspe,ns1,ns2,nf1,nf2,datiso, &
                       ptot,exen,tetk,phik,teta,phia,Nxulf,nbpf)
!
!     ------------------------------------------------------------------
! *   Objet  : ecriture sur fichier cospectro.resu des 3 spectres
! *   Classe : depouillement specifique Roproc_Wave
! *   Auteur : P. Robert, CETP, Janvier 2001
!     ------------------------------------------------------------------
!
      real ptot(Nxulf,nbpf), exen(Nxulf,nbpf)
      real tetk(Nxulf,nbpf), phik(Nxulf,nbpf)
      real teta(Nxulf,nbpf), phia(Nxulf,nbpf)
      
      character*27 datiso(Nxulf)
!
!
      nft  = nf2 -nf1 +1
      nbcol= ns2 -ns1 +1
!
! *** ecriture du spectrogramme de la puissance totale
!
      write(ifc,100) ('-',i=1,72)
      write(ifc,*) 'DATA 1:'
      write(ifc,*) 'Spectrogram of Total Power'
      write(ifc,*) 'Title:'
      write(ifc,*) 'Total Power'
      write(ifc,*) 'dt, df:'
      write(ifc,*) dtspe,dfspe
      write(ifc,*) 'nt, nf:'
      write(ifc,*) nbcol, nft
      write(ifc,*) 'Spectrogram data:'
   do i=ns1,ns2
      write(ifc,100) datiso(i)
      do j=nf1,nf2
      write(ifc,500) ptot(i,j)
      enddo
   enddo
!
! *** ecriture du spectrogramme de l'exentricite
!
      write(ifc,100) ('-',i=1,72)
      write(ifc,*) 'DATA 2:'
      write(ifc,*) 'Spectrogram of Exentricity'
      write(ifc,*) 'Title:'
      write(ifc,*) 'Exentricity'
      write(ifc,*) 'dt, df:'
      write(ifc,*) dtspe,dfspe
      write(ifc,*) 'nt, nf:'
      write(ifc,*) nbcol, nft
      write(ifc,*) 'Spectrogram data:'
   do i=ns1,ns2
      write(ifc,100) datiso(i)
      do j=nf1,nf2
      write(ifc,500) exen(i,j)
      enddo
   enddo      
!
! *** ecriture du spectrogramme de teta K
!
      write(ifc,100) ('-',i=1,72)
      write(ifc,*) 'DATA 3:'
      write(ifc,*) 'Spectrogram of Teta K direction (degres)'
      write(ifc,*) 'Title:'
      write(ifc,*) 'Theta K (d.)'
      write(ifc,*) 'dt, df:'
      write(ifc,*) dtspe,dfspe
      write(ifc,*) 'nt, nf:'
      write(ifc,*) nbcol, nft
      write(ifc,*) 'Spectrogram data:'
   do i=ns1,ns2
      write(ifc,100) datiso(i)
      do j=nf1,nf2
      write(ifc,500) tetk(i,j)
      enddo
   enddo 
!
! *** ecriture du spectrogramme de phi K
!
      write(ifc,100) ('-',i=1,72)
      write(ifc,*) 'DATA 4:'
      write(ifc,*) 'Spectrogram of Phi K direction (degres)'
      write(ifc,*) 'Title:'
      write(ifc,*) 'Phi K (d.)'
      write(ifc,*) 'dt, df:'
      write(ifc,*) dtspe,dfspe
      write(ifc,*) 'nt, nf:'
      write(ifc,*) nbcol, nft
      write(ifc,*) 'Spectrogram data:'
   do i=ns1,ns2
      write(ifc,100) datiso(i)
      do j=nf1,nf2
      write(ifc,500) phik(i,j)
      enddo
   enddo       
!
! *** ecriture du spectrogramme de teta du grand axe
!
      write(ifc,100) ('-',i=1,72)
      write(ifc,*) 'DATA 5:'
      write(ifc,*) 'Spectrogram of Teta Major Axis direction (degres)'
      write(ifc,*) 'Title:'
      write(ifc,*) 'Theta Major Axis (d.)'
      write(ifc,*) 'dt, df:'
      write(ifc,*) dtspe,dfspe
      write(ifc,*) 'nt, nf:'
      write(ifc,*) nbcol, nft
      write(ifc,*) 'Spectrogram data:'
   do i=ns1,ns2
      write(ifc,100) datiso(i)
      do j=nf1,nf2
      write(ifc,500) teta(i,j)
      enddo
   enddo 
!
! *** ecriture du spectrogramme de phi du grand axe
!
      write(ifc,100) ('-',i=1,72)
      write(ifc,*) 'DATA 6:'
      write(ifc,*) 'Spectrogram of Phi Major Axis direction (degres)'
      write(ifc,*) 'Title:'
      write(ifc,*) 'Phi Major Axis (d.)'
      write(ifc,*) 'dt, df:'
      write(ifc,*) dtspe,dfspe
      write(ifc,*) 'nt, nf:'
      write(ifc,*) nbcol, nft
      write(ifc,*) 'Spectrogram data:'
   do i=ns1,ns2
      write(ifc,100) datiso(i)
      do j=nf1,nf2
      write(ifc,500) phia(i,j)
      enddo
   enddo 
!
  100 format(72a)
  500 format(e15.7)
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
      subroutine strlen(str,nc)
!
!     ------------------------------------------------------------------
! *   Objet  : calcul de la longueur utile  d'une chaine de caracteres
! *   Classe : depouillement specifique Roproc
! *   Auteur : P. Robert, CETP, 1998
!     ------------------------------------------------------------------
!
      character*(*) str
!
!                    *********************
!
      nbc=len(str)
!
! *** nc= longueur au de la de laquelle il n'y a que des blancs
!         (mais la chaine 1:nc peu contenir des blancs)
!
      do 10 i=1,nbc
      ii=nbc-i+1
      if(str(ii:ii).ne.' ') go to 12
   10 continue
      ii=0
   12 continue
      nc=ii
!
      return
      end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
