      program test_kepler_lib

!     ***************************************************************0**
!     calcul de la trajectoire de la terre autour du soleil.
!     Permet de verifier la kepler_lib.
!     P. Robert, CRPE, ~1985, revu LPP novembre 2010
!     ***************************************************************0**

      real(kind=8)      :: a,b,c,e,r,an !,rper,rapo
!     character(len=27) :: datisocur,datisoper,datisoapo


      print*
      print*, '-----------------------------------------------------'
      print*, 'calcul de la trajectoire de la terre autour du soleil'
      print*, '-----------------------------------------------------'

!     masse du Soleil (kg)
      GM=1.9891e30
      GM=1.98892e30

!     demi grand axe de l'orbite Terrestre (km) :
      a=149597887.5d0
!     excentricite :
      e=0.01671022d0

      c=e*a
      b=sqrt(a*a -c*c)

      print*
      print*, 'Constantes d''entree:'
      print*, '--------------------'
      print*
      print*, 'Sm=',GM,' kg'
      print*, 'e=',e
      print*, 'a=',a,' km'
      print*
      print*, 'Constantes deduites:'
      print*
      print*, 'b=',b,' km'
      print*, 'c=',c, 'km'
      print*
      print*, 'apogee =',a+c
      print*, 'perigee=',a-c

      print*, 'soit:'
      print*
      print*, 'Size and exentricity of the ellipse'
      print*, '-----------------------------------'
      print*
      print*, 'a=',a,' km'
      print*, 'b=',b,' km'
      print*, 'c=',c, 'km'
      print*, 'e=',e

      an= 365.25696d0
      print*
      print*, 'duree prevue de l''orbite:',an

      print*
      print*, 'Resultats des calculs:'
      print*, '----------------------'

!     calcul de la periode de rotation de la Terre (s)

      call co_period(a, GM, GT)

      GTj= GT/(24.*3600.)
      GTh= GT/3600.

      print*
      print*,'revolution period in sec. : ',GT
      print*,'revolution period in hours: ',GTh
      print*,'revolution period in days : ',GTj

!     calcul des temps de passage  aux sommets de l'ellipse
!     (perigee=0, apogee= GT/2, et sommets secondaires a pour AE=0)

      call co_apex_time(GTh,e, Tapex)

      Tapex2=GTh-Tapex
      print*
      print*, 'time from perigee to get first  apex (hours) :',Tapex
      print*, '                         apogee      (hours) :',GTh/2.
      print*, '                         second apex (hours) :',Tapex2

!     position par rapport a la Terre, dans le repere de l'ellipse
!     au cours du temps; on a choisi les temps correspondants
!     aux apex (sommets secondaires de l'ellipse) pour retrouver
!     les perigee, apogee et grand axe de l'ellipse.

      print*
      print*, 'S/C position along one revolution:'
      print*, 'hour from perigee, Anomalie Exc., distance radiale, Anom. vraie'

      do it=0,4
         select case(it)
           case(0) ; hour=  0.
           case(1) ; hour= Tapex
           case(2) ; hour= GTh/2.
           case(3) ; hour= Tapex2
           case(4) ; hour= GTh
         end select

!        calcul de l'anomalie excentrique par resolution de l'equation
!        de Kepler

         call co_anom_excen(e,hour,GTh,AE)

!        calcul de l'anomalie vraie donnant la position angulaire
!        depuis le foyer (le Soleil)

         call co_anom_vraie(AE,e,a,AV,r)

         pisd=acos(-1.)/180.
         print*, hour, AE/pisd,r,AV/pisd
      enddo

      print*
      print*, 'remainder: perigee:',a-c
      print*, '           a      :',a
      print*, '           apogee :',a+c
      print*, '           perigee:',a-c
      print*, '           a,b,c,e:',a,b,c,e
      print*
      print*, 'Time has been chosed to correspond to the summit of the ellipse,'
      print*, 'to check that one find again perigee, a, apogee,a, and perigee'
      print*, '-----------------------------------------------------'


      print*, 'test_kepler_lib .exe             : NORMAL TERMINATION'
         stop 'test_kepler_lib .exe             : NORMAL TERMINATION'
      end

!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

