!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program vectime_to_mfa

!----------------------------------------------------------------------!
! Object: transform a VecTime VTL2 in GSE system into mfa system
! Author: P. Robert , ScientiDev, Oct. 2020, rev. Jan 2021
!----------------------------------------------------------------------!
  use rff_param_def
  use rff_data_def

  implicit none

  integer            :: i,j1,k1,k2,ifc,i1,i2, icomp1,icomp2,ierr
  integer            :: iyear,imon,iday,ih,im,is,ims,imc,nbloc1,nbloc2,nmfa

  character(len=255) :: VTL2_ULF, VTL2_mfa,VTL2_MAG,com,fullform
  character(len=120) :: credate,repere1,repere2
  character(len= 27) :: di1,di2,di1mag,di2mag,di1ulf,di2ulf
  character(len=3)   :: suff

  real(kind=4)       :: valxyz(3)
  real(kind=4)       :: xmfa,ymfa,zmfa, xgse,ygse,zgse

  
  character(len=27), dimension(:),   allocatable :: datiso_mag
  real(kind=4),      dimension(:,:), allocatable :: vectim_mag

  TYPE(Mandatory_param) :: manda_param1
  TYPE(Optional_param)  :: optio_param1
  TYPE(Constant_data)   :: const_data1


  print*, '------------------------------------------------------------'
  print*, 'vectime_to_mfa : transform a VecTime file in gse '
  print*, '                  system into MFA system'
  print*, '        MFA : Sun direction in (X,Z) plane'
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF ULF VTL2 file to read ? (ex: toto_GSE.rff)'
  read(*,'(a)') VTL2_ULF
  print*, trim(VTL2_ULF)

  print*, 'RFF ULF VTL2 file to write ? (ex: toto_MFA.rff)'
  read(*,'(a)') VTL2_MFA
  print*, trim(VTL2_MFA)
  
  print*, 'RFF MAG file to make transformation ? (ex: MAG_GSE.rff)'
  read(*,'(a)') VTL2_MAG
  print*, trim(VTL2_MAG)
  
  i=len(trim(VTL2_MFA))
  suff=VTL2_MFA(i-2:i)

  if(suff /= 'rff') then
     print*, ' ***file to write has not .rff suffix'
     stop 'vectime_to_mfa.exe              : *** ERROR !! Program aborted !'
  ENDIF

!    ==================
! 1) read  MAG RFF file first...
!    ==================

  print*, '=================================='
  print*, '1) read  MAG RFF file first...'
  print*, '=================================='

  ifc=1
  call rff_R_metadata(ifc,VTL2_MAG)

  call rff_R_const_data(ifc)
  call rff_R_indexed_data(ifc)
  call rff_R_tail(ifc)

  manda_param1=manda_param
  optio_param1=optio_param
  const_data1 =const_data

  print*, "check metadata"

  IF(manda_param%FILE_CLASS /= 'VecTime') THEN
         write(*,*) '*** Only VecTime FILE_CLASS is allowed'
         stop 'vectime_to_mfa.exe              : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_TYPE /= 'FLT') THEN
         write(*,*) '*** Only FLT DATA_TYPE is allowed'
         stop 'vectime_to_mfa.exe              : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%INDEX_UNITS /= 'ISO_TIME') THEN
         write(*,*) '*** Only ISO_TIME INDEX_UNITS is allowed'
         stop 'vectime_to_mfa.exe              : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_FORM /= 'Vector') THEN
         write(*,*) '*** Only Vector DATA_FORM is allowed'
         stop 'vectime_to_mfa.exe              : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_REPRESENTATION /= 'xyz Cartesian') THEN
         write(*,*) '*** Only Vector DATA_REPRESENTATION is allowed'
         stop 'vectime_to_mfa.exe              : *** ERROR !! Program aborted !'
  ENDIF

  repere1=manda_param%DATA_COORDINATE_SYSTEM

   IF(repere1 /= 'GSE') THEN
         write(*,*) '*** Only GSE DATA_COORDINATE_SYSTEM is allowed'
         stop 'vectime_to_mfa.exe              : *** ERROR !! Program aborted !'
  ENDIF


  print*, "OK"

  nbloc1=manda_param%block_number

  di1mag=data_index(1)
  di2mag=data_index(nbloc1)

  write(*,*) 'MAG: number of blocks =',nbloc1
  write(*,*) 'MAG: data_index(    1)=',di1mag
  write(*,*) 'MAG: data_index(nbloc)=',di2mag

! sauvegarde des donnees MAG
! --------------------------


  allocate(vectim_mag(3,nbloc1),stat=ierr)
  allocate(datiso_mag(nbloc1),stat=ierr)

  do i=1,nbloc1
     datiso_mag(i)=data_index(i)
     vectim_mag(1,i)=R_data_vector(1,i)
     vectim_mag(2,i)=R_data_vector(2,i)
     vectim_mag(3,i)=R_data_vector(3,i)     
  enddo


!    ==================
! 1) read  ULF RFF file
!    ==================

  print*
  print*, '=================================='
  print*, '2) read  ULF RFF file '
  print*, '=================================='


  ifc=2
  call rff_R_metadata(ifc,VTL2_ULF)

  call rff_R_const_data(ifc)
  call rff_R_indexed_data(ifc)
  call rff_R_tail(ifc)

  print*, "check metadata"

  IF(manda_param%FILE_CLASS /= 'VecTime') THEN
         write(*,*) '*** Only VecTime FILE_CLASS is allowed'
         stop 'vectime_to_mfa.exe              : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_TYPE /= 'FLT') THEN
         write(*,*) '*** Only FLT DATA_TYPE is allowed'
         stop 'vectime_to_mfa.exe              : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%INDEX_UNITS /= 'ISO_TIME') THEN
         write(*,*) '*** Only ISO_TIME INDEX_UNITS is allowed'
         stop 'vectime_to_mfa.exe              : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_FORM /= 'Vector') THEN
         write(*,*) '*** Only Vector DATA_FORM is allowed'
         stop 'vectime_to_mfa.exe              : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_REPRESENTATION /= 'xyz Cartesian') THEN
         write(*,*) '*** Only Vector DATA_REPRESENTATION is allowed'
         stop 'vectime_to_mfa.exe              : *** ERROR !! Program aborted !'
  ENDIF

  repere2=manda_param%DATA_COORDINATE_SYSTEM

  IF(repere2 /= 'GSE') THEN
         write(*,*) '*** Only GSE DATA_COORDINATE_SYSTEM is allowed'
         stop 'vectime_to_mfa.exe              : *** ERROR !! Program aborted !'
  ENDIF

  IF(repere1 /= repere2) THEN
        write(*,*) '*** ULF and MAG are not in the same COORDINATE_SYSTEM '
         stop 'vectime_to_mfa.exe              : *** ERROR !! Program aborted !'
  ENDIF 
  
  print*, "OK"

  nbloc2=manda_param%block_number


  di1ulf=data_index(1)
  di2ulf=data_index(nbloc2)

  write(*,*)
  write(*,*) 'ULF: number of blocks =',nbloc2
  write(*,*) 'ULF: data_index(    1)=',di1ulf
  write(*,*) 'ULF: data_index(nbloc)=',di2ulf

  write(*,*)
  write(*,*) 'MAG: number of blocks =',nbloc1
  write(*,*) 'MAG: data_index(    1)=',di1mag
  write(*,*) 'MAG: data_index(nbloc)=',di2mag
  write(*,*)

! check data are at the same time
! -------------------------------

  call compare_datiso(di1ulf,di1mag,  icomp1)
  call compare_datiso(di2ulf,di2mag,  icomp2)

  if(icomp1 .gt. 0 .OR. icomp2 .le. 0) then
     print*, 'no enough mag data, file mfa will be not complete'
  endif

  if(icomp1 .ge. 0) then 
                       di1=di1mag
                       else
                       di1=di1ulf
  endif

  if(icomp2 .le. 0) then
                       di2=di2mag
                       else
                       di2=di2ulf
  endif

  print*, 'time period will be ',di1,'  to  ',di2

! reperage des indices ULF correspondant a di1 et di2

  do i=1,nbloc2 
  
     call compare_datiso(data_index(i),di1,  icomp1)
     
     if(icomp1 .le. 0) then
                       i1=i
                       exit
     endif
  enddo
  
  do i=i1,nbloc2
  
     call compare_datiso(data_index(i),di2,  icomp2)
  
     if(icomp2 .le. 0) then 
                       i2=i-1
                       exit
     endif
  enddo


! data transformation
! -------------------
  write(*,*)
  write(*,*) 'transformation between i1=',i1, '  and i2=',i2

  k1=0
  k2=0
  j1=1
  valxyz=0.

  
  DO i=i1,i2

!    Rocotlib time dependant matrix computation
     call decode_datiso(data_index(i),iyear,imon,iday,ih,im,is,ims,imc)
     call ctimpar(iyear,imon,iday,ih,im,is)

     xgse=R_data_vector(1,i)
     ygse=R_data_vector(2,i)
     zgse=R_data_vector(3,i)

!    calcul de la valeur du magnetometre interpolee au temps ULF data_index(i)

     call get_interpol_value(data_index(i),datiso_mag,vectim_mag,nbloc1,j1,valxyz,k1,k2,ierr)
     j1=max(k1,1)

     call t_gse_to_mfa(xgse,ygse,zgse,valxyz(1),valxyz(2),valxyz(3),xmfa,ymfa,zmfa)
     
!    data update in mfa

     R_data_vector(1,i)=xmfa
     R_data_vector(2,i)=ymfa
     R_data_vector(3,i)=zmfa

  ENDDO
  
  nmfa= i2-i1 +1

  print*, 'transformation done.'

  manda_param%DATA_COORDINATE_SYSTEM='MFA'
  manda_param%DATA_DIMENSION(1)     = 3
  manda_param%DATA_FORMAT           = '(E13.6,",",E13.6,",",E13.6)'
  manda_param%BLOCK_FIRST_INDEX=data_index(i1)
  manda_param%BLOCK_LAST_INDEX=data_index(i2)

  com=manda_param%DATA_UNITS(1:3)//' in MFA system'

  optio_param%SUB_TITLE=trim(com)
  manda_param%block_number=nmfa


  print*, 'Update history field'

  call gdatiso(credate)
  call rff_update_history(credate,'RPC_vectime_to_mfa')

  print*,'Write RFF file'

  ifc=2
  call rff_W_metadata(ifc,VTL2_mfa)
  call rff_W_const_data(ifc)

! ***  call rff_W_indexed_data(ifc)

  IF(manda_param%INDEX_EXTENSION_LENGTH == 0) THEN
        fullform='(a27,3(1x,E14.6))'
     ELSE
        fullform= '('//TRIM(manda_param%INDEX_FORMAT)//',",",'// &
        TRIM(manda_param%INDEX_EXTENSION_FORMAT)//',",",'// &
        TRIM(manda_param%DATA_FORMAT)//')'
  ENDIF

  write(*,*) ' block data format=',trim(fullform)

  write(ifc,'(80a)')  '#',('-',i=1,79)
  write(ifc,'(a)')  'START INDEXED_DATA'

  write(*,*) 'write indexed data, i1,i2=',i1,i2

  DO i=i1, i2
     IF(manda_param%INDEX_EXTENSION_LENGTH == 0) THEN
           write(ifc,fullform) data_index(i),R_data_vector(1,i), R_data_vector(2,i), R_data_vector(3,i)
        ELSE
           write(ifc,fullform) data_index(i),status(i),phase(i), &
           R_data_vector(1,i), R_data_vector(2,i), R_data_vector(3,i)
     ENDIF
  ENDDO

  call rff_W_tail(ifc)


! *** termine

  print*
  print*, ('-',i=1,72)
  print*, 'Termine'
  print*, ('-',i=1,72)

  print*, 'vectime_to_mfa.exe               : NORMAL TERMINATION'
     stop 'vectime_to_mfa.exe               : NORMAL TERMINATION'
  end

!XXXXXXXX0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
