!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program vectime_to_mva

!----------------------------------------------------------------------!
! Object: transform a VecTime VTL2 in any system into MVA system
! Author: P. Robert , ScientiDev, Oct. 2020, rev. Jan 2021
!----------------------------------------------------------------------!
  use rff_param_def
  use rff_data_def

  implicit none


  integer            :: nbloc, i, ifc, nc,nr

  character(len=255) :: VTL2_ULF, VTL2_mva,com,fullform
  character(len=120) :: credate,rep
  character(len=3)   :: suff

  real(kind=4)       :: covar(3,3),lambda(3),eigvec(3,3)


  print*, '------------------------------------------------------------'
  print*, 'vectime_to_mva : transform a VecTime file in any system '
  print*, '                   into MVA system'
  print*, '        MVA : Minimum Variance Analysis'
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF ULF VTL2 file to read ? (ex: toto_GSE.rff)'
  read(*,'(a)') VTL2_ULF
  print*, trim(VTL2_ULF)

  print*, 'RFF ULF VTL2 file to write ? (ex: toto_MVA.rff)'
  read(*,'(a)') VTL2_MVA
  print*, trim(VTL2_MVA)

  i=len(trim(VTL2_MVA))
  suff=VTL2_MVA(i-2:i)

  if(suff /= 'rff') then
     print*, ' ***file to write has not .rff suffix'
     stop 'vectime_to_mva.exe              : *** ERROR !! Program aborted !'
  ENDIF



  print*
  print*, '=================================='
  print*, '1) read  ULF RFF file '
  print*, '=================================='


  ifc=1
  call rff_R_metadata(ifc,VTL2_ULF)

  call rff_R_const_data(ifc)
  call rff_R_indexed_data(ifc)
  call rff_R_tail(ifc)

  print*, "check metadata"

  IF(manda_param%FILE_CLASS /= 'VecTime') THEN
         write(*,*) '*** Only VecTime FILE_CLASS is allowed'
         stop 'vectime_to_mva.exe              : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_TYPE /= 'FLT') THEN
         write(*,*) '*** Only FLT DATA_TYPE is allowed'
         stop 'vectime_to_mva.exe              : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%INDEX_UNITS /= 'ISO_TIME') THEN
         write(*,*) '*** Only ISO_TIME INDEX_UNITS is allowed'
         stop 'vectime_to_mva.exe              : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_FORM /= 'Vector') THEN
         write(*,*) '*** Only Vector DATA_FORM is allowed'
         stop 'vectime_to_mva.exe              : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_REPRESENTATION /= 'xyz Cartesian') THEN
         write(*,*) '*** Only Vector DATA_REPRESENTATION is allowed'
         stop 'vectime_to_mva.exe              : *** ERROR !! Program aborted !'
  ENDIF


  print*, "OK"

  nbloc=manda_param%block_number

  write(*,*)
  write(*,*) 'ULF: number of blocks =',nbloc
  write(*,*) 'ULF: data_index(    1)=',data_index(1)
  write(*,*) 'ULF: data_index(nbloc)=',data_index(nbloc)
  write(*,*)


! data transformation
! -------------------

  open(7,file='mat_cp_varmin.resu')
  call mat_cp_varmin(7,R_data_vector(1,:),R_data_vector(2,:),R_data_vector(3,:), &
                     nbloc,1,covar,lambda,eigvec)
  close(7)

  rep=manda_param%DATA_COORDINATE_SYSTEM
  manda_param%DATA_COORDINATE_SYSTEM='MVA'
  manda_param%DATA_DIMENSION(1)     = 3
  manda_param%DATA_FORMAT           = '(E13.6,",",E13.6,",",E13.6)'
  manda_param%BLOCK_FIRST_INDEX=data_index(1)
  manda_param%BLOCK_LAST_INDEX=data_index(nbloc)

  com=optio_param%SUB_TITLE
  nc=len(optio_param%SUB_TITLE)

  i=index(com, trim(rep))
  if(i > 0) then
            nr=len_trim(rep)
            com=com(1:i-1)//'MVA'//com(i+nr:nc)
            else
            com=trim(com)//'-MVA system'
  endif

  optio_param%SUB_TITLE=com(1:nc)


! Update history field
! --------------------

  call gdatiso(credate)
  call rff_update_history(credate,'RPC_vectime_to_mva')

! Write RFF file
! --------------

  ifc=2
  call rff_W_metadata(ifc,VTL2_mva)
  call rff_W_const_data(ifc)

! ***  call rff_W_indexed_data(ifc)

  IF(manda_param%INDEX_EXTENSION_LENGTH == 0) THEN
        fullform='(a27,3(1x,E14.6))'
     ELSE
        fullform= '('//TRIM(manda_param%INDEX_FORMAT)//',",",'// &
        TRIM(manda_param%INDEX_EXTENSION_FORMAT)//',",",'// &
        TRIM(manda_param%DATA_FORMAT)//')'
  ENDIF

  write(*,*) ' block data format=',trim(fullform)

  write(ifc,'(80a)')  '#',('-',i=1,79)
  write(ifc,'(a)')  'START INDEXED_DATA'

  write(*,*) 'write indexed data...'

  DO i=1,nbloc
     IF(manda_param%INDEX_EXTENSION_LENGTH == 0) THEN
           write(ifc,fullform) data_index(i),R_data_vector(1,i), R_data_vector(2,i), R_data_vector(3,i)
        ELSE
           write(ifc,fullform) data_index(i),status(i),phase(i), &
           R_data_vector(1,i), R_data_vector(2,i), R_data_vector(3,i)
     ENDIF
  ENDDO

  call rff_W_tail(ifc)


! *** termine

  print*
  print*, ('-',i=1,72)
  print*, 'Termine'
  print*, ('-',i=1,72)

  print*, 'vectime_to_mva.exe               : NORMAL TERMINATION'
     stop 'vectime_to_mva.exe               : NORMAL TERMINATION'
  end

!XXXXXXXX0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
