!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program vectime_vdh_to_srv_GEOMAG

!----------------------------------------------------------------------!
! Object: create RFF file of GEOS/S331 in SRV system (as S300)
! Author: P. Robert , ScientiDev, Oct 2020
!----------------------------------------------------------------------!

  use rff_param_def
  use rff_data_def

  implicit none

  character(len=255) :: file1, file2
  character(len=120) :: credate,ex_index_fmt
  character(len=3)   :: suff
  integer            :: i
  integer, dimension(2):: data_dim
  integer :: nbvec, iano, LSF
  real :: spin_freq,E1,E2,E3
  real :: x,y,z,s,r,v


  print*, '------------------------------------------------------------'
  print*, 'vectime_vdh_to_srv_GEOMAG : Transform MAG in VDH to MAG in SRV'
  print*, '------------------------------------------------------------'
  print*

  print*, 'GEOMAG  RFF file to read ? (ex: .../data/toto.rff)'
  read(*,'(a)') file1
  print*, trim(file1)

  print*, 'GEOMAG  RFF file to write ? (ex: .../data/toto_srv.rff)'
  read(*,'(a)') file2
  print*, trim(file2)

  i=len(trim(file1))
  suff=file1(i-2:i)

  if(suff /= 'rff') then
     print*, ' ***file1 has not .rff suffix'
     stop 'vectime_vdh_to_srv_GEOMAG.exe   : *** ERROR !! Program aborted !'
  ENDIF

  i=len(trim(file2))
  suff=file2(i-2:i)

  if(suff /= 'rff') then
     print*, ' ***file2 has not .rff suffix'
     stop 'vectime_vdh_to_srv_GEOMAG.exe   : *** ERROR !! Program aborted !'
  ENDIF

! read  RFF files
! --------------

  call print_date_time('Reading MAG Meta-data')

  call rff_R_metadata(1,file1)
  call rff_R_const_data(1)

! Tests

  IF(manda_param%FILE_CLASS /= 'VecTime') THEN
     print*, ' *** RFF file is not a VecTime'
     stop 'vectime_vdh_to_srv_GEOMAG.exe   : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%MISSION_NAME /= 'GEOS') THEN
     print*, ' *** Mission_name is not GEOS'
     stop 'vectime_vdh_to_srv_GEOMAG.exe   : *** ERROR !! Program aborted !'
  ENDIF
 
  IF(manda_param%EXPERIMENT_NAME /= 'S331') THEN
     print*, ' *** experiment_name is not S331'
     stop 'vectime_vdh_to_srv_GEOMAG.exe   : *** ERROR !! Program aborted !'
  ENDIF

  call print_date_time('Reading MAG Indexed data')
 
  call rff_R_indexed_data(1)
  call rff_R_tail(1)

  print*, ('-',i=1,72)

! VDH to SRV
! ----------

  call print_date_time('change coordinate system: VDH to SRV')
 
  nbvec=manda_param%BLOCK_NUMBER
  data_dim=manda_param%DATA_DIMENSION
  ex_index_fmt='(i1,1x,i9,f10.7,3f7.2)'


  DO i=1, nbvec
 
! reading Euler angles
! Here, extended index contains 9 more words : anomalie, Low Speed Format, 
! Spin frequency, Euler angles, spin phase angle in S/C system and S/C sens 
! of rotation (electron or proton
! ex: "0 021468864 0.1633346 247.78 168.04 150.07 p"

  read(status(i),ex_index_fmt) iano,LSF,spin_freq,E1,E2,E3
  if(i == 1) then
             print*
             print*, 'extended index of the first block:'
             print*, 'anomalie, LSF, spin freq, E1, E2, E3= ', iano,LSF,spin_freq,E1,E2,E3
  endif


  x=R_data_vector(1,i)
  y=R_data_vector(2,i)
  z=R_data_vector(3,i)

  call vdh_to_srv(x,y,z,E2,E3,s,r,v)

  R_data_vector(1,i)= s
  R_data_vector(2,i)= r
  R_data_vector(3,i)= v

  ENDDO

  print*, 'done !'


! Update history field
! --------------------

  call gdatiso(credate)
  call rff_update_history(credate,'RPC_vectime_vdh_to_srv_GEOMAG')

  print*
  print*, 'creation du rff dans le SRV'
  print*, 'please wait...'

  call print_date_time('Creating '//trim(file2))

  manda_param%DATA_COORDINATE_SYSTEM='SRV'

  call rff_W_file(3,trim(file2))
 
  print*, 'done !'
  print*

  call print_date_time('vectime_vdh_to_srv_GEOMAG.exe : done !')

  print*, 'vectime_vdh_to_srv_GEOMAG.exe    : NORMAL TERMINATION'
     stop 'vectime_vdh_to_srv_GEOMAG.exe    : NORMAL TERMINATION'

  end program vectime_vdh_to_srv_GEOMAG

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  subroutine vdh_to_srv(x,y,z,E2,E3,s,r,v)

  real :: x,y,z,E2,E3,s,r,v, wx,wy,wz,pisd

  pisd=acos(-1.)/180.
        
! premiere rotation autour de H pour amener V vers le noeud N

  phi= -E3*pisd
  sinphi=sin(phi)
  cosphi=cos(phi)
  
  wx= cosphi*x -sinphi*y
  wy= sinphi*x +cosphi*y 
  wz= z
  
! deuxieme rotation autour de N pour amener H le long de l'axe de spin Z

  phi= -E2*pisd 
  sinphi=sin(phi)
  cosphi=cos(phi)

  x=wx
  y=wy
  z=wz
  
  wx= x
  wy= cosphi*y -sinphi*z
  wz= sinphi*y +cosphi*z  
  
! troisieme rotation autour de Z pour amener X dans le plan VH

  sinrot=cos(E2*pisd)*sin(E3*pisd)
  cosrot=cos(E3*pisd)

  x=wx
  y=wy
  z=wz
  
  s= cosrot*x -sinrot*y
  r= sinrot*x +cosrot*y
  v= z

  return
  end

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

