!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  program vectime_vdh_to_xyz_GEOMAG

!----------------------------------------------------------------------!
! Object: create RFF file of GEOS/S331 in XYZ system (as S300 L1)
! Author: P. Robert , ScientiDev, Oct 2020
!----------------------------------------------------------------------!

  use rff_param_def
  use rff_data_def

  implicit none

  character(len=255) :: file1, file2
  character(len=120) :: credate,ex_index_fmt
  integer            :: i
  character(len=3)   :: suff
  integer, dimension(2):: data_dim
  integer :: nbvec, iano, LSF
  real :: spin_freq,E1,E2,E3
  real :: v,d,h,x,y,z


  print*, '------------------------------------------------------------'
  print*, 'vectime_vdh_to_xyz_GEOMAG : Transform MAG in VDH to MAG in XYZ'
  print*, '------------------------------------------------------------'
  print*

  print*, 'S331  RFF file to read ? (ex: .../data/toto.rff)'
  read(*,'(a)') file1
  print*, trim(file1)

  print*, 'GEOMAG  RFF file to write ? (ex: .../data/toto_srv.rff)'
  read(*,'(a)') file2
  print*, trim(file2)

  i=len(trim(file1))
  suff=file1(i-2:i)

  if(suff /= 'rff') then
     print*, ' ***file1 has not .rff suffix'
     stop 'vectime_vdh_to_xyz_GEOMAG.exe   : *** ERROR !! Program aborted !'
  ENDIF

  i=len(trim(file2))
  suff=file2(i-2:i)

  if(suff /= 'rff') then
     print*, ' ***file2 has not .rff suffix'
     stop 'vectime_vdh_to_xyz_GEOMAG.exe   : *** ERROR !! Program aborted !'
  ENDIF

! read  RFF files
! --------------

  call print_date_time('Reading MAG Meta-data')

  call rff_R_metadata(1,file1)
  call rff_R_const_data(1)

! Tests

  IF(manda_param%FILE_CLASS /= 'VecTime') THEN
     print*, ' *** RFF file is not a VecTime'
     stop 'vectime_vdh_to_xyz_GEOMAG.exe   : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%MISSION_NAME /= 'GEOS') THEN
     print*, ' *** Mission_name is not GEOS'
     stop 'vectime_vdh_to_xyz_GEOMAG.exe   : *** ERROR !! Program aborted !'
  ENDIF
 
  IF(manda_param%EXPERIMENT_NAME /= 'S331') THEN
     print*, ' *** experiment_name is not S331'
     stop 'vectime_vdh_to_xyz_GEOMAG.exe   : *** ERROR !! Program aborted !'
  ENDIF
 
  IF(manda_param%DATA_COORDINATE_SYSTEM /= 'VDH') THEN
     print*, ' *** coordinate system is not VDH'
     stop 'vectime_vdh_to_xyz_GEOMAG.exe   : *** ERROR !! Program aborted !'
  ENDIF
  
  call print_date_time('Reading MAG Indexed data')
 
  call rff_R_indexed_data(1)
  call rff_R_tail(1)

  print*, ('-',i=1,72)

! VDH to XYZ
! ----------

  call print_date_time('change coordinate system')
 
  nbvec=manda_param%BLOCK_NUMBER
  data_dim=manda_param%DATA_DIMENSION

  ex_index_fmt='(i1,i10,f10.7,3(f7.2))'

  DO i=1, nbvec
 
! reading Euler angles
! Here, extended index contains 9 more words : anomalie, Low Speed Format, 
! Spin frequency, Euler angles, spin phase angle in S/C system and S/C sens 
! of rotation (electron or proton
! ex: "0 021468864 0.1633346 247.78 168.04 150.07 p"

  read(status(i),ex_index_fmt) iano,LSF,spin_freq,E1,E2,E3

  v=R_data_vector(1,i)
  d=R_data_vector(2,i)
  h=R_data_vector(3,i)

  call t_vdh_to_xyz(v,d,h,E1,E2,E3,x,y,z)

  R_data_vector(1,i)=x
  R_data_vector(2,i)=y
  R_data_vector(3,i)=z

  ENDDO

  print*, 'done !'


! Update history field
! --------------------

  call gdatiso(credate)
  call rff_update_history(credate,'RPC_vectime_vdh_to_xyz_GEOMAG')
  manda_param%DATA_COORDINATE_SYSTEM='XYZ'

  print*
  print*, 'creation du rff dans le XYZ'
  print*, 'please wait...'

  call print_date_time('Creating '//trim(file2))

  call rff_W_file(3,trim(file2))
 
  print*, 'done !'
  print*

  call print_date_time('vectime_vdh_to_xyz_GEOMAG.exe : done !')

  print*, 'vectime_vdh_to_xyz_GEOMAG.exe    : NORMAL TERMINATION'
     stop 'vectime_vdh_to_xyz_GEOMAG.exe    : NORMAL TERMINATION'

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
  end program vectime_vdh_to_xyz_GEOMAG
!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
