
  program visu_2_vectime

!----------------------------------------------------------------------!
! Object: Visualize a vectime.rff
! Author: P. Robert , ScientiDev, Feb. 2021
!----------------------------------------------------------------------!

  use rff_param_def
  use rff_data_def

  character(len=255) :: VT1,VT2,work,psfile,signat,com
  character(len=3)   :: suff
  character(len=120) :: mission1,experi1,rep1,mode1,laby(6),dati26,label,units,rep
  character(len=120) :: mission2,experi2,rep2,mode2
  character(len=16)  :: forgy,titgra(24)
  character(len=128) :: give_RPC_version,titleft,titright,RPC_version
  character(len=27)  :: datiso1,datiso2,datiso11,datiso12,datiso21,datiso22

  real(kind=4)       :: valgra(24), y1(6),y2(6)
  real(kind=4),      dimension(:),     allocatable :: time,time1,time2
  real(kind=4),      dimension(:,:),   allocatable :: vectime,vectime1,vectime2


  data posfx,posfy/ 3.0,20.6/
  data sizfx,sizfy/15., 3.3/
  data decay /0.3/
  data nbgma,nbpma /24,24/

! --------------------------------------------------------------------+--

  print*, '------------------------------------------------------------'
  print*, 'visu_2_vectime    : Visualize 2 vectime.rff files'
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF VT1 files to read ? (ex: toto1_GSE.rff)'
  read(*,'(a)') VT1
  print*,  trim(VT1)

  print*, 'RFF VT2 files to read ? (ex: toto2_GSE.rff)'
  read(*,'(a)') VT2
  print*,  trim(VT2)

  print*,'datiso1 ? ex:2020-02-05T15:00:00.000000Z'
  read(*,'(a)') datiso1
  print*, trim(datiso1)


  print*,'datiso2 ? ex:2020-02-08T05:32:00.000000Z'
  read(*,'(a)') datiso2
  print*, trim(datiso2)

! test suffixe

  iVT1=len(trim(VT1))
  suff=VT1(iVT1-2:iVT1)

  if(suff /= 'rff') then
     print*, ' ***file ',trim(VT1),',has not .rff suffix',suff
     stop 'visu_2_vectime  .exe               : *** ERROR !! Program aborted !'
  ENDIF

  iVT2=len(trim(VT2))
  suff=VT2(iVT2-2:iVT2)

  if(suff /= 'rff') then
     print*, ' ***file ',trim(VT2),',has not .rff suffix',suff
     stop 'visu_2_vectime  .exe               : *** ERROR !! Program aborted !'
  ENDIF

! --------------------------------------------------------------------+--

! lecture des header des deux fichiers

  call read_VT_header(1,VT1,nbloc1,mission1,experi1,mode1,rep1,dt1,datiso11,datiso12)
  call read_VT_header(2,VT2,nbloc2,mission2,experi2,mode2,rep2,dt2,datiso21,datiso22)

! --------------------------------------------------------------------+--

! redefiniton des bornes si option automatique

  write(*,*)
  write(*,*) 'VT1: number of blocks =',nbloc1
  write(*,*) 'VT1: data_index(    1)=',datiso11
  write(*,*) 'VT1: data_index(nbloc)=',datiso12

  write(*,*)
  write(*,*) ' select time period to extract'

  if(datiso1(1:1) == '0') datiso1=datiso11
  if(datiso2(1:1) == '0') datiso2=datiso12

  if(datiso1 == datiso2) then
     datiso1=datiso11
     datiso2=datiso12
  endif

  print*, 'datiso1=',datiso1
  print*, 'datiso2=',datiso2

  call check_datiso(datiso1)
  call check_datiso(datiso2)

  print*
  print*, 'datiso1 in the file:',datiso11
  print*, 'datiso1 in the file:',datiso12
  print*
  print*, 'datiso1 asked:',datiso1
  print*, 'datiso2 asked:',datiso2


  print*
  print*, '=================================='
  print*, '1) read 1st vectime file '
  print*, '=================================='


  call rff_R_file(1,VT1)

  call check_meta

  nbloc_s=0
  it1=1
  it2=nbloc1

! select period

  do i=1,nbloc1
     call compare_datiso(datiso1,data_index(i),icomp1)
     call compare_datiso(datiso2,data_index(i),icomp2)

     if((icomp1 == -1) .or. (icomp2 == 1)) cycle
     nbloc_s=nbloc_s +1
     if(nbloc_s == 1) it1=i
     it2=i
  end do

  print*,'nbloc1, it1,it2,nbloc_s=',nbloc1,it1,it2,nbloc_s
  print*

  if (allocated(vectime)) deallocate(vectime, stat=ierr1)
  if (allocated(time))    deallocate(time, stat=ierr2)
  allocate(vectime(6,nbloc_s), stat=ierr3)
  allocate(time(nbloc_s), stat=ierr4)

  if(ierr1 /= 0) print*,'ierr1=',ierr1
  if(ierr2 /= 0) print*,'ierr2=',ierr2
  if(ierr3 /= 0) print*,'ierr3=',ierr3
  if(ierr4 /= 0) print*,'ierr4=',ierr4

  print*
  print*, '2) Load data 1st file'

  print*, 'chargement du temps et des vecteurs, avec reduction eventuelle des donnees'

  call load_data

  print*,'nbloc1, it1,it2,nbloc_s=',nbloc1,it1,it2,nbloc_s,'  nbvec=',nbvec
  if(nbvec.lt.nbloc_s) print*,'There is removed fill values'

! save 1st file

  nbvec1=nbvec
  allocate(vectime1(6,nbvec1),stat=ierr1)
  allocate(time1(nbvec1),stat=ierr2)

  if(allocated(vectime1)) deallocate(vectime1, stat=ierr1)
  if (allocated(time1))   deallocate(time1,    stat=ierr2)
  allocate(vectime1(6,nbvec1), stat=ierr3)
  allocate(time1(nbvec1), stat=ierr4)

  if(ierr1 /= 0) print*,'ierr1=',ierr1
  if(ierr2 /= 0) print*,'ierr2=',ierr2
  if(ierr3 /= 0) print*,'ierr3=',ierr3
  if(ierr4 /= 0) print*,'ierr4=',ierr4

  print*, 'sizes:', size(vectime1), size(vectime), size(time1),size(time)
  print*, 'nbvec1=',nbvec1

  vectime1(1:3,1:nbvec1)=vectime(1:3,1:nbvec1)
  time1(1:nbvec1)=time(1:nbvec1)

  deallocate(vectime,stat=ierr1)
  deallocate(time,stat=ierr1)
 
  if(ierr1 /= 0 .or. ierr2 /= 0) print*, '*** deallocate ierr1,ierr2=',ierr1,ierr2

  call extend(vectime1,nbvec1)

  com=trim(optio_param%SUB_TITLE)
  print*, trim(com)

  print*
  print*, '=================================='
  print*, '2) read 2st vectime file '
  print*, '=================================='

  ifc=20
   call rff_R_metadata(ifc,VT2)
! call rff_W_manda_param(6)
! call rff_W_optio_param(6)

  call rff_R_const_data(ifc)
! call rff_W_const_data(6)

  call rff_R_indexed_data(ifc)
  call rff_R_tail(ifc)

  call check_meta

  nbloc_s=0
  it1=1
  it2=nbloc2

! select period

  do i=1,nbloc2
     call compare_datiso(datiso1,data_index(i),icomp1)
     call compare_datiso(datiso2,data_index(i),icomp2)

     if((icomp1 == -1) .or. (icomp2 == 1)) cycle
     nbloc_s=nbloc_s +1
     if(nbloc_s == 1) it1=i
     it2=i
  end do

  print*,'nbloc2, it1,it2,nbloc_s=',nbloc2,it1,it2,nbloc_s
  print*

  if (allocated(vectime)) deallocate(vectime, stat=ierr1)
  if (allocated(time))    deallocate(time, stat=ierr2)
  allocate(vectime(6,nbloc_s), stat=ierr3)
  allocate(time(nbloc_s), stat=ierr4)

  if(ierr1 /= 0) print*,'ierr1=',ierr1
  if(ierr2 /= 0) print*,'ierr2=',ierr2
  if(ierr3 /= 0) print*,'ierr3=',ierr3
  if(ierr4 /= 0) print*,'ierr4=',ierr4

  print*
  print*, '2) Load data 2nd file'

  print*, 'chargement du temps et des vecteurs, avec reduction eventuelle des donnees'

  call load_data

  print*,'nbloc1, it1,it2,nbloc_s=',nbloc1,it1,it2,nbloc_s,'  nbvec=',nbvec
  if(nbvec.lt.nbloc_s) print*,'There is removed fill values'

! save 2st file

  nbvec2=nbvec

  if(allocated(vectime2)) deallocate(vectime2, stat=ierr1)
  if(allocated(time2))    deallocate(time2,    stat=ierr2)
  allocate(vectime2(6,nbvec2), stat=ierr3)
  allocate(time2(nbvec2), stat=ierr4)

  if(ierr1 /= 0) print*,'ierr1=',ierr1
  if(ierr2 /= 0) print*,'ierr2=',ierr2
  if(ierr3 /= 0) print*,'ierr3=',ierr3
  if(ierr4 /= 0) print*,'ierr4=',ierr4

  print*, 'sizes:', size(vectime2), size(vectime), size(time2),size(time)
  print*, 'nbvec2=',nbvec2

  vectime2(1:3,1:nbvec2)=vectime(1:3,1:nbvec2)
  time2(1:nbvec2)=time(1:nbvec2)

  deallocate(vectime,stat=ierr1)
  deallocate(time,stat=ierr1)

  call extend(vectime2,nbvec2)

! ---------------------------------------------------------
  print*, 'Ouverture du fichier PS'
! ---------------------------------------------------------

  print*,'calcul du titre droit et de la date'

  call decode_datiso(datiso11,iyear,imon,iday,ih,im,is,ims,imc)
  call codoty(imon,iday,iyear,idoty1)
  call cdattit_(iyear,imon,iday,titright)
  print*, 'titright=',titright
  write(work,'(I4.4,2i2.2)') iyear,imon,iday

  laby(1)='X'
  laby(2)='Y'
  laby(3)='Z'

  laby(4)='R'
  laby(5)='Theta'
  laby(6)='Phi'

  psfile=mission1(1:3)//'_'//experi1(1:3)//'_'//mission2(1:3)//'_'//experi2(1:3)//'_'//work(1:8)//'.ps'

  tclab=0.30
  tctit=0.30
  tccom=0.25

  call dopegra_(1,psfile)

  call dlinwid_(1.5)
  call dfontyp_('h')
  call dtitsiz_(tctit)

  print*, 'Trace les variables du plot'

! si on veut imposer les bornes
  y1(:)=0.
  y2(:)=0.

  titleft=mission1(1:3)//'/'//experi1(1:3)//'/'//mode1(1:4)//'-' &
        //mission2(1:3)//'/'//experi2(1:3)//'/'//mode2(1:4)

  tcl=0.4
  tcr=0.35
  call gasdati_(dati26)
  RPC_version=give_RPC_version()
  signat='RoGraLib plot -'//' '//trim(psfile)//" - "//RPC_version(1:8)

  print*,'plot du cadre avec titre gauche et droit, signature et date'

  call plotframe(titleft,tcl,titright,tcr,signat)

  print*, 'plot du titre'

  call gpagsiz_(spx,spy)
  call ppagcha_(posfx+sizfx/2.,spy-2.8,0, tctit,tctit,0.,com)


  print*,'plot du commentaire haut gauche'

  write(work,"(a,i9,a,e12.3,a)") "Nb. Pts= ",nbvec,"    <dt> =",dt1,' s'
  call ppagcha_(0.5,spy-2.4,-1,tccom,tccom,0.,trim(work))
  dt=dt1/3600.

  print*, 'calcul des graduations horaire'

  t1=time1(1)
  t2=time1(nbvec1)

  print*, 't1,t2=',t1,t2

  call cfiggrah(t1,t2,valgra,titgra,valdt,nbgma,nbpma)
  call dfiglimx(t1,t2)

  print*, 'nb G. marques=',nbgma
  print*, 'nb P. marques=',nbpma
  print*, 'val. grad.=',(valgra(i),i=1,nbgma)
  print*, 'valdt     =',valdt


! --------------------------------------------------------------------------------------

! On cherche la meme echelle pour les 4 plots

  xmi=min(minval(vectime1(1,:)),minval(vectime2(1,:)))
  ymi=min(minval(vectime1(2,:)),minval(vectime2(2,:)))
  zmi=min(minval(vectime1(3,:)),minval(vectime2(3,:)))
  pmi=min(minval(vectime1(4,:)),minval(vectime2(4,:)))
  qmi=min(minval(vectime1(5,:)),minval(vectime2(5,:)))
  rmi=min(minval(vectime1(6,:)),minval(vectime2(6,:)))


  xma=max(maxval(vectime1(1,:)),maxval(vectime2(1,:)))
  yma=max(maxval(vectime1(2,:)),maxval(vectime2(2,:)))
  zma=max(maxval(vectime1(3,:)),maxval(vectime2(3,:)))
  pma=max(maxval(vectime1(4,:)),maxval(vectime2(4,:)))
  qma=max(maxval(vectime1(5,:)),maxval(vectime2(5,:)))
  rma=max(maxval(vectime1(6,:)),maxval(vectime2(6,:)))

  print*, 'xmi,ymi,zmi,pmi,qmi,rmi=', xmi,ymi,zmi,pmi,qmi,rmi
  print*, 'xma,yma,zma,pma,qma,rma=', xma,yma,zma,pma,qma,rma

! ----------------------------------------------------------------------------
  print*, 'plot des 6 pannels'
! ----------------------------------------------------------------------------

! *   bornes automatiques

  y1(1)=xmi
  y2(1)=xma
  y1(2)=ymi
  y2(2)=yma
  y1(3)=zmi
  y2(3)=zma
  y1(4)=pmi
  y2(4)=pma
  y1(5)=qmi
  y2(5)=qma
  y1(6)=rmi
  y2(6)=rma

  print*,'y1=',y1
  print*,'y2=',y2

  do nco=1,6

     print*, 'component ',nco

     if(nco.gt.1) posfy=posfy-sizfy-decay
     if(nco.eq.4) posfy=posfy-0.7

     call dfigori_(posfx,posfy)
     call dfigsiz_(sizfx,sizfy)
     call cfiggra_(y1(nco),y2(nco),ymin,ymax,bgy,sgy,forgy)
     call dgrasiz_(0.,0.3)

     call dfiglimy(ymin,ymax)
     print*, 'ymin,ymax=',ymin,ymax

     if(nco == 6) call dstipos_('oi','ii')
     if(nco == 4) call ppagcha_(posfx+sizfx/2.,posfy+sizfy+0.4,0, tclab,tclab,0.,'Spherical components')

     call pfigfra_
     call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
     call pfiggray(0.,bgy,sgy,forgy)
     call dlincol_('n')
     call pfigcur_(time1,vectime1(nco,1:nbvec1),nbvec1)
     call dlincol_('r')
     call pfigcur_(time2,vectime2(nco,1:nbvec2),nbvec2)
     call dlincol_('n')
     call cchalen_(laby(nco),nl)
     call ppagcha_(0.5,posfy+sizfy/2.,-1,tclab,tclab,0.,laby(nco)(1:nl))

  end do

! *** re-plot des graduations horaire du bas avec valeurs

  call dgrasiz_(0.35,0.3)
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)

! *** termine, fermeture du fichier graphique

  call dclogra_

  print*, 'visu_2_vectime  .exe             : NORMAL TERMINATION'
     stop 'visu_2_vectime  .exe             : NORMAL TERMINATION'

!-------------------------------------------------------------------+--
  contains

!-------------------------------------------------------------------+--

  subroutine check_meta

  print*, "check metadata"

  IF(manda_param%FILE_CLASS /= 'VecTime') THEN
     write(*,*) '*** Only VecTime FILE_CLASS is allowed'
     stop 'visu_2_vectime  .exe            : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_TYPE /= 'FLT') THEN
     write(*,*) '*** Only FLT DATA_TYPE is allowed'
     stop 'visu_2_vectime  .exe            : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%INDEX_UNITS /= 'ISO_TIME') THEN
     write(*,*) '*** Only ISO_TIME INDEX_UNITS is allowed'
     stop 'visu_2_vectime  .exe            : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_FORM /= 'Vector') THEN
     write(*,*) '*** Only Vector DATA_FORM is allowed'
     stop 'visu_2_vectime  .exe            : *** ERROR !! Program aborted !'
  ENDIF

  print*, "OK"

  end subroutine check_meta

!-------------------------------------------------------------------+--

  subroutine load_data

  print*, 'filval=',trim(manda_param%DATA_FILL_VALUE)
  read(manda_param%DATA_FILL_VALUE,*) filval

  print*,'load_data: filval =',filval
  print*,'load_data: it1,it2=',it1,it2

  nbvec=0

  do i=it1,it2

     if(abs(R_data_vector(1,i)-filval) .lt. 1.e-30) cycle
     if(abs(R_data_vector(2,i)-filval) .lt. 1.e-30) cycle
     if(abs(R_data_vector(3,i)-filval) .lt. 1.e-30) cycle

     nbvec=nbvec+1

     call decode_datiso(data_index(i),iyear,imon,iday,ih,im,is,ims,imc)
     call codoty(imon,iday,iyear,idoty)
     if(i == it1) idoty1=idoty
     nbday=idoty-idoty1
     call codecsec(nbday,ih,im,is,ims,imc,decsec)

     time(nbvec)=decsec/3600.

     vectime(1,nbvec)=R_data_vector(1,i)
     vectime(2,nbvec)=R_data_vector(2,i)
     vectime(3,nbvec)=R_data_vector(3,i)
  end do

  deallocate(data_index)
  deallocate(R_data_vector)

! conversion en cartesien si donnée en lat,lon,dist

  label=manda_param%DATA_LABEL
  units=manda_param%DATA_UNITS
  rep  =manda_param%DATA_COORDINATE_SYSTEM

  print*
  print*, 'label=',label
  print*, 'units=',units

  IF((label == 'Latitude ; Longitude ; Distance') .and. (units == 'degree ; degree ; km')) THEN
    print*
    print*, 'conversion spherical position to cartesian one'
    print*, 'first point r,lat,lon=',vectime(1,1),vectime(2,1), vectime(3,1)
    pisd=acos(-1.)/180.

  do i=1, nbvec
     bx=vectime(1,i)
     by=vectime(2,i)
     bz=vectime(3,i)

     pp=bz*cos(bx*pisd)

     vectime(1,i)=pp*cos(by*pisd)/6378.
     vectime(2,i)=pp*sin(by*pisd)/6378.
     vectime(3,i)=bz*sin(bx*pisd)/6378.
  end do

  manda_param%DATA_LABEL='Px ; Py ; Pz'
  manda_param%DATA_UNITS='Re ; Re ; Re'
  optio_param%SUB_TITLE='Px, Py, Pz (Re) in '//rep(1:4)//' system'

  ENDIF

  end subroutine load_data

!-------------------------------------------------------------------+--

  END program visu_2_vectime

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  subroutine extend(vect,nbvec)

  real vect(6,nbvec)

  print*,'Calcul des composantes spheriques sur N=',nbvec

  do i=1,nbvec
     x=vect(1,i)
     y=vect(2,i)
     z=vect(3,i)

     call car_to_sph(x,y,z,r,teta,phi)

     vect(4,i)=r
     vect(5,i)=teta
     vect(6,i)=phi
  end do

  print*, 'done!'

  return
  END
     subroutine car_to_sph(x,y,z,r,teta,phi) 
!                                                                       
! ----------------------------------------------------------------------
! *   Class  : transform modules of Rocotlib Software                   
! *   Object : transforms_car_to_sph: CAR -> SPH  system                
! *   Author : P. Robert, CRPE, 1992                                    
! *   Comment: none                                                     
!                                                                       
! *   Input  :   x,y,z        cartesian coordinates                     
! *   Output :   r,teta,phi   spherical coordinates (angles in radians) 
! ----------------------------------------------------------------------
!                                                                       
!                                                                       
      teta=0. 
      phi=0. 
      sq=x**2+y**2 
      r=sqrt(sq+z**2) 
      pi=acos(-1.)
      pisd=pi/180
!                                                                      
      if(r.lt.1.e-10) return 
!                                                                       
! *** en dessous de 1/10000 degres, on considere que teta =0 ou 180     
!     et phi indefini, mis a zero                                       
!                                                                       
      if(sq/r .gt.1.7e-6) then 
                   phi=atan2(y,x) 
                 if(phi.lt.-179.999*pisd.and.phi.gt.-180.*pisd) phi=pi
                 if(phi.lt. 0.0001*pisd.and.phi.gt.-0.0001*pisd) phi=0.
                   teta=acos(z/r) 
                   return 
                   endif 
!                                                                       
      if (z.lt.0.) then 
                   teta=acos(-1.) 
                   else 
                   teta=0. 
                   endif 
!                                                                       
      return 
      END                                           
!                                                                       
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
! 

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  subroutine read_VT_header(ifc,VT,nbloc,mission,experi,mode,rep,dt,datiso1,datiso2)

  character(len=*) :: VT,mission,experi,mode,rep,datiso1,datiso2
  character(len=255) :: line,cdt,cbloc
  real(kind=4) :: dt

  print*
  print*, 'Read ',trim(VT),' file...'

  close(ifc)
  open(ifc,file=VT)
  line='---'

  do i=1,300
     read(ifc,'(a)') line
     if(line(1:37) == 'PAR MISSION_NAME              (STR): ') mission=line(38:)
     if(line(1:37) == 'PAR EXPERIMENT_NAME           (STR): ') experi =line(38:)
     if(line(1:37) == 'PAR EXPERIMENT_MODE           (STR): ') mode   =line(38:)
     if(line(1:37) == 'PAR DATA_COORDINATE_SYSTEM    (STR): ') rep    =line(38:)
     if(line(1:37) == 'PAR BLOCK_FIRST_INDEX         (STR): ') datiso1=line(38:)
     if(line(1:37) == 'PAR BLOCK_LAST_INDEX          (STR): ') datiso2=line(38:)
     if(line(1:37) == 'PAR BLOCK_NUMBER              (INT): ') cbloc  =line(38:)
     if(line(1:37) == 'PAR TIME_RESOLUTION           (DBL): ') then
        cdt=line(38:)
        exit
     endif
  end do

  close(ifc)

  print*,'cdt,cbloc=',trim(cdt),' ',trim(cbloc)
  read(cdt,*) dt
  read(cbloc,*) nbloc

  print*, 'MISSION_NAME            : ',trim(mission)
  print*, 'EXPERIMENT_NAME         : ',trim(experi)
  print*, 'EXPERIMENT_MODE         : ',trim(mode)
  print*, 'DATA_COORDINATE_SYSTEM  : ',trim(rep)
  print*, 'TIME_RESOLUTION         : ',dt
  print*, 'PAR BLOCK_FIRST_INDEX   : ',trim(datiso1)
  print*, 'BLOCK_LAST_INDEX        : ',trim(datiso2)
  print*, 'BLOCK_NUMBER            : ',nbloc

  return
  end

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX