!
  program visu_CLUGEOM
!
! --------------------------------------------------------------------+--
! Lecture d'un fichier copolar.resu et
! Creation du postscript visu_CLUGEOM.ps
!
! P. Robert, CETP, Juin 2005, revu P. Robert, ScientiDev, Feb. 2021
! --------------------------------------------------------------------+--
!
! *** Declaration pour la lecture standard du fichier clugeom.resu

  real(kind=4), dimension(:),     allocatable :: time,curve1,curve2,curve3,curve4
  real(kind=4), dimension(:,:),   allocatable :: dist,surf,abc,elon,apla
  real(kind=4), dimension(:,:,:), allocatable :: posgse,posgra

  character(len=8)   :: titgra(24),rep
  character(len=64)  :: give_RPC_version,titleft,titright,RPC_version
  character(len=255) :: psfile,signat
  character(len=120) :: dati26,titpan(3),forgy

  real(kind=4) :: valgra(24)


! Initialisation des variables graphiques
!
  data posfx,posfy/ 3.0,22.4/
  data sizfx,sizfy/15.,2./
  data decay /0.2/
  data nbgma,nbpma /24,24/

 print*, '------------------------------------------------------------------------ '

! --------------------------------
! Lecture du fichier get_data_CLUGEOM.resu
! --------------------------------

  open(1,file='get_data_CLUGEOM.resu')

! lecture de l'entete du fichier
!
  call read_header_CLUGEOM(rep,nrec)
!
! alloc des tableaux

  allocate(time(nrec))
  allocate(curve1(nrec))
  allocate(curve2(nrec))
  allocate(curve3(nrec))
  allocate(curve4(nrec))
  allocate(posgse(3,4,nrec))
  allocate(posgra(3,4,nrec))
  allocate(dist(6,nrec))
  allocate(surf(4,nrec))
  allocate( abc(3,nrec))
  allocate(elon(3,nrec))
  allocate(apla(3,nrec))

! *** lecture des data du fichier

  call read_data_CLUGEOM(jul00,iyear,imon,iday,time,posgse,nrec,&
                     posgra,dist,surf,abc,elon,apla,t1,t2)
!
! fermeture du fichier copolar.resu
!
  close(1)
! ----------------------------------------
! initialisation des parametres graphiques
! ----------------------------------------

  ttit=0.3
  tlab=0.35
  tgrax=0.25
  tgray=0.25
  xlab=0.9



! --------------------------------------------------------------------+--
! ouverture du fichier graphique et mise en page
! --------------------------------------------------------------------+--

  psfile='CLUGEOM.ps'

  call dopegra_(7,psfile)
  call gpagsiz_(pagsx,pagsy)

  titleft='CLUSTER Tetrahedron geometry'
  tcl=0.4
  tcr=0.35
  call gasdati_(dati26)
  RPC_version=give_RPC_version()
  signat='RoGraLib plot -'//' '//trim(psfile)//" - "//RPC_version(1:8)
  call cdattit_(iyear,imon,iday,titright)

  print*,'plot du cadre avec titre gauche et droit, signature et date'

  call plotframe(titleft,tcl,titright,tcr,signat)

! calcul des bornes et graduations en temps et en frequence
! ---------------------------------------------------

  print*,'bornes en temps'

  print*, 't1,t2 (s.)=',t1,t2

  print*, 'calcul des graduations horaire'

  call dlinwid_(2.)
  call cfiggrah(t1,t2,valgra,titgra,valdt,nbgma,nbpma)
  call dfiglimx(t1,t2)

  print*, 'nb G. marques=',nbgma
  print*, 'nb P. marques=',nbpma
  print*, 'val. grad.=',(valgra(i),i=1,nbgma)

! conversion des km en Mm (km*1000)

  posgra=posgra/1000.
  dist  =  dist/1000.
  abc   =   abc/1000.
  surf  =  surf/1000000.

  titpan(1)= 'Positions in '//trim(rep)//' centre of mass (Mm = km x1000)'
  titpan(2)= 'Inter-distances and Areas (Mm & [Mm]2 )'
  titpan(3)= 'Elongation and Planarity vectors'

  print*,'---------------------------------------'
  print*,'GSE, mass center'

  call dfigori_(posfx,posfy)
  call dfigsiz_(sizfx,sizfy)
  call dgrasiz_(0.,tgray)
  call pfigfra_
  call ppagcha_(posfx+sizfx/2.,posfy+sizfy+1.2*ttit,0,ttit,ttit,0.,titpan(1))

! X
  y1=minval(posgra(1,:,:))
  y2=maxval(posgra(1,:,:))

  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)
  call ppagcha_(xlab,posfy+sizfy/2.,0,tlab,tlab,0.,'Px')

  call dlincol_('n')
  call pfigcur_(time,posgra(1,1,:),nrec)
  call dlincol_('r')
  call pfigcur_(time,posgra(1,2,:),nrec)
  call dlincol_('g')
  call pfigcur_(time,posgra(1,3,:),nrec)
  call dlincol_('b')
  call pfigcur_(time,posgra(1,4,:),nrec)
  call dlincol_('n')
  
! Y
  posfy=posfy-sizfy-decay
  call dfigori_(posfx,posfy)
  call pfigfra_

  y1=minval(posgra(2,:,:))
  y2=maxval(posgra(2,:,:))

  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)
  call ppagcha_(xlab,posfy+sizfy/2.,0,tlab,tlab,0.,'Py')

  call dlincol_('n')
  call pfigcur_(time,posgra(2,1,:),nrec)
  call dlincol_('r')
  call pfigcur_(time,posgra(2,2,:),nrec)
  call dlincol_('g')
  call pfigcur_(time,posgra(2,3,:),nrec)
  call dlincol_('b')
  call pfigcur_(time,posgra(2,4,:),nrec)
  call dlincol_('n')

! Z
  posfy=posfy-sizfy-decay
  call dfigori_(posfx,posfy)
  call pfigfra_

  y1=minval(posgra(3,:,:))
  y2=maxval(posgra(3,:,:))

  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)
  call ppagcha_(xlab,posfy+sizfy/2.,0,tlab,tlab,0.,'Pz')

  call dlincol_('n')
  call pfigcur_(time,posgra(3,1,:),nrec)
  call dlincol_('r')
  call pfigcur_(time,posgra(3,2,:),nrec)
  call dlincol_('g')
  call pfigcur_(time,posgra(3,3,:),nrec)
  call dlincol_('b')
  call pfigcur_(time,posgra(3,4,:),nrec)
  call dlincol_('n')
  
! R

  posfy=posfy-sizfy-decay
  call dfigori_(posfx,posfy)
  call pfigfra_
  
  curve1(:)=sqrt(posgra(1,1,:)**2 +posgra(2,1,:)**2 +posgra(3,1,:)**2)  
  curve2(:)=sqrt(posgra(1,2,:)**2 +posgra(2,2,:)**2 +posgra(3,2,:)**2)  
  curve3(:)=sqrt(posgra(1,3,:)**2 +posgra(2,3,:)**2 +posgra(3,3,:)**2)
  curve4(:)=sqrt(posgra(1,4,:)**2 +posgra(2,4,:)**2 +posgra(3,4,:)**2)  
  
  y1=(min(minval(curve1),minval(curve2),minval(curve3),minval(curve4)))
  y2=(max(maxval(curve1),maxval(curve2),maxval(curve3),maxval(curve4)))

  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)
  call ppagcha_(xlab,posfy+sizfy/2.,0,tlab,tlab,0.,'R')

  call dlincol_('n')
  call pfigcur_(time,curve1,nrec)
  
  call dlincol_('r')
  call pfigcur_(time,curve2,nrec)
  
  call dlincol_('g')
  call pfigcur_(time,curve3,nrec)
  
  call dlincol_('b')
  call pfigcur_(time,curve4,nrec)
  
  call dlincol_('n')

  print*,'---------------------------------------'
  print*,'Inter-distances'

  posfy=posfy-sizfy-decay -2.*ttit
  call dfigori_(posfx,posfy)
  call dfigsiz_(sizfx,sizfy)
  call dgrasiz_(0.,tgray)
  call pfigfra_
  call ppagcha_(posfx+sizfx/2.,posfy+sizfy+1.2*ttit,0,ttit,ttit,0.,titpan(2))

  y1=minval(dist)
  y2=maxval(dist)

  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)
  call ppagcha_(xlab,posfy+sizfy/2.,0,tlab,tlab,0.,'Dij')

  call dlincol_('n')
  call pfigcur_(time,dist(1,:),nrec)
  call dlincol_('r')
  call pfigcur_(time,dist(2,:),nrec)
  call dlincol_('g')
  call pfigcur_(time,dist(3,:),nrec)
  call dlincol_('b')
  call pfigcur_(time,dist(4,:),nrec)
  call dlincol_('c')
  call pfigcur_(time,dist(5,:),nrec)
  call dlincol_('m')
  call pfigcur_(time,dist(6,:),nrec)
  call dlincol_('n')

! surfaces

  posfy=posfy-sizfy-decay 
  call dfigori_(posfx,posfy)
  call dfigsiz_(sizfx,sizfy)
  call dgrasiz_(0.,tgray)
  call pfigfra_

  y1=minval(surf)
  y2=maxval(surf)

  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)
  call ppagcha_(xlab+tlab,posfy+sizfy/2.,0,tlab,tlab,0.,'Areas')

  call dlincol_('n')
  call pfigcur_(time,surf(1,:),nrec)
  call dlincol_('r')
  call pfigcur_(time,surf(2,:),nrec)
  call dlincol_('g')
  call pfigcur_(time,surf(3,:),nrec)
  call dlincol_('b')
  call pfigcur_(time,surf(4,:),nrec)
  call dlincol_('n')
  print*,'---------------------------------------'
  print*,'Elon-Plana'

! abc

  posfy=posfy-sizfy-decay -2.*ttit
  call dfigori_(posfx,posfy)
  call dfigsiz_(sizfx,sizfy)
  call dgrasiz_(0.,tgray)
  call pfigfra_
  call ppagcha_(posfx+sizfx/2.,posfy+sizfy+1.2*ttit,0,ttit,ttit,0.,titpan(3))

  y1=minval(abc)
  y2=maxval(abc)

  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)
  call ppagcha_(xlab,posfy+sizfy/2.,0,tlab,tlab,0.,'a,b,c')

  call dlincol_('n')
  call pfigcur_(time,abc(1,:),nrec)
  call dlincol_('r')
  call pfigcur_(time,abc(2,:),nrec)
  call dlincol_('g')
  call pfigcur_(time,abc(3,:),nrec)
  call dlincol_('n')

! E,P

  posfy=posfy-sizfy-decay 
  call dfigori_(posfx,posfy)
  call dfigsiz_(sizfx,sizfy)
  call dgrasiz_(0.,tgray)
  call pfigfra_

  y1=0.
  y2=1

  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)
  call ppagcha_(xlab,posfy+sizfy/2.,0,tlab,tlab,0.,'E,P')

  call dlincol_('n')
  call pfigcur_(time,elon(1,:),nrec)
  call dlincol_('r')
  call pfigcur_(time,apla(1,:),nrec)

  call dlincol_('n')
  
! Theta grands axes

  posfy=posfy-sizfy-decay 
  call dfigori_(posfx,posfy)
  call dfigsiz_(sizfx,sizfy)
  call dgrasiz_(0.,tgray)
  call pfigfra_

  y1=0.
  y2=180.

  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)
  call ppagcha_(xlab,posfy+sizfy/2.,0,0.8*tlab,0.8*tlab,0.,'Theta a,b')

  call dlincol_('n')
  call pfigcur_(time,elon(2,:),nrec)
  call dlincol_('r')
  call pfigcur_(time,apla(2,:),nrec)

  call dlincol_('n')

  
! Phi grands axes

  posfy=posfy-sizfy-decay 
  call dfigori_(posfx,posfy)
  call dfigsiz_(sizfx,sizfy)
  call dgrasiz_(tgrax,tgray)
  call pfigfra_

  y1=-180.
  y2=180.

  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)
  call ppagcha_(xlab,posfy+sizfy/2.,0,0.8*tlab,0.8*tlab,0.,'Phi a,b')

  call dlincol_('n')
  call pfigcur_(time,elon(2,:),nrec)
  call dlincol_('r')
  call pfigcur_(time,apla(2,:),nrec)

  call dlincol_('n')

  call ppagcha_(0.8,posfy-0.6,-1,0.3,0.3,0.,'UT')
!
! *** termine
!
  call dclogra_

  print*, 'visu_CLUGEOM.exe                 : NORMAL TERMINATION'
     stop 'visu_CLUGEOM.exe                 : NORMAL TERMINATION'
  END
!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

 subroutine read_header_CLUGEOM(rep,nrec)

 character*(*) rep
 character*64 bid,form

!----------------------------------------------------------------------!
! Object: lecture del'entete du fichier CLUGEOM.resu
! Author: P. Robert, LPP, 2001 May -conversion IDL-> F90 P.R. Feb. 2021
!----------------------------------------------------------------------!


  PRINT*, 'Reading header of CLUGEOM.resu...'

! lecture de l'entete

  bid=' '

  DO ili=1,5
     READ(1,'(a)') bid
     PRINT*, bid
  END DO

! lecture du repere et de la forme (longue ou courte)

  rep=' '
  form=' '
  nrec=0

  READ(1,"(13x,a)")  rep
  READ(1,"(13x,i7)") nrec

  PRINT*, 'coordinate : ',rep
  PRINT*, 'Nrec       : ',nrec

! lecture du reste de l'entete

  DO ili=1,10
     READ(1,'(a)') bid
     PRINT*, bid
  END DO

  RETURN
  END

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

  subroutine read_data_CLUGEOM(jul001,iyear1,imon1,iday1,time,posgse,nrec,&
                     posgra,dist,surf,abc,elon,apla,t1,t2)

  real(kind=4) :: time(nrec),posgse(3,4,nrec),posgra(3,4,nrec),dist(6,nrec)
  real(kind=4) :: surf(4,nrec),abc(3,nrec),elon(3,nrec),apla(3,nrec)

!----------------------------------------------------------------------!
! Object: lecture des donnees du fichier CLUGEOM.resu
! Author: P. Robert, LPP, 2001 May -conversion IDL-> F90 P.R. Feb. 2021
!----------------------------------------------------------------------!

! lecture  des blocs

  DO iblo=1,nrec

      READ(1,*) jul00,iyear,imon,iday,ih,im,is,isat,x,y,z

      if(iblo == 1 ) then
                     jul001=jul00
                     iyear1=iyear
                     imon1 =imon
                     iday1 =iday
                     ih1=ih
                     im1=im
                     is1=is
      endif

      time(iblo)= FLOAT(ih) +FLOAT(im)/60. +FLOAT(is)/3600.

      posgse(1,isat,iblo)= x
      posgse(2,isat,iblo)= y
      posgse(3,isat,iblo)= z

      READ(1,*) isat,x,y,z

      posgse(1,isat,iblo)= x
      posgse(2,isat,iblo)= y
      posgse(3,isat,iblo)= z

      READ(1,*) isat,x,y,z

      posgse(1,isat,iblo)= x
      posgse(2,isat,iblo)= y
      posgse(3,isat,iblo)= z

      READ(1,*) isat,x,y,z

      posgse(1,isat,iblo)= x
      posgse(2,isat,iblo)= y
      posgse(3,isat,iblo)= z
! -----------------------------------------

      gravx=( posgse(1,1,iblo) +posgse(1,2,iblo) +posgse(1,3,iblo) +posgse(1,4,iblo))/4.
      gravy=( posgse(2,1,iblo) +posgse(2,2,iblo) +posgse(2,3,iblo) +posgse(2,4,iblo))/4.
      gravz=( posgse(3,1,iblo) +posgse(3,2,iblo) +posgse(3,3,iblo) +posgse(3,4,iblo))/4.

      DO isat=1,4
         posgra(1,isat,iblo)=posgse(1,isat,iblo) -gravx
         posgra(2,isat,iblo)=posgse(2,isat,iblo) -gravy
         posgra(3,isat,iblo)=posgse(3,isat,iblo) -gravz
      END DO

! -----------------------------------------

      READ(1,*) d1,d2,d3,d4,d5,d6

      dist(1,iblo)= d1
      dist(2,iblo)= d2
      dist(3,iblo)= d3
      dist(4,iblo)= d4
      dist(5,iblo)= d5
      dist(6,iblo)= d6

      READ(1,*) s1,s2,s3,s4

      surf(1,iblo)= s1
      surf(2,iblo)= s2
      surf(3,iblo)= s3
      surf(4,iblo)= s4

      READ(1,*) a,b,c

      abc(1,iblo)= a
      abc(2,iblo)= b
      abc(3,iblo)= c

      READ(1,*) elonr,elont,elonp

!     elong, teta,phi grand axe
      elon(1,iblo)= elonr
      elon(2,iblo)= elont
      elon(3,iblo)= elonp

      READ(1,*) aplar,aplat,aplap

!     plana, teta,phi petit axe
      apla(1,iblo)= aplar
      apla(2,iblo)= aplat
      apla(3,iblo)= aplap

  END DO

! cloture du fichier de donnees

  CLOSE(1)

  PRINT*,time

  PRINT*
  PRINT*, 'nrec=', nrec
  nday=jul001-jul00
  t1= float(ih1)+float(im1)/60.+float(is1)/3600.
  t2= float(nday)*24. +float(ih)+float(im)/60.+float(is)/3600.

  IF(nrec == 0) THEN
                print*, 'visu_CLUGEOM.exe                 : ***ERR, EMPTY CLUGEOM.resu FILE'
                   stop 'visu_CLUGEOM.exe                 : ***ERR, EMPTY CLUGEOM.resu FILE'
  ENDIF

  RETURN
  END

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX