
  program visu_ave_spectrum
!
!----------------------------------------------------------------------!
! Object: Visualize a SP.rff
! Author: P. Robert , ScientiDev, Feb. 2021
!----------------------------------------------------------------------!

  use rff_param_def
  use rff_data_def

  integer        :: nbspe, i

  character(len=255) :: SP_file,psfile,signat
  character(len=3)   :: suff,XY
  character(len=1)   :: B
  character(len=120) :: dati26,mission,experi,csatnum,units,rep,titpan,br
  character(len=8)   :: laby(3)
  character(len=64)  :: give_RPC_version,titleft,titright,RPC_version,labx
  character(len=27)  :: datiso1,datiso2
  character(len=128)  :: titspe

  real(kind=4),      dimension(:),     allocatable :: freq,puix,puiy,puiz,work
  real(kind=4),      dimension(:,:),   allocatable :: spebx,speby,spebz

! *** declaration pour la partie graphique

  data posfx,posfy/ 2.5,13.2/
  data sizfx,sizfy/15., 8.6/
  data decay /0.40/
  data tclab,tctit,tccom /0.35,0.45,0.27/
  data titpan/'Log Power Spectral Density'/
  data nbgma,nbpma /24,24/


  print*, '------------------------------------------------------------'
  print*, 'visu_ave_spectrum  : Visualize average spectrum'
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF SP file to read ? (ex: toto_GSE.rff)'
  read(*,'(a)') SP_file
  print*, trim(SP_file)

  print*,'datiso1 ? ex:2020-02-05T15:00:00.000000Z'
  read(*,'(a)') datiso1
  print*, trim(datiso1)


  print*,'datiso2 ? ex:2020-02-08T05:32:00.000000Z'
  read(*,'(a)') datiso2
  print*, trim(datiso2)

  print*, 'f1,f2?  (ex: 1. 12.)'
  read *, f1,f2
  print*, f1,f2

  print*, 'logP1, logP2 ?  (ex: -6. -1., 0.=auto)'
  read *, p1imp,p2imp
  print*, p1imp,p2imp

  print*,'XY ? (ex: XY or LR)'
  read(*,'(a)') XY

  iSP=len(trim(SP_file))
  suff=SP_file(iSP-2:iSP)

  if(suff /= 'rff') then
     print*, ' ***file has not .rff suffix',suff
     stop 'visu_spectro.exe                : *** ERROR !! Program aborted !'
  ENDIF


  print*
  print*, '=================================='
  print*, '1) read  spectro file '
  print*, '=================================='


  call rff_R_file(1,SP_file)

  call check_meta

  nbspe=manda_param%block_number
  ncomp=manda_param%DATA_DIMENSION(1)
  nbfre=manda_param%DATA_DIMENSION(2)

  dt=real(optio_param%TIME_RESOLUTION)
  df=real(optio_param%FREQUENCY_RESOLUTION)

  write(*,*)
  write(*,*) 'SP_file: number of blocks =',nbspe
  write(*,*) 'SP_file: number of freq.  =',nbfre
  write(*,*) 'SP_file: data_index(    1)=',data_index(1)
  write(*,*) 'SP_file: data_index(nbspe)=',data_index(nbspe)
  write(*,*) 'SP_file: dt,  df          =',dt,df
  write(*,*)

  write(*,*)
  write(*,*) 'R_DATA_MATRIX(1,10,1)    =',R_DATA_MATRIX(1,10,1)
  write(*,*) 'R_DATA_MATRIX(1,10,nbspe)=',R_DATA_MATRIX(1,10,nbspe)

! select time period to extract

  if(datiso1(1:1) == '0') datiso1=data_index(1)
  if(datiso2(1:1) == '0') datiso2=data_index(nbspe)

  if(datiso1 == datiso2) then
     datiso1=data_index(1)
     datiso2=data_index(nbspe)
  endif

  call check_datiso(datiso1)
  call check_datiso(datiso2)

  print*
  print*, 'datiso1 in the file:',data_index(1)
  print*, 'datiso1 in the file:',data_index(nbspe)
  print*
  print*, 'datiso1 asked:',datiso1
  print*, 'datiso2 asked:',datiso2

  nbspe2=0
  it1=1
  it2=nbspe

  do i=1,nbspe
     call compare_datiso(datiso1,data_index(i),icomp1)
     call compare_datiso(datiso2,data_index(i),icomp2)

     if((icomp1 == -1) .or. (icomp2 == 1)) cycle
     nbspe2=nbspe2 +1
     if(nbspe2 == 1) it1=i
     it2=i
  end do

  print*,'nbspe, it1,it2,nbspe2=',nbspe,it1,it2,nbspe2
  print*, 't1=',data_index(it1),'  t2=',data_index(it2)
  print*

! calcul des indices pour les frequences et les puiss integrees

  call  co_ind

  print*,'alloc dynamique avec nbspe2,nbfre=',nbspe2,nbfre
  print*,'depuis co_ind: if1,if2=',if1,if2

  allocate(spebx(nbspe2,nbfre))
  allocate(speby(nbspe2,nbfre))
  allocate(spebz(nbspe2,nbfre))

  allocate(freq(nbfre))
  allocate(puix(nbfre))
  allocate(puiy(nbfre))
  allocate(puiz(nbfre))
  allocate(work(nbfre))

  do i=1,nbfre
     freq(i)=(i-1)*df
  end do

  print*
  print*, '=================================='
  print*, '2) Load data '
  print*, '=================================='

  print*,'calcul du titre droit et de la date'

  call decode_datiso(data_index(1),iyear,imon,iday,ih,im,is,ims,imc)
  call codoty(imon,iday,iyear,idoty1)
  call cdattit_(iyear,imon,iday,titright)
  print*, 'titright=',titright

  print*, 'chargement du temps et des vecteurs, avec reduction eventuelle des donnees'

  call load_data
  call check_meta

  if(nbvec /= nbspe2) then
                      print*, 'nbvec =',nbvec
                      print*, 'nbspe2=',nbspe2
                      print*, 'nbvec not egal to nbspe2'
                      stop 'visu_spectro.exe                 : *** ERROR !! Program aborted !'
  endif

  print*
  print*, '====================================================='
  print*, 'ouverture du fichier graphique, cadre et mise en page'
  print*, '====================================================='

  psfile=SP_file(1:iSP-4)//'_ave_spe.ps'

  call dopegra_(7,psfile)
  call gpagsiz_(pagsx,pagsy)

  mission=manda_param%MISSION_NAME
  write(csatnum,'(i1)') manda_param%OBSERVATORY_NUMBER
  experi= manda_param%EXPERIMENT_NAME
  br    = manda_param%EXPERIMENT_MODE

  titleft=trim(mission)//"-"//trim(csatnum)//'/'//trim(experi)
  tcl=0.4
  tcr=0.35
  call gasdati_(dati26)
  RPC_version=give_RPC_version()
  signat='RoGraLib plot -'//' '//psfile(1:iSP+7)//" - "//RPC_version(1:8)

  print*,'plot du cadre avec titre gauche et droit, signature et date'

  call plotframe(titleft,tcl,titright,tcr,signat)

  print*,manda_param%DATA_LABEL
  units  =manda_param%DATA_UNITS(1:2)
  rep    =manda_param%DATA_COORDINATE_SYSTEM

  laby(1)=manda_param%DATA_LABEL(1:2)
  laby(2)=manda_param%DATA_LABEL(13:14)
  laby(3)=manda_param%DATA_LABEL(25:26)
  B      =manda_param%DATA_LABEL(1:1)
  titspe =trim(optio_param%TITLE)//'  -  '//trim(optio_param%SUB_TITLE)

  if(XY=='LR') then
               laby(1)=laby(1)(1:1)//'L'
               laby(2)=laby(2)(1:1)//'R'
  endif

  print*,'plot des titres  et label specifiques de la page'

  fs    =real(const_data%SPIN_PERIOD)
  srasc=const_data%SPIN_GEI_RIGHT_ASCENSION
  sdec =const_data%SPIN_GEI_DECLINATION
  fc   =const_data%FREQUENCY_CUT_OFF

  titpan=trim(titpan)//' ('//trim(units)//'^2/Hz )'
  call plot_tit_spectro_(nbspe2,f1,f2,fc,fs,dt,df,sdec,srasc,titpan,titspe,tctit,tccom)


!     plot heure debut et heure fin
!     ---------------------------------------------------------------+--

  yy=posfy+sizfy+1.1

  call ppagcha_(2.,yy,-1,tccom,tccom,0.,'Starting time: '//datiso1)
  yy=yy-1.6*tccom
  call ppagcha_(2.,yy,-1,tccom,tccom,0.,'Ending  time: '//datiso2)

!     plot des 3 spectres moyens
!     ---------------------------------------------------------------+--

  labx=' '
  linlog=0
  print*,'nbfre2=',nbfre2

  call plot_ave_spe

  posfy=posfy-sizfy-1.4
  labx='Frequency (Hz)'
  linlog=1

  call plot_ave_spe

!     fermeture du fichier ps
!     ---------------------------------------------------------------+--

  call dclogra_

  print*, 'visu_ave_spectrum.exe            : NORMAL TERMINATION'
     stop 'visu_ave_spectrum.exe            : NORMAL TERMINATION'

!-------------------------------------------------------------------+-
  contains
!-------------------------------------------------------------------+-
  subroutine co_ind

  print*, 'calcul des indices pour les frequences '

  if(f1.lt.0.) f1=0.
  if(f2.lt.1.e-10) f2=nbfre*df

  if1=int(f1/df +0.5)
  if2=int(f2/df +0.5)+1

  if(if1.lt.1) if1=1
  if(if2.gt.nbfre) if2=nbfre

  nbfre2= if2-if1+1

  print*,'co_ind: nbspe2,nbfre2=',nbspe2,nbfre2
  print*,'co_ind: f1, f2, if1,if2=',f1, f2, if1,if2

  end subroutine co_ind

! -------------------------------------------------------------------+--

  subroutine load_data

  complex (kind=4) :: ci,sx,sy

  ci=CMPLX(0,1.)

  read(manda_param%DATA_FILL_VALUE,*) filval

  nbvec=0

  print*
  print*,'load_data: it1,it2,nbspe2  =',it1,it2,nbspe2
  print*,'load_data: t1=',data_index(it1),'  t2=',data_index(it2)
  print*,'load_data: if1,if2,f1, f2  =',if1,if2,f1,f2,'  nbfre2=',nbfre2


  do i=it1,it2

     nbvec=nbvec+1

     if(XY == 'LR' ) then
       do j=1,nbfre

         sx=cmplx(R_DATA_MATRIX(1,j,i), R_DATA_MATRIX(2,j,i))
         sy=cmplx(R_DATA_MATRIX(3,j,i), R_DATA_MATRIX(4,j,i))

         R_DATA_MATRIX(1,j,i)= REAL(conjg(sx) + ci*conjg(sy))/2.
         R_DATA_MATRIX(2,j,i)=AIMAG(conjg(sx) + ci*conjg(sy))/2.

         R_DATA_MATRIX(3,j,i)= REAL(sx + ci*sy)/2.
         R_DATA_MATRIX(4,j,i)=AIMAG(sx + ci*sy)/2.

       end do
     endif

     spebx(nbvec,1:nbfre)=(R_DATA_MATRIX(1,:,i)**2 +R_DATA_MATRIX(2,:,i)**2)/df
     speby(nbvec,1:nbfre)=(R_DATA_MATRIX(3,:,i)**2 +R_DATA_MATRIX(4,:,i)**2)/df
     spebz(nbvec,1:nbfre)=(R_DATA_MATRIX(5,:,i)**2 +R_DATA_MATRIX(6,:,i)**2)/df

  end do
  
  puix(:)=0.
  puiy(:)=0.
  puiz(:)=0.
  
  do i=1,nbvec
     puix(:)=puix(:) +spebx(i,:)*df
     puiy(:)=puiy(:) +speby(i,:)*df
     puiz(:)=puiz(:) +spebz(i,:)*df
  enddo

  deallocate(data_index)
  deallocate(R_DATA_MATRIX)

  end subroutine load_data

! -------------------------------------------------------------------+--

  subroutine check_meta

  print*, "check metadata"

  IF(manda_param%FILE_CLASS /= 'Spectrogram') THEN
     write(*,*) '*** Only Spectrogram FILE_CLASS is allowed'
     stop 'visu_ave_spectrum.exe            : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_TYPE /= 'FLT') THEN
     write(*,*) '*** Only FLT DATA_TYPE is allowed'
     stop 'visu_ave_spectrum.exe            : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%INDEX_UNITS /= 'ISO_TIME') THEN
     write(*,*) '*** Only ISO_TIME INDEX_UNITS is allowed'
     stop 'visu_ave_spectrum.exe            : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_FORM /= 'Matrix') THEN
     write(*,*) '*** Only Matrix DATA_FORM is allowed'
     stop 'visu_ave_spectrum.exe            : *** ERROR !! Program aborted !'
  ENDIF


  print*, "OK"

  end subroutine check_meta

! -------------------------------------------------------------------+--

  subroutine plot_ave_spe

  character*8 forgx

  print*
  print*,'Plot des spectres moyens, linlog=',linlog

  call dfigsiz_(sizfx,sizfy)
  call dfigori_(posfx,posfy)

  call dlinwid_(2.5)
  call dfontyp_('h')
  call dtitsiz_(tctit)
  call dgrasiz_(0.35,0.35)
  call dstipos_('oi','ii')

  print*
  print*, 'calcul des graduations X'

  call pfigfra_

  print*,'f1,f2=',f1,f2
  print*,'df,2*df=',df,2.*df


  if(linlog == 0 ) then
     call cfiggra_(f1,f2,xmin,xmax,bgx,sgx,forgx)
     call dfiglimx(xmin,xmax)
     call pfiggrax(0.,bgx,sgx,forgx)
                   else
     call dgrastyx(1)
     call cfiggral(df,f2,xmin,xmax)
     call dfiglimx(xmin,xmax)
     call pfiggrlx(1)
  endif
  
  print*, 'xmin,xmax=',xmin,xmax
  
  print*
  print*, 'calcul des graduations Y'
  
  print*, 'pui  voulues:'
  print*, 'p1imp,p2imp,=',p1imp,p2imp
  
  axmin= 1.e20
  axmax=-1.e20
  aymin= 1.e20
  aymax=-1.e20
  azmin= 1.e20
  azmax=-1.e20

  do i=1,nbfre2
  
  if(puix(i) > 0.) then
     axmin=min(axmin,puix(i))
     axmax=max(axmax,puix(i))
  endif
  
  if(puiy(i) > 0.) then
     aymin=min(aymin,puiy(i))
     aymax=max(aymax,puiy(i))
  endif
  
  if(puiz(i) > 0.) then
     azmin=min(azmin,puiz(i))
     azmax=max(azmax,puiz(i))
  endif
  
  enddo


  y1c=min(axmin,aymin,azmin)
  y2c=max(axmax,aymax,azmax)

  print*
  print*, 'pui computed:'
  print*, 'y1c,y2c=',y1c,y2c,' soit ',log10(y1c+1.e-30),log10(y2c+1.e-30)
  
  if(abs(p1imp-p2imp) < 1.) then
      y1=y1c
      y2=y2c
                            else
      y1=10.**p1imp
      y2=10.**p2imp
  endif

  print*, 'taken: '
  print*, 'y1,y2  =',y1,y2,' soit ',log10(y1+1.e-30),log10(y2+1.e-30)
  print*

  call dgrastyy(1)
  call cfiggral(y1,y2,ymin,ymax)
  call dfiglimy(ymin,ymax)
  call pfiggrly(1)

  print*, 'pour les axes:',ymin,ymax
  print*, 'plot, if1,if2,nbfre2=',if1,if2,nbfre2
  
  where (puix <= 0.)
            puix=ymin
  end where
   
  where (puiy <= 0.)
            puiy=ymin
  end where
    
  where (puiz <= 0.)
            puiz=ymin
  end where
  
  print*,'pui <= 0 set to ymin'
  
   
  where (puix > ymax)
            puix=ymax
  end where
   
  where (puiy > ymax)
            puiy=ymax
  end where
    
  where (puiz > ymax)
            puiz=ymax
  end where
  
  print*,'pui > ymax set to ymax'
    
  if(linlog==1 .and. if1==1) then
     if1=2
     nbfre2=nbfre2-1
  endif
  
  call dlincol_('r')
  call pfigcur_(freq(if1:if2),puix(if1:if2),nbfre2)

  call dlincol_('g')
  call pfigcur_(freq(if1:if2),puiy(if1:if2),nbfre2)

  call dlincol_('b')
  call pfigcur_(freq(if1:if2),puiz(if1:if2),nbfre2)

  call dlincol_('n')

  print*,'Plot des labels'

  xx=0.6
  yy=posfy+sizfy/2.
  call ppagcha_(xx,yy,0,tclab,tclab,90.,'Log Power, (nT)^2/Hz')

  call ppagcha_(posfx+sizfx/2.,posfy-1.4,0,tclab,tclab,0.,labx)

  call dlincol_('r')
  xx=posfx+sizfx+0.5
  yy=posfy+sizfy/4.
  call ppagcha_(xx,yy,0,tclab,tclab,90.,trim(laby(1)))

  yy=yy+2.
  call dlincol_('g')
  call ppagcha_(xx,yy,0,tclab,tclab,90.,trim(laby(2)))

  yy=yy+2.
  call dlincol_('b')
  call ppagcha_(xx,yy,0,tclab,tclab,90.,trim(laby(3)))
  call dlincol_('n')
  return

  end subroutine plot_ave_spe

! -------------------------------------------------------------------+--

  END program visu_ave_spectrum

!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  subroutine plot_tit_spectro_(nbp,f1,f2,fc,fs,dt,df,sdec,srasc,titpan,titspe,tctit,tccom)

!     ---------------------------------------------------------------+--
!     plot des titres et parametres
!     ---------------------------------------------------------------+--

  character*140 work
  character*(*) titpan
  character*(*) titspe

  character*120 form
  character*12 fornbp

  call gpagsiz_(pagsx,pagsy)
  call gfigsiz_(sizfx,sizfy)

  print*, 'plot des titres et parametres...'
  print*, 'nbp,f1,f2,fc,fs,dt,df=',nbp,f1,f2,fc,fs,dt,df

  call dfontyp_('h')

! *   titre general

  call ppagcha_(4.8,pagsy-2.8,-1,tctit,tctit,0.,trim(titpan))

! *   titre de l'ensemble des pannels

  call ppagcha_(2.,pagsy-3.5,-1,tccom,tccom,0.,trim(titspe))

! *   Nbp, dt, etc.

  call cbesfori(nbp,fornbp)

  form='("N=",'//fornbp//',"  dt=",f12.6," s df=",f8.5," Hz  Fc=",f10.6," F1=",f10.6," F2=",f10.4)'
  write(work,form)nbp,dt,df,fc,f1,f2
  call ppagcha_(2.,pagsy-3.9,-1,tccom,tccom,0.,trim(work))
  print*, trim(work)

! *   Spin Rasc,dec

  if(abs(sdec) .gt.360. .or. abs(srasc) .gt. 360. .or. abs(fs) .gt. 10.) return
  if(abs(sdec) .gt.0. .and. abs(srasc).gt.0. .and. abs(fs).gt.0.) then

      work='S_dec    S_rasc     S_freq'
      call ppagcha_(0.3,pagsy-2.3,-1,tccom,tccom,0,trim(work))
      print*, trim(work)

      form='(f7.2,"  ",f7.2,"   ",f8.6)'
      write(work,form)sdec,srasc,fs
      call ppagcha_(0.2,pagsy-2.7,-1,tccom,tccom,0.,trim(work))
      print*, trim(work)

  endif

  return
  END

!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
