!
  program visu_curl_div_4sat
!
! --------------------------------------------------------------------+--
! Lecture d'un fichier compute_curl_div_4sat.resu et
! Creation du postscript visu_curl_div_4sat.ps
!
! P. Robert, CETP, Juin 2005, revu P. Robert, ScientiDev, Feb. 2021
! --------------------------------------------------------------------+--


  character(len=8)   :: titgra(24)
  character(len=64)  :: give_RPC_version,titleft,titright,RPC_version,forgy,titpar(20),tit
  character(len=255) :: psfile,signat, cocufile
  character(len=120) :: dati26
  character(len=27)  :: datiso1,datiso2,datiso11,datiso12

  real(kind=4) :: valgra(24)

  real(kind=4), dimension(:),   allocatable :: time,datadiv,dataajb,datarcu,work1,work2,work3,work4
  real(kind=4), dimension(:,:), allocatable :: datamag,datapos,datagra,dataden
  real(kind=4), dimension(:,:), allocatable :: datacur,dataepl, datadis, databmo,datanor,datanpo

  character(len=64) :: tstart,bid,rep,mission,experi


! Initialisation des variables graphiques
!
  data posfx /3.0/
  data sizfx /15./
  data decay /0.25/
  data nbgma,nbpma /24,24/

  print*, '------------------------------------------------------------------------ '


  print*,'datiso1 ? ex:2020-02-05T15:00:00.000000Z'
  read(*,'(a)') datiso1
  print*, trim(datiso1)

  print*,'datiso2 ? ex:2020-02-08T05:32:00.000000Z'
  read(*,'(a)') datiso2
  print*, trim(datiso2)
  
! --------------------------------
! Lecture du fichier compute_curl_div_4sat.resu
! --------------------------------

  call  lect_cocurldiv

  do i=1,20
     j=index(titpar(i),':')
     titpar(i)=titpar(i)(j+1:)
  end do
  
! ----------------------------------------
! initialisation des parametres graphiques
! ----------------------------------------

  tctit=0.35
  tgra=0.35
  tclab=0.3
  tclab2=0.25
  xlab=0.5

! ---------------------------------------------------
! calcul des bornes et graduations en temps
! ---------------------------------------------------

  print*,'bornes en temps et en frequence'

  t1= time(1)
  t2= time(nbp)
  
  call codecsecinv(t1*3600.,nbday,ih,im,is,ims,imc)
  call encode_datiso(iyear,imon,iday,ih,im,is,ims,imc,datiso11)
  
  call codecsecinv(t2*3600.,nbday,ih,im,is,ims,imc)
  call encode_datiso(iyear,imon,iday,ih,im,is,ims,imc,datiso12)
  
  write(*,*)
  write(*,*) 'select time period to extract'

  if(datiso1(1:1) == '0') datiso1=datiso11
  if(datiso2(1:1) == '0') datiso2=datiso12

  if(datiso1 == datiso2) then
     datiso1=datiso11
     datiso2=datiso12
  endif

  print*, 'datiso1=',datiso1
  print*, 'datiso2=',datiso2

  call check_datiso(datiso1)
  call check_datiso(datiso2)

  print*
  print*, 'datiso1 in the file:',datiso11
  print*, 'datiso1 in the file:',datiso12
  print*
  print*, 'datiso1 asked:',datiso1
  print*, 'datiso2 asked:',datiso2  
  

  print*, 't1,t2 in the file(s)=',t1,t2
  
  call decode_datiso(datiso1,iyear,imon,iday,ih,im,is,ims,imc)
  t1=float(ih) +float(im)/60. +float(is)/3600. +float(ims)/3600000.
  
  call decode_datiso(datiso2,iyear,imon,iday,ih,im,is,ims,imc)
  t2=float(ih) +float(im)/60. +float(is)/3600. +float(ims)/3600000.

  print*, 't1,t2 taken      (s)=',t1,t2
  
! calcul des indices pour t1 t2

  do i=1,nbp-1
    if(time(i) < t1 .and. time(i+1) > t1) i1=i
    if(time(i) < t2 .and. time(i+1) > t2) i2=i+1
  end do
  
  if(i1 < 1) i1=1
  if(i2 <1 ) i2=nbp
  if(i2 > nbp) i2=nbp
  
  nbp_r= i2-i1+1
  
  print*, 'i1,i2,nbp,nbp_r=',i1,i2,nbp,nbp_r
  print*
  print*, 'calcul des graduations horaire'

  call cfiggrah(t1,t2,valgra,titgra,valdt,nbgma,nbpma)

  print*, 'nb G. marques=',nbgma
  print*, 'nb P. marques=',nbpma
  print*, 'val. grad.=',(valgra(i),i=1,nbgma)
  
! --------------------------------------------------------------------+--  
! definition commune pour les deux graphiques
! --------------------------------------------------------------------+--
  
  titleft=trim(mission)//' / '//trim(experi)//' / Curl & Div - '//trim(rep)
  tcl=0.4
  tcr=0.35
  call gasdati_(dati26)
  RPC_version=give_RPC_version()
  call cdattit_(iyear,imon,iday,titright)
      
  allocate(work1(nbp))
  allocate(work2(nbp))
  allocate(work3(nbp))
  allocate(work4(nbp))
  
! --------------------------------------------------------------------+--
! ouverture du fichier graphique #1 et mise en page
! --------------------------------------------------------------------+--  

  psfile='visu_mag_pos_4sat.ps'
  signat='RoGraLib plot -'//' '//trim(psfile)//" - "//RPC_version(1:8)

  call dopegra_(7,psfile)
  call gpagsiz_(pagsx,pagsy)

  print*,'plot du cadre avec titre gauche et droit, signature et date'

  call plotframe(titleft,tcl,titright,tcr,signat)
! --------------------------------------------------------------------+-- 
! Positions
! --------------------------------------------------------------------+--  
  
  sizfy=2.8
  posfy=21.6
  tit='Positions, '//trim(rep)//' system'
  print*, trim(tit)

  call dfigsiz_(sizfx,sizfy)
  call dfigori_(posfx,posfy)
  
  call ppagcha_(posfx+sizfx/2.,posfy+sizfy+tctit+0.1,0,tctit,tctit,0.,tit)
  call ppagcha_(xlab,posfy+sizfy/2.,0,tclab,tclab,0.,'Px')

  call dlinwid_(2.)
  call dfontyp_('h')
  call dgrasiz_(0.0,0.3)
  call dstipos_('oi','ii')

  call dfiglimx(t1,t2)
  call dlincol_('n')  
  
  y1=min(minval(datapos(1,i1:i2)),minval(datapos(4,i1:i2)),minval(datapos(7,i1:i2)),minval(datapos(10,i1:i2)))
  y2=max(maxval(datapos(1,i1:i2)),maxval(datapos(4,i1:i2)),maxval(datapos(7,i1:i2)),maxval(datapos(10,i1:i2)))
  
  print*, 'y1,y2=',y1,y2

  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)

  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)

  call dlincol_('n')
  call pfigcur_(time(i1:i2),datapos( 1,i1:i2),nbp_r)
  call dlincol_('r')
  call pfigcur_(time(i1:i2),datapos( 4,i1:i2),nbp_r)
  call dlincol_('g')
  call pfigcur_(time(i1:i2),datapos( 7,i1:i2),nbp_r)
  call dlincol_('b')
  call pfigcur_(time(i1:i2),datapos(10,i1:i2),nbp_r)
  call dlincol_('n')
  
! --------------------------------------------------------------------+-- 
  posfy=posfy -sizfy -decay

  call dfigsiz_(sizfx,sizfy)
  call dfigori_(posfx,posfy)

  call ppagcha_(xlab,posfy+sizfy/2.,0,tclab,tclab,0.,'Py')

  call dlinwid_(2.)
  call dfontyp_('h')
  call dgrasiz_(0.0,0.3)
  call dstipos_('oi','ii')

  call dfiglimx(t1,t2)
  call dlincol_('n')  
  
  y1=min(minval(datapos(2,i1:i2)),minval(datapos(5,i1:i2)),minval(datapos(8,i1:i2)),minval(datapos(11,i1:i2)))
  y2=max(maxval(datapos(2,i1:i2)),maxval(datapos(5,i1:i2)),maxval(datapos(8,i1:i2)),maxval(datapos(11,i1:i2)))

  print*, 'y1,y2=',y1,y2
  
  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)

  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)

  call dlincol_('n')
  call pfigcur_(time(i1:i2),datapos( 2,i1:i2),nbp_r)
  call dlincol_('r')
  call pfigcur_(time(i1:i2),datapos( 5,i1:i2),nbp_r)
  call dlincol_('g')
  call pfigcur_(time(i1:i2),datapos( 8,i1:i2),nbp_r)
  call dlincol_('b')
  call pfigcur_(time(i1:i2),datapos(11,i1:i2),nbp_r)
  call dlincol_('n')  

! --------------------------------------------------------------------+-- 
  posfy=posfy -sizfy -decay

  call dfigsiz_(sizfx,sizfy)
  call dfigori_(posfx,posfy)

  call ppagcha_(xlab,posfy+sizfy/2.,0,tclab,tclab,0.,'Pz')

  call dlinwid_(2.)
  call dfontyp_('h')
  call dgrasiz_(0.0,0.3)
  call dstipos_('oi','ii')

  call dfiglimx(t1,t2)
  call dlincol_('n')  
  
  y1=min(minval(datapos(3,i1:i2)),minval(datapos(6,i1:i2)),minval(datapos(9,i1:i2)),minval(datapos(12,i1:i2)))
  y2=max(maxval(datapos(3,i1:i2)),maxval(datapos(6,i1:i2)),maxval(datapos(8,i1:i2)),maxval(datapos(12,i1:i2)))

  print*, 'y1,y2=',y1,y2
  
  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)

  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)

  call dlincol_('n')
  call pfigcur_(time(i1:i2),datapos( 3,i1:i2),nbp_r)
  call dlincol_('r')
  call pfigcur_(time(i1:i2),datapos( 6,i1:i2),nbp_r)
  call dlincol_('g')
  call pfigcur_(time(i1:i2),datapos( 9,i1:i2),nbp_r)
  call dlincol_('b')
  call pfigcur_(time(i1:i2),datapos(12,i1:i2),nbp_r)
  call dlincol_('n')  

! --------------------------------------------------------------------+-- 
  sizfy=1.7
  posfy=posfy -sizfy -decay

  call dfigsiz_(sizfx,sizfy)
  call dfigori_(posfx,posfy)

  call ppagcha_(xlab,posfy+sizfy/2.,0,tclab,tclab,0.,'R')

  call dlinwid_(2.)
  call dfontyp_('h')
  call dgrasiz_(0.0,0.3)
  call dstipos_('oi','ii')

  call dfiglimx(t1,t2)
  call dlincol_('n')  
  
  work1(i1:i2)=sqrt(datapos(1,i1:i2)**2  +datapos(2,i1:i2)**2  +datapos(3,i1:i2)**2)
  work2(i1:i2)=sqrt(datapos(4,i1:i2)**2  +datapos(5,i1:i2)**2  +datapos(6,i1:i2)**2)
  work3(i1:i2)=sqrt(datapos(7,i1:i2)**2  +datapos(8,i1:i2)**2  +datapos(9,i1:i2)**2)
  work4(i1:i2)=sqrt(datapos(10,i1:i2)**2 +datapos(11,i1:i2)**2 +datapos(12,i1:i2)**2)

  y1=min(minval(work1(i1:i2)),minval(work2(i1:i2)),minval(work3(i1:i2)),minval(work4(i1:i2)))
  y2=max(maxval(work1(i1:i2)),maxval(work2(i1:i2)),maxval(work3(i1:i2)),maxval(work4(i1:i2)))

  print*, 'y1,y2=',y1,y2
  
  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)

  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)

  call dlincol_('n')
  call pfigcur_(time(i1:i2),work1(i1:i2),nbp_r)
  call dlincol_('r')
  call pfigcur_(time(i1:i2),work2(i1:i2),nbp_r)
  call dlincol_('g')
  call pfigcur_(time(i1:i2),work3(i1:i2),nbp_r)
  call dlincol_('b')
  call pfigcur_(time(i1:i2),work4(i1:i2),nbp_r)
  call dlincol_('n')    
  
! --------------------------------------------------------------------+-- 
! Mag field
! --------------------------------------------------------------------+-- 
  sizfy=2.8
  posfy=posfy -sizfy -decay -0.8
  tit='B mag field, time aligned, '//trim(rep)//' system'
  print*, trim(tit)

  call dfigsiz_(sizfx,sizfy)
  call dfigori_(posfx,posfy)
  
  call ppagcha_(posfx+sizfx/2.,posfy+sizfy+tctit+0.1,0,tctit,tctit,0.,tit)
  call ppagcha_(xlab,posfy+sizfy/2.,0,tclab,tclab,0.,'Bx')

  call dlinwid_(2.)
  call dfontyp_('h')
  call dgrasiz_(0.0,0.3)
  call dstipos_('oi','ii')

  call dfiglimx(t1,t2)
  call dlincol_('n')  
  
  y1=min(minval(datamag(1,i1:i2)),minval(datamag(4,i1:i2)),minval(datamag(7,i1:i2)),minval(datamag(10,i1:i2)))
  y2=max(maxval(datamag(1,i1:i2)),maxval(datamag(4,i1:i2)),maxval(datamag(7,i1:i2)),maxval(datamag(10,i1:i2)))

  print*, 'y1,y2=',y1,y2
  
  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)

  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)

  call dlincol_('n')
  call pfigcur_(time(i1:i2),datamag( 1,i1:i2),nbp_r)
  call dlincol_('r')
  call pfigcur_(time(i1:i2),datamag( 4,i1:i2),nbp_r)
  call dlincol_('g')
  call pfigcur_(time(i1:i2),datamag( 7,i1:i2),nbp_r)
  call dlincol_('b')
  call pfigcur_(time(i1:i2),datamag(10,i1:i2),nbp_r)
  call dlincol_('n')
  
! --------------------------------------------------------------------+-- 
  posfy=posfy -sizfy -decay 
  
  call dfigsiz_(sizfx,sizfy)
  call dfigori_(posfx,posfy)

  call ppagcha_(xlab,posfy+sizfy/2.,0,tclab,tclab,0.,'By')

  call dlinwid_(2.)
  call dfontyp_('h')
  call dgrasiz_(0.0,0.3)
  call dstipos_('oi','ii')

  call dfiglimx(t1,t2)
  call dlincol_('n')  
  
  y1=min(minval(datamag(2,i1:i2)),minval(datamag(5,i1:i2)),minval(datamag(8,i1:i2)),minval(datamag(11,i1:i2)))
  y2=max(maxval(datamag(2,i1:i2)),maxval(datamag(5,i1:i2)),maxval(datamag(8,i1:i2)),maxval(datamag(11,i1:i2)))

  print*, 'y1,y2=',y1,y2
  
  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)

  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)

  call dlincol_('n')
  call pfigcur_(time(i1:i2),datamag( 2,i1:i2),nbp_r)
  call dlincol_('r')
  call pfigcur_(time(i1:i2),datamag( 5,i1:i2),nbp_r)
  call dlincol_('g')
  call pfigcur_(time(i1:i2),datamag( 8,i1:i2),nbp_r)
  call dlincol_('b')
  call pfigcur_(time(i1:i2),datamag(11,i1:i2),nbp_r)
  call dlincol_('n')  

! --------------------------------------------------------------------+-- 
  posfy=posfy -sizfy -decay

  call dfigsiz_(sizfx,sizfy)
  call dfigori_(posfx,posfy)

  call ppagcha_(xlab,posfy+sizfy/2.,0,tclab,tclab,0.,'Bz')

  call dlinwid_(2.)
  call dfontyp_('h')
  call dgrasiz_(0.,0.3)
  call dstipos_('oi','ii')

  call dfiglimx(t1,t2)
  call dlincol_('n')  
  
  y1=min(minval(datamag(3,i1:i2)),minval(datamag(6,i1:i2)),minval(datamag(9,i1:i2)),minval(datamag(12,i1:i2)))
  y2=max(maxval(datamag(3,i1:i2)),maxval(datamag(6,i1:i2)),maxval(datamag(8,i1:i2)),maxval(datamag(12,i1:i2)))

  print*, 'y1,y2=',y1,y2
  
  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)

  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)

  call dlincol_('n')
  call pfigcur_(time(i1:i2),datamag( 3,i1:i2),nbp_r)
  call dlincol_('r')
  call pfigcur_(time(i1:i2),datamag( 6,i1:i2),nbp_r)
  call dlincol_('g')
  call pfigcur_(time(i1:i2),datamag( 9,i1:i2),nbp_r)
  call dlincol_('b')
  call pfigcur_(time(i1:i2),datamag(12,i1:i2),nbp_r)
  call dlincol_('n')  

! --------------------------------------------------------------------+-- 
  sizfy=1.7
  posfy=posfy -sizfy -decay

  call dfigsiz_(sizfx,sizfy)
  call dfigori_(posfx,posfy)

  call ppagcha_(xlab,posfy+sizfy/2.,0,tclab,tclab,0.,'|B|')

  call dlinwid_(2.)
  call dfontyp_('h')
  call dgrasiz_(tgra,0.3)
  call dstipos_('oi','ii')

  call dfiglimx(t1,t2)
  call dlincol_('n')  
  
  work1(i1:i2)=sqrt(datamag(1,i1:i2)**2  +datamag(2,i1:i2)**2  +datamag(3,i1:i2)**2)
  work2(i1:i2)=sqrt(datamag(4,i1:i2)**2  +datamag(5,i1:i2)**2  +datamag(6,i1:i2)**2)
  work3(i1:i2)=sqrt(datamag(7,i1:i2)**2  +datamag(8,i1:i2)**2  +datamag(9,i1:i2)**2)
  work4(i1:i2)=sqrt(datamag(10,i1:i2)**2 +datamag(11,i1:i2)**2 +datamag(12,i1:i2)**2)

  y1=min(minval(work1(i1:i2)),minval(work2(i1:i2)),minval(work3(i1:i2)),minval(work4(i1:i2)))
  y2=max(maxval(work1(i1:i2)),maxval(work2(i1:i2)),maxval(work3(i1:i2)),maxval(work4(i1:i2)))

  print*, 'y1,y2=',y1,y2
  
  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)

  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)

  call dlincol_('n')
  call pfigcur_(time(i1:i2),work1(i1:i2),nbp_r)
  call dlincol_('r')
  call pfigcur_(time(i1:i2),work2(i1:i2),nbp_r)
  call dlincol_('g')
  call pfigcur_(time(i1:i2),work3(i1:i2),nbp_r)
  call dlincol_('b')
  call pfigcur_(time(i1:i2),work4(i1:i2),nbp_r)
  call dlincol_('n')    
  
  call ppagcha_(0.8,posfy-0.8,-1,0.4,0.4,0.,'UT')
  
!
! *** termine pour ce plot
!
  call dclogra_

! --------------------------------------------------------------------+--
! ouverture du fichier graphique #2 et mise en page
! --------------------------------------------------------------------+--

  psfile='visu_curl_div_4sat.ps'
  signat='RoGraLib plot -'//' '//trim(psfile)//" - "//RPC_version(1:8)

  call dopegra_(7,psfile)
  call gpagsiz_(pagsx,pagsy)

  print*,'plot du cadre avec titre gauche et droit, signature et date'

  call plotframe(titleft,tcl,titright,tcr,signat)

! --------------------------------------------------------------------+--

  sizfy=6.
  posfy=18.8
  decay=0.35

  call dfigsiz_(sizfx,sizfy)
  call dfigori_(posfx,posfy)
  
  call ppagcha_(xlab,posfy+sizfy/2.,0,tclab,tclab,90.,titpar(10))

  call dlinwid_(2.)
  call dfontyp_('h')
  call dgrasiz_(0.0,0.3)
  call dstipos_('oi','ii')

  call dfiglimx(t1,t2)
  
  work1(i1:i2)=sqrt(dataden(1,i1:i2)**2 +dataden(2,i1:i2)**2 +dataden(3,i1:i2)**2)

  y1=min(minval(dataden(:,i1:i2)),minval(work1(i1:i2)))
  y2=max(maxval(dataden(:,i1:i2)),maxval(work1(i1:i2)))

  print*, 'dataden'
  print*, 'y1,y2=',y1,y2

  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)

  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,bgy,sgy,forgy)

  call dlincol_('r')
  call pfigcur_(time(i1:i2),dataden(1,i1:i2),nbp_r)
  call dlincol_('g')
  call pfigcur_(time(i1:i2),dataden(2,i1:i2),nbp_r)
  call dlincol_('b')
  call pfigcur_(time(i1:i2),dataden(3,i1:i2),nbp_r)
  call dlincol_('n')
  
  call pfigcur_(time(i1:i2),work1(i1:i2),nbp_r)
  
! --------------------------------------------------------------------+--

  sizfy=3.
  posfy=posfy -sizfy -decay
  
  call dfigsiz_(sizfx,sizfy)
  call dfigori_(posfx,posfy)
  
  call ppagcha_(xlab,posfy+sizfy/2.,0,tclab,tclab,90.,titpar(18))

  call dlinwid_(2.)
  call dfontyp_('h')
  call dgrasiz_(0.0,0.3)
  call dstipos_('oi','ii')

  call dfiglimx(t1,t2)

  y1=minval(dataajb)
  y2=maxval(dataajb)

  print*, 'dataajb'
  print*, 'y1,y2=',y1,y2

  if(abs(y2-y1) < 1.e-30) then
                         y1=0.
                         y2=1.
  endif
  
  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)

  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,bgy,sgy,forgy)

  call pfigcur_(time(i1:i2),dataajb(i1:i2),nbp_r)
  
! --------------------------------------------------------------------+--

  sizfy=2.4
  posfy=posfy -sizfy -decay

  call dfigsiz_(sizfx,sizfy)
  call dfigori_(posfx,posfy)
  
  call ppagcha_(xlab,posfy+sizfy/2.,0,tclab2,tclab2,90.,titpar(12))

  call dlinwid_(2.)
  call dfontyp_('h')
  call dgrasiz_(0.0,0.3)
  call dstipos_('oi','ii')

  call dfiglimx(t1,t2)

  y1=minval(datadiv(i1:i2))
  y2=maxval(datadiv(i1:i2))

  print*, 'datadiv'
  print*, 'y1,y2=',y1,y2
  
  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)

  call dlinrgb_(1.,1.,0.8)
  call dfilzon_
  call pfiglin_(t1,ymin,t1,datadiv(1))
  call pfigcur_(time(i1:i2),datadiv(i1:i2),nbp_r)
  call pfiglin_(t2,datadiv(nbp_r),t2,ymin)
  call pfilzon_
  call dlincol_('n')
  call pfigcur_(time(i1:i2),datadiv(i1:i2),nbp_r)

  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,bgy,sgy,forgy)
  
! --------------------------------------------------------------------+--

  sizfy=2.4
  posfy=posfy -sizfy -decay

  call dfigsiz_(sizfx,sizfy)
  call dfigori_(posfx,posfy)
  
  call ppagcha_(xlab,posfy+sizfy/2.,0,tclab2,tclab2,90.,titpar(11))

  call dlinwid_(2.)
  call dfontyp_('h')
  call dgrasiz_(0.0,0.3)
  call dstipos_('oi','ii')

  call dfiglimx(t1,t2)
  
  work1(i1:i2)=sqrt(datacur(1,i1:i2)**2 +datacur(2,i1:i2)**2 +datacur(3,i1:i2)**2)

  y1=0.
  y2=maxval(work1(i1:i2))

  print*, 'datacur'
  print*, 'y1,y2=',y1,y2
  
  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)

  call dlinrgb_(1.,1.,0.8)
  call dfilzon_
  call pfiglin_(t1,ymin,t1,work1(1))
  call pfigcur_(time(i1:i2),work1(i1:i2),nbp_r)
  call pfiglin_(t2,work1(nbp_r),t2,ymin)
  call pfilzon_
  call dlincol_('n')
  call pfigcur_(time(i1:i2),work1(i1:i2),nbp_r)

  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,bgy,sgy,forgy)
  
! --------------------------------------------------------------------+--

  sizfy=2.4
  posfy=posfy -sizfy -decay

  call dfigsiz_(sizfx,sizfy)
  call dfigori_(posfx,posfy)
  
  call ppagcha_(xlab,posfy+sizfy/2.,0,tclab2,tclab2,90.,'|DivB|/|CurlB|')

  call dlinwid_(2.)
  call dfontyp_('h')
  call dgrasiz_(0.0,0.3)
  call dstipos_('oi','ii')

  call dfiglimx(t1,t2)
  
  work1(i1:i2)=abs(datadiv(i1:i2))/(work1(i1:i2)+1.e-30)
  
  y1=0.
  y2=maxval(work1(i1:i2))
  if(y2 > 2.5) y2=2.5

  print*, 'datadiv/curl'
  print*, 'y1,y2=',y1,y2
  
  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)

  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,bgy,sgy,forgy)

  call pfigcur_(time(i1:i2),work1(i1:i2),nbp_r)
  
! --------------------------------------------------------------------+--

  sizfy=2.4
  posfy=posfy -sizfy -decay

  call dfigsiz_(sizfx,sizfy)
  call dfigori_(posfx,posfy)
  
  call ppagcha_(xlab,posfy+sizfy/2.,0,tclab,tclab,90.,'E,P')

  call dlinwid_(2.)
  call dfontyp_('h')
  call dgrasiz_(0.0,0.3)
  call dstipos_('oi','ii')

  call dfiglimx(t1,t2)
  call dfiglimy(0.,1.)

  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,0.5,0.1,'(f3.1)')

  call dlincol_('r')
  call pfigcur_(time(i1:i2),dataepl(1,i1:i2),nbp_r)
  call dlincol_('g')
  call pfigcur_(time(i1:i2),dataepl(2,i1:i2),nbp_r)
  call dlincol_('n')

 
! --------------------------------------------------------------------+--

  sizfy=2.4
  posfy=posfy -sizfy -decay

  call dfigsiz_(sizfx,sizfy)
  call dfigori_(posfx,posfy)
  
  call ppagcha_(xlab,posfy+sizfy/2.,0,tclab,tclab,90.,'Dij')

  call dlinwid_(2.)
  call dfontyp_('h')
  call dgrasiz_(tgra,0.3)
  call dstipos_('oi','ii')

  call dfiglimx(t1,t2)
  
  y1=minval(datadis)
  y2=maxval(datadis)

  print*, 'datadis'
  print*, 'y1,y2=',y1,y2
  
  call cfiggra_(y1,y2,ymin,ymax,bgy,sgy,forgy)
  call dfiglimy(ymin,ymax)

  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,2.*bgy,2.*sgy,forgy)

  call dlincol_('r')
  call pfigcur_(time(i1:i2),datadis(1,i1:i2),nbp_r)
  call dlincol_('g')
  call pfigcur_(time(i1:i2),datadis(2,i1:i2),nbp_r)
  call dlincol_('b')
  call pfigcur_(time(i1:i2),datadis(3,i1:i2),nbp_r)
  call dlincol_('c')
  call pfigcur_(time(i1:i2),datadis(4,i1:i2),nbp_r)
  call dlincol_('m')
  call pfigcur_(time(i1:i2),datadis(6,i1:i2),nbp_r)
  call dlincol_('y')
  call pfigcur_(time(i1:i2),datadis(6,i1:i2),nbp_r)
  call dlincol_('n')  

  
  call ppagcha_(0.8,posfy-0.8,-1,0.4,0.4,0.,'UT')
!
! *** termine pour ce plot
!
  call dclogra_

  print*, 'visu_curl_div_4sat.exe           : NORMAL TERMINATION'
     stop 'visu_curl_div_4sat.exe           : NORMAL TERMINATION'

! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
contains
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
  subroutine lect_cocurldiv

! ======================================================================
! procedure lect_cocurldiv: lecture du fichier cocurldiv.resu
!
! P. Robert, CETP, Juin 2001 - traduction F90 P.R. Fev. 2021
! ======================================================================


  cocufile='compute_curl_div_4sat.resu'

  open(1,file=cocufile,iostat=istat)

  if(istat /= 0) then
     print*,'*** error on open file ',trim(cocufile)
     stop 'visu_curl_div_4sat.exe           : ***BAD TERMINATION'
  endif


! lecture de l'entete du fichier 
! -------------------------------

  tstart=' '
  bid   =' '
  rep   =' '

  print*, ' '
  print*, 'test of visu_curl_div_4sat.resu file header'

! test sur la 1ere ligne du fichier

  read(1,'(a)',iostat=istat) tstart
  if(istat /= 0) then
     print*,'*** error on reading file ',trim(cocufile)
     stop 'visu_curl_div_4sat.exe           : ***BAD TERMINATION'
  endif
  IF(tstart /= 'compute_curl_div_4sat.resu file type') THEN
     print*, ' ***file has not good header'
     stop 'visu_curl_div_4sat.exe          : *** ERROR !! Program aborted !'
  ENDIF

  print*, tstart

! lecture des parametres d'entete

  print*, ' '
  print*, 'read header parameter'
  print*, ' '

  mission='Unknown'
  experi='Unknown'


  read(1,'(a)') bid
  read(1,'(a)') mission
  read(1,'(a)') experi

  print*, trim(mission), trim(experi)

  read(1,'(a)') bid
  read(1,'(a)') bid
  read(1,'(a)') bid
  read(1,'(a)') bid
  read(1,'(a)') bid
  read(1,'(a)') bid

  read(1,*) ijul,iyear,imon,iday
  read(1,'(a)') rep
  read(1,*) nbp

  print*, 'Date/time=', iyear,imon,iday
  print*, 'title:',rep
  print*, 'nbp=',nbp

  allocate (time(nbp))
  allocate (datamag(12,nbp))
  allocate (datapos(12,nbp))
  allocate (datagra(12,nbp))
  allocate (dataden(3,nbp))
  allocate (datacur(3,nbp))
  allocate (datadiv(nbp))
  allocate (dataepl(2,nbp))
  allocate (datadis(6,nbp))
  allocate (databmo(3,nbp))
  allocate (datanor(3,nbp))
  allocate (dataajb(nbp))
  allocate (datanpo(3,nbp))
  allocate (datarcu(nbp))

  read(1,'(a)') bid
  read(1,'(a)') bid
  read(1,'(a)') bid

  do i=1,20
     read(1,'(a)') titpar(i)
  end do
  
  read(1,'(a)') bid

! lecture des donnees

  DO i=1,nbp
     read(1,*) time(i)
     read(1,*) datamag(1:3,i)
     read(1,*) datamag(4:6,i)
     read(1,*) datamag(7:9,i)
     read(1,*) datamag(10:12,i)

     read(1,*) datapos(1:3,i)
     read(1,*) datapos(4:6,i)
     read(1,*) datapos(7:9,i)
     read(1,*) datapos(10:12,i)

     read(1,*) datagra(1:3,i)
     read(1,*) datagra(4:6,i)
     read(1,*) datagra(7:9,i)
     read(1,*) datagra(10:12,i)

     read(1,*) dataden(1:3,i)
     read(1,*) datacur(1:3,i)
     read(1,*) datadiv(i)

     read(1,*) dataepl(1:2,i)
     read(1,*) datadis(1:3,i)
     read(1,*) datadis(4:6,i)

     read(1,*) databmo(1:3,i)
     read(1,*) datanor(1:3,i)

     read(1,*) dataajb(i)
     read(1,*) datanpo(1:3,i)
     read(1,*) datarcu(i)
  END DO

!  datadiv(:)=abs(datadiv(:))
  
  print*
  print*, 'dimension of data arrays:'
  print*
  print*, 'time    (decimal hours)          :', SIZE(time)
  print*, 'datamag (B mag field  4 S/C, nT) :', SIZE(datamag,1)
  print*, 'datapos (Positions of 4 S/C, km) :', SIZE(datapos,1)
  print*, 'datagra (gradients of B, nT/km)  :', SIZE(datagra,1)
  print*, 'dataden (current density, A/km2) :', SIZE(dataden,1)
  print*, 'datacur (Curl of B, nT/km)       :', SIZE(datacur,1)
  print*, 'datadiv (Divergence of B, nT/km) :', SIZE(datadiv,1)
  print*, 'dataepl (Elong., Plana, size km) :', SIZE(dataepl,1)
  print*, 'datadis (inter-spacecr. dist. km):', SIZE(datadis,1)
  print*, 'databmo (B average  barycen., nT):', SIZE(databmo,1)
  print*, 'datanor (J x B normalised vector):', SIZE(datanor,1)
  print*, 'dataajb (J,B angle) in degrees   :', SIZE(dataajb,1)
  print*, 'datanpo (Normale Osculator Plane):', SIZE(datanpo,1)
  print*, 'datarcu (Radius of curvature, km):', SIZE(datarcu,1)
  print*

   print*, 'lect_cocurldiv:'

   print*, 'nbp  =',nbp
   print*, 't1,t2=',time(1),time(nbp)
   print*
   print*,datamag(:,1)
   print*,datapos(:,1)
   print*,datagra(:,1)
   print*,dataden(:,1)
   print*,datacur(:,1)
   print*,datadiv(1)
   print*,dataepl(:,1)
   print*,datadis(:,1)
   print*,databmo(:,1)
   print*,datanor(:,1)
   print*,dataajb(1)
   print*,datanpo(:,1)
   print*,datarcu(1)

  close(1)

  RETURN
  END subroutine lect_cocurldiv

! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
  END program visu_curl_div_4sat
!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX