
  program visu_vectime

!----------------------------------------------------------------------!
! Object: Visualize a vectime.rff
! Author: P. Robert , ScientiDev, Feb. 2021
!----------------------------------------------------------------------!

  use rff_param_def
  use rff_data_def

  integer            :: nbloc, i

  character(len=255) :: VT_file,work,psfile,signat
  character(len=3)   :: suff
  character(len=1)   :: B
  character(len=120) :: laby(6),dati26,mission,experi,csatnum,label,units,rep
  character(len=8)   :: forgy,titgra(24)
  character(len=64)  :: give_RPC_version,titleft,titright,RPC_version
  character(len=27)  :: datiso1,datiso2

  real(kind=4)       :: y1(3),y2(3),valgra(24)
  real(kind=4),      dimension(:),     allocatable :: time,curve
  real(kind=4),      dimension(:,:),   allocatable :: vectime


  data posfx,posfy/ 3.0,20.6/
  data sizfx,sizfy/15., 3.3/
  data decay /0.3/
  data nbgma,nbpma /24,24/

!     ---------------------------------------------------------------+--

  print*, '------------------------------------------------------------'
  print*, 'visu_vectime  : Visualize a vectime.rff'
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF VT file to read ? (ex: toto_GSE.rff)'
  read(*,'(a)') VT_file
  print*, trim(VT_file)

  print*,'datiso1 ? ex:2020-02-05T15:00:00.000000Z'
  read(*,'(a)') datiso1
  print*, trim(datiso1)


  print*,'datiso2 ? ex:2020-02-08T05:32:00.000000Z'
  read(*,'(a)') datiso2
  print*, trim(datiso2)

  ivt=len(trim(VT_file))
  suff=VT_file(ivt-2:ivt)

  if(suff /= 'rff') then
     print*, ' ***file has not .rff suffix',suff
     stop 'visu_vectime.exe                : *** ERROR !! Program aborted !'
  ENDIF

! *** lecture du vectime.rff

  print*
  print*, '=================================='
  print*, '1) read  vectime file '
  print*, '=================================='


  call rff_R_file(1,VT_file)

  call check_meta

  nbloc=manda_param%block_number

  write(*,*)
  write(*,*) 'VT_file: number of blocks =',nbloc
  write(*,*) 'VT_file: data_index(    1)=',data_index(1)
  write(*,*) 'VT_file: data_index(nbloc)=',data_index(nbloc)

  write(*,*)
  write(*,*) ' select time period to extract'

  if(datiso1(1:1) == '0') datiso1=data_index(1)
  if(datiso2(1:1) == '0') datiso2=data_index(nbloc)
    
  if(datiso1 == datiso2) then
     datiso1=data_index(1)
     datiso2=data_index(nbloc)
  endif

  call check_datiso(datiso1)
  call check_datiso(datiso2)

  print*
  print*, 'datiso1 in the file:',data_index(1)
  print*, 'datiso1 in the file:',data_index(nbloc)
  print*
  print*, 'datiso1 asked:',datiso1
  print*, 'datiso2 asked:',datiso2

  nbloc2=0
  it1=1
  it2=nbloc

  do i=1,nbloc
     call compare_datiso(datiso1,data_index(i),icomp1)
     call compare_datiso(datiso2,data_index(i),icomp2)

     if((icomp1 == -1) .or. (icomp2 == 1)) cycle
     nbloc2=nbloc2 +1
     if(nbloc2 == 1) it1=i
     it2=i
  end do

  print*,'nbloc, it1,it2,nbloc2=',nbloc,it1,it2,nbloc2
  print*

  allocate(vectime(6,nbloc2))
  allocate(time(nbloc2))
  allocate(curve(nbloc2))

  print*
  print*, '=================================='
  print*, '2) Load data '
  print*, '=================================='

  if(datiso1(1:1) == '0') datiso1=data_index(1)
  if(datiso2(1:1) == '0') datiso2=data_index(nbloc)

  print*,'calcul du titre droit et de la date'

  call decode_datiso(data_index(1),iyear,imon,iday,ih,im,is,ims,imc)
  call codoty(imon,iday,iyear,idoty1)
  call cdattit_(iyear,imon,iday,titright)
  print*, 'titright=',titright

  print*, 'chargement du temps et des vecteurs, avec reduction eventuelle des donnees'

  call load_data
  call check_meta

  print*, 'nbvec=',nbvec
!     --------------------------------------------------------------+--
! *** ouverture du fichier graphique, cadre et mise en page
!     --------------------------------------------------------------+--


  psfile=VT_file(1:ivt-4)//'.ps'

  tclab=0.35
  tctit=0.35
  tccom=0.25

  y1(:)=0.
  y2(:)=0.

  print*, 'Ouverture du fichier PS'

  call dopegra_(1,psfile)

  print*, 'Trace les variables du plot'

  mission=manda_param%MISSION_NAME
  write(csatnum,'(i1)') manda_param%OBSERVATORY_NUMBER
  experi= manda_param%EXPERIMENT_NAME

  titleft=trim(mission)//"-"//trim(csatnum)//'/'//trim(experi)
  tcl=0.4
  tcr=0.35
  call gasdati_(dati26)
  RPC_version=give_RPC_version()
  signat='RoGraLib plot -'//' '//trim(psfile)//" - "//RPC_version(1:8)

  print*,'plot du cadre avec titre gauche et droit, signature et date'

  call plotframe(titleft,tcl,titright,tcr,signat)

! *** initialisation des parametres des 6 figures

  call dfigsiz_(sizfx,sizfy)
  call dfigori_(posfx,posfy)

  call dlinwid_(2.5)
  call dfontyp_('h')
  call dtitsiz_(tctit)
  call dgrasiz_(0.0,0.3)
  call dstipos_('ii','ii')

! *** extension du vectim a 6 composantes (cartesian + spherical)

  call extend(vectime,nbvec)

  laby(1)=manda_param%DATA_LABEL(1:2)
  laby(2)=manda_param%DATA_LABEL(6:7)
  laby(3)=manda_param%DATA_LABEL(11:12)
  B      =manda_param%DATA_LABEL(1:1)
  laby(4)='|'//B//'|'
  laby(5)='Theta'
  laby(6)='Phi'

  print*, 'plot du titre'

  work=trim(optio_param%TITLE)//'  -  '//trim(optio_param%SUB_TITLE)

  call cchalen_(work,nw)
  call pfigtit_(work(1:nw))

  print*,'plot du commentaire haut gauche'

  dt =real(optio_param%TIME_RESOLUTION)/3600.
  write(work,"(a,i9,a,e12.3)") "Nb. Pts= ",nbvec,"    <dt> =",dt

  call cchalen_(work,nw)
  call ppagcha_(0.5,posfy+sizfy+1.0,-1,tccom,tccom,0.,work(1:nw))

  print*, 'calcul des graduations horaire'

  t1=time(1)
  t2=time(nbvec)

  call cminmax_(time,nbvec,t1,t2)

  print*, 't1,t2=',t1,t2

  call cfiggrah(t1,t2,valgra,titgra,valdt,nbgma,nbpma)
  call dfiglimx(t1,t2)

  print*, 'nb G. marques=',nbgma
  print*, 'nb P. marques=',nbpma
  print*, 'val. gard.=',(valgra(i),i=1,nbgma)

  print*, 'plot des 6 pannels'

  do 10 nco=1,6

  if(nco.gt.1) posfy=posfy-sizfy-decay
  if(nco.eq.4) posfy=posfy-0.7

  call dfigori_(posfx,posfy)

  curve(:)=vectime(nco,:)

! *   bornes imposees ou automatiques

  if(nco.le.3) then
       if(y2(nco).gt.y1(nco)) then
               y1min=y1(nco)
               y1max=y2(nco)
                              else
               call cminmax_(curve,nbvec,y1min,y1max)
       endif
               else
       call cminmax_(curve,nbvec,y1min,y1max)
  endif

  call cfiggra_(y1min,y1max,ymin,ymax,bgy,sgy,forgy)

  call dfiglimy(ymin,ymax)

  if(nco == 6) call dstipos_('oi','ii')
  if(nco == 4) call pfigtit_('Spherical components')

  call pfigfra_
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call pfiggray(0.,bgy,sgy,forgy)
  call pfigcur_(time,curve,nbvec)
  call cchalen_(laby(nco),nl)
  call ppagcha_(0.5,posfy+sizfy/2.,-1,tclab,tclab,0.,laby(nco)(1:nl))

   10 continue

! *** re-plot des graduations horaire du bas avec valeurs

  call dgrasiz_(0.4,0.3)
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)

! *** termine, fermeture du fichier graphique

  call dclogra_

  print*, 'visu_vectime.exe                 : NORMAL TERMINATION'
     stop 'visu_vectime.exe                 : NORMAL TERMINATION'

!-------------------------------------------------------------------+--
  contains

!-------------------------------------------------------------------+--

  subroutine check_meta

  print*, "check metadata"

  IF(manda_param%FILE_CLASS /= 'VecTime') THEN
     write(*,*) '*** Only VecTime FILE_CLASS is allowed'
     stop 'visu_vectime.exe                : *** ERROR !! Program aborted !'
  ENDIF

!  IF(manda_param%DATA_TYPE /= 'FLT') THEN
!     write(*,*) '*** Only FLT DATA_TYPE is allowed'
!     stop 'visu_vectime.exe                : *** ERROR !! Program aborted !'
!  ENDIF

  IF(manda_param%INDEX_UNITS /= 'ISO_TIME') THEN
     write(*,*) '*** Only ISO_TIME INDEX_UNITS is allowed'
     stop 'visu_vectime.exe                : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_FORM /= 'Vector') THEN
     write(*,*) '*** Only Vector DATA_FORM is allowed'
     stop 'visu_vectime.exe                : *** ERROR !! Program aborted !'
  ENDIF

  print*, "OK"

  end subroutine check_meta

!-------------------------------------------------------------------+--

  subroutine load_data
  
  print*, 'filval=',trim(manda_param%DATA_FILL_VALUE)
  read(manda_param%DATA_FILL_VALUE,*) filval

  print*,'load_data: filval =',filval
  print*,'load_data: it1,it2=',it1,it2
  
  idim1=manda_param%DATA_DIMENSION(1)
  
  IF(manda_param%DATA_TYPE == 'INT') R_data_vector=float(I_data_vector)
  
  nbvec=0

  do i=it1,it2

     if(abs(R_data_vector(1,i)-filval) .lt. 1.e-30) cycle
     if(abs(R_data_vector(2,i)-filval) .lt. 1.e-30) cycle
     if(abs(R_data_vector(3,i)-filval) .lt. 1.e-30) cycle

     nbvec=nbvec+1

     call decode_datiso(data_index(i),iyear,imon,iday,ih,im,is,ims,imc)
     call codoty(imon,iday,iyear,idoty)
     if(i == it1) idoty1=idoty
     nbday=idoty-idoty1
     call codecsec(nbday,ih,im,is,ims,imc,decsec)

     time(nbvec)=decsec/3600.

     vectime(1,nbvec)=R_data_vector(1,i)
     vectime(2,nbvec)=R_data_vector(2,i)
     vectime(3,nbvec)=R_data_vector(3,i)
  end do

  deallocate(data_index)
  deallocate(R_data_vector)

! conversion en cartesien si donnée en lat,lon,dist

  label=manda_param%DATA_LABEL
  units=manda_param%DATA_UNITS
  rep  =manda_param%DATA_COORDINATE_SYSTEM

  print*
  print*, 'label=',label
  print*, 'units=',units

  IF((label == 'Latitude ; Longitude ; Distance') .and. (units == 'degree ; degree ; km')) THEN
    print*
    print*, 'conversion spherical position to cartesian one'
    print*, 'first point r,lat,lon=',vectime(1,1),vectime(2,1), vectime(3,1)
    pisd=acos(-1.)/180.

  do i=1, nbvec
     bx=vectime(1,i)
     by=vectime(2,i)
     bz=vectime(3,i)

     pp=bz*cos(bx*pisd)

     vectime(1,i)=pp*cos(by*pisd)/6378.
     vectime(2,i)=pp*sin(by*pisd)/6378.
     vectime(3,i)=bz*sin(bx*pisd)/6378.
  end do

  manda_param%DATA_LABEL='Px ; Py ; Pz'
  manda_param%DATA_UNITS='Re ; Re ; Re'
  optio_param%SUB_TITLE='Px, Py, Pz (Re) in '//rep(1:4)//' system'

  ENDIF

  end subroutine load_data

!-------------------------------------------------------------------+--

  END program visu_vectime

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  subroutine extend(vect,nbvec)

  real vect(6,nbvec)

  print*,'Calcul des composantes spheriques'

  do i=1,nbvec
     x=vect(1,i)
     y=vect(2,i)
     z=vect(3,i)

     call ccarsph_(x,y,z,r,teta,phi)

     vect(4,i)=r
     vect(5,i)=teta
     vect(6,i)=phi
  end do

  return
  END

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
