
  program visu_vectime_3D

!----------------------------------------------------------------------!
! Object: Visualize on 3D planes a vectime.rff
! Author: P. Robert , ScientiDev, Feb. 2021
!----------------------------------------------------------------------!

  use rff_param_def
  use rff_data_def

  integer            :: nbloc, i,indpo(24)

  character(len=255) :: VT_file,work,psfile,signat
  character(len=3)   :: suff
  character(len=120) :: dati26,mission,experi,csatnum,label,units,rep,mode
  character(len=8)   :: forgx,forgy,forgz,titgra(24)
  character(len=64)  :: give_RPC_version,titleft,titright,RPC_version
  character(len=27)  :: datiso1,datiso2

  real(kind=4)       :: y1(3),y2(3),valgra(24), xe(73),ye(73),ze(73)
  real(kind=4),      dimension(:),     allocatable :: time,tra
  real(kind=4),      dimension(:,:),   allocatable :: vectime
  
  common /traj/ nbgma,sizrond,bodyl,bodyw,headl,headw

  data nbgma,nbpma /24,24/


!     ---------------------------------------------------------------+--

  print*, '------------------------------------------------------------'
  print*, 'visu_vectime_3D  : Visualize a vectime.rff'
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF VT file to read ? (ex: toto_GSE.rff)'
  read(*,'(a)') VT_file
  print*, trim(VT_file)

  print*,'datiso1 ? ex:2020-02-05T15:00:00.000000Z'
  read(*,'(a)') datiso1
  print*, trim(datiso1)


  print*,'datiso2 ? ex:2020-02-08T05:32:00.000000Z'
  read(*,'(a)') datiso2
  print*, trim(datiso2)

  ivt=len(trim(VT_file))
  suff=VT_file(ivt-2:ivt)

  if(suff /= 'rff') then
     print*, ' ***file has not .rff suffix',suff
     stop 'visu_vectime_3D.exe                : *** ERROR !! Program aborted !'
  ENDIF

! *** lecture du vectime.rff

  print*
  print*, '=================================='
  print*, '1) read  vectime file '
  print*, '=================================='


  call rff_R_file(1,VT_file)

  call check_meta

  nbloc=manda_param%block_number

  write(*,*)
  write(*,*) 'VT_file: number of blocks =',nbloc
  write(*,*) 'VT_file: data_index(    1)=',data_index(1)
  write(*,*) 'VT_file: data_index(nbloc)=',data_index(nbloc)

  write(*,*)
  write(*,*) ' select time period to extract'

  if(datiso1(1:1) == '0') datiso1=data_index(1)
  if(datiso2(1:1) == '0') datiso2=data_index(nbloc)

  if(datiso1 == datiso2) then
     datiso1=data_index(1)
     datiso2=data_index(nbloc)
  endif

  call check_datiso(datiso1)
  call check_datiso(datiso2)

  print*
  print*, 'datiso1 in the file:',data_index(1)
  print*, 'datiso1 in the file:',data_index(nbloc)
  print*
  print*, 'datiso1 asked:',datiso1
  print*, 'datiso2 asked:',datiso2

  nbloc2=0
  it1=1
  it2=nbloc

  do i=1,nbloc
     call compare_datiso(datiso1,data_index(i),icomp1)
     call compare_datiso(datiso2,data_index(i),icomp2)

     if((icomp1 == -1) .or. (icomp2 == 1)) cycle
     nbloc2=nbloc2 +1
     if(nbloc2 == 1) it1=i
     it2=i
  end do

  print*,'nbloc, it1,it2,nbloc2=',nbloc,it1,it2,nbloc2
  print*

  allocate(vectime(3,nbloc2))
  allocate(time(nbloc2))

  print*
  print*, '=================================='
  print*, '2) Load data '
  print*, '=================================='

  print*,'calcul du titre droit et de la date'

  call decode_datiso(data_index(1),iyear,imon,iday,ih,im,is,ims,imc)
  call codoty(imon,iday,iyear,idoty1)
  call cdattit_(iyear,imon,iday,titright)
  print*, 'titright=',titright

  print*, 'chargement du temps et des vecteurs, avec reduction eventuelle des donnees'

  call load_data
  call check_meta

  print*,'nbloc, it1,it2,nbloc2=',nbloc,it1,it2,nbloc2,'  nbvec=',nbvec
  if(nbvec.lt.nbloc2) print*,'There is removed fill values'

!     --------------------------------------------------------------+--
! *** ouverture du fichier graphique, cadre et mise en page
!     --------------------------------------------------------------+--


  psfile=VT_file(1:ivt-4)//'.ps'

  tclab=0.35
  tctit=0.35
  tccom=0.25


  y1(:)=0.
  y2(:)=0.

! ---------------------------------------------------------
  print*, 'Ouverture du fichier PS'
! ---------------------------------------------------------

  call dopegra_(1,psfile)

  call dlinwid_(1.5)
  call dfontyp_('h')
  call dtitsiz_(tctit)

  print*, 'Trace les variables du plot'

  mission=manda_param%MISSION_NAME
  write(csatnum,'(i1)') manda_param%OBSERVATORY_NUMBER
  experi =manda_param%EXPERIMENT_NAME
  mode   =manda_param%EXPERIMENT_MODE
  rep    =manda_param%DATA_COORDINATE_SYSTEM

  titleft=trim(mission)//"-"//trim(csatnum)//'/'//trim(experi)//'/'//trim(mode)
  tcl=0.4
  tcr=0.35
  call gasdati_(dati26)
  RPC_version=give_RPC_version()
  signat='RoGraLib plot -'//' '//trim(psfile)//" - "//RPC_version(1:8)

  print*,'plot du cadre avec titre gauche et droit, signature et date'

  call plotframe(titleft,tcl,titright,tcr,signat)

  print*, 'plot du titre'

  work=trim(optio_param%TITLE)//'  -  '//trim(optio_param%SUB_TITLE)

  call cchalen_(work,nw)
  call gpagsiz_(spx,spy)
  call ppagcha_(spx/2.,spy-2.6,0, tctit,tctit,0.,trim(work))

  print*,'plot du commentaire haut gauche'

  dt =real(optio_param%TIME_RESOLUTION)
  write(work,"(a,i9,a,e12.3,a)") "Nb. Pts= ",nbvec,"    <dt> =",dt,' s'
  call ppagcha_(0.5,spy-4.2,-1,tccom,tccom,0.,trim(work))
  dt=dt/3600.

  print*,'plot de la duree'

  work='Period: '//datiso1//'  to  '//datiso2
  call ppagcha_(spx/2.,spy-3.3,0,tccom,tccom,0.,trim(work))


  print*, 'calcul des graduations horaire'

  t1=time(1)
  t2=time(nbvec)

  print*, 't1,t2=',t1,t2

  call cfiggrah(t1,t2,valgra,titgra,valdt,nbgma,nbpma)


  print*, 'nb G. marques=',nbgma
  print*, 'nb P. marques=',nbpma
  print*, 'val. grad.=',(valgra(i),i=1,nbgma)
  print*, 'tit grad  =',(titgra(i),i=1,nbgma)
  print*, 'valdt     =',valdt

! calcul position des points en temps


  do j=1,nbgma
     indpo(j)=1
      do i=1,nbvec-1
      if(valgra(j).ge.time(i) .and. valgra(j).le.time(i+1)) indpo(j)=i
    end do
  end do

  print*,'time stick indices:',(indpo(j),j=1,nbgma)


  print*, 'set 3D plot parameters'

  posfx=1.9
  posfy=15.
  sx=6.7
  sy=6.7
  decax=1.2
  decay=1.2

  tgm=0.3
  tpm=0.15
  tg=0.3
  dga=0.5

  bodyl=0.7
  bodyw=0.01
  headl=0.4
  headw=0.3

  sizrond=0.16

  do i=1,73
     tet=float(i-1)*5.*3.14159/180.
     xe(i)=cos(tet)
     ye(i)=sin(tet)
     ze(i)=cos(tet)
  end do

! On cherche la meme echelle pour les 3 plots

  xmi=minval(vectime(1,:),mask=vectime(1,:)/=0.)
  ymi=minval(vectime(2,:),mask=vectime(2,:)/=0.)
  zmi=minval(vectime(3,:),mask=vectime(3,:)/=0.)

  xma=maxval(vectime(1,:),mask=vectime(1,:)/=0.)
  yma=maxval(vectime(2,:),mask=vectime(2,:)/=0.)
  zma=maxval(vectime(3,:),mask=vectime(3,:)/=0.)

 if(abs(xmi) < 1.e-30) xmi=0.
 if(abs(ymi) < 1.e-30) ymi=0.
 if(abs(zmi) < 1.e-30) zmi=0.


  print*, 'xmi,ymi,zmi=', xmi,ymi,zmi
  print*, 'xma,yma,zma=', xma,yma,zma

  dx=xma-xmi
  dy=yma-ymi
  dz=zma-zmi


  dma=max(dx,dy,dz)

  print*,'dma=',dma

  arrlenx=(bodyl+headl)*dma/sx
  arrleny=(bodyl+headl)*dma/sy
  arrlen =sqrt(arrlenx**2 + arrleny**2)

  print*,'with arrow lenhth, arrlen=',arrlen

  xmi2=((xma+xmi) -dma)/2. -arrlen
  ymi2=((yma+ymi) -dma)/2. -arrlen
  zmi2=((zma+zmi) -dma)/2. -arrlen

  xma2=((xma+xmi) +dma)/2. +arrlen
  yma2=((yma+ymi) +dma)/2. +arrlen
  zma2=((zma+zmi) +dma)/2. +arrlen

  xmi=xmi2
  ymi=ymi2
  zmi=zmi2

  xma=xma2
  yma=yma2
  zma=zma2

  print*
  print*, 'after normalization:'
  print*, 'xmi,ymi,zmi=', xmi,ymi,zmi
  print*, 'xma,yma,zma=', xma,yma,zma

  print*,'xma-xmi=',xma-xmi
  print*,'yma-ymi=',yma-ymi
  print*,'zma-zmi=',zma-zmi

  print*, 'plot of pannel 1 in (-X,Z)'
  print*, '--------------------------'

  xx=posfx
  yy=posfy

  call dfigori_(xx,yy)
  call dfigsiz_(sx,sy)
  call dgrasiz_(0.4,0.3)
  call dstipos_('oi','ii')

  call cfiggra_(xmi,xma,xmin,xmax,bgx,sgx,forgx)
  call cfiggra_(ymi,yma,ymin,ymax,bgy,sgy,forgy)
  call cfiggra_(zmi,zma,zmin,zmax,bgz,sgz,forgz)

  call dlinrgb_(0.98,0.98,1.)
  call dfilzon_
  call pfigfra_
  call pfilzon_
  call dlincol_('n')
  call pfigfra_
  call dfigout_('n')

  call dfiglimx(-xma,-xmi)
  call dfiglimy(zmi,zma)

  call ppagaxex(xx,yy   ,sx,xmi,xma,0., bgx, sgx,-tgm,-tpm,0., dga,forgx)
  call ppagaxex(xx,yy+sy,sx,xma,xmi,0.,-bgx,-sgx,-tgm,-tpm,tg,-dga,forgx)

  call ppagaxey(posfx,   posfy,sy,zmi,zma,0.,bgz,sgz,-tgm,-tpm,tg, dga,forgz)
  call ppagaxey(posfx+sx,posfy,sx,zmi,zma,0.,bgz,sgz,-tgm,-tpm,0., dga,forgz)

! Earth

   if((rep == 'GSE') .or. (rep == 'gse')) then
              call dlincol_('y')
              call dfilzon_
              call pfigcurl(xe,ye,18,55,1)
              call pfilzon_

              call dlincol_('c')
              call dfilzon_
              call pfigcurl(xe,ye,1,19,1)
              call pfigcurl(xe,ye,55,73,1)
              call pfilzon_
              call dlincol_('n')
              call pfigcur_(xe,ye,73)
                                           else
              call dlincol_('c')
              call dfilzon_
              call pfigcur_(xe,ye,73)
              call pfilzon_
              call dlincol_('n')
              call pfigcur_(xe,ye,73)
    endif

  angle=atan2(-vectime(3,nbvec) +vectime(3,nbvec-2),vectime(1,nbvec) -vectime(1,nbvec-2))*180./3.14159

  call cfigpag_(-vectime(1,nbvec),vectime(3,nbvec),xx,yy)
  call ppagarrf(xx,yy,-1,bodyl,bodyw,headl,headw,angle+180.)

  call pfigcur_(-vectime(1,:),vectime(3,:),nbvec)

  do i=1,nbgma
     k=indpo(i)
     call pfigrond(-vectime(1,k),vectime(3,k),sizrond)
  end do


  print*, 'plot of pannel 2 in (Y,Z)'
  print*, '--------------------------'

  xx=posfx+sx+decax
  yy=posfy

  call dfigori_(xx,yy)
  call dfigsiz_(sx,sy)
  call dgrasiz_(0.3,0.3)
  call dstipos_('oi','ii')

  call dfiglimx(ymi,yma)
  call dfiglimy(zmi,zma)

  call dlinrgb_(0.98,0.98,1.)
  call dfilzon_
  call pfigfra_
  call pfilzon_
  call dlincol_('n')
  call pfigfra_
  call dfigout_('n')

  call ppagaxex(xx,yy   ,sx,ymi,yma,0.,bgy,sgy,-tgm,-tpm,0., dga,forgy)
  call ppagaxex(xx,yy+sy,sx,ymi,yma,0.,bgy,sgy,-tgm,-tpm,tg,-dga,forgy)

  call ppagaxey(xx   ,yy,sy,zmi,zma,0.,bgz,sgz,tgm,tpm,0., dga,forgz)
  call ppagaxey(xx+sx,yy,sx,zmi,zma,0.,bgz,sgz,tgm,tpm,tg,-dga,forgz)

! Earth
   if((rep == 'GSE') .or. (rep == 'gse')) then
              call dlincol_('y')
              call dfilzon_
              call pfigcur_(xe,ye,73)
              call pfilzon_

              call dlincol_('n')
              call pfigcur_(xe,ye,73)
                                           else
              call dlincol_('c')
              call dfilzon_
              call pfigcur_(xe,ye,73)
              call pfilzon_
              call dlincol_('n')
              call pfigcur_(xe,ye,73)
    endif

  angle=atan2(-vectime(3,nbvec) +vectime(3,nbvec-2),-vectime(2,nbvec) +vectime(2,nbvec-2))*180./3.14159

  call cfigpag_(vectime(2,nbvec),vectime(3,nbvec),xx,yy)
  call ppagarrf(xx,yy,-1,bodyl,bodyw,headl,headw,angle+180.)

  call pfigcur_(vectime(2,:),vectime(3,:),nbvec)

  do i=1,nbgma
     k=indpo(i)
     call pfigrond(vectime(2,k),vectime(3,k),sizrond)
  end do

  print*, 'plot of pannel 3 in (-X,-Y)'
  print*, '--------------------------'

  xx=posfx
  yy=posfy-sy-decay

  call dfigori_(xx,yy)
  call dfigsiz_(sx,sy)
  call dgrasiz_(0.3,0.3)
  call dstipos_('oi','ii')

  call dlinrgb_(0.98,0.98,1.)
  call dfilzon_
  call pfigfra_
  call pfilzon_
  call dlincol_('n')
  call pfigfra_
  call dfigout_('n')

  call dfiglimx(-xma,-xmi)
  call dfiglimy(-yma,-ymi)

  call ppagaxex(xx,yy,   sx,xma,xmi,0.,-bgx,-sgx, tgm, tpm,tg, dga,forgx)
  call ppagaxex(xx,yy+sy,sx,xmi,xma,0., bgx, sgx, tgm, tpm,0.,-dga,forgx)

  call ppagaxey(xx   ,yy,sy,yma,ymi,0.,-bgy,-sgy,-tgm,-tpm,tg, dga,forgy)
  call ppagaxey(xx+sx,yy,sx,yma,ymi,0.,-bgy,-sgy, tgm, tpm,0., dga,forgy)

! Earth

   if((rep == 'GSE') .or. (rep == 'gse')) then
              call dlincol_('y')
              call dfilzon_
              call pfigcurl(xe,ye,18,55,1)
              call pfilzon_

              call dlincol_('c')
              call dfilzon_
              call pfigcurl(xe,ye,1,19,1)
              call pfigcurl(xe,ye,55,73,1)
              call pfilzon_
              call dlincol_('n')
              call pfigcur_(xe,ye,73)
                                           else
              call dlincol_('c')
              call dfilzon_
              call pfigcur_(xe,ye,73)
              call pfilzon_
              call dlincol_('n')
              call pfigcur_(xe,ye,73)
    endif

  angle=atan2(-vectime(2,nbvec) +vectime(2,nbvec-2),-vectime(1,nbvec) +vectime(1,nbvec-2))*180./3.14159

  call cfigpag_(-vectime(1,nbvec),-vectime(2,nbvec),xx,yy)
  call ppagarrf(xx,yy,-1,bodyl,bodyw,headl,headw,angle)

  call pfigcur_(-vectime(1,:),-vectime(2,:),nbvec)

  do i=1,nbgma
     k=indpo(i)
     call pfigrond(-vectime(1,k),-vectime(2,k),sizrond)
  end do

! Big axe

  xx=posfx+sx+decax/2.
  yy=posfy-decay/2.
  rlon=sx+1.7
  wid=0.11

  call dlincol_('g')
  call ppagarrf(xx,yy,-1,rlon    ,wid,0.6,0.5,  0.)
  call dlincol_('b')
  call ppagarrf(xx,yy,-1,rlon+0.4,wid,0.6,0.5, 90.)
  call dlincol_('r')
  call ppagarrf(xx,yy,-1,rlon,    wid,0.6,0.5,180.)
  call dlincol_('g')
  call ppagarrf(xx,yy,-1,rlon+0.4,wid,0.6,0.5,270.)
  call dlincol_('n')

  tclab=0.6
  call ppagcha_(xx-rlon-0.3,yy,0,tclab,tclab,0.,'X')
  call ppagcha_(xx+rlon+0.3,yy,0,tclab,tclab,0.,'Y')
  call ppagcha_(xx+0.6,yy+rlon+0.4,0,tclab,tclab,0.,'Z')
  call ppagcha_(xx+0.7,yy-rlon-0.3,0,tclab,tclab,0.,'Y')

  radius=0.4
  call dfilzon_
  call ppagcir_(xx,yy,radius,0.,270.,5.)
  call ppaglin_(xx,yy-radius,xx,yy)
  call ppaglin_(xx,yy,xx+radius,yy)
  call pfilzon_
  
! ----------------------------------------------------------------------------
! save radius for bottom plot

  allocate(tra(nbloc2))

  tra(:)=sqrt(vectime(1,:)**2 +vectime(2,:)**2 +vectime(3,:)**2)

  Rmax=maxval(tra(1:nbvec))
  Rmin=minval(tra(1:nbvec))
  
! ---------------------------------------------
  print*, '3D cube'
! ---------------------------------------------

  xx=posfx+sx+decax+sx/2.
  yy=posfy-decay-sy/2.-1.

  do i=1,nbvec
     call txyz_to_xycube(vectime(1,i),vectime(2,i),vectime(3,i),x,y,z)
     vectime(1,i)=x
     vectime(2,i)=y
     vectime(3,i)=z
  end do

  xma=maxval(vectime(1,:))
  yma=maxval(vectime(2,:))
  zma=maxval(vectime(3,:))

  xmi=minval(vectime(1,:))
  ymi=minval(vectime(2,:))
  zmi=minval(vectime(3,:))

  print*, 'xmi,xma=',xmi,xma
  print*, 'ymi,yma=',ymi,yma
  print*, 'zmi,zma=',zmi,zma

  if(xmi < 0.) then
               xmac=-xmi
               xmic= xmi
  endif

  if(xma > 0.) then
               xmic=-xma
               xmac= xma
  endif

  if(xmi < 0. .and. xma > 0.) then
                              xmac=max(-xmi,xma)
                              xmic=-xmac
  endif

  if(ymi < 0.) then
               ymac=-ymi
               ymic= ymi
  endif

  if(yma > 0.) then
               ymic=-yma
               ymac= yma
  endif

  if(ymi < 0. .and. yma > 0.) then
                              ymac=max(-ymi,yma)
                              ymic=-ymac
  endif

  dx=xmac-xmic
  dy=ymac-ymic

  dd=max(dx,dy)/1.8


  print*
  print*, 'xmic,xmac=',xmic,xmac
  print*, 'ymic,ymac=',ymic,ymac
  print*
  
  xmip=-dd
  xmap= dd
  ymip=-dd
  ymap= dd

  print*, 'xmip,xmap=',xmip,xmap
  print*, 'ymip,ymap=',ymip,ymap
  
  call dfigori_(xx-sx/2.,yy-sy/2.)
  call dfigsiz_(sx,sy)
  call dfiglimx(xmip,xmap)
  call dfiglimy(ymip,ymap)
  
! plot des axes en 3D
  
  gxx=dd
  gxy=0.
  gxz=0.
  
  gyx=0.
  gyy=dd
  gyz=0.
  
  gzx=0.
  gzy=0.
  gzz=dd
  
  bodyl=dd
  bodyw=dd/40.
  headl=dd/10.
  headw=dd/10.
  
  pi=acos(-1.)
  
! axe X
  call dlincol_('r')
  call txyz_to_xycube(gxx,gxy,gxz,xc,yc,zc)

  angle=atan2(yc,xc)*180./pi
  call pfigarrf(0.,0.,-1,bodyl,bodyw,headl,headw,angle)
  
! axe Y
  call dlincol_('g')
  call txyz_to_xycube(gyx,gyy,gyz,xc,yc,zc)

  angle=atan2(yc,xc)*180./pi
  call pfigarrf(0.,0.,-1,bodyl,bodyw,headl,headw,angle)
    
! axe Z
  call dlincol_('b')
  call txyz_to_xycube(gzx,gzy,gzz,xc,yc,zc)

  angle=atan2(yc,xc)*180./pi
  call pfigarrf(0.,0.,-1,bodyl,bodyw,headl,headw,angle)  

  call dlincol_('n')

  bodyl=0.7
  bodyw=0.01
  headl=0.4
  headw=0.3

  call dlincol_('n')
  call plot_traj(vectime,nbvec,1,2,1.,1.,indpo)

!Earth
  if((rep == 'GSE') .or. (rep == 'gse')) then
      call dlincol_('y')
      call dfilzon_
      call pfigcur_(xe,ye,73)
      call pfilzon_

      call dlincol_('c')
      call dfilzon_
      call pfigcurl(xe,ye,1,28,1)
      call pfiglin_(xe(28),ye(28), -0.2,0.6)
      call pfiglin_(-0.2,0.6,0.3,0.3)
      call pfiglin_(0.3,0.3,0.4,0.1)
      call pfiglin_(0.4,0.1,0.5,0.)
      call pfiglin_(0.5,0.,xe(64),ye(64))
      call pfigcurl(xe,ye,64,73,1)
      call pfilzon_
      call dlincol_('n')
      call pfigcur_(xe,ye,73)
                                           else
      call dlincol_('c')
      call dfilzon_
      call pfigcur_(xe,ye,73)
      call pfilzon_
      call dlincol_('n')
      call pfigcur_(xe,ye,73)
  endif
  
  
  print*, 'bottom panel'

  xx=posfx
  yy=2.
  sx=sx+decax+sx
  sy=3.2
  
  print*, 'nb G. marques=',nbgma
  print*, 'nb P. marques=',nbpma
  print*, 'val. grad.=',(valgra(i),i=1,nbgma)
  print*, 'tit grad  =',(titgra(i),i=1,nbgma)
  print*, 'valdt     =',valdt

  call dlincol_('n')
  call dfigori_(xx,yy)
  call dfigsiz_(sx,sy)
  call dfiglimx(t1,t2)
  
  call cfiggra_(Rmin,Rmax,ymin,ymax,bgy,sgy,forgy)
  
  call dfiglimy(ymin,ymax)
  call pfigfra_
  call pfiggray(0.,bgy,sgy,forgy)
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
  call ppagcha_(1.,yy,-1,0.27,0.27,90.,'Geocentric distance (Re)')
  call ppagcha_(0.9,yy-0.65,-1,0.35,0.35,0.,'UT')
  call pfigcur_(time,tra,nbvec)

  do i=1,nbgma
     call pfigrond(time(indpo(i)),tra(indpo(i)),sizrond)
  end do

  call dlincol_('n')

! *** termine, fermeture du fichier graphique

  call dclogra_

  print*, 'visu_vectime_3D.exe              : NORMAL TERMINATION'
     stop 'visu_vectime_3D.exe              : NORMAL TERMINATION'

!-------------------------------------------------------------------+--
  contains

!-------------------------------------------------------------------+--

  subroutine check_meta

  print*, "check metadata"

  IF(manda_param%FILE_CLASS /= 'VecTime') THEN
     write(*,*) '*** Only VecTime FILE_CLASS is allowed'
     stop 'visu_vectime_3D.exe             : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_TYPE /= 'FLT') THEN
     write(*,*) '*** Only FLT DATA_TYPE is allowed'
     stop 'visu_vectime_3D.exe             : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%INDEX_UNITS /= 'ISO_TIME') THEN
     write(*,*) '*** Only ISO_TIME INDEX_UNITS is allowed'
     stop 'visu_vectime_3D.exe             : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_FORM /= 'Vector') THEN
     write(*,*) '*** Only Vector DATA_FORM is allowed'
     stop 'visu_vectime_3D.exe             : *** ERROR !! Program aborted !'
  ENDIF

  print*, "OK"

  end subroutine check_meta

!-------------------------------------------------------------------+--

  subroutine load_data

  read(manda_param%DATA_FILL_VALUE,*) filval

  print*,'load_data: it1,it2=',it1,it2

  nbvec=0

  do i=it1,it2

     if(abs(R_data_vector(1,i)-filval) .lt. 1.e-30) cycle
     if(abs(R_data_vector(2,i)-filval) .lt. 1.e-30) cycle
     if(abs(R_data_vector(3,i)-filval) .lt. 1.e-30) cycle

     nbvec=nbvec+1

     call decode_datiso(data_index(i),iyear,imon,iday,ih,im,is,ims,imc)
     call codoty(imon,iday,iyear,idoty)
     nbday=idoty-idoty1
     call codecsec(nbday,ih,im,is,ims,imc,decsec)

     time(nbvec)=decsec/3600.

     vectime(1,nbvec)=R_data_vector(1,i)
     vectime(2,nbvec)=R_data_vector(2,i)
     vectime(3,nbvec)=R_data_vector(3,i)
  end do

  deallocate(data_index)
  deallocate(R_data_vector)

! conversion en cartesien si donnée en lat,lon,dist

  label=manda_param%DATA_LABEL
  units=manda_param%DATA_UNITS
  rep  =manda_param%DATA_COORDINATE_SYSTEM

  print*
  print*, 'label=',label
  print*, 'units=',units

  IF((label == 'Latitude ; Longitude ; Distance') .and. (units == 'degree ; degree ; km')) THEN
    print*
    print*, 'conversion spherical position to cartesian one'
    print*, 'first point r,lat,lon=',vectime(1,1),vectime(2,1), vectime(3,1)
    pisd=acos(-1.)/180.

  do i=1, nbvec
     bx=vectime(1,i)
     by=vectime(2,i)
     bz=vectime(3,i)

     pp=bz*cos(bx*pisd)

     vectime(1,i)=pp*cos(by*pisd)/6378.
     vectime(2,i)=pp*sin(by*pisd)/6378.
     vectime(3,i)=bz*sin(bx*pisd)/6378.
  end do

  manda_param%DATA_LABEL='Px ; Py ; Pz'
  manda_param%DATA_UNITS='Re ; Re ; Re'
  optio_param%SUB_TITLE='Px, Py, Pz (Re) in '//rep(1:4)//' system'

  ENDIF

  IF(units == 'km ; km ; km') THEN
    print*
    print*, 'conversion from km to Re, with Re=6378 km'

  do i=1, nbvec

     vectime(1,i)=vectime(1,i)/6378.
     vectime(2,i)=vectime(2,i)/6378.
     vectime(3,i)=vectime(3,i)/6378.
  end do

  manda_param%DATA_UNITS='Re ; Re ; Re'
  optio_param%SUB_TITLE='Px, Py, Pz (Re) in '//rep(1:4)//' system'

  ENDIF

  end subroutine load_data

!-------------------------------------------------------------------+--

  END program visu_vectime_3D

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  subroutine txyz_to_xycube(x,y,z,xc,yc,zc)
  
! transformation matrix
! 2 rotation de 45d, une autour de Z, l'autre autour de Y
! cos teta=cos phi=sqrt(2)/2

  pi=acos(-1.)
  tet=pi/4.
  phi=pi/4.
  
  ct=cos(tet)
  st=sin(tet)
  cp=cos(phi)
  sp=sin(phi)

  ax1=ct*cp
  ax2=st*cp
  ax3=sp

  ay1=-st
  ay2=ct
  ay3= 0.

  az1=-ct*sp
  az2=-st*sp
  az3=cp

  xx=ax1*x +ax2*y +ax3*z
  yy=ay1*x +ay2*y +ay3*z
  zz=az1*x +az2*y +az3*z
  
! permutation

  xc=yy
  yc=zz
  zc=xx
     
 return
 end
 
!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  subroutine plot_traj(vectime,nbvec,i1,i2,sig1,sig2,indpo)

  common /traj/ nbgma,sizrond,bodyl,bodyw,headl,headw

  real(kind=4) :: vectime(3,nbvec)
  integer      :: indpo(24)

  angle=-atan2(sig2*vectime(i2,nbvec-2) -sig2*vectime(i2,nbvec),sig1*vectime(i1,nbvec) -sig1*vectime(i1,nbvec-2))*180./3.14159

  call cfigpag_(sig1*vectime(i1,nbvec),sig2*vectime(i2,nbvec),xx,yy)

  call ppagarrf(xx,yy,-1,bodyl,bodyw,headl,headw,angle)

  call pfigcur_(sig1*vectime(i1,:),sig2*vectime(i2,:),nbvec)

  do i=1,nbgma
     k=indpo(i)
     call pfigrond(sig1*vectime(i1,k),sig2*vectime(i2,k),sizrond)
  end do

  return
  end

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

