
  program visu_vectime_4sat

!----------------------------------------------------------------------!
! Object: Visualize a vectime.rff
! Author: P. Robert , ScientiDev, Feb. 2021
!----------------------------------------------------------------------!

  use rff_param_def
  use rff_data_def

  integer            :: nbloc, i

  character(len=255) :: VT1,VT2,VT3,VT4,work,psfile,signat
  character(len=3)   :: suff
  character(len=120) :: dati26,mission,experi,label,units,rep,mode,laby(6)
  character(len=8)   :: forgy,titgra(24)
  character(len=64)  :: give_RPC_version,titleft,titright,RPC_version
  character(len=27)  :: datiso1,datiso2

  real(kind=4)       :: valgra(24), y1(6),y2(6)
  real(kind=4),      dimension(:),     allocatable :: time,time1,time2,time3,time4
  real(kind=4),      dimension(:,:),   allocatable :: vectime,vectime1,vectime2,vectime3,vectime4


  data posfx,posfy/ 3.0,20.6/
  data sizfx,sizfy/15., 3.3/
  data decay /0.3/
  data nbgma,nbpma /24,24/

!      ---------------------------------------------------------------+--

  print*, '------------------------------------------------------------'
  print*, 'visu_vectime_4sat  : Visualize 4 vectime.rff files'
  print*, '------------------------------------------------------------'
  print*

  print*, 'RFF VT files to read ? (ex: toto1_GSE.rff... toto4_GSE.rff)'
  read(*,'(a)') VT1
  print*,  trim(VT1)

  read(*,'(a)') VT2
  print*,  trim(VT2)

  read(*,'(a)') VT3
  print*,  trim(VT3)

  read(*,'(a)') VT4
  print*,  trim(VT4)

  print*,'datiso1 ? ex:2020-02-05T15:00:00.000000Z'
  read(*,'(a)') datiso1
  print*, trim(datiso1)


  print*,'datiso2 ? ex:2020-02-08T05:32:00.000000Z'
  read(*,'(a)') datiso2
  print*, trim(datiso2)

! test suffixe

  iVT1=len(trim(VT1))
  suff=VT1(iVT1-2:iVT1)

  if(suff /= 'rff') then
     print*, ' ***file ',trim(VT1),',has not .rff suffix',suff
     stop 'visu_vectime_4sat.exe              : *** ERROR !! Program aborted !'
  ENDIF

  iVT2=len(trim(VT2))
  suff=VT2(iVT2-2:iVT2)

  if(suff /= 'rff') then
     print*, ' ***file ',trim(VT2),',has not .rff suffix',suff
     stop 'visu_vectime_4sat.exe              : *** ERROR !! Program aborted !'
  ENDIF

  iVT3=len(trim(VT3))
  suff=VT3(iVT3-2:iVT3)

  if(suff /= 'rff') then
     print*, ' ***file ',trim(VT3),',has not .rff suffix',suff
     stop 'visu_vectime_4sat.exe              : *** ERROR !! Program aborted !'
  ENDIF

  iVT4=len(trim(VT4))
  suff=VT4(iVT4-2:iVT4)

  if(suff /= 'rff') then
     print*, ' ***file ',trim(VT4),',has not .rff suffix',suff
     stop 'visu_vectime_4sat.exe              : *** ERROR !! Program aborted !'
  ENDIF

! *** lecture du vectime.rff

  print*
  print*, '=================================='
  print*, '1) read 1st vectime file '
  print*, '=================================='


  call rff_R_file(1,VT1)

  call check_meta

  nbloc=manda_param%block_number

  write(*,*)
  write(*,*) 'VT1: number of blocks =',nbloc
  write(*,*) 'VT1: data_index(    1)=',data_index(1)
  write(*,*) 'VT1: data_index(nbloc)=',data_index(nbloc)

  write(*,*)
  write(*,*) ' select time period to extract'

  if(datiso1(1:1) == '0') datiso1=data_index(1)
  if(datiso2(1:1) == '0') datiso2=data_index(nbloc)

  if(datiso1 == datiso2) then
     datiso1=data_index(1)
     datiso2=data_index(nbloc)
  endif

  call check_datiso(datiso1)
  call check_datiso(datiso2)

  print*
  print*, 'datiso1 in the file:',data_index(1)
  print*, 'datiso1 in the file:',data_index(nbloc)
  print*
  print*, 'datiso1 asked:',datiso1
  print*, 'datiso2 asked:',datiso2

  nbloc_s=0
  it1=1
  it2=nbloc

! select period

  do i=1,nbloc
     call compare_datiso(datiso1,data_index(i),icomp1)
     call compare_datiso(datiso2,data_index(i),icomp2)

     if((icomp1 == -1) .or. (icomp2 == 1)) cycle
     nbloc_s=nbloc_s +1
     if(nbloc_s == 1) it1=i
     it2=i
  end do

  print*,'nbloc, it1,it2,nbloc_s=',nbloc,it1,it2,nbloc_s
  print*

  allocate(vectime(6,nbloc_s))
  allocate(time(nbloc_s))

  print*
  print*, '=================================='
  print*, '2) Load data 1st file'
  print*, '=================================='

  print*,'calcul du titre droit et de la date'

  call decode_datiso(data_index(1),iyear,imon,iday,ih,im,is,ims,imc)
  call codoty(imon,iday,iyear,idoty1)
  call cdattit_(iyear,imon,iday,titright)
  print*, 'titright=',titright
  write(work,'(I4.4,2i2.2)') iyear,imon,iday

  print*, 'chargement du temps et des vecteurs, avec reduction eventuelle des donnees'

  call load_data
  call check_meta

  print*,'nbloc, it1,it2,nbloc_s=',nbloc,it1,it2,nbloc_s,'  nbvec=',nbvec
  if(nbvec.lt.nbloc_s) print*,'There is removed fill values'

! save 1st file

  nbvec1=nbvec
  allocate(vectime1(6,nbvec1))
  allocate(time1(nbvec1))

  vectime1(1:3,1:nbvec1)=vectime(1:3,1:nbvec1)
  time1(1:nbvec1)=time(1:nbvec1)
  
  call extend(vectime1,nbvec1)

! ---------------------------------------------------------
  print*, 'Ouverture du fichier PS'
! ---------------------------------------------------------

  mission =manda_param%MISSION_NAME
  experi  = manda_param%EXPERIMENT_NAME
  mode    =manda_param%EXPERIMENT_MODE
  rep(1:3)=manda_param%DATA_COORDINATE_SYSTEM(1:3)

  laby(1)='X'
  laby(2)='Y'
  laby(3)='Z'

  laby(4)='R'
  laby(5)='Theta'
  laby(6)='Phi'

  psfile=mission(1:3)//'_'//experi(1:3)//'_'//mode(1:3)//'_'//rep(1:3)//'_'//work(1:8)//'_4sat.ps'

  call dopegra_(1,psfile)

  call dlinwid_(1.5)
  call dfontyp_('h')
  call dtitsiz_(tctit)

  print*, 'Trace les variables du plot'

  tclab=0.30
  tctit=0.40
  tccom=0.25
  
! si on veut imposer les bornes
  y1(:)=0.
  y2(:)=0.

  titleft=trim(mission)//'/'//trim(experi)//'/'//trim(mode)
  tcl=0.4
  tcr=0.35
  call gasdati_(dati26)
  RPC_version=give_RPC_version()
  signat='RoGraLib plot -'//' '//trim(psfile)//" - "//RPC_version(1:8)

  print*,'plot du cadre avec titre gauche et droit, signature et date'

  call plotframe(titleft,tcl,titright,tcr,signat)

  print*, 'plot du titre'

  call gpagsiz_(spx,spy)
  call ppagcha_(posfx+sizfx/2.,spy-2.8,0, tctit,tctit,0.,trim(optio_param%SUB_TITLE))


  print*,'plot du commentaire haut gauche'

  dt =real(optio_param%TIME_RESOLUTION)
  write(work,"(a,i9,a,e12.3,a)") "Nb. Pts= ",nbvec,"    <dt> =",dt,' s'
  call ppagcha_(0.5,spy-2.4,-1,tccom,tccom,0.,trim(work))
  dt=dt/3600.

  print*, 'calcul des graduations horaire'

  t1=time(1)
  t2=time(nbvec)

  call cminmax_(time,nbvec,t1,t2)

  print*, 't1,t2=',t1,t2

  call cfiggrah(t1,t2,valgra,titgra,valdt,nbgma,nbpma)
  call dfiglimx(t1,t2)

  print*, 'nb G. marques=',nbgma
  print*, 'nb P. marques=',nbpma
  print*, 'val. grad.=',(valgra(i),i=1,nbgma)
  print*, 'valdt     =',valdt

  print*, '=================================='
  print*, 'read 3 others files'
  print*, '=================================='

! --------------------------------------------------------------------------------------
  call rff_R_file(2,VT2)
  call check_meta

  nbloc=manda_param%block_number

  write(*,*)
  write(*,*) 'VT2: number of blocks =',nbloc
  write(*,*) 'VT2: data_index(    1)=',data_index(1)
  write(*,*) 'VT2: data_index(nbloc)=',data_index(nbloc)

! select period

  do i=1,nbloc
     call compare_datiso(datiso1,data_index(i),icomp1)
     call compare_datiso(datiso2,data_index(i),icomp2)

     if((icomp1 == -1) .or. (icomp2 == 1)) cycle
     nbloc_s=nbloc_s +1
     if(nbloc_s == 1) it1=i
     it2=i
  end do

  print*,'nbloc, it1,it2,nbloc_s=',nbloc,it1,it2,nbloc_s
  print*

  deallocate(vectime)
  deallocate(time)

  allocate(vectime(6,nbloc_s))
  allocate(time(nbloc_s))

  call load_data
  call check_meta

  print*,'nbloc, it1,it2,nbloc_s=',nbloc,it1,it2,nbloc_s,'  nbvec=',nbvec
  if(nbvec.lt.nbloc_s) print*,'There is removed fill values'

! save 2 file

  nbvec2=nbvec
  allocate(vectime2(6,nbvec2))
  allocate(time2(nbvec2))

  vectime2(1:3,1:nbvec2)=vectime(1:3,1:nbvec2)
  time2(1:nbvec2)=time(1:nbvec2)
  
  call extend(vectime2,nbvec2)
  
! --------------------------------------------------------------------------------------

  call rff_R_file(3,VT3)
  call check_meta

  nbloc=manda_param%block_number

  write(*,*)
  write(*,*) 'VT3: number of blocks =',nbloc
  write(*,*) 'VT3: data_index(    1)=',data_index(1)
  write(*,*) 'VT3: data_index(nbloc)=',data_index(nbloc)

! select period

  do i=1,nbloc
     call compare_datiso(datiso1,data_index(i),icomp1)
     call compare_datiso(datiso2,data_index(i),icomp2)

     if((icomp1 == -1) .or. (icomp2 == 1)) cycle
     nbloc_s=nbloc_s +1
     if(nbloc_s == 1) it1=i
     it2=i
  end do

  print*,'nbloc, it1,it2,nbloc_s=',nbloc,it1,it2,nbloc_s
  print*

  deallocate(vectime)
  deallocate(time)

  allocate(vectime(6,nbloc_s))
  allocate(time(nbloc_s))

  call load_data
  call check_meta

  print*,'nbloc, it1,it2,nbloc_s=',nbloc,it1,it2,nbloc_s,'  nbvec=',nbvec
  if(nbvec.lt.nbloc_s) print*,'There is removed fill values'

! save 3 file

  nbvec3=nbvec
  allocate(vectime3(6,nbvec3))
  allocate(time3(nbvec3))

  vectime3(1:3,1:nbvec3)=vectime(1:3,1:nbvec3)
  time3(1:nbvec3)=time(1:nbvec3)
  
  call extend(vectime3,nbvec3)
  
! --------------------------------------------------------------------------------------
  call rff_R_file(4,VT4)
  call check_meta

  nbloc=manda_param%block_number

  write(*,*)
  write(*,*) 'VT4: number of blocks =',nbloc
  write(*,*) 'VT4: data_index(    1)=',data_index(1)
  write(*,*) 'VT4: data_index(nbloc)=',data_index(nbloc)

! select period

  do i=1,nbloc
     call compare_datiso(datiso1,data_index(i),icomp1)
     call compare_datiso(datiso2,data_index(i),icomp2)

     if((icomp1 == -1) .or. (icomp2 == 1)) cycle
     nbloc_s=nbloc_s +1
     if(nbloc_s == 1) it1=i
     it2=i
  end do

  print*,'nbloc, it1,it2,nbloc_s=',nbloc,it1,it2,nbloc_s
  print*

  deallocate(vectime)
  deallocate(time)

  allocate(vectime(6,nbloc_s))
  allocate(time(nbloc_s))

  call load_data
  call check_meta

  print*,'nbloc, it1,it2,nbloc_s=',nbloc,it1,it2,nbloc_s,'  nbvec=',nbvec
  if(nbvec.lt.nbloc_s) print*,'There is removed fill values'

! save 4 file

  nbvec4=nbvec
  allocate(vectime4(6,nbvec4))
  allocate(time4(nbvec4))

  vectime4(1:3,1:nbvec4)=vectime(1:3,1:nbvec4)
  time4(1:nbvec4)=time(1:nbvec4)
  
  call extend(vectime4,nbvec4)
  
! --------------------------------------------------------------------------------------

! On cherche la meme echelle pour les 4 plots

  xmi=min(minval(vectime1(1,:)),minval(vectime2(1,:)),minval(vectime3(1,:)),minval(vectime4(1,:)))
  ymi=min(minval(vectime1(2,:)),minval(vectime2(2,:)),minval(vectime3(2,:)),minval(vectime4(2,:)))
  zmi=min(minval(vectime1(3,:)),minval(vectime2(3,:)),minval(vectime3(3,:)),minval(vectime4(3,:)))
  pmi=min(minval(vectime1(4,:)),minval(vectime2(4,:)),minval(vectime3(4,:)),minval(vectime4(4,:)))
  qmi=min(minval(vectime1(5,:)),minval(vectime2(5,:)),minval(vectime3(5,:)),minval(vectime4(5,:)))
  rmi=min(minval(vectime1(6,:)),minval(vectime2(6,:)),minval(vectime3(6,:)),minval(vectime4(6,:)))


  xma=max(maxval(vectime1(1,:)),maxval(vectime2(1,:)),maxval(vectime3(1,:)),maxval(vectime4(1,:)))
  yma=max(maxval(vectime1(2,:)),maxval(vectime2(2,:)),maxval(vectime3(2,:)),maxval(vectime4(2,:)))
  zma=max(maxval(vectime1(3,:)),maxval(vectime2(3,:)),maxval(vectime3(3,:)),maxval(vectime4(3,:)))
  pma=max(maxval(vectime1(4,:)),maxval(vectime2(4,:)),maxval(vectime3(4,:)),maxval(vectime4(4,:)))
  qma=max(maxval(vectime1(5,:)),maxval(vectime2(5,:)),maxval(vectime3(5,:)),maxval(vectime4(5,:)))
  rma=max(maxval(vectime1(6,:)),maxval(vectime2(6,:)),maxval(vectime3(6,:)),maxval(vectime4(6,:)))

  print*, 'xmi,ymi,zmi,pmi,qmi,rmi=', xmi,ymi,zmi,pmi,qmi,rmi
  print*, 'xma,yma,zma,pma,qma,rma=', xma,yma,zma,pma,qma,rma

! ----------------------------------------------------------------------------
  print*, 'plot des 6 pannels'
! ----------------------------------------------------------------------------

! *   bornes automatiques

  y1(1)=xmi
  y2(1)=xma
  y1(2)=ymi
  y2(2)=yma
  y1(3)=zmi
  y2(3)=zma
  y1(4)=pmi
  y2(4)=pma
  y1(5)=qmi
  y2(5)=qma
  y1(6)=rmi
  y2(6)=rma
     
  print*,'y1=',y1
  print*,'y2=',y2

  do nco=1,6

     print*, 'component ',nco

     if(nco.gt.1) posfy=posfy-sizfy-decay
     if(nco.eq.4) posfy=posfy-0.7

     call dfigori_(posfx,posfy)
     call dfigsiz_(sizfx,sizfy)
     call cfiggra_(y1(nco),y2(nco),ymin,ymax,bgy,sgy,forgy)
     call dgrasiz_(0.,0.3)

     call dfiglimy(ymin,ymax)
     print*, 'ymin,ymax=',ymin,ymax

     if(nco == 6) call dstipos_('oi','ii')
     if(nco == 4) call ppagcha_(posfx+sizfx/2.,posfy+sizfy+0.4,0, tclab,tclab,0.,'Spherical components')

     call pfigfra_
     call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)
     call pfiggray(0.,bgy,sgy,forgy)
     call dlincol_('n')
     call pfigcur_(time1,vectime1(nco,:),nbvec1)
     call dlincol_('r')
     call pfigcur_(time2,vectime2(nco,:),nbvec2)
     call dlincol_('g')
     call pfigcur_(time3,vectime3(nco,:),nbvec3)
     call dlincol_('b')
     call pfigcur_(time4,vectime4(nco,:),nbvec4)
     call dlincol_('n')     
     call cchalen_(laby(nco),nl)
     call ppagcha_(0.5,posfy+sizfy/2.,-1,tclab,tclab,0.,laby(nco)(1:nl))
       
  end do

! *** re-plot des graduations horaire du bas avec valeurs
    
  call dgrasiz_(0.35,0.3)
  call pfiggrah(valgra,titgra,valdt,nbgma,nbpma)

! *** termine, fermeture du fichier graphique

  call dclogra_

  print*, 'visu_vectime_4sat.exe            : NORMAL TERMINATION'
     stop 'visu_vectime_4sat.exe            : NORMAL TERMINATION'

!-------------------------------------------------------------------+--
  contains

!-------------------------------------------------------------------+--

  subroutine check_meta

  print*, "check metadata"

  IF(manda_param%FILE_CLASS /= 'VecTime') THEN
     write(*,*) '*** Only VecTime FILE_CLASS is allowed'
     stop 'visu_vectime_4sat.exe           : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_TYPE /= 'FLT') THEN
     write(*,*) '*** Only FLT DATA_TYPE is allowed'
     stop 'visu_vectime_4sat.exe           : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%INDEX_UNITS /= 'ISO_TIME') THEN
     write(*,*) '*** Only ISO_TIME INDEX_UNITS is allowed'
     stop 'visu_vectime_4sat.exe           : *** ERROR !! Program aborted !'
  ENDIF

  IF(manda_param%DATA_FORM /= 'Vector') THEN
     write(*,*) '*** Only Vector DATA_FORM is allowed'
     stop 'visu_vectime_4sat.exe           : *** ERROR !! Program aborted !'
  ENDIF

  print*, "OK"

  end subroutine check_meta

!-------------------------------------------------------------------+--

  subroutine load_data

  read(manda_param%DATA_FILL_VALUE,*) filval

  print*,'load_data: it1,it2=',it1,it2

  nbvec=0

  do i=it1,it2

     if(abs(R_data_vector(1,i)-filval) .lt. 1.e-30) cycle
     if(abs(R_data_vector(2,i)-filval) .lt. 1.e-30) cycle
     if(abs(R_data_vector(3,i)-filval) .lt. 1.e-30) cycle

     nbvec=nbvec+1

     call decode_datiso(data_index(i),iyear,imon,iday,ih,im,is,ims,imc)
     call codoty(imon,iday,iyear,idoty)
     nbday=idoty-idoty1
     call codecsec(nbday,ih,im,is,ims,imc,decsec)

     time(nbvec)=decsec/3600.

     vectime(1,nbvec)=R_data_vector(1,i)
     vectime(2,nbvec)=R_data_vector(2,i)
     vectime(3,nbvec)=R_data_vector(3,i)
  end do

  deallocate(data_index)
  deallocate(R_data_vector)

! conversion en cartesien si donnée en lat,lon,dist

  label=manda_param%DATA_LABEL
  units=manda_param%DATA_UNITS
  rep  =manda_param%DATA_COORDINATE_SYSTEM

  print*
  print*, 'label=',label
  print*, 'units=',units

  IF((label == 'Latitude ; Longitude ; Distance') .and. (units == 'degree ; degree ; km')) THEN
    print*
    print*, 'conversion spherical position to cartesian one'
    print*, 'first point r,lat,lon=',vectime(1,1),vectime(2,1), vectime(3,1)
    pisd=acos(-1.)/180.

  do i=1, nbvec
     bx=vectime(1,i)
     by=vectime(2,i)
     bz=vectime(3,i)

     pp=bz*cos(bx*pisd)

     vectime(1,i)=pp*cos(by*pisd)/6378.
     vectime(2,i)=pp*sin(by*pisd)/6378.
     vectime(3,i)=bz*sin(bx*pisd)/6378.
  end do

  manda_param%DATA_LABEL='Px ; Py ; Pz'
  manda_param%DATA_UNITS='Re ; Re ; Re'
  optio_param%SUB_TITLE='Px, Py, Pz (Re) in '//rep(1:4)//' system'

  ENDIF

  end subroutine load_data

!-------------------------------------------------------------------+--

  END program visu_vectime_4sat

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

  subroutine extend(vect,nbvec)

  real vect(6,nbvec)

  print*,'Calcul des composantes spheriques'

  do i=1,nbvec
     x=vect(1,i)
     y=vect(2,i)
     z=vect(3,i)

     call ccarsph_(x,y,z,r,teta,phi)

     vect(4,i)=r
     vect(5,i)=teta
     vect(6,i)=phi
  end do

  return
  END

!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
