!XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

program waveform_to_vectime

    !--------------------------------------------------------------------0--
    ! Laboratoire de Physique des Plasmas
    ! program to read CLUSTER/STAFF-SC RFF WaveForm file and convert it
    ! into a RFF vectime file.
    ! Rodrigue Piberne, LPP, 2011 February 16
    ! Revised P. Robert 2011 March 21
    ! Revised R. Piberne 2012 August 22 (correct bad timing)
    ! Revised R. Piberne 2012 September 06 (correct the first block. There
    ! was a problem when the last time of the previous day was a block index)
    ! Revised P. Robert 2019 for VTL1 ULF GEOS
    ! Revised P. Robert 2021 for VTL1 ULF mobile station
    !--------------------------------------------------------------------0--

!----------------------------------------------------------------------!
! Object: convert a WF RFF file into a VT RFF file 
! Author: R. Piberne, LPP, 2011 Feb 16  
! 
!   modifié P. Robert, January   2019 pour traiter les VTL1 de GEOS
!   modifié P. Robert, September 2021 pour traiter les VTL1 de GEOS/SOL
!----------------------------------------------------------------------!

    use rff_param_def
    use rff_data_def

    implicit none

    integer            :: block_number1, block_number2,vec_per_block
    integer            :: ierr1,ierr2,ierr3, i,j,k, nc, ifc, istart,iend
    integer            :: ix,iy,iz,nbcomp,x,y,z,iano,LSF
    integer            :: time_problem_index, ip1,ip2

    real(kind=8)       :: diff_time
    real(kind=8)       :: secdbl, fs
    real(kind=4)       :: phadiff, Eudiff1, Eudiff2, Eudiff3

    real (kind=4)      :: Eul_a1, Eul_b1, Eul_c1
    real (kind=4)      :: Eul_a2, Eul_b2, Eul_c2

    character(len=255) :: file1, file2, Fbasename
    character(len=27)  :: time_temp
    character(len=24)  :: credate
    character(len=255) :: fullform, work
    character(len=10)  :: cur_date
    character(len=1)   :: comp_ind,srot,tag_time


    print*, '---------------------------------------------------------------'
    print*, 'waveform_to_vectime : read a CLUSTER/STAFF-SC   RFF WaveForm file'
    print*, '                        or a GEOS/S300          RFF WaveForm file'
    print*, '                        or a ULF mobile station RFF WaveForm file'
    print*, 'and convert it into a RFF vectime file.'
    print*, '---------------------------------------------------------------'
    print*

    print*, 'RFF waveform file to read ? (ex: ../data/toto.rff)'
    read(*,'(a)') file1
    print*, trim(file1)

    ! file names reading
    ! ------------------

    print*, 'RFF vectime file to create ? (ex: ./toto_VT.rff, or blank)'

    read(*,'(a)') file2
    print*, trim(file2)

    ! compute name of file2 if empty string

    if (len_trim(file2) == 0) then
        file2=TRIM(Fbasename(file1))
        nc=LEN_TRIM(file2)
        file2=file2(1:nc-4)//'_VT.rff'
    endif

    write(*,*) ('-',i=1,72)
    write(*,*) 'Vectime rff file will be : ',TRIM(file2)

    ! read  RFF file
    ! --------------

    call rff_R_metadata(1,file1)
    call rff_W_manda_param(6)
    call rff_W_optio_param(6)

    call rff_R_const_data(1)
    call rff_W_const_data(6)
    
    write(*,*) 'test divers...'

    ! test if it is a CLUSTER/STAFF-SC  or a GEOS/S300 file or a mobile station file

    work=TRIM(manda_param%MISSION_NAME)//'/'//TRIM(manda_param%EXPERIMENT_NAME)

    if (work /= 'CLUSTER/STAFF-SC' .and. work /= 'GEOS/S300' .and. work /= 'MOBILE STATION/ULF'   ) then
        write(*,*) ' *** mission/experiment=',work
        write(*,*) ' *** WARNING, This is not a CLUSTER/STAFF-SC RFF file'
        write(*,*) ' ***                   or a GEOS/S300 file'
        write(*,*) ' ***                   or a GEOS/SOL  file'
        write(*,*) ' ***          May be this program will not run correctly...'
    endif

    ! run only on waveform with integer data

    if(manda_param%FILE_CLASS /= 'WaveForm'  .or. &
    manda_param%DATA_FORM  /= 'Matrix'    .or. &
    manda_param%DATA_TYPE  /= 'INT' ) THEN
        write(*,*)
        write(*,*) '*** Error !!! this procedure run only with'
        write(*,*) '    WaveForm FILE_CLASS and INT DATA_TYPE'
        write(*,*) 'FILE_CLASS  =',manda_param%FILE_CLASS
        write(*,*) 'DATA_FORM   =', manda_param%DATA_FORM
        write(*,*) 'DATA_TYPE   =', manda_param%DATA_TYPE
        write(*,*) '*** Program aborted !!!'
        stop 'waveform_to_vectime.exe         : *** ERROR !! Program aborted !'
    endif

    ! set time resolution parameter if =0

    if(optio_param%TIME_RESOLUTION < 1.D-10) then
        optio_param%TIME_RESOLUTION= 1.D0/const_data%SAMPLE_RATE
        write(*,*) 'TIME_RESOLUTION < 1.D-10, SET to ',optio_param%TIME_RESOLUTION
    endif

    secdbl = optio_param%TIME_RESOLUTION

    ! number of blocks and number of vectors per block in the waveform file

    block_number1=manda_param%BLOCK_NUMBER
    vec_per_block=manda_param%DATA_DIMENSION(2)
    block_number2=block_number1*vec_per_block

    ! case of empty files

    if (block_number1 == 0) then
        write(*,*) ' *** WARNING, empty file, no data'
        go to 100
    endif

    ! file is not empty, we can read indexed data

    call rff_R_indexed_data(1)
    call rff_R_tail(1)


    ! create the vectime time array, time status array and phase array

    allocate(data_index2(block_number2),stat=ierr1)
    allocate(     phase2(block_number2),stat=ierr2)
    allocate(    status2(block_number2),stat=ierr3)
    
    if(ierr1 == 0) then
       write(*,*) 'data_index2 allocated to ',block_number2
                   else
       write(*,*) 'data_index2 not allocated to ',block_number2
       stop ' waveform_to_vectime: *** ABORTED on allocate!'
    endif
    
     if(ierr2 == 0) then
       write(*,*) '     phase 2 allocated to ',block_number2
                   else
       write(*,*) '     phase2 not allocated to ',block_number2
       stop ' waveform_to_vectime: *** ABORTED on allocate!'
    endif

    if(ierr3 == 0) then
       write(*,*) '     status2 allocated to ',block_number2
                   else
       write(*,*) '     status2 not allocated to ',block_number2
       stop ' waveform_to_vectime: *** ABORTED on allocate!'
    endif
  
  
    ! test si il y a une phase à écrire
    ip1=index(manda_param%INDEX_EXTENSION_LABEL,'Phase')
    ip2=index(manda_param%INDEX_EXTENSION_LABEL,'phase')
    write(*,*) 'ip1,ip2=',ip1,ip2
    IF (ip1 /= 0 .or. ip2 /= 0) THEN 
        write(*,*) 'There is a phase to process...'
                                ELSE
        write(*,*) 'No phase to process'
    ENDIF

    ! fill new data arrays
    ! --------------------

    k=0
    istart=0
    iend=block_number2

    work=ADJUSTL(optio_param%TIME_SPAN_FROM)
    if(work(1:6) == '      ' .or. work(1:9) == 'undefined') then
        work=data_index(block_number1/2)
    endif
    cur_date=work(1:10)

    write(*,*)
    write(*,*) 'Current date to process : ',cur_date
    write(*,*) 'vectors to be computed  : ',block_number2

    time_problem_index = 0
    tag_time='1'

    ! --------------------------------------------------
    ! permutation des composantes pour CLUSTER STAFF-SC

    if(TRIM(manda_param%MISSION_NAME)    == 'CLUSTER' .and. &
    TRIM(manda_param%EXPERIMENT_NAME) == 'STAFF-SC' ) then
        write(*,*) 'permutation des composantes pour CLUSTER/STAFF-SC'
        manda_param%DATA_COORDINATE_SYSTEM='INSTRUMENT'
        ix=2
        iy=3
        iz=1
    ! introduction des min max en Volt pour le cef

        const_data%VOLT_RANGE_MIN=-5.
        const_data%VOLT_RANGE_MAX= 5.
    else
        ix=1
        iy=2
        iz=3
    endif ! CLUSTER
    ! --------------------------------------------------
    ! GEOS: la frequence de spin est dans chaque bloc
    ! calcul pour le 1er point:

    if(TRIM(manda_param%MISSION_NAME)    == 'GEOS' .and. &
      TRIM(manda_param%EXPERIMENT_NAME) == 'S300' ) then

    ! get sample rate (redefined, false in WFL1) and spin frequency

      read(status(1),'(11x,f10.7)') fs
      const_data%SPIN_PERIOD=1.D0/fs
      const_data%SAMPLE_RATE=1.D0/0.043D0
      optio_param%TIME_RESOLUTION=1.D0/(const_data%SAMPLE_RATE)
      secdbl = optio_param%TIME_RESOLUTION
      nbcomp=8
    endif ! GEOS
    ! --------------------------------------------------
    
    ! Mobile station: on rajoute le status d'interpolation
    if(TRIM(manda_param%MISSION_NAME)    == 'MOBILE STATION' .and. &
       TRIM(manda_param%EXPERIMENT_NAME) == 'ULF' ) then
           manda_param%INDEX_EXTENSION_LABEL =trim(manda_param%INDEX_EXTENSION_LABEL)//' ; interp'
          ! manda_param%INDEX_EXTENSION_FORMAT='(a14)'
          ! manda_param%INDEX_EXTENSION_LENGTH=14
           manda_param%INDEX_EXTENSION_UNITS ='ms ; ms ; none'
    endif  ! mobile station  
    ! --------------------------------------------------
    
   IF (ip1 /= 0 .or. ip2 /= 0) THEN 
   ! il y a une phase a traiter
   call diff_datiso(data_index(2), data_index(1), diff_time)

   if (abs(diff_time - dble(vec_per_block)*secdbl) < 1.5D0*secdbl) then
          phadiff=phase(2)-phase(1)
          phadiff=modulo(phadiff,360.)
   endif
                               ELSE
   phase=0.
   ENDIF

   write(*,*) 'loop on all the blocks, block_number1=',block_number1
   
!   loop on all the blocks
!   ======================

    do i=1, block_number1

        ! mention time problem (block duration at 1%)
        if (i /= 1) then
            call diff_datiso(data_index(i-1), data_index(i), diff_time)
            if (abs(diff_time - dble(vec_per_block-1)*secdbl) > diff_time/100.D0)  then
                    time_problem_index = time_problem_index +1
                    tag_time = '2'
            else
                tag_time = '1'
            endif
        endif

        k= k+1

        ! one time over vec_per_block is the original time 
        ! cluster: vec_per_block=25 or 135; Geos: 128 ; mobile station: 1024
        data_index2(k) = data_index(i)
        phase2(k) = phase(i)
        time_temp = data_index(i)

        ! manip autre que CLUSTER ou GEOS: par defaut status avec indication interpol

        if(manda_param%INDEX_EXTENSION_LENGTH == 0) then
                           status2(k)=tag_time
                           manda_param%INDEX_EXTENSION_LABEL ='interpol. status'
                           manda_param%INDEX_EXTENSION_FORMAT='(a1)'
                           manda_param%INDEX_EXTENSION_TYPE  ='STR'
                           manda_param%INDEX_EXTENSION_UNITS ='none'
                                                    else
                           status2(k)= trim(status(i))//' '//tag_time
        endif
       
        ! --------------------------------------------------
        ! Cluster: on met la quatrième composante dans le status
        ! et on indique que le temps du bloc n'est pas interpolle
        
        if(TRIM(manda_param%MISSION_NAME)    == 'CLUSTER' .and. &
           TRIM(manda_param%EXPERIMENT_NAME) == 'STAFF-SC' ) then
           write(comp_ind,'(i1)') I_data_matrix(4,1,i)
           status2(k)= trim(status(i))//tag_time//comp_ind
        endif ! CLUSTER
        ! --------------------------------------------------
        
        nbcomp=3

        ! calcul des differences entre blocs pour l'interpolation

        if (i < block_number1) then
            call diff_datiso(data_index(i), data_index(i+1), diff_time)
            if (abs(diff_time - dble(vec_per_block)*secdbl) < 1.5D0*secdbl) then
               if (ip1 /= 0 .or. ip2 /= 0) then
                  phadiff=phase(i+1) -phase(i)
                  phadiff= modulo(phadiff,360.)
               endif

               ! --------------------------------------------------
               ! GEOS: on lit fs a partir du bloc en cour
               ! et on indique que le temps du bloc n'est pas interpolle
               ! on lit les angles d'Euler pour l'interpolation

               if(TRIM(manda_param%MISSION_NAME)    == 'GEOS' .and. &
                  TRIM(manda_param%EXPERIMENT_NAME) == 'S300' ) then
                   status2(k)= trim(status(i))//' '//tag_time
                   read(status(i),  '(i1,1x,i9,f10.7,3f7.2,1x,a1)') &
                                iano,LSF,fs,Eul_a1,Eul_b1,Eul_c1,srot
                   read(status(i+1),'(i1,1x,i9,f10.7,3f7.2,1x,a1)') &
                                iano,LSF,fs,Eul_a2,Eul_b2,Eul_c2,srot

                   Eudiff1=Eul_a2 -Eul_a1
                   Eudiff2=Eul_b2 -Eul_b1
                   Eudiff3=Eul_c2 -Eul_c1

                !!! *** attention: Eul1 ne varie pas linéairement, il tourne
                !       alors que Eul2 et Eul3 varient lentement,
                !       donc on peut faire l'interpolation lineaire sur 2 et 3
     
                   Eudiff1= modulo(Eudiff1,360.)
                   
                ! pour 2 et 3 gestion des passages à zero
                
                   if(abs(Eudiff2) > 180.) then
                             if(Eudiff2 < 0) then
                                             Eudiff2= Eudiff2 +360.
                                             else
                                             Eudiff2= Eudiff2 -360.              
                             endif
                   endif
 
                   if(abs(Eudiff3) > 180.) then
                             if(Eudiff3 < 0) then
                                             Eudiff3= Eudiff3 +360.
                                             else
                                             Eudiff3= Eudiff3 -360.              
                             endif
                   endif 

                   const_data%SPIN_PERIOD=1.D0/fs
                   
               endif ! GEOS
               ! --------------------------------------------------

            endif ! diff time
        endif ! i < bloc_number

        ! interpolation des blocks

        do j=1, vec_per_block -1

            ! memorize the position of vectors of the day before or after
            if(data_index2(k)(1:10) /= cur_date) then
                if(data_index2(k)(1:10) < cur_date) then
                    istart=k
                endif
            endif

            k= k+1
            ! interpolate time
            call addsecdbl_datiso(time_temp,dble(j)*secdbl,data_index2(k))

            ! interpolate phase
            IF (ip1 /= 0 .or. ip2 /= 0) THEN
            if(phase(i) <= -499.0) then
                phase2(k)= -500.
            else
                phase2(k) = phase(i) +phadiff*float(j)/float(vec_per_block)
                phase2(k) = modulo(phase2(k),360.)
            endif
            ENDIF

            ! copy status

            ! manip autre que CLUSTER ou GEOS : par defaut status avec indication interpol

            if(manda_param%INDEX_EXTENSION_LENGTH == 0) then
                           status2(k)=' 0'
                           manda_param%INDEX_EXTENSION_LABEL ='interpol. status'
                           manda_param%INDEX_EXTENSION_FORMAT='(a1)'
                           manda_param%INDEX_EXTENSION_TYPE  ='STR'
                           manda_param%INDEX_EXTENSION_UNITS ='none'
                                                    else
                           status2(k)= trim(status(i))//' 0'
            endif

            ! --------------------------------------------------
            ! Cluster: on met la quatrième composante dans le status
            ! plus le repere du temps
            
            if(TRIM(manda_param%MISSION_NAME)    == 'CLUSTER' .and. &
               TRIM(manda_param%EXPERIMENT_NAME) == 'STAFF-SC' ) then
               write(comp_ind,'(i1)') I_data_matrix(4,j+1,i)
               status2(k) = trim(status(i))//'0'//comp_ind
               nbcomp=3
            endif !CLUSTER
            ! --------------------------------------------------

            ! GEOS: repere de temps +euler interpolation
            if(TRIM(manda_param%MISSION_NAME)    == 'GEOS' .and. &
               TRIM(manda_param%EXPERIMENT_NAME) == 'S300' ) then

             ! interpolate Euler angles
               Eul_a2 = Eul_a1 +Eudiff1*float(j)/float(vec_per_block)
               Eul_b2 = Eul_b1 +Eudiff2*float(j)/float(vec_per_block)
               Eul_c2 = Eul_c1 +Eudiff3*float(j)/float(vec_per_block)

               Eul_a2 = modulo(Eul_a2,360.)
               Eul_b2 = modulo(Eul_b2,360.)
               Eul_c2 = modulo(Eul_c2,360.)
  
               write(status2(k),'(i1,1x,i9,f10.7,3f7.2,1x,a1,a2)') &
                            iano,LSF,fs,Eul_a2,Eul_b2,Eul_c2,srot,' 0'
               nbcomp=8
            endif ! GEOS
            ! --------------------------------------------------

            ! memorize the position of vectors of the day before or after
            if(data_index2(k)(1:10) /= cur_date) then
                if(data_index2(k)(1:10) < cur_date) then
                    istart=k
                endif
                if(data_index2(k)(1:10) > cur_date .and. iend == block_number2) then
                    iend=k-1
                endif
            endif
        end do
    end do
!   ======================

    write(*,*) 'vectors  computed              : ',k
    write(*,*) 'vectors  before current date   : ',istart, ' have to be removed'
    write(*,*) 'vectors  after  current date   : ',block_number2-iend,   ' have to be removed'
    write(*,*) 'blocks   with time problem     : ',time_problem_index
    write(*,*) 'vectors  with time problem     : ',time_problem_index*vec_per_block

    write(*,*) 'iend = ', iend

    block_number2=iend -istart
    write(*,*) 'vectors  to be written         : ',block_number2

100 continue ! step above was skipped for empty files

    if(block_number2 /= 0) then
        manda_param%block_first_index = data_index2(istart+1)
        manda_param%block_last_index  = data_index2(iend)
        write(*,*) 'Last index = ', manda_param%block_last_index
    else
        manda_param%block_first_index = 'None'
        manda_param%block_last_index  = 'None'
    endif



    ! change parameters for a vectime file
    ! ------------------------------------

    if(file2(1:2) == './') then
        file2=file2(3:len_trim(file2))
    endif

    manda_param%file_name = TRIM(file2)
    manda_param%file_class = 'VecTime'
    manda_param%block_number=block_number2
    manda_param%data_form = 'Vector'
    manda_param%data_dimension(1)= nbcomp
    manda_param%data_dimension(2)= 1

    ! ajoute le time_tag
    
    manda_param%INDEX_EXTENSION_LENGTH = manda_param%INDEX_EXTENSION_LENGTH +2
    i=manda_param%INDEX_EXTENSION_LENGTH
    write(manda_param%INDEX_EXTENSION_FORMAT,'(a2,i2,a1)') '(a',i,')'
    manda_param%INDEX_EXTENSION_TYPE='STR'
            
    if(TRIM(manda_param%MISSION_NAME)    == 'CLUSTER' .and. &
       TRIM(manda_param%EXPERIMENT_NAME) == 'STAFF-SC' ) then
       manda_param%data_label ='Bx ; By ; Bz'
       manda_param%data_units = 'TM_counts ; TM_counts ; TM_counts'
       manda_param%index_extension_length=22
       manda_param%INDEX_EXTENSION_FORMAT='(a14,",",f7.2)'
       manda_param%DATA_FORMAT='(3i6)'
    endif

    if(TRIM(manda_param%MISSION_NAME)    == 'GEOS' .and. &
       TRIM(manda_param%EXPERIMENT_NAME) == 'S300' ) then
       manda_param%data_label ='Bx ; By ; Bz ; Gx : Gy ; Gz ; Dx ; Dy '
       manda_param%data_units ='TM_cts ; TM_cts ; TM_cts ; None ; None ; None ; TM_cts ; TM_cts'
       manda_param%index_extension_length=54
       manda_param%INDEX_EXTENSION_FORMAT='(a46,",",f7.2)'
    endif
    
    write(*,*) 'manda_param%INDEX_EXTENSION_FORMAT=',trim(manda_param%INDEX_EXTENSION_FORMAT)

    ! replace format by integer decimal format (CLUSTER STAFF-SC only)
    ! and comma instead blank for cef data format compliance

    if(TRIM(manda_param%MISSION_NAME)    == 'CLUSTER' .and. &
       TRIM(manda_param%EXPERIMENT_NAME) == 'STAFF-SC' ) then
            manda_param%INDEX_EXTENSION_TYPE='STR ; FLT'
    endif

    ! vire le blanc de Space and  Magnetospheric Physics

    if (optio_param%DISCIPLINE_NAME == 'Space and  Magnetospheric Physics') then
        optio_param%DISCIPLINE_NAME  = 'Space and Magnetospheric Physics'
    endif

    ! update history optional parameter

    call gdatiso(credate)
    call rff_update_history(credate,'RPC_waveform_to_vectime')


    ! write new vectime file
    ! ----------------------

    ! remise aux valeurs par defaut definies dans la RFF_lib

    call rff_set_default_DATA_DESCRIPTION
    call rff_set_default_BLOCK_DESCRIPTION
    call rff_set_default_INDEX_DESCRIPTION
    call rff_set_default_INDEX_EXTENSION_DESCRIP

    ifc = 2
    call rff_W_metadata(ifc,file2)
    call rff_W_const_data(ifc)

    write(*,*) ('-',i=1,72)
    write(*,*) 'Writing indexed data, nb. blocks=',manda_param%BLOCK_NUMBER
    write(*,*) 'Please wait...'

    write(ifc,'(80a)')  '#',('-',i=1,79)
    write(ifc,'(a)')  'START INDEXED_DATA'

    if (block_number1 /= 0) then

        !    entire bloc data format

        fullform= '('//TRIM(manda_param%INDEX_FORMAT)//',",",'// &
        TRIM(manda_param%INDEX_EXTENSION_FORMAT)//',",",'// &
        TRIM(manda_param%DATA_FORMAT)//')'

        write(*,*) ' block data format=',trim(fullform)

        j=1
        k=1
     print*,'fullform=',trim(fullform)
        do i=istart+1,iend
            k =(i-1)/vec_per_block +1
            j =i-(k-1)*vec_per_block
            x=I_data_matrix(ix,j,k)
            y=I_data_matrix(iy,j,k)
            z=I_data_matrix(iz,j,k)
            I_data_matrix(1,j,k)=x
            I_data_matrix(2,j,k)=y
            I_data_matrix(3,j,k)=z

            IF (ip1 /= 0 .or. ip2 /= 0) THEN
               write(ifc,fullform) data_index2(i),status2(i),phase2(i),I_data_matrix(1:nbcomp,j,k)      
                 else
               write(ifc,fullform) data_index2(i),status2(i), I_data_matrix(1:nbcomp,j,k)
            endif
        end do

    endif

    ! write normal end of RFF file
    ! ----------------------------

    call rff_W_tail(ifc)

    write(*,'(1x,80a)')  ('-',i=1,79)

    print*, "waveform_to_vectime.exe          : NORMAL TERMINATION"
       stop "waveform_to_vectime.exe          : NORMAL TERMINATION"
    end
!
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!
