#!/bin/sh

dir=`dirname $0` 
dirpri=`dirname $dir`

machine=`uname -m` 
system=`uname -o | sed 's%/%_%'` 
compilor=`grep " FC = " $dirpri/Makefile  | sed 's/ FC = //'` 
language=`ls $dirpri/src/rocot_check.* | sed 's/.*\.//g'`

namref=out_$system"_"$machine"_"$compilor"_"$language

dirout=$dirpri/out
dirref=$dirpri/$namref
dircor=${dirref}_corr

echo $dir
echo $dirpri
echo $dirout
echo $dirref
echo $dircor

echo "-----------------------------------------"
echo "Save .out files in $dirref"

echo
echo "  1- Creating directory $dirref"
echo "     (if already existing, be erased)"
if test -d $dirref
   then rm -r $dirref
fi
mkdir $dirref

echo "  2- Copie of all *.out new files in $dirref"
cp $dirout/*.* $dirref
echo "  3- Done !"
echo
echo "Correct out files for comparisons with other OS/harware"

echo "  1- Creating directory $dircor"
echo "     (if already existing, be erased)"
if test -d $dircor
   then rm -r $dircor 
fi
mkdir $dircor

echo "  2- correct out files and put in $dircor"

list1=`ls -1 $dirout/*.out`
list2=`ls -1 $dirout/*.resu`

list="$list1 $list2"

for name in $list 
do
echo "     $name ..."
nameout=`basename $name`
sed -e s"/  \./ 0\./g" -e s"/ -\./-0\./g"  -e s"/-0\.0000/ 0\.0000/g" -e s"/-180\.00/ 180\.00/g" \
    -e s"/ -0\.000 /  0\.000 /g"  -e 's/ *$//' $name > $dircor/$nameout
done
echo
echo "  3- Done !"
echo "-----------------------------------------"
