/* rocotlib_V3p2.f -- translated by f2c (version 20100827).
   You must link the resulting object file with libf2c:
	on Microsoft Windows system, link with libf2c.lib;
	on Linux or Unix systems, link with .../path/to/libf2c.a -lm
	or, if you install libf2c.a in a standard place, with -lf2c -lm
	-- in that order, at the end of the command line, as in
		cc *.o -lf2c -lm
	Source for libf2c is in /netlib/f2c/libf2c.zip, e.g.,

		http://www.netlib.org/f2c/libf2c.zip
*/

#include "f2c.h"

/* Common Block Declarations */

struct {
    real suntim[1441], sunele[1441], sunazi[1441];
} sunvdh_;

#define sunvdh_1 sunvdh_

struct {
    real sgst, cgst, gst, slong, srasn, sdecl, obliq;
} timp00_;

#define timp00_1 timp00_

struct {
    real gs1, gs2, gs3, gm1, gm2, gm3, ge1, ge2, ge3, gr1, gr2, gr3;
} timp01_;

#define timp01_1 timp01_

struct {
    real ps1, ps2, ps3, gd1, gd2, gd3, pe1, pe2, pe3, pr1, pr2, pr3;
} timp02_;

#define timp02_1 timp02_

struct {
    real gmgs1, gmgs2, gmgs3, gegs1, gegs2, gegs3;
} timp03_;

#define timp03_1 timp03_

struct {
    real grgs1, grgs2, grgs3, grge1, grge2, grge3;
} timp04_;

#define timp04_1 timp04_

struct {
    real gdps1, gdps2, gdps3;
} timp05_;

#define timp05_1 timp05_

struct {
    real peps1, peps2, peps3, prps1, prps2, prps3;
} timp06_;

#define timp06_1 timp06_

struct {
    real xeima1, xeima2, xeima3, yeima1, yeima2, yeima3;
} timp07_;

#define timp07_1 timp07_

struct {
    real xeism1, xeism2, xeism3, yeism1, yeism2, yeism3;
} timp08_;

#define timp08_1 timp08_

struct {
    real yeigm1, yeigm2, yeigm3, zeigm1, zeigm2, zeigm3;
} timp09_;

#define timp09_1 timp09_

struct {
    real yeigq1, yeigq2, yeigq3, zeigq1, zeigq2, zeigq3;
} timp10_;

#define timp10_1 timp10_

struct {
    real stetq, ctetq, sdze, cdze, smu, cmu, sphi, cphi;
} timp11_;

#define timp11_1 timp11_

struct {
    real xeoma1, xeoma2, xeoma3, yeoma1, yeoma2, yeoma3;
} timp12_;

#define timp12_1 timp12_

struct {
    real xeosm1, xeosm2, xeosm3, yeosm1, yeosm2, yeosm3;
} timp13_;

#define timp13_1 timp13_

struct {
    real yeogm1, yeogm2, yeogm3, zeogm1, zeogm2, zeogm3;
} timp14_;

#define timp14_1 timp14_

struct {
    real yeogq1, yeogq2, yeogq3, zeogq1, zeogq2, zeogq3;
} timp15_;

#define timp15_1 timp15_

/* Table of constant values */

static doublereal c_b2 = 1e-13;
static integer c__9 = 9;
static integer c__1 = 1;
static real c_b16 = 360.f;
static real c_b28 = 1.f;
static integer c__3 = 3;
static doublereal c_b39 = 360.;
static integer c__23 = 23;
static integer c__59 = 59;
static integer c__30 = 30;
static integer c__2001 = 2001;
static integer c__4 = 4;

/* BEGIN ROCOTLIB 3.2 */

/* XX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */
/* XX                                                                  XX */
/* XX   Robert's Coordinates Transformation Library  ROCOTLIB          XX */
/* XX                                                                  XX */
/* XX            Revised  version 3.2, February 2020                   XX */
/* XX                    ___________________                           XX */
/* XX                                                                  XX */
/* XX             Version 1.0 initially supported by                   XX */
/* XX                                                                  XX */
/* XX                  EUROPEAN  SPACE  AGENCY                         XX */
/* XX                                                                  XX */
/* XX               Study of the Cluster Mission                       XX */
/* XX                 Planning Related Aspects                         XX */
/* XX          within the Numerical Simulations Network                XX */
/* XX                                                                  XX */
/* XX            Patrick ROBERT, CRPE, November 1992                   XX */
/* XX                    ___________________                           XX */
/* XX                                                                  XX */
/* XX Further versions developped by the Author:                       XX */
/* XX                                                                  XX */
/* XX    version 1.0, November 1992                                    xx */
/* XX    version 1.1, July     1993                                    xx */
/* XX    version 1.2, January  1995                                    xx */
/* XX    version 1.3, July     2000 (Julian day 2000 et sun dir)       xx */
/* XX    version 1.4, June     2001 (for automatic documentation)      xx */
/* XX    version 1.5, December 2001 (adding cp_sunrise_sunset)         xx */
/* XX    version 1.6, Juin     2002 (upgrade IGRF -> 2005)             xx */
/* XX    version 1.7, December 2002 (Version for CDPP)                 xx */
/* XX    version 1.8, November 2003 (adding t_sr2_to_sr)               xx */
/* XX    version 1.9, March    2004 (compatibility with IDL)           xx */
/* XX    version 2.0, November 2006 (Update  IGRF -> 2010)             xx */
/* XX    version 2.1, November 2010 (Update  IGRF -> 2015)             xx */
/* XX    version 2.2, December 2011 (cp_sunrise_sunset on polar zone   xx */
/* XX    version 3.0, February 2016 (IGRF -> table of geomagnetic pole XX */
/* XX                                -> 2020 + some other coord. sys.) XX */
/* XX    version 3.1, January  2019 (add name compatibility with V2.2) XX */
/* XX    version 3.2, February 2020 (add trans. with Euler angles)     XX */
/* XX                                                                  XX */
/* XX Copyright 1992, Patrick ROBERT, CNRS-ESA, All Rights reserved    XX */
/* XX                    ___________________                           XX */
/* XX                                                                  XX */
/* XX         For details, see the orginal document untitled:          XX */
/* XX CLUSTER Software Tools, part I: Coordinate Transformation LibraryXX */
/* XX             Document de travail DT/CRPE/1231                     XX */
/* XX             Patrick Robert, CRPE/TID, Juillet 1993               XX */
/* XX                                                                  XX */
/* XX         Available in CDPP:                                       XX */
/* XX             ROCOTLIB: a coordinate Transformation Library        XX */
/* XX             for Solar-Terrestrial studies                        XX */
/* XX             Patrick ROBERT, version 1.7 - January 2003,          XX */
/* XX             Rapport Interne no RI-CETP/02/2003                   XX */
/* XX                    ___________________                           XX */
/* XX                                                                  XX */
/* XX         The previous version 3.0 contains new transformations     XX */
/* XX         (TPN, MVA), and the cp_sunrise_sunset module allowing    XX */
/* XX         computation of sunrise and sunset anywhere on Earth,     XX */
/* XX         including polar zones.                                   XX */
/* XX                                                                  XX */
/* XX         The determination of the dipole axis direction           XX */
/* XX         has been replaced by a table available from years        XX */
/* XX         1900 to 2020, in order to have an easy way to code       XX */
/* XX         maintenance in the coming years.                         XX */
/* XX                                                                  XX */
/* XX         Operations on matrix (somme, product, inversion,         XX */
/* XX         computation of eigen vectors, diagonalization...)        XX */
/* XX         required for Minimum Variance Analysis coordinates       XX */
/* XX         have been added with prefix "mat_".                      XX */
/* XX                                                                  XX */
/* XX         The previous and temporary V3.1 is the same as 3.0       XX */
/* XX         but is compatible with V2.2 version concerning           XX */
/* XX         subroutine name (ex: tmaggsm -> t_mag_to_gsm)            XX */
/* XX                                                                  XX */
/* XX         The present V3.2 version contains transformations        XX */
/* XX         with Euler angles and their interpolation.               XX */
/* XX                                                                  XX */
/* XX         Fortran 90, C, and IDL codes are also available.         XX */
/* XX                                                                  XX */
/* XX                                                                  XX */
/* XX XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */


/*     ***************************************************************0** */

/*     Reminder for the developper: */
/*     Any changes leadind to a new version implies following actions: */
/*        - Update the file header above */
/*        - Update the subroutine g_rocot_version_number */
/*        - Update the subroutine print_rocot_info */
/*        - Update the readme.txt file in the full package */

/*     ***************************************************************0** */


/* Subroutine */ int cp_angle_and_ratio__(real *ux, real *uy, real *uz, real *
	vx, real *vy, real *vz, real *angle, real *ratio)
{
    /* Builtin functions */
    double sqrt(doublereal), d_sign(doublereal *, doublereal *);
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    double acos(doublereal);

    /* Local variables */
    static doublereal u1, u2, u3, v1, v2, v3, dp, ru, rv, cot;

    /* Fortran I/O blocks */
    static cilist io___11 = { 0, 6, 0, 0, 0 };
    static cilist io___12 = { 0, 6, 0, 0, 0 };
    static cilist io___13 = { 0, 6, 0, 0, 0 };
    static cilist io___14 = { 0, 6, 0, 0, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : basic compute modules of Rocotlib Software */
/* *   Object : compute_angle_and_ratio beetween U and V vectors */
/* *   Author : P. Robert, CRPE, 1992 */

/* *   Input  : ux,uy,uz */
/*              vx,vy,vz */

/* *   Output : sp=U.V */
/*              angle=angle beetween U and V (radians) */
/*              ratio= mod(U)/mod(V) */
/* ---------------------------------------------------------------------- */



    u1 = (doublereal) (*ux);
    u2 = (doublereal) (*uy);
    u3 = (doublereal) (*uz);
    v1 = (doublereal) (*vx);
    v2 = (doublereal) (*vy);
    v3 = (doublereal) (*vz);

    dp = u1 * v1 + u2 * v2 + u3 * v3;
    ru = sqrt(u1 * u1 + u2 * u2 + u3 * u3);
    rv = sqrt(v1 * v1 + v2 * v2 + v3 * v3);
    cot = dp / (ru * rv);
    cot -= d_sign(&c_b2, &cot);
    *ratio = (real) (ru / rv);
    if (cot >= 1.) {
	s_wsle(&io___11);
	do_lio(&c__9, &c__1, " *** Rocotlib/cp_angle_and_ratio: cos > 1 !!!", 
		(ftnlen)45);
	e_wsle();
	s_wsle(&io___12);
	do_lio(&c__9, &c__1, "                       angle set to 0.", (
		ftnlen)38);
	e_wsle();
	*angle = 0.f;
	return 0;
    }
    if (cot < -1.) {
	s_wsle(&io___13);
	do_lio(&c__9, &c__1, " *** Rocotlib/cp_angle_and_ratio: cos < 1 !!!", 
		(ftnlen)45);
	e_wsle();
	s_wsle(&io___14);
	do_lio(&c__9, &c__1, "                       angle set to 0.", (
		ftnlen)38);
	e_wsle();
	*angle = 0.f;
	return 0;
    }

    *angle = (real) acos(cot);

    return 0;
} /* cp_angle_and_ratio__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cp_euler_interp__(real *a1, real *b1, real *c1, real *a2,
	 real *b2, real *c2, real *ti, real *dt, real *ai, real *bi, real *ci)
{
    static real diff_a__, diff_b__, diff_c__;
    extern doublereal rmodulo_(real *, real *);


/* ---------------------------------------------------------------------- */
/* *   Class  : basic compute modules of Rocotlib Software */
/* *   Object : compute_Euler_angles_interpolation */
/* *   Author : P. Robert, SDev, 2020 */

/* *   Input  :  a1,b1,c1 Euler angles at time t1 */
/*               a2,b2,c2 Euler angles at time t2 */
/*               ti time for interpolation t1 < ti < t2 */
/*               dt = t2 - t1 */

/* *   Output :  ai,bi,ci Euler angles interpolated at time ti */
/* ---------------------------------------------------------------------- */

    diff_a__ = *a2 - *a1;
    diff_b__ = *b2 - *b1;
    diff_c__ = *c2 - *c1;
/*     WARNING: a does not vary linearly, it turns fast */
/*     while b and c vary slowly, */
/*     so we can do the linear interpolation on 2 and 3 */
/*     but not on a */
    diff_a__ = rmodulo_(&diff_a__, &c_b16);
/*     for 2 and 3 management of zero crossings */
    if (dabs(diff_b__) > 180.f) {
	if (diff_b__ < 0.f) {
	    diff_b__ += 360.f;
	} else {
	    diff_b__ += -360.f;
	}
    }
    if (dabs(diff_c__) > 180.f) {
	if (diff_c__ < 0.f) {
	    diff_c__ += 360.f;
	} else {
	    diff_c__ += -360.f;
	}
    }
/*     interpolate Euler angles */
    *ai = *a1 + diff_a__ * *ti / *dt;
    *bi = *b1 + diff_b__ * *ti / *dt;
    *ci = *c1 + diff_c__ * *ti / *dt;
    *ai = rmodulo_(a2, &c_b16);
    *bi = rmodulo_(b2, &c_b16);
    *ci = rmodulo_(c2, &c_b16);
    return 0;
} /* cp_euler_interp__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cp_geo_dipole_dir__(integer *iyear, integer *idoy, real *
	d1, real *d2, real *d3)
{
    /* Initialized data */

    static integer iy = -1;
    static integer id = -1;
    static integer ipr = -1;
    static real year[25] = { 1900.f,1905.f,1910.f,1915.f,1920.f,1925.f,1930.f,
	    1935.f,1940.f,1945.f,1950.f,1955.f,1960.f,1965.f,1970.f,1975.f,
	    1980.f,1985.f,1990.f,1995.f,2e3f,2005.f,2010.f,2015.f,2020.f };
    static real rlat[25] = { 78.68f,78.68f,78.66f,78.64f,78.63f,78.62f,78.6f,
	    78.57f,78.55f,78.55f,78.55f,78.54f,78.58f,78.6f,78.66f,78.76f,
	    78.88f,79.04f,79.21f,79.39f,79.61f,79.82f,80.09f,80.37f,80.65f };
    static real rlon[25] = { -68.79f,-68.75f,-68.72f,-68.57f,-68.38f,-68.27f,
	    -68.26f,-68.36f,-68.51f,-68.53f,-68.85f,-69.16f,-69.47f,-69.85f,
	    -70.18f,-70.47f,-70.76f,-70.9f,-71.13f,-71.42f,-71.57f,-71.81f,
	    -72.21f,-72.63f,-73.17f };

    /* Format strings */
    static char fmt_10[] = "(\002 * ROCOTLIB/cp_geo_dipole_dir: Warning! yea"
	    "r=\002,i4.4,\002   dipole direction can be computed between 1900"
	    "-2020.\002,\002   It will be computed for year \002,i4.4)";

    /* Builtin functions */
    integer s_wsfe(cilist *), do_fio(integer *, char *, ftnlen), e_wsfe(void);

    /* Local variables */
    static integer i__;
    static real d1p, d2p, d3p, alat, clat, alon, clon;
    extern /* Subroutine */ int t_sph_to_car__(real *, real *, real *, real *,
	     real *, real *);
    static real dyear;

    /* Fortran I/O blocks */
    static cilist io___27 = { 0, 6, 0, fmt_10, 0 };
    static cilist io___30 = { 0, 6, 0, fmt_10, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : basic compute modules of Rocotlib Software */
/* *   Object : compute_dipole_direction in GEO system */
/* *   Author : P. Robert, LPP , 2016 */

/* *   Input  :  iyear (1900 - 2020), idoy= day of year (1/1=1) */
/* *   Output :  d1,d2,d3  cartesian dipole components in GEO system */
/* ---------------------------------------------------------------------- */


/* *** table of geomagnetic Nort pole */
/*     International Geomagnetic Reference Field: the 12th generation, */
/*     Thbault et al. Earth, Planets and Space (2015) 67:79 , */
/*     DOI 10.1186/s40623-015-0228-9 */

/*     geomagnetice pole (N & S) are symmetric, so there are used to */
/*     define dipole axis. Do not mix up within the the North and south */
/*     magnetic pole (not symetric). */




/*                        ------------------------ */

/* *** Computation are not done if date is the same as previous call */

    if (*iyear == iy && *idoy == id) {
	*d1 = d1p;
	*d2 = d2p;
	*d3 = d3p;
	return 0;
    }

    iy = *iyear;
    id = *idoy;

/* *** Check date interval of validity */

/*     we are restricted by the interval 1965-2010, for which the igrf */
/*     coefficients are known; */
/*     if iyear is outside this interval, then the subroutine uses the */
/*     nearest limiting value and prints a warning: */

    if (iy < 1900) {
	iy = 1900;
	if (ipr != 1) {
	    s_wsfe(&io___27);
	    do_fio(&c__1, (char *)&(*iyear), (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&iy, (ftnlen)sizeof(integer));
	    e_wsfe();
	}
	ipr = 1;
	alat = rlat[0];
	alon = rlon[0];
    }
    if (iy > 2020) {
	iy = 2020;
	if (ipr != 1) {
	    s_wsfe(&io___30);
	    do_fio(&c__1, (char *)&(*iyear), (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&iy, (ftnlen)sizeof(integer));
	    e_wsfe();
	}
	ipr = 1;
	alat = rlat[24];
	alon = rlon[24];
    }

/* *** decimal year */

    dyear = (real) iy + (real) id / 365.25f;

/* *** find two known intervals */
    for (i__ = 2; i__ <= 25; ++i__) {
	if ((real) iy >= year[i__ - 2] && (real) iy <= year[i__ - 1]) {
	    alat = rlat[i__ - 2] + (rlat[i__ - 1] - rlat[i__ - 2]) * (dyear - 
		    year[i__ - 2]) / 5.f;
	    alon = rlon[i__ - 2] + (rlon[i__ - 1] - rlon[i__ - 2]) * (dyear - 
		    year[i__ - 2]) / 5.f;
	    goto L20;
	}
    }
L20:

/* *** direction of dipole axis in GEO system: */

    clat = (90.f - alat) * 3.141593f / 180.f;
    clon = alon * 3.141593f / 180.f;
    t_sph_to_car__(&c_b28, &clat, &clon, d1, d2, d3);

    d1p = *d1;
    d2p = *d2;
    d3p = *d3;


    return 0;
} /* cp_geo_dipole_dir__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cp_gei_sun_dir__(integer *iyear, integer *idoy, integer *
	ih, integer *im, integer *is, real *gst, real *slong, real *sra, real 
	*sdec, real *obliq)
{
    /* System generated locals */
    real r__1;
    doublereal d__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    /* Subroutine */ int s_stop(char *, ftnlen);
    double acos(doublereal), d_mod(doublereal *, doublereal *), sin(
	    doublereal), cos(doublereal), sqrt(doublereal), atan(doublereal), 
	    atan2(doublereal, doublereal);

    /* Local variables */
    static real g, t;
    static doublereal dj;
    static real sc, pi, vl, cob, sob, pre, slp;
    static doublereal fday;
    static real cosd, sind, pisd;
    static integer ileap;

    /* Fortran I/O blocks */
    static cilist io___35 = { 0, 6, 0, 0, 0 };
    static cilist io___36 = { 0, 6, 0, 0, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : basic compute modules of Rocotlib Software */
/* *   Object : compute_sun_direction in GEI system */
/* *   Author : CT.Russel, CE-D, 1971, rev. P.R., 1992,2001,2002 */

/* *   Comment: calculates four quantities in gei system necessary for */
/*              coordinate transformations dependent on sun position */
/*              (and, hence, on universal time and season) */
/*              Initial code from C.T. Russel, cosmic electro-dynamics, */
/*              v.2, 184-196, 1971. */
/*              accuracy: 0.006 degree. */
/*              Adaptation P.Robert, November 1992. */
/*              Revised and F90 compatibility, P. Robert June 2001. */
/*              Optimisation of DBLE computations and comments, */
/*              P. Robert, December 2002 */

/* *   Input  : iyear : year (1901-2099) */
/*              idoy : day of the year (1 for january 1) */
/*              ih,im,is : hours, minutes, seconds U.T. */

/* *   Output : gst      greenwich mean sideral time (radians) */
/*              slong    longitude along ecliptic (radians) */
/*              sra      right ascension (radians) */
/*              sdec     declination of the sun (radians) */
/*              obliq    inclination of Earth's axis (radians) */
/* ---------------------------------------------------------------------- */



    if (*iyear < 1901 || *iyear > 2099) {
	s_wsle(&io___35);
	do_lio(&c__9, &c__1, "*** Rocotlib/cp_gei_sun_dir: year = ", (ftnlen)
		36);
	do_lio(&c__3, &c__1, (char *)&(*iyear), (ftnlen)sizeof(integer));
	e_wsle();
	s_wsle(&io___36);
	do_lio(&c__9, &c__1, "*** Rocotlib/cp_gei_sun_dir: year must be >190"
		"0 and <2099", (ftnlen)57);
	e_wsle();
	s_stop("*** Rocotlib/cp_gei_sun_dir: year must be >1901 and <3000", (
		ftnlen)57);
    }

    pi = acos(-1.f);
    pisd = pi / 180.f;

/* *** Julian day and greenwich mean sideral time */

    fday = (doublereal) (*ih * 3600 + *im * 60 + *is) / 86400.;
    ileap = (*iyear - 1901) / 4;
/*     Note: year 2000 is a leap year, line above is right */
    dj = (doublereal) ((*iyear - 1900) * 365 + ileap + *idoy) - .5 + fday;
    d__1 = dj * .9856473354 + 279.690983 + fday * 360. + 180.;
    *gst = (real) d_mod(&d__1, &c_b39) * pisd;

/* *** longitude along ecliptic */

    d__1 = dj * .9856473354 + 279.696678;
    vl = (real) d_mod(&d__1, &c_b39);
    t = (real) (dj / 36525.);
    d__1 = dj * .985600267 + 358.475845;
    g = (real) d_mod(&d__1, &c_b39) * pisd;
    *slong = (vl + (1.91946f - t * .004789f) * sin(g) + sin(g * 2.f) * 
	    .020094f) * pisd;

/* *** inclination of Earth's axis */

    *obliq = (23.45229f - t * .0130125f) * pisd;
    sob = sin(*obliq);
    cob = cos(*obliq);

/*     precession of declination (about 0.0056 deg., ajou P. Robert) */

    pre = (.0055686f - t * 2.5e-6f) * pisd;

/* *** declination of the sun */

    slp = *slong - pre;
    sind = sob * sin(slp);
/* Computing 2nd power */
    r__1 = sind;
    cosd = sqrt(1.f - r__1 * r__1);
    sc = sind / cosd;
    *sdec = atan(sc);

/* *** right ascension of the sun */

    *sra = pi - atan2(cob / sob * sc, -cos(slp) / cosd);

    return 0;
} /* cp_gei_sun_dir__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cp_sunrise_sunset__(integer *iyear, integer *imon, 
	integer *iday, real *rlat, real *rlon, char *tmer, char *tris, char *
	tset, char *durd, real *elemer, real *azimer, real *eleris, real *
	aziris, real *eleset, real *aziset, integer *icor, ftnlen tmer_len, 
	ftnlen tris_len, ftnlen tset_len, ftnlen durd_len)
{
    /* Format strings */
    static char fmt_100[] = "(i2.2,\002:\002,i2.2,\002:\002,i2.2)";
    static char fmt_200[] = "(i2,\002:\002,i2.2,\002:\002,i2.2)";

    /* System generated locals */
    integer i__1;
    icilist ici__1;

    /* Builtin functions */
    integer i_len(char *, ftnlen), s_wsle(cilist *), do_lio(integer *, 
	    integer *, char *, ftnlen), e_wsle(void);
    /* Subroutine */ int s_stop(char *, ftnlen);
    double acos(doublereal), sin(doublereal), tan(doublereal);
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);
    integer s_wsfi(icilist *), do_fio(integer *, char *, ftnlen), e_wsfi(void)
	    , s_cmp(char *, char *, ftnlen, ftnlen);

    /* Local variables */
    extern /* Subroutine */ int cv_date_to_jul2000__(integer *, integer *, 
	    integer *, integer *), cv_jul2000_to_date__(integer *, integer *, 
	    integer *, integer *);
    static real h__, r__;
    extern /* Subroutine */ int g_gei_geo_sun_dir__(real *, real *, real *, 
	    real *, real *, real *);
    static integer ih, im;
    static real sd, sh;
    static integer is;
    extern /* Subroutine */ int cv_msotd_to_hmsms__(integer *, integer *, 
	    integer *, integer *, integer *);
    static real sv;
    static integer jd00;
    static real deg, phi, cor, sdp;
    static integer ims;
    static real tet, svp;
    static integer isec, imer, lmer, imin;
    static real epsi;
    static integer ldur, lset, lris;
    extern /* Subroutine */ int t_geo_to_vdh__(real *, real *, real *, real *,
	     real *, real *, real *, real *), t_car_to_sph__(real *, real *, 
	    real *, real *, real *, real *), t_sph_to_car__(real *, real *, 
	    real *, real *, real *, real *);
    static integer idiff, idayp, mimer[2];
    static real tetnc, vemer[2], sxgei, sygei, szgei;
    static integer imonp, ismax;
    static real sxgeo, sygeo, szgeo, svmin;
    extern /* Subroutine */ int cp_time_param__(integer *, integer *, integer 
	    *, integer *, integer *, integer *);
    static integer milmer, milmin;
    static real cormax;
    static integer iyearp, milset, milris, millsec;

    /* Fortran I/O blocks */
    static cilist io___56 = { 0, 6, 0, 0, 0 };
    static cilist io___57 = { 0, 6, 0, 0, 0 };
    static cilist io___58 = { 0, 6, 0, 0, 0 };
    static cilist io___59 = { 0, 6, 0, 0, 0 };
    static cilist io___60 = { 0, 6, 0, 0, 0 };
    static cilist io___61 = { 0, 6, 0, 0, 0 };
    static cilist io___62 = { 0, 6, 0, 0, 0 };
    static cilist io___63 = { 0, 6, 0, 0, 0 };
    static cilist io___102 = { 0, 6, 0, 0, 0 };
    static cilist io___103 = { 0, 6, 0, 0, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : basic compute modules of Rocotlib Software */
/* *   Object : compute_sunset_time and others */
/* *   Author : P. Robert, CRPE, 2001 Revised Dec. 2011 */
/* *   Comment: Spherical Earth assumed */

/* *   Input  : iyear,imon,iday, rlat, rlong (rad) */
/*              icor: type de correction */
/*                  0 pas de correction */
/*                  1: correction de la refraction atmospherique seule */
/*                     (calcul comparable a l'IMC, ancien BDL) */
/*                  2: correction de la refraction et du bord superieur */
/*                     du soleil (calcul de la SAF). */
/*                  3: correction de la refraction avec l'elevation */
/*                     pour le passage au meridien (utile pour les zones */
/*                     polaires, ou le soleil peut raser l'horizon */
/*                     a midi) */

/*                  voir explications plus precises ci-dessous */

/* *   Output : tmer,tris,tset,durd on char*8 format, as '23:42:37' */
/*              tmer: Sun Meridian time (local noon) */
/*              tris: Sunrise time */
/*              tset: Sunset  time */
/*              durd: Duration of the day */

/*              elemer; elevation, en degres, du soleil au meridin */
/*              azimer: azimuth, en degres, a partir du nord vers l'est */
/*                      du soleil au meridien */
/*              eleris,aziris: meme chose pour le lever de soleil */
/*              eleset,aziset: meme chose pour le coucher */

/*              /sunVDH/ trajectoire du Soleil pendant la journe */
/*              Accuracy: 10 sec. */

/*    Les valeures pour Paris (latitude moyenne) et Tromso (zone polaire) */
/*    ont ete comparees aux ephemerides de l'institut de mecanique */
/*    celeste (anciennement bureau des longitudes) avec icor=1 */
/*    Les resultats sont comparables a la minute prs pour les levers */
/*    et couchers, et a quelques secondes d'arc pour les elevations et */
/*    azimuts, y compris dans les zones polaires et pour les transitions */
/*    avec les nuits polaires ou jours polaires (pas de lever ni coucher) */

/* ---------------------------------------------------------------------- */

/* *** calcul des heures de lever et coucher de soleil: */
/*     correction du diametre apparent du soleil et de la refraction */
/*     a l'horizon. Les valeurs prises sont extraites de l'ouvrage */
/*     "introduction aux ephemerides astronomiques", publie par le */
/*     Bureau Des Longitudes. */
/*     Diametre apparent du soleil: 32' */
/*     Refraction a l'horizon     : 34' (36.6 pour le BDL) */
/*     correction= 32'/2 + 34' = 50' */

/* *** Attention : */
/*     Les Ephemrides Astronomiques du Bureau des Longitudes ne tiennent */
/*     compte que de la refraction a laquelle elles donnent la valeur */
/*     r = 36,6'. */
/*     Les Ephemrides Astronomiques de la S.A.F. considere le lever comme */
/*     l'apparition de son bord superieur. */
/*     Elles utilisent la valeur ht = -50'. */

/* *   variation avec la temperature et la pression: */
/*     on peut utiliser la formule de Bennet, pour corriger la refraction */
/*     en la multipliant par le coefficient: */
/*     (P/1010)(283/(273+T)) */
/*     avec P en millibar et T en Celsius. */
/*     Note: Le BDL prend 1 pour cette correction, donc */
/*     suppose une presion P=1010 et une temperature T=10 deg. */

/* *   variation de R avec la hauteur apparente: */
/*     Une formule assez simple est donne par Bennet : */
/*     R = 1/Tan[h+7,31/(h+4,4)] */
/*     avec h en degre et R en minute d'arc */
/*     soit pour h=0 on trouve R= 34.5 */
/*          pour h=45          R=  0.99' */
/*     (34' et 1' etant les valeurs couramment admises) */

/* *   Crepuscules : par definition la fin (le soir) ou le debut */
/*     (le matin) des crepuscules civil, nautique et astronomique */
/*     se produit quand le centre du Soleil est abaisse de 6, 12 et 18 */
/*     degres sous l'horizon. */
/* ---------------------------------------------------------------------- */


    lmer = i_len(tmer, tmer_len);
    lris = i_len(tris, tris_len);
    lset = i_len(tset, tset_len);
    ldur = i_len(durd, durd_len);

    if (lmer < 8) {
	s_wsle(&io___56);
	do_lio(&c__9, &c__1, "*** Rocotlib/cp_sunrise_sunset: tmer must be c"
		"har*8", (ftnlen)51);
	e_wsle();
	s_wsle(&io___57);
	do_lio(&c__9, &c__1, "    len=", (ftnlen)8);
	do_lio(&c__3, &c__1, (char *)&lmer, (ftnlen)sizeof(integer));
	e_wsle();
	s_stop("cp_sunrise_sunset: tmer must be char*8 variable", (ftnlen)47);
    }

    if (lris < 8) {
	s_wsle(&io___58);
	do_lio(&c__9, &c__1, "*** Rocotlib/cp_sunrise_sunset: tris must be c"
		"har*8", (ftnlen)51);
	e_wsle();
	s_wsle(&io___59);
	do_lio(&c__9, &c__1, "    len=", (ftnlen)8);
	do_lio(&c__3, &c__1, (char *)&lris, (ftnlen)sizeof(integer));
	e_wsle();
	s_stop("cp_sunrise_sunset: tris must be char*8 variable", (ftnlen)47);
    }

    if (lset < 8) {
	s_wsle(&io___60);
	do_lio(&c__9, &c__1, "*** Rocotlib/cp_sunrise_sunset: tset must be c"
		"har*8", (ftnlen)51);
	e_wsle();
	s_wsle(&io___61);
	do_lio(&c__9, &c__1, "    len=", (ftnlen)8);
	do_lio(&c__3, &c__1, (char *)&lset, (ftnlen)sizeof(integer));
	e_wsle();
	s_stop("cp_sunrise_sunset: tset must be char*8 variable", (ftnlen)47);
    }

    if (ldur < 8) {
	s_wsle(&io___62);
	do_lio(&c__9, &c__1, "*** Rocotlib/cp_sunrise_sunset: durd must be c"
		"har*8", (ftnlen)51);
	e_wsle();
	s_wsle(&io___63);
	do_lio(&c__9, &c__1, "    len=", (ftnlen)8);
	do_lio(&c__3, &c__1, (char *)&ldur, (ftnlen)sizeof(integer));
	e_wsle();
	s_stop("cp_sunrise_sunset: durd must be char*8 variable", (ftnlen)47);
    }

    milris = -1;
    milset = -1;
    milmer = -1;
    milmin = -1;
    imer = 0;
    vemer[0] = -2.f;
    vemer[1] = -2.f;

    sdp = 0.f;
    svp = 0.f;
    deg = 180.f / acos(-1.f);

/* *   tolerance de 1 degre sur le meridien quand le soleil est */
/*     au ras de l'horizon et donc sujet a la refraction */

    cormax = 1.f;
    svmin = -sin(cormax / deg);
/* *** initialisation de sdp=sd et svp=sv pour le jour d'avant */
    cv_date_to_jul2000__(iyear, imon, iday, &jd00);
    --jd00;
    cv_jul2000_to_date__(&jd00, &iyearp, &imonp, &idayp);
    cp_time_param__(&iyearp, &imonp, &idayp, &c__23, &c__59, &c__30);
    g_gei_geo_sun_dir__(&sxgei, &sygei, &szgei, &sxgeo, &sygeo, &szgeo);
    t_geo_to_vdh__(&sxgeo, &sygeo, &szgeo, rlat, rlon, &sv, &sd, &sh);
/* *   correction de la refraction (voir + loin) */
    t_car_to_sph__(&sd, &sh, &sv, &r__, &tetnc, &phi);
/* *   pas de correction de refraction par defaut */
    tet = tetnc;
/* *   calcul de la refraction a l'horizon */
    if (*icor > 0) {
	if (*icor == 1) {
	    cor = .60999999999999999f;
	} else {
	    cor = .83333333333333337f;
	}
	tet = tetnc - cor / deg;
	t_sph_to_car__(&r__, &tet, &phi, &sd, &sh, &sv);
    }
    sdp = sd;
    svp = sv;
    iyearp = *iyear;
    imonp = *imon;
    idayp = *iday;
    ismax = 50;

/*     ---------------------------------------------- */
/*     boucle sur le temps de la journee */
/*     ---------------------------------------------- */
    for (imin = 0; imin <= 1440; ++imin) {
	if (imin == 1440) {
	    cv_date_to_jul2000__(iyear, imon, iday, &jd00);
	    ++jd00;
	    cv_jul2000_to_date__(&jd00, iyear, imon, iday);
	    ismax = 30;
	}
	i__1 = ismax;
	for (is = 0; is <= i__1; is += 10) {
	    if (imin < 1440) {
		isec = imin * 60 + is;
	    } else {
		isec = is;
	    }

/* *** calcul de la direction du Soleil dans le VDH pour chaque pas de */
/*     temps de la journee en cours ( precision 10 sec) */
	    millsec = isec * 1000;
	    cv_msotd_to_hmsms__(&millsec, &ih, &im, &is, &ims);
	    cp_time_param__(iyear, imon, iday, &ih, &im, &is);
	    g_gei_geo_sun_dir__(&sxgei, &sygei, &szgei, &sxgeo, &sygeo, &
		    szgeo);
	    t_geo_to_vdh__(&sxgeo, &sygeo, &szgeo, rlat, rlon, &sv, &sd, &sh);

/* *** calcul des heures de lever et coucher de soleil: */
/*     correction du diametre apparent du soleil et de la refraction */
/*     a l'horizon. Les valeurs prises sont extraites de l'ouvrage */
/*     "introduction aux ephemerides astronomiques", publie par le */
/*     Bureau Des Longitudes. */
/*     Diametre apparent du soleil: 32' */
/*     Refraction a l'horizon     : 34' */
/*     correction= 32'/2 + 34' = 50' */

/* *** Attention : */
/*     Les Ephemrides Astronomiques du Bureau des Longitudes ne tiennent */
/*     compte que de la refraction a laquelle elles donnent la valeur */
/*     r = 36,6'. */
/*     Les Ephemrides Astronomiques de la S.A.F. considere le lever comme */
/*     l'apparition de son bord superieur. */
/*     Elles utilisent la valeur ht = -50'. */


/* *   dans le reperes DHV, teta est l'angle entre la verticale sortante */
/*     et la direction du Soleil */
	    t_car_to_sph__(&sd, &sh, &sv, &r__, &tetnc, &phi);
/* *   pas de correction de refraction par defaut */
	    tet = tetnc;
/* *   calcul de la refraction a l'horizon */
	    if (*icor > 0) {
		if (*icor == 1) {
		    cor = .60999999999999999f;
		} else {
		    cor = .83333333333333337f;
		}
		tet = tetnc - cor / deg;
		t_sph_to_car__(&r__, &tet, &phi, &sd, &sh, &sv);
/* *   calcul de la refraction a teta pour le calcul de la trajectoire */
/*     Quand le Soleil est vertical (tet=0), la correction est minime; */
/*     Quand le soleil est proche de l'horizon (tet=90) cor=34' */
		if (*icor == 3) {
		    h__ = 90.f - tet * deg;
		    cor = 1.f / tan((h__ + 7.31f / (h__ + 4.4f)) / deg);
		    cor /= 60.f;
		}
		tet = tetnc - cor / deg;
	    }
/* *** chargement du common /sunVDH/ */
/*     resolution en temps: 1mn */
/*     l'azimut est compt positivement depuis le Nors vers l'Est */
	    if (is == 0) {
		sunvdh_1.suntim[imin] = (real) imin;
		sunvdh_1.sunele[imin] = 90.f - tet * deg;
		sunvdh_1.sunazi[imin] = 90.f - phi * deg;
	    }

/* *** calcul du midi local, quand D (vers l'est) change de signe */
/*     attention: dans le cas du soleil de minuit, il y a deux meridien */
/*     ou le soleil est visible. */
/*     On prend celui ou le soleil est au plus haut */
/*     (a midi, et non pas a minuit) */

	    if (sv > svmin && sd * sdp < 0.f) {
		++imer;
		if (imer > 2) {
		    s_wsle(&io___102);
		    do_lio(&c__9, &c__1, "**Rocotlib more than 2 meridian cr"
			    "ossing!", (ftnlen)41);
		    e_wsle();
		    s_wsle(&io___103);
		    do_lio(&c__9, &c__1, "           last is taken into acco"
			    "unt", (ftnlen)37);
		    e_wsle();
		    goto L21;
		}
		mimer[imer - 1] = isec * 1000;
		vemer[imer - 1] = sv;
	    }
L21:

/* *** calcul du temps ou l'elevation est minimum (soleil de minuit) */

	    if (sv >= 0.f && svp >= 0.f && sv < svp) {
		milmin = isec * 1000;
	    }

/* *** on a une transition (lever ou couche) quand V (vertical sortante) */
/*     change de signe (unite: millisec du jour) */

/* *   cas ou sv est nul (le soleil est a l'horizon) */

	    epsi = 1e-6f;
/* cc   if(sv.eq.0.) then */
	    if (dabs(sv) < epsi) {
		sv = 0.f;
		if (svp < 0.f) {
/*                    juste avant, le soleil etait sous l'horizon */
/*                    la transition est donc un lever de soleil */
		    milris = isec * 1000;
		} else {
/*                    juste avant, le soleil etait au dessus de l'horizon */
/*                    la transition est donc un coucher de soleil */
		    milset = isec * 1000;
		}
/* cc   print*, '          cas 1 sv,svp=',sv,svp,' ris,set=',milris,milset */
		goto L20;
	    }
/* *   cas ou svp est nul (le soleil etait a l'horizon) */

	    if (dabs(svp) < epsi) {
		if (sv > 0.f) {
/*                    le soleil est au dessus de l'horizon */
/*                    la transition est donc un lever de soleil */
		    milris = isec * 1000;
		} else {
/*                    le soleil est au dessous de l'horizon */
/*                    la transition est donc un coucher de soleil */
		    milset = isec * 1000;
		}
/* cc   print*, '          cas 2 sv,svp=',sv,svp,' ris,set=',milris,milset */
		goto L20;
	    }

/* *   sv et svp sont non nuls */

	    if (sv * svp < 0.f) {
/*              si sv et svp sont de signe contraire, on a une transition */
/*              (lever ou coucher) */
		if (sv > 0.f) {
/*                    le soleil passe au passe au dessus de l'horizon */
/*                    la transition est donc un lever de soleil */
		    milris = isec * 1000;
		} else {
/*                    le soleil passe au passe au dessous de l'horizon */
/*                    la transition est donc un coucher de soleil */
		    milset = isec * 1000;
		}
/* cc   print*, '         cas 3 sv,svp=',sv,svp,' ris,set=',milris,milset */
	    }
L20:
	    sdp = sd;
	    svp = sv;
/* L8: */
	}
/* L10: */
    }

/*     ---------------------------------------------- */
/*     la boucle sur le temps de la journee est finie */
/*     ---------------------------------------------- */
/* *   on restaure le jour en cours */
    *iyear = iyearp;
    *imon = imonp;
    *iday = idayp;
/* *** encodage des resultats sous la forme HH:MM:SS */
/*     et calcul de l'elevation et de l'azimuth pour chacun des 3 cas */

    s_copy(tmer, "night   ", tmer_len, (ftnlen)8);
    s_copy(tris, "no SR   ", tris_len, (ftnlen)8);
    s_copy(tset, "no SS   ", tset_len, (ftnlen)8);
    s_copy(durd, "00:00:00", durd_len, (ftnlen)8);
    *elemer = 999.f;
    *eleris = 999.f;
    *eleset = 999.f;
    *azimer = 999.f;
    *aziris = 999.f;
    *aziset = 999.f;

/* *   choix du midi local si soleil de minuit */

    if (imer > 0) {
	if (vemer[0] > vemer[1]) {
	    milmer = mimer[0];
	} else {
	    milmer = mimer[1];
	}
    }

/* *   calcul des positions au temps du meridien */

    if (milmer > -1) {
	cv_msotd_to_hmsms__(&milmer, &ih, &im, &is, &ims);
	ici__1.icierr = 0;
	ici__1.icirnum = 1;
	ici__1.icirlen = tmer_len;
	ici__1.iciunit = tmer;
	ici__1.icifmt = fmt_100;
	s_wsfi(&ici__1);
	do_fio(&c__1, (char *)&ih, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&im, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&is, (ftnlen)sizeof(integer));
	e_wsfi();
	cp_time_param__(iyear, imon, iday, &ih, &im, &is);
	g_gei_geo_sun_dir__(&sxgei, &sygei, &szgei, &sxgeo, &sygeo, &szgeo);
	t_geo_to_vdh__(&sxgeo, &sygeo, &szgeo, rlat, rlon, &sv, &sd, &sh);
	t_car_to_sph__(&sd, &sh, &sv, &r__, &tet, &phi);

	if (*icor == 3) {
/*                         calcul de la refraction a teta */
	    h__ = 90.f - tet * deg;
	    cor = 1.f / tan((h__ + 7.31f / (h__ + 4.4f)) / deg);
	    cor /= 60.f;
	    tet -= cor / deg;
	}
	*elemer = 90.f - tet * deg;
	*azimer = 90.f - phi * deg;
    }

/* *   duree du jour calculee seuleument si le lever et le coucher */
/*     sont definis */

    if (milris > -1 && milset > -1) {
	idiff = milset - milris;
	if (idiff < 0) {
	    idiff += 86400000;
	}
	cv_msotd_to_hmsms__(&idiff, &ih, &im, &is, &ims);
	ici__1.icierr = 0;
	ici__1.icirnum = 1;
	ici__1.icirlen = durd_len;
	ici__1.iciunit = durd;
	ici__1.icifmt = fmt_200;
	s_wsfi(&ici__1);
	do_fio(&c__1, (char *)&ih, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&im, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&is, (ftnlen)sizeof(integer));
	e_wsfi();
    } else {
	if (*elemer > 0.f && *elemer < 180.f) {
	    s_copy(durd, "24:00:00", durd_len, (ftnlen)8);
	}
    }


/* *** cas du soleil de minuit: lever = coucher= temp elevation min */

    if (s_cmp(durd, "24:00:00", durd_len, (ftnlen)8) == 0 && milmin > -1) {
	milris = milmin;
	milset = milmin;
    }

    if (milris > -1) {
	cv_msotd_to_hmsms__(&milris, &ih, &im, &is, &ims);
	ici__1.icierr = 0;
	ici__1.icirnum = 1;
	ici__1.icirlen = tris_len;
	ici__1.iciunit = tris;
	ici__1.icifmt = fmt_100;
	s_wsfi(&ici__1);
	do_fio(&c__1, (char *)&ih, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&im, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&is, (ftnlen)sizeof(integer));
	e_wsfi();
	cp_time_param__(iyear, imon, iday, &ih, &im, &is);
	g_gei_geo_sun_dir__(&sxgei, &sygei, &szgei, &sxgeo, &sygeo, &szgeo);
	t_geo_to_vdh__(&sxgeo, &sygeo, &szgeo, rlat, rlon, &sv, &sd, &sh);
	t_car_to_sph__(&sd, &sh, &sv, &r__, &tet, &phi);
	*eleris = 90.f - tet * deg;
	*aziris = 90.f - phi * deg;
    }

    if (milset > -1) {
	cv_msotd_to_hmsms__(&milset, &ih, &im, &is, &ims);
	ici__1.icierr = 0;
	ici__1.icirnum = 1;
	ici__1.icirlen = tset_len;
	ici__1.iciunit = tset;
	ici__1.icifmt = fmt_100;
	s_wsfi(&ici__1);
	do_fio(&c__1, (char *)&ih, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&im, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&is, (ftnlen)sizeof(integer));
	e_wsfi();
	cp_time_param__(iyear, imon, iday, &ih, &im, &is);
	g_gei_geo_sun_dir__(&sxgei, &sygei, &szgei, &sxgeo, &sygeo, &szgeo);
	t_geo_to_vdh__(&sxgeo, &sygeo, &szgeo, rlat, rlon, &sv, &sd, &sh);
	t_car_to_sph__(&sd, &sh, &sv, &r__, &tet, &phi);
	*eleset = 90.f - tet * deg;
	*aziset = 90.f - phi * deg;
    }

    return 0;
} /* cp_sunrise_sunset__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cp_time_param__(integer *iyear, integer *imonth, integer 
	*iday, integer *ih, integer *im, integer *is)
{
    /* Initialized data */

    static integer idoy = -1;

    /* System generated locals */
    real r__1, r__2, r__3;

    /* Builtin functions */
    double sqrt(doublereal), cos(doublereal), sin(doublereal);
    /* Subroutine */ int s_stop(char *, ftnlen);

    /* Local variables */
    static real q;
    extern /* Subroutine */ int cp_geo_dipole_dir__(integer *, integer *, 
	    real *, real *, real *);
    static real dec, rad, qd12, qm12, ras, epsi, rgmgs, rgdps, rgrgs, rprps;
    extern /* Subroutine */ int cp_gei_sun_dir__(integer *, integer *, 
	    integer *, integer *, integer *, real *, real *, real *, real *, 
	    real *), cv_date_to_doty__(integer *, integer *, integer *, 
	    integer *);


/* ---------------------------------------------------------------------- */
/* *   Class  : basic compute modules of Rocotlib Software */
/* *   Object : compute_time_parameters and time-dependent matrix */
/* *   Author : P. Robert, CRPE, 1992 */

/* *   Comment: Prepare all time varying quantities for computations of */
/*              coordinate transforms of the library. */

/* *   Input  : iyear,imonth,iday (1901<year<2099) */
/*              ih,im,is : hours, minutes, seconds U.T. */
/* *   Output : in common statements */
/* ---------------------------------------------------------------------- */







/* *** day of year */

    cv_date_to_doty__(iyear, imonth, iday, &idoy);

/* *** Dipole direction in GEO system */

    cp_geo_dipole_dir__(iyear, &idoy, &timp02_1.gd1, &timp02_1.gd2, &
	    timp02_1.gd3);

/* Computing 2nd power */
    r__1 = timp02_1.gd1;
/* Computing 2nd power */
    r__2 = timp02_1.gd2;
    qd12 = sqrt(r__1 * r__1 + r__2 * r__2);

/* *** Sun direction in GEI (from right ascension and declination), */
/*     greenwich mean sideral time and longitude along ecliptic */

    cp_gei_sun_dir__(iyear, &idoy, ih, im, is, &timp00_1.gst, &timp00_1.slong,
	     &timp00_1.srasn, &timp00_1.sdecl, &timp00_1.obliq);

    timp01_1.gs1 = cos(timp00_1.srasn) * cos(timp00_1.sdecl);
    timp01_1.gs2 = sin(timp00_1.srasn) * cos(timp00_1.sdecl);
    timp01_1.gs3 = sin(timp00_1.sdecl);

/* *** sin and cos of GMST */

    timp00_1.sgst = sin(timp00_1.gst);
    timp00_1.cgst = cos(timp00_1.gst);

/* *** ecliptic pole in GEI system */

    timp01_1.ge1 = 0.f;
    timp01_1.ge2 = -sin(timp00_1.obliq);
    timp01_1.ge3 = cos(timp00_1.obliq);

/* *** direction of the rotation axis of the sun in GEI system */
/*     (from C.T. Russell, Cosmic Electro-dynamics, V.2, 184-196, 1971.) */

    rad = 57.29578f;

    ras = -74.f / rad;
    dec = 63.8f / rad;

    timp01_1.gr1 = cos(ras) * cos(dec);
    timp01_1.gr2 = sin(ras) * cos(dec);
    timp01_1.gr3 = sin(dec);

/* *** dipole direction in GEI system */

    timp01_1.gm1 = timp02_1.gd1 * timp00_1.cgst - timp02_1.gd2 * 
	    timp00_1.sgst;
    timp01_1.gm2 = timp02_1.gd1 * timp00_1.sgst + timp02_1.gd2 * 
	    timp00_1.cgst;
    timp01_1.gm3 = timp02_1.gd3;

/* Computing 2nd power */
    r__1 = timp01_1.gm1;
/* Computing 2nd power */
    r__2 = timp01_1.gm2;
    qm12 = sqrt(r__1 * r__1 + r__2 * r__2);

/* *** direction of the sun in GEO system */

    timp02_1.ps1 = timp01_1.gs1 * timp00_1.cgst + timp01_1.gs2 * 
	    timp00_1.sgst;
    timp02_1.ps2 = -timp01_1.gs1 * timp00_1.sgst + timp01_1.gs2 * 
	    timp00_1.cgst;
    timp02_1.ps3 = timp01_1.gs3;

/* *** direction of the ecliptic in GEO system */

    timp02_1.pe1 = timp01_1.ge1 * timp00_1.cgst + timp01_1.ge2 * 
	    timp00_1.sgst;
    timp02_1.pe2 = -timp01_1.ge1 * timp00_1.sgst + timp01_1.ge2 * 
	    timp00_1.cgst;
    timp02_1.pe3 = timp01_1.ge3;

/* *** direction of the rotation axis of the sun in GEO system */

    timp02_1.pr1 = timp01_1.gr1 * timp00_1.cgst + timp01_1.gr2 * 
	    timp00_1.sgst;
    timp02_1.pr2 = -timp01_1.gr1 * timp00_1.sgst + timp01_1.gr2 * 
	    timp00_1.cgst;
    timp02_1.pr3 = timp01_1.gr3;

/* *** cross product MxS in GEI system */

    timp03_1.gmgs1 = timp01_1.gm2 * timp01_1.gs3 - timp01_1.gm3 * 
	    timp01_1.gs2;
    timp03_1.gmgs2 = timp01_1.gm3 * timp01_1.gs1 - timp01_1.gm1 * 
	    timp01_1.gs3;
    timp03_1.gmgs3 = timp01_1.gm1 * timp01_1.gs2 - timp01_1.gm2 * 
	    timp01_1.gs1;

/* Computing 2nd power */
    r__1 = timp03_1.gmgs1;
/* Computing 2nd power */
    r__2 = timp03_1.gmgs2;
/* Computing 2nd power */
    r__3 = timp03_1.gmgs3;
    rgmgs = sqrt(r__1 * r__1 + r__2 * r__2 + r__3 * r__3);

/* *** cross product ExS in GEI system */

    timp03_1.gegs1 = timp01_1.ge2 * timp01_1.gs3 - timp01_1.ge3 * 
	    timp01_1.gs2;
    timp03_1.gegs2 = timp01_1.ge3 * timp01_1.gs1 - timp01_1.ge1 * 
	    timp01_1.gs3;
    timp03_1.gegs3 = timp01_1.ge1 * timp01_1.gs2 - timp01_1.ge2 * 
	    timp01_1.gs1;

/* *** cross product RxS in GEI system */

    timp04_1.grgs1 = timp01_1.gr2 * timp01_1.gs3 - timp01_1.gr3 * 
	    timp01_1.gs2;
    timp04_1.grgs2 = timp01_1.gr3 * timp01_1.gs1 - timp01_1.gr1 * 
	    timp01_1.gs3;
    timp04_1.grgs3 = timp01_1.gr1 * timp01_1.gs2 - timp01_1.gr2 * 
	    timp01_1.gs1;

/* Computing 2nd power */
    r__1 = timp04_1.grgs1;
/* Computing 2nd power */
    r__2 = timp04_1.grgs2;
/* Computing 2nd power */
    r__3 = timp04_1.grgs3;
    rgrgs = sqrt(r__1 * r__1 + r__2 * r__2 + r__3 * r__3);

/* *** cross product RxE in GEI system */

    timp04_1.grge1 = timp01_1.gr2 * timp01_1.ge3 - timp01_1.gr3 * 
	    timp01_1.ge2;
    timp04_1.grge2 = timp01_1.gr3 * timp01_1.ge1 - timp01_1.gr1 * 
	    timp01_1.ge3;
    timp04_1.grge3 = timp01_1.gr1 * timp01_1.ge2 - timp01_1.gr2 * 
	    timp01_1.ge1;

/* *** cross product DxS in GEO system */

    timp05_1.gdps1 = timp02_1.gd2 * timp02_1.ps3 - timp02_1.gd3 * 
	    timp02_1.ps2;
    timp05_1.gdps2 = timp02_1.gd3 * timp02_1.ps1 - timp02_1.gd1 * 
	    timp02_1.ps3;
    timp05_1.gdps3 = timp02_1.gd1 * timp02_1.ps2 - timp02_1.gd2 * 
	    timp02_1.ps1;

/* Computing 2nd power */
    r__1 = timp05_1.gdps1;
/* Computing 2nd power */
    r__2 = timp05_1.gdps2;
/* Computing 2nd power */
    r__3 = timp05_1.gdps3;
    rgdps = sqrt(r__1 * r__1 + r__2 * r__2 + r__3 * r__3);

/* *** cross product ExS in GEO system */

    timp06_1.peps1 = timp02_1.pe2 * timp02_1.ps3 - timp02_1.pe3 * 
	    timp02_1.ps2;
    timp06_1.peps2 = timp02_1.pe3 * timp02_1.ps1 - timp02_1.pe1 * 
	    timp02_1.ps3;
    timp06_1.peps3 = timp02_1.pe1 * timp02_1.ps2 - timp02_1.pe2 * 
	    timp02_1.ps1;

/* *** cross product RxS in GEO system */

    timp06_1.prps1 = timp02_1.pr2 * timp02_1.ps3 - timp02_1.pr3 * 
	    timp02_1.ps2;
    timp06_1.prps2 = timp02_1.pr3 * timp02_1.ps1 - timp02_1.pr1 * 
	    timp02_1.ps3;
    timp06_1.prps3 = timp02_1.pr1 * timp02_1.ps2 - timp02_1.pr2 * 
	    timp02_1.ps1;

/* Computing 2nd power */
    r__1 = timp06_1.prps1;
/* Computing 2nd power */
    r__2 = timp06_1.prps2;
/* Computing 2nd power */
    r__3 = timp06_1.prps3;
    rprps = sqrt(r__1 * r__1 + r__2 * r__2 + r__3 * r__3);

/* *** computation of gei to mag vectors */

    if (qm12 < 1e-30f) {
	s_stop("*** Rocotlib error qm12", (ftnlen)23);
    }
    timp07_1.xeima1 = timp01_1.gm1 * timp01_1.gm3 / qm12;
    timp07_1.xeima2 = timp01_1.gm2 * timp01_1.gm3 / qm12;
    timp07_1.xeima3 = -qm12;

    timp07_1.yeima1 = -timp01_1.gm2 / qm12;
    timp07_1.yeima2 = timp01_1.gm1 / qm12;
    timp07_1.yeima3 = 0.f;

/* *** computation of gei to sm vectors */

    if (rgmgs < 1e-30f) {
	s_stop("*** Rocotlib error rgmgs", (ftnlen)24);
    }
    timp08_1.yeism1 = timp03_1.gmgs1 / rgmgs;
    timp08_1.yeism2 = timp03_1.gmgs2 / rgmgs;
    timp08_1.yeism3 = timp03_1.gmgs3 / rgmgs;

    timp08_1.xeism1 = timp08_1.yeism2 * timp01_1.gm3 - timp08_1.yeism3 * 
	    timp01_1.gm2;
    timp08_1.xeism2 = timp08_1.yeism3 * timp01_1.gm1 - timp08_1.yeism1 * 
	    timp01_1.gm3;
    timp08_1.xeism3 = timp08_1.yeism1 * timp01_1.gm2 - timp08_1.yeism2 * 
	    timp01_1.gm1;

/* *** computation of gei to gsm vectors */

    timp09_1.yeigm1 = timp03_1.gmgs1 / rgmgs;
    timp09_1.yeigm2 = timp03_1.gmgs2 / rgmgs;
    timp09_1.yeigm3 = timp03_1.gmgs3 / rgmgs;

    timp09_1.zeigm1 = timp01_1.gs2 * timp09_1.yeigm3 - timp01_1.gs3 * 
	    timp09_1.yeigm2;
    timp09_1.zeigm2 = timp01_1.gs3 * timp09_1.yeigm1 - timp01_1.gs1 * 
	    timp09_1.yeigm3;
    timp09_1.zeigm3 = timp01_1.gs1 * timp09_1.yeigm2 - timp01_1.gs2 * 
	    timp09_1.yeigm1;

/* *** computation of gei to gseq vectors */

    if (rgrgs < 1e-30f) {
	s_stop("*** Rocotlib error rgrgs", (ftnlen)24);
    }
    timp10_1.yeigq1 = timp04_1.grgs1 / rgrgs;
    timp10_1.yeigq2 = timp04_1.grgs2 / rgrgs;
    timp10_1.yeigq3 = timp04_1.grgs3 / rgrgs;

    timp10_1.zeigq1 = timp01_1.gs2 * timp10_1.yeigq3 - timp01_1.gs3 * 
	    timp10_1.yeigq2;
    timp10_1.zeigq2 = timp01_1.gs3 * timp10_1.yeigq1 - timp01_1.gs1 * 
	    timp10_1.yeigq3;
    timp10_1.zeigq3 = timp01_1.gs1 * timp10_1.yeigq2 - timp01_1.gs2 * 
	    timp10_1.yeigq1;

/* *** computation of tetq angle */

    timp11_1.stetq = (timp04_1.grge1 * timp01_1.gs1 + timp04_1.grge2 * 
	    timp01_1.gs2 + timp04_1.grge3 * timp01_1.gs3) / rgrgs;
/* Computing 2nd power */
    r__1 = timp11_1.stetq;
    timp11_1.ctetq = sqrt(1.f - r__1 * r__1);

/* *** computation of mu angle */

    timp11_1.smu = timp02_1.ps1 * timp02_1.gd1 + timp02_1.ps2 * timp02_1.gd2 
	    + timp02_1.ps3 * timp02_1.gd3;
    timp11_1.cmu = sqrt(1.f - timp11_1.smu * timp11_1.smu);

/* *** computation of dzeta angle */

    timp11_1.cdze = (timp01_1.ge1 * timp01_1.gm1 + timp01_1.ge2 * 
	    timp01_1.gm2 + timp01_1.ge3 * timp01_1.gm3) / rgmgs;
    timp11_1.sdze = (timp01_1.ge1 * timp03_1.gmgs1 + timp01_1.ge2 * 
	    timp03_1.gmgs2 + timp01_1.ge3 * timp03_1.gmgs3) / rgmgs;
/*     accuracy low on this angle */
    epsi = 1e-4f;
/* Computing 2nd power */
    r__2 = timp11_1.sdze;
/* Computing 2nd power */
    r__3 = timp11_1.cdze;
    if ((r__1 = r__2 * r__2 + r__3 * r__3 - 1.f, dabs(r__1)) > epsi) {
	s_stop("*** Rocotlib error 3", (ftnlen)20);
    }

/* *** computation of phi angle */

    q = qd12 * rgdps;
    if (q < 1e-30f) {
	s_stop("*** Rocotlib error q", (ftnlen)20);
    }

/* Computing 2nd power */
    r__1 = timp02_1.gd1;
/* Computing 2nd power */
    r__2 = timp02_1.gd2;
    timp11_1.cphi = (timp02_1.gd1 * timp02_1.gd3 * timp02_1.ps1 + 
	    timp02_1.gd2 * timp02_1.gd3 * timp02_1.ps2 - (r__1 * r__1 + r__2 *
	     r__2) * timp02_1.ps3) / q;
    timp11_1.sphi = (timp02_1.gd2 * timp02_1.ps1 - timp02_1.gd1 * 
	    timp02_1.ps2) / q;
/* Computing 2nd power */
    r__2 = timp11_1.sphi;
/* Computing 2nd power */
    r__3 = timp11_1.cphi;
    if ((r__1 = r__2 * r__2 + r__3 * r__3 - 1.f, dabs(r__1)) > epsi) {
	s_stop("*** Rocotlib error 4", (ftnlen)20);
    }

/* *** computation of geo to mag vectors */

    if (qd12 < 1e-30f) {
	s_stop("*** Rocotlib error qd12", (ftnlen)23);
    }
    timp12_1.yeoma1 = -timp02_1.gd2 / qd12;
    timp12_1.yeoma2 = timp02_1.gd1 / qd12;
    timp12_1.yeoma3 = 0.f;

    timp12_1.xeoma1 = timp12_1.yeoma2 * timp02_1.gd3;
    timp12_1.xeoma2 = -timp12_1.yeoma1 * timp02_1.gd3;
    timp12_1.xeoma3 = timp12_1.yeoma1 * timp02_1.gd2 - timp12_1.yeoma2 * 
	    timp02_1.gd1;

/* *** computation of geo to sm vectors */

    if (rgdps < 1e-30f) {
	s_stop("*** Rocotlib error rgdps", (ftnlen)24);
    }
    timp13_1.yeosm1 = timp05_1.gdps1 / rgdps;
    timp13_1.yeosm2 = timp05_1.gdps2 / rgdps;
    timp13_1.yeosm3 = timp05_1.gdps3 / rgdps;

    timp13_1.xeosm1 = timp13_1.yeosm2 * timp02_1.gd3 - timp13_1.yeosm3 * 
	    timp02_1.gd2;
    timp13_1.xeosm2 = timp13_1.yeosm3 * timp02_1.gd1 - timp13_1.yeosm1 * 
	    timp02_1.gd3;
    timp13_1.xeosm3 = timp13_1.yeosm1 * timp02_1.gd2 - timp13_1.yeosm2 * 
	    timp02_1.gd1;

/* *** computation of geo to gsm vectors */

    timp14_1.yeogm1 = timp13_1.yeosm1;
    timp14_1.yeogm2 = timp13_1.yeosm2;
    timp14_1.yeogm3 = timp13_1.yeosm3;

    timp14_1.zeogm1 = timp02_1.ps2 * timp14_1.yeogm3 - timp02_1.ps3 * 
	    timp14_1.yeogm2;
    timp14_1.zeogm2 = timp02_1.ps3 * timp14_1.yeogm1 - timp02_1.ps1 * 
	    timp14_1.yeogm3;
    timp14_1.zeogm3 = timp02_1.ps1 * timp14_1.yeogm2 - timp02_1.ps2 * 
	    timp14_1.yeogm1;

/* *** computation of geo to gsq vectors */

    if (rprps < 1e-30f) {
	s_stop("*** Rocotlib error rprps", (ftnlen)24);
    }
    timp15_1.yeogq1 = timp06_1.prps1 / rprps;
    timp15_1.yeogq2 = timp06_1.prps2 / rprps;
    timp15_1.yeogq3 = timp06_1.prps3 / rprps;

    timp15_1.zeogq1 = timp02_1.ps2 * timp15_1.yeogq3 - timp02_1.ps3 * 
	    timp15_1.yeogq2;
    timp15_1.zeogq2 = timp02_1.ps3 * timp15_1.yeogq1 - timp02_1.ps1 * 
	    timp15_1.yeogq3;
    timp15_1.zeogq3 = timp02_1.ps1 * timp15_1.yeogq2 - timp02_1.ps2 * 
	    timp15_1.yeogq1;

    return 0;
} /* cp_time_param__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cp_time_param2__(integer *jd1950, real *houday)
{
    /* Initialized data */

    static integer iyear = -1;
    static integer imonth = -1;
    static integer iday = -1;
    static integer ih = -1;
    static integer im = -1;
    static integer is = -1;

    extern /* Subroutine */ int cv_jul1950_to_date__(integer *, integer *, 
	    integer *, integer *), cp_time_param__(integer *, integer *, 
	    integer *, integer *, integer *, integer *), cv_dech_to_hms__(
	    real *, integer *, integer *, integer *);


/* ---------------------------------------------------------------------- */
/* *   Class  : basic compute modules of Rocotlib Software */
/* *   Object : compute_time_parameters and time-dependent matrix */
/* *   Author : P. Robert, CRPE, 2001 */

/* *   Comment: Prepare all time varying quantities for computations of */
/*              coordinate transforms of the library. */
/*              Same as cp_time_param, only input arguments are changed. */

/* *   Input  : jd1950: Julian day 1950 (0= 1/1/1950) */
/*              houday: decimal hour of the day (U.T.) */
/* *   Output : in common statements */
/* ---------------------------------------------------------------------- */


    cv_jul1950_to_date__(jd1950, &iyear, &imonth, &iday);
    cv_dech_to_hms__(houday, &ih, &im, &is);

    cp_time_param__(&iyear, &imonth, &iday, &ih, &im, &is);

    return 0;
} /* cp_time_param2__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cp_time_param3__(integer *jd2000, real *houday)
{
    /* Initialized data */

    static integer iyear = -1;
    static integer imonth = -1;
    static integer iday = -1;
    static integer ih = -1;
    static integer im = -1;
    static integer is = -1;

    extern /* Subroutine */ int cv_jul1950_to_date__(integer *, integer *, 
	    integer *, integer *), cp_time_param__(integer *, integer *, 
	    integer *, integer *, integer *, integer *), cv_dech_to_hms__(
	    real *, integer *, integer *, integer *);


/* ---------------------------------------------------------------------- */
/* *   Class  : basic compute modules of Rocotlib Software */
/* *   Object : compute_time_parameters and time-dependent matrix */
/* *   Author : P. Robert, CRPE, 2001 */

/* *   Comment: Prepare all time varying quantities for computations of */
/*              coordinate transforms of the library. */
/*              Same as cp_time_param, only input arguments are changed. */

/* *   Input  : jd2000: Julian day 2000 (0= 1/1/2000) */
/*              houday: decimal hour of the day (U.T.) */
/* *   Output : in common statements */
/* ---------------------------------------------------------------------- */


    cv_jul1950_to_date__(jd2000, &iyear, &imonth, &iday);
    cv_dech_to_hms__(houday, &ih, &im, &is);

    cp_time_param__(&iyear, &imonth, &iday, &ih, &im, &is);

    return 0;
} /* cp_time_param3__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cp_tpn_param__(real *xo, real *yo, real *zo, real *xs, 
	real *tx, real *ty, real *tz, real *px, real *py, real *pz, real *nx, 
	real *ny, real *nz)
{
    /* System generated locals */
    real r__1, r__2, r__3;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    static real r__, dx, rnon, rnop, rnot;



/*     ---------------------------------------------------------------+-- */
/* *   Class  : basic compute modules of Rocotlib Software */
/* *   Object : compute_TPN_system */
/* *   Author : P. Robert, CETP, 2004 */
/* *   Comment: Compute TPN vector in GSE system or any system having X */
/*              axis towards the SUN. */

/*         N: Output normal to the paraboloid */
/*         T: tengente to the paraboloid, towards the summit */
/*         P: tengente to the paraboloid, P=N X T */

/*     The paraboloid is defined by its summit Xs and the local point */
/*     Xo, Yo, Zo */

/*     Note: the paraboloid is close to the magnetopause if the summit */
/*           is defined as the subsolar point (by T87,T89 model or other) */
/*           and if the local point Xo,Yo,Zo correspond to magnetopause */
/*           crossing. */

/* *   Input : xo,yo,zo,xs */
/* *   Output: Nx,Ny,Nz,Tx,Ty,Tz,Px,Py,Pz */
/*     ---------------------------------------------------------------+-- */


/* Computing 2nd power */
    r__1 = *yo;
/* Computing 2nd power */
    r__2 = *zo;
    r__ = sqrt(r__1 * r__1 + r__2 * r__2);
    dx = *xs - *xo;

    *nx = r__;
    *ny = dx * 2.f * *yo / r__;
    *nz = dx * 2.f * *zo / r__;

    *tx = dx * 2.f;
    *ty = -(*yo);
    *tz = -(*zo);

    *px = *ny * *tz - *nz * *ty;
    *py = *nz * *tx - *nx * *tz;
    *pz = *nx * *ty - *ny * *tx;

/*     normalisation */

/* Computing 2nd power */
    r__1 = *nx;
/* Computing 2nd power */
    r__2 = *ny;
/* Computing 2nd power */
    r__3 = *nz;
    rnon = sqrt(r__1 * r__1 + r__2 * r__2 + r__3 * r__3);
/* Computing 2nd power */
    r__1 = *tx;
/* Computing 2nd power */
    r__2 = *ty;
/* Computing 2nd power */
    r__3 = *tz;
    rnot = sqrt(r__1 * r__1 + r__2 * r__2 + r__3 * r__3);
/* Computing 2nd power */
    r__1 = *px;
/* Computing 2nd power */
    r__2 = *py;
/* Computing 2nd power */
    r__3 = *pz;
    rnop = sqrt(r__1 * r__1 + r__2 * r__2 + r__3 * r__3);

    *nx /= rnon;
    *ny /= rnon;
    *nz /= rnon;

    *tx /= rnot;
    *ty /= rnot;
    *tz /= rnot;

    *px /= rnop;
    *py /= rnop;
    *pz /= rnop;

    return 0;
} /* cp_tpn_param__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cp_nbday_in_month__(integer *iyear, integer *imonth, 
	integer *nbday)
{
    /* Initialized data */

    static integer nday[12] = { 31,28,31,30,31,30,31,31,30,31,30,31 };
    static integer ily = -1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    /* Subroutine */ int s_stop(char *, ftnlen);

    /* Local variables */
    extern /* Subroutine */ int cp_leap_year__(integer *, integer *);

    /* Fortran I/O blocks */
    static cilist io___138 = { 0, 6, 0, 0, 0 };
    static cilist io___139 = { 0, 6, 0, 0, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : compute_number_of_day_of_the_month */
/* *   Author : P. Robert, CRPE, 2001 */

/* *   Input  : iyear,imonth (1-12) */
/* *   Output : nbday */
/* ---------------------------------------------------------------------- */



    if (*imonth < 1 || *imonth > 12) {
	s_wsle(&io___138);
	do_lio(&c__9, &c__1, "*** Rocotlib/cp_nbday_in_month: month= ", (
		ftnlen)39);
	do_lio(&c__3, &c__1, (char *)&(*imonth), (ftnlen)sizeof(integer));
	e_wsle();
	s_wsle(&io___139);
	do_lio(&c__9, &c__1, "*** Rocotlib/cp_nbday_in_month: month must be "
		">0 and <13", (ftnlen)56);
	e_wsle();
	s_stop("*** Rocotlib/cp_nbday_in_month: month must be >0 and <13", (
		ftnlen)56);
    }

    cp_leap_year__(iyear, &ily);

    if (ily == 1) {
	nday[1] = 29;
    } else {
	nday[1] = 28;
    }

    *nbday = nday[*imonth - 1];

    return 0;
} /* cp_nbday_in_month__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cp_en_day_name__(integer *iday, char *cday, integer *
	nbcha, ftnlen cday_len)
{
    /* Initialized data */

    static char days[9*7] = "Monday   " "Tuesday  " "Wednesday" "Thurday  " 
	    "Friday   " "Saturday " "Sunday   ";
    static integer nbca[7] = { 6,7,9,7,6,8,6 };

    /* Builtin functions */
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);

    /* Local variables */
    static integer nday, iweek;


/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : compute_english_day_name, ex: 'Monday' for iday=1 */
/* *   Author : P. Robert, CRPE, 2001 */

/* *   Input  : iday (1-7, otherwise modulo is done) */
/* *   Output : cday,nchar */
/* ---------------------------------------------------------------------- */



    iweek = *iday / 7;
    nday = *iday - iweek * 7;
    if (nday < 1) {
	nday += 7;
    }

    s_copy(cday, days + (nday - 1) * 9, cday_len, (ftnlen)9);
    *nbcha = nbca[nday - 1];

    return 0;
} /* cp_en_day_name__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cp_en_month_name__(integer *imonth, char *cmonth, 
	integer *nchar, ftnlen cmonth_len)
{
    /* Initialized data */

    static char cara[9*12] = "January  " "February " "March    " "April    " 
	    "May      " "June     " "July     " "August   " "September" "Oct"
	    "ober  " "November " "December ";
    static integer nbca[12] = { 7,8,5,5,3,4,4,6,9,7,8,8 };

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    /* Subroutine */ int s_stop(char *, ftnlen), s_copy(char *, char *, 
	    ftnlen, ftnlen);

    /* Fortran I/O blocks */
    static cilist io___146 = { 0, 6, 0, 0, 0 };
    static cilist io___147 = { 0, 6, 0, 0, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : compute_english_month_name */
/* *   Author : P. Robert, CRPE, 2001 */

/* *   Input  : imonth (1-12) */
/* *   Output : cmonth,nchar */
/* ---------------------------------------------------------------------- */





    if (*imonth < 1 || *imonth > 12) {
	s_wsle(&io___146);
	do_lio(&c__9, &c__1, "*** Rocotlib/cp_en_month_name: month= ", (
		ftnlen)38);
	do_lio(&c__3, &c__1, (char *)&(*imonth), (ftnlen)sizeof(integer));
	e_wsle();
	s_wsle(&io___147);
	do_lio(&c__9, &c__1, "*** Rocotlib/cp_en_month_name: month must be >"
		"0 and <13", (ftnlen)55);
	e_wsle();
	s_stop("*** Rocotlib/cp_en_month_name: month must be >0 and <13", (
		ftnlen)55);
    }

    s_copy(cmonth, cara + (*imonth - 1) * 9, cmonth_len, (ftnlen)9);
    *nchar = nbca[*imonth - 1];

    return 0;
} /* cp_en_month_name__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cp_fr_day_name__(integer *iday, char *cday, integer *
	nbcha, ftnlen cday_len)
{
    /* Initialized data */

    static char days[8*7] = "Lundi   " "Mardi   " "Mercredi" "Jeudi   " "Ven"
	    "dredi" "Samedi  " "Dimanche";
    static integer nbca[7] = { 5,5,8,5,8,6,8 };

    /* Builtin functions */
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);

    /* Local variables */
    static integer nday, iweek;


/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : compute_french_day_name, ex: 'Lundi' for iday=1 */
/* *   Author : P. Robert, CRPE, 2001 */

/* *   Input  : iday (1-7, otherwise modulo is done) */
/* *   Output : cday,nchar */
/* ---------------------------------------------------------------------- */



    iweek = *iday / 7;
    nday = *iday - iweek * 7;
    if (nday < 1) {
	nday += 7;
    }

    s_copy(cday, days + ((nday - 1) << 3), cday_len, (ftnlen)8);
    *nbcha = nbca[nday - 1];

    return 0;
} /* cp_fr_day_name__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cp_fr_month_name__(integer *imonth, char *cmonth, 
	integer *nchar, ftnlen cmonth_len)
{
    /* Initialized data */

    static char cara[9*12] = "Janvier  " "F\351vrier  " "Mars     " "Avril  "
	    "  " "Mai      " "Juin     " "Juillet  " "Ao\373t     " "Septembre"
	     "Octobre  " "Novembre " "D\351cembre ";
    static integer nbca[12] = { 7,7,4,5,3,4,7,4,9,7,8,8 };

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    /* Subroutine */ int s_stop(char *, ftnlen), s_copy(char *, char *, 
	    ftnlen, ftnlen);

    /* Fortran I/O blocks */
    static cilist io___154 = { 0, 6, 0, 0, 0 };
    static cilist io___155 = { 0, 6, 0, 0, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : compute_french_month_name */
/* *   Author : P. Robert, CRPE, 2001 */

/* *   Input  : imonth (1-12) */
/* *   Output : cmonth,nchar */
/* ---------------------------------------------------------------------- */






    if (*imonth < 1 || *imonth > 12) {
	s_wsle(&io___154);
	do_lio(&c__9, &c__1, "*** Rocotlib/cp_fr_month_name: month= ", (
		ftnlen)38);
	do_lio(&c__3, &c__1, (char *)&(*imonth), (ftnlen)sizeof(integer));
	e_wsle();
	s_wsle(&io___155);
	do_lio(&c__9, &c__1, "*** Rocotlib/cp_fr_month_name: month must be >"
		"0 and <13", (ftnlen)55);
	e_wsle();
	s_stop("*** Rocotlib/cp_fr_month_name: month must be >0 and <13", (
		ftnlen)55);
    }

    s_copy(cmonth, cara + (*imonth - 1) * 9, cmonth_len, (ftnlen)9);
    *nchar = nbca[*imonth - 1];

    return 0;
} /* cp_fr_month_name__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cp_leap_year__(integer *iyear, integer *ileap)
{
    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    /* Subroutine */ int s_stop(char *, ftnlen);

    /* Local variables */
    static integer ir, is;

    /* Fortran I/O blocks */
    static cilist io___156 = { 0, 6, 0, 0, 0 };
    static cilist io___157 = { 0, 6, 0, 0, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : compute_leap_year with ileap=1 for leap year, 0 if not */
/* *   Author : P. Robert, CRPE, 1992 */

/* *   Input  : iyear (ex: 1980) */
/* *   Output : ileap (1 or 0 if iyear is or not a leap year) */
/* ---------------------------------------------------------------------- */

    if (*iyear < 1900) {
	s_wsle(&io___156);
	do_lio(&c__9, &c__1, "*** Rocotlib/cp_leap_year: iyear= ", (ftnlen)34)
		;
	do_lio(&c__3, &c__1, (char *)&(*iyear), (ftnlen)sizeof(integer));
	e_wsle();
	s_wsle(&io___157);
	do_lio(&c__9, &c__1, "*** Rocotlib/cp_leap_year: iyear must be > 1900"
		, (ftnlen)47);
	e_wsle();
	s_stop("*** Rocotlib/cp_leap_year: iyear must be > 1900", (ftnlen)47);
    }

    ir = *iyear - (*iyear / 4 << 2);
    if (ir == 0) {
	*ileap = 1;
    } else {
	*ileap = 0;
    }

    is = *iyear - *iyear / 100 * 100;
    if (is == 0) {
	ir = *iyear - *iyear / 400 * 400;
	if (ir == 0) {
	    *ileap = 1;
	} else {
	    *ileap = 0;
	}
    } else {
	return 0;
    }

    return 0;
} /* cp_leap_year__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cp_seasons__(integer *iyear, integer *id_sso__, integer *
	id_wso__, integer *id_seq__, integer *id_feq__, char *ct_sso__, char *
	ct_wso__, char *ct_seq__, char *ct_feq__, ftnlen ct_sso_len, ftnlen 
	ct_wso_len, ftnlen ct_seq_len, ftnlen ct_feq_len)
{
    /* System generated locals */
    integer i__1;
    icilist ici__1;

    /* Builtin functions */
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);
    double acos(doublereal);
    integer s_wsfi(icilist *), do_fio(integer *, char *, ftnlen), e_wsfi(void)
	    ;

    /* Local variables */
    extern /* Subroutine */ int g_gei_geo_sun_dir__(real *, real *, real *, 
	    real *, real *, real *), cp_nbday_in_month__(integer *, integer *,
	     integer *);
    static integer ih, im, is, iday;
    static real teta;
    static integer imon;
    static real zmin, zmax;
    static integer nbday;
    static real sxgei, sygei, szgei, sxgeo, sygeo, szgeo;
    extern /* Subroutine */ int cp_time_param__(integer *, integer *, integer 
	    *, integer *, integer *, integer *);
    static real tetmax;



/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : compute_seasons, i.e. solstice & equinox */
/* *   Author : P. Robert, SDev, 2017 */

/* *   Input  : iyear (ex: 1980) */
/* *   Output : id_sso,id_wso : June and december day of summer and */
/*                              winter solstice. */
/*              id_seq,id_feq : same for march and september spring */
/*                              and fall equinoxes. */
/*              ct_sso,ct_wso : June and december time of summer and */
/*                              winter solstice. */
/*              ct_seq,ct_feq : same for march and september spring */
/*                             and fall equinoxes; Cha*5 (hh:mm) */
/* * */
/* *   Comment: calcul des saisons: solstices & equinoxes, */
/* *            precision 1 heure environ */
/* ---------------------------------------------------------------------- */
    *id_sso__ = 0;
    *id_wso__ = 0;
    *id_seq__ = 0;
    *id_feq__ = 0;
    s_copy(ct_sso__, "?", (ftnlen)5, (ftnlen)1);
    s_copy(ct_wso__, "?", (ftnlen)5, (ftnlen)1);
    s_copy(ct_seq__, "?", (ftnlen)5, (ftnlen)1);
    s_copy(ct_feq__, "?", (ftnlen)5, (ftnlen)1);

/* *** calcul de l'equinoxe de printemps */

    imon = 3;
    tetmax = 0.f;
    cp_nbday_in_month__(iyear, &imon, &nbday);
    i__1 = nbday;
    for (iday = 1; iday <= i__1; ++iday) {
	for (ih = 0; ih <= 23; ++ih) {
	    for (im = 0; im <= 50; im += 10) {
		is = 0;
		cp_time_param__(iyear, &imon, &iday, &ih, &im, &is);
		g_gei_geo_sun_dir__(&sxgei, &sygei, &szgei, &sxgeo, &sygeo, &
			szgeo);
		teta = acos(szgeo) * 180.f / 3.14159f;
		if (teta > tetmax && szgeo > 0.f) {
		    tetmax = teta;
		    *id_seq__ = iday;
		    ici__1.icierr = 0;
		    ici__1.icirnum = 1;
		    ici__1.icirlen = 5;
		    ici__1.iciunit = ct_seq__;
		    ici__1.icifmt = "(i2.2,':',i2.2)";
		    s_wsfi(&ici__1);
		    do_fio(&c__1, (char *)&ih, (ftnlen)sizeof(integer));
		    do_fio(&c__1, (char *)&im, (ftnlen)sizeof(integer));
		    e_wsfi();
		}
	    }
	}
    }

/* *** calcul de l'equinoxe d'automne */

    imon = 9;
    tetmax = 0.f;
    cp_nbday_in_month__(iyear, &imon, &nbday);
    i__1 = nbday;
    for (iday = 1; iday <= i__1; ++iday) {
	for (ih = 0; ih <= 23; ++ih) {
	    for (im = 0; im <= 50; im += 10) {
		is = 0;
		cp_time_param__(iyear, &imon, &iday, &ih, &im, &is);
		g_gei_geo_sun_dir__(&sxgei, &sygei, &szgei, &sxgeo, &sygeo, &
			szgeo);
		teta = acos(szgeo) * 180.f / 3.14159f;
		if (teta > tetmax && szgeo > 0.f) {
		    tetmax = teta;
		    *id_feq__ = iday;
		    ici__1.icierr = 0;
		    ici__1.icirnum = 1;
		    ici__1.icirlen = 5;
		    ici__1.iciunit = ct_feq__;
		    ici__1.icifmt = "(i2.2,':',i2.2)";
		    s_wsfi(&ici__1);
		    do_fio(&c__1, (char *)&ih, (ftnlen)sizeof(integer));
		    do_fio(&c__1, (char *)&im, (ftnlen)sizeof(integer));
		    e_wsfi();
		}
	    }
	}
    }

/* *** calcul du solstice d'ete */

    imon = 6;
    zmax = 0.f;
    cp_nbday_in_month__(iyear, &imon, &nbday);
    i__1 = nbday;
    for (iday = 1; iday <= i__1; ++iday) {
	for (ih = 0; ih <= 23; ++ih) {
	    for (im = 0; im <= 50; im += 10) {
		is = 0;
		cp_time_param__(iyear, &imon, &iday, &ih, &im, &is);
		g_gei_geo_sun_dir__(&sxgei, &sygei, &szgei, &sxgeo, &sygeo, &
			szgeo);
		if (szgeo > zmax) {
		    zmax = szgeo;
		    *id_sso__ = iday;
		    ici__1.icierr = 0;
		    ici__1.icirnum = 1;
		    ici__1.icirlen = 5;
		    ici__1.iciunit = ct_sso__;
		    ici__1.icifmt = "(i2.2,':',i2.2)";
		    s_wsfi(&ici__1);
		    do_fio(&c__1, (char *)&ih, (ftnlen)sizeof(integer));
		    do_fio(&c__1, (char *)&im, (ftnlen)sizeof(integer));
		    e_wsfi();
		}
	    }
	}
    }

/* *** calcul du solstice d'hiver */

    imon = 12;
    zmin = 1.f;
    cp_nbday_in_month__(iyear, &imon, &nbday);
    i__1 = nbday;
    for (iday = 1; iday <= i__1; ++iday) {
	for (ih = 0; ih <= 23; ++ih) {
	    for (im = 0; im <= 50; im += 10) {
		is = 0;
		cp_time_param__(iyear, &imon, &iday, &ih, &im, &is);
		g_gei_geo_sun_dir__(&sxgei, &sygei, &szgei, &sxgeo, &sygeo, &
			szgeo);
		if (szgeo < zmin) {
		    zmin = szgeo;
		    *id_wso__ = iday;
		    ici__1.icierr = 0;
		    ici__1.icirnum = 1;
		    ici__1.icirlen = 5;
		    ici__1.iciunit = ct_wso__;
		    ici__1.icifmt = "(i2.2,':',i2.2)";
		    s_wsfi(&ici__1);
		    do_fio(&c__1, (char *)&ih, (ftnlen)sizeof(integer));
		    do_fio(&c__1, (char *)&im, (ftnlen)sizeof(integer));
		    e_wsfi();
		}
	    }
	}
    }

    return 0;
} /* cp_seasons__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cv_doty_to_date__(integer *idoy, integer *iyear, integer 
	*imonth, integer *iday)
{
    /* Initialized data */

    static integer month[12] = { 31,28,31,30,31,30,31,31,30,31,30,31 };
    static integer ily = -1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    /* Subroutine */ int s_stop(char *, ftnlen);

    /* Local variables */
    static integer m, im, mp;
    extern /* Subroutine */ int cp_leap_year__(integer *, integer *);

    /* Fortran I/O blocks */
    static cilist io___178 = { 0, 6, 0, 0, 0 };
    static cilist io___179 = { 0, 6, 0, 0, 0 };
    static cilist io___180 = { 0, 6, 0, 0, 0 };
    static cilist io___181 = { 0, 6, 0, 0, 0 };
    static cilist io___182 = { 0, 6, 0, 0, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : convert_day_of_year for a given year in date */
/* *   Author : P. Robert, CRPE, 1992 */

/* *   Input  : iyear,idoy (idoy=1 for january 1) */
/* *   Output : imonth,iday */
/* ---------------------------------------------------------------------- */



    cp_leap_year__(iyear, &ily);

    if (*idoy > 365 && ily == 0) {
	s_wsle(&io___178);
	do_lio(&c__9, &c__1, "*** Rocotlib/cv_doty_to_date: idoy= ", (ftnlen)
		36);
	do_lio(&c__3, &c__1, (char *)&(*idoy), (ftnlen)sizeof(integer));
	e_wsle();
	s_wsle(&io___179);
	do_lio(&c__9, &c__1, "*** Rocotlib/cv_doty_to_date: iyear not a leap"
		" year", (ftnlen)51);
	e_wsle();
	s_wsle(&io___180);
	do_lio(&c__9, &c__1, "                      no more than 365 day", (
		ftnlen)42);
	e_wsle();
	s_stop("*** Rocotlib/cv_doty_to_date: iyear not a leap year", (ftnlen)
		51);
    }

    if (*idoy < 1) {
	s_wsle(&io___181);
	do_lio(&c__9, &c__1, "*** Rocotlib/cv_doty_to_date: idoy= ", (ftnlen)
		36);
	do_lio(&c__3, &c__1, (char *)&(*idoy), (ftnlen)sizeof(integer));
	e_wsle();
	s_wsle(&io___182);
	do_lio(&c__9, &c__1, "*** Rocotlib/cv_doty_to_date: idoy must be > 0",
		 (ftnlen)46);
	e_wsle();
	s_stop("*** Rocotlib/cv_doty_to_date: idoy must be > 0", (ftnlen)46);
    }

    if (ily == 1) {
	month[1] = 29;
    } else {
	month[1] = 28;
    }

    m = 0;

    for (im = 1; im <= 12; ++im) {
	mp = m;
	m += month[im - 1];
	if (*idoy <= m) {
	    goto L20;
	}
/* L10: */
    }
L20:

    *imonth = im;
    *iday = *idoy - mp;

    return 0;
} /* cv_doty_to_date__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cv_jul2000_to_date__(integer *jd00, integer *iyear, 
	integer *imonth, integer *iday)
{
    extern /* Subroutine */ int cv_jul1950_to_date__(integer *, integer *, 
	    integer *, integer *);
    static integer jd50;


/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : convert_julian_day_2000 in date */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: compute date as year, month, day from julian day 2000 */

/* *   Input  : jd00 julian day 2000 (0= 1/1/2000) */
/* *   Output : iyear,imonth,iday */
/* ---------------------------------------------------------------------- */


    jd50 = *jd00 + 18262;

    cv_jul1950_to_date__(&jd50, iyear, imonth, iday);

    return 0;
} /* cv_jul2000_to_date__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cv_jul1950_to_date__(integer *jd50, integer *iyear, 
	integer *imonth, integer *iday)
{
    /* Initialized data */

    static integer ily = -1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    /* Subroutine */ int s_stop(char *, ftnlen);

    /* Local variables */
    static integer jd, iy, jd1, jdp;
    extern /* Subroutine */ int cp_leap_year__(integer *, integer *), 
	    cv_doty_to_date__(integer *, integer *, integer *, integer *);

    /* Fortran I/O blocks */
    static cilist io___191 = { 0, 6, 0, 0, 0 };
    static cilist io___192 = { 0, 6, 0, 0, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : convert_julian_day_1950 in date */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: compute date as year, month, day from julian day 1950 */

/* *   Input  : jd50  julian day 1950 (0= 1/1/1950) */
/* *   Output : iyear,imonth,iday */
/* ---------------------------------------------------------------------- */



    jd1 = -1;

    for (iy = 1950; iy <= 3000; ++iy) {
	cp_leap_year__(&iy, &ily);
	jdp = jd1;
	if (ily == 1) {
	    jd1 += 366;
	} else {
	    jd1 += 365;
	}
	if (jd1 >= *jd50) {
	    *iyear = iy;
	    goto L20;
	}

/* L10: */
    }
    s_wsle(&io___191);
    do_lio(&c__9, &c__1, "*** Rocotlib/cv_jul1950_to_date: jd50= ", (ftnlen)
	    39);
    do_lio(&c__3, &c__1, (char *)&(*jd50), (ftnlen)sizeof(integer));
    e_wsle();
    s_wsle(&io___192);
    do_lio(&c__9, &c__1, "*** Rocotlib/cv_jul1950_to_date: jd50 leads year >"
	    " 3000", (ftnlen)55);
    e_wsle();
    s_stop("*** Rocotlib/cv_jul1950_to_date: jd50 leads year > 3000", (ftnlen)
	    55);

L20:
    jd = *jd50 - jdp;
    cv_doty_to_date__(&jd, &iy, imonth, iday);

    return 0;
} /* cv_jul1950_to_date__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cv_weekn_to_date__(integer *iweek, integer *iyear, 
	integer *imonth, integer *iday)
{
    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    /* Subroutine */ int s_stop(char *, ftnlen);

    /* Local variables */
    extern /* Subroutine */ int cv_date_to_weekn__(integer *, integer *, 
	    integer *, integer *);
    static integer ipl, idow, idoy, iweek1;
    extern /* Subroutine */ int cv_date_to_dotw__(integer *, integer *, 
	    integer *, integer *), cv_doty_to_date__(integer *, integer *, 
	    integer *, integer *);

    /* Fortran I/O blocks */
    static cilist io___196 = { 0, 6, 0, 0, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : convert_first_day_of_week_number in date */
/* *   Author : P. Robert, CRPE, 2001 */

/* *   Input  : iweek,iyear */
/* *   Output : imonth,iday */
/* ---------------------------------------------------------------------- */


/*  calcul de la date correspondant au premier jour de la semaine */

/* *** premier lundi de l'annee */

    for (ipl = 1; ipl <= 7; ++ipl) {
	cv_date_to_dotw__(iyear, &c__1, &ipl, &idow);
	if (idow == 1) {
	    goto L20;
	}
/* L10: */
    }
    s_wsle(&io___196);
    do_lio(&c__9, &c__1, "*** Rocotlib/cv_weekn_to_date: error in idow compu"
	    "tation", (ftnlen)56);
    e_wsle();
    s_stop("*** Rocotlib/cv_weekn_to_date: error in idow computation", (
	    ftnlen)56);
L20:

/* *** semaine correspondant au premier lundi */

    cv_date_to_weekn__(iyear, &c__1, &ipl, &iweek1);

/* *** jour de l'annee correspondant au lundi de la semaine */

    idoy = ipl + (*iweek - iweek1) * 7;
    if (idoy < 1) {
	--(*iyear);
	*imonth = 12;
	*iday = idoy + 31;
	return 0;
    }

/* *** date correspondante */

    cv_doty_to_date__(&idoy, iyear, imonth, iday);

    return 0;
} /* cv_weekn_to_date__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cv_date_to_dotw__(integer *iyear, integer *imonth, 
	integer *iday, integer *idow)
{
    /* Initialized data */

    static integer jdref = -100000;
    static integer julday = -100000;

    extern /* Subroutine */ int cv_date_to_jul2000__(integer *, integer *, 
	    integer *, integer *);
    static integer idiff, iweek;


/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : convert_date in day_of_the_week */
/* *   Author : P. Robert, CRPE, 2001 */

/* *   Input  : iyear,imonth,iday */
/* *   Output : idow (1-7) */
/* ---------------------------------------------------------------------- */



/* *** jour julien du lundi de reference (le 1/1/2001 etait un lundi) */

    cv_date_to_jul2000__(&c__2001, &c__1, &c__1, &jdref);

/* *** jour julien de la date demandee */

    cv_date_to_jul2000__(iyear, imonth, iday, &julday);

/* *** calcul du jour de la semaine */

    idiff = julday - jdref;

    iweek = idiff / 7;
    *idow = idiff - iweek * 7 + 1;
    if (*idow < 1) {
	*idow += 7;
    }

    return 0;
} /* cv_date_to_dotw__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cv_date_to_doty__(integer *iyear, integer *imonth, 
	integer *iday, integer *idoy)
{
    /* Initialized data */

    static integer month[12] = { 31,28,31,30,31,30,31,31,30,31,30,31 };
    static integer ily = -1;

    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    /* Subroutine */ int s_stop(char *, ftnlen);

    /* Local variables */
    static integer i__;
    extern /* Subroutine */ int cp_leap_year__(integer *, integer *);

    /* Fortran I/O blocks */
    static cilist io___205 = { 0, 6, 0, 0, 0 };
    static cilist io___206 = { 0, 6, 0, 0, 0 };
    static cilist io___207 = { 0, 6, 0, 0, 0 };
    static cilist io___208 = { 0, 6, 0, 0, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : convert_date in day_of_year with idoy=1 for january 1 */
/* *   Author : P. Robert, CRPE, 1992 */

/* *   Input  : iyear,imonth,iday   ex: 1990,10,17 */
/* *   Output : idoy                ex: 290 */
/* ---------------------------------------------------------------------- */



    cp_leap_year__(iyear, &ily);

    if (ily == 1) {
	month[1] = 29;
    } else {
	month[1] = 28;
    }

    if (*imonth < 1 || *imonth > 12) {
	s_wsle(&io___205);
	do_lio(&c__9, &c__1, "*** Rocotlib/cv_date_to_doty: imonth = ", (
		ftnlen)39);
	do_lio(&c__3, &c__1, (char *)&(*imonth), (ftnlen)sizeof(integer));
	e_wsle();
	s_wsle(&io___206);
	do_lio(&c__9, &c__1, "*** Rocotlib/cv_date_to_doty: imonth must be >"
		"0 and <13", (ftnlen)55);
	e_wsle();
	s_stop("*** Rocotlib/cv_date_to_doty: imonth must be >0 and <13", (
		ftnlen)55);
    }

    if (*iday > month[*imonth - 1]) {
	s_wsle(&io___207);
	do_lio(&c__9, &c__1, "*** Rocotlib/cv_date_to_doty: iday= ", (ftnlen)
		36);
	do_lio(&c__3, &c__1, (char *)&(*iday), (ftnlen)sizeof(integer));
	e_wsle();
	s_wsle(&io___208);
	do_lio(&c__9, &c__1, "*** Rocotlib/cv_date_to_doty: this month has o"
		"nly", (ftnlen)49);
	do_lio(&c__3, &c__1, (char *)&month[*imonth - 1], (ftnlen)sizeof(
		integer));
	do_lio(&c__9, &c__1, "days", (ftnlen)4);
	e_wsle();
	s_stop("*** Rocotlib: error iday in cv_date_to_doty", (ftnlen)43);
    }

    *idoy = *iday;
    i__1 = *imonth - 1;
    for (i__ = 1; i__ <= i__1; ++i__) {
	*idoy += month[i__ - 1];
/* L10: */
    }

    return 0;
} /* cv_date_to_doty__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cv_hms_to_dech__(integer *ih, integer *im, integer *is, 
	real *houday)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : convert_hours_minutes_seconds in decimal hour of the day */
/* *   Author : P. Robert, CRPE, 1992 */

/* *   Input  : ih,im,is */
/* *   Output : houday  decimal hour of the day */
/* ---------------------------------------------------------------------- */

    *houday = (real) (*ih) + (real) (*im) / 60.f + (real) (*is) / 3600.f;

    return 0;
} /* cv_hms_to_dech__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cv_date_to_jul1950__(integer *iyear, integer *imonth, 
	integer *iday, integer *jd50)
{
    /* Initialized data */

    static integer ily = -1;
    static integer idoy = -1;

    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    /* Subroutine */ int s_stop(char *, ftnlen);

    /* Local variables */
    static integer i__;
    extern /* Subroutine */ int cp_leap_year__(integer *, integer *), 
	    cv_date_to_doty__(integer *, integer *, integer *, integer *);

    /* Fortran I/O blocks */
    static cilist io___212 = { 0, 6, 0, 0, 0 };
    static cilist io___213 = { 0, 6, 0, 0, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : convert_date in julian_day_1950 with jd50=0 for jan 1 */
/* *   Author : P. Robert, CRPE, 1992 */

/* *   Input  : iyear,imonth,iday   ex: 1990,10,17 */
/* *   Output : jd50 */
/* ---------------------------------------------------------------------- */



    if (*iyear < 1950) {
	s_wsle(&io___212);
	do_lio(&c__9, &c__1, "*** Rocotlib/cv_date_to_jul1950: iyear= ", (
		ftnlen)40);
	do_lio(&c__3, &c__1, (char *)&(*iyear), (ftnlen)sizeof(integer));
	e_wsle();
	s_wsle(&io___213);
	do_lio(&c__9, &c__1, "*** Rocotlib/cv_date_to_jul1950: iyear must be"
		" > 1950", (ftnlen)53);
	e_wsle();
	s_stop("*** Rocotlib/cv_date_to_jul1950: iyear must be > 1950", (
		ftnlen)53);
    }

    cv_date_to_doty__(iyear, imonth, iday, &idoy);

    *jd50 = idoy - 1;
    i__1 = *iyear - 1;
    for (i__ = 1950; i__ <= i__1; ++i__) {
	cp_leap_year__(&i__, &ily);
	if (ily == 1) {
	    *jd50 += 366;
	} else {
	    *jd50 += 365;
	}
/* L10: */
    }

    return 0;
} /* cv_date_to_jul1950__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cv_date_to_jul2000__(integer *iyear, integer *imonth, 
	integer *iday, integer *jd00)
{
    /* Initialized data */

    static integer jd50 = -1;

    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);
    /* Subroutine */ int s_stop(char *, ftnlen);

    /* Local variables */
    extern /* Subroutine */ int cv_date_to_jul1950__(integer *, integer *, 
	    integer *, integer *);

    /* Fortran I/O blocks */
    static cilist io___216 = { 0, 6, 0, 0, 0 };
    static cilist io___217 = { 0, 6, 0, 0, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : convert_date in julian_day_2000 with jd00=0 for january 1 */
/* *   Author : P. Robert, CRPE, 1992 */

/* *   Input  : iyear,imonth,iday   ex: 2001,10,17 */
/* *   Output : jd00 (may be negative) */
/* ---------------------------------------------------------------------- */



    if (*iyear < 1950) {
	s_wsle(&io___216);
	do_lio(&c__9, &c__1, "*** Rocotlib/cv_date_to_jul2000: iyear= ", (
		ftnlen)40);
	do_lio(&c__3, &c__1, (char *)&(*iyear), (ftnlen)sizeof(integer));
	e_wsle();
	s_wsle(&io___217);
	do_lio(&c__9, &c__1, "*** Rocotlib/cv_date_to_jul2000: iyear must be"
		" > 1950", (ftnlen)53);
	e_wsle();
	s_stop("*** Rocotlib/cv_date_to_jul2000: iyear must be > 1950", (
		ftnlen)53);
    }

    cv_date_to_jul1950__(iyear, imonth, iday, &jd50);

    *jd00 = jd50 - 18262;

    return 0;
} /* cv_date_to_jul2000__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cv_dhms_to_msotd__(integer *ih, integer *im, integer *is,
	 integer *ims, integer *milday)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : convert_hours_minutes_seconds_ms in millisec_of_day */
/* *   Author : P. Robert, CRPE, 2001 */

/* *   Input  : ih,im,is,ims */
/* *   Output : milday  millisecond of the day */
/* ---------------------------------------------------------------------- */

    *milday = *ih * 3600000 + *im * 60000 + *is * 1000 + *ims;

    return 0;
} /* cv_dhms_to_msotd__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cv_dech_to_hms__(real *houday, integer *ih, integer *im, 
	integer *is)
{
    static integer nj;
    static real rdech;


/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : convert_decimal hour of the day in time */
/* *   Author : P. Robert, CRPE, 1992 */

/* *   Input  : houday decimal hour of the day */
/* *   Output : ih,im,is */
/* ---------------------------------------------------------------------- */


    nj = (integer) (dabs(*houday) / 24.f);
    rdech = dabs(*houday) - (real) (nj * 24);

    *ih = (integer) rdech;
    *im = (integer) ((rdech - (real) (*ih)) * 60.f);
    *is = (integer) ((rdech - (real) (*ih) - (real) (*im) / 60.f) * 3600.f + 
	    .001f);

    if (*is == 60) {
	*is = 0;
	++(*im);
    }

    return 0;
} /* cv_dech_to_hms__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cv_msotd_to_hmsms__(integer *milday, integer *ih, 
	integer *im, integer *is, integer *ims)
{
    /* Builtin functions */
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    static integer nj, mil2;

    /* Fortran I/O blocks */
    static cilist io___222 = { 0, 6, 0, 0, 0 };
    static cilist io___223 = { 0, 6, 0, 0, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : convert_millisec. of the day in time */
/* *   Author : P. Robert, CRPE, 2001 */

/* *   Input  : milday millisecond of the day */
/* *   Output : ih,im,is,ims */
/* ---------------------------------------------------------------------- */


    nj = *milday / 86400000;
    mil2 = *milday - nj * 86400000;

    if (nj != 0) {
	s_wsle(&io___222);
	do_lio(&c__9, &c__1, "*** Rocotlib/cv_msotd_to_hmsms: milday=", (
		ftnlen)39);
	do_lio(&c__3, &c__1, (char *)&(*milday), (ftnlen)sizeof(integer));
	do_lio(&c__9, &c__1, "is > 86400000", (ftnlen)13);
	e_wsle();
	s_wsle(&io___223);
	do_lio(&c__9, &c__1, "                      assumed:", (ftnlen)30);
	do_lio(&c__3, &c__1, (char *)&mil2, (ftnlen)sizeof(integer));
	e_wsle();
    }

    *ih = *milday / 3600000;
    *im = (*milday - *ih * 3600000) / 60000;
    *is = (*milday - *ih * 3600000 - *im * 60000) / 1000;
    *ims = *milday - *ih * 3600000 - *im * 60000 - *is * 1000;

    return 0;
} /* cv_msotd_to_hmsms__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int cv_date_to_weekn__(integer *iyear, integer *imonth, 
	integer *iday, integer *iweek)
{
    static integer idow, idotl, idoty, idoty2;
    extern /* Subroutine */ int cv_date_to_dotw__(integer *, integer *, 
	    integer *, integer *), cv_date_to_doty__(integer *, integer *, 
	    integer *, integer *);


/* ---------------------------------------------------------------------- */
/* *   Class  : calendar modules of Rocotlib Software */
/* *   Object : convert_date in week_of_the_year */
/* *   Author : P. Robert, CRPE, 2001, revised SD April 2017 */

/* *   Input  : iyear,imonth,iday */
/* *   Output : iweek */
/* ---------------------------------------------------------------------- */

/*     la semaine 1 de toute anne est celle qui contient le 4 janvier */
/*     ou celle qui contient le 1er jeudi de janvier(norme ISO-8601). */
/* *** calcul du jour de la semaine du 1er janvier de l'annee */
    cv_date_to_dotw__(iyear, &c__1, &c__1, &idow);
/* *** calcul du lundi commencant la semaine 2 */
    if (idow == 1) {
	idoty2 = 8;
    }
    if (idow == 2) {
	idoty2 = 7;
    }
    if (idow == 3) {
	idoty2 = 6;
    }
    if (idow == 4) {
	idoty2 = 5;
    }
    if (idow == 5) {
	idoty2 = 11;
    }
    if (idow == 6) {
	idoty2 = 10;
    }
    if (idow == 7) {
	idoty2 = 9;
    }

/* *** jour de l'annee de la date demandee */

    cv_date_to_doty__(iyear, imonth, iday, &idoty);

/* *** jour de la semaine de la date demandee */

    cv_date_to_dotw__(iyear, imonth, iday, &idow);

/* *** jour de l'annee du lundi de la semaine de la date demandee */

    idotl = idoty - idow + 1;
/* *** numero de la semaine */
    *iweek = (idotl - idoty2) / 7 + 2;

    return 0;
} /* cv_date_to_weekn__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int g_gei_geo_dipole_dir__(real *dxgei, real *dygei, real *
	dzgei, real *dxgeo, real *dygeo, real *dzgeo)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : give modules of Rocotlib Software */
/* *   Object : give_dipole_direction in GEI and GEO system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: values are extracted from common */

/* *   Input  : none */
/* *   Output : dxgei,dygei,dzgei  cartesian dipole GEI coordinates */
/*              dxgeo,dygeo,dzgeo  cartesian dipole GEO coordinates */
/* ---------------------------------------------------------------------- */


    *dxgei = timp01_1.gm1;
    *dygei = timp01_1.gm2;
    *dzgei = timp01_1.gm3;

    *dxgeo = timp02_1.gd1;
    *dygeo = timp02_1.gd2;
    *dzgeo = timp02_1.gd3;

    return 0;
} /* g_gei_geo_dipole_dir__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int g_gsm_dipole_tilt_angle__(real *diptan)
{
    /* Builtin functions */
    double atan2(doublereal, doublereal);


/* ---------------------------------------------------------------------- */
/* *   Class  : give modules of Rocotlib Software */
/* *   Object : give_dipole_tilt_angle in radians */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: values are extracted from common */

/* *   Input  : none */
/* *   Output : diptan (radians) */
/* ---------------------------------------------------------------------- */


    *diptan = atan2(timp11_1.smu, timp11_1.cmu);

    return 0;
} /* g_gsm_dipole_tilt_angle__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int g_gei_geo_ecliptic_dir__(real *exgei, real *eygei, real *
	ezgei, real *exgeo, real *eygeo, real *ezgeo)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : give modules of Rocotlib Software */
/* *   Object : give_ecliptic_direction in GEI and GEO system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: values are extracted from common */

/* *   Input  : none */
/* *   Output : exgei,eygei,ezgei  cartesian ecliptic GEI coordinates */
/*              exgeo,eygeo,ezgeo  cartesian ecliptic GEO coordinates */
/* ---------------------------------------------------------------------- */


    *exgei = timp01_1.ge1;
    *eygei = timp01_1.ge2;
    *ezgei = timp01_1.ge3;

    *exgeo = timp02_1.pe1;
    *eygeo = timp02_1.pe2;
    *ezgeo = timp02_1.pe3;

    return 0;
} /* g_gei_geo_ecliptic_dir__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int g_gei_geo_sun_rot__(real *rxgei, real *rygei, real *
	rzgei, real *rxgeo, real *rygeo, real *rzgeo)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : give modules of Rocotlib Software */
/* *   Object : give_sun_rotation_direction in GEI and GEO system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: values are extracted from common */

/* *   Input  : none */
/* *   Output : rxgei,rygei,rzgei cartesian sun rotation GEI coordinates */
/*              rxgeo,rygeo,rzgeo cartesian sun rotation GEO coordinates */
/* ---------------------------------------------------------------------- */


    *rxgei = timp01_1.gr1;
    *rygei = timp01_1.gr2;
    *rzgei = timp01_1.gr3;

    *rxgeo = timp02_1.pr1;
    *rygeo = timp02_1.pr2;
    *rzgeo = timp02_1.pr3;

    return 0;
} /* g_gei_geo_sun_rot__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int g_gei_geo_sun_dir__(real *sxgei, real *sygei, real *
	szgei, real *sxgeo, real *sygeo, real *szgeo)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : give modules of Rocotlib Software */
/* *   Object : give_sun_direction in GEI and GEO system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: values are extracted from common */

/* *   Input  : none */
/* *   Output : sxgei,sygei,szgei  cartesian sun GEI coordinates */
/*              sxgeo,sygeo,szgeo  cartesian sun GEO coordinates */
/* ---------------------------------------------------------------------- */


    *sxgei = timp01_1.gs1;
    *sygei = timp01_1.gs2;
    *szgei = timp01_1.gs3;

    *sxgeo = timp02_1.ps1;
    *sygeo = timp02_1.ps2;
    *szgeo = timp02_1.ps3;

    return 0;
} /* g_gei_geo_sun_dir__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int g_gei_sun_param__(real *gmst, real *slon, real *sras, 
	real *sdec, real *obli)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : give modules of Rocotlib Software */
/* *   Object : give_sun_parameter dependant of time in GEI system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: values are extracted from common */

/* *   Input  : none */
/* *   Output : gmst   greenwich mean sideral time (radians) */
/*              slon   longitude along ecliptic (radians) */
/*              sras   right ascension (radians) */
/*              sdec   declination of the sun (radians) */
/* ---------------------------------------------------------------------- */


    *gmst = timp00_1.gst;
    *slon = timp00_1.slong;
    *sras = timp00_1.srasn;
    *sdec = timp00_1.sdecl;
    *obli = timp00_1.obliq;

    return 0;
} /* g_gei_sun_param__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int g_rocot_version_number__(real *vernum, char *verdat, 
	ftnlen verdat_len)
{
    /* Builtin functions */
    /* Subroutine */ int s_copy(char *, char *, ftnlen, ftnlen);



/* ---------------------------------------------------------------------- */
/* *   Class  : give modules of Rocotlib Software */
/* *   Object : give_version_number and modification date of the library */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: values are extracted from common */

/* *   Input  : none */
/* *   Output : vernum (ex 1.0) and verdat (ex: 'January 1995') */
/* ---------------------------------------------------------------------- */

/*     For previous versions informations, see print_rocot_info subrout. */

    *vernum = 3.2f;
    s_copy(verdat, "Fev 2020", (ftnlen)14, (ftnlen)8);

    return 0;
} /* g_rocot_version_number__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int print_rocot_info__(void)
{
    /* Format strings */
    static char fmt_100[] = "(3a)";
    static char fmt_200[] = "(a,f4.1,2a)";

    /* Builtin functions */
    integer s_wsfe(cilist *), do_fio(integer *, char *, ftnlen), e_wsfe(void);

    /* Local variables */
    static char verdat[14];
    static real vernum;
    extern /* Subroutine */ int g_rocot_version_number__(real *, char *, 
	    ftnlen);

    /* Fortran I/O blocks */
    static cilist io___230 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___231 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___232 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___233 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___234 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___235 = { 0, 6, 0, fmt_200, 0 };
    static cilist io___236 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___237 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___238 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___239 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___240 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___241 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___242 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___243 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___244 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___245 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___246 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___247 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___248 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___249 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___250 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___251 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___252 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___253 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___254 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___255 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___256 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___257 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___258 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___259 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___260 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___261 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___262 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___263 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___264 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___265 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___266 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___267 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___268 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___269 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___270 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___271 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___272 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___273 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___274 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___275 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___276 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___277 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___278 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___279 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___280 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___281 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___282 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___283 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___284 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___285 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___286 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___287 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___288 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___289 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___290 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___291 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___292 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___293 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___294 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___295 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___296 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___297 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___298 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___299 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___300 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___301 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___302 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___303 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___304 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___305 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___306 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___307 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___308 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___309 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___310 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___311 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___312 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___313 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___314 = { 0, 6, 0, fmt_100, 0 };




/* ---------------------------------------------------------------------- */
/* *   Class  : print modules of Rocotlib Software */
/* *   Object : print_library_informations */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: could be a main program */

/* *   Input  : none */
/* *   Output : none; print infos on output */
/* ---------------------------------------------------------------------- */

    g_rocot_version_number__(&vernum, verdat, (ftnlen)14);


    s_wsfe(&io___230);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___231);
    do_fio(&c__1, "*****************************************************", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___232);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___233);
    do_fio(&c__1, "    Coordinates Transformation Library  ROCOTLIB", (ftnlen)
	    48);
    e_wsfe();
    s_wsfe(&io___234);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___235);
    do_fio(&c__1, "        Revised Version ", (ftnlen)24);
    do_fio(&c__1, (char *)&vernum, (ftnlen)sizeof(real));
    do_fio(&c__1, " - ", (ftnlen)3);
    do_fio(&c__1, verdat, (ftnlen)14);
    e_wsfe();
    s_wsfe(&io___236);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___237);
    do_fio(&c__1, "               ___________________", (ftnlen)34);
    e_wsfe();
    s_wsfe(&io___238);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___239);
    do_fio(&c__1, "              initially supported by ", (ftnlen)37);
    e_wsfe();
    s_wsfe(&io___240);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___241);
    do_fio(&c__1, "              EUROPEAN  SPACE  AGENCY", (ftnlen)37);
    e_wsfe();
    s_wsfe(&io___242);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___243);
    do_fio(&c__1, "           Study of the Cluster Mission", (ftnlen)39);
    e_wsfe();
    s_wsfe(&io___244);
    do_fio(&c__1, "             Planning Related Aspects", (ftnlen)37);
    e_wsfe();
    s_wsfe(&io___245);
    do_fio(&c__1, "      within the Numerical Simulations Network", (ftnlen)
	    46);
    e_wsfe();
    s_wsfe(&io___246);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___247);
    do_fio(&c__1, "        Patrick ROBERT, CRPE, November 1992", (ftnlen)43);
    e_wsfe();
    s_wsfe(&io___248);
    do_fio(&c__1, "               ___________________", (ftnlen)34);
    e_wsfe();
    s_wsfe(&io___249);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___250);
    do_fio(&c__1, " version 1.0, November 1992                          ", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___251);
    do_fio(&c__1, " version 1.1, July     1993                          ", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___252);
    do_fio(&c__1, " version 1.2, January  1995                          ", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___253);
    do_fio(&c__1, " version 1.3, July     2000 (Jul. day 2000/sun dir)  ", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___254);
    do_fio(&c__1, " version 1.4, June     2001 (for automatic docum.)   ", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___255);
    do_fio(&c__1, " version 1.5, December 2001 (add cp_sunrise_sunset   ", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___256);
    do_fio(&c__1, " version 1.6, Juin     2002 (upgrade IGRF -> 2005)   ", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___257);
    do_fio(&c__1, " version 1.7, December 2002 (Version for CDPP)       ", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___258);
    do_fio(&c__1, " version 1.8, November 2003 (add t_sr2_to_sr)        ", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___259);
    do_fio(&c__1, " version 1.9, March    2004 (compatibility with IDL) ", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___260);
    do_fio(&c__1, " version 2.0, November 2006 (Update  IGRF -> 2010)   ", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___261);
    do_fio(&c__1, " version 2.1, November 2006 (Update  IGRF -> 2015)   ", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___262);
    do_fio(&c__1, " version 2.2, December 2011 (cp_sunrise_sunset polar)", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___263);
    do_fio(&c__1, " version 3.0, May      2017 (IGRF->table geomag. pole", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___264);
    do_fio(&c__1, "                     -> 2020 +some other coord. sys.)", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___265);
    do_fio(&c__1, " version 3.1, January  2019 (compatibility with V2.2)", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___266);
    do_fio(&c__1, " version 3.2, February 2020 (add trans. Euler angles)", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___267);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___268);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___269);
    do_fio(&c__1, "      Copyright 1992, Patrick ROBERT, CNRS-ESA,", (ftnlen)
	    47);
    e_wsfe();
    s_wsfe(&io___270);
    do_fio(&c__1, "               All Rights reserved", (ftnlen)34);
    e_wsfe();
    s_wsfe(&io___271);
    do_fio(&c__1, "               ___________________", (ftnlen)34);
    e_wsfe();
    s_wsfe(&io___272);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___273);
    do_fio(&c__1, "    For details, see the orginal document untitled:", (
	    ftnlen)51);
    e_wsfe();
    s_wsfe(&io___274);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___275);
    do_fio(&c__1, "              CLUSTER Software Tools", (ftnlen)36);
    e_wsfe();
    s_wsfe(&io___276);
    do_fio(&c__1, "      Part I: Coordinate Transformation Library", (ftnlen)
	    47);
    e_wsfe();
    s_wsfe(&io___277);
    do_fio(&c__1, "          Document de travail DT/CRPE/1231", (ftnlen)42);
    e_wsfe();
    s_wsfe(&io___278);
    do_fio(&c__1, "        Patrick Robert, CRPE/TID, Juillet 1993", (ftnlen)
	    46);
    e_wsfe();
    s_wsfe(&io___279);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___280);
    do_fio(&c__1, "    Available at CDPP:", (ftnlen)22);
    e_wsfe();
    s_wsfe(&io___281);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___282);
    do_fio(&c__1, "    ROCOTLIB: a coordinate Transformation Library", (
	    ftnlen)49);
    e_wsfe();
    s_wsfe(&io___283);
    do_fio(&c__1, "              for Solar-Terrestrial studies", (ftnlen)43);
    e_wsfe();
    s_wsfe(&io___284);
    do_fio(&c__1, "    Patrick ROBERT, version 1.7 - January 2003,", (ftnlen)
	    47);
    e_wsfe();
    s_wsfe(&io___285);
    do_fio(&c__1, "        Rapport Interne no RI-CETP/02/2003", (ftnlen)42);
    e_wsfe();
    s_wsfe(&io___286);
    do_fio(&c__1, "               ___________________", (ftnlen)34);
    e_wsfe();
    s_wsfe(&io___287);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___288);
    do_fio(&c__1, " The present version 3.0 contains new transformations", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___289);
    do_fio(&c__1, " (TPN, MVA), and the cp_sunrise_sunset sub. allowing ", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___290);
    do_fio(&c__1, " computation of sunrise and sunset anywhere on Earth,", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___291);
    do_fio(&c__1, " including polar zones.          ", (ftnlen)33);
    e_wsfe();
    s_wsfe(&io___292);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___293);
    do_fio(&c__1, " The determination of the dipole axis direction", (ftnlen)
	    47);
    e_wsfe();
    s_wsfe(&io___294);
    do_fio(&c__1, " has been replaced by a table available from years", (
	    ftnlen)50);
    e_wsfe();
    s_wsfe(&io___295);
    do_fio(&c__1, " 1900 to 2020, in order to have an easy way to code ", (
	    ftnlen)52);
    e_wsfe();
    s_wsfe(&io___296);
    do_fio(&c__1, " maintenance in the coming years.", (ftnlen)33);
    e_wsfe();
    s_wsfe(&io___297);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___298);
    do_fio(&c__1, " Operations on matrix (somme, product, inversion, ", (
	    ftnlen)50);
    e_wsfe();
    s_wsfe(&io___299);
    do_fio(&c__1, " computation of eigen vectors, diagonalization...)", (
	    ftnlen)50);
    e_wsfe();
    s_wsfe(&io___300);
    do_fio(&c__1, " required for Minimum Variance Analysis coordinates", (
	    ftnlen)51);
    e_wsfe();
    s_wsfe(&io___301);
    do_fio(&c__1, " have been added with prefix \"mat_\".", (ftnlen)36);
    e_wsfe();
    s_wsfe(&io___302);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___303);
    do_fio(&c__1, " The previous and temporary V3.1 is the same as 3.0 ", (
	    ftnlen)52);
    e_wsfe();
    s_wsfe(&io___304);
    do_fio(&c__1, " but is compatible with V2.2 version concerning ", (ftnlen)
	    48);
    e_wsfe();
    s_wsfe(&io___305);
    do_fio(&c__1, " subroutine name (ex: tmaggsm -> t_mag_to_gsm) ", (ftnlen)
	    47);
    e_wsfe();
    s_wsfe(&io___306);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___307);
    do_fio(&c__1, " The present V3.2 version contains transformations ", (
	    ftnlen)51);
    e_wsfe();
    s_wsfe(&io___308);
    do_fio(&c__1, " with Euler angles and their interpolation. ", (ftnlen)44);
    e_wsfe();
    s_wsfe(&io___309);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___310);
    do_fio(&c__1, " Original code developped in Fortran 77.", (ftnlen)40);
    e_wsfe();
    s_wsfe(&io___311);
    do_fio(&c__1, " Fortran 90, C, and IDL codes are also available.", (
	    ftnlen)49);
    e_wsfe();
    s_wsfe(&io___312);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();
    s_wsfe(&io___313);
    do_fio(&c__1, "*****************************************************", (
	    ftnlen)53);
    e_wsfe();
    s_wsfe(&io___314);
    do_fio(&c__1, " ", (ftnlen)1);
    e_wsfe();


    return 0;
} /* print_rocot_info__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int r_coordinate_values__(real *x, real *y, real *z__, char *
	cs, ftnlen cs_len)
{
    /* Format strings */
    static char fmt_100[] = "(a)";
    static char fmt_110[] = "(1pe14.6,1x,f8.3,1x,f8.3)";
    static char fmt_120[] = "(1x,a,3(1pe11.3),a)";
    static char fmt_200[] = "(1x,a,1pe11.3,f8.3,f8.3,a)";

    /* Builtin functions */
    double acos(doublereal);
    integer s_wsfe(cilist *), do_fio(integer *, char *, ftnlen), e_wsfe(void),
	     s_rsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_rsle(void), s_wsle(cilist *), e_wsle(void);

    /* Local variables */
    static real r__, phi, tet, pisd;
    extern /* Subroutine */ int t_sph_to_car__(real *, real *, real *, real *,
	     real *, real *), t_car_to_sph__(real *, real *, real *, real *, 
	    real *, real *);

    /* Fortran I/O blocks */
    static cilist io___316 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___317 = { 0, 5, 0, 0, 0 };
    static cilist io___318 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___319 = { 0, 6, 0, 0, 0 };
    static cilist io___320 = { 0, 6, 0, 0, 0 };
    static cilist io___321 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___322 = { 0, 5, 0, 0, 0 };
    static cilist io___326 = { 0, 6, 0, fmt_110, 0 };
    static cilist io___327 = { 0, 6, 0, fmt_120, 0 };
    static cilist io___328 = { 0, 6, 0, 0, 0 };
    static cilist io___329 = { 0, 5, 0, 0, 0 };
    static cilist io___330 = { 0, 6, 0, 0, 0 };
    static cilist io___331 = { 0, 6, 0, fmt_200, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : read modules of Rocotlib Software */
/* *   Object : read coordinate values from input */
/* *   Author : P. Robert, CRPE, 2002 */

/* *   Comment: read cs and x,y,z cartesian  or spherical coordinates */
/* *            print error if cs is not valid, and ask again */

/* *   Input  : cs (c or s) and x,y,z on standard input */
/* *   Output : cs and x,y,z always in cartesian coordinates */
/* ---------------------------------------------------------------------- */



    pisd = acos(-1.f) / 180.f;

L10:

    s_wsfe(&io___316);
    do_fio(&c__1, "input coordinates: cartesian (c) or spherical (s)", (
	    ftnlen)49);
    e_wsfe();
    s_rsle(&io___317);
    do_lio(&c__9, &c__1, cs, (ftnlen)1);
    e_rsle();
    s_wsfe(&io___318);
    do_fio(&c__1, cs, (ftnlen)1);
    e_wsfe();

    if (*(unsigned char *)cs != 's' && *(unsigned char *)cs != 'c') {
	s_wsle(&io___319);
	do_lio(&c__9, &c__1, "only c or s", (ftnlen)11);
	e_wsle();
	s_wsle(&io___320);
	do_lio(&c__9, &c__1, "again...", (ftnlen)8);
	e_wsle();
	goto L10;
    }
    if (*(unsigned char *)cs == 's') {
	s_wsfe(&io___321);
	do_fio(&c__1, "R,tet, phi (RE,deg.) ?", (ftnlen)22);
	e_wsfe();
	s_rsle(&io___322);
	do_lio(&c__4, &c__1, (char *)&r__, (ftnlen)sizeof(real));
	do_lio(&c__4, &c__1, (char *)&tet, (ftnlen)sizeof(real));
	do_lio(&c__4, &c__1, (char *)&phi, (ftnlen)sizeof(real));
	e_rsle();
	s_wsfe(&io___326);
	do_fio(&c__1, (char *)&r__, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&tet, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&phi, (ftnlen)sizeof(real));
	e_wsfe();

	tet *= pisd;
	phi *= pisd;
	t_sph_to_car__(&r__, &tet, &phi, x, y, z__);
	s_wsfe(&io___327);
	do_fio(&c__1, "then x,y,z = ", (ftnlen)13);
	do_fio(&c__1, (char *)&(*x), (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&(*y), (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&(*z__), (ftnlen)sizeof(real));
	do_fio(&c__1, "(RE)", (ftnlen)4);
	e_wsfe();

    } else {
	s_wsle(&io___328);
	do_lio(&c__9, &c__1, "x,y,z ? (RE) ", (ftnlen)13);
	e_wsle();
	s_rsle(&io___329);
	do_lio(&c__4, &c__1, (char *)&(*x), (ftnlen)sizeof(real));
	do_lio(&c__4, &c__1, (char *)&(*y), (ftnlen)sizeof(real));
	do_lio(&c__4, &c__1, (char *)&(*z__), (ftnlen)sizeof(real));
	e_rsle();
	s_wsle(&io___330);
	do_lio(&c__4, &c__1, (char *)&(*x), (ftnlen)sizeof(real));
	do_lio(&c__4, &c__1, (char *)&(*y), (ftnlen)sizeof(real));
	do_lio(&c__4, &c__1, (char *)&(*z__), (ftnlen)sizeof(real));
	e_wsle();

	t_car_to_sph__(x, y, z__, &r__, &tet, &phi);
	tet /= pisd;
	phi /= pisd;
	s_wsfe(&io___331);
	do_fio(&c__1, "then R,tet,phi= ", (ftnlen)16);
	do_fio(&c__1, (char *)&r__, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&tet, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&phi, (ftnlen)sizeof(real));
	do_fio(&c__1, " (RE,deg.)", (ftnlen)10);
	e_wsfe();
    }


    return 0;
} /* r_coordinate_values__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int r_coordinate_system__(char *csys, ftnlen csys_len)
{
    /* Format strings */
    static char fmt_100[] = "(a)";

    /* Builtin functions */
    integer s_wsfe(cilist *), do_fio(integer *, char *, ftnlen), e_wsfe(void),
	     s_rsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_rsle(void), s_cmp(char *, char *, ftnlen, ftnlen), s_wsle(
	    cilist *), e_wsle(void);

    /* Fortran I/O blocks */
    static cilist io___332 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___333 = { 0, 5, 0, 0, 0 };
    static cilist io___334 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___335 = { 0, 6, 0, 0, 0 };
    static cilist io___336 = { 0, 6, 0, 0, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : read modules of Rocotlib Software */
/* *   Object : read coordinate system from input and check validity */
/* *   Author : P. Robert, CRPE, 2002 */

/* *   Comment: read csys string variable and check validity */
/* *            (only gei, geo, mag, sma, gsm, gse, gsq) */
/* *            print error if csys is not valid, and ask again */

/* *   Input  : csys on standard input */
/* *   Output : csys */
/* ---------------------------------------------------------------------- */


L10:

    s_wsfe(&io___332);
    do_fio(&c__1, "repere ? (gei, geo, mag, sma, gsm, gse, gsq)", (ftnlen)44);
    e_wsfe();
    s_rsle(&io___333);
    do_lio(&c__9, &c__1, csys, (ftnlen)3);
    e_rsle();
    s_wsfe(&io___334);
    do_fio(&c__1, csys, (ftnlen)3);
    e_wsfe();

    if (s_cmp(csys, "gei", (ftnlen)3, (ftnlen)3) == 0) {
	return 0;
    }
    if (s_cmp(csys, "geo", (ftnlen)3, (ftnlen)3) == 0) {
	return 0;
    }
    if (s_cmp(csys, "mag", (ftnlen)3, (ftnlen)3) == 0) {
	return 0;
    }
    if (s_cmp(csys, "sma", (ftnlen)3, (ftnlen)3) == 0) {
	return 0;
    }
    if (s_cmp(csys, "gsm", (ftnlen)3, (ftnlen)3) == 0) {
	return 0;
    }
    if (s_cmp(csys, "gse", (ftnlen)3, (ftnlen)3) == 0) {
	return 0;
    }
    if (s_cmp(csys, "gsq", (ftnlen)3, (ftnlen)3) == 0) {
	return 0;
    }

    s_wsle(&io___335);
    do_lio(&c__9, &c__1, "Only gei, geo, mag, sma, gsm, gse or gsq please...",
	     (ftnlen)50);
    e_wsle();
    s_wsle(&io___336);
    do_lio(&c__9, &c__1, "again...", (ftnlen)8);
    e_wsle();
    goto L10;

} /* r_coordinate_system__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int r_date__(integer *iyear, integer *imonth, integer *iday)
{
    /* Initialized data */

    static integer month[12] = { 31,28,31,30,31,30,31,31,30,31,30,31 };
    static integer ily = -1;

    /* Format strings */
    static char fmt_100[] = "(a)";
    static char fmt_110[] = "(1x,i4,1x,i2,1x,i2)";

    /* Builtin functions */
    integer s_wsfe(cilist *), do_fio(integer *, char *, ftnlen), e_wsfe(void),
	     s_rsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_rsle(void), s_wsle(cilist *), e_wsle(void);

    /* Local variables */
    extern /* Subroutine */ int cp_leap_year__(integer *, integer *);

    /* Fortran I/O blocks */
    static cilist io___339 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___340 = { 0, 5, 0, 0, 0 };
    static cilist io___341 = { 0, 6, 0, fmt_110, 0 };
    static cilist io___342 = { 0, 6, 0, 0, 0 };
    static cilist io___343 = { 0, 6, 0, 0, 0 };
    static cilist io___344 = { 0, 6, 0, 0, 0 };
    static cilist io___345 = { 0, 6, 0, 0, 0 };
    static cilist io___346 = { 0, 6, 0, 0, 0 };
    static cilist io___347 = { 0, 6, 0, 0, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : read modules of Rocotlib Software */
/* *   Object : read_date from input and check validity */
/* *   Author : P. Robert, CRPE, 1992 */

/* *   Comment: test if year is gt 1900 */
/* *            test if imonth is not greater than 12 */
/*              test if iday is not greather than lengh of the month, */
/*                        takink into account the leap years. */
/*               print error if date is not valid, and ask again */

/* *   Input  : iyear,imonth,iday given in standard input */
/* *   Output : iyear,imonth,iday */
/* ---------------------------------------------------------------------- */



L10:
    s_wsfe(&io___339);
    do_fio(&c__1, " iyear,imonth,iday ? (ex: 1990,10,17)", (ftnlen)37);
    e_wsfe();
    s_rsle(&io___340);
    do_lio(&c__3, &c__1, (char *)&(*iyear), (ftnlen)sizeof(integer));
    do_lio(&c__3, &c__1, (char *)&(*imonth), (ftnlen)sizeof(integer));
    do_lio(&c__3, &c__1, (char *)&(*iday), (ftnlen)sizeof(integer));
    e_rsle();
    s_wsfe(&io___341);
    do_fio(&c__1, (char *)&(*iyear), (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&(*imonth), (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&(*iday), (ftnlen)sizeof(integer));
    e_wsfe();


    if (*iyear < 1900) {
	s_wsle(&io___342);
	do_lio(&c__9, &c__1, "*** Rocotlib/r_date: iyear must be greater tha"
		"n 1900", (ftnlen)52);
	e_wsle();
	s_wsle(&io___343);
	do_lio(&c__9, &c__1, "                     again ...", (ftnlen)30);
	e_wsle();
	goto L10;
    }

    cp_leap_year__(iyear, &ily);


    if (ily == 1) {
	month[1] = 29;
    } else {
	month[1] = 28;
    }

    if (*imonth < 1 || *imonth > 12) {
	s_wsle(&io___344);
	do_lio(&c__9, &c__1, "*** Rocotlib/r_date: imonth must be between 1 "
		"or 12 ", (ftnlen)52);
	e_wsle();
	s_wsle(&io___345);
	do_lio(&c__9, &c__1, "                     again...", (ftnlen)29);
	e_wsle();
	goto L10;
    }

    if (*iday > month[*imonth - 1]) {
	s_wsle(&io___346);
	do_lio(&c__9, &c__1, "*** Rocotlib/r_date: this month has only", (
		ftnlen)40);
	do_lio(&c__3, &c__1, (char *)&month[*imonth - 1], (ftnlen)sizeof(
		integer));
	do_lio(&c__9, &c__1, "days", (ftnlen)4);
	e_wsle();
	s_wsle(&io___347);
	do_lio(&c__9, &c__1, "                     again...", (ftnlen)29);
	e_wsle();
	goto L10;
    }
    return 0;
} /* r_date__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int r_time__(integer *ih, integer *im, integer *is)
{
    /* Format strings */
    static char fmt_100[] = "(a)";
    static char fmt_110[] = "(1x,i2,1x,i2,1x,i2)";

    /* Builtin functions */
    integer s_wsfe(cilist *), do_fio(integer *, char *, ftnlen), e_wsfe(void),
	     s_rsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_rsle(void), s_wsle(cilist *), e_wsle(void);

    /* Fortran I/O blocks */
    static cilist io___348 = { 0, 6, 0, fmt_100, 0 };
    static cilist io___349 = { 0, 5, 0, 0, 0 };
    static cilist io___350 = { 0, 6, 0, fmt_110, 0 };
    static cilist io___351 = { 0, 6, 0, 0, 0 };
    static cilist io___352 = { 0, 6, 0, 0, 0 };
    static cilist io___353 = { 0, 6, 0, 0, 0 };
    static cilist io___354 = { 0, 6, 0, 0, 0 };
    static cilist io___355 = { 0, 6, 0, 0, 0 };
    static cilist io___356 = { 0, 6, 0, 0, 0 };



/* ---------------------------------------------------------------------- */
/* *   Class  : read modules of Rocotlib Software */
/* *   Object : read_time from input and check validity */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: read hour, minute and second and verifie validity */
/*              ih must be between 1 and 23, im and is between 1 and 59 */
/*              print error if time is not valid, and ask again */

/* *   Input  : ih,im,is on standard input */
/* *   Output : ih,im,is */
/* ---------------------------------------------------------------------- */

L10:
    s_wsfe(&io___348);
    do_fio(&c__1, " hour, minute, second ? (ex: 10,45,50)", (ftnlen)38);
    e_wsfe();
    s_rsle(&io___349);
    do_lio(&c__3, &c__1, (char *)&(*ih), (ftnlen)sizeof(integer));
    do_lio(&c__3, &c__1, (char *)&(*im), (ftnlen)sizeof(integer));
    do_lio(&c__3, &c__1, (char *)&(*is), (ftnlen)sizeof(integer));
    e_rsle();
    s_wsfe(&io___350);
    do_fio(&c__1, (char *)&(*ih), (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&(*im), (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&(*is), (ftnlen)sizeof(integer));
    e_wsfe();


    if (*ih < 0 || *ih > 23) {
	s_wsle(&io___351);
	do_lio(&c__9, &c__1, "hour between 0 and 23 please", (ftnlen)28);
	e_wsle();
	s_wsle(&io___352);
	do_lio(&c__9, &c__1, "again...", (ftnlen)8);
	e_wsle();
	goto L10;
    }

    if (*im < 0 || *im > 59) {
	s_wsle(&io___353);
	do_lio(&c__9, &c__1, "minute between 0 and 59 please", (ftnlen)30);
	e_wsle();
	s_wsle(&io___354);
	do_lio(&c__9, &c__1, "again...", (ftnlen)8);
	e_wsle();
	goto L10;
    }

    if (*is < 0 || *is > 59) {
	s_wsle(&io___355);
	do_lio(&c__9, &c__1, "second between 0 and 59 please", (ftnlen)30);
	e_wsle();
	s_wsle(&io___356);
	do_lio(&c__9, &c__1, "again...", (ftnlen)8);
	e_wsle();
	goto L10;
    }

    return 0;
} /* r_time__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_car_to_sph__(real *x, real *y, real *z__, real *r__, 
	real *teta, real *phi)
{
    /* System generated locals */
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal), acos(doublereal), atan2(doublereal, doublereal);

    /* Local variables */
    static real pi, sq, pisd;


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_car_to_sph: CAR -> SPH  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: none */

/* *   Input  :   x,y,z        cartesian coordinates */
/* *   Output :   r,teta,phi   spherical coordinates (angles in radians) */
/* ---------------------------------------------------------------------- */


    *teta = 0.f;
    *phi = 0.f;
/* Computing 2nd power */
    r__1 = *x;
/* Computing 2nd power */
    r__2 = *y;
    sq = r__1 * r__1 + r__2 * r__2;
/* Computing 2nd power */
    r__1 = *z__;
    *r__ = sqrt(sq + r__1 * r__1);
    pi = acos(-1.f);
    pisd = pi / 180.f;

    if (*r__ < 1e-30f) {
	return 0;
    }

/* *** en dessous de 1/10000 degres, on considere que teta =0 ou 180 */
/*     et phi indefini, mis a zero */

    if (sq / *r__ > 1.7e-6f) {
	*phi = atan2(*y, *x);
	if (*phi < pisd * -179.999f && *phi > pisd * -180.f) {
	    *phi = pi;
	}
	if (*phi < pisd * 1e-4f && *phi > pisd * -1e-4f) {
	    *phi = 0.f;
	}
	*teta = acos(*z__ / *r__);
	return 0;
    }

    if (*z__ < 0.f) {
	*teta = acos(-1.f);
    } else {
	*teta = 0.f;
    }

    return 0;
} /* t_car_to_sph__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_dm_to_geo__(real *xdme, real *ydme, real *zdme, real *
	rlat, real *rlong, real *xgeo, real *ygeo, real *zgeo)
{
    /* System generated locals */
    real r__1, r__2, r__3;

    /* Builtin functions */
    double cos(doublereal), sin(doublereal), sqrt(doublereal);

    /* Local variables */
    static real q, r1, r2, r3, x1, y1, y2, y3, x2, x3;


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_dme_to_geo: DM  -> GEO  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xdme,ydme,zdme   cartesian dme coordinates */
/*              rlat,rlong       latitude and longitude of the point */
/*                               of observation (radians) */
/* *   Output : xgeo,ygeo,zgeo   cartesian geo coordinates */
/* ---------------------------------------------------------------------- */



    q = cos(*rlat);
    r1 = q * cos(*rlong);
    r2 = q * sin(*rlong);
    r3 = sin(*rlat);

    y1 = (real) ((doublereal) timp02_1.gd2 * r3 - (doublereal) timp02_1.gd3 * 
	    r2);
    y2 = (real) ((doublereal) timp02_1.gd3 * r1 - (doublereal) timp02_1.gd1 * 
	    r3);
    y3 = (real) ((doublereal) timp02_1.gd1 * r2 - (doublereal) timp02_1.gd2 * 
	    r1);

/* Computing 2nd power */
    r__1 = y1;
/* Computing 2nd power */
    r__2 = y2;
/* Computing 2nd power */
    r__3 = y3;
    q = sqrt(r__1 * r__1 + r__2 * r__2 + r__3 * r__3);

    y1 /= q;
    y2 /= q;
    y3 /= q;

    x1 = (real) ((doublereal) y2 * timp02_1.gd3 - (doublereal) y3 * 
	    timp02_1.gd2);
    x2 = (real) ((doublereal) y3 * timp02_1.gd1 - (doublereal) y1 * 
	    timp02_1.gd3);
    x3 = (real) ((doublereal) y1 * timp02_1.gd2 - (doublereal) y2 * 
	    timp02_1.gd1);


    *xgeo = x1 * *xdme + y1 * *ydme + timp02_1.gd1 * *zdme;
    *ygeo = x2 * *xdme + y2 * *ydme + timp02_1.gd2 * *zdme;
    *zgeo = x3 * *xdme + y3 * *ydme + timp02_1.gd3 * *zdme;

    return 0;
} /* t_dm_to_geo__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gei_to_geo__(real *xgei, real *ygei, real *zgei, real *
	xgeo, real *ygeo, real *zgeo)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gei_to_geo: GEI -> GEO  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgei,ygei,zgei   cartesian gei coordinates */
/* *   Output : xgeo,ygeo,zgeo   cartesian geo coordinates */
/* ---------------------------------------------------------------------- */



    *xgeo = timp00_1.cgst * *xgei + timp00_1.sgst * *ygei;
    *ygeo = -timp00_1.sgst * *xgei + timp00_1.cgst * *ygei;
    *zgeo = *zgei;

    return 0;
} /* t_gei_to_geo__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gei_to_gse__(real *xgei, real *ygei, real *zgei, real *
	xgse, real *ygse, real *zgse)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gei_to_gse: GEI -> GSE  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgei,ygei,zgei cartesian gei coordinates */
/* *   Output : xgse,ygse,zgse cartesian gse coordinates */
/* ---------------------------------------------------------------------- */



    *xgse = timp01_1.gs1 * *xgei + timp01_1.gs2 * *ygei + timp01_1.gs3 * *
	    zgei;
    *ygse = timp03_1.gegs1 * *xgei + timp03_1.gegs2 * *ygei + timp03_1.gegs3 *
	     *zgei;
    *zgse = timp01_1.ge1 * *xgei + timp01_1.ge2 * *ygei + timp01_1.ge3 * *
	    zgei;

    return 0;
} /* t_gei_to_gse__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gei_to_gsm__(real *xgei, real *ygei, real *zgei, real *
	xgsm, real *ygsm, real *zgsm)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gei_to_gsm: GEI -> GSM  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgei,ygei,zgei   cartesian gei coordinates */
/* *   Output : xgsm,ygsm,zgsm   cartesian gsm coordinates */
/* ---------------------------------------------------------------------- */



    *xgsm = timp01_1.gs1 * *xgei + timp01_1.gs2 * *ygei + timp01_1.gs3 * *
	    zgei;
    *ygsm = timp09_1.yeigm1 * *xgei + timp09_1.yeigm2 * *ygei + 
	    timp09_1.yeigm3 * *zgei;
    *zgsm = timp09_1.zeigm1 * *xgei + timp09_1.zeigm2 * *ygei + 
	    timp09_1.zeigm3 * *zgei;

    return 0;
} /* t_gei_to_gsm__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gei_to_gseq__(real *xgei, real *ygei, real *zgei, real 
	*xgsq, real *ygsq, real *zgsq)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gei_to_gsq: GEI -> GSEQ system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgei,ygei,zgei   cartesian gei coordinates */
/* *   Output : xgsq,ygsq,zgsq   cartesian gsq coordinates */
/* ---------------------------------------------------------------------- */



    *xgsq = timp01_1.gs1 * *xgei + timp01_1.gs2 * *ygei + timp01_1.gs3 * *
	    zgei;
    *ygsq = timp10_1.yeigq1 * *xgei + timp10_1.yeigq2 * *ygei + 
	    timp10_1.yeigq3 * *zgei;
    *zgsq = timp10_1.zeigq1 * *xgei + timp10_1.zeigq2 * *ygei + 
	    timp10_1.zeigq3 * *zgei;

    return 0;
} /* t_gei_to_gseq__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gei_to_mag__(real *xgei, real *ygei, real *zgei, real *
	xmag, real *ymag, real *zmag)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gei_to_mag: GEI -> MAG  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgei,ygei,zgei   cartesian gei coordinates */
/* *   Output : xmag,ymag,zmag   cartesian mag coordinates */
/* ---------------------------------------------------------------------- */



    *xmag = timp07_1.xeima1 * *xgei + timp07_1.xeima2 * *ygei + 
	    timp07_1.xeima3 * *zgei;
    *ymag = timp07_1.yeima1 * *xgei + timp07_1.yeima2 * *ygei + 
	    timp07_1.yeima3 * *zgei;
    *zmag = timp01_1.gm1 * *xgei + timp01_1.gm2 * *ygei + timp01_1.gm3 * *
	    zgei;

    return 0;
} /* t_gei_to_mag__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gei_to_sm__(real *xgei, real *ygei, real *zgei, real *
	xsma, real *ysma, real *zsma)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gei_to_sma: GEI -> SM   system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgei,ygei,zgei   cartesian gei coordinates */
/* *   Output : xsma,ysma,zsma   cartesian sma coordinates */
/* ---------------------------------------------------------------------- */



    *xsma = timp08_1.xeism1 * *xgei + timp08_1.xeism2 * *ygei + 
	    timp08_1.xeism3 * *zgei;
    *ysma = timp08_1.yeism1 * *xgei + timp08_1.yeism2 * *ygei + 
	    timp08_1.yeism3 * *zgei;
    *zsma = timp01_1.gm1 * *xgei + timp01_1.gm2 * *ygei + timp01_1.gm3 * *
	    zgei;

    return 0;
} /* t_gei_to_sm__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_geo_to_dm__(real *xgeo, real *ygeo, real *zgeo, real *
	rlat, real *rlong, real *xdme, real *ydme, real *zdme)
{
    /* System generated locals */
    real r__1, r__2, r__3;

    /* Builtin functions */
    double cos(doublereal), sin(doublereal), sqrt(doublereal);

    /* Local variables */
    static real q, r1, r2, r3, x1, y1, y2, y3, x2, x3;


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_geo_to_dme: GEO -> DM   system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgeo,ygeo,zgeo   cartesian geo coordinates */
/*              rlat,rlong       latitude and longitude of the point */
/*                               of observation (radians) */
/* *   Output : xdme,ydme,zdme   cartesian dme coordinates */
/* ---------------------------------------------------------------------- */



    q = cos(*rlat);
    r1 = q * cos(*rlong);
    r2 = q * sin(*rlong);
    r3 = sin(*rlat);

    y1 = (real) ((doublereal) timp02_1.gd2 * r3 - (doublereal) timp02_1.gd3 * 
	    r2);
    y2 = (real) ((doublereal) timp02_1.gd3 * r1 - (doublereal) timp02_1.gd1 * 
	    r3);
    y3 = (real) ((doublereal) timp02_1.gd1 * r2 - (doublereal) timp02_1.gd2 * 
	    r1);

/* Computing 2nd power */
    r__1 = y1;
/* Computing 2nd power */
    r__2 = y2;
/* Computing 2nd power */
    r__3 = y3;
    q = sqrt(r__1 * r__1 + r__2 * r__2 + r__3 * r__3);

    y1 /= q;
    y2 /= q;
    y3 /= q;

    x1 = (real) ((doublereal) y2 * timp02_1.gd3 - (doublereal) y3 * 
	    timp02_1.gd2);
    x2 = (real) ((doublereal) y3 * timp02_1.gd1 - (doublereal) y1 * 
	    timp02_1.gd3);
    x3 = (real) ((doublereal) y1 * timp02_1.gd2 - (doublereal) y2 * 
	    timp02_1.gd1);

    *xdme = x1 * *xgeo + x2 * *ygeo + x3 * *zgeo;
    *ydme = y1 * *xgeo + y2 * *ygeo + y3 * *zgeo;
    *zdme = timp02_1.gd1 * *xgeo + timp02_1.gd2 * *ygeo + timp02_1.gd3 * *
	    zgeo;

    return 0;
} /* t_geo_to_dm__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_geo_to_gei__(real *xgeo, real *ygeo, real *zgeo, real *
	xgei, real *ygei, real *zgei)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_geo_to_gei: GEO -> GEI  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgeo,ygeo,zgeo cartesian geo coordinates */
/* *   Output : xgei,ygei,zgei cartesian gei coordinates */
/* ---------------------------------------------------------------------- */



    *xgei = timp00_1.cgst * *xgeo - timp00_1.sgst * *ygeo;
    *ygei = timp00_1.sgst * *xgeo + timp00_1.cgst * *ygeo;
    *zgei = *zgeo;

    return 0;
} /* t_geo_to_gei__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_geo_to_gse__(real *xgeo, real *ygeo, real *zgeo, real *
	xgse, real *ygse, real *zgse)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_geo_to_gse: GEO -> GSE  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgeo,ygeo,zgeo   cartesian geo coordinates */
/* *   Output : xgse,ygse,zgse   cartesian gse coordinates */
/* ---------------------------------------------------------------------- */



    *xgse = timp02_1.ps1 * *xgeo + timp02_1.ps2 * *ygeo + timp02_1.ps3 * *
	    zgeo;
    *ygse = timp06_1.peps1 * *xgeo + timp06_1.peps2 * *ygeo + timp06_1.peps3 *
	     *zgeo;
    *zgse = timp02_1.pe1 * *xgeo + timp02_1.pe2 * *ygeo + timp02_1.pe3 * *
	    zgeo;

    return 0;
} /* t_geo_to_gse__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_geo_to_gsm__(real *xgeo, real *ygeo, real *zgeo, real *
	xgsm, real *ygsm, real *zgsm)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_geo_to_gsm: GEO -> GSM  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgeo,ygeo,zgeo   cartesian geo coordinates */
/* *   Output : xgsm,ygsm,zgsm   cartesian gsm coordinates */
/* ---------------------------------------------------------------------- */



    *xgsm = timp02_1.ps1 * *xgeo + timp02_1.ps2 * *ygeo + timp02_1.ps3 * *
	    zgeo;
    *ygsm = timp14_1.yeogm1 * *xgeo + timp14_1.yeogm2 * *ygeo + 
	    timp14_1.yeogm3 * *zgeo;
    *zgsm = timp14_1.zeogm1 * *xgeo + timp14_1.zeogm2 * *ygeo + 
	    timp14_1.zeogm3 * *zgeo;

    return 0;
} /* t_geo_to_gsm__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_geo_to_gseq__(real *xgeo, real *ygeo, real *zgeo, real 
	*xgsq, real *ygsq, real *zgsq)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_geo_to_gsq: GEO -> GSEQ system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgeo,ygeo,zgeo   cartesian geo coordinates */
/* *   Output : xgsq,ygsq,zgsq   cartesian gsq coordinates */
/* ---------------------------------------------------------------------- */



    *xgsq = timp02_1.ps1 * *xgeo + timp02_1.ps2 * *ygeo + timp02_1.ps3 * *
	    zgeo;
    *ygsq = timp15_1.yeogq1 * *xgeo + timp15_1.yeogq2 * *ygeo + 
	    timp15_1.yeogq3 * *zgeo;
    *zgsq = timp15_1.zeogq1 * *xgeo + timp15_1.zeogq2 * *ygeo + 
	    timp15_1.zeogq3 * *zgeo;

    return 0;
} /* t_geo_to_gseq__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_geo_to_mag__(real *xgeo, real *ygeo, real *zgeo, real *
	xmag, real *ymag, real *zmag)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_geo_to_mag: GEO -> MAG  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgeo,ygeo,zgeo   cartesian geo coordinates */
/* *   Output : xmag,ymag,zmag   cartesian mag coordinates */
/* ---------------------------------------------------------------------- */



    *xmag = timp12_1.xeoma1 * *xgeo + timp12_1.xeoma2 * *ygeo + 
	    timp12_1.xeoma3 * *zgeo;
    *ymag = timp12_1.yeoma1 * *xgeo + timp12_1.yeoma2 * *ygeo + 
	    timp12_1.yeoma3 * *zgeo;
    *zmag = timp02_1.gd1 * *xgeo + timp02_1.gd2 * *ygeo + timp02_1.gd3 * *
	    zgeo;

    return 0;
} /* t_geo_to_mag__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_geo_to_sm__(real *xgeo, real *ygeo, real *zgeo, real *
	xsma, real *ysma, real *zsma)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_geo_to_sma: GEO -> SM   system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgeo,ygeo,zgeo   cartesian geo coordinates */
/* *   Output : xsma,ysma,zsma   cartesian sma coordinates */
/* ---------------------------------------------------------------------- */



    *xsma = timp13_1.xeosm1 * *xgeo + timp13_1.xeosm2 * *ygeo + 
	    timp13_1.xeosm3 * *zgeo;
    *ysma = timp13_1.yeosm1 * *xgeo + timp13_1.yeosm2 * *ygeo + 
	    timp13_1.yeosm3 * *zgeo;
    *zsma = timp02_1.gd1 * *xgeo + timp02_1.gd2 * *ygeo + timp02_1.gd3 * *
	    zgeo;

    return 0;
} /* t_geo_to_sm__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_geo_to_vdh__(real *xgeo, real *ygeo, real *zgeo, real *
	rlat, real *rlong, real *xvdh, real *yvdh, real *zvdh)
{
    /* System generated locals */
    real r__1, r__2;

    /* Builtin functions */
    double cos(doublereal), sin(doublereal), sqrt(doublereal);

    /* Local variables */
    static real q, d1, d2, d3, h1, h2, h3, r1, r2, r3, v1, v2, v3, q12;


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_geo_to_vdh: GEO -> VDH  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: local system, non time dependent */

/* *   Input  : xgeo,ygeo,zgeo   cartesian geo coordinates */
/*              rlat,rlong       latitude and longitude of the point */
/*                               of observation (radians) */
/* *   Output : xvdh,yvdh,zvdh   cartesian vdh coordinates */
/* ---------------------------------------------------------------------- */


    q = cos(*rlat);
    r1 = q * cos(*rlong);
    r2 = q * sin(*rlong);
    r3 = sin(*rlat);

    v1 = r1;
    v2 = r2;
    v3 = r3;

/* Computing 2nd power */
    r__1 = r1;
/* Computing 2nd power */
    r__2 = r2;
    q12 = sqrt(r__1 * r__1 + r__2 * r__2);

    d1 = -r2 / q12;
    d2 = r1 / q12;
    d3 = 0.f;

    h1 = -r1 * r3 / q12;
    h2 = -r2 * r3 / q12;
    h3 = q12;

    *xvdh = v1 * *xgeo + v2 * *ygeo + v3 * *zgeo;
    *yvdh = d1 * *xgeo + d2 * *ygeo + d3 * *zgeo;
    *zvdh = h1 * *xgeo + h2 * *ygeo + h3 * *zgeo;

    return 0;
} /* t_geo_to_vdh__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gse_to_gei__(real *xgse, real *ygse, real *zgse, real *
	xgei, real *ygei, real *zgei)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gse_to_gei: GSE -> GEI  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgse,ygse,zgse    cartesian gse coordinates */
/* *   Output : xgei,ygei,zgei    cartesian gei coordinates */
/* ---------------------------------------------------------------------- */



    *xgei = timp01_1.gs1 * *xgse + timp03_1.gegs1 * *ygse + timp01_1.ge1 * *
	    zgse;
    *ygei = timp01_1.gs2 * *xgse + timp03_1.gegs2 * *ygse + timp01_1.ge2 * *
	    zgse;
    *zgei = timp01_1.gs3 * *xgse + timp03_1.gegs3 * *ygse + timp01_1.ge3 * *
	    zgse;

    return 0;
} /* t_gse_to_gei__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gse_to_geo__(real *xgse, real *ygse, real *zgse, real *
	xgeo, real *ygeo, real *zgeo)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gse_to_geo: GSE -> GEO  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgse,ygse,zgse   cartesian gse coordinates */
/* *   Output : xgeo,ygeo,zgeo   cartesian geo coordinates */
/* ---------------------------------------------------------------------- */



    *xgeo = timp02_1.ps1 * *xgse + timp06_1.peps1 * *ygse + timp02_1.pe1 * *
	    zgse;
    *ygeo = timp02_1.ps2 * *xgse + timp06_1.peps2 * *ygse + timp02_1.pe2 * *
	    zgse;
    *zgeo = timp02_1.ps3 * *xgse + timp06_1.peps3 * *ygse + timp02_1.pe3 * *
	    zgse;

    return 0;
} /* t_gse_to_geo__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gse_to_gsm__(real *xgse, real *ygse, real *zgse, real *
	xgsm, real *ygsm, real *zgsm)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gse_to_gsm: GSE -> GSM  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgse,ygse,zgse   cartesian gse coordinates */
/* *   Output : xgsm,ygsm,zgsm   cartesian gsm coordinates */
/* ---------------------------------------------------------------------- */



    *xgsm = *xgse;
    *ygsm = timp11_1.cdze * *ygse + timp11_1.sdze * *zgse;
    *zgsm = -timp11_1.sdze * *ygse + timp11_1.cdze * *zgse;

    return 0;
} /* t_gse_to_gsm__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gse_to_gseq__(real *xgse, real *ygse, real *zgse, real 
	*xgsq, real *ygsq, real *zgsq)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gse_to_gsq: GSE -> GSEQ system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgse,ygse,zgse   cartesian gse coordinates */
/* *   Output : xgsq,ygsq,zgsq   cartesian gsq coordinates */
/* ---------------------------------------------------------------------- */



    *xgsq = *xgse;
    *ygsq = timp11_1.ctetq * *ygse - timp11_1.stetq * *zgse;
    *zgsq = timp11_1.stetq * *ygse + timp11_1.ctetq * *zgse;

    return 0;
} /* t_gse_to_gseq__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gse_to_mfa__(real *xgse, real *ygse, real *zgse, real *
	bx, real *by, real *bz, real *xmfa, real *ymfa, real *zmfa)
{
    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    static real b0, xp, yp, zp, sxm, sym, xmag, ymag, zmag, bperp, cosphi, 
	    sinphi, cospsi, costet, sinpsi, sintet, smperp;


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gse_to_mfa: GSE -> MFA  system */
/* *   Author : P. Robert, LPP , 2016 */
/* *   Comment: local system, non time dependent */

/* *   Input  : xgse,ygse,gsez cartesian gse coordinates */
/*              bx,  by,  bz   cartesian gse coordinates of DC mag field */
/* *   Output : xmfa,ymfa,zmfa cartesian mfa coordinates */
/* ---------------------------------------------------------------------- */


/* *** tranform the vector from gse to mfa */

    bperp = sqrt(*bx * *bx + *by * *by);
    b0 = sqrt(*bx * *bx + *by * *by + *bz * *bz);

/* **  first rotation */

    sinphi = *by / bperp;
    cosphi = *bx / bperp;

    xp = cosphi * *xgse + sinphi * *ygse;
    yp = -sinphi * *xgse + cosphi * *ygse;
    zp = *zgse;

/* **  second rotation */

    sintet = bperp / b0;
    costet = *bz / b0;

    xmag = costet * xp - sintet * zp;
    ymag = yp;
    zmag = sintet * xp + costet * zp;

/* **  third rotation */

    sxm = costet * cosphi;
    sym = -sinphi;

    smperp = sqrt(sxm * sxm + sym * sym);

    sinpsi = sym / smperp;
    cospsi = sxm / smperp;

    *xmfa = cospsi * xmag + sinpsi * ymag;
    *ymfa = -sinpsi * xmag + cospsi * ymag;
    *zmfa = zmag;

    return 0;
} /* t_gse_to_mfa__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gse_to_sr2__(real *xgse, real *ygse, real *zgse, real *
	rotx, real *roty, real *rotz, real *xsr2, real *ysr2, real *zsr2)
{
    /* System generated locals */
    real r__1, r__2, r__3;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    static real a, x1, x2, x3, y1, y2, y3, z1, z2, z3, rx, ry, rz, rmod;


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gse_to_sr2: GSE -> SR2  system */
/* *   Author : P. Robert, CETP, 2001 */
/* *   Comment: local system, non time dependent */

/* *   Input  : xgse,ygse,zgse cartesian gse coordinates */
/*              rotx,roty,rotz cartesian gse coordinates of rotation axis */
/* *   Output : xsr2,ysr2,zsr2 cartesian sr2 coordinates */
/* ---------------------------------------------------------------------- */


/* *** set transform matrix with Spin axis terms */

/* Computing 2nd power */
    r__1 = *rotx;
/* Computing 2nd power */
    r__2 = *roty;
/* Computing 2nd power */
    r__3 = *rotz;
    rmod = sqrt(r__1 * r__1 + r__2 * r__2 + r__3 * r__3);

    rx = *rotx / rmod;
    ry = *roty / rmod;
    rz = *rotz / rmod;

    a = 1.f / sqrt(ry * ry + rz * rz);

    x1 = (ry * ry + rz * rz) * a;
    x2 = -rx * ry * a;
    x3 = -rx * rz * a;

    y1 = 0.f;
    y2 = rz * a;
    y3 = -ry * a;

    z1 = rx;
    z2 = ry;
    z3 = rz;

/* *** tranform the input vector from gse to sr2 */

    *xsr2 = x1 * *xgse + x2 * *ygse + x3 * *zgse;
    *ysr2 = y1 * *xgse + y2 * *ygse + y3 * *zgse;
    *zsr2 = z1 * *xgse + z2 * *ygse + z3 * *zgse;

    return 0;
} /* t_gse_to_sr2__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gse_to_tpn__(real *xgse, real *ygse, real *zgse, real *
	xo, real *yo, real *zo, real *xs, real *xtpn, real *ytpn, real *ztpn)
{
    static real nx, px, tx, ty, tz, py, pz, ny, nz;
    extern /* Subroutine */ int cp_tpn_param__(real *, real *, real *, real *,
	     real *, real *, real *, real *, real *, real *, real *, real *, 
	    real *);


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gse_to_tpn: GSE -> TPN  system */
/* *   Author : P. Robert, LPP , 2016 */
/* *   Comment: local system, non time dependent */

/* *   Input  : xgse,ygse,zgse cartesian gse vector */
/*              xo,yo,zo position of the S/C in gse */
/*              xs subsolar point, submit of the paraboloid */
/*              from Earth to Sun */
/* *   Output : xtpn,ytpn,ztpn cartesian tpn coordinates */
/* ---------------------------------------------------------------------- */


/*     computation of the TPN axis in gse system */

    cp_tpn_param__(xo, yo, zo, xs, &tx, &ty, &tz, &px, &py, &pz, &nx, &ny, &
	    nz);

    *xtpn = tx * *xgse + ty * *ygse + tz * *zgse;
    *ytpn = px * *xgse + py * *ygse + pz * *zgse;
    *ztpn = nx * *xgse + ny * *ygse + nz * *zgse;

    return 0;
} /* t_gse_to_tpn__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gsm_to_gei__(real *xgsm, real *ygsm, real *zgsm, real *
	xgei, real *ygei, real *zgei)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gsm_to_gei: GSM -> GEI  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgsm,ygsm,zgsm   cartesian gsm coordinates */
/* *   Output : xgei,ygei,zgei   cartesian gei coordinates */
/* ---------------------------------------------------------------------- */



    *xgei = timp01_1.gs1 * *xgsm + timp09_1.yeigm1 * *ygsm + timp09_1.zeigm1 *
	     *zgsm;
    *ygei = timp01_1.gs2 * *xgsm + timp09_1.yeigm2 * *ygsm + timp09_1.zeigm2 *
	     *zgsm;
    *zgei = timp01_1.gs3 * *xgsm + timp09_1.yeigm3 * *ygsm + timp09_1.zeigm3 *
	     *zgsm;

    return 0;
} /* t_gsm_to_gei__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gsm_to_geo__(real *xgsm, real *ygsm, real *zgsm, real *
	xgeo, real *ygeo, real *zgeo)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gsm_to_geo: GSM -> GEO  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgsm,ygsm,zgsm   cartesian gsm coordinates */
/* *   Output : xgeo,ygeo,zgeo   cartesian geo coordinates */
/* ---------------------------------------------------------------------- */



    *xgeo = timp02_1.ps1 * *xgsm + timp14_1.yeogm1 * *ygsm + timp14_1.zeogm1 *
	     *zgsm;
    *ygeo = timp02_1.ps2 * *xgsm + timp14_1.yeogm2 * *ygsm + timp14_1.zeogm2 *
	     *zgsm;
    *zgeo = timp02_1.ps3 * *xgsm + timp14_1.yeogm3 * *ygsm + timp14_1.zeogm3 *
	     *zgsm;

    return 0;
} /* t_gsm_to_geo__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gsm_to_gse__(real *xgsm, real *ygsm, real *zgsm, real *
	xgse, real *ygse, real *zgse)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gsm_to_gse: GSM -> GSE  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgsm,ygsm,zgsm   cartesian gsm coordinates */
/* *   Output : xgse,ygse,zgse   cartesian gse coordinates */
/* ---------------------------------------------------------------------- */



    *xgse = *xgsm;
    *ygse = timp11_1.cdze * *ygsm - timp11_1.sdze * *zgsm;
    *zgse = timp11_1.sdze * *ygsm + timp11_1.cdze * *zgsm;

    return 0;
} /* t_gsm_to_gse__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gsm_to_gseq__(real *xgsm, real *ygsm, real *zgsm, real 
	*xgsq, real *ygsq, real *zgsq)
{
    static real ax, ay, az;
    extern /* Subroutine */ int t_gsm_to_gse__(real *, real *, real *, real *,
	     real *, real *), t_gse_to_gseq__(real *, real *, real *, real *, 
	    real *, real *);


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gsm_to_gsq: GSM -> GSQ  system */
/* *   Author : P. Robert, CRPE, 2002 */

/* *   Input  : xgsm,ygsm,zgsm cartesian gsm coordinates */
/* *   Output : xgsq,ygsq,zgsq cartesian gsq coordinates */
/* ---------------------------------------------------------------------- */


    t_gsm_to_gse__(xgsm, ygsm, zgsm, &ax, &ay, &az);
    t_gse_to_gseq__(&ax, &ay, &az, xgsq, ygsq, zgsq);

    return 0;
} /* t_gsm_to_gseq__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gsm_to_mag__(real *xgsm, real *ygsm, real *zgsm, real *
	xmag, real *ymag, real *zmag)
{
    static real ax, ay, az;
    extern /* Subroutine */ int t_sm_to_mag__(real *, real *, real *, real *, 
	    real *, real *), t_gsm_to_sm__(real *, real *, real *, real *, 
	    real *, real *);


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gsm_to_mag: GSM -> MAG  system */
/* *   Author : P. Robert, CRPE, 2002 */

/* *   Input  : xgsm,ygsm,zgsm cartesian gsm coordinates */
/* *   Output : xmag,ymag,zmag cartesian mag coordinates */
/* ---------------------------------------------------------------------- */


    t_gsm_to_sm__(xgsm, ygsm, zgsm, &ax, &ay, &az);
    t_sm_to_mag__(&ax, &ay, &az, xmag, ymag, zmag);

    return 0;
} /* t_gsm_to_mag__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gsm_to_sm__(real *xgsm, real *ygsm, real *zgsm, real *
	xsma, real *ysma, real *zsma)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gsm_to_sma: GSM -> SM   system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgsm,ygsm,zgsm   cartesian gsm coordinates */
/* *   Output : xsma,ysma,zsma   cartesian sma coordinates */
/* ---------------------------------------------------------------------- */



    *xsma = timp11_1.cmu * *xgsm - timp11_1.smu * *zgsm;
    *ysma = *ygsm;
    *zsma = timp11_1.smu * *xgsm + timp11_1.cmu * *zgsm;

    return 0;
} /* t_gsm_to_sm__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gsm_to_tpn__(real *xgsm, real *ygsm, real *zgsm, real *
	xo, real *yo, real *zo, real *xs, real *xtpn, real *ytpn, real *ztpn)
{
    static real nx, px, tx, ty, tz, py, pz, ny, nz;
    extern /* Subroutine */ int cp_tpn_param__(real *, real *, real *, real *,
	     real *, real *, real *, real *, real *, real *, real *, real *, 
	    real *);


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gsm_to_tpn: GSM -> TPN  system */
/* *   Author : P. Robert, LPP , 2016 */
/* *   Comment: local system, non time dependent */

/* *   Input  : xgsm,ygsm,zgsm cartesian gsm vector */
/*              xo,yo,zo position of the S/C in gsm */
/*              xs subsolar point, submit of the paraboloid */
/*              from Earth to Sun */
/* *   Output : xtpn,ytpn,ztpn cartesian tpn coordinates */
/* ---------------------------------------------------------------------- */


/*     computation of the TPN axis in gsm system */

    cp_tpn_param__(xo, yo, zo, xs, &tx, &ty, &tz, &px, &py, &pz, &nx, &ny, &
	    nz);

    *xtpn = tx * *xgsm + ty * *ygsm + tz * *zgsm;
    *ytpn = px * *xgsm + py * *ygsm + pz * *zgsm;
    *ztpn = nx * *xgsm + ny * *ygsm + nz * *zgsm;

    return 0;
} /* t_gsm_to_tpn__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gseq_to_gei__(real *xgsq, real *ygsq, real *zgsq, real 
	*xgei, real *ygei, real *zgei)
{

/* ---------------------------------------------------------------------- */

/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gsq_to_gei: GSEQ-> GEI  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgsq,ygsq,zgsq   cartesian gsq coordinates */
/* *   Output : xgei,ygei,zgei   cartesian gei coordinates */

/* ---------------------------------------------------------------------- */



    *xgei = timp01_1.gs1 * *xgsq + timp10_1.yeigq1 * *ygsq + timp10_1.zeigq1 *
	     *zgsq;
    *ygei = timp01_1.gs2 * *xgsq + timp10_1.yeigq2 * *ygsq + timp10_1.zeigq2 *
	     *zgsq;
    *zgei = timp01_1.gs3 * *xgsq + timp10_1.yeigq3 * *ygsq + timp10_1.zeigq3 *
	     *zgsq;

    return 0;
} /* t_gseq_to_gei__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gseq_to_geo__(real *xgsq, real *ygsq, real *zgsq, real 
	*xgeo, real *ygeo, real *zgeo)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gsq_to_geo: GSEQ-> GEO  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgsq,ygsq,zgsq   cartesian gsq coordinates */
/* *   Output : xgeo,ygeo,zgeo   cartesian geo coordinates */
/* ---------------------------------------------------------------------- */



    *xgeo = timp02_1.ps1 * *xgsq + timp15_1.yeogq1 * *ygsq + timp15_1.zeogq1 *
	     *zgsq;
    *ygeo = timp02_1.ps2 * *xgsq + timp15_1.yeogq2 * *ygsq + timp15_1.zeogq2 *
	     *zgsq;
    *zgeo = timp02_1.ps3 * *xgsq + timp15_1.yeogq3 * *ygsq + timp15_1.zeogq3 *
	     *zgsq;

    return 0;
} /* t_gseq_to_geo__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gseq_to_gse__(real *xgsq, real *ygsq, real *zgsq, real 
	*xgse, real *ygse, real *zgse)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gsq_to_gse: GSEQ-> GSE  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xgsq,ygsq,zgsq   cartesian gsq coordinates */
/* *   Output : xgse,ygse,zgse   cartesian gse coordinates */
/* ---------------------------------------------------------------------- */



    *xgse = *xgsq;
    *ygse = timp11_1.ctetq * *ygsq + timp11_1.stetq * *zgsq;
    *zgse = -timp11_1.stetq * *ygsq + timp11_1.ctetq * *zgsq;

    return 0;
} /* t_gseq_to_gse__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_gseq_to_gsm__(real *xgsq, real *ygsq, real *zgsq, real 
	*xgsm, real *ygsm, real *zgsm)
{
    static real xx, yy, zz;
    extern /* Subroutine */ int t_gse_to_gsm__(real *, real *, real *, real *,
	     real *, real *), t_gseq_to_gse__(real *, real *, real *, real *, 
	    real *, real *);


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_gsq_to_gsm: GSQ -> GSM  system */
/* *   Author : P. Robert, CRPE, 2002 */

/* *   Input  : xgsq,ygsq,zgsq cartesian gsq coordinates */
/* *   Output : xgsm,ygsm,zgsm cartesian gsm coordinates */
/* ---------------------------------------------------------------------- */


    t_gseq_to_gse__(xgsq, ygsq, zgsq, &xx, &yy, &zz);
    t_gse_to_gsm__(&xx, &yy, &zz, xgsm, ygsm, zgsm);

    return 0;
} /* t_gseq_to_gsm__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_mag_to_gei__(real *xmag, real *ymag, real *zmag, real *
	xgei, real *ygei, real *zgei)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_mag_to_gei: MAG -> GEI  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xmag,ymag,zmag cartesian mag coordinates */
/* *   Output : xgei,ygei,zgei cartesian gei coordinates */
/* ---------------------------------------------------------------------- */



    *xgei = timp07_1.xeima1 * *xmag + timp07_1.yeima1 * *ymag + timp01_1.gm1 *
	     *zmag;
    *ygei = timp07_1.xeima2 * *xmag + timp07_1.yeima2 * *ymag + timp01_1.gm2 *
	     *zmag;
    *zgei = timp07_1.xeima3 * *xmag + timp07_1.yeima3 * *ymag + timp01_1.gm3 *
	     *zmag;

    return 0;
} /* t_mag_to_gei__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_mag_to_geo__(real *xmag, real *ymag, real *zmag, real *
	xgeo, real *ygeo, real *zgeo)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_mag_to_geo: MAG -> GEO  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xmag,ymag,zmag   cartesian mag coordinates */
/* *   Output : xgeo,ygeo,zgeo   cartesian geo coordinates */
/* ---------------------------------------------------------------------- */



    *xgeo = timp12_1.xeoma1 * *xmag + timp12_1.yeoma1 * *ymag + timp02_1.gd1 *
	     *zmag;
    *ygeo = timp12_1.xeoma2 * *xmag + timp12_1.yeoma2 * *ymag + timp02_1.gd2 *
	     *zmag;
    *zgeo = timp12_1.xeoma3 * *xmag + timp12_1.yeoma3 * *ymag + timp02_1.gd3 *
	     *zmag;

    return 0;
} /* t_mag_to_geo__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_mag_to_gsm__(real *xmag, real *ymag, real *zmag, real *
	xgsm, real *ygsm, real *zgsm)
{
    static real xx, yy, zz;
    extern /* Subroutine */ int t_mag_to_sm__(real *, real *, real *, real *, 
	    real *, real *), t_sm_to_gsm__(real *, real *, real *, real *, 
	    real *, real *);


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_mag_to_gsm: MAG -> GSM  system */
/* *   Author : P. Robert, CRPE, 2002 */

/* *   Input  : xmag,ymag,zmag cartesian mag coordinates */
/* *   Output : xgsm,ygsm,zgsm cartesian gsm coordinates */
/* ---------------------------------------------------------------------- */


    t_mag_to_sm__(xmag, ymag, zmag, &xx, &yy, &zz);
    t_sm_to_gsm__(&xx, &yy, &zz, xgsm, ygsm, zgsm);

    return 0;
} /* t_mag_to_gsm__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_mag_to_sm__(real *xmag, real *ymag, real *zmag, real *
	xsma, real *ysma, real *zsma)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_mag_to_sma: MAG -> SM   system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xmag,ymag,zmag   cartesian mag coordinates */
/* *   Output : xsma,ysma,zsma   cartesian sma coordinates */
/* ---------------------------------------------------------------------- */



    *xsma = timp11_1.cphi * *xmag - timp11_1.sphi * *ymag;
    *ysma = timp11_1.sphi * *xmag + timp11_1.cphi * *ymag;
    *zsma = *zmag;

    return 0;
} /* t_mag_to_sm__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_sm_to_gei__(real *xsma, real *ysma, real *zsma, real *
	xgei, real *ygei, real *zgei)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_sma_to_gei: SM  -> GEI  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xsma,ysma,zsma   cartesian sma coordinates */
/* *   Output : xgei,ygei,zgei   cartesian gei coordinates */
/* ---------------------------------------------------------------------- */



    *xgei = timp08_1.xeism1 * *xsma + timp08_1.yeism1 * *ysma + timp01_1.gm1 *
	     *zsma;
    *ygei = timp08_1.xeism2 * *xsma + timp08_1.yeism2 * *ysma + timp01_1.gm2 *
	     *zsma;
    *zgei = timp08_1.xeism3 * *xsma + timp08_1.yeism3 * *ysma + timp01_1.gm3 *
	     *zsma;

    return 0;
} /* t_sm_to_gei__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_sm_to_geo__(real *xsma, real *ysma, real *zsma, real *
	xgeo, real *ygeo, real *zgeo)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_sma_to_geo: SM  -> GEO  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xsma,ysma,zsma   cartesian sma coordinates */
/* *   Output : xgeo,ygeo,zgeo   cartesian geo coordinates */
/* ---------------------------------------------------------------------- */



    *xgeo = timp13_1.xeosm1 * *xsma + timp13_1.yeosm1 * *ysma + timp02_1.gd1 *
	     *zsma;
    *ygeo = timp13_1.xeosm2 * *xsma + timp13_1.yeosm2 * *ysma + timp02_1.gd2 *
	     *zsma;
    *zgeo = timp13_1.xeosm3 * *xsma + timp13_1.yeosm3 * *ysma + timp02_1.gd3 *
	     *zsma;

    return 0;
} /* t_sm_to_geo__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_sm_to_gsm__(real *xsma, real *ysma, real *zsma, real *
	xgsm, real *ygsm, real *zgsm)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_sma_to_gsm: SM  -> GSM  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xsma,ysma,zsma   cartesian sma coordinates */
/* *   Output : xgsm,ygsm,zgsm   cartesian gsm coordinates */
/* ---------------------------------------------------------------------- */



    *xgsm = timp11_1.cmu * *xsma + timp11_1.smu * *zsma;
    *ygsm = *ysma;
    *zgsm = -timp11_1.smu * *xsma + timp11_1.cmu * *zsma;

    return 0;
} /* t_sm_to_gsm__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_sm_to_mag__(real *xsma, real *ysma, real *zsma, real *
	xmag, real *ymag, real *zmag)
{

/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_sma_to_mag: SM  -> MAG  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: terms of transformation matrix are given in common */

/* *   Input  : xsma,ysma,zsma   cartesian sma coordinates */
/* *   Output : xmag,ymag,zmag   cartesian mag coordinates */
/* ---------------------------------------------------------------------- */



    *xmag = timp11_1.cphi * *xsma + timp11_1.sphi * *ysma;
    *ymag = -timp11_1.sphi * *xsma + timp11_1.cphi * *ysma;
    *zmag = *zsma;

    return 0;
} /* t_sm_to_mag__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_sph_to_car__(real *r__, real *teta, real *phi, real *x,
	 real *y, real *z__)
{
    /* Builtin functions */
    double sin(doublereal), cos(doublereal);

    /* Local variables */
    static real sq;


/* ---------------------------------------------------------------------- */

/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_sph_to_car: SPH -> CAR  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: none */

/* *   Input  :   r,teta,phi  spherical coordinates (angles in radians) */
/* *   Output :   x,y,z       cartesian coordinates */
/* ---------------------------------------------------------------------- */


    sq = *r__ * sin(*teta);
    *x = sq * cos(*phi);
    *y = sq * sin(*phi);
    *z__ = *r__ * cos(*teta);

    return 0;
} /* t_sph_to_car__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_sr2_to_gse__(real *xsr2, real *ysr2, real *zsr2, real *
	rotx, real *roty, real *rotz, real *xgse, real *ygse, real *zgse)
{
    /* System generated locals */
    real r__1, r__2, r__3;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    static real a, x1, x2, x3, y1, y2, y3, z1, z2, z3, rx, ry, rz, rmod;


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_sr2_to_gse: SR2 -> GSE  system */
/* *   Author : P. Robert, CETP, 2001 */
/* *   Comment: local system, non time dependent */

/* *   Input  : xsr2,ysr2,sr2z cartesian sr2 coordinates */
/*              rotx,roty,rotz cartesian gse coordinates of rotation axis */
/* *   Output : xgse,ygse,zgse cartesian gse coordinates */
/* ---------------------------------------------------------------------- */

/* *** set transform matrix with Spin axis terms */

/* Computing 2nd power */
    r__1 = *rotx;
/* Computing 2nd power */
    r__2 = *roty;
/* Computing 2nd power */
    r__3 = *rotz;
    rmod = sqrt(r__1 * r__1 + r__2 * r__2 + r__3 * r__3);

    rx = *rotx / rmod;
    ry = *roty / rmod;
    rz = *rotz / rmod;

    a = 1.f / sqrt(ry * ry + rz * rz);

    x1 = (ry * ry + rz * rz) * a;
    x2 = -rx * ry * a;
    x3 = -rx * rz * a;

    y1 = 0.f;
    y2 = rz * a;
    y3 = -ry * a;

    z1 = rx;
    z2 = ry;
    z3 = rz;

/* *** tranform the input vector from sr2 to gse */

    *xgse = x1 * *xsr2 + y1 * *ysr2 + z1 * *zsr2;
    *ygse = x2 * *xsr2 + y2 * *ysr2 + z2 * *zsr2;
    *zgse = x3 * *xsr2 + y3 * *ysr2 + z3 * *zsr2;

    return 0;
} /* t_sr2_to_gse__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_sr2_to_mfa__(real *xsr2, real *ysr2, real *zsr2, real *
	bx, real *by, real *bz, real *rox, real *roy, real *roz, real *xm, 
	real *ym, real *zm)
{
    /* System generated locals */
    real r__1, r__2, r__3;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    static real b, b0, xp, yp, rx, ry, rz, zp, sxm, sym, xmag, ymag, zmag, 
	    rmod, bperp, cosphi, sinphi, cospsi, costet, sinpsi, sintet, 
	    smperp;


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_sr2_to_mfa: SR2 -> MFA  system */
/* *   Author : P. Robert, CETP, 2001 */
/* *   Comment: local system, non time dependent */

/* *   Input  : xsr2,ysr2,sr2z cartesian sr2 coordinates */
/*              bx,  by,  bz   cartesian sr2 coordinates of DC mag field */
/*              rox, roy, roz  cartesian gse coordinates of rotation axis */
/* *   Output : xm,  ym,  zm   cartesian mfa coordinates */
/* ---------------------------------------------------------------------- */


/* *** normalise R supposed undependant of time */

/* Computing 2nd power */
    r__1 = *rox;
/* Computing 2nd power */
    r__2 = *roy;
/* Computing 2nd power */
    r__3 = *roz;
    rmod = sqrt(r__1 * r__1 + r__2 * r__2 + r__3 * r__3);

    rx = *rox / rmod;
    ry = *roy / rmod;
    rz = *roz / rmod;

/* *** tranform the vector from sr2 to mfa */

    bperp = sqrt(*bx * *bx + *by * *by);
    b0 = sqrt(*bx * *bx + *by * *by + *bz * *bz);

/* **  first rotation */

    sinphi = *by / bperp;
    cosphi = *bx / bperp;

    xp = cosphi * *xsr2 + sinphi * *ysr2;
    yp = -sinphi * *xsr2 + cosphi * *ysr2;
    zp = *zsr2;

/* **  second rotation */

    sintet = bperp / b0;
    costet = *bz / b0;

    xmag = costet * xp - sintet * zp;
    ymag = yp;
    zmag = sintet * xp + costet * zp;

/* **  third rotation */

    b = sqrt(ry * ry + rz * rz);

    sxm = b * costet * cosphi - rx * sintet;
    sym = -b * sinphi;

    smperp = sqrt(sxm * sxm + sym * sym);

    sinpsi = sym / smperp;
    cospsi = sxm / smperp;

    *xm = cospsi * xmag + sinpsi * ymag;
    *ym = -sinpsi * xmag + cospsi * ymag;
    *zm = zmag;

    return 0;
} /* t_sr2_to_mfa__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_sr2_to_sr__(real *xsr2, real *ysr2, real *spifre, real 
	*spipha, real *deltat, real *xsre, real *ysre)
{
    /* System generated locals */
    real r__1;

    /* Builtin functions */
    double r_mod(real *, real *), sin(doublereal), cos(doublereal);

    /* Local variables */
    static real pi2, phicr, depift, cosphi, sinphi;


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_sr2_to_sre: SR2 -> SRef system */
/* *   Author : P. Robert, CRPE, 2001 */
/* *   Comment: Z component is unchanged (spin axis) */

/* *   Input  : xsr2, ysr2 cartesian sr2 coordinates */
/*              spifre     spin frequency in Hz */
/*              spipha     spin phase in radians, growing with time */
/*                         spipha= positive angle between the xsr axis */
/*                         and the component of the direction of the Sun */
/*                         in the xsr-ysr plane. */
/*              deltaT     (T -To) time (sec.), between the current time */
/*                         and the time where is measured the spin phase. */
/* *   Output : xsre,ysre  cartesian sr coordinates */
/* ---------------------------------------------------------------------- */


    pi2 = 6.2831853999999998f;

    r__1 = pi2 * *spifre * *deltat;
    depift = r_mod(&r__1, &pi2);
    phicr = *spipha - depift;
    sinphi = sin(phicr);
    cosphi = cos(phicr);

    *xsre = cosphi * *xsr2 - sinphi * *ysr2;
    *ysre = sinphi * *xsr2 + cosphi * *ysr2;

    return 0;
} /* t_sr2_to_sr__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_sr_to_sr2__(real *xsre, real *ysre, real *spifre, real 
	*spipha, real *deltat, real *xsr2, real *ysr2)
{
    /* System generated locals */
    real r__1;

    /* Builtin functions */
    double r_mod(real *, real *), sin(doublereal), cos(doublereal);

    /* Local variables */
    static real pi2, phicr, depift, cosphi, sinphi;


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_sre_to_sr2: SRef-> SR2 system */
/* *   Author : P. Robert, CRPE, 2001 */
/* *   Comment: Z component is unchanged (spin axis) */

/* *   Input  : xsre, ysre cartesian sr coordinates */
/*              spifre     spin frequency in Hz */
/*              spipha     spin phase in radians, growing with time */
/*                         spipha= positive angle between the xsr axis */
/*                         and the component of the direction of the Sun */
/*                         in the xsr-ysr plane. */
/*              deltaT     (T -To) time (sec.), between the current time */
/*                         and the time where is measured the spin phase. */
/* *   Output : xsr2,ysr2  cartesian sr coordinates */
/* ---------------------------------------------------------------------- */


    pi2 = 6.2831853999999998f;

    r__1 = pi2 * *spifre * *deltat;
    depift = r_mod(&r__1, &pi2);
    phicr = *spipha - depift;
    sinphi = sin(phicr);
    cosphi = cos(phicr);

    *xsr2 = cosphi * *xsre + sinphi * *ysre;
    *ysr2 = -sinphi * *xsre + cosphi * *ysre;

    return 0;
} /* t_sr_to_sr2__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_vdh_to_geo__(real *xvdh, real *yvdh, real *zvdh, real *
	rlat, real *rlong, real *xgeo, real *ygeo, real *zgeo)
{
    /* System generated locals */
    real r__1, r__2;

    /* Builtin functions */
    double cos(doublereal), sin(doublereal), sqrt(doublereal);

    /* Local variables */
    static real q, d1, d2, d3, h1, h2, h3, r1, r2, r3, v1, v2, v3, q12;


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_vdh_to_geo: VDH -> GEO  system */
/* *   Author : P. Robert, CRPE, 1992 */
/* *   Comment: local system, non time dependent */

/* *   Input  : xvdh,yvdh,zvdh   cartesian vdh coordinates */
/*              rlat,rlong       latitude and longitude of the point */
/*                               of observation (radians) */
/* *   Output : xgeo,ygeo,zgeo   cartesian geo coordinates */
/* ---------------------------------------------------------------------- */


    q = cos(*rlat);
    r1 = q * cos(*rlong);
    r2 = q * sin(*rlong);
    r3 = sin(*rlat);

    v1 = r1;
    v2 = r2;
    v3 = r3;

/* Computing 2nd power */
    r__1 = r1;
/* Computing 2nd power */
    r__2 = r2;
    q12 = sqrt(r__1 * r__1 + r__2 * r__2);

    d1 = -r2 / q12;
    d2 = r1 / q12;
    d3 = 0.f;

    h1 = -r1 * r3 / q12;
    h2 = -r2 * r3 / q12;
    h3 = q12;

    *xgeo = v1 * *xvdh + d1 * *yvdh + h1 * *zvdh;
    *ygeo = v2 * *xvdh + d2 * *yvdh + h2 * *zvdh;
    *zgeo = v3 * *xvdh + d3 * *yvdh + h3 * *zvdh;

    return 0;
} /* t_vdh_to_geo__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_xyz_to_vdh__(real *x, real *y, real *z__, real *a1, 
	real *a2, real *a3, real *v, real *d__, real *h__)
{
    /* Builtin functions */
    double cos(doublereal), sin(doublereal);

    /* Local variables */
    static real c1, c2, c3, s1, s2, s3, a1r, a2r, a3r, pisd;


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_xyz_to_vdh: xyz spinning -> VDH */
/* *   Author : P. Robert, SDev, 2020 */
/* *   Comment: use Euler angles in degrees; VDH is the fixed system. */

/* *   Input : x,y,z cartesian xyz coordinates */
/* *   Output: v,d,h cartesian VDH coordinates */
/* ---------------------------------------------------------------------- */
    pisd = .017453292222222222f;

    a1r = *a1 * pisd;
    a2r = *a2 * pisd;
    a3r = *a3 * pisd;

    c1 = cos(a1r);
    c2 = cos(a2r);
    c3 = cos(a3r);
    s1 = sin(a1r);
    s2 = sin(a2r);
    s3 = sin(a3r);

    *v = (c1 * c3 - s1 * c2 * s3) * *x + (-s1 * c3 - c1 * c2 * s3) * *y + s2 *
	     s3 * *z__;
    *d__ = (c1 * s3 + s1 * c2 * c3) * *x + (-s1 * s3 + c1 * c2 * c3) * *y + 
	    -s2 * c3 * *z__;
    *h__ = s1 * s2 * *x + c1 * s2 * *y + c2 * *z__;

    return 0;
} /* t_xyz_to_vdh__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/* Subroutine */ int t_vdh_to_xyz__(real *v, real *d__, real *h__, real *a1, 
	real *a2, real *a3, real *x, real *y, real *z__)
{
    /* Builtin functions */
    double cos(doublereal), sin(doublereal);

    /* Local variables */
    static real c1, c2, c3, s1, s2, s3, a1r, a2r, a3r, pisd;


/* ---------------------------------------------------------------------- */
/* *   Class  : transform modules of Rocotlib Software */
/* *   Object : transforms_vdh_to_xyz: VDH -> xyz spinning */
/* *   Author : P. Robert, SDev, 2020 */
/* *   Comment: use Euler angles in degrees; VDH is the fixed system. */

/* *   Input  : v,d,h cartesian VDH coordinates */
/* *   Output : x,y,z cartesian xyz coordinates */
/* ---------------------------------------------------------------------- */
    pisd = .017453292222222222f;

    a1r = *a1 * pisd;
    a2r = *a2 * pisd;
    a3r = *a3 * pisd;

    c1 = cos(a1r);
    c2 = cos(a2r);
    c3 = cos(a3r);
    s1 = sin(a1r);
    s2 = sin(a2r);
    s3 = sin(a3r);

    *x = (c1 * c3 - s1 * c2 * s3) * *v + (c1 * s3 + s1 * c2 * c3) * *d__ + s1 
	    * s2 * *h__;
    *y = (-s1 * c3 - c1 * c2 * s3) * *v + (-s1 * s3 + c1 * c2 * c3) * *d__ + 
	    c1 * s2 * *h__;
    *z__ = s2 * s3 * *v + -s2 * c3 * *d__ + c2 * *h__;

    return 0;
} /* t_vdh_to_xyz__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */

/*     Supplements for matrix operations. */
/*     Allows the transformation of an input 3D signal into the */
/*     Minimum variance coordinate (MVA Analysis). */

/*     All codes in this part are extracted of Roproc Software, V 4.5 */
/*     and rewrited properly in f77, with Rocotlib V2.2 conventions. */
/*     P. Robert, LPP , April 2016. */

/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */

/* Subroutine */ int mat_cp_varmin__(integer *ifc, real *vx, real *vy, real *
	vz, integer *n, integer *irep, real *covar, real *lambda, real *
	eigvec)
{
    /* Format strings */
    static char fmt_100[] = "(1x,a)";

    /* Builtin functions */
    integer s_wsfe(cilist *), e_wsfe(void), do_fio(integer *, char *, ftnlen);

    /* Local variables */
    extern /* Subroutine */ int mat_change_coord__(real *, real *, real *, 
	    real *, integer *), mat_cp_covariance__(real *, real *, real *, 
	    integer *, real *), mat_write__(integer *, char *, real *, ftnlen)
	    , mat_write_eigen_vec__(integer *, real *, real *), 
	    mat_diagonalise__(real *, real *, real *), mat_check_ortho__(
	    integer *, real *);

    /* Fortran I/O blocks */
    static cilist io___536 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___537 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___538 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___539 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___540 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___541 = { 0, 0, 0, fmt_100, 0 };




/*     ---------------------------------------------------------------+-- */
/* *   Class  : matrix operation of Rocotlib Software */
/* *   Object : compute variance minimum coordinate of a signal Vx,Vy,Vz */
/* *   Author : P. Robert, CETP, 2001, rev. PR 2016 */
/*     Comment: check orthogonality of the MVA matrix */

/* *   Input  : ifc (unit for writing results) */
/*              Vx(n),Vy(n),Vz(n) input signal */
/*              n number of point of the signal */
/*              irep=1 : passe input vector in MVA coordinates */

/* *   Output : covar covariance matrix */
/*              lamda(3), eigvev(3,3) eigen values and eigen vectors */
/*              results are also writted on unit ifc */
/*     ---------------------------------------------------------------+-- */

    /* Parameter adjustments */
    --vz;
    --vy;
    --vx;
    covar -= 4;
    --lambda;
    eigvec -= 4;

    /* Function Body */
    io___536.ciunit = *ifc;
    s_wsfe(&io___536);
    e_wsfe();
    io___537.ciunit = *ifc;
    s_wsfe(&io___537);
    do_fio(&c__1, "------------------------------------------------", (ftnlen)
	    48);
    e_wsfe();
    io___538.ciunit = *ifc;
    s_wsfe(&io___538);
    do_fio(&c__1, "Compute Minimum Variance Analaysis coord. system", (ftnlen)
	    48);
    e_wsfe();
    io___539.ciunit = *ifc;
    s_wsfe(&io___539);
    do_fio(&c__1, "------------------------------------------------", (ftnlen)
	    48);
    e_wsfe();

/* *** compute covariance matrix */

    mat_cp_covariance__(&vx[1], &vy[1], &vz[1], n, &covar[4]);
    mat_write__(ifc, "covariance matrix of input signal:", &covar[4], (ftnlen)
	    34);

/* *** diagonalisation of covariance matrix */

    mat_diagonalise__(&covar[4], &lambda[1], &eigvec[4]);
    mat_write__(ifc, "covariance matrix diagonalized:", &covar[4], (ftnlen)31)
	    ;
    mat_write__(ifc, "eigen vectors matrix:", &eigvec[4], (ftnlen)21);

/* *** check orthogonality and direct sens of the 3 vectors */

    mat_check_ortho__(ifc, &eigvec[4]);

/* *** print eigen vectors and eigen values */

    mat_write_eigen_vec__(ifc, &lambda[1], &eigvec[4]);

/* *** transform input signal in MVA coordinates, ie. eigen vectors */

    if (*irep != 0) {
	mat_change_coord__(&eigvec[4], &vx[1], &vy[1], &vz[1], n);
	io___540.ciunit = *ifc;
	s_wsfe(&io___540);
	e_wsfe();
	io___541.ciunit = *ifc;
	s_wsfe(&io___541);
	do_fio(&c__1, "input signal is passed into MVA coordinates", (ftnlen)
		43);
	e_wsfe();
    }


    return 0;
} /* mat_cp_varmin__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */

/* Subroutine */ int mat_cp_covariance__(real *vx, real *vy, real *vz, 
	integer *n, real *covar)
{
    /* System generated locals */
    integer i__1;
    real r__1;
    doublereal d__1;

    /* Local variables */
    static integer k;
    static doublereal sx, sy, sz, sx2, sy2, sz2, sxy, szx, syz;


/*     ---------------------------------------------------------------+-- */
/* *   Class  : matrix operation of Rocotlib Software */
/* *   Object : compute covariance matrix for a vector series V(n) */
/* *   Author : P. Robert, CETP, 2001, rev. PR 2016 */

/* *   Input  : Vx(n),Vy(n),Vz(n) vector series */
/* *   Output : covar(3,3) */
/*     ---------------------------------------------------------------+-- */


/* *   set summation to zero */

    /* Parameter adjustments */
    --vz;
    --vy;
    --vx;
    covar -= 4;

    /* Function Body */
    sx = 0.;
    sy = 0.;
    sz = 0.;
    sx2 = 0.;
    sy2 = 0.;
    sz2 = 0.;
    sxy = 0.;
    syz = 0.;
    szx = 0.;

/* *   components summation and square components summation */

    i__1 = *n;
    for (k = 1; k <= i__1; ++k) {

	sx += (doublereal) vx[k];
	sy += (doublereal) vy[k];
	sz += (doublereal) vz[k];

/* Computing 2nd power */
	r__1 = vx[k];
	sx2 += (doublereal) (r__1 * r__1);
/* Computing 2nd power */
	r__1 = vy[k];
	sy2 += (doublereal) (r__1 * r__1);
/* Computing 2nd power */
	r__1 = vz[k];
	sz2 += (doublereal) (r__1 * r__1);

	sxy += (doublereal) (vx[k] * vy[k]);
	syz += (doublereal) (vy[k] * vz[k]);
	szx += (doublereal) (vz[k] * vx[k]);

    }

/* *   average values */

    sx /= (doublereal) (*n);
    sy /= (doublereal) (*n);
    sz /= (doublereal) (*n);

    sx2 /= (doublereal) (*n);
    sy2 /= (doublereal) (*n);
    sz2 /= (doublereal) (*n);

    sxy /= (doublereal) (*n);
    syz /= (doublereal) (*n);
    szx /= (doublereal) (*n);

/* *   variance set to diagonals terms */

/* Computing 2nd power */
    d__1 = sx;
    covar[4] = (real) (sx2 - d__1 * d__1);
/* Computing 2nd power */
    d__1 = sy;
    covar[8] = (real) (sy2 - d__1 * d__1);
/* Computing 2nd power */
    d__1 = sz;
    covar[12] = (real) (sz2 - d__1 * d__1);

/* *   covariances set to semi \diagonal terms */

    covar[5] = (real) (sxy - sx * sy);
    covar[9] = (real) (syz - sy * sz);
    covar[6] = (real) (szx - sz * sx);

/* *   second half triangle */

    covar[7] = covar[5];
    covar[10] = covar[6];
    covar[11] = covar[9];

    return 0;
} /* mat_cp_covariance__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */

/* Subroutine */ int mat_diagonalise__(real *mat, real *lambda, real *eigvec)
{
    extern /* Subroutine */ int mat_cp_eigen_vec__(real *, real *, real *);
    static integer i__, j, k;
    extern /* Subroutine */ int mat_normalize_vec__(real *);
    static real det, dint;
    extern /* Subroutine */ int mat_cp_determin__(real *, real *);



/*     ---------------------------------------------------------------+-- */
/* *   Class  : matrix operation of Rocotlib Software */
/* *   Object : diagonalise the given matrix mat(3,3) */
/* *   Author : P. Robert, CETP, 2001, rev. PR 2016 */

/* *   Input  : real mat(3,3) */
/* *   Output : lambda(3)   eigen values */
/*              eigvec(3,3) eigen vectors normalised to 1. */
/*     ---------------------------------------------------------------+-- */

/*     compute eigen vectors and eigen values of real mat(3,3) */

    /* Parameter adjustments */
    eigvec -= 4;
    --lambda;
    mat -= 4;

    /* Function Body */
    mat_cp_eigen_vec__(&mat[4], &lambda[1], &eigvec[4]);

/*     normalise to 1 eigen vectors */
    mat_normalize_vec__(&eigvec[4]);
/* *   set positive direction for \diag */

    if (eigvec[6] < 0.f) {
	eigvec[4] = -eigvec[4];
	eigvec[5] = -eigvec[5];
	eigvec[6] = -eigvec[6];
    }
    if (eigvec[10] < 0.f) {
	eigvec[10] = -eigvec[10];
	eigvec[11] = -eigvec[11];
	eigvec[12] = -eigvec[12];
    }

/* *   sort eigen vector with eigen value (z=min) */

    for (k = 1; k <= 4; ++k) {
	i__ = k;
	if (k > 2) {
	    i__ = k - 2;
	}
	if (lambda[i__] < lambda[i__ + 1]) {
	    dint = lambda[i__];
	    lambda[i__] = lambda[i__ + 1];
	    lambda[i__ + 1] = dint;
	    for (j = 1; j <= 3; ++j) {
		dint = eigvec[j + i__ * 3];
		eigvec[j + i__ * 3] = eigvec[j + (i__ + 1) * 3];
		eigvec[j + (i__ + 1) * 3] = dint;
	    }
	}
    }

/* *   determinant computation: */

    mat_cp_determin__(&eigvec[4], &det);

    if (det < 0.f) {
	eigvec[7] = -eigvec[7];
	eigvec[8] = -eigvec[8];
	eigvec[9] = -eigvec[9];
    }


/* *   modif P.R. 2004: the vector corresponding to lambda min has z >0 */

    if (eigvec[12] < 0.f) {
	eigvec[7] = -eigvec[7];
	eigvec[8] = -eigvec[8];
	eigvec[9] = -eigvec[9];
	eigvec[10] = -eigvec[10];
	eigvec[11] = -eigvec[11];
	eigvec[12] = -eigvec[12];
    }

    return 0;
} /* mat_diagonalise__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */

/* Subroutine */ int mat_check_ortho__(integer *ifc, real *mat)
{
    /* Format strings */
    static char fmt_100[] = "(3(1x,a,1pe14.5))";
    static char fmt_200[] = "(1x,a,3(1pe16.5))";

    /* Builtin functions */
    integer s_wsfe(cilist *), e_wsfe(void), do_fio(integer *, char *, ftnlen);

    /* Local variables */
    static real v1x, v1y, v1z, v2x, v2y, v2z, v3x, v3y, v3z, v1v2, v3v1, v2v3,
	     v1cv2x, v1cv2y, v1cv2z, v2cv3x, v2cv3y, v2cv3z, v3cv1x, v3cv1y, 
	    v3cv1z;

    /* Fortran I/O blocks */
    static cilist io___566 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___567 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___568 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___569 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___570 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___574 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___575 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___576 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___577 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___578 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___579 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___580 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___590 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___591 = { 0, 0, 0, fmt_200, 0 };
    static cilist io___592 = { 0, 0, 0, fmt_200, 0 };
    static cilist io___593 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___594 = { 0, 0, 0, fmt_200, 0 };
    static cilist io___595 = { 0, 0, 0, fmt_200, 0 };
    static cilist io___596 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___597 = { 0, 0, 0, fmt_200, 0 };
    static cilist io___598 = { 0, 0, 0, fmt_200, 0 };



/*     ---------------------------------------------------------------+-- */
/* *   Class  : matrix operation of Rocotlib Software */
/* *   Object : check orthogonality of matrix components */
/* *   Author : P. Robert, CETP, 2001, rev. PR 2016 */

/* *   Input  : ifc (unit for writing results), real mat(3,3) */
/* *   Output : writing result on unit ifc */
/*     ---------------------------------------------------------------+-- */


    /* Parameter adjustments */
    mat -= 4;

    /* Function Body */
    v1x = mat[4];
    v1y = mat[5];
    v1z = mat[6];

    v2x = mat[7];
    v2y = mat[8];
    v2z = mat[9];

    v3x = mat[10];
    v3y = mat[11];
    v3z = mat[12];

    io___566.ciunit = *ifc;
    s_wsfe(&io___566);
    e_wsfe();
    io___567.ciunit = *ifc;
    s_wsfe(&io___567);
    do_fio(&c__1, "Check orthogonality of given matrix:", (ftnlen)36);
    e_wsfe();
    io___568.ciunit = *ifc;
    s_wsfe(&io___568);
    do_fio(&c__1, "----------------------------------- ", (ftnlen)36);
    e_wsfe();
    io___569.ciunit = *ifc;
    s_wsfe(&io___569);
    e_wsfe();

    io___570.ciunit = *ifc;
    s_wsfe(&io___570);
    do_fio(&c__1, "1) dot product of any two rows or any two colums must be "
	    "equal to zero:", (ftnlen)71);
    e_wsfe();
    v1v2 = v1x * v2x + v1y * v2y + v1z * v2z;
    v2v3 = v2x * v3x + v2y * v3y + v2z * v3z;
    v3v1 = v3x * v1x + v3y * v1y + v3z * v1z;

    io___574.ciunit = *ifc;
    s_wsfe(&io___574);
    e_wsfe();
    io___575.ciunit = *ifc;
    s_wsfe(&io___575);
    do_fio(&c__1, "V1.V2 =", (ftnlen)7);
    do_fio(&c__1, (char *)&v1v2, (ftnlen)sizeof(real));
    e_wsfe();
    io___576.ciunit = *ifc;
    s_wsfe(&io___576);
    do_fio(&c__1, "V2.V3 =", (ftnlen)7);
    do_fio(&c__1, (char *)&v2v3, (ftnlen)sizeof(real));
    e_wsfe();
    io___577.ciunit = *ifc;
    s_wsfe(&io___577);
    do_fio(&c__1, "V3.V1 =", (ftnlen)7);
    do_fio(&c__1, (char *)&v3v1, (ftnlen)sizeof(real));
    e_wsfe();

    io___578.ciunit = *ifc;
    s_wsfe(&io___578);
    e_wsfe();
    io___579.ciunit = *ifc;
    s_wsfe(&io___579);
    do_fio(&c__1, "2) cross product of any two rows or colums must be equal "
	    "to the third ", (ftnlen)70);
    e_wsfe();
    io___580.ciunit = *ifc;
    s_wsfe(&io___580);
    do_fio(&c__1, "   row or column or its negative):", (ftnlen)34);
    e_wsfe();

/* *   v1 X v2 */

    v1cv2x = v1y * v2z - v1z * v2y;
    v1cv2y = v1z * v2x - v1x * v2z;
    v1cv2z = v1x * v2y - v1y * v2x;

/* *   v2 X v3 */

    v2cv3x = v2y * v3z - v2z * v3y;
    v2cv3y = v2z * v3x - v2x * v3z;
    v2cv3z = v2x * v3y - v2y * v3x;

/* *   v3 X v1 */

    v3cv1x = v3y * v1z - v3z * v1y;
    v3cv1y = v3z * v1x - v3x * v1z;
    v3cv1z = v3x * v1y - v3y * v1x;

    io___590.ciunit = *ifc;
    s_wsfe(&io___590);
    e_wsfe();
    io___591.ciunit = *ifc;
    s_wsfe(&io___591);
    do_fio(&c__1, "V1XV2 =", (ftnlen)7);
    do_fio(&c__1, (char *)&v1cv2x, (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&v1cv2y, (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&v1cv2z, (ftnlen)sizeof(real));
    e_wsfe();
    io___592.ciunit = *ifc;
    s_wsfe(&io___592);
    do_fio(&c__1, "   V3 =", (ftnlen)7);
    do_fio(&c__1, (char *)&v3x, (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&v3y, (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&v3z, (ftnlen)sizeof(real));
    e_wsfe();

    io___593.ciunit = *ifc;
    s_wsfe(&io___593);
    e_wsfe();
    io___594.ciunit = *ifc;
    s_wsfe(&io___594);
    do_fio(&c__1, "V2XV3 =", (ftnlen)7);
    do_fio(&c__1, (char *)&v2cv3x, (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&v2cv3y, (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&v2cv3z, (ftnlen)sizeof(real));
    e_wsfe();
    io___595.ciunit = *ifc;
    s_wsfe(&io___595);
    do_fio(&c__1, "   V1 =", (ftnlen)7);
    do_fio(&c__1, (char *)&v1x, (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&v1y, (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&v1z, (ftnlen)sizeof(real));
    e_wsfe();

    io___596.ciunit = *ifc;
    s_wsfe(&io___596);
    e_wsfe();
    io___597.ciunit = *ifc;
    s_wsfe(&io___597);
    do_fio(&c__1, "V3XV1 =", (ftnlen)7);
    do_fio(&c__1, (char *)&v3cv1x, (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&v3cv1y, (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&v3cv1z, (ftnlen)sizeof(real));
    e_wsfe();
    io___598.ciunit = *ifc;
    s_wsfe(&io___598);
    do_fio(&c__1, "   V2 =", (ftnlen)7);
    do_fio(&c__1, (char *)&v2x, (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&v2y, (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&v2z, (ftnlen)sizeof(real));
    e_wsfe();


    return 0;
} /* mat_check_ortho__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */

/* Subroutine */ int mat_cp_determin__(real *mat, real *det)
{

/*     ---------------------------------------------------------------+-- */
/* *   Class  : matrix operation of Rocotlib Software */
/* *   Object : compute determinant of the given matrix */
/* *   Author : P. Robert, CETP, 2001, rev. PR 2016 */

/* *   Input  : real mat(3,3) */
/* *   Output : det */
/*     ---------------------------------------------------------------+-- */


    /* Parameter adjustments */
    mat -= 4;

    /* Function Body */
    *det = mat[4] * mat[8] * mat[12] + mat[7] * mat[11] * mat[6];
    *det = *det + mat[5] * mat[9] * mat[10] - mat[6] * mat[8] * mat[10];
    *det = *det - mat[4] * mat[9] * mat[11] - mat[5] * mat[7] * mat[12];

    return 0;
} /* mat_cp_determin__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */

/* Subroutine */ int mat_cp_eigen_vec__(real *mat, real *lambda, real *eigvec)
{
    /* System generated locals */
    integer i__1;
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);
    /* Subroutine */ int s_stop(char *, ftnlen);
    double r_sign(real *, real *);

    /* Local variables */
    static real b, c__, e[3], f, g, h__;
    static integer i__, j, k, l, m;
    static real p, r__, s, dd, rr[9]	/* was [3][3] */;
    extern /* Subroutine */ int mat_cp_pythag_func__(real *, real *, real *), 
	    mat_product__(real *, real *, real *);
    static real epsi;
    static integer iter;
    static real signe;


/*     ---------------------------------------------------------------+-- */
/* *   Class  : matrix operation of Rocotlib Software */
/* *   Object : compute eigen vectors and eigen values of real mat(3,3) */
/* *   Author : unknown, CETP, 2001, rev. PR 2016 */
/* *   Comment: mat(3,3) must be real and symmetrical; */
/*              Method used is Householder. */

/* *   Input  : real mat(3,3) */
/* *   Output : lambda(3)   eigen values */
/*              eigvec(3,3) eigen vectors */
/*     ---------------------------------------------------------------+-- */


/* *   set eigen vectors to unity matrix */

    /* Parameter adjustments */
    eigvec -= 4;
    --lambda;
    mat -= 4;

    /* Function Body */
    for (i__ = 1; i__ <= 3; ++i__) {
	for (j = 1; j <= 3; ++j) {
	    eigvec[i__ + j * 3] = 0.f;
	}
	eigvec[i__ + i__ * 3] = 1.f;
    }

/*     set eigen values */

    lambda[1] = mat[10];
    lambda[2] = mat[11];

    signe = 1.f;
    if (lambda[2] < 0.f) {
	signe = -1.f;
    }
/* Computing 2nd power */
    r__1 = lambda[1];
/* Computing 2nd power */
    r__2 = lambda[2];
    lambda[2] += signe * sqrt(r__1 * r__1 + r__2 * r__2);
    lambda[3] = 0.f;

/* Computing 2nd power */
    r__1 = lambda[1];
/* Computing 2nd power */
    r__2 = lambda[2];
    h__ = (r__1 * r__1 + r__2 * r__2) / 2.f;

    epsi = 1e-30f;
    if (dabs(h__) > epsi) {

/*        determination of the Householder matrix (results in  eigvec). */

	for (i__ = 1; i__ <= 3; ++i__) {
	    for (j = 1; j <= 3; ++j) {
		eigvec[i__ + j * 3] -= lambda[i__] * lambda[j] / h__;
	    }
	}

/*        tridiagonalisation of mat matrix */

	mat_product__(&eigvec[4], &mat[4], rr);
	mat_product__(rr, &eigvec[4], &mat[4]);

    }
/*     set eigen values to diagonal terms */

    for (i__ = 1; i__ <= 3; ++i__) {
	lambda[i__] = mat[i__ + i__ * 3];
    }

    for (i__ = 1; i__ <= 2; ++i__) {
	e[i__ - 1] = mat[i__ + 1 + i__ * 3];
    }
    e[2] = 0.f;

/* *   search for eigen values (max iteration = 30) */

    for (l = 1; l <= 3; ++l) {
	iter = 0;
L1:
	for (m = l; m <= 2; ++m) {
	    dd = (r__1 = lambda[m], dabs(r__1)) + (r__2 = lambda[m + 1], dabs(
		    r__2));
/* PR        if (abs(e(m))+dd.eq.dd) goto 2 */
	    if ((r__1 = e[m - 1], dabs(r__1)) <= dabs(dd) * 1e-6f) {
		goto L2;
	    }
	}
	m = 3;
L2:
	if (m != l) {

	    if (iter == 30) {
		s_stop("*** Rocotlib/mat_cp_eigen_vec: ABORTED ! TOO MANY IT"
			"ERATIONS", (ftnlen)60);
	    }
	    ++iter;
	    g = (lambda[l + 1] - lambda[l]) / (e[l - 1] * 2.f);
	    mat_cp_pythag_func__(&g, &c_b28, &r__);
	    g = lambda[m] - lambda[l] + e[l - 1] / (g + r_sign(&r__, &g));
	    s = 1.f;
	    c__ = 1.f;
	    p = 0.f;
	    i__1 = l;
	    for (i__ = m - 1; i__ >= i__1; --i__) {
		f = s * e[i__ - 1];
		b = c__ * e[i__ - 1];
		mat_cp_pythag_func__(&f, &g, &r__);
		e[i__] = r__;
		if (dabs(r__) < epsi) {
		    lambda[i__ + 1] -= p;
		    e[m - 1] = 0.f;
		    goto L1;
		}
		s = f / r__;
		c__ = g / r__;
		g = lambda[i__ + 1] - p;
		r__ = (lambda[i__] - g) * s + c__ * 2.f * b;
		p = s * r__;
		lambda[i__ + 1] = g + p;
		g = c__ * r__ - b;

		for (k = 1; k <= 3; ++k) {
		    f = eigvec[k + (i__ + 1) * 3];
		    eigvec[k + (i__ + 1) * 3] = s * eigvec[k + i__ * 3] + c__ 
			    * f;
		    eigvec[k + i__ * 3] = c__ * eigvec[k + i__ * 3] - s * f;
		}

	    }
	    lambda[l] -= p;
	    e[l - 1] = g;
	    e[m - 1] = 0.f;
	    goto L1;

	}
    }

/* *   modif PR  sep 11 2001 to load  mat with the result of the diag. */

    for (i__ = 1; i__ <= 3; ++i__) {
	mat[i__ + i__ * 3] = lambda[i__];
    }

    for (i__ = 1; i__ <= 2; ++i__) {
	mat[i__ + 1 + i__ * 3] = e[i__ - 1];
	mat[i__ + (i__ + 1) * 3] = e[i__ - 1];
    }

    mat[10] = e[2];
    mat[6] = e[2];

    return 0;
} /* mat_cp_eigen_vec__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */

/* Subroutine */ int mat_cp_pythag_func__(real *a, real *b, real *fpyth)
{
    /* System generated locals */
    real r__1;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    static real absa, absb, epsi;


/*     ---------------------------------------------------------------+-- */
/* *   Class  : matrix operation of Rocotlib Software */
/* *   Object : Pythagore function of two real (used by mat_cp_eigen_vec) */
/* *   Author : unknown, CETP, 2001, rev. PR 2016 */

/* *   Input  : a,b */
/* *   Output : fpyth */
/*     ---------------------------------------------------------------+-- */

    absa = dabs(*a);
    absb = dabs(*b);

    epsi = 1e-37f;
    if (absa > absb) {
/* Computing 2nd power */
	r__1 = absb / absa;
	*fpyth = absa * sqrt(r__1 * r__1 + 1.f);
    } else {
	if (absb < epsi) {
	    *fpyth = 0.f;
	} else {
/* Computing 2nd power */
	    r__1 = absa / absb;
	    *fpyth = absb * sqrt(r__1 * r__1 + 1.f);
	}
    }

    return 0;
} /* mat_cp_pythag_func__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */

/* Subroutine */ int mat_normalize_vec__(real *mat)
{
    /* Builtin functions */
    double sqrt(doublereal);
    integer s_wsle(cilist *), do_lio(integer *, integer *, char *, ftnlen), 
	    e_wsle(void);

    /* Local variables */
    static integer i__, j;
    static real epsi, matmod;

    /* Fortran I/O blocks */
    static cilist io___625 = { 0, 6, 0, 0, 0 };



/*     ---------------------------------------------------------------+-- */
/* *   Class  : matrix operation of Rocotlib Software */
/* *   Object : normalize to 1. the vectors of the input matrix */
/* *   Author : P. Robert, CETP, 2001, rev. PR 2016 */

/* *   Input  : real mat(3,3) */
/* *   Output : real mat(3,3) with vectors normalized to 1. */
/*     ---------------------------------------------------------------+-- */


    /* Parameter adjustments */
    mat -= 4;

    /* Function Body */
    epsi = 1e-37f;

    for (j = 1; j <= 3; ++j) {
	matmod = 0.f;
	for (i__ = 1; i__ <= 3; ++i__) {
	    matmod += mat[i__ + j * 3] * mat[i__ + j * 3];
	}
	for (i__ = 1; i__ <= 3; ++i__) {
	    if (dabs(matmod) > epsi) {
		mat[i__ + j * 3] /= sqrt(matmod);
	    } else {
		s_wsle(&io___625);
		do_lio(&c__9, &c__1, "*** Rocotlib/mat_normalize_vec: module"
			" is = 0", (ftnlen)45);
		e_wsle();
	    }
	}
    }

    return 0;
} /* mat_normalize_vec__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */

/* Subroutine */ int mat_product__(real *mat1, real *mat2, real *mat3)
{
    static integer i__, j, k;


/*     ---------------------------------------------------------------+-- */
/* *   Class  : matrix operation of Rocotlib Software */
/* *   Object : matrix product of two given matrix of dim. 3 */
/* *   Author : P. Robert, CETP, 2001, rev. PR 2016 */

/* *   Input  : n, mat1(3,3), mat2(3,3) */
/* *   Output : mat3(3,3) */
/*     ---------------------------------------------------------------+-- */


    /* Parameter adjustments */
    mat3 -= 4;
    mat2 -= 4;
    mat1 -= 4;

    /* Function Body */
    for (i__ = 1; i__ <= 3; ++i__) {
	for (j = 1; j <= 3; ++j) {
	    mat3[i__ + j * 3] = 0.f;
	    for (k = 1; k <= 3; ++k) {
		mat3[i__ + j * 3] += mat1[i__ + k * 3] * mat2[k + j * 3];
	    }
	}
    }

    return 0;
} /* mat_product__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */

/* Subroutine */ int mat_somme__(real *mat1, real *mat2, real *mat3)
{
    static integer i__, j;


/*     ---------------------------------------------------------------+-- */
/* *   Class  : matrix operation of Rocotlib Software */
/* *   Object : matrix somme of two given matrix of dim. 3 */
/* *   Author : P. Robert, LPP , 2016 */

/* *   Input  : n, mat1(3,3), mat2(3,3) */
/* *   Output : mat3(3,3) */
/*     ---------------------------------------------------------------+-- */


    /* Parameter adjustments */
    mat3 -= 4;
    mat2 -= 4;
    mat1 -= 4;

    /* Function Body */
    for (i__ = 1; i__ <= 3; ++i__) {
	for (j = 1; j <= 3; ++j) {
	    mat3[i__ + j * 3] = mat1[i__ + j * 3] + mat2[i__ + j * 3];
	}
    }
    return 0;
} /* mat_somme__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */

/* Subroutine */ int mat_diff__(real *mat1, real *mat2, real *mat3)
{
    static integer i__, j;


/*     ---------------------------------------------------------------+-- */
/* *   Class  : matrix operation of Rocotlib Software */
/* *   Object : matrix difference of two given matrix */
/* *   Author : P. Robert, LPP , 2016 */

/* *   Input  : n, mat1(3,3), mat2(3,3) */
/* *   Output : mat3(3,3) */
/*     ---------------------------------------------------------------+-- */


    /* Parameter adjustments */
    mat3 -= 4;
    mat2 -= 4;
    mat1 -= 4;

    /* Function Body */
    for (i__ = 1; i__ <= 3; ++i__) {
	for (j = 1; j <= 3; ++j) {
	    mat3[i__ + j * 3] = mat1[i__ + j * 3] - mat2[i__ + j * 3];
	}
    }
    return 0;
} /* mat_diff__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */

/* Subroutine */ int mat_transpose__(real *mat)
{
    static real r12, r13, r23;


/*     ---------------------------------------------------------------+-- */
/* *   Class  : matrix operation of Rocotlib Software */
/* *   Object : transpose input matrix */
/* *   Author : P. Robert, CETP, 2001, rev. PR 2016 */

/* *   Input  : real mat(3,3) */
/* *   Output : real mat(3,3) transposed */
/*     ---------------------------------------------------------------+-- */


    /* Parameter adjustments */
    mat -= 4;

    /* Function Body */
    r12 = mat[7];
    r13 = mat[10];
    r23 = mat[11];

    mat[7] = mat[5];
    mat[10] = mat[6];
    mat[11] = mat[9];

    mat[5] = r12;
    mat[6] = r13;
    mat[9] = r23;

    return 0;
} /* mat_transpose__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */

/* Subroutine */ int mat_change_coord__(real *mat, real *vx, real *vy, real *
	vz, integer *n)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static integer i__;
    static real vxr, vyr, vzr;


/*     ---------------------------------------------------------------+-- */
/* *   Class  : matrix operation of Rocotlib Software */
/* *   Object : change coordinate of a vector serie with a given matrix */
/* *   Author : P. Robert, CETP, 2001, rev. PR 2016 */
/* *   Comment: compute V(n)= mat*V(n) */

/* *   Input  : ifc (unit for writing results), real mat(3,3) */
/* *   Output : writing result on unit ifc */
/*     ---------------------------------------------------------------+-- */


    /* Parameter adjustments */
    mat -= 4;
    --vz;
    --vy;
    --vx;

    /* Function Body */
    i__1 = *n;
    for (i__ = 1; i__ <= i__1; ++i__) {

	vxr = mat[4] * vx[i__] + mat[5] * vy[i__] + mat[6] * vz[i__];
	vyr = mat[7] * vx[i__] + mat[8] * vy[i__] + mat[9] * vz[i__];
	vzr = mat[10] * vx[i__] + mat[11] * vy[i__] + mat[12] * vz[i__];

	vx[i__] = vxr;
	vy[i__] = vyr;
	vz[i__] = vzr;

    }

    return 0;
} /* mat_change_coord__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */

/* Subroutine */ int mat_write__(integer *ifc, char *com, real *mat, ftnlen 
	com_len)
{
    /* Format strings */
    static char fmt_100[] = "(1x,a)";
    static char fmt_200[] = "(11x,3(1pe15.5))";

    /* Builtin functions */
    integer s_wsfe(cilist *), e_wsfe(void), do_fio(integer *, char *, ftnlen);

    /* Local variables */
    static integer j;

    /* Fortran I/O blocks */
    static cilist io___640 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___641 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___642 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___643 = { 0, 0, 0, fmt_200, 0 };
    static cilist io___645 = { 0, 0, 0, fmt_200, 0 };
    static cilist io___646 = { 0, 0, 0, fmt_200, 0 };



/*     ---------------------------------------------------------------+-- */
/* *   Class  : matrix operation of Rocotlib Software */
/* *   Object : print on ifc unit mat(3,3) with a comment */
/* *   Author : P. Robert, CETP, 2001, rev. PR 2016 */

/* *   Input  : ifc (unit for writing results), com, real mat(3,3) */
/* *   Output : writing result on unit ifc */
/*     ---------------------------------------------------------------+-- */


    /* Parameter adjustments */
    mat -= 4;

    /* Function Body */
    io___640.ciunit = *ifc;
    s_wsfe(&io___640);
    e_wsfe();
    io___641.ciunit = *ifc;
    s_wsfe(&io___641);
    do_fio(&c__1, com, com_len);
    e_wsfe();
    io___642.ciunit = *ifc;
    s_wsfe(&io___642);
    e_wsfe();
    io___643.ciunit = *ifc;
    s_wsfe(&io___643);
    for (j = 1; j <= 3; ++j) {
	do_fio(&c__1, (char *)&mat[j * 3 + 1], (ftnlen)sizeof(real));
    }
    e_wsfe();
    io___645.ciunit = *ifc;
    s_wsfe(&io___645);
    for (j = 1; j <= 3; ++j) {
	do_fio(&c__1, (char *)&mat[j * 3 + 2], (ftnlen)sizeof(real));
    }
    e_wsfe();
    io___646.ciunit = *ifc;
    s_wsfe(&io___646);
    for (j = 1; j <= 3; ++j) {
	do_fio(&c__1, (char *)&mat[j * 3 + 3], (ftnlen)sizeof(real));
    }
    e_wsfe();


    return 0;
} /* mat_write__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */

/* Subroutine */ int mat_write_eigen_vec__(integer *ifc, real *lambda, real *
	mat)
{
    /* Format strings */
    static char fmt_100[] = "(1x,a,3f15.4)";
    static char fmt_110[] = "(1x,a,3a15)";
    static char fmt_120[] = "(1x,a,3(1pe15.4))";

    /* Builtin functions */
    integer s_wsfe(cilist *), e_wsfe(void), do_fio(integer *, char *, ftnlen);

    /* Local variables */
    static integer i__;
    static real r__[3], dpi, phi[3], teta, phir;
    extern /* Subroutine */ int t_car_to_sph__(real *, real *, real *, real *,
	     real *, real *);
    static real theta[3];

    /* Fortran I/O blocks */
    static cilist io___654 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___655 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___656 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___657 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___658 = { 0, 0, 0, fmt_110, 0 };
    static cilist io___659 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___660 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___661 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___662 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___663 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___664 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___665 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___666 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___667 = { 0, 0, 0, fmt_120, 0 };



/*     ---------------------------------------------------------------+-- */
/* *   Class  : matrix operation of Rocotlib Software */
/* *   Object : print on ifc unit eigen values & vectors of mat(3,3) */
/* *   Author : P. Robert, CETP, 2001, rev. PR 2016 */

/* *   Input  : ifc (unit for writing results), lambda(3), real mat(3,3) */
/* *   Output : writing result on unit ifc */
/*     ---------------------------------------------------------------+-- */


    /* Parameter adjustments */
    mat -= 4;
    --lambda;

    /* Function Body */
    dpi = 57.295827908797776f;

    for (i__ = 1; i__ <= 3; ++i__) {
	t_car_to_sph__(&mat[i__ * 3 + 1], &mat[i__ * 3 + 2], &mat[i__ * 3 + 3]
		, &r__[i__ - 1], &teta, &phir);
	theta[i__ - 1] = teta * dpi;
	phi[i__ - 1] = phir * dpi;
    }
    io___654.ciunit = *ifc;
    s_wsfe(&io___654);
    e_wsfe();
    io___655.ciunit = *ifc;
    s_wsfe(&io___655);
    do_fio(&c__1, "Eigen vectors and eigen values", (ftnlen)30);
    e_wsfe();
    io___656.ciunit = *ifc;
    s_wsfe(&io___656);
    do_fio(&c__1, "------------------------------", (ftnlen)30);
    e_wsfe();
    io___657.ciunit = *ifc;
    s_wsfe(&io___657);
    e_wsfe();
    io___658.ciunit = *ifc;
    s_wsfe(&io___658);
    do_fio(&c__1, "   ", (ftnlen)3);
    do_fio(&c__1, "V1", (ftnlen)2);
    do_fio(&c__1, "V2", (ftnlen)2);
    do_fio(&c__1, "V3", (ftnlen)2);
    e_wsfe();
    io___659.ciunit = *ifc;
    s_wsfe(&io___659);
    do_fio(&c__1, "x     ", (ftnlen)6);
    do_fio(&c__1, (char *)&mat[4], (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&mat[7], (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&mat[10], (ftnlen)sizeof(real));
    e_wsfe();
    io___660.ciunit = *ifc;
    s_wsfe(&io___660);
    do_fio(&c__1, "y     ", (ftnlen)6);
    do_fio(&c__1, (char *)&mat[5], (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&mat[8], (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&mat[11], (ftnlen)sizeof(real));
    e_wsfe();
    io___661.ciunit = *ifc;
    s_wsfe(&io___661);
    do_fio(&c__1, "z     ", (ftnlen)6);
    do_fio(&c__1, (char *)&mat[6], (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&mat[9], (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&mat[12], (ftnlen)sizeof(real));
    e_wsfe();
    io___662.ciunit = *ifc;
    s_wsfe(&io___662);
    e_wsfe();
    io___663.ciunit = *ifc;
    s_wsfe(&io___663);
    do_fio(&c__1, "r     ", (ftnlen)6);
    do_fio(&c__1, (char *)&r__[0], (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&r__[1], (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&r__[2], (ftnlen)sizeof(real));
    e_wsfe();
    io___664.ciunit = *ifc;
    s_wsfe(&io___664);
    do_fio(&c__1, "theta ", (ftnlen)6);
    do_fio(&c__1, (char *)&theta[0], (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&theta[1], (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&theta[2], (ftnlen)sizeof(real));
    e_wsfe();
    io___665.ciunit = *ifc;
    s_wsfe(&io___665);
    do_fio(&c__1, "phi   ", (ftnlen)6);
    do_fio(&c__1, (char *)&phi[0], (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&phi[1], (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&phi[2], (ftnlen)sizeof(real));
    e_wsfe();
    io___666.ciunit = *ifc;
    s_wsfe(&io___666);
    e_wsfe();
    io___667.ciunit = *ifc;
    s_wsfe(&io___667);
    do_fio(&c__1, "Lambda", (ftnlen)6);
    do_fio(&c__1, (char *)&lambda[1], (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&lambda[2], (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&lambda[3], (ftnlen)sizeof(real));
    e_wsfe();


    return 0;
} /* mat_write_eigen_vec__ */


/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */

/* BEGIN V2.2 compatibility */

/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */
/*     P. Robert, ScientiDev, Janvier 2019 */
/*     subroutine for compatibility with previous V2.2 versions */
/*     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX */
/* Subroutine */ int cangrat_(real *ux, real *uy, real *uz, real *vx, real *
	vy, real *vz, real *angle, real *ratio)
{
    extern /* Subroutine */ int cp_angle_and_ratio__(real *, real *, real *, 
	    real *, real *, real *, real *, real *);

    cp_angle_and_ratio__(ux, uy, uz, vx, vy, vz, angle, ratio);
    return 0;
} /* cangrat_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int cdatdoy_(integer *idoy, integer *iyear, integer *imonth, 
	integer *iday)
{
    extern /* Subroutine */ int cv_doty_to_date__(integer *, integer *, 
	    integer *, integer *);

    cv_doty_to_date__(idoy, iyear, imonth, iday);
    return 0;
} /* cdatdoy_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int cdatj00_(integer *jd00, integer *iyear, integer *imonth, 
	integer *iday)
{
    extern /* Subroutine */ int cv_jul2000_to_date__(integer *, integer *, 
	    integer *, integer *);

    cv_jul2000_to_date__(jd00, iyear, imonth, iday);
    return 0;
} /* cdatj00_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int cdatj50_(integer *jd50, integer *iyear, integer *imonth, 
	integer *iday)
{
    extern /* Subroutine */ int cv_jul1950_to_date__(integer *, integer *, 
	    integer *, integer *);

    cv_jul1950_to_date__(jd50, iyear, imonth, iday);
    return 0;
} /* cdatj50_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int cdatwee_(integer *iweek, integer *iyear, integer *imonth,
	 integer *iday)
{
    extern /* Subroutine */ int cv_weekn_to_date__(integer *, integer *, 
	    integer *, integer *);

    cv_weekn_to_date__(iweek, iyear, imonth, iday);
    return 0;
} /* cdatwee_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int cdipdir_(integer *iyear, integer *idoy, real *d1, real *
	d2, real *d3)
{
    extern /* Subroutine */ int cp_geo_dipole_dir__(integer *, integer *, 
	    real *, real *, real *);

    cp_geo_dipole_dir__(iyear, idoy, d1, d2, d3);
    return 0;
} /* cdipdir_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int cdoweek_(integer *iyear, integer *imonth, integer *iday, 
	integer *idow)
{
    extern /* Subroutine */ int cv_date_to_dotw__(integer *, integer *, 
	    integer *, integer *);

    cv_date_to_dotw__(iyear, imonth, iday, idow);
    return 0;
} /* cdoweek_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int cdoyear_(integer *iyear, integer *imonth, integer *iday, 
	integer *idoy)
{
    extern /* Subroutine */ int cv_date_to_doty__(integer *, integer *, 
	    integer *, integer *);

    cv_date_to_doty__(iyear, imonth, iday, idoy);
    return 0;
} /* cdoyear_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int cfrdayn_(integer *iday, char *cday, integer *nbcha, 
	ftnlen cday_len)
{
    extern /* Subroutine */ int cp_fr_day_name__(integer *, char *, integer *,
	     ftnlen);

    cp_fr_day_name__(iday, cday, nbcha, cday_len);
    return 0;
} /* cfrdayn_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int cfrmonn_(integer *imonth, char *cmonth, integer *nchar, 
	ftnlen cmonth_len)
{
    extern /* Subroutine */ int cp_fr_month_name__(integer *, char *, integer 
	    *, ftnlen);

    cp_fr_month_name__(imonth, cmonth, nchar, cmonth_len);
    return 0;
} /* cfrmonn_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int chouday_(integer *ih, integer *im, integer *is, real *
	houday)
{
    extern /* Subroutine */ int cv_hms_to_dech__(integer *, integer *, 
	    integer *, real *);

    cv_hms_to_dech__(ih, im, is, houday);
    return 0;
} /* chouday_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int cjd1950_(integer *iyear, integer *imonth, integer *iday, 
	integer *jd50)
{
    extern /* Subroutine */ int cv_date_to_jul1950__(integer *, integer *, 
	    integer *, integer *);

    cv_date_to_jul1950__(iyear, imonth, iday, jd50);
    return 0;
} /* cjd1950_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int cjd2000_(integer *iyear, integer *imonth, integer *iday, 
	integer *jd00)
{
    extern /* Subroutine */ int cv_date_to_jul2000__(integer *, integer *, 
	    integer *, integer *);

    cv_date_to_jul2000__(iyear, imonth, iday, jd00);
    return 0;
} /* cjd2000_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int cmilday_(integer *ih, integer *im, integer *is, integer *
	ims, integer *milday)
{
    extern /* Subroutine */ int cv_dhms_to_msotd__(integer *, integer *, 
	    integer *, integer *, integer *);

    cv_dhms_to_msotd__(ih, im, is, ims, milday);
    return 0;
} /* cmilday_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int cnbdmon_(integer *iyear, integer *imonth, integer *nbday)
{
    extern /* Subroutine */ int cp_nbday_in_month__(integer *, integer *, 
	    integer *);

    cp_nbday_in_month__(iyear, imonth, nbday);
    return 0;
} /* cnbdmon_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int coleapy_(integer *iyear, integer *ileap)
{
    extern /* Subroutine */ int cp_leap_year__(integer *, integer *);

    cp_leap_year__(iyear, ileap);
    return 0;
} /* coleapy_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int csundir_(integer *iyear, integer *idoy, integer *ih, 
	integer *im, integer *is, real *gst, real *slong, real *sra, real *
	sdec, real *obliq)
{
    extern /* Subroutine */ int cp_gei_sun_dir__(integer *, integer *, 
	    integer *, integer *, integer *, real *, real *, real *, real *, 
	    real *);

    cp_gei_sun_dir__(iyear, idoy, ih, im, is, gst, slong, sra, sdec, obliq);
    return 0;
} /* csundir_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int csunset_(integer *iyear, integer *imon, integer *iday, 
	real *rlat, real *rlon, char *tmer, char *tris, char *tset, char *
	durd, real *elemer, real *azimer, real *eleris, real *aziris, real *
	eleset, real *aziset, integer *icor, ftnlen tmer_len, ftnlen tris_len,
	 ftnlen tset_len, ftnlen durd_len)
{
    extern /* Subroutine */ int cp_sunrise_sunset__(integer *, integer *, 
	    integer *, real *, real *, char *, char *, char *, char *, real *,
	     real *, real *, real *, real *, real *, integer *, ftnlen, 
	    ftnlen, ftnlen, ftnlen);

    cp_sunrise_sunset__(iyear, imon, iday, rlat, rlon, tmer, tris, tset, durd,
	     elemer, azimer, eleris, aziris, eleset, aziset, icor, tmer_len, 
	    tris_len, tset_len, durd_len);
    return 0;
} /* csunset_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int ctimhou_(real *houday, integer *ih, integer *im, integer 
	*is)
{
    extern /* Subroutine */ int cv_dech_to_hms__(real *, integer *, integer *,
	     integer *);

    cv_dech_to_hms__(houday, ih, im, is);
    return 0;
} /* ctimhou_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int ctimmil_(integer *milday, integer *ih, integer *im, 
	integer *is, integer *ims)
{
    extern /* Subroutine */ int cv_msotd_to_hmsms__(integer *, integer *, 
	    integer *, integer *, integer *);

    cv_msotd_to_hmsms__(milday, ih, im, is, ims);
    return 0;
} /* ctimmil_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int ctimpa2_(integer *jd1950, real *houday)
{
    extern /* Subroutine */ int cp_time_param2__(integer *, real *);

    cp_time_param2__(jd1950, houday);
    return 0;
} /* ctimpa2_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int ctimpa3_(integer *jd2000, real *houday)
{
    extern /* Subroutine */ int cp_time_param3__(integer *, real *);

    cp_time_param3__(jd2000, houday);
    return 0;
} /* ctimpa3_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int ctimpar_(integer *iyear, integer *imonth, integer *iday, 
	integer *ih, integer *im, integer *is)
{
    extern /* Subroutine */ int cp_time_param__(integer *, integer *, integer 
	    *, integer *, integer *, integer *);

    cp_time_param__(iyear, imonth, iday, ih, im, is);
    return 0;
} /* ctimpar_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int cusdayn_(integer *iday, char *cday, integer *nbcha, 
	ftnlen cday_len)
{
    extern /* Subroutine */ int cp_en_day_name__(integer *, char *, integer *,
	     ftnlen);

    cp_en_day_name__(iday, cday, nbcha, cday_len);
    return 0;
} /* cusdayn_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int cusmonn_(integer *imonth, char *cmonth, integer *nchar, 
	ftnlen cmonth_len)
{
    extern /* Subroutine */ int cp_en_month_name__(integer *, char *, integer 
	    *, ftnlen);

    cp_en_month_name__(imonth, cmonth, nchar, cmonth_len);
    return 0;
} /* cusmonn_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int cweedoy_(integer *iyear, integer *imonth, integer *iday, 
	integer *iweek)
{
    extern /* Subroutine */ int cv_date_to_weekn__(integer *, integer *, 
	    integer *, integer *);

    cv_date_to_weekn__(iyear, imonth, iday, iweek);
    return 0;
} /* cweedoy_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int gdipdir_(real *dxgei, real *dygei, real *dzgei, real *
	dxgeo, real *dygeo, real *dzgeo)
{
    extern /* Subroutine */ int g_gei_geo_dipole_dir__(real *, real *, real *,
	     real *, real *, real *);

    g_gei_geo_dipole_dir__(dxgei, dygei, dzgei, dxgeo, dygeo, dzgeo);
    return 0;
} /* gdipdir_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int gdiptan_(real *diptan)
{
    extern /* Subroutine */ int g_gsm_dipole_tilt_angle__(real *);

    g_gsm_dipole_tilt_angle__(diptan);
    return 0;
} /* gdiptan_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int gecldir_(real *exgei, real *eygei, real *ezgei, real *
	exgeo, real *eygeo, real *ezgeo)
{
    extern /* Subroutine */ int g_gei_geo_ecliptic_dir__(real *, real *, real 
	    *, real *, real *, real *);

    g_gei_geo_ecliptic_dir__(exgei, eygei, ezgei, exgeo, eygeo, ezgeo);
    return 0;
} /* gecldir_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int gsrodir_(real *rxgei, real *rygei, real *rzgei, real *
	rxgeo, real *rygeo, real *rzgeo)
{
    extern /* Subroutine */ int g_gei_geo_sun_rot__(real *, real *, real *, 
	    real *, real *, real *);

    g_gei_geo_sun_rot__(rxgei, rygei, rzgei, rxgeo, rygeo, rzgeo);
    return 0;
} /* gsrodir_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int gsundir_(real *sxgei, real *sygei, real *szgei, real *
	sxgeo, real *sygeo, real *szgeo)
{
    extern /* Subroutine */ int g_gei_geo_sun_dir__(real *, real *, real *, 
	    real *, real *, real *);

    g_gei_geo_sun_dir__(sxgei, sygei, szgei, sxgeo, sygeo, szgeo);
    return 0;
} /* gsundir_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int gsunpar_(real *gmst, real *slon, real *sras, real *sdec, 
	real *obli)
{
    extern /* Subroutine */ int g_gei_sun_param__(real *, real *, real *, 
	    real *, real *);

    g_gei_sun_param__(gmst, slon, sras, sdec, obli);
    return 0;
} /* gsunpar_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int gvernum_(real *vernum, char *verdat, ftnlen verdat_len)
{
    extern /* Subroutine */ int g_rocot_version_number__(real *, char *, 
	    ftnlen);

    g_rocot_version_number__(vernum, verdat, (ftnlen)14);
    return 0;
} /* gvernum_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int plibinf_(void)
{
    extern /* Subroutine */ int print_rocot_info__(void);

    print_rocot_info__();
    return 0;
} /* plibinf_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int recoor_(real *x, real *y, real *z__, char *cs, ftnlen 
	cs_len)
{
    extern /* Subroutine */ int r_coordinate_values__(real *, real *, real *, 
	    char *, ftnlen);

    r_coordinate_values__(x, y, z__, cs, (ftnlen)1);
    return 0;
} /* recoor_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int recsys_(char *csys, ftnlen csys_len)
{
    extern /* Subroutine */ int r_coordinate_system__(char *, ftnlen);

    r_coordinate_system__(csys, csys_len);
    return 0;
} /* recsys_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int redate_(integer *iyear, integer *imonth, integer *iday)
{
    extern /* Subroutine */ int r_date__(integer *, integer *, integer *);

    r_date__(iyear, imonth, iday);
    return 0;
} /* redate_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int retime_(integer *ih, integer *im, integer *is)
{
    extern /* Subroutine */ int r_time__(integer *, integer *, integer *);

    r_time__(ih, im, is);
    return 0;
} /* retime_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tcarsph_(real *x, real *y, real *z__, real *r__, real *
	teta, real *phi)
{
    extern /* Subroutine */ int t_car_to_sph__(real *, real *, real *, real *,
	     real *, real *);

    t_car_to_sph__(x, y, z__, r__, teta, phi);
    return 0;
} /* tcarsph_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tdmegeo_(real *xdme, real *ydme, real *zdme, real *rlat, 
	real *rlong, real *xgeo, real *ygeo, real *zgeo)
{
    extern /* Subroutine */ int t_dm_to_geo__(real *, real *, real *, real *, 
	    real *, real *, real *, real *);

    t_dm_to_geo__(xdme, ydme, zdme, rlat, rlong, xgeo, ygeo, zgeo);
    return 0;
} /* tdmegeo_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgeigeo_(real *xgei, real *ygei, real *zgei, real *xgeo, 
	real *ygeo, real *zgeo)
{
    extern /* Subroutine */ int t_gei_to_geo__(real *, real *, real *, real *,
	     real *, real *);

    t_gei_to_geo__(xgei, ygei, zgei, xgeo, ygeo, zgeo);
    return 0;
} /* tgeigeo_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgeigse_(real *xgei, real *ygei, real *zgei, real *xgse, 
	real *ygse, real *zgse)
{
    extern /* Subroutine */ int t_gei_to_gse__(real *, real *, real *, real *,
	     real *, real *);

    t_gei_to_gse__(xgei, ygei, zgei, xgse, ygse, zgse);
    return 0;
} /* tgeigse_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgeigsm_(real *xgei, real *ygei, real *zgei, real *xgsm, 
	real *ygsm, real *zgsm)
{
    extern /* Subroutine */ int t_gei_to_gsm__(real *, real *, real *, real *,
	     real *, real *);

    t_gei_to_gsm__(xgei, ygei, zgei, xgsm, ygsm, zgsm);
    return 0;
} /* tgeigsm_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgeigsq_(real *xgei, real *ygei, real *zgei, real *xgsq, 
	real *ygsq, real *zgsq)
{
    extern /* Subroutine */ int t_gei_to_gseq__(real *, real *, real *, real *
	    , real *, real *);

    t_gei_to_gseq__(xgei, ygei, zgei, xgsq, ygsq, zgsq);
    return 0;
} /* tgeigsq_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgeimag_(real *xgei, real *ygei, real *zgei, real *xmag, 
	real *ymag, real *zmag)
{
    extern /* Subroutine */ int t_gei_to_mag__(real *, real *, real *, real *,
	     real *, real *);

    t_gei_to_mag__(xgei, ygei, zgei, xmag, ymag, zmag);
    return 0;
} /* tgeimag_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgeisma_(real *xgei, real *ygei, real *zgei, real *xsma, 
	real *ysma, real *zsma)
{
    extern /* Subroutine */ int t_gei_to_sm__(real *, real *, real *, real *, 
	    real *, real *);

    t_gei_to_sm__(xgei, ygei, zgei, xsma, ysma, zsma);
    return 0;
} /* tgeisma_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgeodme_(real *xgeo, real *ygeo, real *zgeo, real *rlat, 
	real *rlong, real *xdme, real *ydme, real *zdme)
{
    extern /* Subroutine */ int t_geo_to_dm__(real *, real *, real *, real *, 
	    real *, real *, real *, real *);

    t_geo_to_dm__(xgeo, ygeo, zgeo, rlat, rlong, xdme, ydme, zdme);
    return 0;
} /* tgeodme_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgeogei_(real *xgeo, real *ygeo, real *zgeo, real *xgei, 
	real *ygei, real *zgei)
{
    extern /* Subroutine */ int t_geo_to_gei__(real *, real *, real *, real *,
	     real *, real *);

    t_geo_to_gei__(xgeo, ygeo, zgeo, xgei, ygei, zgei);
    return 0;
} /* tgeogei_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgeogse_(real *xgeo, real *ygeo, real *zgeo, real *xgse, 
	real *ygse, real *zgse)
{
    extern /* Subroutine */ int t_geo_to_gse__(real *, real *, real *, real *,
	     real *, real *);

    t_geo_to_gse__(xgeo, ygeo, zgeo, xgse, ygse, zgse);
    return 0;
} /* tgeogse_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgeogsm_(real *xgeo, real *ygeo, real *zgeo, real *xgsm, 
	real *ygsm, real *zgsm)
{
    extern /* Subroutine */ int t_geo_to_gsm__(real *, real *, real *, real *,
	     real *, real *);

    t_geo_to_gsm__(xgeo, ygeo, zgeo, xgsm, ygsm, zgsm);
    return 0;
} /* tgeogsm_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgeogsq_(real *xgeo, real *ygeo, real *zgeo, real *xgsq, 
	real *ygsq, real *zgsq)
{
    extern /* Subroutine */ int t_geo_to_gseq__(real *, real *, real *, real *
	    , real *, real *);

    t_geo_to_gseq__(xgeo, ygeo, zgeo, xgsq, ygsq, zgsq);
    return 0;
} /* tgeogsq_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgeomag_(real *xgeo, real *ygeo, real *zgeo, real *xmag, 
	real *ymag, real *zmag)
{
    extern /* Subroutine */ int t_geo_to_mag__(real *, real *, real *, real *,
	     real *, real *);

    t_geo_to_mag__(xgeo, ygeo, zgeo, xmag, ymag, zmag);
    return 0;
} /* tgeomag_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgeosma_(real *xgeo, real *ygeo, real *zgeo, real *xsma, 
	real *ysma, real *zsma)
{
    extern /* Subroutine */ int t_geo_to_sm__(real *, real *, real *, real *, 
	    real *, real *);

    t_geo_to_sm__(xgeo, ygeo, zgeo, xsma, ysma, zsma);
    return 0;
} /* tgeosma_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgeovdh_(real *xgeo, real *ygeo, real *zgeo, real *rlat, 
	real *rlong, real *xvdh, real *yvdh, real *zvdh)
{
    extern /* Subroutine */ int t_geo_to_vdh__(real *, real *, real *, real *,
	     real *, real *, real *, real *);

    t_geo_to_vdh__(xgeo, ygeo, zgeo, rlat, rlong, xvdh, yvdh, zvdh);
    return 0;
} /* tgeovdh_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgsegei_(real *xgse, real *ygse, real *zgse, real *xgei, 
	real *ygei, real *zgei)
{
    extern /* Subroutine */ int t_gse_to_gei__(real *, real *, real *, real *,
	     real *, real *);

    t_gse_to_gei__(xgse, ygse, zgse, xgei, ygei, zgei);
    return 0;
} /* tgsegei_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgsegeo_(real *xgse, real *ygse, real *zgse, real *xgeo, 
	real *ygeo, real *zgeo)
{
    extern /* Subroutine */ int t_gse_to_geo__(real *, real *, real *, real *,
	     real *, real *);

    t_gse_to_geo__(xgse, ygse, zgse, xgeo, ygeo, zgeo);
    return 0;
} /* tgsegeo_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgsegsm_(real *xgse, real *ygse, real *zgse, real *xgsm, 
	real *ygsm, real *zgsm)
{
    extern /* Subroutine */ int t_gse_to_gsm__(real *, real *, real *, real *,
	     real *, real *);

    t_gse_to_gsm__(xgse, ygse, zgse, xgsm, ygsm, zgsm);
    return 0;
} /* tgsegsm_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgsegsq_(real *xgse, real *ygse, real *zgse, real *xgsq, 
	real *ygsq, real *zgsq)
{
    extern /* Subroutine */ int t_gse_to_gseq__(real *, real *, real *, real *
	    , real *, real *);

    t_gse_to_gseq__(xgse, ygse, zgse, xgsq, ygsq, zgsq);
    return 0;
} /* tgsegsq_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgsesr2_(real *xgse, real *ygse, real *zgse, real *rotx, 
	real *roty, real *rotz, real *xsr2, real *ysr2, real *zsr2)
{
    extern /* Subroutine */ int t_gse_to_sr2__(real *, real *, real *, real *,
	     real *, real *, real *, real *, real *);

    t_gse_to_sr2__(xgse, ygse, zgse, rotx, roty, rotz, xsr2, ysr2, zsr2);
    return 0;
} /* tgsesr2_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgsmgei_(real *xgsm, real *ygsm, real *zgsm, real *xgei, 
	real *ygei, real *zgei)
{
    extern /* Subroutine */ int t_gsm_to_gei__(real *, real *, real *, real *,
	     real *, real *);

    t_gsm_to_gei__(xgsm, ygsm, zgsm, xgei, ygei, zgei);
    return 0;
} /* tgsmgei_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgsmgeo_(real *xgsm, real *ygsm, real *zgsm, real *xgeo, 
	real *ygeo, real *zgeo)
{
    extern /* Subroutine */ int t_gsm_to_geo__(real *, real *, real *, real *,
	     real *, real *);

    t_gsm_to_geo__(xgsm, ygsm, zgsm, xgeo, ygeo, zgeo);
    return 0;
} /* tgsmgeo_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgsmgse_(real *xgsm, real *ygsm, real *zgsm, real *xgse, 
	real *ygse, real *zgse)
{
    extern /* Subroutine */ int t_gsm_to_gse__(real *, real *, real *, real *,
	     real *, real *);

    t_gsm_to_gse__(xgsm, ygsm, zgsm, xgse, ygse, zgse);
    return 0;
} /* tgsmgse_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgsmgsq_(real *xgsm, real *ygsm, real *zgsm, real *xgsq, 
	real *ygsq, real *zgsq)
{
    extern /* Subroutine */ int t_gsm_to_gseq__(real *, real *, real *, real *
	    , real *, real *);

    t_gsm_to_gseq__(xgsm, ygsm, zgsm, xgsq, ygsq, zgsq);
    return 0;
} /* tgsmgsq_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgsmmag_(real *xgsm, real *ygsm, real *zgsm, real *xmag, 
	real *ymag, real *zmag)
{
    extern /* Subroutine */ int t_gsm_to_mag__(real *, real *, real *, real *,
	     real *, real *);

    t_gsm_to_mag__(xgsm, ygsm, zgsm, xmag, ymag, zmag);
    return 0;
} /* tgsmmag_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgsmsma_(real *xgsm, real *ygsm, real *zgsm, real *xsma, 
	real *ysma, real *zsma)
{
    extern /* Subroutine */ int t_gsm_to_sm__(real *, real *, real *, real *, 
	    real *, real *);

    t_gsm_to_sm__(xgsm, ygsm, zgsm, xsma, ysma, zsma);
    return 0;
} /* tgsmsma_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgsqgei_(real *xgsq, real *ygsq, real *zgsq, real *xgei, 
	real *ygei, real *zgei)
{
    extern /* Subroutine */ int t_gseq_to_gei__(real *, real *, real *, real *
	    , real *, real *);

    t_gseq_to_gei__(xgsq, ygsq, zgsq, xgei, ygei, zgei);
    return 0;
} /* tgsqgei_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgsqgeo_(real *xgsq, real *ygsq, real *zgsq, real *xgeo, 
	real *ygeo, real *zgeo)
{
    extern /* Subroutine */ int t_gseq_to_geo__(real *, real *, real *, real *
	    , real *, real *);

    t_gseq_to_geo__(xgsq, ygsq, zgsq, xgeo, ygeo, zgeo);
    return 0;
} /* tgsqgeo_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgsqgse_(real *xgsq, real *ygsq, real *zgsq, real *xgse, 
	real *ygse, real *zgse)
{
    extern /* Subroutine */ int t_gseq_to_gse__(real *, real *, real *, real *
	    , real *, real *);

    t_gseq_to_gse__(xgsq, ygsq, zgsq, xgse, ygse, zgse);
    return 0;
} /* tgsqgse_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tgsqgsm_(real *xgsq, real *ygsq, real *zgsq, real *xgsm, 
	real *ygsm, real *zgsm)
{
    extern /* Subroutine */ int t_gseq_to_gsm__(real *, real *, real *, real *
	    , real *, real *);

    t_gseq_to_gsm__(xgsq, ygsq, zgsq, xgsm, ygsm, zgsm);
    return 0;
} /* tgsqgsm_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tmaggei_(real *xmag, real *ymag, real *zmag, real *xgei, 
	real *ygei, real *zgei)
{
    extern /* Subroutine */ int t_mag_to_gei__(real *, real *, real *, real *,
	     real *, real *);

    t_mag_to_gei__(xmag, ymag, zmag, xgei, ygei, zgei);
    return 0;
} /* tmaggei_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tmaggeo_(real *xmag, real *ymag, real *zmag, real *xgeo, 
	real *ygeo, real *zgeo)
{
    extern /* Subroutine */ int t_mag_to_geo__(real *, real *, real *, real *,
	     real *, real *);

    t_mag_to_geo__(xmag, ymag, zmag, xgeo, ygeo, zgeo);
    return 0;
} /* tmaggeo_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tmaggsm_(real *xmag, real *ymag, real *zmag, real *xgsm, 
	real *ygsm, real *zgsm)
{
    extern /* Subroutine */ int t_mag_to_gsm__(real *, real *, real *, real *,
	     real *, real *);

    t_mag_to_gsm__(xmag, ymag, zmag, xgsm, ygsm, zgsm);
    return 0;
} /* tmaggsm_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tmagsma_(real *xmag, real *ymag, real *zmag, real *xsma, 
	real *ysma, real *zsma)
{
    extern /* Subroutine */ int t_mag_to_sm__(real *, real *, real *, real *, 
	    real *, real *);

    t_mag_to_sm__(xmag, ymag, zmag, xsma, ysma, zsma);
    return 0;
} /* tmagsma_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tsmagei_(real *xsma, real *ysma, real *zsma, real *xgei, 
	real *ygei, real *zgei)
{
    extern /* Subroutine */ int t_sm_to_gei__(real *, real *, real *, real *, 
	    real *, real *);

    t_sm_to_gei__(xsma, ysma, zsma, xgei, ygei, zgei);
    return 0;
} /* tsmagei_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tsmageo_(real *xsma, real *ysma, real *zsma, real *xgeo, 
	real *ygeo, real *zgeo)
{
    extern /* Subroutine */ int t_sm_to_geo__(real *, real *, real *, real *, 
	    real *, real *);

    t_sm_to_geo__(xsma, ysma, zsma, xgeo, ygeo, zgeo);
    return 0;
} /* tsmageo_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tsmagsm_(real *xsma, real *ysma, real *zsma, real *xgsm, 
	real *ygsm, real *zgsm)
{
    extern /* Subroutine */ int t_sm_to_gsm__(real *, real *, real *, real *, 
	    real *, real *);

    t_sm_to_gsm__(xsma, ysma, zsma, xgsm, ygsm, zgsm);
    return 0;
} /* tsmagsm_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tsmamag_(real *xsma, real *ysma, real *zsma, real *xmag, 
	real *ymag, real *zmag)
{
    extern /* Subroutine */ int t_sm_to_mag__(real *, real *, real *, real *, 
	    real *, real *);

    t_sm_to_mag__(xsma, ysma, zsma, xmag, ymag, zmag);
    return 0;
} /* tsmamag_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tsphcar_(real *r__, real *teta, real *phi, real *x, real 
	*y, real *z__)
{
    extern /* Subroutine */ int t_sph_to_car__(real *, real *, real *, real *,
	     real *, real *);

    t_sph_to_car__(r__, teta, phi, x, y, z__);
    return 0;
} /* tsphcar_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tsr2gse_(real *xsr2, real *ysr2, real *zsr2, real *rotx, 
	real *roty, real *rotz, real *xgse, real *ygse, real *zgse)
{
    extern /* Subroutine */ int t_sr2_to_gse__(real *, real *, real *, real *,
	     real *, real *, real *, real *, real *);

    t_sr2_to_gse__(xsr2, ysr2, zsr2, rotx, roty, rotz, xgse, ygse, zgse);
    return 0;
} /* tsr2gse_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tsr2mfa_(real *xsr2, real *ysr2, real *zsr2, real *bx, 
	real *by, real *bz, real *rox, real *roy, real *roz, real *xm, real *
	ym, real *zm)
{
    extern /* Subroutine */ int t_sr2_to_mfa__(real *, real *, real *, real *,
	     real *, real *, real *, real *, real *, real *, real *, real *);

    t_sr2_to_mfa__(xsr2, ysr2, zsr2, bx, by, bz, rox, roy, roz, xm, ym, zm);
    return 0;
} /* tsr2mfa_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tsr2sre_(real *xsr2, real *ysr2, real *spifre, real *
	spipha, real *deltat, real *xsre, real *ysre)
{
    extern /* Subroutine */ int t_sr2_to_sr__(real *, real *, real *, real *, 
	    real *, real *, real *);

    t_sr2_to_sr__(xsr2, ysr2, spifre, spipha, deltat, xsre, ysre);
    return 0;
} /* tsr2sre_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tsresr2_(real *xsre, real *ysre, real *spifre, real *
	spipha, real *deltat, real *xsr2, real *ysr2)
{
    extern /* Subroutine */ int t_sr_to_sr2__(real *, real *, real *, real *, 
	    real *, real *, real *);

    t_sr_to_sr2__(xsre, ysre, spifre, spipha, deltat, xsr2, ysr2);
    return 0;
} /* tsresr2_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
/* Subroutine */ int tvdhgeo_(real *xvdh, real *yvdh, real *zvdh, real *rlat, 
	real *rlong, real *xgeo, real *ygeo, real *zgeo)
{
    extern /* Subroutine */ int t_vdh_to_geo__(real *, real *, real *, real *,
	     real *, real *, real *, real *);

    t_vdh_to_geo__(xvdh, yvdh, zvdh, rlat, rlong, xgeo, ygeo, zgeo);
    return 0;
} /* tvdhgeo_ */

/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */

/*     modulo for f77 */

doublereal rmodulo_(real *a, real *p)
{
    /* System generated locals */
    real ret_val;

    /* Local variables */
    static integer ifloor;

    if (dabs(*p) > 0.f) {
	if (*a * *p > 0.f) {
	    ifloor = (integer) (*a / *p);
	} else {
	    ifloor = (integer) (*a / *p) - 1;
	}
	ret_val = *a - (real) ifloor * *p;
    } else {
	ret_val = *a;
    }
    return ret_val;
} /* rmodulo_ */


/*     xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx0xx */
integer imodulo_(integer *ia, integer *ip)
{
    /* System generated locals */
    integer ret_val;

    /* Local variables */
    static integer ifloor;

    if (abs(*ip) > 0) {
	if (*ia * *ip > 0) {
	    ifloor = *ia / *ip;
	} else {
	    ifloor = *ia / *ip - 1;
	}
	ret_val = *ia - ifloor * *ip;
    } else {
	ret_val = *ia;
    }
    return ret_val;
} /* imodulo_ */

