      PRO co_mag_time, in_file

;     ***************************************************************0**
; *   Compute_Magnetic_Time ; use cmagtim module 
;     P. Robert, Jan 2002                
;     ***************************************************************0**

      fmt100="(a,3f12.5)"
      fmt200="(a,f10.5,a,1x,i2.2,':',i2.2,':',i2.2)"
      fmt300="(a,4(f10.6),2f10.4)"
      fmt400="(a,3i5)"

      PRINT
      PRINT, FORMAT=fmt100, '****************************************************'
      PRINT
      PRINT, FORMAT=fmt100, 'Test of cmagtim:'
      PRINT

      iyear=0
      imonth=0
      iday=0

      ih=0
      im=0
      is=0

      rlat=0.
      rlon=0.

      OPENR, ifc, in_file, /GET_LUN

      r_datef, ifc, iyear,imonth,iday
      r_timef, ifc, ih,im,is
      cp_time_param, iyear,imonth,iday,ih,im,is

      PRINT, FORMAT=fmt100, 'lat et long en degre?'
      READF, ifc, rlat,rlon
      PRINT, FORMAT=fmt100, 'lat, long=', rlat, rlon

      psd= 3.1415927/180.
      pis2= 3.1415927/2.
      rlat=rlat*psd
      rlon=rlon*psd
      rtet=pis2-rlat

      g_gei_geo_sun_dir, sxgei,sygei,szgei,sxgeo,sygeo,szgeo
      g_gei_geo_dipole_dir, dxgei,dygei,dzgei,dxgeo,dygeo,dzgeo

      t_car_to_sph, dxgeo,dygeo,dzgeo,dr,dtet,dphi
      t_sph_to_car, 1.,rtet,rlon, pxgeo,pygeo,pzgeo

      t_geo_to_mag, pxgeo,pygeo,pzgeo,pxmag,pymag,pzmag
      t_geo_to_mag, sxgeo,sygeo,szgeo,sxmag,symag,szmag

      t_car_to_sph, pxmag,pymag,pzmag,pr,ptet,pphi
      t_car_to_sph, sxmag,symag,szmag,sr,stet,sphi

      hmagp= (sphi -pphi)*12./3.1415927 +12.
      IF(hmagp LT 0.) THEN hmagp=hmagp+24.

      ihmag= FIX(hmagp)
      immag= FIX(hmagp*60.) -ihmag*60
      ismag= FIX(hmagp*3600.) -ihmag*3600 -immag*60
;      
      PRINT
      PRINT, FORMAT=fmt400, 'date: YY/MM/JJ=', iyear,imonth,iday
      PRINT, FORMAT=fmt400, 'time: HH/MM/SS=', ih,im,is
      PRINT
      PRINT, FORMAT=fmt300, 'Dipole in GEO:',dxgeo,dygeo,dzgeo,dr,dtet/psd,dphi/psd
      PRINT, FORMAT=fmt300, 'Point  in GEO:',pxgeo,pygeo,pzgeo,1.,rtet/psd,rlon/psd
      PRINT, FORMAT=fmt300, 'Point  in MAG:',pxmag,pymag,pzmag,pr,ptet/psd,pphi/psd
      PRINT, FORMAT=fmt300, 'Sun    in MAG:',sxmag,symag,szmag,sr,stet/psd,sphi/psd
      PRINT
      PRINT, FORMAT=fmt200, 'Mag. Local Time:',hmagp,' soit ',ihmag,immag,ismag
      PRINT
      PRINT, FORMAT=fmt100, '****************************************************'
      PRINT

      END

;     ------------------------------------------------------------------

