      PRO co_seasons, in_file

;     ***************************************************************0**
; *   Compute_Seasons: computation of Solstices & equinox
; *                    FOR a list of years
;     P. Robert, Jan. 2018                                 
;     ***************************************************************0**
      
      fmt100="(10a)     "
      fmt200="(9x,4a)"
      fmt300="(i4,1x,i1,4(7x,i2.2,1x,a5))"

      PRINT
      PRINT, FORMAT=fmt100, '************************************************'
      PRINT, FORMAT=fmt100, 'co_seasons: computation of Solstices & equinoxes'
      PRINT, FORMAT=fmt100, '************************************************'
      PRINT

;     id_sso,id_wso : June and december day of summer and
;                     winter solstice.
;     id_seq,id_feq : same FOR march and september spring
;                     and fall equinoxes.
;     ct_sso,ct_wso : June and december time of summer and
;                     winter solstice.
;     ct_seq,ct_feq : same FOR march and september spring
;                     and fall equinoxes; Cha*5 (hh:mm)



      year_1=0
      year_2=0

      OPENR, ifc, in_file, /GET_LUN

      PRINT, FORMAT=fmt100, 'year_1, year_2 ? ex: 1990 2020'
      READF, ifc, year_1, year_2
      PRINT,      year_1, year_2
      PRINT
      
      PRINT
      ligne = REPLICATE('=======', 10)
      com   = REPLICATE('      DD hh:mm ',4)
      PRINT,FORMAT=fmt100,ligne
      PRINT,FORMAT=fmt200, 'June solstice  ','dec. solstice  ', $ 
                           'march equinoxe ','  sept. equinoxe'
      PRINT,FORMAT=fmt100, 'Year LY',com
      PRINT,FORMAT=fmt100,ligne

      ligne = REPLICATE('-------', 10)    

      FOR iyear= year_1, year_2 DO BEGIN

      cp_leap_year, iyear,ily
      cp_seasons, iyear,id_sso,id_wso,id_seq,id_feq, $ 
                        ct_sso,ct_wso,ct_seq,ct_feq

      PRINT,FORMAT=fmt300, iyear,ily, id_sso,ct_sso, id_wso,ct_wso, $ 
                                      id_seq,ct_seq ,id_feq,ct_feq
      IF(ily EQ 1) THEN PRINT,FORMAT=fmt100,ligne
      
      ENDFOR

      PRINT
      PRINT

      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
;      
