      PRO co_sunset, in_file

;     ***************************************************************0**
; *   Compute_Sunset: computation of sunrise and sunset time
;     P. Robert, Dec 2011                                  
;     ***************************************************************0**

      fmt100="(' merid. time (UT)= ',a8,' sunrise= ',a8," + $ 
                           "' sunset= ',a8,' durd= ',a8)"
      fmt200="(4a)"
      fmt300="(2f10.3,2a)"
      ligne=' '
      qq=' '

      PRINT
      PRINT, FORMAT=fmt200, '****************************************************'
      PRINT
      PRINT, FORMAT=fmt200, 'sunset: computation of sunrise and sunset time'
      PRINT, FORMAT=fmt200, '        assuming spherical Earth'
      PRINT

      OPENR, ifc, in_file, /GET_LUN

      WHILE qq NE 'q' DO BEGIN

      PRINT, FORMAT=fmt200, '-----------------------------------------------------'

      r_datef, ifc, iyear,imon,iday

      PRINT, FORMAT=fmt200, 'lat et long en degre, et lieu ? (blank separator,', $ 
              ' 0 or q to quit)'

      READF, ifc, FORMAT=fmt200, ligne

      qq=STRMID(ligne,0,1)
      IF(qq EQ 'q') THEN BREAK
      READS,ligne, rlat, rlon

      npos=STRPOS(ligne,' ',/REVERSE_SEARCH)
      lieu=STRMID(ligne,npos+1,32)

      PRINT, FORMAT=fmt300, rlat, rlon,'   ',lieu
      PRINT

      rlat=rlat*3.1415927/180.
      rlon=rlon*3.1415927/180.

      icor=3
      tmer='00:00:00'
      tris='00:00:00'
      tset='00:00:00'
      durd='00:00:00'

      cp_sunrise_sunset, iyear,imon,iday,rlat,rlon,tmer,tris,tset, $ 
                   durd,elemer,azimer,eleris,aziris,eleset,aziset,icor

      PRINT, FORMAT=fmt100, tmer,tris,tset,durd

      ENDWHILE

      PRINT
      PRINT, FORMAT=fmt200, '****************************************************'
      PRINT

      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

