      FUNCTION conv,angle

      IF(angle LT 0.)   THEN angle=angle +360.
      IF(angle GT 360.) THEN angle=angle -360.
      IF(angle LT 0.  OR angle GT 360.) THEN BEGIN
                                        rconv='    -   '
                                        RETURN, rconv
                                        ENDIF

      ideg=FIX(angle)
      dec=angle-float(ideg)
      imin=FIX(dec*60.)

      fmt100="(i4,a1,i2.2,a1)"
;     com=STRING(FORMAT=fmt100, ideg,char(176),imin,"'")
      com=STRING(FORMAT=fmt100, ideg,'d',imin,"'")

      RETURN, com
      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO co_sunset_year, in_file

;     ------------------------------------------------------------------
; *   calcul des heures de lever et de coucher de Soleil en un point
;     et pour chaque jour d'une annee.
;     ------------------------------------------------------------------

      fmt100="(a7,2x,3(a7,2a8),2x,a5)"
      fmt200="(a)"
      fmt300="(2f10.3,2a)"
      fmt400="(i4,'-',i2.2,'-',i2.2,3(2x,a5,2a8),2x,a4)"

      PRINT
      PRINT, FORMAT=fmt200, '====================================================='
      PRINT, FORMAT=fmt200, 'Computation of sunrise and sunset time for one year ;'
      PRINT, FORMAT=fmt200, 'Spherical Earth and constant light refaction assumed.'
      PRINT, FORMAT=fmt200, 'Patrick ROBERT, Rocotlib tools, Jan. 2017.'
      PRINT, FORMAT=fmt200, '====================================================='
      PRINT

      OPENR, ifc, in_file, /GET_LUN
      
      PRINT, FORMAT=fmt200, 'year ? ex: 2001'
      READF, ifc, iyear
      PRINT, FORMAT=fmt400, iyear

      PRINT, FORMAT=fmt200, 'lat et long en degre, et lieu ? (blank separator)'

      ligne=' '
      READF, ifc, FORMAT=fmt200, ligne
      READS, ligne, rlat, rlon

      npos=STRPOS(ligne,' ',/REVERSE_SEARCH)
      lieu=STRMID(ligne,npos+1,32)

      PRINT, FORMAT=fmt300, rlat, rlon,'   ',lieu

      rlat=rlat*3.1415927/180.
      rlon=rlon*3.1415927/180.


      FOR imon=1,12 DO BEGIN

      cp_nbday_in_month, iyear,imon,nbday
      cp_en_month_name, imon,cmon,ncha

      PRINT
      PRINT, FORMAT=fmt200, cmon
      PRINT
      PRINT, FORMAT=fmt100, 'date','tris','eleris','aziris', $$ 
                        'tmer','elemer','azimer', $$ 
                        'tset','eleset','aziset','durd'


      icor=3
      tmer='00:00:00'
      tris='00:00:00'
      tset='00:00:00'
      durd='00:00:00'      

      FOR iday=1,nbday DO BEGIN

      cp_sunrise_sunset, iyear,imon,iday,rlat,rlon,tmer,tris,tset, $
                   durd,elemer,azimer,eleris,aziris,eleset,aziset,icor

; *** arondi a la minute la plus proche

      arondi, tris
      arondi, tset
      arondi, tmer
      arondi, durd

      celeris=conv(eleris)
      caziris=conv(aziris)
      celemer=conv(elemer)
      cazimer=conv(azimer)
      celeset=conv(eleset)
      caziset=conv(aziset)

      IF(STRMID(durd,0,5) EQ '00:00') THEN BEGIN
                               celeris=' no Sun '
                               celeset=' no Sun '
                               caziris='    -   '
                               caziset='    -   '
                               ENDIF

      IF(STRMID(durd,0,5) EQ '24:00') THEN BEGIN
                               celeris=' Sun day'
                               celeset=' Sun day'
                               caziris='    -   '
                               caziset='    -   '
                               ENDIF

      PRINT, FORMAT=fmt400, iyear,imon,iday,tris,celeris,caziris, $$ 
                                 tmer,celemer,cazimer, $$ 
                                 tset,celeset,caziset,durd
      ENDFOR
      ENDFOR


      PRINT
      PRINT, FORMAT=fmt200, '****************************************************'
      PRINT

      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO arondi, tris

; *** arondi tris a la minute la plus proche

; WWW  character*8 tris

      FOR i=1,8 DO BEGIN
      IF(STRMID(tris,i-1,1) NE '0'  AND $ 
         STRMID(tris,i-1,1) NE '1'  AND $ 
         STRMID(tris,i-1,1) NE '2'  AND $ 
         STRMID(tris,i-1,1) NE '3'  AND $ 
         STRMID(tris,i-1,1) NE '4'  AND $ 
         STRMID(tris,i-1,1) NE '5'  AND $ 
         STRMID(tris,i-1,1) NE '6'  AND $ 
         STRMID(tris,i-1,1) NE '7'  AND $ 
         STRMID(tris,i-1,1) NE '8'  AND $ 
         STRMID(tris,i-1,1) NE '9'  AND $ 
         STRMID(tris,i-1,1) NE ':' ) THEN RETURN
      ENDFOR

      cchatim_, tris,ih,im,is

      IF(is GE 30) THEN BEGIN
                   im=im+1
                   IF(im GT 59) THEN BEGIN
                                ih=ih+1
                                im=im-60
                                ENDIF
                   ENDIF
      is=0

      ctimcha_, ih,im,is,tris
      
;     RETURN
      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO cchatim_, ctime,ih,im,is

;     ---------------------------------------------------------------+--
; *   Object : convert_time_character_to_time '13:03:05' to 13 03 05
; *   Class  : convert modules of Rogralib Software
; *   Author : P. Robert, PatCie, 1992
;     ---------------------------------------------------------------+--

;     character*(*) ctime

      fmt100="(i2,1x,i2,1x,i2)"
      READS,ctime,FORMAT=fmt100, ih,im,is

;     RETURN
      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO ctimcha_, ih,im,is,ctime

;     ---------------------------------------------------------------+--
; *   Object : convert_time_number_to_char  '13:03:05'
; *   Class  : convert modules of Rogralib Software
; *   Author : P. Robert, PatCie, 1992
;     ---------------------------------------------------------------+--

;     character*(*) ctime

      fmt100="(i2.2,':',i2.2,':',i2.2)"
      ctime=STRING(FORMAT=fmt100, ih,im,is)

;     IF(ctime(1:1) EQ ' ') THEN ctime(1:1)='0'
;     IF(ctime(4:4) EQ ' ') THEN ctime(4:4)='0'
;     IF(ctime(7:7) EQ ' ') THEN ctime(7:7)='0'
      ctime=STRJOIN(STRSPLIT(ctime, /EXTRACT), '0')

;     RETURN
      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

 

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
