      PRO rocot_check, in_file
;                                   
;     ***************************************************************0^

; *   Rocot_Check program:  check subroutines of the rocotlib library;

;     Ask date and time and check calendar conversions and coordinate
;     transformations by walking across all path
;                       ___________________

;     for details, see schematic diagram of section III the orginal
;     document untitled:
;    "CLUSTER Software Tools, part I: Coordinate Transformation Library"
;                     Document de travail DT/CRPE/1231
;                  Patrick Robert, CRPE/TID, Juillet 1993
;                       ___________________

;     Adaptation for successives version of rocotlib:

;               version 1.0, November 1992
;               version 1.1, July     1993
;               version 1.2, January  1995
;               version 1.3, July     2000
;               version 1.4, June     2001
;               version 1.5, December 2001
;               version 1.6, Juin     2002 (upgrade IGRF -> 2005)
;               version 1.7, December 2002 (Version for CDPP)
;               version 1.8, November 2003 (adding t_sr2_to_sr tests)
;               version 1.9, March    2004 (compatibility  V 1.9 IDL)
;               version 2.0, May      2016 (test GSE->MFA et TPN)

;    Copyright 1992, Patrick ROBERT, CNRS-ESA, All Rights reserved

;     ***************************************************************0^

; WWW  character*14 verdat
;     real Tx,Ty,Tz, Px,Py,Pz, Nx,Ny,Nz

      pi=ACOS(-1.)
      d=180./pi

      fmt100="(a,3i6)" 
      fmt105="(a,1x,i4,1x,i2.2,1x,i2.2)"
      fmt106="(a,3(1x,i2.2))"
      fmt108="(f12.5,1x,f8.3,1x,f8.3)"
      fmt109="(f8.3,1x,f8.3)"
      fmt110="(a,f8.4)"
      fmt111="(10x,a,f8.4,a)"
      fmt112="(a,3f10.3)"
      fmt130="(   32x,'X=',f9.4,5x,'r   =  ',f9.4,/" +$ 
                ",32X,'Y=',f9.4,5x,'teta=  ',f7.2,/" +$ 
                ",32X,'Z=',f9.4,5x,'phi =  ',f7.2)"
      fmt140="(/,a44, ' angle=',f8.3,'    (deg.)',:" +$ 
             "/, 44x,' ratio=',f14.5)"
      fmt150="(/,a47, ' angle= ',f9.3,'    (deg.)',:" +$ 
             "/, 47x,' ratio= ',f11.5)"
      fmt200="(1x,a,f3.1,2a,2x,a)"


      g_rocot_version_number, vernum,verdat

      PRINT, FORMAT=fmt100, ' '
      PRINT, FORMAT=fmt100, 'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'
      PRINT, FORMAT=fmt100, ' '
      PRINT, FORMAT=fmt100, '     Coordinates Transformation Library  ROCOTLIB'
      PRINT, FORMAT=fmt100, '                  ___________________'
      PRINT, FORMAT=fmt100, ' '
      PRINT, FORMAT=fmt100, ' Rocotche program: Check transformations of Rocotlib'
      PRINT, FORMAT=fmt100, ' '
      PRINT, FORMAT=fmt100, '          Patrick ROBERT, CRPE, November 1992'
      PRINT, FORMAT=fmt100, ' '
      PRINT, FORMAT=fmt200, '         Revised Version ',vernum, ' - ',verdat
      PRINT, FORMAT=fmt100, ' '
      PRINT, FORMAT=fmt100, 'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'
      PRINT
      PRINT
      PRINT
      PRINT, FORMAT=fmt100, 'SUMMARY OF CHECK OPERATIONS :'
      PRINT, FORMAT=fmt100, '***************************'
      PRINT
      PRINT, FORMAT=fmt100, '  I) TEST OF ROCOTLIB CALENDAR CONVERSIONS'
      PRINT
      PRINT, FORMAT=fmt100, ' II) CHECK BASIC TIME PARAMETERS'
      PRINT
      PRINT, FORMAT=fmt100, 'III) CHECK BASIC TRANSFORMATIONS'
      PRINT
      PRINT, FORMAT=fmt100, ' IV) TEST OF ROCOTLIB TRANSFORMATION SUBROUTINES'
      PRINT
      PRINT, FORMAT=fmt100, '    A) STAR TRANSFORMATIONS AROUND  GEI  SYSTEM'
      PRINT
      PRINT, FORMAT=fmt100, '       GEI -----------------------------> MAG'
      PRINT, FORMAT=fmt100, '       GEI ------------------------> SM'
      PRINT, FORMAT=fmt100, '       GEI ------------------> GSM'
      PRINT, FORMAT=fmt100, '       GEI ------------> GSE'
      PRINT
      PRINT, FORMAT=fmt100, '    B) COUNTERCLOCKWISE RING CUMULATIVE TRANSFORM.'
      PRINT
      PRINT, FORMAT=fmt100, '       GEO ->GEI ->GSQ ->GSE ->GSM ->SM ->MAG ->GEO'
      PRINT
      PRINT, FORMAT=fmt100, '    C) CLOCKWISE RING CUMULATIVE TRANSFORMATIONS'
      PRINT
      PRINT, FORMAT=fmt100, '       GEO ->MAG ->SM ->GSM ->GSE ->GSQ ->GEI ->GEO'
      PRINT
      PRINT, FORMAT=fmt100, '    D) STAR TRANSFORMATIONS AROUND  GEO  SYSTEM'
      PRINT
      PRINT, FORMAT=fmt100, '       GEO ------> SM'
      PRINT, FORMAT=fmt100, '       GEO -----------> GSM'
      PRINT, FORMAT=fmt100, '       GEO -----------------> GSE'
      PRINT, FORMAT=fmt100, '       GEO -----------------------> GSQ'
      PRINT
      PRINT, FORMAT=fmt100, '    E) LOCAL SYSTEMS'
      PRINT
      PRINT, FORMAT=fmt100, '       GEO ----> DM'
      PRINT, FORMAT=fmt100, '       GEO ----> VDH'
      PRINT
      PRINT, FORMAT=fmt100, '    F) SPACECRAFT SYSTEMS'
      PRINT
      PRINT, FORMAT=fmt100, '       GEO -> GSE -> SR2 -> SR -> SR2 -> GSE -> GEO'
      PRINT
      PRINT, FORMAT=fmt100, '    G) PSEUDO-MAGNETOPAUSE SYSTEMS'
      PRINT
      PRINT, FORMAT=fmt100, '       GSE ----> TPN'
      PRINT, FORMAT=fmt100, '       GSM ----> TPN'

      OPENR, ifc, in_file, /GET_LUN

      PRINT, FORMAT=fmt100, STRING(12B)
      PRINT
      PRINT
      PRINT, FORMAT=fmt100, 'INPUT DATA TEST :'
      PRINT, FORMAT=fmt100, '***************'
      PRINT
      PRINT, FORMAT=fmt100, 'INPUT DATE AND TIME:'

      r_datef, ifc, iyear,imonth,iday
      r_timef, ifc, ih,im,is

      PRINT
      PRINT, FORMAT=fmt105, 'iyear,imonth,iday: ',iyear,imonth,iday
      PRINT, FORMAT=fmt106, 'ih, im, is       : ',ih,im,is

      PRINT
      PRINT, FORMAT=fmt100, 'INPUT VECTOR TEST:'

      PRINT, FORMAT=fmt100, 'r, teta,phi of any vector in GEO system ? (deg.)'
      READF, ifc, gr, gtet, gphi
      PRINT, FORMAT=fmt108, gr,gtet,gphi
      gtet=gtet/d
      gphi=gphi/d
      t_sph_to_car, gr,gtet,gphi,g1,g2,g3

      PRINT
      PRINT, FORMAT=fmt100, 'INPUT GEOG. LAT AND LONG. FOR LOCAL SYSTEMS TEST:'
      PRINT, FORMAT=fmt100, 'lat. and long. of local direct. of observation ? (d.)'
      READF, ifc, grlat,grlon
      PRINT, FORMAT=fmt109, grlat,grlon
      grlat=grlat/d
      grlon=grlon/d

      PRINT
      PRINT, FORMAT=fmt100, 'INPUT SPIN DIRECTION for SR and SR2 SYSTEMS:'
      PRINT, FORMAT=fmt100, 'r, teta,phi of spin axis in GSE system ? (deg.)'
      READF, ifc, sar,sat,sap
      PRINT, FORMAT=fmt108, sar,sat,sap
      sat=sat/d
      sap=sap/d
      t_sph_to_car, sar,sat,sap,sa1,sa2,sa3

      PRINT
      PRINT, FORMAT=fmt100, 'SPIN FREQUENCY, SPIN PHASE & Deltat T :'
      PRINT, ' Spin frequency, Spin phase ? (Hz, deg.)'
      READF, ifc, spifre,spipha
      PRINT, FORMAT=fmt108, spifre,spipha
      PRINT, FORMAT=fmt100, 'delta T ? (sec. from time of spin phase)'
      READF, ifc, deltaT
      PRINT, FORMAT=fmt108, deltaT
      spipha=spipha/d

      PRINT
      PRINT
      PRINT
      PRINT, FORMAT=fmt100, 'RUN OF CHECK PROGRAM'
      PRINT, FORMAT=fmt100, '********************'
      PRINT
      PRINT, FORMAT=fmt100, 'Please wait...'
      PRINT, FORMAT=fmt100, STRING(12B)

      PRINT
      PRINT, FORMAT=fmt200, '            T E S T   O F   R O C O T L I B  Version '$ 
                  ,vernum
      PRINT
      PRINT
      PRINT, FORMAT=fmt100, 'I) TEST OF ROCOTLIB CALENDAR CONVERSIONS'
      PRINT, FORMAT=fmt100, '   ====================================='
      PRINT
      PRINT, FORMAT=fmt100, 'INPUT DATE AND TIME:'
      PRINT
      PRINT, FORMAT=fmt100, 'year, month,  day   :     ',iyear,imonth,iday
      PRINT, FORMAT=fmt100, 'hour, minute, second:     ',ih,im,is

      cv_hms_to_dech, ih,im,is,houday
      cv_date_to_doty, iyear,imonth,iday,idoty
      cv_date_to_jul1950, iyear,imonth,iday,jud50
      cv_date_to_jul2000, iyear,imonth,iday,jud00
      cp_leap_year, iyear,ily

      PRINT
      PRINT, FORMAT=fmt100, 'computed values:'
      PRINT
      PRINT, FORMAT=fmt110, 'decimal hour of the day:  ',houday
      PRINT, FORMAT=fmt100, 'day of the year:          ',idoty
      PRINT, FORMAT=fmt100, 'Julian day from 1-1-1950: ',jud50
      PRINT, FORMAT=fmt100, 'Julian day from 1-1-2000: ',jud00
      PRINT, FORMAT=fmt100, 'leap year (1=yes,0=no):   ',ily

      cv_doty_to_date, idoty,iyear,imon2,iday2
      cv_jul1950_to_date, jud50,iyea3,imon3,iday3
      cv_jul2000_to_date, jud00,iyea4,imon4,iday4
      cv_dech_to_hms, houday,ih2,im2,is2

      PRINT
      PRINT, FORMAT=fmt100,'recompute date from year and day of the year:'$ 
                           ,iyear,imon2,iday2
      PRINT, FORMAT=fmt100,'recompute date from Julian day 1950         :'$ 
                           ,iyea3,imon3,iday3
      PRINT, FORMAT=fmt100,'recompute date from Julian day 2000         :'$ 
                           ,iyea4,imon4,iday4
      PRINT, FORMAT=fmt100,'recompute time from decimal hour:',ih2,im2,is2

      PRINT
      PRINT
      PRINT, FORMAT=fmt100, 'II) CHECK BASIC TIME PARAMETERS'
      PRINT, FORMAT=fmt100, '    ==========================='
      PRINT
      PRINT
      PRINT, FORMAT=fmt100, 'SUN PARAMETERS IN GEI SYSTEM'
      PRINT

      cp_time_param, iyear,imonth,iday,ih,im,is

      g_gei_geo_sun_dir, s1gei,s2gei,s3gei, s1geo,s2geo,s3geo
      g_gei_geo_dipole_dir, d1gei,d2gei,d3gei, d1geo,d2geo,d3geo
      g_gei_geo_ecliptic_dir, e1gei,e2gei,e3gei, e1geo,e2geo,e3geo
      g_gei_geo_sun_rot, r1gei,r2gei,r3gei, r1geo,r2geo,r3geo
      g_gei_sun_param, gmst,slong,srasn,sdec,obli
      g_gsm_dipole_tilt_angle, diptan

      t_car_to_sph, s1gei,s2gei,s3gei,srgei,stgei,spgei
      t_car_to_sph, d1gei,d2gei,d3gei,drgei,dtgei,dpgei
      t_car_to_sph, e1gei,e2gei,e3gei,ergei,etgei,epgei
      t_car_to_sph, r1gei,r2gei,r3gei,rrgei,rtgei,rpgei

      t_car_to_sph, s1geo,s2geo,s3geo,srgeo,stgeo,spgeo
      t_car_to_sph, d1geo,d2geo,d3geo,drgeo,dtgeo,dpgeo
      t_car_to_sph, e1geo,e2geo,e3geo,ergeo,etgeo,epgeo
      t_car_to_sph, r1geo,r2geo,r3geo,rrgeo,rtgeo,rpgeo


      PRINT, FORMAT=fmt112, 'Greenwich Sideral Time (deg.):',  gmst*d
      PRINT, FORMAT=fmt112, 'ecliptic longitude     (deg.):', slong*d
      PRINT, FORMAT=fmt112, 'right ascention        (deg.):', srasn*d
      PRINT, FORMAT=fmt112, 'declination            (deg.):',  sdec*d
      PRINT
      PRINT, FORMAT=fmt112, 'DIPOLE TILT ANGLE      (deg.):',diptan*d
      PRINT
      PRINT, FORMAT=fmt100, 'SUN DIRECTION'
      PRINT, FORMAT=fmt100, '                     in GEI:'
      PRINT, FORMAT=fmt130,  s1gei,srgei,s2gei,stgei*d,s3gei, spgei*d
      PRINT, FORMAT=fmt100, '                     in GEO:'
      PRINT, FORMAT=fmt130,  s1geo,srgeo,s2geo,stgeo*d,s3geo, spgeo*d
      PRINT
      PRINT, FORMAT=fmt100, 'DIPOLE DIRECTION'
      PRINT, FORMAT=fmt100, '                     in GEI:'
      PRINT, FORMAT=fmt130,  d1gei,drgei,d2gei,dtgei*d,d3gei, dpgei*d
      PRINT, FORMAT=fmt100, '                     in GEO:'
      PRINT, FORMAT=fmt130,  d1geo,drgeo,d2geo,dtgeo*d,d3geo, dpgeo*d
      PRINT
      PRINT, FORMAT=fmt100, 'ECLIPTIC DIRECTION'
      PRINT, FORMAT=fmt100, '                     in GEI:'
      PRINT, FORMAT=fmt130,  e1gei,ergei,e2gei,etgei*d,e3gei, epgei*d
      PRINT, FORMAT=fmt100, '                     in GEO:'
      PRINT, FORMAT=fmt130,  e1geo,ergeo,e2geo,etgeo*d,e3geo, epgeo*d
      PRINT
      PRINT, FORMAT=fmt100, 'SUN EQUATOR DIRECTION'
      PRINT, FORMAT=fmt100, '                     in GEI:'
      PRINT, FORMAT=fmt130,  r1gei,rrgei,r2gei,rtgei*d,r3gei, rpgei*d
      PRINT, FORMAT=fmt100, '                     in GEO:'
      PRINT, FORMAT=fmt130,  r1geo,rrgeo,r2geo,rtgeo*d,r3geo, rpgeo*d


      PRINT, FORMAT=fmt100, STRING(12B)
      PRINT
      PRINT, FORMAT=fmt100, 'III) CHECK BASIC TRANSFORMATIONS'
      PRINT, FORMAT=fmt100, '     ==========================='
      PRINT

      cp_angle_and_ratio, s1gei,s2gei,s3gei,e1gei,e2gei,e3gei,a ,r 
      cp_angle_and_ratio, s1geo,s2geo,s3geo,e1geo,e2geo,e3geo,a2,r2

      PRINT, FORMAT=fmt140, 'Check (S,E) angle is equal to 90 deg. :',a*d
      IF(abs(a-a2) GT 0.0001/d) THEN BEGIN
        PRINT, FORMAT=fmt100, ' *** angle computed in GEI or GEO system'
        PRINT, FORMAT=fmt100, '     give not the same result:'
        PRINT, FORMAT=fmt140, 'in GEI:',a*d
        PRINT, FORMAT=fmt140, 'in GEO:',a2*d
      ENDIF

      PRINT
      PRINT
      PRINT, FORMAT=fmt100, '1) input vector: Sun direction in GEI system'
      PRINT, FORMAT=fmt100, '   -----------------------------------------'
      PRINT
      PRINT, FORMAT=fmt130,  s1gei,srgei,s2gei,stgei*d,s3gei,spgei*d
      PRINT
      PRINT, FORMAT=fmt100, '                               in GEO system'
      PRINT
      PRINT, FORMAT=fmt130,  s1geo,srgeo,s2geo,stgeo*d,s3geo,spgeo*d

      PRINT
      PRINT
      PRINT, FORMAT=fmt100, '   check Y=0 in SM  system with t_gei_to_sm:'
      t_gei_to_sm, s1gei,s2gei,s3gei,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d
      PRINT
      PRINT, FORMAT=fmt100, '                           with t_geo_to_sm:'
      t_geo_to_sm, s1geo,s2geo,s3geo,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '   check Y=0 and Z=0 in GSM system with t_gei_to_gsm:'
      t_gei_to_gsm, s1gei,s2gei,s3gei,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d
      PRINT
      PRINT, FORMAT=fmt100, '                           with t_geo_to_gsm:'
      t_geo_to_gsm, s1geo,s2geo,s3geo,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '   check Y=0 and Z=0 in GSE system with t_gei_to_gse:'
      t_gei_to_gse, s1gei,s2gei,s3gei,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d
      PRINT
      PRINT, FORMAT=fmt100, '                           with t_geo_to_gse:'
      t_geo_to_gse, s1geo,s2geo,s3geo,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '   check Y=0 and Z=0 in GSQ system with' + $ 
                                             ' t_gei_to_gseq:'
      t_gei_to_gseq, s1gei,s2gei,s3gei,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d
      PRINT
      PRINT, FORMAT=fmt100, '                           with' + $ 
                                            ' t_geo_to_gseq:'
      t_geo_to_gseq, s1geo,s2geo,s3geo,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT, FORMAT=fmt100, STRING(12B)
      PRINT
      PRINT, FORMAT=fmt100, '2) input vector: Dipole direction in GEI system'
      PRINT, FORMAT=fmt100, '   --------------------------------------------'
      PRINT
      PRINT, FORMAT=fmt130,  d1gei,drgei,d2gei,dtgei*d,d3gei,dpgei*d
      PRINT
      PRINT, FORMAT=fmt100, '                                  in GEO system'
      PRINT
      PRINT, FORMAT=fmt130,  d1geo,drgeo,d2geo,dtgeo*d,d3geo,dpgeo*d


      PRINT
      PRINT
      PRINT, FORMAT=fmt100, '   check X=0 and Y=0 in MAG system with t_gei_to_mag:'
      t_gei_to_mag, d1gei,d2gei,d3gei,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d
      PRINT
      PRINT, FORMAT=fmt100, '                           with t_geo_to_mag:'
      t_geo_to_mag, d1geo,d2geo,d3geo,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '   check X=0 and Y=0 in SM  system with t_gei_to_sm:'
      t_gei_to_sm, d1gei,d2gei,d3gei,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d
      PRINT
      PRINT, FORMAT=fmt100, '                           with t_geo_to_sm:'
      t_geo_to_sm, d1geo,d2geo,d3geo,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '   check Y=0 in GSM system with t_gei_to_gsm:'
      t_gei_to_gsm, d1gei,d2gei,d3gei,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d
      PRINT
      PRINT, FORMAT=fmt100, '                           with t_geo_to_gsm:'
      t_geo_to_gsm, d1geo,d2geo,d3geo,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d


      PRINT, FORMAT=fmt100, STRING(12B)
      PRINT
      PRINT, FORMAT=fmt100, '3) input vector: Ecliptic direction in GEI system'
      PRINT, FORMAT=fmt100, '   ----------------------------------------------'
      PRINT
      PRINT, FORMAT=fmt130,  e1gei,ergei,e2gei,etgei*d,e3gei,epgei*d
      PRINT
      PRINT, FORMAT=fmt100, '                                    in GEO system'
      PRINT
      PRINT, FORMAT=fmt130,  e1geo,ergeo,e2geo,etgeo*d,e3geo,epgeo*d


      PRINT
      PRINT
      PRINT, FORMAT=fmt100, '   check X=0 and Y=0 in GSE system with t_gei_to_gse:'
      t_gei_to_gse, e1gei,e2gei,e3gei,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d
      PRINT
      PRINT, FORMAT=fmt100, '                           with t_geo_to_gse:'
      t_geo_to_gse, e1geo,e2geo,e3geo,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '   check X=0 in GSQ system with t_gei_to_gseq:'
      t_gei_to_gseq, e1gei,e2gei,e3gei,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d
      PRINT
      PRINT, FORMAT=fmt100, '                           with t_geo_to_gseq:'
      t_geo_to_gseq, e1geo,e2geo,e3geo,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d


      PRINT
      PRINT
      PRINT
      PRINT
      PRINT
      PRINT, FORMAT=fmt100, '4) input vector: Sun equator in GEI system'
      PRINT, FORMAT=fmt100, '   ---------------------------------------'
      PRINT
      PRINT, FORMAT=fmt130,  r1gei,rrgei,r2gei,rtgei*d,r3gei,rpgei*d
      PRINT
      PRINT, FORMAT=fmt100, '                             in GEO system'
      PRINT
      PRINT, FORMAT=fmt130,  r1geo,rrgeo,r2geo,rtgeo*d,r3geo,rpgeo*d


      PRINT
      PRINT
      PRINT, FORMAT=fmt100, '   check and Y=0 in GSQ system with t_gei_to_gseq:'
      t_gei_to_gseq, r1gei,r2gei,r3gei,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d
      PRINT
      PRINT, FORMAT=fmt100, '                           with t_geo_to_gseq:'
      t_geo_to_gseq, r1geo,r2geo,r3geo,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d


      PRINT, FORMAT=fmt100, STRING(12B)
      PRINT
      PRINT, FORMAT=fmt100, '5) input vector: North geographic in GEO system'
      PRINT, FORMAT=fmt100, '   --------------------------------------------'
      t_car_to_sph, 0.,0.,1.,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, 0.,vr,0.,vt*d,1.,vp*d
      PRINT
      PRINT
      PRINT, FORMAT=fmt100, '   check X=0 and Y=0 in GEI system with t_geo_to_gei:'
      t_geo_to_gei, 0.,0.,1.,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      PRINT
      PRINT, FORMAT=fmt100, '   check Y=0 in MAG system with t_gei_to_mag:'
      t_gei_to_mag, w1,w2,w3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d
      PRINT
      PRINT, FORMAT=fmt100, '                           with t_geo_to_mag:'
      t_geo_to_mag, w1,w2,w3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d


      PRINT
      PRINT
      PRINT, FORMAT=fmt100, 'IV) TEST OF ROCOTLIB TRANSFORMATION SUBROUTINES'
      PRINT, FORMAT=fmt100, '    ==========================================='
      PRINT
      PRINT, FORMAT=fmt100, '1) input choosed test vector in GEO system :'
      PRINT
      PRINT, FORMAT=fmt130, g1,gr,g2,gtet*d,g3,gphi*d

      PRINT
      PRINT, FORMAT=fmt100, '2) converts GEO system to GEI system by t_geo_to_gei'
      t_geo_to_gei, g1,g2,g3,u1,u2,u3
      t_car_to_sph, u1,u2,u3,ur,ut,up
      PRINT
      PRINT, FORMAT=fmt130, u1,ur,u2,ut*d,u3,up*d


      PRINT, FORMAT=fmt100, STRING(12B)
      PRINT
      PRINT, FORMAT=fmt100, 'A) STAR TRANSFORMATIONS AROUND  GEI  SYSTEM'
      PRINT, FORMAT=fmt100, '   ========================================'
      PRINT
      PRINT, FORMAT=fmt100, '            # 3'
      PRINT, FORMAT=fmt100, '       GEI --------> MAG'
      PRINT, FORMAT=fmt100, '            # 4'
      PRINT, FORMAT=fmt100, '       GEI --------> SM'
      PRINT, FORMAT=fmt100, '            # 5'
      PRINT, FORMAT=fmt100, '       GEI --------> GSM'
      PRINT, FORMAT=fmt100, '            # 6'
      PRINT, FORMAT=fmt100, '       GEI --------> GSE'
      PRINT

      PRINT
      PRINT, FORMAT=fmt100, '1) t# 3 converts GEI system to MAG system by' + $ 
                                                   't_gei_to_mag'
      t_gei_to_mag, u1,u2,u3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '              come back to GEI system by t_mag_to_gei'
      t_mag_to_gei, v1,v2,v3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      cp_angle_and_ratio, u1,u2,u3,w1,w2,w3,a,ra
      PRINT, FORMAT=fmt150, 'difference beetween first GEI vector:',a*d,ra


      PRINT
      PRINT
      PRINT, FORMAT=fmt100, '2) t# 4 converts GEI system to SM  system by' + $ 
                                                    't_gei_to_sm'
      t_gei_to_sm, u1,u2,u3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '              come back to GEI system by t_sm_to_gei'
      t_sm_to_gei, v1,v2,v3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      cp_angle_and_ratio, u1,u2,u3,w1,w2,w3,a,ra
      PRINT, FORMAT=fmt150, 'difference beetween first GEI vector:',a*d,ra


      PRINT
      PRINT
      PRINT, FORMAT=fmt100, '3) t# 5 converts GEI system to GSM system by' + $ 
                                                   't_gei_to_gsm'
      t_gei_to_gsm, u1,u2,u3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '              come back to GEI system by t_gsm_to_gei'
      t_gsm_to_gei, v1,v2,v3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      cp_angle_and_ratio, u1,u2,u3,w1,w2,w3,a,ra
      PRINT, FORMAT=fmt150, 'difference beetween first GEI vector:',a*d,ra


      PRINT, FORMAT=fmt100, STRING(12B)
      PRINT
      PRINT, FORMAT=fmt100, '4) t# 6 converts GEI system to GSE system by' + $ 
                                                   ' t_gei_to_gse'
      t_gei_to_gse, u1,u2,u3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '              come back to GEI system by t_gse_to_gei'
      t_gse_to_gei, v1,v2,v3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      cp_angle_and_ratio, u1,u2,u3,w1,w2,w3,a,ra
      PRINT, FORMAT=fmt150, 'difference beetween first GEI vector:',a*d,ra

      PRINT, FORMAT=fmt100, STRING(12B)
      PRINT
      PRINT, FORMAT=fmt100, 'B) COUNTERCLOCKWISE RING CUMULATIVE TRANSFORMATIONS'
      PRINT, FORMAT=fmt100, '   ================================================'
      PRINT
      PRINT, FORMAT=fmt100, '    # 2      7      8      9     10    11     12'
      PRINT, FORMAT=fmt100, '  GEO -> GEI -> GSQ -> GSE -> GSM -> SM -> MAG -> GEO'
      PRINT
      PRINT
      PRINT, FORMAT=fmt100, '   input choosed test vector in GEO system :'
      PRINT
      PRINT, FORMAT=fmt130, g1,gr,g2,gtet*d,g3,gphi*d

      PRINT
      PRINT, FORMAT=fmt100, '1) t# 2 converts GEO system to GEI system by' + $ 
                                                  ' t_geo_to_gei'
      t_geo_to_gei, g1,g2,g3,u1,u2,u3
      t_car_to_sph, u1,u2,u3,ur,ut,up
      PRINT
      PRINT, FORMAT=fmt130, u1,ur,u2,ut*d,u3,up*d

      PRINT
      PRINT, FORMAT=fmt100, '2) t# 7 converts GEI system to GSQ system by' + $ 
                                                 ' t_gei_to_gseq'
      t_gei_to_gseq, u1,u2,u3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d


      PRINT
      PRINT, FORMAT=fmt100, '3) t# 8 converts GSQ system to GSE system by' + $ 
                                                 ' t_gseq_to_gse'
      t_gseq_to_gse, v1,v2,v3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d


      PRINT
      PRINT, FORMAT=fmt100, '4) þ# 9 converts GSE system to GSM system by' + $ 
                                                  ' t_gse_to_gsm'
      t_gse_to_gsm, w1,w2,w3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d


      PRINT
      PRINT, FORMAT=fmt100, '5) t# 10 converts GSM system to SM  system by' + $ 
                                                    ' t_gsm_to_sm'
      t_gsm_to_sm, v1,v2,v3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d


      PRINT
      PRINT, FORMAT=fmt100, '6) t# 11 converts SM  system to MAG system by' + $ 
                                                    ' t_sm_to_mag'
      t_sm_to_mag, w1,w2,w3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d


      PRINT
      PRINT, FORMAT=fmt100, '7) t# 12 converts MAG system to GEO system by' + $ 
                                                   ' t_mag_to_geo'
      t_mag_to_geo, v1,v2,v3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      cp_angle_and_ratio, g1,g2,g3,w1,w2,w3,a,ra
      PRINT, FORMAT=fmt150, 'difference beetween first GEO vector:',a*d,ra


      PRINT, FORMAT=fmt100, STRING(12B)
      PRINT
      PRINT, FORMAT=fmt100, 'C) CLOCKWISE RING CUMULATIVE TRANSFORMATIONS'
      PRINT, FORMAT=fmt100, '   ========================================='
      PRINT
      PRINT, FORMAT=fmt100, '    # 12     11    10     9      8      7      2'
      PRINT, FORMAT=fmt100, '  GEO -> MAG -> SM -> GSM -> GSE -> GSQ -> GEI -> GEO'
      PRINT
      PRINT
      PRINT, FORMAT=fmt100, '   input choosed test vector in GEO system :'
      PRINT
      PRINT, FORMAT=fmt130, g1,gr,g2,gtet*d,g3,gphi*d

      PRINT
      PRINT, FORMAT=fmt100, '1) t# 12 converts GEO system to MAG system by' + $ 
                                                   ' t_geo_to_mag'
      t_geo_to_mag, g1,g2,g3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d


      PRINT
      PRINT, FORMAT=fmt100, '2) t# 11 converts MAG system to SM  system by' + $ 
                                                    ' t_mag_to_sm'
      t_mag_to_sm, w1,w2,w3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d


      PRINT
      PRINT, FORMAT=fmt100, '3) t# 10 converts SM  system to GSM system by' + $ 
                                                    ' t_sm_to_gsm'
      t_sm_to_gsm, v1,v2,v3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d


      PRINT
      PRINT, FORMAT=fmt100, '4) t# 9 converts GSM system to GSE system by' + $ 
                                                  ' t_gsm_to_gse'
      t_gsm_to_gse, w1,w2,w3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d


      PRINT
      PRINT, FORMAT=fmt100, '5) t# 8 converts GSE system to GSQ system by' + $ 
                                                 ' t_gse_to_gseq'
      t_gse_to_gseq, v1,v2,v3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d


      PRINT
      PRINT, FORMAT=fmt100, '6) t# 7 converts GSQ system to GEI system by' + $ 
                                                 ' t_gseq_to_gei'
      t_gseq_to_gei, w1,w2,w3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      cp_angle_and_ratio, u1,u2,u3,v1,v2,v3,a,ra
      PRINT, FORMAT=fmt150, 'difference beetween first GEI vector:',a*d,ra


      PRINT
      PRINT
      PRINT, FORMAT=fmt100, '7) t# 2 converts GEI system to GEO system by' + $ 
                                                  ' t_gei_to_geo'
      t_gei_to_geo, v1,v2,v3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      cp_angle_and_ratio, g1,g2,g3,w1,w2,w3,a,ra
      PRINT, FORMAT=fmt150, 'difference beetween first GEO vector:',a*d,ra

;      PRINT, FORMAT=fmt100, STRING(12B)
      PRINT, FORMAT=fmt100, 'D) STAR TRANSFORMATIONS AROUND  GEO  SYSTEM'
      PRINT, FORMAT=fmt100, '   ========================================'
      PRINT
      PRINT, FORMAT=fmt100, '          # 13'
      PRINT, FORMAT=fmt100, '     GEO --------> SM'
      PRINT, FORMAT=fmt100, '          # 14'
      PRINT, FORMAT=fmt100, '     GEO --------> GSM'
      PRINT, FORMAT=fmt100, '          # 15'
      PRINT, FORMAT=fmt100, '     GEO --------> GSE'
      PRINT, FORMAT=fmt100, '          # 16'
      PRINT, FORMAT=fmt100, '     GEO --------> GSQ'

      PRINT
      PRINT
      PRINT, FORMAT=fmt100, '   input choosed test vector in GEO system :'
      PRINT
      PRINT, FORMAT=fmt130, g1,gr,g2,gtet*d,g3,gphi*d

      PRINT
      PRINT, FORMAT=fmt100, '1) t# 13 converts GEO system to SM  system by' + $ 
                                                    ' t_geo_to_sm'
      t_geo_to_sm, g1,g2,g3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '              come back to GEO system by t_sm_to_geo'
      t_sm_to_geo, v1,v2,v3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      cp_angle_and_ratio, g1,g2,g3,w1,w2,w3,a,ra
      PRINT, FORMAT=fmt150, 'difference beetween first GEO vector:',a*d,ra


      PRINT
      PRINT, FORMAT=fmt100, '2) t# 14 converts GEO system to GSM system by' + $ 
                                                   ' t_geo_to_gsm'
      t_geo_to_gsm, g1,g2,g3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '              come back to GEO system by t_gsm_to_geo'
      t_gsm_to_geo, v1,v2,v3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      cp_angle_and_ratio, g1,g2,g3,w1,w2,w3,a,ra
      PRINT, FORMAT=fmt150, 'difference beetween first GEO vector:',a*d,ra


      PRINT
      PRINT, FORMAT=fmt100, '3) t# 15 converts GEO system to GSE system by' + $ 
                                                   ' t_geo_to_gse'
      t_geo_to_gse, g1,g2,g3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '              come back to GEO system by t_gse_to_geo'
      t_gse_to_geo, v1,v2,v3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      cp_angle_and_ratio, g1,g2,g3,w1,w2,w3,a,ra
      PRINT, FORMAT=fmt150, 'difference beetween first GEO vector:',a*d,ra


      PRINT
      PRINT, FORMAT=fmt100, '4) t# 16 converts GEO system to GSQ system by' + $ 
                                                  ' t_geo_to_gseq'
      t_geo_to_gseq, g1,g2,g3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '              come back to GEO system by' + $ 
                                             ' t_gseq_to_geo'
      t_gseq_to_geo, v1,v2,v3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      cp_angle_and_ratio, g1,g2,g3,w1,w2,w3,a,ra
      PRINT, FORMAT=fmt150, 'difference beetween first GEO vector:',a*d,ra

;      PRINT, FORMAT=fmt100, STRING(12B)
      PRINT, FORMAT=fmt100, 'E) LOCAL SYSTEMS TRANSFORMATIONS'
      PRINT, FORMAT=fmt100, '   ============================='
      PRINT
      PRINT, FORMAT=fmt100, '          # 17'
      PRINT, FORMAT=fmt100, '     GEO --------> DM'
      PRINT, FORMAT=fmt100, '          # 18'
      PRINT, FORMAT=fmt100, '     GEO --------> VDH'
      PRINT
      PRINT, FORMAT=fmt100, '   first direction of observation in GEO system:'
      PRINT, FORMAT=fmt112, '        geog. lat., long. =',grlat*d,grlon*d

      PRINT
      PRINT, FORMAT=fmt100, '1) t# 17 converts GEO system to DM  system by' + $ 
                                                    ' t_geo_to_dm'
      t_geo_to_dm, g1,g2,g3,grlat,grlon,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '              come back to GEO system by t_dm_to_geo'
      t_dm_to_geo, v1,v2,v3,grlat,grlon,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      cp_angle_and_ratio, g1,g2,g3,w1,w2,w3,a,ra
      PRINT, FORMAT=fmt150, 'difference beetween first GEO vector:',a*d,ra


      PRINT
      PRINT, FORMAT=fmt100, '2) t# 18 converts GEO system to VDH system by' + $ 
                                                   ' t_geo_to_vdh'
      t_geo_to_vdh, g1,g2,g3,grlat,grlon,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '              come back to GEO system by t_vdh_to_geo'
      t_vdh_to_geo, v1,v2,v3,grlat,grlon,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      cp_angle_and_ratio, g1,g2,g3,w1,w2,w3,a,ra
      PRINT, FORMAT=fmt150, 'difference beetween first GEO vector:',a*d,ra

      PRINT
      PRINT
      PRINT, FORMAT=fmt100, '   second direction of observation in GEO system:'
      PRINT, FORMAT=fmt112, '        geog. lat., long. =',grlat*d,grlon*d

      PRINT
      PRINT, FORMAT=fmt100, '3) t# 17 converts GEO system to DM  system by' + $ 
                                                    ' t_geo_to_dm'
      t_geo_to_dm, g1,g2,g3,grlat,grlon,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '              come back to GEO system by t_dm_to_geo'
      t_dm_to_geo, v1,v2,v3,grlat,grlon,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      cp_angle_and_ratio, g1,g2,g3,w1,w2,w3,a,ra
      PRINT, FORMAT=fmt150, 'difference beetween first GEO vector:',a*d,ra


      PRINT
      PRINT, FORMAT=fmt100, '4) t# 18 converts GEO system to VDH system by' + $ 
                                                   ' t_geo_to_vdh'
      t_geo_to_vdh, g1,g2,g3,grlat,grlon,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '              come back to GEO system by t_vdh_to_geo'
      t_vdh_to_geo, v1,v2,v3,grlat,grlon,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      cp_angle_and_ratio, g1,g2,g3,w1,w2,w3,a,ra
      PRINT, FORMAT=fmt150, 'difference beetween first GEO vector:',a*d,ra

;      PRINT, FORMAT=fmt100, STRING(12B)
      PRINT
      PRINT, FORMAT=fmt100, 'F) LOCAL SPACECRAFT SYSTEMS TRANSFORMATIONS'
      PRINT, FORMAT=fmt100, '   ========================================'
      PRINT
      PRINT, FORMAT=fmt100, '    # 15    19     21    -21    -19    -15'
      PRINT, FORMAT=fmt100, '  GEO -> GSE -> SR2 -> SR -> SR2 -> GSE -> GEO'
      PRINT
      PRINT
      PRINT, FORMAT=fmt100, '   input choosed test vector in GEO system :'
      PRINT
      PRINT, FORMAT=fmt130, g1,gr,g2,gtet*d,g3,gphi*d

      PRINT
      PRINT, FORMAT=fmt100, '   input choosed spin axis in GSE system :'
      PRINT
      PRINT, FORMAT=fmt130, sa1,sar,sa2,sat*d,sa3,sap*d

      PRINT
      PRINT, FORMAT=fmt100, '   input choosed Spin frequency, Spin phase, dt:'
      PRINT
      PRINT, FORMAT=fmt111, '         Spin frequency= ',spifre,   ' Hz'
      PRINT, FORMAT=fmt111, '         Spin phase    = ',spipha*d, ' deg.'
      PRINT, FORMAT=fmt111, '         delta T       = ',deltaT,   ' sec.'
      PRINT

      PRINT
      PRINT, FORMAT=fmt100, '1) t# 15 converts GEO system to GSE system by' + $ 
                                                   ' t_geo_to_gse'
      t_geo_to_gse, g1,g2,g3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      PRINT
      PRINT, FORMAT=fmt100, '2) t# 19 converts GSE system to SR2 system by' + $ 
                                                   ' t_gse_to_sr2'
      t_gse_to_sr2, w1,w2,w3,sa1,sa2,sa3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d


      PRINT
      PRINT, FORMAT=fmt100, '3) t#-21 converts SR2 system to SR  system by' + $ 
                                                    ' t_sr2_to_sr'
      t_sr2_to_sr, v1,v2,spifre,spipha,deltaT,w1,w2
      w3=v3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d


      PRINT
      PRINT, FORMAT=fmt100, '4) t# 21 converts SR  system to SR2 system by' + $ 
                                                    ' t_sr_to_sr2'
      t_sr_to_sr2, w1,w2,spifre,spipha,deltaT,v1,v2
      v3=w3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d


      PRINT
      PRINT, FORMAT=fmt100, '5) t#-19 converts SR2 system to GSE system by' + $ 
                                                   ' t_sr2_to_gse'
      t_sr2_to_gse, v1,v2,v3,sa1,sa2,sa3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d


      PRINT
      PRINT, FORMAT=fmt100, '6) t#-15 converts GSE system to GEO system by' + $ 
                                                   ' t_gse_to_geo'
      t_gse_to_geo, w1,w2,w3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      cp_angle_and_ratio, g1,g2,g3,v1,v2,v3,a,ra
      PRINT, FORMAT=fmt150, 'difference beetveen first GEO wector:',a*d,ra

      PRINT
      PRINT
      PRINT, FORMAT=fmt100, 'G) MAGNETIC FIELD ALIGNED TRANSFORMATION'
      PRINT, FORMAT=fmt100, '   ======================================'
      PRINT
      PRINT, FORMAT=fmt100, '  GSE -> MFA'
      PRINT, FORMAT=fmt100, '  SR2 -> MFA'

      PRINT
      PRINT, FORMAT=fmt100, '   input choosed test vector in GSE system :'
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      PRINT
      PRINT, FORMAT=fmt100, '   input choosed DC mag. field in GSE system :'
      b1=30.
      b2=50.
      b3=200.
      t_car_to_sph, b1,b2,b3,br,bt,bp
      PRINT
      PRINT, FORMAT=fmt130, b1,br,b2,bt*d,b3,bp*d

      PRINT
      PRINT
      PRINT, FORMAT=fmt100, '1) t# 22 converts GSE system to MFA system by' + $ 
                                                   ' t_gse_to_mfa'
      t_gse_to_mfa, w1,w2,w3,b1,b2,b3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '   input choosed test vector in SR2 system :'
      t_gse_to_sr2, w1,w2,w3,sa1,sa2,sa3,v1,v2,v3
      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '   input choosed DC mag. field in SR2 system :'
      t_gse_to_sr2, b1,b2,b3,sa1,sa2,sa3,bs1,bs2,bs3
      t_car_to_sph, bs1,bs2,bs3,bsr,bst,bsp
      PRINT
      PRINT, FORMAT=fmt130, bs1,bsr,bs2,bst*d,bs3,bsp*d

      PRINT
      PRINT, FORMAT=fmt100, '2) t# 20 converts SR2 system to MFA system by' + $ 
                                                   ' t_sr2_to_mfa'
      t_sr2_to_mfa, v1,v2,v3,bs1,bs2,bs3,sa1,sa2,sa3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

;      PRINT, FORMAT=fmt100, STRING(12B)
      PRINT
      PRINT, FORMAT=fmt100, 'H) PSEUDO-MAGNETOPAUSE SYSTEMS'
      PRINT, FORMAT=fmt100, '   ==========================='
      PRINT
      PRINT, FORMAT=fmt100, '       GSE ----> TPN'
      PRINT, FORMAT=fmt100, '       GSM ----> TPN'

      PRINT
      PRINT, FORMAT=fmt100, '1) Computation of the TPN system'

      PRINT
      PRINT, FORMAT=fmt100, '   Input position in GSE system, in RE:'
      PRINT, FORMAT=fmt100, '   (supposed to be on the magnetopause)'

      xo= 5.72
      yo= 8.23
      zo= 9.22

      PRINT
      PRINT, FORMAT=fmt112, '   Xo, Yo, Zo in GSE =',xo,yo,zo

      xs= 12.0

      PRINT
      PRINT, FORMAT=fmt112, '   abcisse of subsolar point for paraboloid model:',xs

      cp_tpn_param, xo,yo,zo,xs, Tx,Ty,Tz, Px,Py,Pz, Nx,Ny,Nz

      PRINT
      PRINT, FORMAT=fmt100, '   TPN vectors in GSE:'
      PRINT
      PRINT, FORMAT=fmt112, '   Tx,Ty,Tz=', Tx,Ty,Tz
      PRINT, FORMAT=fmt112, '   Px,Py,Pz=', Px,Py,Pz
      PRINT, FORMAT=fmt112, '   Nx,Ny,Nz=', Nx,Ny,Nz
      PRINT, FORMAT=fmt100, ' '

      PRINT
      PRINT, FORMAT=fmt100, '   input choosed test vector in GSE system :'

      v1=Nx
      v2=Ny
      v3=Nz

      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT, FORMAT=fmt100, ' '
      PRINT, FORMAT=fmt100, '2) t# 23 convert GSE system to TPN system by' + $ 
                                                  ' t_gse_to_tpn'

      t_gse_to_tpn, v1,v2,v3,xo,yo,zo,xs,w1,w2,w3

      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      PRINT, FORMAT=fmt100, ' '
      PRINT, FORMAT=fmt100, '3) t# 9 convert GSE system to GSM system by' + $ 
                                                 ' t_gse_to_gsm'

      t_gse_to_gsm, v1,v2,v3,w1,w2,w3
      t_car_to_sph, w1,w2,w3,wr,wt,wp
      PRINT
      PRINT, FORMAT=fmt130, w1,wr,w2,wt*d,w3,wp*d

      PRINT, FORMAT=fmt100, ' '
      PRINT, FORMAT=fmt100, '4) t# 9 convert GSE position of S/C to GSM position'

      t_gse_to_gsm, xo,yo,zo,xm,ym,zm

      PRINT
      PRINT, FORMAT=fmt112, '   Xo, Yo, Zo in GSM =',xm,ym,zm

      PRINT, FORMAT=fmt100, ' '
      PRINT, FORMAT=fmt100, '5) t# 24 convert GSM system to TPN system by' + $ 
                                                  ' t_gsm_to_tpn'

      t_gsm_to_tpn, w1,w2,w3,xm,ym,zm,xs,v1,v2,v3

      t_car_to_sph, v1,v2,v3,vr,vt,vp
      PRINT
      PRINT, FORMAT=fmt130, v1,vr,v2,vt*d,v3,vp*d

      PRINT
      PRINT, FORMAT=fmt100, '==============================='
      PRINT, FORMAT=fmt100, 'END OF rocot_check test program'
      PRINT, FORMAT=fmt100, '==============================='

      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
