      PRO rocot_check_mva, in_file, out_dir

;     ***************************************************************0**
; *   Rocot_Check_MVA: PRO de test des modules varmin de le rocotlib

;     calcul la base (vecteurs propres de la matrice de variance
;     d'un signal bx,by,bz

;     P. Robert, aout 2001
;     ***************************************************************0**

      nbp=1000
      
      bx=FLTARR(nbp)
      by=FLTARR(nbp)
      bz=FLTARR(nbp)
      
      var =FLTARR(3,3)
      valp=FLTARR(3)
      vecp=FLTARR(3,3)
      

      fmt100="(3(e14.5))"
      fmt200="(a)"
      fmt300="(i8)"

      PRINT
      PRINT, FORMAT=fmt200, '======================='
      PRINT, FORMAT=fmt200, 'rocot_check_mva program'
      PRINT, FORMAT=fmt200, '======================='
      PRINT

; *** chargement d'un signal test

      sigtest, bx,by,bz,nbp, in_file

; *** ouverture du fichier resu et chargement du signal d'entree

;     pas de write dans la version demo, donc astuce:
;     on met tout dans un tableau et on fait un SPAWN echo

;     OPENW, 1,FILEPATH('rocot_check_mva.resu')

      CD, out_dir

      resu=STRARR(2*nbp+5)
      lines=0

      writ_para_tube, lines, resu

;     PRINT, 1, FORMAT='(a)', 'Input signal:'
;     PRINT, 1, FORMAT=fmt300,nbp
      lines=lines+1
      resu(lines)='Input signal:'
      lines=lines+1
      resu(lines)=STRING(nbp,FORMAT=fmt300)
      
      FOR i=0,nbp-1 DO BEGIN
;     PRINT, 1, FORMAT=fmt100,bx(i),by(i),bz(i)
      lines=lines+1
      resu(lines)=STRING( bx(i),by(i),bz(i),FORMAT=fmt100)
      ENDFOR

; *** calcul de variance du signal:
;     calcul de la matrice de variance, des  valeurs propres et
;     des vecteurs propres ; verification de l'orthogonalite
;     et du sens de la base trouvee, et passage des donnees
;     dans cette nouvelle base si icrep NE 0.

      icrep=1

      mat_cp_varmin, 6, bx,by,bz,nbp,icrep,var,valp,vecp

; *** ecriture du signal dans la base de la variance

;     PRINT, 1, FORMAT='(a)', '-------------------------------------'
;     PRINT, 1, FORMAT='(a)', 'MVA signal:'
      lines=lines+1
      resu(lines)='-------------------------------------'
      lines=lines+1
      resu(lines)='MVA signal:'

      FOR i=0,nbp-1 DO BEGIN
      lines=lines+1
;     PRINT, 1, FORMAT=fmt100,bx(i),by(i),bz(i)
      resu(lines)=STRING(bx(i),by(i),bz(i),FORMAT=fmt100)
      ENDFOR

; *** fermeture du fichier resultat

;      close, 1


      PRINT, FORMAT=fmt200, ' '
      PRINT, FORMAT=fmt200, 'Input signal and MVA coord. syst. signal are in ' +$ 
              'rocot_check_mva.resu file'
      PRINT
      PRINT, FORMAT=fmt200, '======================='
      PRINT, FORMAT=fmt200, 'end of rocot_check_mva '
      PRINT, FORMAT=fmt200, '======================='

;     le contenu de rocot_check_mva.resu est en une seule ligne
;     a la fin du fichier out; separateur de lignes: '|'

      tot=STRJOIN(resu,'xxx')
      PRINT, tot

      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO sigtest, bx,by,bz,nbp, in_file

      COMMON tube,  grtube,pari,gjtube,tettu,phitu,gjxtu,gjytu,gjztu
      COMMON repaj,  modj

      read_para_tube, in_file

      dx=grtube/60. 

      PRINT
      PRINT, FORMAT=fmt200,'Computation of B vector along the trajectory'
      PRINT, FORMAT=fmt200,'--------------------------------------------'
      PRINT

      PRINT, FORMAT=fmt200, 'nb. of points=',nbp

      FOR i=0,nbp-1 DO BEGIN

         sx= float(i)*dx -10.*pari
         sy= -pari
         sz= 0.

         cal_b_tube, sx,sy,sz,bxi,byi,bzi,bmoy
         
         bx(i)=bxi
         by(i)=byi
         bz(i)=bzi

      ENDFOR

      fmt200="(a,i9)"
 
;     RETURN
      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

;     magsructlib: "magnetic structure libarary"
;                  bibliotheque de modules permettant le calcul
;                  du champ et de la densite de courant produit
;                  par une structure de courant telle un tube de courant
;                  a densite uniforme ou gaussienne.

;                  Biblioteque developpee pour les simulation CLUSTER
;                  Patrick ROBERT, CRPE, 1990-1995

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO read_para_tube, in_file

      COMMON tube,  grtube,pari,gjtube,tettu,phitu,gjxtu,gjytu,gjztu
      COMMON repaj,  modj


      OPENR, ifc, in_file, /GET_LUN

;     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^***
;     lecture des parametres du tube
;     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^***

      fmt100="(a1)"
      fmt200="(a)"
      fmt300="(f10.3)"
      
      PRINT, FORMAT=fmt200, ' '
      PRINT, FORMAT=fmt200, 'Current tube characteristics:'
      PRINT, FORMAT=fmt200, '-----------------------------'

      PRINT, FORMAT=fmt200, ' '
      PRINT, FORMAT=fmt200, 'Radius of the current tube, in km'
      READF, ifc,    grtube
      PRINT, FORMAT=fmt300,grtube

      PRINT, FORMAT=fmt200, ' '
      PRINT, FORMAT=fmt200, 'impact parameter (min dist to the curr. tube), in km'
      READF, ifc, pari
      PRINT, FORMAT=fmt300,pari

      PRINT, FORMAT=fmt200, ' '
      PRINT, FORMAT=fmt200, 'Current density, in A/km2'
      READF, ifc,    gjtube
      PRINT, FORMAT=fmt300,gjtube

      PRINT, FORMAT=fmt200, ' '
      PRINT, FORMAT=fmt200, 'Theta angle of the current direction/ given frame (d)'
      PRINT, FORMAT=fmt200, 'teta ?'
      READF, ifc,    tettu
      PRINT, FORMAT=fmt300,tettu

      PRINT, FORMAT=fmt200, ' '
      PRINT, FORMAT=fmt200, 'Phi   angle of the current direction/ given frame (d)'
      READF, ifc,    phitu
      PRINT, FORMAT=fmt300,phitu

      carsphe, gjtube,tettu,phitu,gjxtu,gjytu,gjztu
      
      modj=' '

      PRINT, FORMAT=fmt200, ' '
      PRINT, FORMAT=fmt200, 'Current density model ("u" or "g"/ uniform or gauss.)'
      READF, ifc, modj
      PRINT, modj
      PRINT

      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO writ_para_tube, lines, resu

      COMMON tube,  grtube,pari,gjtube,tettu,phitu,gjxtu,gjytu,gjztu
      COMMON repaj,  modj

;     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^***
;     ecriture des parametres du tube
;     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^***

      fmt100="(' R=',f8.1,' km  IP=',f8.1,' km J=',f6.3,' A/km2  tet=', " +$ 
             "f5.1,' d.  phi=',f5.1,' d. mod=',a)"
     
;     PRINTF, ifc, FORMAT=fmt100, grtube, pari, gjtube, tettu, phitu, modj  
; % PRINTF: Feature disabled for demo mode.
   

  ss=STRING(grtube, pari, gjtube, tettu, phitu, modj, FORMAT=fmt100)
      resu(0)=ss
      lines=0

;     RETURN
      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO cal_b_tube, xs,ys,zs,bxs,bys,bzs,bmod

      COMMON tube,  grtube,pari,gjtube,tettu,phitu,gjxtu,gjytu,gjztu
      COMMON repaj,  modj

;     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^***
;     calcul de B dans le repere structure
;     repere structure=repere ou le tube est oblique
;     COMMON /tube/=axe et module de J dans le repere structure
;     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^***

      pi=ACOS(-1.)
;     valeur de Mu0 en nT*km/A
;     rmu=4.*pi*(1.e-7)*(1.e6)
;     c=Mu0*J/2
      c=0.2*pi*gjtube


; *** passage au repere tube incline par rapport au repere structure

      xybvdh, xs,ys,zs,gjxtu,gjytu,gjztu,x,y,z

      r2=x*x+y*y
      gr2=grtube*grtube


      IF(STRMID(modj,0,1)NE 'u' AND STRMID(modj,0,1)NE 'g') THEN $ 
               MESSAGE, /NONAME, /NOPREFIX, 'CAL_B_TUBE     *** ABORTED ! UNDEFINED MODEL OF J'

      IF(STRMID(modj,0,1)EQ 'u') THEN BEGIN

; *** densite uniforme

          IF(r2 GE gr2) THEN BEGIN
                        bx=-c*gr2*y/r2
                        by= c*gr2*x/r2
                        bz=0.

                        ENDIF ELSE BEGIN
                        bx=-c*y
                        by= c*x
                        bz= 0.
          ENDELSE

      ENDIF ELSE BEGIN

; *** densite gaussienne

      rsr2=r2/gr2

      bx=-c*(1./rsr2)*(1.-exp(-rsr2))*y
      by= c*(1./rsr2)*(1.-exp(-rsr2))*x
      bz= 0.

;     um=1.06
;     rm=SQRT(um)*grtube
;     bmax=c*rm*(1.-exp(-um))/um

      ENDELSE

      bmod=SQRT(bx*bx+by*by+bz*bz)

; *** passage au repere structure

      vdhxyb, bx,by,bz,gjxtu,gjytu,gjztu,bxs,bys,bzs

;     RETURN
      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO cal_j_tube, xs,ys,zs,xsj,ysj,zsj,rsj

      COMMON tube,  grtube,pari,gjtube,tettu,phitu,gjxtu,gjytu,gjztu
      COMMON repaj,  modj

;     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^***
;     calcul de J dans le repere structure
;     repere structure=repere ou le tube est oblique
;     COMMON /tube/=axe et module de J dans le repere structure
;     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^***


; *** passage au repere tube

      xybvdh, xs,ys,zs,gjxtu,gjytu,gjztu,x,y,z

      r=SQRT(x*x+y*y)

      IF(STRMID(modj,0,1)NE 'u' AND STRMID(modj,0,1)NE 'g') THEN $ 
               MESSAGE, /NONAME, /NOPREFIX, 'CAL_B_TUBE     *** ABORTED ! UNDEFINED MODEL OF J'

      IF(STRMID(modj,0,1)EQ 'u') THEN BEGIN

; *** modele uniforme

          IF(r GT grtube) THEN BEGIN
                          xj=0.
                          yj=0.
                          zj=0.
; 
                          ENDIF ELSE BEGIN
                          xj=0.
                          yj=0.
                          zj=gjtube
                          ENDELSE

      ENDIF ELSE BEGIN

; *** modele gaussien

      xj=0.
      yj=0.
      zj=gjtube*exp(-(r/grtube)^2)

      ENDELSE
      
      rsj=SQRT(xj*xj+yj*yj+zj*zj)

; *** passage au repere structure

      vdhxyb, xj,yj,zj,gjxtu,gjytu,gjztu,xsj,ysj,zsj

;     RETURN
      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO carsphe, r,tet,phi,x,y,z

;     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
;     auteur   :p. robert
;     categorie:astronomie et changement de base
;     objet    :conversion de coordonnees spheriques en cartesiennes
;     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

      pp=3.1415926/180.

      x=r*SIN(tet*pp)*COS(phi*pp)
      y=r*SIN(tet*pp)*SIN(phi*pp)
      z=r*COS(tet*pp)

;     RETURN
      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO sincosp, x,y,z,st,ct,sp,cp

;     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
;     auteur   :p. robert
;     categorie:astronomie et changement de base
;     objet    :sin et cos des angles polaires d"un vecteur cartesien
;     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

      r=SQRT(x*x+y*y+z*z)

      ct=z/r
      IF(abs(ct) GT 1.) THEN BEGIN
      MESSAGE, /NONAME, /NOPREFIX, 'SINCOSP        *** ABORTED ! ERROR 1'
      ENDIF
      
      st=SQRT(1.-ct*ct)
      IF(abs(st) GT 1.) THEN BEGIN
      MESSAGE, /NONAME, /NOPREFIX, 'SINCOSP        *** ABORTED ! ERROR 2'
      ENDIF

      sp=0.
      cp=1.
      rp=SQRT(x*x+y*y)

      IF(rp LT 1.e-30) THEN RETURN
      sp=y/(rp)
      IF(abs(sp) GT 1.) THEN BEGIN
      MESSAGE, /NONAME, /NOPREFIX, 'SINCOSP        *** ABORTED ! ERROR 3'
      ENDIF
      
      cp=x/(rp)
      IF(abs(cp) GT 1.) THEN BEGIN
      MESSAGE, /NONAME, /NOPREFIX, 'SINCOSP        *** ABORTED ! ERROR 4'
      ENDIF

;     RETURN
      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO vdhxyb, x,y,b,bv,bd,bh,v,d,h

;     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
;     auteur   :p. robert
;     categorie:astronomie et changement de base
;     objet    :passage du repere ligne de force au repere vdh
;     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

;      input=x,y,b avec axe x dans le plan du meridien magnetique
;      output=v,d,h

      sincosp, bv,bd,bh,st,ct,sp,cp

      stv=SQRT(1.-cp*cp*st*st)
      IF(stv GT 1.e-30) THEN BEGIN
                        spv=-sp/stv
                        cpv=cp*ct/stv

                        ENDIF ELSE BEGIN
                        spv=0.
                        cpv=1.
                        ENDELSE

      b1=cpv*x -spv*y
      b2=spv*x +cpv*y
      b3=b

      v= cp*ct*b1 -sp*b2 +cp*st*b3
      d= sp*ct*b1 +cp*b2 +sp*st*b3
      h=-st*b1 +ct*b3

;     RETURN
      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO xybvdh, v,d,h,bv,bd,bh,x,y,b

;     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
;     auteur   :p. robert
;     categorie:astronomie et changement de base
;     objet    :passage du repere vdh au repere ligne de force
;     ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^

;      input=v,d,h
;      output=x,y,b
;             x est dans le plan du meridien magnetique


      sincosp, bv,bd,bh,st,ct,sp,cp

      b1= ct*cp*v +ct*sp*d -st*h
      b2=-sp*v +cp*d
      b3= st*cp*v +st*sp*d +ct*h

      stv=SQRT(1.-cp*cp*st*st)
      IF(stv GT 1.e-30 ) THEN BEGIN
                         spv=-sp/stv
                         cpv=cp*ct/stv

                         ENDIF ELSE BEGIN
                         spv=0.
                         cpv=1.
                         ENDELSE

      x= cpv*b1 +spv*b2
      y=-spv*b1 +cpv*b2
      b=b3

;     RETURN
      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

