      PRO rocot_example, in_file
;
;     ***************************************************************0**
; *   Rocot_Example: show example of Rocotlib use.
;     P. Robert, July 2000                                       
;     ***************************************************************0**
;
;
      fmt100="(a,3i6)"
      fmt200="(a,3f14.6)"
      fmt300="(a,3f14.4)"
;
      PRINT
      PRINT, FORMAT=fmt100, '*****************************************************'
      PRINT
      PRINT, FORMAT=fmt100, 'ROCOTEXP:'
      PRINT
;
      OPENR, ifc, in_file, /GET_LUN

      r_datef, ifc, iyear,imonth,iday
      r_timef, ifc, ih,im,is
      cv_date_to_doty, iyear,imonth,iday,idoy
;
      PRINT
      PRINT, FORMAT=fmt100, 'date: MM/JJ/YY =', imonth,iday,iyear
      PRINT, FORMAT=fmt100, 'time: HH/MM/SS =', ih,im,is
      PRINT, FORMAT=fmt100, 'day of the year=', idoy
;
      cp_time_param, iyear,imonth,iday,ih,im,is
      g_gei_geo_sun_dir, sxgei,sygei,szgei,sxgeo,sygeo,szgeo
      t_gei_to_gsm, sxgei,sygei,szgei,sxgsm,sygsm,szgsm
;
      PRINT
      PRINT, FORMAT=fmt200, 'Sun in GEI:',sxgei,sygei,szgei
      PRINT, FORMAT=fmt200, 'Sun in GEO:',sxgeo,sygeo,szgeo
      PRINT, FORMAT=fmt200, 'Sun in GSM:',sxgsm,sygsm,szgsm
;
      g_gei_geo_dipole_dir, dxgei,dygei,dzgei,dxgeo,dygeo,dzgeo
      t_gei_to_gsm, dxgei,dygei,dzgei,dxgsm,dygsm,dzgsm
      t_gei_to_mag, dxgei,dygei,dzgei,dxmag,dymag,dzmag
      t_gei_to_sm, dxgei,dygei,dzgei,dxsma,dysma,dzsma
;
      PRINT
      PRINT, FORMAT=fmt200, 'Dip in GEI:',dxgei,dygei,dzgei
      PRINT, FORMAT=fmt200, 'Dip in GEO:',dxgeo,dygeo,dzgeo
      PRINT, FORMAT=fmt200, 'Dip in GSM:',dxgsm,dygsm,dzgsm
      PRINT, FORMAT=fmt200, 'Dip in MAG:',dxmag,dymag,dzmag
      PRINT, FORMAT=fmt200, 'Dip in SM :',dxsma,dysma,dzsma
;
      PRINT
      PRINT, FORMAT=fmt300, 'xyz in GEO=', -5.5, -12.5, -7.10
;
      t_geo_to_gsm, -5.5, -12.5, -7.10,xgsm,ygsm,zgsm
      t_geo_to_gse, -5.5, -12.5, -7.10,xgse,ygse,zgse
;
      PRINT, FORMAT=fmt300, 'xyz in GSM:', xgsm, ygsm, zgsm
      PRINT, FORMAT=fmt300, 'xyz in GSE:', xgse, ygse, zgse
;
      PRINT
      PRINT, FORMAT=fmt100, '*****************************************************'
      PRINT

      END
