      PRO rocot_utility, in_file 

;     ***************************************************************0*
; *   Rocot_Utility : tranform a file of time tagged vectors
;                     given in sys1 to sys2
;     P. Robert, Jan 2008
;     ***************************************************************0*

      fmt100="(a,3i6)"
      header=STRARR(6)
      allowed=STRARR(7)
      allowed=[ 'geo','gei','gsq','gse','gsm','sma','mag']
      line=' '

      PRINT
      PRINT, FORMAT=fmt100, '****************************************************'
      PRINT
      PRINT, FORMAT=fmt100, 'rocot_utility:'
      PRINT

      rep1='XXX'
      rep2='YYY'

; *** ouverture de fichier input

      OPENR, ifc, in_file, /GET_LUN

      file1=' '
      file2=' '

      PRINT, 'file to read? (ex:in/CLUFGM1-gse.txt)'
      READF, ifc,  line
      file1=FILE_DIRNAME(in_file)+'\'+STRTRIM(line)
      PRINT, 'file to read=',file1

      OPENR, ifc2,file1, /GET_LUN

; *** lecture du repere

      irep=0

      FOR  i=1,6 DO BEGIN
      READF,ifc2,FORMAT='(a)', line
      PRINT,line
      header(i-1)=line
      IF(STRMID(line, 0,28) EQ '# CHA : COORDINATE_SYSTEM : ')  THEN BEGIN
                                        READS,line,FORMAT='(28x,a3)', rep1
                                             irep=i
                                             PRINT, 'irep=',irep
      ENDIF 
      ENDFOR

      IF(irep EQ 0) THEN BEGIN
        PRINT, '*** bad metadata'
        PRINT, '"# CHA : COORDINATE_SYSTEM :" not found'
        CLOSE,1
        MESSAGE, /NONAME, /NOPREFIX, 'rocot_utility.exe: bad metadata, aborted'
      ENDIF

; *** conversion eventuelle en minuscule

      rep1=STRLOWCASE(rep1)

      PRINT, 'input  coordinate system :', rep1

      testrep, rep1,allowed

      PRINT, 'output coordinate system ? (ex: gsm)'
      READF, ifc, rep2
      PRINT, STRTRIM(rep2)

      PRINT, 'output file ? (ex: CLUFGM1-gsm.txt)'
      READF, ifc,  file2
      PRINT, STRTRIM(file2)

      testrep, rep2,allowed

;      OPENW, 2,FILEPATH(file2) !!!! IDL demo, pas de write file...
      header(irep-1)='# CHA : COORDINATE_SYSTEM : '+STRUPCASE(rep2)

      FOR  i=1,6 DO BEGIN
;     PRINTF, 2, STRTRIM(header(i-1))
      PRINT, FORMAT='(a)', STRTRIM(header(i-1))
      ENDFOR

; *** lecture et traitement de chaque vecteur

      WHILE NOT EOF(ifc2) DO BEGIN
        READF,ifc2, line
        IF(STRMID(line, 4,1) NE '-' OR STRMID(line, 7,1) NE '-' $
        OR STRMID(line,10,1) NE 'T' OR STRMID(line,13,1) NE ':' $
        OR STRMID(line,16,1) NE ':' OR STRMID(line,19,1) NE '.' $
        OR STRMID(line,23,1) NE 'Z') THEN BEGIN
           PRINT, 'date/time field=', STRMID(line,0,24)
           PRINT, '*** date/time field is not in ISO format'
           PRINT, '    ex: 2003-08-17T16:33:07.000Z'
           PRINT, '    PRO aborted !!!'
         ENDIF


;    lecture du vecteur et de son temps

     READS,line,FORMAT='(i4,5(1x,i2))', iyear,imonth,iday,ih,im,is
     READS,STRMID(line,24,127), Ux,Uy,Uz

;    initialisation des matrices

      cp_time_param, iyear,imonth,iday,ih,im,is

;    tranformation dans le repere souhaite

; *   transformations possibles: geo gei gsq gse gsm sma mag
;     toutes les combinaisons sont:

;     geogei geogsq geogse geogsm geosma geomag
;     geigeo gsqgeo gsegeo gsmgeo smageo maggeo

;     geigsq geigse geigsm geisma geimag
;     gsqgei gsegei gsmgei smagei maggei

;     gsqgse gsqgsm gsqsma gsqmag
;     gsegsq gsmgsq smagsq maggsq

;     gsegsm gsesma gsemag
;     gsmgse smagse maggse

;     gsmsma gsmmag
;     smagsm maggsm

;     smmag
;     magsma

      subname=rep1+rep2

; *   les IF de la mort:...

      IF(subname EQ 'geogei') THEN t_geo_to_gei, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'geogsq') THEN t_geo_to_gseq, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'geogse') THEN t_geo_to_gse, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'geogsm') THEN t_geo_to_gsm, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'geosma') THEN t_geo_to_sm, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'geomag') THEN t_geo_to_mag, Ux,Uy,Uz,Vx,Vy,Vz

      IF(subname EQ 'geigeo') THEN t_gei_to_geo, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'gsqgeo') THEN t_gseq_to_geo, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'gsegeo') THEN t_gse_to_geo, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'gsmgeo') THEN t_gsm_to_geo, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'smageo') THEN t_sm_to_geo, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'maggeo') THEN t_mag_to_geo, Ux,Uy,Uz,Vx,Vy,Vz


      IF(subname EQ 'geigsq') THEN t_gei_to_gseq, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'geigse') THEN t_gei_to_gse, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'geigsm') THEN t_gei_to_gsm, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'geisma') THEN t_gei_to_sm, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'geimag') THEN t_gei_to_mag, Ux,Uy,Uz,Vx,Vy,Vz

      IF(subname EQ 'gsqgei') THEN t_gseq_to_gei, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'gsegei') THEN t_gse_to_gei, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'gsmgei') THEN t_gsm_to_gei, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'smagei') THEN t_sm_to_gei, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'maggei') THEN t_mag_to_gei, Ux,Uy,Uz,Vx,Vy,Vz


      IF(subname EQ 'gsqgse') THEN t_gseq_to_gse, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'gsqgsm') THEN t_gseq_to_gsm, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'gsqsma') THEN t_gsq_to_sm, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'gsqmag') THEN t_gsq_to_mag, Ux,Uy,Uz,Vx,Vy,Vz

      IF(subname EQ 'gsegsq') THEN t_gse_to_gseq, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'gsmgsq') THEN t_gsm_to_gseq, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'smagsq') THEN t_sm_togsq, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'maggsq') THEN t_mag_to_gsq, Ux,Uy,Uz,Vx,Vy,Vz


      IF(subname EQ 'gsegsm') THEN t_gse_to_gsm, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'gsesma') THEN t_gse_to_sm, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'gsemag') THEN t_gse_to_mag, Ux,Uy,Uz,Vx,Vy,Vz

      IF(subname EQ 'gsmgse') THEN t_gsm_to_gse, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'smagse') THEN t_sm_to_gse, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'maggse') THEN t_mg_to_gse, Ux,Uy,Uz,Vx,Vy,Vz


      IF(subname EQ 'gsmsma') THEN t_gsm_to_sm, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'gsmmag') THEN t_gsm_to_mag, Ux,Uy,Uz,Vx,Vy,Vz

      IF(subname EQ 'smagsm') THEN t_sm_to_gsm, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'maggsm') THEN t_mag_to_gsm, Ux,Uy,Uz,Vx,Vy,Vz


      IF(subname EQ 'smamag') THEN t_sm_to_mag, Ux,Uy,Uz,Vx,Vy,Vz
      IF(subname EQ 'magsma') THEN t_mag_to_sm, Ux,Uy,Uz,Vx,Vy,Vz

;     ecriture des resultats: on le fait sur stdout car IDL demo, pas de write file...

      PRINT, FORMAT='(a,3(e15.5))', STRMID(line,0,23), Vx,Vy,Vz

;     rebelote...
      ENDWHILE

      CLOSE,1

      PRINT
      PRINT, FORMAT=fmt100, '****************************************************'
      PRINT

      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO testrep, rep,allowed


      fmt100="(a,/,7a)"

      FOR i=1,7 DO BEGIN
      IF(rep EQ allowed(i-1)) THEN RETURN
      ENDFOR

      PRINT, '*** ',rep,' is not allowed'
      PRINT, FORMAT=fmt100, 'allowed coordinates are ', allowed
      MESSAGE, /NONAME, /NOPREFIX, '   PRO aborted'

      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO t_sm_to_gse, x1,y1,z1,x2,y2,z2

      t_sm_to_gsm, x1,y1,z1,x3,y3,z3
      t_gsm_to_gse, x3,y3,z3,x2,y2,z2

      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO t_gse_to_sm, x1,y1,z1,x2,y2,z2

      t_gse_to_gsm, x1,y1,z1,x3,y3,z3
      t_gsm_to_sm, x3,y3,z3,x2,y2,z2

      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO t_mg_to_gse, x1,y1,z1,x2,y2,z2

      t_mag_to_sm, x1,y1,z1,x3,y3,z3
      t_sm_to_gse, x3,y3,z3,x2,y2,z2

      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO t_gse_to_mag, x1,y1,z1,x2,y2,z2

      t_gse_to_sm, x1,y1,z1,x3,y3,z3
      t_sm_to_mag, x3,y3,z3,x2,y2,z2

      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO t_sm_togsq, x1,y1,z1,x2,y2,z2

      t_sm_to_gsm, x1,y1,z1,x3,y3,z3
      t_gsm_to_gseq, x3,y3,z3,x2,y2,z2

      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO t_gsq_to_sm, x1,y1,z1,x2,y2,z2

      t_gseq_to_gsm, x1,y1,z1,x3,y3,z3
      t_gsm_to_sm, x3,y3,z3,x2,y2,z2

      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO t_mag_to_gsq, x1,y1,z1,x2,y2,z2

      t_mag_to_sm, x1,y1,z1,x3,y3,z3
      t_sm_togsq, x3,y3,z3,x2,y2,z2

      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      PRO t_gsq_to_mag, x1,y1,z1,x2,y2,z2

      t_gsq_to_sm, x1,y1,z1,x3,y3,z3
      t_sm_to_mag, x3,y3,z3,x2,y2,z2

      END

;     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX



