      PRO test_dir_sun, in_file

;     ***************************************************************0**
; *   Test_Dir_Sun: Sun direction in various coordinate systems
;     P. Robert, CETP, June 2001 ; use Rocotlib library                                  
;     ***************************************************************0**


      PRINT
      PRINT, FORMAT=fmt200, '*****************************************************'
      PRINT
      PRINT, FORMAT=fmt200, 'Sun direction in various coordinate systems'
      PRINT
; 
; *   reading date and time & compute general matrix

      OPENR, ifc, in_file, /GET_LUN
      
      r_datef, ifc, iyear,imonth,iday
      r_timef, ifc, ih,im,is
      cp_time_param, iyear,imonth,iday,ih,im,is

      fmt100="(a,4a10  ,2a10  )"
      fmt200="(a,4f10.3,2f10.3)"
      fmt300="(a,3I5)"
      
; *   reading position of point of observation in GEO

      PRINT, FORMAT=fmt200, 'latitude, longitude, distance in GEO ? (deg & any u.)'
      READF, ifc, rlageo, rlogeo,rdis
      PRINT, FORMAT=fmt200, ' ',rlageo, rlogeo,rdis

      rlagr=rlageo*3.1415927/180.
      rlogr=rlogeo*3.1415927/180.
      teta=(90.-rlageo)*3.1415927/180.

; *   geographic cartesian coordinates

      t_sph_to_car, rdis,teta,rlogr,xgeo,ygeo,zgeo

; *   same in other systems

      t_geo_to_gei, xgeo,ygeo,zgeo,xgei,ygei,zgei
      t_geo_to_gse, xgeo,ygeo,zgeo,xgse,ygse,zgse
      t_geo_to_gsm, xgeo,ygeo,zgeo,xgsm,ygsm,zgsm
      t_geo_to_vdh, xgeo,ygeo,zgeo,rlagr,rlogr,xvdh,yvdh,zvdh

; *   latitude, longitude in other systems

      t_car_to_sph, xgeo,ygeo,zgeo,r,tetgeo,phigeo
      t_car_to_sph, xgei,ygei,zgei,r,tetgei,phigei
      t_car_to_sph, xgse,ygse,zgse,r,tetgse,phigse
      t_car_to_sph, xgsm,ygsm,zgsm,r,tetgsm,phigsm
      t_car_to_sph, xvdh,yvdh,zvdh,r,tetvdh,phivdh

      colalon, tetgeo,phigeo,rlageo,rlogeo
      colalon, tetgei,phigei,rlagei,rlogei
      colalon, tetgse,phigse,rlagse,rlogse
      colalon, tetgsm,phigsm,rlagsm,rlogsm
      colalon, tetvdh,phivdh,rlavdh,rlovdh

      PRINT,' _________________________________________________________'
      PRINT
      PRINT, FORMAT=fmt300, 'date: YY/MM/JJ=', iyear,imonth,iday
      PRINT, FORMAT=fmt300, 'time: HH/MM/SS=', ih,im,is
      PRINT

      PRINT, FORMAT=fmt100, '            ','x','y','z','R','Lat','Long'
      PRINT

      PRINT, FORMAT=fmt200, 'Pos. in GEO :',xgeo,ygeo,zgeo, r,rlageo,rlogeo
      PRINT, FORMAT=fmt200, 'Pos. in GEI :',xgei,ygei,zgei, r,rlagei,rlogei
      PRINT, FORMAT=fmt200, 'Pos. in GSE :',xgse,ygse,zgse, r,rlagse,rlogse
      PRINT, FORMAT=fmt200, 'Pos. in GSM :',xgsm,ygsm,zgsm, r,rlagsm,rlogsm
      PRINT, FORMAT=fmt200, 'Pos. in VDH :',xvdh,yvdh,zvdh, r,rlavdh,rlovdh
; 
; *   Sun direction

      g_gei_geo_sun_dir, sxgei,sygei,szgei,sxgeo,sygeo,szgeo
      t_gei_to_gse, sxgei,sygei,szgei,sxgse,sygse,szgse
      t_gei_to_gsm, sxgei,sygei,szgei,sxgsm,sygsm,szgsm
      t_geo_to_vdh, sxgeo,sygeo,szgeo,rlagr,rlogr,sxvdh,syvdh,szvdh

      t_car_to_sph, sxgeo,sygeo,szgeo,rgeo,tetgeo,phigeo
      t_car_to_sph, sxgei,sygei,szgei,rgei,tetgei,phigei
      t_car_to_sph, sxgse,sygse,szgse,rgse,tetgse,phigse
      t_car_to_sph, sxgsm,sygsm,szgsm,rgsm,tetgsm,phigsm
      t_car_to_sph, sxvdh,syvdh,szvdh,rvdh,tetvdh,phivdh

      convdeg, tetgeo,phigeo
      convdeg, tetgei,phigei
      convdeg, tetgse,phigse
      convdeg, tetgsm,phigsm
      convdeg, tetvdh,phivdh

      PRINT
      PRINT, FORMAT=fmt200, 'Sun  in GEO :',sxgeo,sygeo,szgeo,  rgeo,tetgeo,phigeo
      PRINT, FORMAT=fmt200, 'Sun  in GEI :',sxgei,sygei,szgei,  rgei,tetgei,phigei
      PRINT, FORMAT=fmt200, 'Sun  in GSE :',sxgse,sygse,szgse,  rgse,tetgse,phigse
      PRINT, FORMAT=fmt200, 'Sun  in GSM :',sxgsm,sygsm,szgsm,  rgsm,tetgsm,phigsm
      PRINT, FORMAT=fmt200, 'Sun  in VDH :',sxvdh,syvdh,szvdh,  rvdh,tetvdh,phivdh
      PRINT
      PRINT
      PRINT, ' ********************************************************'
      PRINT
       
      END

;     ---------------------------------------------------------------0--

      PRO convdeg, x,y

      pisd=3.1415927/180.

      x=x/pisd
      y=y/pisd

;     RETURN
      END

;     ---------------------------------------------------------------0--

      PRO colalon, teta,phi,rlat,rlon

; *   compute lat and long in degres from teta, phi in radians

      pisd=3.1415927/180.

      rlat= 90. -teta/pisd
      rlon= phi/pisd

;     RETURN
      END

;     ---------------------------------------------------------------0--

