      PRO vdh_to_gse, in_file

;     ------------------------------------------------------------------

; *   Rocot_Example of using Rocotlib      
;                                   
;     ------------------------------------------------------------------

      PRINT
      PRINT, FORMAT=fmt100, '****************************************************'
      PRINT
      PRINT, FORMAT=fmt100, 'vdh_to_gse:'
      PRINT

      fmt100="(a, 3i5)"
      fmt200="(a, 3f10.5)"

      OPENR, ifc, in_file, /GET_LUN
      
      r_datef, ifc, iyear,imonth,iday
      r_timef, ifc, ih,im,is
       
      cp_time_param, iyear,imonth,iday,ih,im,is

      PRINT, FORMAT=fmt100, 'x,y,z in VDH ?'
      READF, ifc, xvdh,yvdh,zvdh

      PRINT, FORMAT=fmt100, 'lat et long en degre?'
      READF, ifc, rlat, rlon
      rlat=rlat*3.1415927/180.
      rlon=rlon*3.1415927/180.

      t_vdh_to_geo, xvdh,yvdh,zvdh,rlat,rlon,xgeo,ygeo,zgeo
      t_geo_to_gse, xgeo,ygeo,zgeo,xgse,ygse,zgse
       
      PRINT
      PRINT, FORMAT=fmt100, 'date: MM/JJ/YY=', imonth,iday,iyear
      PRINT, FORMAT=fmt100, 'time: HH/MM/SS=', ih,im,is
      PRINT
      PRINT, FORMAT=fmt200, 'xyz in VDH:', xvdh,yvdh,zvdh
      PRINT, FORMAT=fmt200, 'xyz in GEO:', xgeo,ygeo,zgeo
      PRINT, FORMAT=fmt200, 'xyz in GSE:', xgse,ygse,zgse
      PRINT
      PRINT, FORMAT=fmt200, '****************************************************'
      PRINT
       
      END
