
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;
  PRO visu_mva, out_dir
;
; Procedure de visualisation du fichier rocot_check_mva.resu
; Cree un fichier PostScript visu_mva.ps
;
; Patrick Robert, CETP, Septembre 2001, revu ScientiDev sep. 2020
; Necessite la Roplotlib_mini.pro
;
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

  PRINT
  PRINT, '-----------------------------------------------------------'
  PRINT, 'PRO visu_mva: visualisation du fichier rocot_check_mva.resu

; ======================================================================
; lecture des donnees
; ======================================================================

; ouverture du fichier de donnees type rocot_check_mva.resu


  DataFile = 'rocot_check_mva.resu'
  PRINT, 'Name of Data File=', DataFile

  CD, out_dir
  CD, current=pwd
  PRINT, 'pwd=',pwd

  OPENR, 1, DataFile, ERROR=ierr
 
  IF(ierr NE 0) THEN BEGIN 
      PRINT,'***/ NO FILE: ',DataFile
      MESSAGE, /NONAME, /NOPREFIX,'VISU_VARMIN    : ***ERR-NO DATA FILE'
;                PRINT, '*** visu_mva:  pas de fichier ', DataFile 
;                PRINT, '    arret brutal, pas de .ps'
 ;               STOP,  'visu_mva: pas de fichier de donne' 
                ENDIF
   
 
; lecture des donnees
; -------------------

  param=' '
  com=' '

  READF, 1, param
  READF, 1,com
  READF, 1, nbp

  PRINT, 'nbp=',nbp

  data= FLTARR(2,3,nbp)
  bloc= FLTARR(3,nbp)
 
; signal d'origine

  READF, 1, bloc

  data(0,0,*)= bloc(0,*)
  data(0,1,*)= bloc(1,*)
  data(0,2,*)= bloc(2,*)
  print, data(0,0,0),data(0,1,0),data(0,2,0)

; signal dans la base de la variance

  READF, 1,com
  READF, 1,com

  READF, 1, bloc

  data(1,0,*)= bloc(0,*)
  data(1,1,*)= bloc(1,*)
  data(1,2,*)= bloc(2,*)

  time=FINDGEN(nbp)/3600.
  t1=time(0)
  t2=time(nbp-1)

  bloc=0.

; cloture du fichier de donnees

  CLOSE, 1

; creation du fichier PostScript
; ------------------------------
 
  nomps= 'visu_mva.ps'
  expe='Result of rocot_check_mva'
  nbpan=2
  titpan=STRARR(nbpan)
  titpan(0)= 'Input signal'
  titpan(1)= 'Signal in MVA coordinates'
  nbcupan= [3,3]

  g_rocot_version_number,vernum,verdat
  jul00=-9999
  iday=' '
  imon=' '
  iyear='Test of Rocotlib version '+STRING(vernum, FORMAT='(f3.1)')
 
  creps, nomps,expe,jul00,iday,imon,iyear, $
         nbpan,nbcupan,titpan,time,data,t1,t2




  PRINT, 'visu_mva.pro: Normal Ending'
  PRINT, '--------------------------------'
  PRINT, STRING(7B)
  PRINT, STRING(7B)
  MESSAGE, /informational, /noname, /noprefix, $
         'VISUVARMIN         NORMAL TERMINATION'

  END

;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

  PRO creps, nomps,expe,jul00,iday,imon,iyear, $
             nbpan,nbcupan,titpan,time,data,t1,t2


; ======================================================================
; procedure creps_: creation du fichier PostScript pour le trace 
;                  des resultats de la mva
;
; P. Robert, CETP, Septembre 2001
; ======================================================================

; Mise en page
; ------------

  xpage = 18.
  ypage = 26.8
  maryh= 2.8
  maryb= 1.6
  ox=  2.4
  rx= 15.0

  dyc= 0.5
  dyp= 1.0

  signat=give_signat(' ','rocot_check_mva',nomps)

  sid=' '
  isat=0
  xtvt= 9.7

; ouverture du fichier .ps, avec mise en page pour pannels standards,
; cadre, titre et signature, pret pour recevoir les courbes a tracer

  crepagps, nomps,expe,jul00,iday,imon,iyear,t1,t2,signat,$
            xpage,ypage,maryh,maryb,ox,rx,nbpan,nbcupan, dyc,dyp,$
            x1,x2,y1,y2,ydc,ydp,xtickval, xtickgra, nbxti, nbxmi, xtvt

; trace des courbes
; -----------------

  xtit=' '
  xchasi= 0.001
  ychasi= 1.0
  laby=['Bx', 'By', 'Bz'] 


; *** Pannel 1

  tot= [data]
  ymi= MIN(tot,MAX=yma)

  plotcou,time,data(0,0,*),t1,t2,ymi,yma,titpan(0),xtit,laby(0), $
          x1,x2,y1,y2,ydc,xchasi,ychasi,xtickval,xtickgra,nbxti,nbxmi
  OPLOT, time,data(0,0,*), Color=0

  plotcou,time,data(0,1,*),t1,t2,ymi,yma,'       ',xtit,laby(1), $
          x1,x2,y1,y2,ydc,xchasi,ychasi,xtickval,xtickgra,nbxti,nbxmi
  OPLOT, time,data(0,1,*), Color=1

  plotcou,time,data(0,2,*),t1,t2,ymi,yma,'       ',xtit,laby(2), $
          x1,x2,y1,y2,ydp,xchasi,ychasi,xtickval,xtickgra,nbxti,nbxmi
  OPLOT, time,data(0,2,*), Color=2


; *** Pannel 2


  plotcou,time,data(1,0,*),t1,t2,ymi,yma,titpan(1),xtit,laby(0), $
          x1,x2,y1,y2,ydc,xchasi,ychasi,xtickval,xtickgra,nbxti,nbxmi
  OPLOT, time,data(1,0,*), Color=0

  plotcou,time,data(1,1,*),t1,t2,ymi,yma,'       ',xtit,laby(1), $
          x1,x2,y1,y2,ydc,xchasi,ychasi,xtickval,xtickgra,nbxti,nbxmi
  OPLOT, time,data(1,1,*), Color=1

  xchasi= 1.3

  plotcou,time,data(1,2,*),t1,t2,ymi,yma,'       ',xtit,laby(2), $
          x1,x2,y1,y2,ydp,xchasi,ychasi,xtickval,xtickgra,nbxti,nbxmi
  OPLOT, time,data(1,2,*), Color=2


; *** symbole UT

  XYOUTS, 0.5/xpage,1.05/ypage, 'U.T.', Charsize= 0.7, Font=0, /Normal


; cloture du fichier PS
; ---------------------

  PRINT
  PRINT, nomps, ' created'

  DEVICE, /close

  RETURN
  END

;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
