#!/bin/sh

prog=visu_mva

# ------------------------------------------------------------------------
# run $prog.exe, read parameters in $prog.in, 
# put results in $prog.out
# ------------------------------------------------------------------------

echo "---------------------------------------------------------------------"
dircur=`pwd`
echo dircur $dircur
dirdsh=`dirname $dircur/$0`
echo dirdsh $dirdsh

dirpro=`echo $dirdsh | sed 's/sh$/pro/' `
dirout=`echo $dirdsh | sed 's/sh$/out/' `

sys=`uname -o`
if test $sys = Msys
   then 
       disk_letter=`$dirdsh/give_disk_letter.sh`
       echo "system $sys disk_letter=$disk_letter"
       dirpro=`echo $dirpro | sed "s%^/${disk_letter}%${disk_letter}:%" `
       dirdou=`echo $dirout | sed "s%^/${disk_letter}%${disk_letter}:%" `
fi
echo dirpro $dirpro
echo dirout $dirout

echo "---------------------------------------------------------------------"
echo "Run $0 in $dircur"
echo

if test -f toto_$$.tmp ; then \rm -f toto_$$.tmp; fi

echo ".RUN $dirpro/Rocotlib_V3p2.pro"   > toto_$$.tmp
echo ".RUN $dirpro/Roplotlib_mini.pro"  >> toto_$$.tmp
echo ".RUN $dirpro/$prog.pro"           >> toto_$$.tmp
echo "$prog,  '$dirdou'"                >> toto_$$.tmp
echo "WAIT, 1.0"                        >> toto_$$.tmp
echo "exit"                             >> toto_$$.tmp

echo "run IDL command: $R_IDL -quiet -e '@$dircur/toto_$$.tmp' > $prog.out"
cat toto_$$.tmp
echo
echo "Go..."
$R_IDL -quiet -e "@$dircur/toto_$$.tmp" > $prog.out
echo "Done !"
echo
echo "==> $prog.out text file available"
nbli=`wc -l $prog.out | cut -d " " -f 1`
if test -f $dirout/visu_mva.ps
   then echo "    file visu_mva.ps avalaible"
   else echo "*** no file visu_mva.ps created"
fi

if test $sys = Msys
   then  sed -e 's/.$//' -e '/% Compiled module:/d' $prog.out > $prog.out2
   mv $prog.out2 $prog.out
fi

mv $prog.out $dirout
rm toto_$$.tmp

echo "    $prog.out : $nbli lines"  
echo "    $prog.out is located in $dirout"
echo "    $prog.sh  terminated"
echo "---------------------------------------------------------------------"
echo
