      program co_mag_time
c
c     ***************************************************************0**
c *   Compute_Magnetic_Time ; use cmagtim module 
c     P. Robert, Jan 2002                
c     ***************************************************************0**
c
      print*
      print 100, '****************************************************'
      print*
      print 100, 'Test of cmagtim:'
      print*

  100 format(a,3f12.5)
c 
      call r_date(iyear,imonth,iday)
      call r_time(ih,im,is)
      call cp_time_param(iyear,imonth,iday,ih,im,is)
c
      print 100, 'lat et long en degre?'
      read *, rlat,rlon
      print 100, 'lat, long=', rlat, rlon
c
      psd= 3.1415927/180.
      pis2= 3.1415927/2.
      rlat=rlat*psd
      rlon=rlon*psd
      rtet=pis2-rlat
c
      call g_gei_geo_sun_dir(sxgei,sygei,szgei,sxgeo,sygeo,szgeo)
      call g_gei_geo_dipole_dir(dxgei,dygei,dzgei,dxgeo,dygeo,dzgeo)
c
      call t_car_to_sph(dxgeo,dygeo,dzgeo,dr,dtet,dphi)
      call t_sph_to_car(1.,rtet,rlon, pxgeo,pygeo,pzgeo)
c
      call t_geo_to_mag(pxgeo,pygeo,pzgeo,pxmag,pymag,pzmag)
      call t_geo_to_mag(sxgeo,sygeo,szgeo,sxmag,symag,szmag)
c
      call t_car_to_sph(pxmag,pymag,pzmag,pr,ptet,pphi)
      call t_car_to_sph(sxmag,symag,szmag,sr,stet,sphi)
c
      hmagp= (sphi -pphi)*12./3.1415927 +12.
      if(hmagp.lt.0.) hmagp=hmagp+24.
c
      ihmag= int(hmagp)
      immag= int(hmagp*60.) -ihmag*60
      ismag= int(hmagp*3600.) -ihmag*3600 -immag*60
c      
      print*
      print 400, 'date: YY/MM/JJ=', iyear,imonth,iday
      print 400, 'time: HH/MM/SS=', ih,im,is
      print*
      print 300, 'Dipole in GEO:',dxgeo,dygeo,dzgeo,dr,dtet/psd,dphi/psd
      print 300, 'Point  in GEO:',pxgeo,pygeo,pzgeo,1.,rtet/psd,rlon/psd
      print 300, 'Point  in MAG:',pxmag,pymag,pzmag,pr,ptet/psd,pphi/psd
      print 300, 'Sun    in MAG:',sxmag,symag,szmag,sr,stet/psd,sphi/psd
      print*
      print 200, 'Mag. Local Time:',hmagp,' soit ',ihmag,immag,ismag
      print*
      print 100, '****************************************************'
      print*
c
  200 format(a,f10.5,a,1x,i2.2,':',i2.2,':',i2.2)
  300 format(a,4(f10.6),2f10.4)
  400 format(a,3i5)
       
      stop 'co_mag_time: normal termination'
      end
c
c     ------------------------------------------------------------------
c
