      program rocot_check
c                                   
c     ***************************************************************0**
c
c *   Rocot_Check program:  check subroutines of the rocotlib library;
c
c     Ask date and time and check calendar conversions and coordinate
c     transformations by walking across all path
c                       ___________________
c
c     For details, see schematic diagram of section III the orginal
c     document untitled:
c    "CLUSTER Software Tools, part I: Coordinate Transformation Library"
c                     Document de travail DT/CRPE/1231
c                  Patrick Robert, CRPE/TID, Juillet 1993
c                       ___________________
c
c     Adaptation for successives version of rocotlib:
c
c               version 1.0, November 1992
c               version 1.1, July     1993
c               version 1.2, January  1995
c               version 1.3, July     2000
c               version 1.4, June     2001
c               version 1.5, December 2001
c               version 1.6, Juin     2002 (upgrade IGRF -> 2005)
c               version 1.7, December 2002 (Version for CDPP)
c               version 1.8, November 2003 (adding t_sr2_to_sr tests)
c               version 1.9, March    2004 (compatibility  V 1.9 IDL)
c               version 2.0, May      2016 (test GSE->MFA et TPN)
c
c    Copyright 1992, Patrick ROBERT, CNRS-ESA, All Rights reserved
c
c     ***************************************************************0**
c
      character*14 verdat
      real Tx,Ty,Tz, Px,Py,Pz, Nx,Ny,Nz
c
      pi=acos(-1.)
      d=180./pi
c
c
      call g_rocot_version_number(vernum,verdat)
      call strlen(verdat,nv)
c
      print 100, ' '
      print 100, 'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'
      print 100, ' '
      print 100, '     Coordinates Transformation Library  ROCOTLIB'
      print 100, '                  ___________________'
      print 100, ' '
      print 100, ' Rocotche program: Check transformations of Rocotlib'
      print 100, ' '
      print 100, '          Patrick ROBERT, CRPE, November 1992'
      print 100, ' '
      print 200, '         Revised Version ',vernum, ' - ',verdat(1:nv)
      print 100, ' '
      print 100, 'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX'
      print 100
      print 100
      print 100
      print 100, 'SUMMARY OF CHECK OPERATIONS :'
      print 100, '***************************'
      print 100
      print 100, '  I) TEST OF ROCOTLIB CALENDAR CONVERSIONS'
      print 100
      print 100, ' II) CHECK BASIC TIME PARAMETERS'
      print 100
      print 100, 'III) CHECK BASIC TRANSFORMATIONS'
      print 100
      print 100, ' IV) TEST OF ROCOTLIB TRANSFORMATION SUBROUTINES'
      print 100
      print 100, '    A) STAR TRANSFORMATIONS AROUND  GEI  SYSTEM'
      print 100
      print 100, '       GEI -----------------------------> MAG'
      print 100, '       GEI ------------------------> SM'
      print 100, '       GEI ------------------> GSM'
      print 100, '       GEI ------------> GSE'
      print 100
      print 100, '    B) COUNTERCLOCKWISE RING CUMULATIVE TRANSFORM.'
      print 100
      print 100, '       GEO ->GEI ->GSQ ->GSE ->GSM ->SM ->MAG ->GEO'
      print 100
      print 100, '    C) CLOCKWISE RING CUMULATIVE TRANSFORMATIONS'
      print 100
      print 100, '       GEO ->MAG ->SM ->GSM ->GSE ->GSQ ->GEI ->GEO'
      print 100
      print 100, '    D) STAR TRANSFORMATIONS AROUND  GEO  SYSTEM'
      print 100
      print 100, '       GEO ------> SM'
      print 100, '       GEO -----------> GSM'
      print 100, '       GEO -----------------> GSE'
      print 100, '       GEO -----------------------> GSQ'
      print 100
      print 100, '    E) LOCAL SYSTEMS'
      print 100
      print 100, '       GEO ----> DM'
      print 100, '       GEO ----> VDH'
      print 100
      print 100, '    F) SPACECRAFT SYSTEMS'
      print 100
      print 100, '       GEO -> GSE -> SR2 -> SR -> SR2 -> GSE -> GEO'
      print 100
      print 100, '    G) PSEUDO-MAGNETOPAUSE SYSTEMS'
      print 100
      print 100, '       GSE ----> TPN'
      print 100, '       GSM ----> TPN'

c
      print 100, char(12)
      print 100
      print 100
      print 100, 'INPUT DATA TEST :'
      print 100, '***************'
      print 100
      print 100, 'INPUT DATE AND TIME:'
c
      call r_date(iyear,imonth,iday)
      call r_time(ih,im,is)
c
      print 100
      print 105, 'iyear,imonth,iday: ',iyear,imonth,iday
      print 106, 'ih, im, is       : ',ih,im,is
c
      print 100
      print 100, 'INPUT VECTOR TEST:'
c
      print 100, 'r, teta,phi of any vector in GEO system ? (deg.)'
      read *, gr,gt,gp
      print 108, gr,gt,gp
      gt=gt/d
      gp=gp/d
      call t_sph_to_car(gr,gt,gp,g1,g2,g3)
c
      print 100
      print 100, 'INPUT GEOG. LAT AND LONG. FOR LOCAL SYSTEMS TEST:'
      print 100, 'lat. and long. of local direct. of observation ? (d.)'
      read *, grlat,grlon
      print 109, grlat,grlon
      grlat=grlat/d
      grlon=grlon/d
c
      print 100
      print 100, 'INPUT SPIN DIRECTION for SR and SR2 SYSTEMS:'
      print 100, 'r, teta,phi of spin axis in GSE system ? (deg.)'
      read *, sar,sat,sap
      print 108, sar,sat,sap
      sat=sat/d
      sap=sap/d
      call t_sph_to_car(sar,sat,sap,sa1,sa2,sa3)
c
      print 100
      print 100, 'SPIN FREQUENCY, SPIN PHASE & Deltat T :'
      print*, 'Spin frequency, Spin phase ? (Hz, deg.)'
      read *, spifre,spipha
      print 108, spifre,spipha
      print 100, 'delta T ? (sec. from time of spin phase)'
      read *, deltaT
      print 108, deltaT
      spipha=spipha/d
c
      print 100
      print 100
      print 100
      print 100, 'RUN OF CHECK PROGRAM'
      print 100, '********************'
      print 100
      print 100, 'Please wait...'
      print 100, char(12)
c
      print 100
      print 200, '            T E S T   O F   R O C O T L I B  Version '
     &            ,vernum
      print 100
      print 100
      print 100, 'I) TEST OF ROCOTLIB CALENDAR CONVERSIONS'
      print 100, '   ====================================='
      print 100
      print 100, 'INPUT DATE AND TIME:'
      print 100
      print 100, 'year, month,  day   :     ',iyear,imonth,iday
      print 100, 'hour, minute, second:     ',ih,im,is
c
      call cv_hms_to_dech(ih,im,is,houday)
      call cv_date_to_doty(iyear,imonth,iday,idoty)
      call cv_date_to_jul1950(iyear,imonth,iday,jud50)
      call cv_date_to_jul2000(iyear,imonth,iday,jud00)
      call cp_leap_year(iyear,ily)
c
      print 100
      print 100, 'computed values:'
      print 100
      print 110, 'decimal hour of the day:  ',houday
      print 100, 'day of the year:          ',idoty
      print 100, 'Julian day from 1-1-1950: ',jud50
      print 100, 'Julian day from 1-1-2000: ',jud00
      print 100, 'leap year (1=yes,0=no):   ',ily
c
      call cv_doty_to_date(idoty,iyear,imon2,iday2)
      call cv_jul1950_to_date(jud50,iyea3,imon3,iday3)
      call cv_jul2000_to_date(jud00,iyea4,imon4,iday4)
      call cv_dech_to_hms(houday,ih2,im2,is2)
c
      print 100
      print 100,'recompute date from year and day of the year:'
     &                     ,iyear,imon2,iday2
      print 100,'recompute date from Julian day 1950         :'
     &                     ,iyea3,imon3,iday3
      print 100,'recompute date from Julian day 2000         :'
     &                     ,iyea4,imon4,iday4
      print 100,'recompute time from decimal hour:',ih2,im2,is2
c
      print 100
      print 100
      print 100, 'II) CHECK BASIC TIME PARAMETERS'
      print 100, '    ==========================='
      print 100
      print 100
      print 100, 'SUN PARAMETERS IN GEI SYSTEM'
      print 100
c
      call cp_time_param(iyear,imonth,iday,ih,im,is)
c
      call g_gei_geo_sun_dir(s1gei,s2gei,s3gei, s1geo,s2geo,s3geo)
      call g_gei_geo_dipole_dir(d1gei,d2gei,d3gei, d1geo,d2geo,d3geo)
      call g_gei_geo_ecliptic_dir(e1gei,e2gei,e3gei, e1geo,e2geo,e3geo)
      call g_gei_geo_sun_rot(r1gei,r2gei,r3gei, r1geo,r2geo,r3geo)
      call g_gei_sun_param(gmst,slong,srasn,sdec,obli)
      call g_gsm_dipole_tilt_angle(diptan)
c
      call t_car_to_sph(s1gei,s2gei,s3gei,srgei,stgei,spgei)
      call t_car_to_sph(d1gei,d2gei,d3gei,drgei,dtgei,dpgei)
      call t_car_to_sph(e1gei,e2gei,e3gei,ergei,etgei,epgei)
      call t_car_to_sph(r1gei,r2gei,r3gei,rrgei,rtgei,rpgei)
c
      call t_car_to_sph(s1geo,s2geo,s3geo,srgeo,stgeo,spgeo)
      call t_car_to_sph(d1geo,d2geo,d3geo,drgeo,dtgeo,dpgeo)
      call t_car_to_sph(e1geo,e2geo,e3geo,ergeo,etgeo,epgeo)
      call t_car_to_sph(r1geo,r2geo,r3geo,rrgeo,rtgeo,rpgeo)
c
c
      print 112, 'Greenwich Sideral Time (deg.):',  gmst*d
      print 112, 'ecliptic longitude     (deg.):', slong*d
      print 112, 'right ascention        (deg.):', srasn*d
      print 112, 'declination            (deg.):',  sdec*d
      print 100
      print 112, 'DIPOLE TILT ANGLE      (deg.):',diptan*d
      print 100
      print 100, 'SUN DIRECTION'
      print 100, '                     in GEI:'
      print 130,  s1gei,srgei,s2gei,stgei*d,s3gei, spgei*d
      print 100, '                     in GEO:'
      print 130,  s1geo,srgeo,s2geo,stgeo*d,s3geo, spgeo*d
      print 100
      print 100, 'DIPOLE DIRECTION'
      print 100, '                     in GEI:'
      print 130,  d1gei,drgei,d2gei,dtgei*d,d3gei, dpgei*d
      print 100, '                     in GEO:'
      print 130,  d1geo,drgeo,d2geo,dtgeo*d,d3geo, dpgeo*d
      print 100
      print 100, 'ECLIPTIC DIRECTION'
      print 100, '                     in GEI:'
      print 130,  e1gei,ergei,e2gei,etgei*d,e3gei, epgei*d
      print 100, '                     in GEO:'
      print 130,  e1geo,ergeo,e2geo,etgeo*d,e3geo, epgeo*d
      print 100
      print 100, 'SUN EQUATOR DIRECTION'
      print 100, '                     in GEI:'
      print 130,  r1gei,rrgei,r2gei,rtgei*d,r3gei, rpgei*d
      print 100, '                     in GEO:'
      print 130,  r1geo,rrgeo,r2geo,rtgeo*d,r3geo, rpgeo*d
c
c
      print 100, char(12)
      print 100
      print 100, 'III) CHECK BASIC TRANSFORMATIONS'
      print 100, '     ==========================='
      print 100
c
      call cp_angle_and_ratio(s1gei,s2gei,s3gei,e1gei,e2gei,e3gei,a ,r )
      call cp_angle_and_ratio(s1geo,s2geo,s3geo,e1geo,e2geo,e3geo,a2,r2)
c
      print 140, 'Check (S,E) angle is equal to 90 deg. :',a*d
      if(abs(a-a2).gt.0.0001/d) then
        print 100, ' *** angle computed in GEI or GEO system'
        print 100, '     give not the same result:'
        print 140, 'in GEI:',a*d
        print 140, 'in GEO:',a2*d
      endif
c
      print 100
      print 100
      print 100, '1) input vector: Sun direction in GEI system'
      print 100, '   -----------------------------------------'
      print 100
      print 130,  s1gei,srgei,s2gei,stgei*d,s3gei,spgei*d
      print 100
      print 100, '                               in GEO system'
      print 100
      print 130,  s1geo,srgeo,s2geo,stgeo*d,s3geo,spgeo*d
c
      print 100
      print 100
      print 100, '   check Y=0 in SM  system with t_gei_to_sm:'
      call t_gei_to_sm(s1gei,s2gei,s3gei,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
      print 100
      print 100, '                           with t_geo_to_sm:'
      call t_geo_to_sm(s1geo,s2geo,s3geo,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '   check Y=0 and Z=0 in GSM system with t_gei_to_gsm:'
      call t_gei_to_gsm(s1gei,s2gei,s3gei,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
      print 100
      print 100, '                           with t_geo_to_gsm:'
      call t_geo_to_gsm(s1geo,s2geo,s3geo,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '   check Y=0 and Z=0 in GSE system with t_gei_to_gse:'
      call t_gei_to_gse(s1gei,s2gei,s3gei,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
      print 100
      print 100, '                           with t_geo_to_gse:'
      call t_geo_to_gse(s1geo,s2geo,s3geo,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '   check Y=0 and Z=0 in GSQ system with'//
     &                                       ' t_gei_to_gseq:'
      call t_gei_to_gseq(s1gei,s2gei,s3gei,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
      print 100
      print 100, '                           with'//
     &                                      ' t_geo_to_gseq:'
      call t_geo_to_gseq(s1geo,s2geo,s3geo,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100, char(12)
      print 100
      print 100, '2) input vector: Dipole direction in GEI system'
      print 100, '   --------------------------------------------'
      print 100
      print 130,  d1gei,drgei,d2gei,dtgei*d,d3gei,dpgei*d
      print 100
      print 100, '                                  in GEO system'
      print 100
      print 130,  d1geo,drgeo,d2geo,dtgeo*d,d3geo,dpgeo*d
c
c
      print 100
      print 100
      print 100, '   check X=0 and Y=0 in MAG system with t_gei_to_mag:'
      call t_gei_to_mag(d1gei,d2gei,d3gei,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
      print 100
      print 100, '                           with t_geo_to_mag:'
      call t_geo_to_mag(d1geo,d2geo,d3geo,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '   check X=0 and Y=0 in SM  system with t_gei_to_sm:'
      call t_gei_to_sm(d1gei,d2gei,d3gei,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
      print 100
      print 100, '                           with t_geo_to_sm:'
      call t_geo_to_sm(d1geo,d2geo,d3geo,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '   check Y=0 in GSM system with t_gei_to_gsm:'
      call t_gei_to_gsm(d1gei,d2gei,d3gei,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
      print 100
      print 100, '                           with t_geo_to_gsm:'
      call t_geo_to_gsm(d1geo,d2geo,d3geo,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
c
      print 100, char(12)
      print 100
      print 100, '3) input vector: Ecliptic direction in GEI system'
      print 100, '   ----------------------------------------------'
      print 100
      print 130,  e1gei,ergei,e2gei,etgei*d,e3gei,epgei*d
      print 100
      print 100, '                                    in GEO system'
      print 100
      print 130,  e1geo,ergeo,e2geo,etgeo*d,e3geo,epgeo*d
c
c
      print 100
      print 100
      print 100, '   check X=0 and Y=0 in GSE system with t_gei_to_gse:'
      call t_gei_to_gse(e1gei,e2gei,e3gei,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
      print 100
      print 100, '                           with t_geo_to_gse:'
      call t_geo_to_gse(e1geo,e2geo,e3geo,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '   check X=0 in GSQ system with t_gei_to_gseq:'
      call t_gei_to_gseq(e1gei,e2gei,e3gei,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
      print 100
      print 100, '                           with t_geo_to_gseq:'
      call t_geo_to_gseq(e1geo,e2geo,e3geo,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
c
      print 100
      print 100
      print 100
      print 100
      print 100
      print 100, '4) input vector: Sun equator in GEI system'
      print 100, '   ---------------------------------------'
      print 100
      print 130,  r1gei,rrgei,r2gei,rtgei*d,r3gei,rpgei*d
      print 100
      print 100, '                             in GEO system'
      print 100
      print 130,  r1geo,rrgeo,r2geo,rtgeo*d,r3geo,rpgeo*d
c
c
      print 100
      print 100
      print 100, '   check and Y=0 in GSQ system with t_gei_to_gseq:'
      call t_gei_to_gseq(r1gei,r2gei,r3gei,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
      print 100
      print 100, '                           with t_geo_to_gseq:'
      call t_geo_to_gseq(r1geo,r2geo,r3geo,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
c
      print 100, char(12)
      print 100
      print 100, '5) input vector: North geographic in GEO system'
      print 100, '   --------------------------------------------'
      call t_car_to_sph(0.,0.,1.,vr,vt,vp)
      print 100
      print 130, 0.,vr,0.,vt*d,1.,vp*d
      print 100
      print 100
      print 100, '   check X=0 and Y=0 in GEI system with t_geo_to_gei:'
      call t_geo_to_gei(0.,0.,1.,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      print 100
      print 100, '   check Y=0 in MAG system with t_gei_to_mag:'
      call t_gei_to_mag(w1,w2,w3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
      print 100
      print 100, '                           with t_geo_to_mag:'
      call t_geo_to_mag(w1,w2,w3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
c
      print 100
      print 100
      print 100, 'IV) TEST OF ROCOTLIB TRANSFORMATION SUBROUTINES'
      print 100, '    ==========================================='
      print 100
      print 100, '1) input choosed test vector in GEO system :'
      print 100
      print 130, g1,gr,g2,gt*d,g3,gp*d
c
      print 100
      print 100, '2) converts GEO system to GEI system by t_geo_to_gei'
      call t_geo_to_gei(g1,g2,g3,u1,u2,u3)
      call t_car_to_sph(u1,u2,u3,ur,ut,up)
      print 100
      print 130, u1,ur,u2,ut*d,u3,up*d
c
c
      print 100, char(12)
      print 100
      print 100, 'A) STAR TRANSFORMATIONS AROUND  GEI  SYSTEM'
      print 100, '   ========================================'
      print 100
      print 100, '            # 3'
      print 100, '       GEI --------> MAG'
      print 100, '            # 4'
      print 100, '       GEI --------> SM'
      print 100, '            # 5'
      print 100, '       GEI --------> GSM'
      print 100, '            # 6'
      print 100, '       GEI --------> GSE'
      print 100
c
      print 100
      print 100, '1) t# 3 converts GEI system to MAG system by'//
     &                                             't_gei_to_mag'
      call t_gei_to_mag(u1,u2,u3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '              come back to GEI system by t_mag_to_gei'
      call t_mag_to_gei(v1,v2,v3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      call cp_angle_and_ratio(u1,u2,u3,w1,w2,w3,a,ra)
      print 150, 'difference beetween first GEI vector:',a*d,ra
c
c
      print 100
      print 100
      print 100, '2) t# 4 converts GEI system to SM  system by'//
     &                                              't_gei_to_sm'
      call t_gei_to_sm(u1,u2,u3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '              come back to GEI system by t_sm_to_gei'
      call t_sm_to_gei(v1,v2,v3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      call cp_angle_and_ratio(u1,u2,u3,w1,w2,w3,a,ra)
      print 150, 'difference beetween first GEI vector:',a*d,ra
c
c
      print 100
      print 100
      print 100, '3) t# 5 converts GEI system to GSM system by'//
     &                                             't_gei_to_gsm'
      call t_gei_to_gsm(u1,u2,u3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '              come back to GEI system by t_gsm_to_gei'
      call t_gsm_to_gei(v1,v2,v3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      call cp_angle_and_ratio(u1,u2,u3,w1,w2,w3,a,ra)
      print 150, 'difference beetween first GEI vector:',a*d,ra
c
c
      print 100, char(12)
      print 100
      print 100, '4) t# 6 converts GEI system to GSE system by'//
     &                                             ' t_gei_to_gse'
      call t_gei_to_gse(u1,u2,u3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '              come back to GEI system by t_gse_to_gei'
      call t_gse_to_gei(v1,v2,v3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      call cp_angle_and_ratio(u1,u2,u3,w1,w2,w3,a,ra)
      print 150, 'difference beetween first GEI vector:',a*d,ra
c
      print 100, char(12)
      print 100
      print 100, 'B) COUNTERCLOCKWISE RING CUMULATIVE TRANSFORMATIONS'
      print 100, '   ================================================'
      print 100
      print 100, '    # 2      7      8      9     10    11     12'
      print 100, '  GEO -> GEI -> GSQ -> GSE -> GSM -> SM -> MAG -> GEO'
      print 100
      print 100
      print 100, '   input choosed test vector in GEO system :'
      print 100
      print 130, g1,gr,g2,gt*d,g3,gp*d
c
      print 100
      print 100, '1) t# 2 converts GEO system to GEI system by'//
     &                                            ' t_geo_to_gei'
      call t_geo_to_gei(g1,g2,g3,u1,u2,u3)
      call t_car_to_sph(u1,u2,u3,ur,ut,up)
      print 100
      print 130, u1,ur,u2,ut*d,u3,up*d
c
      print 100
      print 100, '2) t# 7 converts GEI system to GSQ system by'//
     &                                           ' t_gei_to_gseq'
      call t_gei_to_gseq(u1,u2,u3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
c
      print 100
      print 100, '3) t# 8 converts GSQ system to GSE system by'//
     &                                           ' t_gseq_to_gse'
      call t_gseq_to_gse(v1,v2,v3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
c
      print 100
      print 100, '4) þ# 9 converts GSE system to GSM system by'//
     &                                            ' t_gse_to_gsm'
      call t_gse_to_gsm(w1,w2,w3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
c
      print 100
      print 100, '5) t# 10 converts GSM system to SM  system by'//
     &                                              ' t_gsm_to_sm'
      call t_gsm_to_sm(v1,v2,v3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
c
      print 100
      print 100, '6) t# 11 converts SM  system to MAG system by'//
     &                                              ' t_sm_to_mag'
      call t_sm_to_mag(w1,w2,w3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
c
      print 100
      print 100, '7) t# 12 converts MAG system to GEO system by'//
     &                                             ' t_mag_to_geo'
      call t_mag_to_geo(v1,v2,v3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      call cp_angle_and_ratio(g1,g2,g3,w1,w2,w3,a,ra)
      print 150, 'difference beetween first GEO vector:',a*d,ra
c
c
      print 100, char(12)
      print 100
      print 100, 'C) CLOCKWISE RING CUMULATIVE TRANSFORMATIONS'
      print 100, '   ========================================='
      print 100
      print 100, '    # 12     11    10     9      8      7      2'
      print 100, '  GEO -> MAG -> SM -> GSM -> GSE -> GSQ -> GEI -> GEO'
      print 100
      print 100
      print 100, '   input choosed test vector in GEO system :'
      print 100
      print 130, g1,gr,g2,gt*d,g3,gp*d
c
      print 100
      print 100, '1) t# 12 converts GEO system to MAG system by'//
     &                                             ' t_geo_to_mag'
      call t_geo_to_mag(g1,g2,g3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
c
      print 100
      print 100, '2) t# 11 converts MAG system to SM  system by'//
     &                                              ' t_mag_to_sm'
      call t_mag_to_sm(w1,w2,w3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
c
      print 100
      print 100, '3) t# 10 converts SM  system to GSM system by'//
     &                                              ' t_sm_to_gsm'
      call t_sm_to_gsm(v1,v2,v3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
c
      print 100
      print 100, '4) t# 9 converts GSM system to GSE system by'//
     &                                            ' t_gsm_to_gse'
      call t_gsm_to_gse(w1,w2,w3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
c
      print 100
      print 100, '5) t# 8 converts GSE system to GSQ system by'//
     &                                           ' t_gse_to_gseq'
      call t_gse_to_gseq(v1,v2,v3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
c
      print 100
      print 100, '6) t# 7 converts GSQ system to GEI system by'//
     &                                           ' t_gseq_to_gei'
      call t_gseq_to_gei(w1,w2,w3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      call cp_angle_and_ratio(u1,u2,u3,v1,v2,v3,a,ra)
      print 150, 'difference beetween first GEI vector:',a*d,ra
c
c
      print 100
      print 100
      print 100, '7) t# 2 converts GEI system to GEO system by'//
     &                                            ' t_gei_to_geo'
      call t_gei_to_geo(v1,v2,v3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      call cp_angle_and_ratio(g1,g2,g3,w1,w2,w3,a,ra)
      print 150, 'difference beetween first GEO vector:',a*d,ra
c
      print 100, char(12)
      print 100, 'D) STAR TRANSFORMATIONS AROUND  GEO  SYSTEM'
      print 100, '   ========================================'
      print 100
      print 100, '          # 13'
      print 100, '     GEO --------> SM'
      print 100, '          # 14'
      print 100, '     GEO --------> GSM'
      print 100, '          # 15'
      print 100, '     GEO --------> GSE'
      print 100, '          # 16'
      print 100, '     GEO --------> GSQ'
c
      print 100
      print 100
      print 100, '   input choosed test vector in GEO system :'
      print 100
      print 130, g1,gr,g2,gt*d,g3,gp*d
c
      print 100
      print 100, '1) t# 13 converts GEO system to SM  system by'//
     &                                              ' t_geo_to_sm'
      call t_geo_to_sm(g1,g2,g3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '              come back to GEO system by t_sm_to_geo'
      call t_sm_to_geo(v1,v2,v3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      call cp_angle_and_ratio(g1,g2,g3,w1,w2,w3,a,ra)
      print 150, 'difference beetween first GEO vector:',a*d,ra
c
c
      print 100
      print 100, '2) t# 14 converts GEO system to GSM system by'//
     &                                             ' t_geo_to_gsm'
      call t_geo_to_gsm(g1,g2,g3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '              come back to GEO system by t_gsm_to_geo'
      call t_gsm_to_geo(v1,v2,v3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      call cp_angle_and_ratio(g1,g2,g3,w1,w2,w3,a,ra)
      print 150, 'difference beetween first GEO vector:',a*d,ra
c
c
      print 100
      print 100, '3) t# 15 converts GEO system to GSE system by'//
     &                                             ' t_geo_to_gse'
      call t_geo_to_gse(g1,g2,g3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '              come back to GEO system by t_gse_to_geo'
      call t_gse_to_geo(v1,v2,v3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      call cp_angle_and_ratio(g1,g2,g3,w1,w2,w3,a,ra)
      print 150, 'difference beetween first GEO vector:',a*d,ra
c
c
      print 100
      print 100, '4) t# 16 converts GEO system to GSQ system by'//
     &                                            ' t_geo_to_gseq'
      call t_geo_to_gseq(g1,g2,g3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '              come back to GEO system by'//
     &                                       ' t_gseq_to_geo'
      call t_gseq_to_geo(v1,v2,v3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      call cp_angle_and_ratio(g1,g2,g3,w1,w2,w3,a,ra)
      print 150, 'difference beetween first GEO vector:',a*d,ra
c
      print 100, char(12)
      print 100, 'E) LOCAL SYSTEMS TRANSFORMATIONS'
      print 100, '   ============================='
      print 100
      print 100, '          # 17'
      print 100, '     GEO --------> DM'
      print 100, '          # 18'
      print 100, '     GEO --------> VDH'
      print 100
      print 100, '   first direction of observation in GEO system:'
      print 112, '        geog. lat., long. =',grlat*d,grlon*d
c
      print 100
      print 100, '1) t# 17 converts GEO system to DM  system by'//
     &                                              ' t_geo_to_dm'
      call t_geo_to_dm(g1,g2,g3,grlat,grlon,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '              come back to GEO system by t_dm_to_geo'
      call t_dm_to_geo(v1,v2,v3,grlat,grlon,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      call cp_angle_and_ratio(g1,g2,g3,w1,w2,w3,a,ra)
      print 150, 'difference beetween first GEO vector:',a*d,ra
c
c
      print 100
      print 100, '2) t# 18 converts GEO system to VDH system by'//
     &                                             ' t_geo_to_vdh'
      call t_geo_to_vdh(g1,g2,g3,grlat,grlon,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '              come back to GEO system by t_vdh_to_geo'
      call t_vdh_to_geo(v1,v2,v3,grlat,grlon,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      call cp_angle_and_ratio(g1,g2,g3,w1,w2,w3,a,ra)
      print 150, 'difference beetween first GEO vector:',a*d,ra
c
      print 100
      print 100
      print 100, '   second direction of observation in GEO system:'
      print 112, '        geog. lat., long. =',grlat*d,grlon*d
c
      print 100
      print 100, '3) t# 17 converts GEO system to DM  system by'//
     &                                              ' t_geo_to_dm'
      call t_geo_to_dm(g1,g2,g3,grlat,grlon,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '              come back to GEO system by t_dm_to_geo'
      call t_dm_to_geo(v1,v2,v3,grlat,grlon,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      call cp_angle_and_ratio(g1,g2,g3,w1,w2,w3,a,ra)
      print 150, 'difference beetween first GEO vector:',a*d,ra
c
c
      print 100
      print 100, '4) t# 18 converts GEO system to VDH system by'//
     &                                             ' t_geo_to_vdh'
      call t_geo_to_vdh(g1,g2,g3,grlat,grlon,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '              come back to GEO system by t_vdh_to_geo'
      call t_vdh_to_geo(v1,v2,v3,grlat,grlon,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      call cp_angle_and_ratio(g1,g2,g3,w1,w2,w3,a,ra)
      print 150, 'difference beetween first GEO vector:',a*d,ra
c
      print 100, char(12)
      print 100
      print 100, 'F) LOCAL SPACECRAFT SYSTEMS TRANSFORMATIONS'
      print 100, '   ========================================'
      print 100
      print 100, '    # 15    19     21    -21    -19    -15'
      print 100, '  GEO -> GSE -> SR2 -> SR -> SR2 -> GSE -> GEO'
      print 100
      print 100
      print 100, '   input choosed test vector in GEO system :'
      print 100
      print 130, g1,gr,g2,gt*d,g3,gp*d
c
      print 100
      print 100, '   input choosed spin axis in GSE system :'
      print 100
      print 130, sa1,sar,sa2,sat*d,sa3,sap*d
c
      print 100
      print 100, '   input choosed Spin frequency, Spin phase, dt:'
      print 100
      print 111, '         Spin frequency= ',spifre,   ' Hz'
      print 111, '         Spin phase    = ',spipha*d, ' deg.'
      print 111, '         delta T       = ',deltaT,   ' sec.'
      print 100
c
      print 100
      print 100, '1) t# 15 converts GEO system to GSE system by'//
     &                                             ' t_geo_to_gse'
      call t_geo_to_gse(g1,g2,g3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      print 100
      print 100, '2) t# 19 converts GSE system to SR2 system by'//
     &                                             ' t_gse_to_sr2'
      call t_gse_to_sr2(w1,w2,w3,sa1,sa2,sa3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
c
      print 100
      print 100, '3) t#-21 converts SR2 system to SR  system by'//
     &                                              ' t_sr2_to_sr'
      call t_sr2_to_sr(v1,v2,spifre,spipha,deltaT,w1,w2)
      w3=v3
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
c
      print 100
      print 100, '4) t# 21 converts SR  system to SR2 system by'//
     &                                              ' t_sr_to_sr2'
      call t_sr_to_sr2(w1,w2,spifre,spipha,deltaT,v1,v2)
      v3=w3
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
c
      print 100
      print 100, '5) t#-19 converts SR2 system to GSE system by'//
     &                                             ' t_sr2_to_gse'
      call t_sr2_to_gse(v1,v2,v3,sa1,sa2,sa3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
c
      print 100
      print 100, '6) t#-15 converts GSE system to GEO system by'//
     &                                             ' t_gse_to_geo'
      call t_gse_to_geo(w1,w2,w3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      call cp_angle_and_ratio(g1,g2,g3,v1,v2,v3,a,ra)
      print 150, 'difference beetveen first GEO wector:',a*d,ra
c
      print 100
      print 100
      print 100, 'G) MAGNETIC FIELD ALIGNED TRANSFORMATION'
      print 100, '   ======================================'
      print 100
      print 100, '  GSE -> MFA'
      print 100, '  SR2 -> MFA'
c
      print 100
      print 100, '   input choosed test vector in GSE system :'
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      print 100
      print 100, '   input choosed DC mag. field in GSE system :'
      b1=30.
      b2=50.
      b3=200.
      call t_car_to_sph(b1,b2,b3,br,bt,bp)
      print 100
      print 130, b1,br,b2,bt*d,b3,bp*d
c
      print 100
      print 100
      print 100, '1) t# 22 converts GSE system to MFA system by'//
     &                                             ' t_gse_to_mfa'
      call t_gse_to_mfa(w1,w2,w3,b1,b2,b3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '   input choosed test vector in SR2 system :'
      call t_gse_to_sr2(w1,w2,w3,sa1,sa2,sa3,v1,v2,v3)
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100
      print 100, '   input choosed DC mag. field in SR2 system :'
      call t_gse_to_sr2(b1,b2,b3,sa1,sa2,sa3,bs1,bs2,bs3)
      call t_car_to_sph(bs1,bs2,bs3,bsr,bst,bsp)
      print 100
      print 130, bs1,bsr,bs2,bst*d,bs3,bsp*d
c
      print 100
      print 100, '2) t# 20 converts SR2 system to MFA system by'//
     &                                             ' t_sr2_to_mfa'
      call t_sr2_to_mfa(v1,v2,v3,bs1,bs2,bs3,sa1,sa2,sa3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      print 100, char(12)
      print 100
      print 100, 'H) PSEUDO-MAGNETOPAUSE SYSTEMS'
      print 100, '   ==========================='
      print 100
      print 100, '       GSE ----> TPN'
      print 100, '       GSM ----> TPN'
c
      print 100
      print 100, '1) Computation of the TPN system'
c
      print 100
      print 100, '   Input position in GSE system, in RE:'
      print 100, '   (supposed to be on the magnetopause)'
c
      xo= 5.72
      yo= 8.23
      zo= 9.22
c
      print 100
      print 112, '   Xo, Yo, Zo in GSE =',xo,yo,zo
c
      xs= 12.0
c
      print 100
      print 112, '   abcisse of subsolar point for paraboloid model:',xs
c
      call cp_tpn_param(xo,yo,zo,xs, Tx,Ty,Tz, Px,Py,Pz, Nx,Ny,Nz)
c
      print 100
      print 100, '   TPN vectors in GSE:'
      print 100
      print 112, '   Tx,Ty,Tz=', Tx,Ty,Tz
      print 112, '   Px,Py,Pz=', Px,Py,Pz
      print 112, '   Nx,Ny,Nz=', Nx,Ny,Nz
      print 100, ' '
c
      print 100
      print 100, '   input choosed test vector in GSE system :'
c
      v1=Nx
      v2=Ny
      v3=Nz
c
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
      print 100, ' '
      print 100, '2) t# 23 convert GSE system to TPN system by'//
     &                                            ' t_gse_to_tpn'
c
      call t_gse_to_tpn(v1,v2,v3,xo,yo,zo,xs,w1,w2,w3)
c
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      print 100, ' '
      print 100, '3) t# 9 convert GSE system to GSM system by'//
     &                                           ' t_gse_to_gsm'
c
      call t_gse_to_gsm(v1,v2,v3,w1,w2,w3)
      call t_car_to_sph(w1,w2,w3,wr,wt,wp)
      print 100
      print 130, w1,wr,w2,wt*d,w3,wp*d
c
      print 100, ' '
      print 100, '4) t# 9 convert GSE position of S/C to GSM position'
c
      call t_gse_to_gsm(xo,yo,zo,xm,ym,zm)
c
      print 100
      print 112, '   Xo, Yo, Zo in GSM =',xm,ym,zm
c
      print 100, ' '
      print 100, '5) t# 24 convert GSM system to TPN system by'//
     &                                            ' t_gsm_to_tpn'
c
      call t_gsm_to_tpn(w1,w2,w3,xm,ym,zm,xs,v1,v2,v3)
c
      call t_car_to_sph(v1,v2,v3,vr,vt,vp)
      print 100
      print 130, v1,vr,v2,vt*d,v3,vp*d
c
c
      print 100
      print 100, '==============================='
      print 100, 'END OF rocot_check test program'
      print 100, '==============================='
c
  100 format(a,3i6)
  105 format(a,1x,i4,1x,i2.2,1x,i2.2)
  106 format(a,3(1x,i2.2))
  108 format(f12.5,1x,f8.3,1x,f8.3)
  109 format(f8.3,1x,f8.3)
  110 format(a,f8.4)
  111 format(10x,a,f8.4,a)
  112 format(a,3f10.3)
  130 format(SS,32x,'X=',f9.4,5x,'r   =  ',f9.4,/,32x,
     &              'Y=',f9.4,5x,'teta=  ',f7.2,/,32x,
     &              'Z=',f9.4,5x,'phi =  ',f7.2)
  140 format(/,a44, ' angle=',f8.3,'    (deg.)',:
     &       /, 44x,' ratio=',f14.5)
  150 format(/,a47, ' angle= ',f9.3,'    (deg.)',:
     &       /, 47x,' ratio= ',f11.5)
  200 format(1x,a,f3.1,2a,2x,a)
c
c
      stop 'rocot_check.exe: normal termination'
      end
c
c     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
c
      subroutine strlen(str,nc)
c
c ----------------------------------------------------------------------
c
c *   Class  : basic compute modules of Rocotlib Software
c *   Object : compute usefull lengh of a string (ignore last blanks)
c *   Author : P. Robert, CRPE, 1992
c
c ----------------------------------------------------------------------
c
      character*(*) str
c
      nbc=len(str)
c
c *** nc= longueur au de la de laquelle il n'y a que des blancs
c         (mais la chaine 1:nc peu contenir des blancs)
c
      do 10 i=1,nbc
      ii=nbc-i+1
      if(str(ii:ii).ne.' ') go to 12
   10 continue
      ii=0
   12 continue
      nc=ii
c
      return
      end
c
c     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
c
