 
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
;
;   bibliotheque de procedure PV-Waves developpee initialememt pour les
;   visualisations de GEOS, SOL et CLUSTER, puis etendue aux Roproc
;
;   Patrick ROBERT, CNRS/CETP, 1998-2001
;
;   Version minimum pour la visu_mva, P.R., Sept. 2020
;
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

  FUNCTION give_signat, projet, appli, nomps
 
;----------------------------------------------------------------------!
; Object: retourne la signature pour les Roplots 
; Author: P. Robert, LPP, 2011 Aug 
;----------------------------------------------------------------------! 
  signat=" "
  if (strlen(strtrim(projet,2)) eq 0) then begin
      signat='ROPLOT/'+appli +'/' +nomps 
  endif else begin
      signat= strtrim(projet,2) +'_ROPLOT/' +appli +'/' +nomps +' - ' +version
  endelse

  RETURN, signat
  END 
  
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

  FUNCTION datim

;----------------------------------------------------------------------!
; Object: return current date/time as 2001 Aug 30, 14:55:37  
; Author: P. Robert, LPP, 2011 Aug 
;----------------------------------------------------------------------! 
 
  s24=systime()
  
  dat_time=strmid(s24,20,4) +strmid(s24,3,4) +strmid(s24,7,3) +','  $
         +strmid(s24,10,9)
         
         
  RETURN, dat_time
  END 

;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

  PRO crepagps, nomps,fultit,jul00,iday,imon,iyear,t1,t2,signat,$
                xpage,ypage,maryh,maryb,ox,rx,nbpan,nbcupan, dyc,dyp,$
                x1,x2,y1,y2,ydc,ydp,xtickval, xtickgra, nbxti, nbxmi,xtvt

;----------------------------------------------------------------------!
; Object: ouverture du fichier .ps, mise en page panels standards,
;         cadre, titre et signature,
;         pret pour recevoir les courbes a tracer, de preference via
;         la procedure plotcou pour le decalage automatique des courbes
;
;         Le nombre de pannels ets nbpan, et le nombre de courbes par 
;         pannel est definit par nbcupan.
;         Exemple: avec nbpan=2, nbcupan= [2,3] on a 2 pannels,
;         le premier avec 2 courbes et le second avec 3 courbes.
;
; Author: P. Robert, CETP, 2001 Avr
; rev. sep 2002 Oct 2015
;----------------------------------------------------------------------!

; ouverture du fichier .ps, avec cadre, titre et signature
; --------------------------------------------------------

 crepagnu, nomps,fultit,jul00,iday,imon,iyear,signat,xpage,ypage, $
           maryh,maryb,xtvt

; mise en page 
; -----------

; calcul de ry,dyc,dyp selon le nb de pannel nbpan et 
;                            le nb de courbes par pannel nbcupan(nbpan)
;    dyc: distance entre 2 courbes 
;    dyp: distance entre 2 pannels)

  misenpag, nbpan,nbcupan,ypage,maryh,maryb, ry,oy,dyc,dyp

; decalage normalise pour coube suivante, avec/sans changement de pannel

  ydc= (ry +dyc)/ypage
  ydp= (ry +dyp)/ypage

; normalisations

  x1=ox/xpage
  y1=oy/ypage
  x2=(ox+rx)/xpage
  y2=(oy+ry)/ypage


; calcul des graduation horaires (t1,t2 inchanges)
; ------------------------------------------------

  cogratim, t1, t2, xtickval, xtickgra, nbxti, nbxmi

  PRINT
  PRINT, 'calcul des graduations horaires'
  PRINT, 't1,t2=',t1,t2
  PRINT, 'nb grad=', nbxti
  PRINT, 'v. grad=', xtickval
  PRINT, '   grad=', xtickgra
  PRINT

  RETURN
  END

;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

  PRO crepagnu, nomps,fultit,jul00,iday,imon,iyear,signat,$
                xpage,ypage,maryh,maryb,xtvt

;----------------------------------------------------------------------!
; Object: ouverture du fichier .ps + cadre, titre et signature,
;         pret pour recevoir les objets a tracer
; Author: P. Robert, CETP, 2001 Jun/mod 2015 Oct
;----------------------------------------------------------------------!


  PRINT
  PRINT, 'Creation du fichier PostScript'
  PRINT, '------------------------------'
  PRINT
  PRINT, 'Nom: ',nomps
  PRINT
  PRINT, 'Mise en page:'
  PRINT, '        dimension X: ', xpage
  PRINT, '        dimension Y: ', ypage
  PRINT, '        Marge haute: ', maryh
  PRINT, '        Marge basse: ', maryb


; ouverture du fichier .ps et taille de police suivant version
; ------------------------------------------------------------

  softinfo, soft, arch,os,release

  fontsize= 18
  PRINT, 'fontsize=',fontsize

  SET_PLOT,'PS'
  DEVICE,Filename=nomps,/color,bits_per_pixel=4, $
         Xoffset=1.5,Yoffset=1.1, Xsize=xpage,Ysize=ypage, $
         User_Font='Helvetica', Font_Size=fontsize
 
; polices helvetica

  !P.FONT = 0

; definition de la mire de couleur
; --------------------------------

  defpalrgb8

  PRINT
  PRINT, 'nb. of colors=', !D.N_colors
  PRINT

; calcul des titres
; -----------------

; date sous la forme 2001/May/07


; exceptions pour titre particulier

  IF(jul00 EQ -9999) THEN BEGIN
                     titdat=' '+iyear
                     ENDIF ELSE BEGIN

  codatec, iday,imon,iyear, datec

  IF (jul00 LT 10000) then $
                      cjul= STRING(FORMAT='(i5)',jul00) $
                      else $
                      cjul= STRING(FORMAT='(i6)',jul00)

  titdat= ' ' +datec +'   (Jul. day ' +cjul +')'
  ENDELSE
  
  PRINT
  PRINT, titdat

; trace du cadre, des titres lus et des entetes en noir
; -----------------------------------------------------

  chas1= 0.87
  chas2= 0.77
  inoir=0
  ijaunp=6

  longtit= STRLEN(fultit)

  IF(longtit GT 32) THEN chas1=chas1*SQRT(32./FLOAT(longtit))

  cadre, fultit,chas1,titdat,chas2,xtvt,xpage,ypage,inoir,ijaunp,signat

  RETURN
  END
 
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

 PRO plotcou,xdat,ydat,t1,t2,ymi,yma,tit,xtit,ytit,x1,x2,y1,y2,yd, $
             xchasi, ychasi, xtickval, xtickgra, nbxti, nbxmi

;----------------------------------------------------------------------!
; Object: plot d'une courbe et de ses graduations.
;         L'abcisse est le temps sous la forme HH:MM:SS
;         Decale l'origine pour la suivante;
;         souvent utilise apres crepagps.
; Author: P. Robert, CETP, 2001 Jan
; revu Octobre 2002 ; revu LPP Aout 2011
;----------------------------------------------------------------------!


  PRINT, 'plotcou: ymin,ymax=',ymi,yma

; ajustement de la taille des traits
; taille des marques x agrandie si y2-y1 est petit

  absxtl= 0.06
  IF((y2-y1) LT 0.084) THEN absxtl=absxtl*0.084/(y2-y1)
 
  IF(xchasi GT 0.005) THEN xticklen= -absxtl ELSE xticklen= absxtl
  yticklen=  0.02

; plot de la courbe et de toutes ses caracteristiques d'axe

  IF(!D.name EQ 'X') THEN thick_t=1 ELSE thick_t=2

  PLOT,xdat,ydat, Position=[x1,y1,x2,y2],   $
       Xstyle   =1,                                $
       Xrange   =[t1,t2],     Yrange   =[ymi,yma], $
       Xtitle   =xtit,        Ytitle   ='  ',      $   
       Xticklen =xticklen,    Yticklen =yticklen,  $
       Xcharsize=abs(xchasi),  Ycharsize=ychasi,    $
       Xticks=nbxti, Xminor=nbxmi, Xtickname=xtickgra, Xtickv=xtickval,$
       Title=tit,$
       Charsize=0.5, $
       Thick=thick_t, $
       /YNOZERO, /Noerase, /normal, /NODATA

; plot du label Y separement, a distance fixe de l'axe

  XYOUTS, x1/8., (y2+y1)/2., ytit, Charsize= ychasi*0.55,  /Normal

; decalage des origines y pour la courbe suivante

  y1=y1-yd
  y2=y2-yd

  RETURN
  END
  
;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

  PRO softinfo, soft, arch,os,release

;----------------------------------------------------------------------!
; Object: permet de connaitre la version du logiciel
 ;        (WAVE ou IDL), et son numero de version
; Author: P. Robert, CETP, 2001 Fev
;----------------------------------------------------------------------!


  prompt= !prompt
  ipos= STRPOS(prompt,'>')
  soft= STRMID(prompt,0,ipos)

  info= !version

  nvar= N_tags(info)
  names= TAG_NAMES(info)

  arch   = info.arch
  os     = info.os
  release= info.release

  PRINT
  PRINT, 'used Software: ', soft, ' version ',release, $
         ' on ',arch, ' / ',os
  PRINT
  FOR I= 0,nvar-1 DO PRINT, names(i), ' : ',info.(i)
  PRINT

  RETURN
  END

;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

  PRO defpalrgb8

;----------------------------------------------------------------------!
; Object: definition d'une pallette RGB a 8 couleurs
;         utilisee pour les visualisations GEOS, CLUSTER, CUSP, CHARM etc. 
; Author: P. Robert, CETP, 1998 Dec
;----------------------------------------------------------------------!


; le jaune est eclairci pour servir de couleur de fond a un texte

;--------------------------------------------
;   0    1  2  3   4      5        6      7
; black, r, g, b, cyan, magenta, yellow, pink
;--------------------------------------------

  red= [0,  1, 0, 0,  0, 1, 1. , 1  ]

  gre= [0,  0, 1, 0,  1, 0, 1. , 0.8]

  blu= [0,  0, 0, 1,  1, 1, 0.6, 0.8]

  TVLCT, 255*red, 255*gre, 255*blu

  RETURN
  END

;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

  PRO codatec, iday,imon,iyear, datec

; ======================================================================
; codetec: 
;
; P. Robert, CETP, Fevrier 2001 - 
; ======================================================================

;----------------------------------------------------------------------!
; Object: converti la date en variable character 
; Author: P. Robert, CETP, 2001 Fev
; rev.  : LPP PRo Aout 2011
;----------------------------------------------------------------------!

  cmon= STRARR(12)
  cmon= ['January','February','March','April','May','June', 'July', $
         'August','September','October','November','December']
  cday= STRING(FORMAT='(i2.2)',iday)
  cyear= STRING(FORMAT='(i4)',iyear)
  datec= cyear +'-' +cmon(imon-1) +'-' +cday

  RETURN
  END

;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

  PRO cadre, tit1,chas1,tit2,chas2,xtvt,xpage,ypage,inoir,ijaune,signat

;----------------------------------------------------------------------!
; Object: trace du cadre de la page, avec bandau jaune d'entete, 
;         le titre, la signature et la date de production.
; Author: P. Robert, CETP, 2000 Avr
;----------------------------------------------------------------------!

; couleur courante en noir

  !P.COLOR= inoir

; dimension du cadre normalise

  xi = 0.0
  yi = 0.0
  xs = 1.0
; ys = 0.996  ; pour epaisseur du trait visible sur device X
  ys = 1.0
 
; 1) bandeau jaune avec l'entete CNRS - LPP
;    --------------------------------------

  hband= 0.7

  ysm=ys-hband/ypage
  PLOTS, [xi,xs], [ysm,ysm], thick=2, /normal
  POLYFILL, [xi,xi,xs,xs], [ysm,ys,ys,ysm], col=ijaune, /Normal

  tcetp='LABORATOIRE DE PHYSIQUE DES PLASMAS'
  tcnrs='CENTRE NATIONAL DE LA RECHERCHE SCIENTIFIQUE'

  xt =  0.3/xpage
  yt =  (ypage-hband*0.65)/ypage
  XYOUTS,xt,yt,tcetp,alignment=0.,charsize=0.40,/normal
  xt=   (xpage-0.3)/xpage
  XYOUTS,xt,yt,tcnrs,alignment=1.,charsize=0.40,/normal
 
; 2) cadre de la page en surimpression sur le bandeau
;    ------------------------------------------------

  IF(!D.name EQ 'X') THEN thick_t=2 ELSE thick_t=4

  PLOTS, [xi,xs], [yi,yi], thick=thick_t, /normal
  PLOTS, [xs,xs], [yi,ys], thick=thick_t, /normal
  PLOTS, [xi,xs], [ys,ys], thick=thick_t, /normal
  PLOTS, [xi,xi], [yi,ys], thick=thick_t, /normal

; 3) titres 
;    ------

; trait de separation du titre

  hcase= 1.1

  xtv= xtvt/xpage
  yth= (hband +hcase)/ypage
  yth2= hband/ypage

  PLOTS, [xi,xs],   [ys-yth, ys-yth],  thick=thick_t, /normal
  PLOTS, [xi,xs],   [ys-yth2,ys-yth2], thick=thick_t, /normal
  PLOTS, [xtv,xtv], [ys-yth, ys-yth2], thick=thick_t, /normal

; 1- Satellite, manip... (en gros a gauche)

  xt =  0.2/xpage
  yt = (ypage -hband -hcase +0.25*hcase)/ypage
  XYOUTS,xt,yt,tit1,alignment=0.,charsize=chas1,/normal

; 2- date et heure du debut (a droite)

  xt =  (xtvt +0.2)/xpage
  XYOUTS,xt,yt,tit2,alignment=0.,charsize=chas2,/normal


; 4) signature du bas
;    ----------------
 
  prodat = 'Production date :  ' + datim()
  yt = 0.15/ypage
  xt =  0.2/xpage
  XYOUTS,xt,yt,signat,alignment=0.,charsize=0.40,/normal
  xt =  (xpage-0.2)/xpage
  XYOUTS,xt,yt,prodat,alignment=1.,charsize=0.40,/normal

  RETURN
  END

;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

  PRO misenpag, nbpan,nbcupan,ypage,maryh,maryb, ry,oy,dyc,dyp

;----------------------------------------------------------------------!
; Object: mise en page d'un groupe de courbes dans une page
;         calcul de ry,dyc,dyp selon le nb de pannel nbpan et 
;                            le nb de courbes par pannel nbcupan(nbpan)
;         dyc: distance entre 2 courbes 
;         dyp: distance entre 2 pannels)
;
;    Si ces valeurs sont nulles a l'appel, elles sont calculees;
;    Sinon, elle sont prises en compte pour le calcul de ry et oy.
;
; Author: P. Robert, CETP, 2001 Jan
;----------------------------------------------------------------------!


  PRINT, '        Nb. pannel : ',  nbpan
  PRINT, '        Nb. courbes: ', nbcupan
  PRINT, '        d 2 courbes: ', dyc
  PRINT, '        d 2 pannels: ', dyp

; espace utile pour les courbes et les intervalles

  utily= ypage -maryh -maryb

; calcul des distances inter-courbes et inter-pannels

  IF(dyc EQ 0 OR dyp EQ 0) THEN BEGIN

          IF(nbpan EQ 1) THEN BEGIN
                         dyc= 0.3
                         dyp= 1.2
                         ENDIF

          IF(nbpan EQ 2) THEN BEGIN
                         dyc= 0.2
                         dyp= 1.0
                         ENDIF

          IF(nbpan GE 3) THEN BEGIN
                         dyc= 0.1
                         dyp= 0.8
                         ENDIF
  PRINT, 'valeurs recalculees:'
  PRINT, '        d 2 courbes: ', dyc
  PRINT, '        d 2 pannels: ', dyp

  ENDIF

; calcul du ry

  nbcutot= TOTAL(nbcupan)
  ry= (utily -(nbcutot-1)*dyc -(nbpan-1)*(dyp-dyc))/nbcutot

; premiere ordonnee, pour la premiere courbe du premier pannel

  oy= ypage -maryh -ry

  PRINT, '        Longueur Y :',ry
  PRINT, '        1ere ord Y :',oy

  RETURN
  END

;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

  PRO cogratim, t1, t2, xtickval, xtickgra, nbxti, nbxmi

;----------------------------------------------------------------------!
; Object: calcul des graduations de l'axe en HH:MM:SS
;         valable pour des periode de 2 mn a 24 heures.
;         t1,t2 sont en heures.
; Author: P. Robert, CETP, 2000 Oct
; revision Decembre 2000
; revision Octobre  2002 pour arondi des bornes.
;----------------------------------------------------------------------!

; on commence par arondir les bornes t1 et t2 a une minute ronde
; (inferieure et superieure) si la difference est inferieure a
; la tolerence (0.1cm/15cm)*(t2-t1)

; modif PRo 21 mai 2012
; dth= (t2-t1)*0.1/15.
; roundt1t2, t1,t2,dth
; endmodif

; on definit 10 echelles caracteristiques; t1,t2 en heures

  nbh  = long(t2-t1 +0.01) 
  nb10m= long((t2-t1)*6.    +0.01) 
  nb5m = long((t2-t1)*12.   +0.01) 
  nb2m = long((t2-t1)*30.   +0.01) 
  nb1m = long((t2-t1)*60.   +0.01) 
  nb30s= long((t2-t1)*120.  +0.01) 
  nb10s= long((t2-t1)*360.  +0.01) 
  nb5s = long((t2-t1)*720.  +0.01) 
  nb1s = long((t2-t1)*3600. +0.01) 
  nbds = long((t2-t1)*36000.+0.01) 

; test de duree minimum

  IF( (t2-t1)*36000 LT 2) THEN BEGIN
      PRINT,'***/ T1=',t1,' T2=',t2
      PRINT,'***/ T1-T2=',(t2-t1)*36000.,'< 0.2 S'
      MESSAGE, /NONAME, /NOPREFIX,'COGRATIM     : ***ERR-T2-T1 < 0.2 S'
                       ENDIF

; calcul du nombre de marques et des valeurs associees

  IF(nbds GT 1) THEN BEGIN
                nbxti= nbds +1
                xtickval= FINDGEN(nbxti+1)*1./36000. +long(t1*36000.+0.01)/36000.
                nbxmi=5
                ENDIF

  IF(nb1s GT 1) THEN BEGIN
                nbxti= nb1s +1
                xtickval= FINDGEN(nbxti+1)*1./3600. +long(t1*3600.+0.01)/3600.
                nbxmi=5
                ENDIF

  IF(nb5s GT 1) THEN BEGIN
                nbxti= nb5s +1
;               duree de 5 sec en heures: 5/3600 = 1/720
                xtickval= FINDGEN(nbxti+1)*1./720. +long(t1*720.+0.01)/720.
                nbxmi=5
                ENDIF

  IF(nb10s GT 1) THEN BEGIN
                nbxti= nb10s +1
                xtickval= FINDGEN(nbxti+1)*1./360. +long(t1*360.+0.01)/360.
                nbxmi=5
                ENDIF

  IF(nb30s GT 1) THEN BEGIN
                nbxti= nb30s +1
                xtickval= FINDGEN(nbxti+1)*1./120. +long(t1*120.+0.01)/120.
                nbxmi=3
                ENDIF

  IF(nb1m GT 1) THEN BEGIN
                nbxti= nb1m +1
                xtickval= FINDGEN(nbxti+1)*1./60. +long(t1*60.+0.01)/60.
                nbxmi=6
                ENDIF

  IF(nb2m GT 1) THEN BEGIN
                nbxti= nb2m +1
                xtickval= FINDGEN(nbxti+1)*1./30. +long(t1*30.+0.01)/30.
                nbxmi=4
                ENDIF

  IF(nb5m GT 1) THEN BEGIN
                nbxti= nb5m +1
                xtickval= FINDGEN(nbxti+1)*1./12. +long(t1*12.+0.01)/12.
                nbxmi=5
                ENDIF

  IF(nb10m GT 1) THEN BEGIN
                 nbxti= nb10m +1
                 xtickval= FINDGEN(nbxti+1)*1./6. +long(t1*6.+0.01)/6.
                 nbxmi=5
                 ENDIF

  IF(nbh GT 1) THEN BEGIN
               nbxti= nbh +1
               xtickval= FINDGEN(nbxti+1) + long(t1 +0.01)
               nbxmi=6
               ENDIF

; cas des grandes periodes superieures a 8 heures

  IF(nbh GT 8) THEN BEGIN
               nbxti= nbh/2 +1
               xtickval= FINDGEN(nbxti+1)*2. + long(t1/2. +0.01)*2.
               ENDIF

  IF(nbh GT 16) THEN BEGIN
                nbxti= nbh/3 +1
                xtickval= FINDGEN(nbxti+1)*3. + long(t1/3. +0.01)*3
                ENDIF

  IF(nbh GT 24) THEN BEGIN
                nbxti= nbh/6 +1
                xtickval= FINDGEN(nbxti+1)*6. + long(t1/6. +0.01)*6.
                ENDIF

  IF(nbh GT 48) THEN BEGIN
                nbxti= nbh/12 +1
                xtickval= FINDGEN(nbxti+1)*12. + long(t1/12. +0.01)*12.
                ENDIF

  IF(nbh GT 96) THEN BEGIN
                nbxti= nbh/24 +1
                xtickval= FINDGEN(nbxti+1)*24. + long(t1/24. +0.01)*24.
                ENDIF

; on enleve les marques de debut et de fin si elles sont hors periode

  IF(xtickval(nbxti) GT t2 ) THEN BEGIN
                             nbxti=nbxti-1
                             xtickval= xtickval(0:nbxti)
                             ENDIF

  IF(xtickval(0) LT t1 ) THEN BEGIN
                         nbxti=nbxti-1
                         xtickval= xtickval(1:nbxti+1)
                         ENDIF

; chargement du tableau des graduations

  xtickgra= STRARR(nbxti+1)

  FOR i= 0L, nbxti DO BEGIN

  hour= long( xtickval(i))
  min = long((xtickval(i) -hour)*60. +0.001)
  sec = long((xtickval(i) -hour)*3600 -min*60 +0.001)
  dsec= long((xtickval(i) -hour)*36000 -min*600 -sec*10 +0.001)

  xtickgra(i)=STRING(hour,min,sec,dsec, $
                                  FORMAT="(i2.2,':',i2.2,':',i2.2,'.',i1.1)") 

  IF(dsec EQ 0 ) THEN xtickgra(i)=STRING(hour,min,sec, $
                                  FORMAT="(i2.2,':',i2.2,':',i2.2)") 
  IF(dsec EQ 0 AND sec EQ 0) THEN xtickgra(i)=STRING(hour,min, $
                                  FORMAT="(i2.2,':',i2.2)") 
  IF(dsec EQ 0 AND sec EQ 0 AND min EQ 0 ) THEN xtickgra(i)=STRING(hour,  $
                                  FORMAT="(i3.2)")
  ENDFOR

  RETURN
  END

;XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

