      program co_mag_time 
!                                                                       
!     ***************************************************************0**
! *   Compute_Magnetic_Time ; use cmagtim module                        
!     P. Robert, Jan 2002                                               
!     ***************************************************************0**
!                                                                       
      print* 
      print 100, '****************************************************' 
      print* 
      print 100, 'Test of cmagtim:' 
      print* 
                                                                        
  100 format(a,3f12.5) 
!                                                                       
      call r_date(iyear,imonth,iday) 
      call r_time(ih,im,is) 
      call cp_time_param(iyear,imonth,iday,ih,im,is) 
!                                                                       
      print 100, 'lat et long en degre?' 
      read *, rlat,rlon 
      print 100, 'lat, long=', rlat, rlon 
!                                                                       
      psd= 3.1415927/180. 
      pis2= 3.1415927/2. 
      rlat=rlat*psd 
      rlon=rlon*psd 
      rtet=pis2-rlat 
!                                                                       
      call g_gei_geo_sun_dir(sxgei,sygei,szgei,sxgeo,sygeo,szgeo) 
      call g_gei_geo_dipole_dir(dxgei,dygei,dzgei,dxgeo,dygeo,dzgeo) 
!                                                                       
      call t_car_to_sph(dxgeo,dygeo,dzgeo,dr,dtet,dphi) 
      call t_sph_to_car(1.,rtet,rlon, pxgeo,pygeo,pzgeo) 
!                                                                       
      call t_geo_to_mag(pxgeo,pygeo,pzgeo,pxmag,pymag,pzmag) 
      call t_geo_to_mag(sxgeo,sygeo,szgeo,sxmag,symag,szmag) 
!                                                                       
      call t_car_to_sph(pxmag,pymag,pzmag,pr,ptet,pphi) 
      call t_car_to_sph(sxmag,symag,szmag,sr,stet,sphi) 
!                                                                       
      hmagp= (sphi -pphi)*12./3.1415927 +12. 
      if(hmagp.lt.0.) hmagp=hmagp+24. 
!                                                                       
      ihmag= int(hmagp) 
      immag= int(hmagp*60.) -ihmag*60 
      ismag= int(hmagp*3600.) -ihmag*3600 -immag*60 
!                                                                       
      print* 
      print 400, 'date: YY/MM/JJ=', iyear,imonth,iday 
      print 400, 'time: HH/MM/SS=', ih,im,is 
      print* 
      print 300, 'Dipole in GEO:',dxgeo,dygeo,dzgeo,dr,dtet/psd,dphi/psd 
      print 300, 'Point  in GEO:',pxgeo,pygeo,pzgeo,1.,rtet/psd,rlon/psd 
      print 300, 'Point  in MAG:',pxmag,pymag,pzmag,pr,ptet/psd,pphi/psd 
      print 300, 'Sun    in MAG:',sxmag,symag,szmag,sr,stet/psd,sphi/psd 
      print* 
      print 200, 'Mag. Local Time:',hmagp,' soit ',ihmag,immag,ismag 
      print* 
      print 100, '****************************************************' 
      print* 
!                                                                       
  200 format(a,f10.5,a,1x,i2.2,':',i2.2,':',i2.2) 
  300 format(a,4(f10.6),2f10.4) 
  400 format(a,3i5) 
                                                                        
      stop 'co_mag_time: normal termination' 
      END                                           
