      program rocot_utility 
                                                                        
!     ***************************************************************0**
! *   Rocot_Utility : tranform a file of time tagged vectors            
!                     given in sys1 to sys2                             
!     P. Robert, Jan 2008                                               
!     ***************************************************************0**
                                                                        
      character*255 file1,file2,line, header(6) 
      character*3 rep1,rep2 
      character*7 subname 
      character*3 allowed(7) 
                                                                        
      data allowed / 'geo','gei','gsq','gse','gsm','sma','mag'/ 
                                                                        
                                                                        
      print 100 
      print 100, '*****************************************************' 
      print 100 
      print 100, 'rocot_utility:' 
      print 100 
                                                                        
! *** lecture des parametres                                            
                                                                        
      print*, 'input  file ? (ex: CLUFGM1-gse.txt)' 
      read (*,'(a)') file1 
      call cchalen_(file1,nc) 
      print*, file1(1:nc) 
                                                                        
      rep1='XXX' 
                                                                        
! *** ouverture de fichier input                                        
                                                                        
      open(1,file=file1,status='old') 
                                                                        
! *** lecture du repere                                                 
                                                                        
      do 5 i=1,6 
      read(1,'(a)',end=7) header(i) 
      if(header(i)(1:28).ne.'# CHA : COORDINATE_SYSTEM : ') then 
                                        go to 5 
                                                            else 
                                        read(header(i),'(28x,a3)') rep1 
                                             irep=i 
      endif 
    5 continue 
                                                                        
! *** conversion eventuelle en minuscule                                
                                                                        
      do i=1,3 
      ic = ichar(rep1(i:i)) 
      if (ic .ge. 65 .and. ic .lt. 90) rep1(i:i) = char(ic+32) 
      enddo 
                                                                        
      print*, 'input  coordinate system :', rep1 
                                                                        
      call test(rep1,allowed) 
                                                                        
      print* 
      print*, 'output coordinate system ? (ex: gsm)' 
      read(*,'(a)') rep2 
      print*, rep2 
                                                                        
      print*, 'output file ? (ex: CLUFGM1-gsm.txt)' 
      read (*,'(a)') file2 
      call cchalen_(file2,nc) 
      print*, file2(1:nc) 
                                                                        
      call test(rep2,allowed) 
                                                                        
      open(2,file=file2) 
      header(irep)='# CHA : COORDINATE_SYSTEM : '//rep2 
      call cchalen_(line,nc) 
                                                                        
      do 6 i=1,6 
      call cchalen_(header(i),nc) 
      write(2,'(a)') header(i)(1:nc) 
    6 continue 
                                                                        
! *** lecture et traitement de chaque vecteur                           
                                                                        
   10 continue 
      read(1,'(a)', end=20) line 
      if (line(5:5).ne.'-' .or. line(8:8).ne.'-' .or. line(11:11).ne.'T'&
     &       .or. line(14:14).ne.':' .or. line(17:17).ne.':'            &
     &       .or. line(20:20).ne.'.' .or. line(24:24).ne.'Z') then      
         print*, 'date/time field=',line(1:24) 
         print*, '*** date/time field is not in ISO format' 
         print*, '    ex: 2003-08-17T16:33:07.000Z' 
         print*, '    program aborted !!!' 
      endif 
                                                                        
! **  lecture du vecteur et de son temps                                
                                                                        
      read(line,'(i4,5(1x,i2))') iyear,imonth,iday,ih,im,is 
      read(line(25:128),*) Ux,Uy,Uz 
                                                                        
! **  initialisation des matrices                                       
                                                                        
      call cp_time_param(iyear,imonth,iday,ih,im,is) 
                                                                        
! **  tranformation dans le repere souhaite                             
                                                                        
! *   transformations possibles: geo gei gsq gse gsm sma mag            
!     toutes les combinaisons sont:                                     
                                                                        
!     geogei geogsq geogse geogsm geosma geomag                         
!     geigeo gsqgeo gsegeo gsmgeo smageo maggeo                         
                                                                        
!     geigsq geigse geigsm geisma geimag                                
!     gsqgei gsegei gsmgei smagei maggei                                
                                                                        
!     gsqgse gsqgsm gsqsma gsqmag                                       
!     gsegsq gsmgsq smagsq maggsq                                       
                                                                        
!     gsegsm gsesma gsemag                                              
!     gsmgse smagse maggse                                              
                                                                        
!     gsmsma gsmmag                                                     
!     smagsm maggsm                                                     
                                                                        
!     smmag                                                             
!     magsma                                                            
                                                                        
      subname=rep1//rep2 
                                                                        
! * les if de la mort:...                                               
                                                                        
      if(subname.eq.'geogei') call t_geo_to_gei(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'geogsq') call t_geo_to_gseq(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'geogse') call t_geo_to_gse(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'geogsm') call t_geo_to_gsm(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'geosma') call t_geo_to_sm(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'geomag') call t_geo_to_mag(Ux,Uy,Uz,Vx,Vy,Vz) 
                                                                        
      if(subname.eq.'geigeo') call t_gei_to_geo(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'gsqgeo') call t_gseq_to_geo(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'gsegeo') call t_gse_to_geo(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'gsmgeo') call t_gsm_to_geo(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'smageo') call t_sm_to_geo(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'maggeo') call t_mag_to_geo(Ux,Uy,Uz,Vx,Vy,Vz) 
                                                                        
                                                                        
      if(subname.eq.'geigsq') call t_gei_to_gseq(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'geigse') call t_gei_to_gse(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'geigsm') call t_gei_to_gsm(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'geisma') call t_gei_to_sm(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'geimag') call t_gei_to_mag(Ux,Uy,Uz,Vx,Vy,Vz) 
                                                                        
      if(subname.eq.'gsqgei') call t_gseq_to_gei(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'gsegei') call t_gse_to_gei(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'gsmgei') call t_gsm_to_gei(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'smagei') call t_sm_to_gei(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'maggei') call t_mag_to_gei(Ux,Uy,Uz,Vx,Vy,Vz) 
                                                                        
                                                                        
      if(subname.eq.'gsqgse') call t_gseq_to_gse(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'gsqgsm') call t_gseq_to_gsm(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'gsqsma') call t_gsq_to_sm(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'gsqmag') call t_gsq_to_mag(Ux,Uy,Uz,Vx,Vy,Vz) 
                                                                        
      if(subname.eq.'gsegsq') call t_gse_to_gseq(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'gsmgsq') call t_gsm_to_gseq(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'smagsq') call t_sm_togsq(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'maggsq') call t_mag_to_gsq(Ux,Uy,Uz,Vx,Vy,Vz) 
                                                                        
                                                                        
      if(subname.eq.'gsegsm') call t_gse_to_gsm(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'gsesma') call t_gse_to_sm(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'gsemag') call t_gse_to_mag(Ux,Uy,Uz,Vx,Vy,Vz) 
                                                                        
      if(subname.eq.'gsmgse') call t_gsm_to_gse(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'smagse') call t_sm_to_gse(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'maggse') call t_mg_to_gse(Ux,Uy,Uz,Vx,Vy,Vz) 
                                                                        
                                                                        
      if(subname.eq.'gsmsma') call t_gsm_to_sm(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'gsmmag') call t_gsm_to_mag(Ux,Uy,Uz,Vx,Vy,Vz) 
                                                                        
      if(subname.eq.'smagsm') call t_sm_to_gsm(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'maggsm') call t_mag_to_gsm(Ux,Uy,Uz,Vx,Vy,Vz) 
                                                                        
                                                                        
      if(subname.eq.'smamag') call t_sm_to_mag(Ux,Uy,Uz,Vx,Vy,Vz) 
      if(subname.eq.'magsma') call t_mag_to_sm(Ux,Uy,Uz,Vx,Vy,Vz) 
                                                                        
! **  ecriture des resultats                                            
                                                                        
      write(2,'(a,3(1Pe15.5))') line(1:24), Vx,Vy,Vz 
                                                                        
! **  rebelote...                                                       
      go to 10 
                                                                        
   20 continue 
                                                                        
      close(1) 
      close(2) 
                                                                        
                                                                        
      print 100 
      print 100, '*****************************************************' 
      print 100 
!                                                                       
  100 format(a,3i6) 
                                                                        
      stop 'rocot_utility.exe: normal termination' 
                                                                        
    7 continue 
                                                                        
      write(*,*) '*** bad metadata' 
      write(*,*) '"# CHA : COORDINATE_SYSTEM :" not found' 
      close(1) 
                                                                        
      stop 'rocot_utility.exe: bad metadata, aborted' 
                                                                        
      END                                           
!                                                                       
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!                                                                       
      subroutine test(rep,allowed) 
                                                                        
      character*3 rep,allowed(7) 
                                                                        
      do i=1,7 
      if(rep.eq.allowed(i)) return 
      end do 
                                                                        
      print*, '*** ',rep,' is not allowed' 
      print 100, 'allowed coordinates are ', allowed 
      stop '   program aborted' 
                                                                        
  100 format(a,/,7a5) 
                                                                        
      END                                           
!                                                                       
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!                                                                       
      subroutine t_sm_to_gse(x1,y1,z1,x2,y2,z2) 
                                                                        
      call t_sm_to_gsm(x1,y1,z1,x3,y3,z3) 
      call t_gsm_to_gse(x3,y3,z3,x2,y2,z2) 
                                                                        
      return 
      END                                           
!                                                                       
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!                                                                       
      subroutine t_gse_to_sm(x1,y1,z1,x2,y2,z2) 
                                                                        
      call t_gse_to_gsm(x1,y1,z1,x3,y3,z3) 
      call t_gsm_to_sm(x3,y3,z3,x2,y2,z2) 
                                                                        
      return 
      END                                           
!                                                                       
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!                                                                       
      subroutine t_mg_to_gse(x1,y1,z1,x2,y2,z2) 
                                                                        
      call t_mag_to_sm(x1,y1,z1,x3,y3,z3) 
      call t_sm_to_gse(x3,y3,z3,x2,y2,z2) 
                                                                        
      return 
      END                                           
!                                                                       
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!                                                                       
      subroutine t_gse_to_mag(x1,y1,z1,x2,y2,z2) 
                                                                        
      call t_gse_to_sm(x1,y1,z1,x3,y3,z3) 
      call t_sm_to_mag(x3,y3,z3,x2,y2,z2) 
                                                                        
      return 
      END                                           
!                                                                       
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!                                                                       
      subroutine t_sm_togsq(x1,y1,z1,x2,y2,z2) 
                                                                        
      call t_sm_to_gsm(x1,y1,z1,x3,y3,z3) 
      call t_gsm_to_gseq(x3,y3,z3,x2,y2,z2) 
                                                                        
      return 
      END                                           
!                                                                       
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!                                                                       
      subroutine t_gsq_to_sm(x1,y1,z1,x2,y2,z2) 
                                                                        
      call t_gseq_to_gsm(x1,y1,z1,x3,y3,z3) 
      call t_gsm_to_sm(x3,y3,z3,x2,y2,z2) 
                                                                        
      return 
      END                                           
!                                                                       
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!                                                                       
      subroutine t_mag_to_gsq(x1,y1,z1,x2,y2,z2) 
                                                                        
      call t_mag_to_sm(x1,y1,z1,x3,y3,z3) 
      call t_sm_togsq(x3,y3,z3,x2,y2,z2) 
                                                                        
      return 
      END                                           
!                                                                       
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!                                                                       
      subroutine t_gsq_to_mag(x1,y1,z1,x2,y2,z2) 
                                                                        
      call t_gsq_to_sm(x1,y1,z1,x3,y3,z3) 
      call t_sm_to_mag(x3,y3,z3,x2,y2,z2) 
                                                                        
      return 
      END                                           
!                                                                       
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
!                                                                       
      subroutine cchalen_(chast,nbcha) 
!                                                                       
!     ---------------------------------------------------------------+--
! *   Object : compute_character_length without end blanks              
! *   Class  : compute modules of Rogralib Software                     
! *   Author : P. Robert, PatCie, 1992                                  
!     ---------------------------------------------------------------+--
!                                                                       
      character*(*) chast 
!                                                                       
!     calcule la longueur utile d'une chaine de caracteres              
!     les blancs de fin sont ignores                                    
!                                                                       
!                                                                       
      nbc=len(chast) 
      if(nbc.gt.255) then 
                     print*, '***nbc=',nbc, ' > 255' 
                     print*, '   program aborted' 
                     stop '*** program aborted' 
                     endif 
!                                                                       
!                                                                       
      do 10 i=1,nbc 
      ii=nbc-i+1 
      if(chast(ii:ii).ne.' ') go to 12 
   10 continue 
      ii=0 
   12 continue 
!                                                                       
      nbcha=ii 
!                                                                       
      return 
      END                                           
