      program test_dir_sun 
!                                                                       
!     ***************************************************************0**
! *   Test_Dir_Sun: Sun direction in various coordinate systems         
!     P. Robert, CETP, June 2001 ; use Rocotlib library                 
!     ***************************************************************0**
!                                                                       
!                                                                       
      print* 
      print 200, '*****************************************************' 
      print* 
      print 200, 'Sun direction in various coordinate systems' 
      print* 
!                                                                       
! *   reading date and time & compute general matrix                    
!                                                                       
      call r_date(iyear,imonth,iday) 
      call r_time(ih,im,is) 
      call cp_time_param(iyear,imonth,iday,ih,im,is) 
!                                                                       
! *   reading position of point of observation in GEO                   
!                                                                       
      print 200, 'latitude, longitude, distance in GEO ? (deg & any u.)' 
      read *, rlageo, rlogeo,rdis 
      print 200, ' ',rlageo, rlogeo,rdis 
!                                                                       
      rlagr=rlageo*3.1415927/180. 
      rlogr=rlogeo*3.1415927/180. 
      teta=(90.-rlageo)*3.1415927/180. 
!                                                                       
! *   geographic cartesian coordinates                                  
!                                                                       
      call t_sph_to_car(rdis,teta,rlogr,xgeo,ygeo,zgeo) 
!                                                                       
! *   same in other systems                                             
!                                                                       
      call t_geo_to_gei(xgeo,ygeo,zgeo,xgei,ygei,zgei) 
      call t_geo_to_gse(xgeo,ygeo,zgeo,xgse,ygse,zgse) 
      call t_geo_to_gsm(xgeo,ygeo,zgeo,xgsm,ygsm,zgsm) 
      call t_geo_to_vdh(xgeo,ygeo,zgeo,rlagr,rlogr,xvdh,yvdh,zvdh) 
!                                                                       
! *   latitude, longitude in other systems                              
!                                                                       
      call t_car_to_sph(xgeo,ygeo,zgeo,r,tetgeo,phigeo) 
      call t_car_to_sph(xgei,ygei,zgei,r,tetgei,phigei) 
      call t_car_to_sph(xgse,ygse,zgse,r,tetgse,phigse) 
      call t_car_to_sph(xgsm,ygsm,zgsm,r,tetgsm,phigsm) 
      call t_car_to_sph(xvdh,yvdh,zvdh,r,tetvdh,phivdh) 
!                                                                       
      call colalon(tetgeo,phigeo,rlageo,rlogeo) 
      call colalon(tetgei,phigei,rlagei,rlogei) 
      call colalon(tetgse,phigse,rlagse,rlogse) 
      call colalon(tetgsm,phigsm,rlagsm,rlogsm) 
      call colalon(tetvdh,phivdh,rlavdh,rlovdh) 
!                                                                       
      print*,'_________________________________________________________' 
      print* 
      print 300, 'date: YY/MM/JJ=', iyear,imonth,iday 
      print 300, 'time: HH/MM/SS=', ih,im,is 
      print* 
!                                                                       
      print 100, '            ','x','y','z','R','Lat','Long' 
      print 100 
!                                                                       
      print 200, 'Pos. in GEO :',xgeo,ygeo,zgeo, r,rlageo,rlogeo 
      print 200, 'Pos. in GEI :',xgei,ygei,zgei, r,rlagei,rlogei 
      print 200, 'Pos. in GSE :',xgse,ygse,zgse, r,rlagse,rlogse 
      print 200, 'Pos. in GSM :',xgsm,ygsm,zgsm, r,rlagsm,rlogsm 
      print 200, 'Pos. in VDH :',xvdh,yvdh,zvdh, r,rlavdh,rlovdh 
!                                                                       
! *   Sun direction                                                     
!                                                                       
      call g_gei_geo_sun_dir(sxgei,sygei,szgei,sxgeo,sygeo,szgeo) 
      call t_gei_to_gse(sxgei,sygei,szgei,sxgse,sygse,szgse) 
      call t_gei_to_gsm(sxgei,sygei,szgei,sxgsm,sygsm,szgsm) 
      call t_geo_to_vdh(sxgeo,sygeo,szgeo,rlagr,rlogr,sxvdh,syvdh,szvdh) 
!                                                                       
      call t_car_to_sph(sxgeo,sygeo,szgeo,rgeo,tetgeo,phigeo) 
      call t_car_to_sph(sxgei,sygei,szgei,rgei,tetgei,phigei) 
      call t_car_to_sph(sxgse,sygse,szgse,rgse,tetgse,phigse) 
      call t_car_to_sph(sxgsm,sygsm,szgsm,rgsm,tetgsm,phigsm) 
      call t_car_to_sph(sxvdh,syvdh,szvdh,rvdh,tetvdh,phivdh) 
!                                                                       
      call convdeg(tetgeo,phigeo) 
      call convdeg(tetgei,phigei) 
      call convdeg(tetgse,phigse) 
      call convdeg(tetgsm,phigsm) 
      call convdeg(tetvdh,phivdh) 
!                                                                       
      print* 
      print 200, 'Sun  in GEO :',sxgeo,sygeo,szgeo,  rgeo,tetgeo,phigeo 
      print 200, 'Sun  in GEI :',sxgei,sygei,szgei,  rgei,tetgei,phigei 
      print 200, 'Sun  in GSE :',sxgse,sygse,szgse,  rgse,tetgse,phigse 
      print 200, 'Sun  in GSM :',sxgsm,sygsm,szgsm,  rgsm,tetgsm,phigsm 
      print 200, 'Sun  in VDH :',sxvdh,syvdh,szvdh,  rvdh,tetvdh,phivdh 
      print* 
      print* 
      print*, '********************************************************' 
      print* 
!                                                                       
  100 format(a,4a10  ,2a10  ) 
  200 format(a,4f10.3,2f10.3) 
  300 format(a,3I5) 
                                                                        
      stop 'test_dir_sun.exe: normal termination' 
      END                                           
!                                                                       
!     ---------------------------------------------------------------0--
!                                                                       
      subroutine convdeg(x,y) 
!                                                                       
      pisd=3.1415927/180. 
!                                                                       
      x=x/pisd 
      y=y/pisd 
!                                                                       
      return 
      END                                           
!                                                                       
!     ---------------------------------------------------------------0--
!                                                                       
      subroutine colalon(teta,phi,rlat,rlon) 
!                                                                       
! *   compute lat and long in degres from teta, phi in radians          
!                                                                       
      pisd=3.1415927/180. 
!                                                                       
      rlat= 90. -teta/pisd 
      rlon= phi/pisd 
!                                                                       
      return 
      END                                           
