
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      program coplot_magsphe
 
      real(kind=4), dimension(10) :: parmod

      character*6 ex
      character*3 rep
      character*5 sunpo
      character*2 stipox,stipoy,ckp
      character*64 info(36) 

      character(len=1) :: cocli,cooli,codip,corot,coarr

      real (kind=4), dimension(3,2000,20) :: linjou,linnui,linnor,linsud
      integer,       dimension(20)        :: npljou,nplnui,nplnor,nplsud

      real (kind=4), dimension(3,3600) :: magpau,bowsho ! 3600=3*1200

      integer, dimension(180,360) :: icowor
      integer, dimension(101,101) :: imawor

      common /sunsid/ isun
      common /dimlin/ Nlimax,Nptmax

      data Nlimax, Nptmax /20,1000/ ! 1000*2=2000 points (// et \//)
      data idiwor /101/
      data info /                                                      &
      ' ',                                                             &
      '--------------------------------------------------------------',&
      ' Trace d''une magnetosphere 2D dans le plan meridien',          &
      ' d''apres le modele de Tsyganenko.',                            &
      ' Le soleil est a gauche ou a droite.',                          &
      ' On rajoute la terre (bien orientee) et le bow shock,',         &
      ' le repere peut etre gse ou gsm.',                              &
      ' Les couleurs de remplissage sont choisies pour mettre en ',    &
      ' valeurles zones d''interet',                                   &
      ' ',                                                             &
      ' Calcul selon des ecrements suivant l axe X le long de SM',     &
      ' pour les lignes fermees',                                      &
      ' (et donc le long d''un axe X perpendiculaire au dipole Z et',  &
      ' avec la direction du soleil dans le plan XZ)',                 &
      ' et le long d''un axe // a Z GSM pour les lignes ouvertes',     &
      ' (et donc perpendiculaire a la direction du soleil)',           &
      ' ',                                                             &
      ' Rappel: SM et GSM ont Y en commun.',                           &
      ' Le depart des lignes de force est dans le plan XZ.',           &
      ' Utilise  les bibliotheques suivantes:',                        &
      '          comagnetolib.f',                                      &
      '          maglinelib.f',                                        &
      '          geopacklib.f90',                                      &
      '          tsygalib.f90',                                        &
      '          tsauxlib.f90',                                        &
      '          rocotlib.f90',                                        &
      '          rogralib_V9p6.f',                                     &
      '          worldlib.f',                                          &
      ' ',                                                             &
      ' P. Robert, CETP, 1996',                                        &
      '    revu Decembre 2001',                                        &
      '    revu Janvier  2010 migration SUN -> linux & PC compatible ',&
      '    revu Juin     2010 pour compatibilite avec les Roprocs',    &
      '                       et les differents modeles de Tsyganenko',&
      ' ',                                                             &
      '--------------------------------------------------------------' /
     
! *** parametres de la figure
 
      data ofx,ofy / 1.1, 1.8/
      data sfx,sfy /26. ,16. /
 
!      data x1,x2   /-40., 25./
!      data y1,y2   /-20., 20./
 
! *   option grande echelle (attention garder le rapport 65/40)
 
      data x1,x2   /-80., 50./
      data y1,y2   /-40., 40./
 
      data oarx,oary / 18., 10. /
      data tc        /  0.30    /
 
      data stipox,stipoy /'oi','oi'/
      data stisil,stisis /0.30,0.15/
      data grasix,grasiy /0.40,0.40/
!                          _____________________
                          
      
      print '(a)', info
 
      print*
      print*, 'lecture des donnees pour le programme co_magneto'
      print*, '************************************************'
 
      call re_co_magneto(iyear,imon,iday,ih,im,is,ex,ikpl, &
                         parmod,rep,sunpo)
 
      print*
      print*, 'calcul du ikp pour la date et l''heure consideree'
      print*, '*************************************************'
 
      call cokp(1,iyear,imon,iday,ih,rkp)
      call convkptsy(ex,rkp,ikp)
      call convrkp(rkp,ckp)
 
! *   si pas de Kp dans la base, on prend la valeur lue
 
      if(ikp.lt.0) then
                   print*, 'base des kp innaccessible'
                   ikp=ikpl
                   print*, 'kp pris=kp lu =',ikp
                   else
                   print*, 'rkp,ckp,ikp=',rkp,ckp,ikp
                   endif

      print*
      print*, 'calcul et trace de la magnetosphere complete'
      print*, '********************************************'
 
      call co_magneto(iyear,imon,iday,ih,im,is,ex,ikp,parmod,rep, &
                    linjou,linnui,linnor,linsud, &
                    nlijou,nlinui,nlinor,nlisud, &
                    npljou,nplnui,nplnor,nplsud, &
                    magpau,npau,bowsho,nbow,     &
                    dxrep,dyrep,dzrep, rxrep,ryrep,rzrep)

      print*
      print*, 'lecture du fichier monde et calcul de l''image projetee'
      print*, '******************************************************'

      call rewormap(1,icowor,3)
      call coworpic(icowor,imawor,idiwor,rep,sunpo)

      print*
      print*, 'lecture des donnees pour le programme plot_magneto'
      print*, '**************************************************'

      call re_plot_magneto(ifill,isolwi, &
                           irvs1,irvs2,icbs1,icbs2,irbs1,irbs2, &
                           icmp1,icmp2,irmp1,irmp2,ircl1,ircl2, &
                           irps1,irps2,cocli,cooli,codip,corot,coarr)
 
      print*
      print*, 'ouverture du fichier graphique/initialisations/header'
      print*, '*****************************************************'
 
      call dopegra_(2,'coplot_magsphe.ps')
      call dpagfor_('l')
 
      call dfontyp_('h')
      call ppaghea_('P. Robert, LPP / CNRS  - ')
 
      print*
      print*, 'plot de la magnetosphere '
      print*, '*************************'

      call plot_magneto(linjou,linnui,linnor,linsud, &
                        nlijou,nlinui,nlinor,nlisud, &
                        npljou,nplnui,nplnor,nplsud, &
                        magpau,npau,bowsho,nbow,     &
                        imawor,idiwor,               &
                        dxrep,dyrep,dzrep, rxrep,ryrep,rzrep,  &
                        ofx,ofy,sfx,sfy,x1,x2,y1,y2,oarx,oary, &
                        stipox,stipoy,stisil,stisis,grasix,grasiy,&
                        ifill,isolwi, &
                        irvs1,irvs2,icbs1,icbs2,irbs1,irbs2, &
                        icmp1,icmp2,irmp1,irmp2,ircl1,ircl2, &
                        irps1,irps2,cocli,cooli,codip,corot,coarr)
 
      print*
      print*, 'ajou d''une legende au dessus de la figure'
      print*, '******************************************'
 
      x=ofx
      y=ofy+sfy+0.3

      call plot_legende(iyear,imon,iday,ih,im,is,ex,rep,ikp,ckp,x,y,tc)

      print*
      print*, 'fermeture du fichier graphique'
      print*, '******************************'
      print*
      
      call dclogra_
      
      print*
      print*, '*************************************'
      print*, 'coplot_magsphe : normal termination ;'
      print*, 'see file coplot_magsphe.ps'
      print*, '*************************************'
 
      stop 'coplot_magsphe: NORMAL TERMINATION'
      end
 
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

      subroutine plot_legende(iyear,imon,iday,ih,im,is,ex,rep,ikp,ckp, &
                              x,y,tc)

!     ajou d''une legende au dessus de la figure

      character*(*) ex,rep,ckp
      character*6 mod
      character*4 sys
      character*9 cmonth,ctime
      character*84 com

      call cmoncar_(imon,cmonth)
      call ctimcha_(ih,im,is,ctime)
      call cchalen_(cmonth,nm)
 
      mod=ex
      call upper_case(mod,1)
      call strlen(mod,nc)
      sys=rep
      call upper_case(sys,3)

      print*, 'date/time=',iyear,cmonth(1:nm),iday,ctime(1:5)
 
     if(ckp.ne.'??') then
                     write(com,200) iyear,cmonth(1:nm),iday,ctime(1:5),&
                                    mod(1:nc), ikp,' : Kp=',ckp,', ',sys
                     else
                     write(com,200) iyear,cmonth(1:nm),iday,ctime(1:5),&
                                    mod(1:nc), ikp,', ',sys
                     endif

  200 format(i4,1x,a,i3,', ',a,' From Tsyganenko model ',a,', ikp=',i1,&
             4a,' system')

      call cchalen_(com,nc)
 
      print*, com(1:nc)
 
      call ppagcha_(x,y,-1,tc,tc,0.,com)

      return
      end
 
!     XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

