; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
;+
; PROCEDURE:
; cangrat.pro : IDL procedure
;         
; PURPOSE:
;        compute_angle_and_ratio beetween U and V vectors
;
; INPUT: 
;        ux,uy,uz
;        vx,vy,vz
;
; OUTPUT: 
;        sp=U.V
;        angle=angle beetween U and V (radians)
;        ratio= mod(U)/mod(V)
;
;$CreatedBy: P. Robert, CRPE, 1992; IDL version nov. 2015 $
;$LastChangedDate: 2015-12-07
; ----------------------------------------------------------------------

  PRO cangrat, ux,uy,uz,vx,vy,vz,angle,ratio


  u1 = DOUBLE(ux)
  u2 = DOUBLE(uy)
  u3 = DOUBLE(uz)

  v1 = DOUBLE(vx)
  v2 = DOUBLE(vy)
  v3 = DOUBLE(vz)

  ru = SQRT(u1*u1 + u2*u2 + u3*u3)
  rv = SQRT(v1*v1 + v2*v2 + v3*v3)
  
  IF(ru EQ 0. OR rv EQ 0.) THEN BEGIN
     PRINT, ' *** cangrat: U or V vector is = 0.'
     RETURN
  ENDIF

  dp= u1*v1 + u2*v2 + u3*v3

  cot = dp/(ru*rv) 
  cot = cot -(cot/ABS(cot))*1.d-13
  ratio = FLOAT(ru/rv)

  if(cot ge 1.d0)  THEN BEGIN
     PRINT, ' *** cangrat: cos greater than 1 !!!'
     PRINT, '                       angle set to 0.'
     angle = 0.
     RETURN
  ENDIF

  if(cot lt -1.d0) THEN BEGIN
     PRINT, ' *** cangrat: cos less than 1 !!!'
     PRINT, '                       angle set to 0.'
     angle = 0.
     RETURN
  ENDIF

  angle = FLOAT(ACOS(cot))

  RETURN
  END

; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX

