; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX
;+
; PROCEDURE:
; cointdist.pro : IDL procedure
;         
; PURPOSE:
;      compute the 6 inter-distances of the tetrahedron
;      can be used for 4 S/C missions, as CLUSTER or MMS.
;
; INPUT: 
;        Valpos: position at each vertice of the tetrahedron (km)
;                DBLE [N_time, 3 (xyz), 4 (S/C) ]
;
; OUTPUT:
;        d_12, d_13, d_14, d_23, d_24, d_34 : distance between 2 vertex
;
; This procedure requires the compilation of barycentric_lib.pro 
; which contains the cdistance.pro procedure.
;
;$CreatedBy: P. Robert, CRPE, 1994 in F77 $
;$LastChangedDate: 2015-11-25  (IDL transcription P.R., LPP) $
;
; -------------------------------------------------------------------------------

  PRO cointdist, valpos, d_12, d_13, d_14, d_23, d_24, d_34

  common distan,  d12 ,  d13 ,  d14 ,  d23 ,  d24,  d34, $
                 dx12 , dx13 , dx14 , dx21 , dx31, dx41, $
                 dy12 , dy13 , dy14 , dy21 , dy31, dy41, $
                 dz12 , dz13 , dz14 , dz21 , dz31, dz41
   
  PRINT
  PRINT, 'cointdist.pro / input  parameters:'
  HELP, valpos
  
  nbp = n_elements(valpos(*,0,0))
  
; output arrays
; -------------
  
  d_12 = FLTARR(nbp)
  d_13 = FLTARR(nbp)
  d_14 = FLTARR(nbp)
  d_23 = FLTARR(nbp)
  d_24 = FLTARR(nbp)
  d_34 = FLTARR(nbp)
  
; working array
  satpos = DBLARR(3,4)
                     
  ;  BIG LOOP ON THE TIME 

; ======================== 
  FOR k = 0,nbp-1 DO BEGIN
; ========================  
  
;     compute satpos at each time
;     ---------------------------

      satpos(*,0) = valpos(k,*,0)
      satpos(*,1) = valpos(k,*,1)
      satpos(*,2) = valpos(k,*,2)
      satpos(*,3) = valpos(k,*,3)
      
;     compute the 6 inter-distances 
;     -----------------------------     
      
      cdistance, satpos  
 
      d_12(k) = d12
      d_13(k) = d13
      d_14(k) = d14
      d_23(k) = d23
      d_24(k) = d24
      d_34(k) = d34
  
; END OF BIG LOOP ON THE TIME 

; ====== 
  ENDFOR
; ======   

  PRINT, 'cointdist.pro / Done...'
  PRINT
  PRINT, 'cointdist.pro / output parameters:'
  HELP,  d_12 ,  d_13 ,  d_14 ,  d_23 ,  d_24,  d_34

  RETURN
  END

; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX0XX      
